/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtensionDebuggerBridge;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "<init>", "()V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleTaskManagerExtensionDebuggerBridge
implements GradleTaskManagerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEBUGGER_SCRIPT_PREFIX = "ijDebugger-";
    @NotNull
    public static final String DEBUGGER_ENABLED = "DEBUGGER_ENABLED";

    @Override
    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        String string;
        String dispatchPort;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Project project = id.findProject();
        List toolingInitScripts = CollectionsKt.listOf((Object)GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(GradleInitScriptUtil.GRADLE_TOOLING_EXTENSION_CLASSES));
        Integer n = (Integer)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
        String string2 = dispatchPort = n != null ? n.toString() : null;
        if (dispatchPort != null) {
            settings.addEnvironmentVariable(DEBUGGER_ENABLED, "true");
        }
        if ((string = (String)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_PARAMETERS_KEY)) == null) {
            string = "";
        }
        String debugOptions = string;
        DebuggerBackendExtension.EP_NAME.forEachExtensionSafe(arg_0 -> GradleTaskManagerExtensionDebuggerBridge.configureTasks$lambda$1(arg_0 -> GradleTaskManagerExtensionDebuggerBridge.configureTasks$lambda$0(dispatchPort, project, debugOptions, toolingInitScripts, settings, arg_0), arg_0));
        DebuggerBackendExtension.EP_NAME.forEachExtensionSafe(arg_0 -> GradleTaskManagerExtensionDebuggerBridge.configureTasks$lambda$3(arg_0 -> GradleTaskManagerExtensionDebuggerBridge.configureTasks$lambda$2(settings, project, dispatchPort, debugOptions, arg_0), arg_0));
    }

    private static final Unit configureTasks$lambda$0(String $dispatchPort, Project $project, String $debugOptions, List $toolingInitScripts, GradleExecutionSettings $settings, DebuggerBackendExtension extension) {
        List initScripts;
        if ((extension.isAlwaysAttached() || $dispatchPort != null) && !(initScripts = extension.initializationCode($project, $dispatchPort, $debugOptions)).isEmpty()) {
            Collection collection = $toolingInitScripts;
            Intrinsics.checkNotNull((Object)initScripts);
            String initScript = GradleInitScriptUtil.joinInitScripts(CollectionsKt.plus((Collection)collection, (Iterable)initScripts));
            String extensionClassName = extension.getClass().getName();
            $settings.addInitScript(DEBUGGER_SCRIPT_PREFIX + extensionClassName, initScript);
        }
        return Unit.INSTANCE;
    }

    private static final void configureTasks$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureTasks$lambda$2(GradleExecutionSettings $settings, Project $project, String $dispatchPort, String $debugOptions, DebuggerBackendExtension extension) {
        if (extension.isAlwaysAttached()) {
            $settings.withEnvironmentVariables(extension.executionEnvironmentVariables($project, $dispatchPort, $debugOptions));
        }
        return Unit.INSTANCE;
    }

    private static final void configureTasks$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtensionDebuggerBridge$Companion;", "", "<init>", "()V", "DEBUGGER_SCRIPT_PREFIX", "", "DEBUGGER_ENABLED", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

