/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import icons.ExternalSystemIcons;
import icons.OpenapiIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.navigator.SelectMavenGoalDialog;
import org.jetbrains.idea.maven.navigator.structure.GoalNode;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenPluginWithArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public final class MavenKeymapExtension
implements ExternalSystemKeymapExtension.ActionsProvider {
    public KeymapGroup createGroup(Condition<? super AnAction> condition, final Project project) {
        KeymapGroup result2 = KeymapGroupFactory.getInstance().createGroup(TasksBundle.message("maven.tasks.action.group.name", new Object[0]), OpenapiIcons.RepositoryLibraryLogo);
        if (project == null) {
            return result2;
        }
        Comparator projectComparator = (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        TreeMap<MavenProject, TreeSet<Pair>> projectToActionsMapping = new TreeMap<MavenProject, TreeSet<Pair>>(projectComparator);
        ActionManager actionManager = ActionManager.getInstance();
        for (String string : MavenKeymapExtension.getActionIdList(project, null)) {
            AnAction eachAction = actionManager.getAction(string);
            if (!(eachAction instanceof MavenGoalAction)) continue;
            MavenGoalAction mavenAction = (MavenGoalAction)eachAction;
            if (condition != null && !condition.value((Object)actionManager.getActionOrStub(string))) continue;
            MavenProject mavenProject = mavenAction.getMavenProject();
            TreeSet<Pair> actions = (TreeSet<Pair>)projectToActionsMapping.get(mavenProject);
            if (actions == null) {
                List<String> projectGoals = MavenKeymapExtension.collectGoals(mavenProject);
                actions = new TreeSet<Pair>((o1, o2) -> {
                    int index2;
                    String goal1 = (String)o1.getFirst();
                    String goal2 = (String)o2.getFirst();
                    int index1 = projectGoals.indexOf(goal1);
                    if (index1 == (index2 = projectGoals.indexOf(goal2))) {
                        return goal1.compareToIgnoreCase(goal2);
                    }
                    return index1 < index2 ? -1 : 1;
                });
                projectToActionsMapping.put(mavenProject, actions);
            }
            actions.add(Pair.create((Object)mavenAction.getGoal(), (Object)string));
        }
        for (Map.Entry entry : projectToActionsMapping.entrySet()) {
            Set goalsToActionIds = (Set)entry.getValue();
            for (Pair eachGoalToActionId : goalsToActionIds) {
                result2.addActionId((String)eachGoalToActionId.getSecond());
            }
        }
        Icon icon = AllIcons.General.Add;
        ((Group)result2).addHyperlink(new Hyperlink(icon, MavenConfigurableBundle.message("link.label.choose.phase.goal.to.assign.shortcut", new Object[0])){

            public void onClick(MouseEvent e) {
                SelectMavenGoalDialog dialog = new SelectMavenGoalDialog(project);
                if (dialog.showAndGet() && dialog.getResult() != null) {
                    KeymapPanel keymapPanel;
                    GoalNode goalNode = dialog.getResult();
                    String goal = goalNode.getGoal();
                    String actionId = MavenShortcutsManager.getInstance(project).getActionId(goalNode.getProjectPath(), goal);
                    MavenKeymapExtension.getOrRegisterAction(goalNode.getMavenProject(), actionId, goal);
                    ((KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC)).processCurrentKeymapChanged();
                    Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext(e.getComponent()));
                    KeymapPanel keymapPanel2 = keymapPanel = allSettings != null ? (KeymapPanel)allSettings.find(KeymapPanel.class) : null;
                    if (keymapPanel != null) {
                        keymapPanel.showOption("");
                        keymapPanel.selectAction(actionId);
                    }
                }
            }
        });
        return result2;
    }

    static void updateActions(Project project, List<MavenProject> mavenProjects) {
        MavenKeymapExtension.clearActions(project, mavenProjects);
        MavenKeymapExtension.createActions(project, mavenProjects);
    }

    public static MavenAction getOrRegisterAction(MavenProject mavenProject, String actionId, String goal) {
        MavenGoalAction mavenGoalAction = new MavenGoalAction(mavenProject, goal);
        ActionManager manager = ActionManager.getInstance();
        AnAction anAction = manager.getAction(actionId);
        if (anAction instanceof MavenGoalAction) {
            return (MavenGoalAction)anAction;
        }
        manager.replaceAction(actionId, (AnAction)mavenGoalAction);
        return mavenGoalAction;
    }

    private static void createActions(Project project, List<MavenProject> mavenProjects) {
        ActionManager actionManager = ActionManager.getInstance();
        MavenShortcutsManager shortcutsManager = MavenShortcutsManager.getInstance(project);
        boolean actionManagerActionsExist = !actionManager.getActionIdList("Maven_").isEmpty();
        boolean shortcutsManagerActionsExist = shortcutsManager.hasShortcuts();
        if (!actionManagerActionsExist && !shortcutsManagerActionsExist) {
            return;
        }
        for (MavenProject eachProject : mavenProjects) {
            String actionIdPrefix = MavenKeymapExtension.getActionPrefix(project, eachProject);
            if (actionIdPrefix == null) continue;
            for (MavenGoalAction eachAction : MavenKeymapExtension.collectActions(eachProject)) {
                String id = actionIdPrefix + eachAction.getGoal();
                if (shortcutsManager.hasShortcuts(eachProject, eachAction.getGoal())) {
                    actionManager.replaceAction(id, (AnAction)eachAction);
                    continue;
                }
                actionManager.unregisterAction(id);
            }
        }
    }

    private static List<MavenGoalAction> collectActions(MavenProject mavenProject) {
        ArrayList<MavenGoalAction> result2 = new ArrayList<MavenGoalAction>();
        for (String eachGoal : MavenKeymapExtension.collectGoals(mavenProject)) {
            result2.add(new MavenGoalAction(mavenProject, eachGoal));
        }
        return result2;
    }

    public static void clearActions(Project project) {
        ActionManager manager = ActionManager.getInstance();
        for (String each : MavenKeymapExtension.getActionIdList(project, null)) {
            manager.unregisterAction(each);
        }
    }

    static void clearActions(Project project, List<MavenProject> mavenProjects) {
        ActionManager manager = ActionManager.getInstance();
        for (MavenProject eachProject : mavenProjects) {
            for (String eachAction : MavenKeymapExtension.getActionIdList(project, eachProject)) {
                manager.unregisterAction(eachAction);
            }
        }
    }

    private static @NotNull List<@NonNls String> getActionIdList(@NotNull Project project, @Nullable MavenProject mavenProject) {
        String actionPrefix;
        if (project == null) {
            MavenKeymapExtension.$$$reportNull$$$0(0);
        }
        if ((actionPrefix = MavenKeymapExtension.getActionPrefix(project, mavenProject)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenKeymapExtension.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = ActionManager.getInstance().getActionIdList(actionPrefix);
        if (list == null) {
            MavenKeymapExtension.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static List<String> collectGoals(MavenProject project) {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(MavenConstants.PHASES);
        for (MavenPluginWithArtifact each : project.getDeclaredPluginInfos()) {
            MavenPluginInfo info = MavenArtifactUtil.readPluginInfo(each.getArtifact());
            if (info == null) continue;
            for (MavenPluginInfo.Mojo m : info.getMojos()) {
                result2.add(m.getQualifiedGoal());
            }
        }
        return new ArrayList<String>(result2);
    }

    @TestOnly
    @Nullable
    public static String getActionPrefix(@NotNull Project project, @Nullable MavenProject mavenProject) {
        if (project == null) {
            MavenKeymapExtension.$$$reportNull$$$0(3);
        }
        String pomPath = mavenProject == null ? null : mavenProject.getPath();
        MavenShortcutsManager mavenShortcutsManager = MavenShortcutsManager.getInstanceIfCreated(project);
        return mavenShortcutsManager == null ? null : mavenShortcutsManager.getActionId(pomPath, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/tasks/MavenKeymapExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenKeymapExtension";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionIdList";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class MavenGoalAction
    extends MavenAction {
        private final MavenProject myMavenProject;
        @NlsSafe
        private final String myGoal;

        MavenGoalAction(MavenProject mavenProject, String goal) {
            this.myMavenProject = mavenProject;
            this.myGoal = goal;
            Presentation template = this.getTemplatePresentation();
            template.setText(goal + " (" + String.valueOf(mavenProject.getMavenId()) + ")", false);
            template.setIcon(ExternalSystemIcons.Task);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataContext context2;
            Project project;
            if (e == null) {
                MavenGoalAction.$$$reportNull$$$0(0);
            }
            if ((project = MavenActionUtil.getProject(context2 = e.getDataContext())) == null) {
                return;
            }
            MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context2);
            if (projectsManager == null) {
                return;
            }
            MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
            MavenRunnerParameters params = new MavenRunnerParameters(true, this.myMavenProject.getDirectory(), this.myMavenProject.getFile().getName(), Collections.singletonList(this.myGoal), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
            MavenRunConfigurationType.runConfiguration(project, params, null);
        }

        public MavenProject getMavenProject() {
            return this.myMavenProject;
        }

        public String getGoal() {
            return this.myGoal;
        }

        public String toString() {
            return String.valueOf(this.myMavenProject) + ":" + this.myGoal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/tasks/MavenKeymapExtension$MavenGoalAction", "actionPerformed"));
        }
    }
}

