/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.git.shared.actions.GitSingleRefActions;
import git4idea.actions.branch.GitBranchActionsDataKeys;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesDashboardTreeModel;
import git4idea.ui.branch.dashboard.BranchesDashboardTreeSelectionHandler;
import git4idea.ui.branch.dashboard.BranchesDataKeysKt;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeSelection;
import git4idea.ui.branch.dashboard.RemoteInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bJ\b\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J%\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001dH\u0097\u0001J\u0019\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\rH\u0097\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014*\u0004\b\u000f\u0010\u0010R(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,8W@WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00063"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeController;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler;", "project", "Lcom/intellij/openapi/project/Project;", "selectionHandler", "model", "Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeModel;", "tree", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler;Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeModel;Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;)V", "<set-?>", "", "showOnlyMy", "getShowOnlyMy$delegate", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeController;)Ljava/lang/Object;", "getShowOnlyMy", "()Z", "setShowOnlyMy", "(Z)V", "updateLogBranchFilter", "", "navigateLogToRef", "selection", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor$LogNavigatable;", "getSelectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "repositoryGroupingEnabled", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "filterBy", "branches", "", "", "repositories", "navigateTo", "navigatable", "focus", "value", "Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler$SelectionAction;", "selectionAction", "getSelectionAction", "()Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler$SelectionAction;", "setSelectionAction", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler$SelectionAction;)V", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesDashboardTreeController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardTreeController.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardTreeController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1#2:117\n382#3,7:118\n382#3,7:131\n1634#4,3:125\n774#4:128\n865#4,2:129\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardTreeController.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardTreeController\n*L\n64#1:118,7\n72#1:131,7\n68#1:125,3\n70#1:128\n70#1:129,2\n*E\n"})
public final class BranchesDashboardTreeController
implements UiDataProvider,
BranchesDashboardTreeSelectionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BranchesDashboardTreeSelectionHandler selectionHandler;
    @NotNull
    private final BranchesDashboardTreeModel model;
    @NotNull
    private final BranchesTreeComponent tree;

    public BranchesDashboardTreeController(@NotNull Project project, @NotNull BranchesDashboardTreeSelectionHandler selectionHandler, @NotNull BranchesDashboardTreeModel model, @NotNull BranchesTreeComponent tree) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectionHandler, (String)"selectionHandler");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.project = project;
        this.selectionHandler = selectionHandler;
        this.model = model;
        this.tree = tree;
        TreeSelectionListener treeSelectionListener = arg_0 -> BranchesDashboardTreeController._init_$lambda$1(this, arg_0);
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public final boolean getShowOnlyMy() {
        return this.model.getShowOnlyMy();
    }

    public final void setShowOnlyMy(boolean bl) {
        this.model.setShowOnlyMy(bl);
    }

    private static Object getShowOnlyMy$delegate(BranchesDashboardTreeController branchesDashboardTreeController) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)branchesDashboardTreeController.model, BranchesDashboardTreeModel.class, "showOnlyMy", "getShowOnlyMy()Z", 0)));
    }

    public final void updateLogBranchFilter() {
        BranchesTreeSelection treeSelection = this.tree.getSelection();
        List<String> selectedFilters = treeSelection.getSelectedBranchFilters();
        Set<GitRepository> repositories = this.repositoryGroupingEnabled() ? treeSelection.getRepositoriesOfSelectedBranches() : SetsKt.emptySet();
        this.selectionHandler.filterBy(selectedFilters, repositories);
    }

    public final void navigateLogToRef(@NotNull BranchNodeDescriptor.LogNavigatable selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        this.selectionHandler.navigateTo(selection, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<GitRepository, Set<GitRemote>> getSelectedRemotes() {
        Set<RemoteInfo> selectedRemotes = this.tree.getSelection().getSelectedRemotes();
        if (selectedRemotes.isEmpty()) {
            return MapsKt.emptyMap();
        }
        HashMap result2 = new HashMap();
        if (this.repositoryGroupingEnabled()) {
            for (RemoteInfo selectedRemote : selectedRemotes) {
                GitRemote remote;
                Object object;
                void $this$getOrPut$iv;
                Object v1;
                GitRepository gitRepository;
                block12: {
                    if (selectedRemote.getRepository() == null) continue;
                    Collection<GitRemote> collection = gitRepository.getRemotes();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemotes(...)");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        GitRemote it = (GitRemote)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)selectedRemote.getRemoteName())) continue;
                        v1 = t;
                        break block12;
                    }
                    v1 = null;
                }
                if ((GitRemote)v1 == null) continue;
                Map map2 = result2;
                GitRepository key$iv = gitRepository;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(remote);
            }
        } else {
            void $this$mapTo$iv;
            Iterable selectedRemote = selectedRemotes;
            Collection collection = new HashSet();
            boolean $i$f$mapTo = false;
            Iterator $this$getOrPut$iv = $this$mapTo$iv.iterator();
            while ($this$getOrPut$iv.hasNext()) {
                void it;
                Object item$iv = $this$getOrPut$iv.next();
                RemoteInfo $i$f$getOrPut = (RemoteInfo)item$iv;
                Collection collection2 = collection;
                boolean bl = false;
                collection2.add(it.getRemoteName());
            }
            HashSet remoteNames = (HashSet)collection;
            for (GitRepository gitRepository : GitRepositoryManager.getInstance(this.project).getRepositories()) {
                Object object;
                void $this$filterTo$iv$iv;
                Collection<GitRemote> collection3 = gitRepository.getRemotes();
                Intrinsics.checkNotNullExpressionValue(collection3, (String)"getRemotes(...)");
                Object $this$filter$iv = collection3;
                boolean $i$f$filter = false;
                Iterable it = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GitRemote remote = (GitRemote)element$iv$iv;
                    boolean bl = false;
                    if (!remoteNames.contains(remote.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List remotes = (List)destination$iv$iv;
                if (!(!((Collection)remotes).isEmpty())) continue;
                $this$filter$iv = result2;
                GitRepository key$iv = gitRepository;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).addAll(remotes);
            }
        }
        return result2;
    }

    private final boolean repositoryGroupingEnabled() {
        Boolean bl = this.model.getGroupingConfig().get(GroupingKey.GROUPING_BY_REPOSITORY);
        return bl != null ? bl : false;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER(), (Object)this);
        Companion.snapshotSelectionActionsKeys$intellij_vcs_git(sink, this.tree.getSelectionPaths());
    }

    @Override
    @RequiresEdt
    @Nullable
    public BranchesDashboardTreeSelectionHandler.SelectionAction getSelectionAction() {
        return this.selectionHandler.getSelectionAction();
    }

    @Override
    @RequiresEdt
    public void setSelectionAction(@Nullable BranchesDashboardTreeSelectionHandler.SelectionAction selectionAction) {
        this.selectionHandler.setSelectionAction(selectionAction);
    }

    @Override
    @RequiresEdt
    public void filterBy(@NotNull List<String> branches, @NotNull Set<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        this.selectionHandler.filterBy(branches, repositories);
    }

    @Override
    @RequiresEdt
    public void navigateTo(@NotNull BranchNodeDescriptor.LogNavigatable navigatable, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        this.selectionHandler.navigateTo(navigatable, focus);
    }

    private static final void _init_$lambda$1(BranchesDashboardTreeController this$0, TreeSelectionEvent it) {
        if (!this$0.tree.isShowing()) {
            return;
        }
        BranchesDashboardTreeSelectionHandler.SelectionAction selectionAction = this$0.selectionHandler.getSelectionAction();
        switch (selectionAction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[selectionAction.ordinal()]) {
            case 1: {
                this$0.updateLogBranchFilter();
                break;
            }
            case 2: {
                BranchNodeDescriptor.LogNavigatable logNavigatable = this$0.tree.getSelection().getLogNavigatableNodeDescriptor();
                if (logNavigatable != null) {
                    BranchNodeDescriptor.LogNavigatable logNavigatableSelection = logNavigatable;
                    boolean bl = false;
                    this$0.selectionHandler.navigateTo(logNavigatableSelection, false);
                }
                break;
            }
            case -1: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0001\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeController$Companion;", "", "<init>", "()V", "snapshotSelectionActionsKeys", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "selectionPaths", "", "Ljavax/swing/tree/TreePath;", "snapshotSelectionActionsKeys$intellij_vcs_git", "(Lcom/intellij/openapi/actionSystem/DataSink;[Ljavax/swing/tree/TreePath;)V", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final void snapshotSelectionActionsKeys$intellij_vcs_git(@NotNull DataSink sink, @Nullable TreePath[] selectionPaths) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            BranchesTreeSelection selection = new BranchesTreeSelection(selectionPaths);
            sink.set(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION(), (Object)selection);
            DataKey dataKey = PlatformCoreDataKeys.SELECTED_ITEMS;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"SELECTED_ITEMS");
            sink.set(dataKey, (Object)selectionPaths);
            BranchTreeNode branchTreeNode = (BranchTreeNode)CollectionsKt.singleOrNull(selection.getSelectedNodes());
            if (branchTreeNode == null) {
                return;
            }
            BranchTreeNode selectedNode = branchTreeNode;
            BranchNodeDescriptor selectedDescriptor = selectedNode.getNodeDescriptor();
            if (selection.getHeadSelected()) {
                sink.set(GitBranchActionsDataKeys.USE_CURRENT_BRANCH, (Object)true);
            }
            BranchNodeDescriptor.Ref ref = selectedDescriptor instanceof BranchNodeDescriptor.Ref ? (BranchNodeDescriptor.Ref)selectedDescriptor : null;
            if (ref == null) {
                return;
            }
            BranchNodeDescriptor.Ref selectedRef = ref;
            sink.set(GitSingleRefActions.SELECTED_REF_DATA_KEY, (Object)selectedRef.getRefInfo().getRef());
            List<GitRepository> selectedRepositories = BranchesTreeSelection.Companion.getSelectedRepositories(selectedNode);
            sink.set(GitBranchActionsDataKeys.AFFECTED_REPOSITORIES, selectedRepositories);
            sink.set(GitBranchActionsDataKeys.SELECTED_REPOSITORY, CollectionsKt.singleOrNull(selectedRepositories));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BranchesDashboardTreeSelectionHandler.SelectionAction.values().length];
            try {
                nArray[BranchesDashboardTreeSelectionHandler.SelectionAction.FILTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BranchesDashboardTreeSelectionHandler.SelectionAction.NAVIGATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

