/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.cfg.ConstructorConsistencyChecker;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.ReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.TailInstructionDetector;
import org.jetbrains.kotlin.cfg.TailRecursionKind;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.cfg.UnreachableCodeImpl;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.JumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfo;
import org.jetbrains.kotlin.cfg.variable.PseudocodeVariablesData;
import org.jetbrains.kotlin.cfg.variable.VariableControlFlowState;
import org.jetbrains.kotlin.cfg.variable.VariableInitReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.variable.VariableUseState;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.IncrementalTrackerUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u0081\u00012\u00020\u0001:\t{|}~\u007f\u0080\u0001\u0081\u0001B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB5\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u0011J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0019H\u0002J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0002J\b\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\f\u0010(\u001a\u00020)*\u00020*H\u0002J*\u0010+\u001a\u00020\u00192\n\u0010,\u001a\u00060-R\u00020\u00002\u0006\u0010.\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\u0018\u00102\u001a\u00020)2\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J2\u00106\u001a\u00020)2\n\u0010,\u001a\u00060-R\u00020\u00002\u0006\u00107\u001a\u0002082\u0006\u00104\u001a\u0002052\f\u00109\u001a\b\u0012\u0004\u0012\u00020100H\u0002J,\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u0002082\u0006\u00103\u001a\u00020*2\n\u0010,\u001a\u00060-R\u00020\u0000H\u0002J$\u0010=\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\u0006\u00103\u001a\u0002012\n\u0010,\u001a\u00060-R\u00020\u0000H\u0002J\u001c\u0010>\u001a\u00020)2\n\u0010,\u001a\u00060-R\u00020\u00002\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010?\u001a\u00020)*\u00060-R\u00020\u0000H\u0002J\u001c\u0010@\u001a\u00020)2\n\u0010,\u001a\u00060-R\u00020\u00002\u0006\u00107\u001a\u000208H\u0002J*\u0010'\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010A\u001a\u0014\u0012\u0004\u0012\u00020C\u0012\n\u0012\b\u0012\u0004\u0012\u00020E0D0BH\u0002J\b\u0010F\u001a\u00020\u0019H\u0002J.\u0010J\u001a\u00020\u00192\u0006\u0010.\u001a\u00020K2\u0006\u00103\u001a\u0002012\n\u0010,\u001a\u00060LR\u00020\u00002\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J$\u0010O\u001a\u00020\u00192\n\u0010,\u001a\u00060LR\u00020\u00002\u0006\u0010.\u001a\u00020P2\u0006\u00103\u001a\u000201H\u0002J\b\u0010Q\u001a\u00020\u0019H\u0002J\b\u0010R\u001a\u00020\u0019H\u0002J\f\u0010S\u001a\u00020\u0019*\u000208H\u0002J\b\u0010T\u001a\u00020\u0019H\u0002J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010U\u001a\u00020VH\u0002J\b\u0010W\u001a\u00020\u0019H\u0002J\u0010\u0010X\u001a\u00020\u00192\u0006\u00107\u001a\u000208H\u0002J\b\u0010Y\u001a\u00020\u0019H\u0002J\"\u0010Z\u001a\u00020\u00192\b\u0010[\u001a\u0004\u0018\u00010\u001d2\u0006\u0010.\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0002J(\u0010_\u001a\u00020\u00192\b\u0010[\u001a\u0004\u0018\u00010\u001d2\u0006\u0010.\u001a\u00020\\2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020b0aH\u0002J\b\u0010c\u001a\u00020\u0019H\u0002J\b\u0010d\u001a\u00020\u0019H\u0002J\u0010\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0003H\u0002J\u0016\u0010i\u001a\u00020)*\u00020j2\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0002JG\u0010k\u001a\u00020\u00192<\b\u0004\u0010l\u001a6\u0012\u0013\u0012\u00110j\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b(p\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030q\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b(r\u0012\u0004\u0012\u00020\u00190mH\u0082\bJ\u001c\u0010s\u001a\u00020\u00192\u0006\u0010t\u001a\u00020u2\n\u0010,\u001a\u00060vR\u00020\u0000H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010G\u001a\u00020)*\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0018\u0010I\u001a\u00020)*\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010HR\u0018\u0010w\u001a\u00020x*\u00020x8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010z\u00a8\u0006\u0082\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;)V", "declaration", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;)V", "pseudocodeVariablesData", "Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "getPseudocodeVariablesData", "()Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariablesData;", "pseudocodeVariablesData$delegate", "Lkotlin/Lazy;", "checkForLocalClassOrObjectMode", "", "checkDeclaration", "checkFunction", "expectedReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "collectReturnExpressions", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$ReturnedExpressionsInfo;", "checkLocalFunctions", "checkDefiniteReturn", "unreachableCode", "Lorg/jetbrains/kotlin/cfg/UnreachableCode;", "reportUnreachableCode", "collectUnreachableCode", "markUninitializedVariables", "recordInitializedVariables", "isDefinitelyInitialized", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkIsInitialized", "ctxt", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableInitContext;", "element", "varWithUninitializedErrorGenerated", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isCapturedWrite", "variableDescriptor", "writeValueInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/WriteValueInstruction;", "checkValReassignment", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "varWithValReassignErrorGenerated", "reportVisibilityWarningForInternalFakeSetterOverride", "setterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "reportValReassigned", "checkAssignmentBeforeDeclaration", "isInitializationBeforeDeclaration", "checkInitializationForCustomSetter", "initializersMap", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/Edges;", "Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;", "markUnusedVariables", "isLocalVariableWithDelegate", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Z", "isLocalVariableWithProvideDelegate", "processUnusedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableUseContext;", "variableUseState", "Lorg/jetbrains/kotlin/cfg/variable/VariableUseState;", "processUnusedParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "markUnusedExpressions", "markStatements", "recordUsedAsExpression", "markAnnotationArguments", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfExpressions", "checkImplicitCastOnConditionalExpression", "checkWhenExpressions", "checkWhenStatement", "subjectType", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkExhaustiveWhenStatement", "missingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "checkConstructorConsistency", "markAndCheckTailCalls", "markAndCheckRecursiveTailCalls", "subroutineDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isInsideTry", "isTailCall", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/CallInstruction;", "traverseCalls", "onCall", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "instruction", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "report", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "deparenthesizedParent", "Lcom/intellij/psi/PsiElement;", "getDeparenthesizedParent", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "ReturnedExpressionsInfo", "AlgebraicTypeKind", "VariableContext", "VariableInitContext", "VariableUseContext", "Factory", "Companion", "cfg"})
@SourceDebugExtension(value={"SMAP\nControlFlowInformationProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowInformationProviderImpl.kt\norg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1376:1\n1195#1,5:1394\n1#2:1377\n13472#3:1378\n13473#3:1382\n314#4,2:1379\n326#4:1381\n307#4,9:1383\n326#4:1392\n308#4:1393\n295#5,2:1399\n*S KotlinDebug\n*F\n+ 1 ControlFlowInformationProviderImpl.kt\norg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl\n*L\n1126#1:1394,5\n903#1:1378\n903#1:1382\n904#1:1379,2\n904#1:1381\n913#1:1383,9\n913#1:1392\n913#1:1393\n1006#1:1399,2\n*E\n"})
public final class ControlFlowInformationProviderImpl
implements ControlFlowInformationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtElement subroutine;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Pseudocode pseudocode;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    @Nullable
    private final EnumWhenTracker enumWhenTracker;
    @NotNull
    private final Lazy pseudocodeVariablesData$delegate;

    private ControlFlowInformationProviderImpl(KtElement subroutine, BindingTrace trace, Pseudocode pseudocode, LanguageVersionSettings languageVersionSettings, PlatformDiagnosticSuppressor diagnosticSuppressor, EnumWhenTracker enumWhenTracker) {
        this.subroutine = subroutine;
        this.trace = trace;
        this.pseudocode = pseudocode;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.enumWhenTracker = enumWhenTracker;
        this.pseudocodeVariablesData$delegate = LazyKt.lazy(() -> ControlFlowInformationProviderImpl.pseudocodeVariablesData_delegate$lambda$0(this));
    }

    private final PseudocodeVariablesData getPseudocodeVariablesData() {
        Lazy lazy = this.pseudocodeVariablesData$delegate;
        return (PseudocodeVariablesData)lazy.getValue();
    }

    public ControlFlowInformationProviderImpl(@NotNull KtElement declaration, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @Nullable EnumWhenTracker enumWhenTracker) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(diagnosticSuppressor, "diagnosticSuppressor");
        this(declaration, trace, new ControlFlowProcessor(trace, languageVersionSettings).generatePseudocode(declaration), languageVersionSettings, diagnosticSuppressor, enumWhenTracker);
    }

    public /* synthetic */ ControlFlowInformationProviderImpl(KtElement ktElement, BindingTrace bindingTrace, LanguageVersionSettings languageVersionSettings, PlatformDiagnosticSuppressor platformDiagnosticSuppressor, EnumWhenTracker enumWhenTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            enumWhenTracker = null;
        }
        this(ktElement, bindingTrace, languageVersionSettings, platformDiagnosticSuppressor, enumWhenTracker);
    }

    @Override
    public void checkForLocalClassOrObjectMode() {
        this.recordInitializedVariables();
    }

    @Override
    public void checkDeclaration() {
        this.recordInitializedVariables();
        this.checkLocalFunctions();
        this.markUninitializedVariables();
        if (this.trace.wantsDiagnostics()) {
            this.markUnusedVariables();
        }
        this.markStatements();
        this.markAnnotationArguments();
        this.markUnusedExpressions();
        if (this.trace.wantsDiagnostics()) {
            this.checkIfExpressions();
        }
        this.checkWhenExpressions();
        this.checkConstructorConsistency();
    }

    @Override
    public void checkFunction(@Nullable KotlinType expectedReturnType) {
        UnreachableCode unreachableCode = this.collectUnreachableCode();
        this.reportUnreachableCode(unreachableCode);
        if (this.subroutine instanceof KtFunctionLiteral) {
            return;
        }
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue(simpleType, "NO_EXPECTED_TYPE");
            kotlinType = simpleType;
        }
        this.checkDefiniteReturn(kotlinType, unreachableCode);
        this.markAndCheckTailCalls();
    }

    private final ReturnedExpressionsInfo collectReturnExpressions() {
        HashSet<Instruction> instructions = CollectionsKt.toHashSet((Iterable)this.pseudocode.getInstructions());
        SubroutineExitInstruction exitInstruction = this.pseudocode.getExitInstruction();
        ArrayList<KtElement> returnedExpressions = new ArrayList<KtElement>();
        Ref.BooleanRef hasReturnsInInlinedLambda = new Ref.BooleanRef();
        for (Instruction previousInstruction : exitInstruction.getPreviousInstructions()) {
            previousInstruction.accept(new InstructionVisitor(instructions, returnedExpressions, hasReturnsInInlinedLambda){
                final /* synthetic */ HashSet<Instruction> $instructions;
                final /* synthetic */ ArrayList<KtElement> $returnedExpressions;
                final /* synthetic */ Ref.BooleanRef $hasReturnsInInlinedLambda;
                {
                    this.$instructions = $instructions;
                    this.$returnedExpressions = $returnedExpressions;
                    this.$hasReturnsInInlinedLambda = $hasReturnsInInlinedLambda;
                }

                public void visitReturnValue(ReturnValueInstruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    if (this.$instructions.contains(instruction)) {
                        this.$returnedExpressions.add(instruction.getElement());
                    }
                    if (instruction.getOwner().isInlined()) {
                        this.$hasReturnsInInlinedLambda.element = true;
                    }
                }

                public void visitReturnNoValue(ReturnNoValueInstruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    if (this.$instructions.contains(instruction)) {
                        this.$returnedExpressions.add(instruction.getElement());
                    }
                    if (instruction.getOwner().isInlined()) {
                        this.$hasReturnsInInlinedLambda.element = true;
                    }
                }

                public void visitUnconditionalJump(UnconditionalJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitConditionalJump(ConditionalJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                private final void redirectToPrevInstructions(Instruction instruction) {
                    for (Instruction redirectInstruction : instruction.getPreviousInstructions()) {
                        redirectInstruction.accept(this);
                    }
                }

                public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitMarkInstruction(MarkInstruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    this.redirectToPrevInstructions(instruction);
                }

                public void visitInstruction(Instruction instruction) {
                    Intrinsics.checkNotNullParameter(instruction, "instruction");
                    if (!(instruction instanceof KtElementInstruction)) {
                        throw new IllegalStateException(instruction + " precedes the exit point");
                    }
                    this.$returnedExpressions.add(((KtElementInstruction)instruction).getElement());
                }
            });
        }
        return new ReturnedExpressionsInfo((Collection<? extends KtElement>)returnedExpressions, hasReturnsInInlinedLambda.element);
    }

    private final void checkLocalFunctions() {
        for (LocalFunctionDeclarationInstruction localDeclarationInstruction : this.pseudocode.getLocalDeclarations()) {
            CallableDescriptor functionDescriptor;
            KtElement element = localDeclarationInstruction.getElement();
            if (!(element instanceof KtDeclarationWithBody)) continue;
            DeclarationDescriptor declarationDescriptor = this.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            CallableDescriptor callableDescriptor = functionDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            KotlinType expectedType = callableDescriptor != null ? callableDescriptor.getReturnType() : null;
            ControlFlowInformationProviderImpl providerForLocalDeclaration = new ControlFlowInformationProviderImpl(element, this.trace, localDeclarationInstruction.getBody(), this.languageVersionSettings, this.diagnosticSuppressor, this.enumWhenTracker);
            providerForLocalDeclaration.checkFunction(expectedType);
        }
    }

    private final void checkDefiniteReturn(KotlinType expectedReturnType, UnreachableCode unreachableCode) {
        KtElement ktElement = this.subroutine;
        KtDeclarationWithBody ktDeclarationWithBody = ktElement instanceof KtDeclarationWithBody ? (KtDeclarationWithBody)ktElement : null;
        if (ktDeclarationWithBody == null) {
            throw new AssertionError((Object)("checkDefiniteReturn is called for " + this.subroutine.getText() + " which is not KtDeclarationWithBody"));
        }
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        if (!function2.hasBody()) {
            return;
        }
        ReturnedExpressionsInfo returnedExpressionsInfo = this.collectReturnExpressions();
        Collection<KtElement> returnedExpressions = returnedExpressionsInfo.component1();
        boolean hasReturnsInInlinedLambdas = returnedExpressionsInfo.component2();
        boolean blockBody = function2.hasBlockBody();
        Ref.BooleanRef noReturnError = new Ref.BooleanRef();
        for (KtElement returnedExpression : returnedExpressions) {
            returnedExpression.accept(new KtVisitorVoid(blockBody, this, expectedReturnType, unreachableCode, noReturnError){
                final /* synthetic */ boolean $blockBody;
                final /* synthetic */ ControlFlowInformationProviderImpl this$0;
                final /* synthetic */ KotlinType $expectedReturnType;
                final /* synthetic */ UnreachableCode $unreachableCode;
                final /* synthetic */ Ref.BooleanRef $noReturnError;
                {
                    this.$blockBody = $blockBody;
                    this.this$0 = $receiver;
                    this.$expectedReturnType = $expectedReturnType;
                    this.$unreachableCode = $unreachableCode;
                    this.$noReturnError = $noReturnError;
                }

                public void visitReturnExpression(KtReturnExpression expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    if (!this.$blockBody) {
                        ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).report(Errors.RETURN_IN_FUNCTION_WITH_EXPRESSION_BODY.on((KtReturnExpression)((PsiElement)expression2)));
                    }
                }

                public void visitKtElement(KtElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (!(element instanceof KtExpression) && !(element instanceof KtWhenCondition)) {
                        return;
                    }
                    if (this.$blockBody && !TypeUtils.noExpectedType(this.$expectedReturnType) && !KotlinBuiltIns.isUnit(this.$expectedReturnType) && !this.$unreachableCode.getElements().contains(element)) {
                        this.$noReturnError.element = true;
                    }
                }
            });
        }
        if (noReturnError.element) {
            if (hasReturnsInInlinedLambdas) {
                this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY_MIGRATION.on((KtDeclarationWithBody)((PsiElement)function2)));
            } else {
                this.trace.report(Errors.NO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY.on((KtDeclarationWithBody)((PsiElement)function2)));
            }
        }
    }

    private final void reportUnreachableCode(UnreachableCode unreachableCode) {
        for (KtElement element : unreachableCode.getElements()) {
            this.trace.report(Errors.UNREACHABLE_CODE.on((KtElement)((PsiElement)element), unreachableCode.getReachableElements(), unreachableCode.getUnreachableElements()));
        }
    }

    private final UnreachableCode collectUnreachableCode() {
        HashSet<KtElement> reachableElements = new HashSet<KtElement>();
        HashSet<KtElement> unreachableElements = new HashSet<KtElement>();
        for (Instruction instruction : this.pseudocode.getInstructionsIncludingDeadCode()) {
            boolean isJumpElement;
            if (!(instruction instanceof KtElementInstruction) || instruction instanceof LoadUnitValueInstruction || instruction instanceof MergeInstruction || instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getSynthetic()) continue;
            KtElement element = ((KtElementInstruction)instruction).getElement();
            if (instruction instanceof JumpInstruction && !(isJumpElement = element instanceof KtBreakExpression || element instanceof KtContinueExpression || element instanceof KtReturnExpression || element instanceof KtThrowExpression)) continue;
            boolean bl = instruction.getDead() ? unreachableElements.add(element) : reachableElements.add(element);
        }
        return new UnreachableCodeImpl((Set<? extends KtElement>)reachableElements, (Set<? extends KtElement>)unreachableElements);
    }

    private final void markUninitializedVariables() {
        HashSet varWithUninitializedErrorGenerated = new HashSet();
        HashSet varWithValReassignErrorGenerated = new HashSet();
        boolean processClassOrObject = this.subroutine instanceof KtClassOrObject || this.subroutine instanceof KtSecondaryConstructor;
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(this.pseudocode, true);
        BlockScopeVariableInfo blockScopeVariableInfo = this.getPseudocodeVariablesData().getBlockScopeVariableInfo();
        HashMap reportedDiagnosticMap = new HashMap();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, initializers, (arg_0, arg_1, arg_2) -> ControlFlowInformationProviderImpl.markUninitializedVariables$lambda$1(this, reportedDiagnosticMap, blockScopeVariableInfo, declaredVariables, varWithUninitializedErrorGenerated, varWithValReassignErrorGenerated, processClassOrObject, arg_0, arg_1, arg_2));
    }

    private final void recordInitializedVariables() {
        Pseudocode pseudocode = this.getPseudocodeVariablesData().getPseudocode();
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        this.recordInitializedVariables(pseudocode, initializers);
        for (LocalFunctionDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            this.recordInitializedVariables(instruction.getBody(), initializers);
        }
    }

    private final boolean isDefinitelyInitialized(PropertyDescriptor $this$isDefinitelyInitialized) {
        if (Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, $this$isDefinitelyInitialized), true)) {
            return false;
        }
        PsiElement property2 = DescriptorToSourceUtils.descriptorToDeclaration($this$isDefinitelyInitialized);
        return !(property2 instanceof KtProperty) || !((KtProperty)property2).hasDelegate();
    }

    private final void checkIsInitialized(VariableInitContext ctxt, KtElement element, Collection<VariableDescriptor> varWithUninitializedErrorGenerated) {
        block14: {
            VariableDescriptor variableDescriptor;
            VariableDescriptor variableDescriptor2;
            block16: {
                block15: {
                    if (!(element instanceof KtSimpleNameExpression)) {
                        return;
                    }
                    VariableControlFlowState variableControlFlowState = ctxt.getExitInitState$cfg();
                    boolean isDefinitelyInitialized = variableControlFlowState != null ? variableControlFlowState.definitelyInitialized() : false;
                    variableDescriptor2 = ctxt.getVariableDescriptor$cfg();
                    if (!isDefinitelyInitialized && variableDescriptor2 instanceof PropertyDescriptor) {
                        isDefinitelyInitialized = this.isDefinitelyInitialized((PropertyDescriptor)variableDescriptor2);
                    }
                    if (isDefinitelyInitialized || CollectionsKt.contains((Iterable)varWithUninitializedErrorGenerated, variableDescriptor2)) break block14;
                    if (!(variableDescriptor2 instanceof PropertyDescriptor)) {
                        VariableDescriptor variableDescriptor3 = variableDescriptor2;
                        if (variableDescriptor3 != null) {
                            VariableDescriptor it = variableDescriptor3;
                            boolean bl = false;
                            varWithUninitializedErrorGenerated.add(it);
                        }
                    } else if (((PropertyDescriptor)variableDescriptor2).isLateInit()) {
                        this.trace.record(BindingContext.MUST_BE_LATEINIT, variableDescriptor2);
                        return;
                    }
                    variableDescriptor = variableDescriptor2;
                    if (!(variableDescriptor instanceof ValueParameterDescriptor)) break block15;
                    ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_PARAMETER.on((KtSimpleNameExpression)element, (ValueParameterDescriptor)variableDescriptor2);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                    break block14;
                }
                if (!(variableDescriptor instanceof FakeCallableDescriptorForObject)) break block16;
                ClassDescriptor classDescriptor = ((FakeCallableDescriptorForObject)variableDescriptor2).getClassDescriptor();
                switch (WhenMappings.$EnumSwitchMapping$0[classDescriptor.getKind().ordinal()]) {
                    case 1: {
                        ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_ENUM_ENTRY.on((KtSimpleNameExpression)element, classDescriptor);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                        this.report(parametrizedDiagnostic, ctxt);
                        break;
                    }
                    case 2: {
                        if (!classDescriptor.isCompanionObject()) break block14;
                        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
                        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                        DeclarationDescriptor container = declarationDescriptor;
                        if (!(container instanceof ClassDescriptor) || ((ClassDescriptor)container).getKind() != ClassKind.ENUM_CLASS || this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAccessToEnumCompanionMembersInEnumConstructorCall)) break block14;
                        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_ENUM_COMPANION.on((KtExpression)element, (ClassDescriptor)container);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                        this.report(parametrizedDiagnostic, ctxt);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block14;
            }
            if (!(variableDescriptor == null || variableDescriptor2.isLateInit() || variableDescriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)variableDescriptor2)))) {
                ParametrizedDiagnostic<KtSimpleNameExpression> parametrizedDiagnostic = Errors.UNINITIALIZED_VARIABLE.on((KtSimpleNameExpression)element, variableDescriptor2);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        }
    }

    private final boolean isCapturedWrite(VariableDescriptor variableDescriptor, WriteValueInstruction writeValueInstruction) {
        block5: {
            BindingContext context;
            DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            DeclarationDescriptor containingDeclarationDescriptor = declarationDescriptor;
            if (containingDeclarationDescriptor instanceof PackageFragmentDescriptor) {
                return false;
            }
            KtDeclaration parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(writeValueInstruction.getElement());
            while (true) {
                Intrinsics.checkNotNullExpressionValue(this.trace.getBindingContext(), "getBindingContext(...)");
                DeclarationDescriptor parentDescriptor = CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parentDeclaration, context);
                if (Intrinsics.areEqual(parentDescriptor, containingDeclarationDescriptor)) {
                    return false;
                }
                KtDeclaration ktDeclaration = parentDeclaration;
                if (ktDeclaration instanceof KtObjectDeclaration || ktDeclaration instanceof KtClassInitializer) {
                    parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration);
                    continue;
                }
                if (!(ktDeclaration instanceof KtDeclarationWithBody)) break block5;
                PsiElement maybeEnclosingLambdaExpr = ((KtDeclarationWithBody)parentDeclaration).getParent();
                if (!(maybeEnclosingLambdaExpr instanceof KtLambdaExpression) || this.trace.get(BindingContext.LAMBDA_INVOCATIONS, maybeEnclosingLambdaExpr) == null) break;
                parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration);
            }
            if (parentDeclaration instanceof KtFunction && ((KtFunction)parentDeclaration).isLocal()) {
                return true;
            }
            return !Intrinsics.areEqual(CfgContainingDeclarationUtilsKt.getDeclarationDescriptorIncludingConstructors(parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(parentDeclaration), context), containingDeclarationDescriptor);
        }
        return true;
    }

    private final boolean checkValReassignment(VariableInitContext ctxt, KtExpression expression2, WriteValueInstruction writeValueInstruction, Collection<VariableDescriptor> varWithValReassignErrorGenerated) {
        boolean captured;
        boolean bl;
        boolean hasBackingField;
        boolean bl2;
        Object it;
        VariableDescriptor variableDescriptor = ctxt.getVariableDescriptor$cfg();
        VariableControlFlowState variableControlFlowState = ctxt.getEnterInitState$cfg();
        boolean mayBeInitializedNotHere = variableControlFlowState != null ? variableControlFlowState.mayBeInitialized() : false;
        PropertyDescriptor propertyDescriptor = variableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)variableDescriptor : null;
        if (propertyDescriptor != null) {
            it = propertyDescriptor;
            boolean bl3 = false;
            Boolean bl4 = (Boolean)this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, it);
            bl2 = bl4 != null ? bl4 : false;
        } else {
            bl2 = hasBackingField = true;
        }
        if (variableDescriptor instanceof PropertyDescriptor && ((PropertyDescriptor)variableDescriptor).isVar()) {
            ReceiverValue receiverValue;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            DeclarationDescriptor descriptor = BindingContextUtilsKt.getEnclosingDescriptor(bindingContext, expression2);
            PropertySetterDescriptor setterDescriptor = ((PropertyDescriptor)variableDescriptor).getSetter();
            KtElement ktElement = expression2;
            BindingContext bindingContext2 = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
            ReceiverValue receiverValue2 = receiverValue = resolvedCall2 != null ? ResolvedCallUtilKt.getDispatchReceiverWithSmartCast(resolvedCall2) : null;
            if (DescriptorVisibilityUtils.isVisible(receiverValue, variableDescriptor, descriptor, this.languageVersionSettings) && setterDescriptor != null) {
                if (!DescriptorVisibilityUtils.isVisible(receiverValue, setterDescriptor, descriptor, this.languageVersionSettings)) {
                    it = Errors.INVISIBLE_SETTER.on(expression2, variableDescriptor, setterDescriptor.getVisibility(), setterDescriptor);
                    Intrinsics.checkNotNullExpressionValue(it, "on(...)");
                    this.report((Diagnostic)it, ctxt);
                    return true;
                }
                this.reportVisibilityWarningForInternalFakeSetterOverride(setterDescriptor, expression2, (PropertyDescriptor)variableDescriptor, ctxt);
            }
        }
        boolean isThisOrNoDispatchReceiver = PseudocodeUtil.isThisOrNoDispatchReceiver(writeValueInstruction, this.trace.getBindingContext());
        VariableDescriptor variableDescriptor2 = variableDescriptor;
        if (variableDescriptor2 != null) {
            VariableDescriptor it2 = variableDescriptor2;
            boolean bl5 = false;
            bl = this.isCapturedWrite(it2, writeValueInstruction);
        } else {
            bl = captured = false;
        }
        if (!(!mayBeInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver && !captured || variableDescriptor == null || variableDescriptor.isVar())) {
            KtSimpleNameExpression operationReference;
            boolean hasReassignMethodReturningUnit = false;
            PsiElement parent2 = expression2.getParent();
            KtSimpleNameExpression ktSimpleNameExpression = parent2 instanceof KtBinaryExpression ? (KtSimpleNameExpression)((KtBinaryExpression)parent2).getOperationReference() : (operationReference = parent2 instanceof KtUnaryExpression ? ((KtUnaryExpression)parent2).getOperationReference() : null);
            if (operationReference != null) {
                DeclarationDescriptor descriptor = (DeclarationDescriptor)this.trace.get(BindingContext.REFERENCE_TARGET, operationReference);
                if (descriptor instanceof FunctionDescriptor) {
                    boolean bl6;
                    KotlinType kotlinType = ((FunctionDescriptor)descriptor).getReturnType();
                    if (kotlinType != null) {
                        KotlinType it3 = kotlinType;
                        boolean bl7 = false;
                        bl6 = KotlinBuiltIns.isUnit(it3);
                    } else {
                        bl6 = false;
                    }
                    if (bl6) {
                        hasReassignMethodReturningUnit = true;
                    }
                }
                if (descriptor == null) {
                    Collection collection = (Collection)this.trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationReference);
                    if (collection == null) {
                        collection = CollectionsKt.emptyList();
                    }
                    Collection descriptors = collection;
                    for (DeclarationDescriptor referenceDescriptor : descriptors) {
                        boolean bl8;
                        Annotated annotated = referenceDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)referenceDescriptor : null;
                        if (annotated != null && (annotated = annotated.getReturnType()) != null) {
                            Annotated it4 = annotated;
                            boolean bl9 = false;
                            bl8 = KotlinBuiltIns.isUnit((KotlinType)it4);
                        } else {
                            bl8 = false;
                        }
                        if (!bl8) continue;
                        hasReassignMethodReturningUnit = true;
                    }
                }
            }
            if (!hasReassignMethodReturningUnit) {
                if (!isThisOrNoDispatchReceiver || !varWithValReassignErrorGenerated.contains(variableDescriptor)) {
                    if (captured && !mayBeInitializedNotHere && hasBackingField && isThisOrNoDispatchReceiver) {
                        if (variableDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.CAPTURED_MEMBER_VAL_INITIALIZATION.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                            this.report(parametrizedDiagnostic, ctxt);
                        } else {
                            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                            this.report(parametrizedDiagnostic, ctxt);
                        }
                    } else if (DescriptorPsiUtilsKt.isBackingFieldReference(variableDescriptor)) {
                        this.reportValReassigned(expression2, variableDescriptor, ctxt);
                    } else {
                        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VAL_REASSIGNMENT.on((KtExpression)((PsiElement)expression2), variableDescriptor);
                        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                        this.report(parametrizedDiagnostic, ctxt);
                    }
                }
                if (isThisOrNoDispatchReceiver) {
                    varWithValReassignErrorGenerated.add(variableDescriptor);
                }
                return true;
            }
        }
        return false;
    }

    private final void reportVisibilityWarningForInternalFakeSetterOverride(PropertySetterDescriptor setterDescriptor, KtExpression expression2, PropertyDescriptor variableDescriptor, VariableInitContext ctxt) {
        if (setterDescriptor.getKind().isReal()) {
            return;
        }
        if (setterDescriptor.getVisibility().isPublicAPI()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = setterDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden$default(setterDescriptor, false, ControlFlowInformationProviderImpl::reportVisibilityWarningForInternalFakeSetterOverride$lambda$7, 1, null);
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor firstRealOverridden = callableMemberDescriptor;
        Collection<CallableMemberDescriptor> collection = OverridingUtil.filterVisibleFakeOverrides(containingClass, (Collection<CallableMemberDescriptor>)CollectionsKt.listOf(firstRealOverridden));
        Intrinsics.checkNotNullExpressionValue(collection, "filterVisibleFakeOverrides(...)");
        Collection<CallableMemberDescriptor> visibleOverrides = collection;
        if (visibleOverrides.isEmpty()) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor> diagnostic = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAccessToInvisibleSetterFromDerivedClass) ? Errors.INVISIBLE_SETTER : Errors.INVISIBLE_SETTER_FROM_DERIVED;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnostic.on(expression2, variableDescriptor, setterDescriptor.getVisibility(), setterDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final void reportValReassigned(KtExpression expression2, VariableDescriptor variableDescriptor, VariableInitContext ctxt) {
        this.report(Errors.VAL_REASSIGNMENT_VIA_BACKING_FIELD.on(this.languageVersionSettings, (KtExpression)((PsiElement)expression2), variableDescriptor), ctxt);
    }

    private final boolean checkAssignmentBeforeDeclaration(VariableInitContext ctxt, KtExpression expression2) {
        boolean bl;
        if (this.isInitializationBeforeDeclaration(ctxt)) {
            if (ctxt.getVariableDescriptor$cfg() != null) {
                ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.INITIALIZATION_BEFORE_DECLARATION.on((KtExpression)((PsiElement)expression2), ctxt.getVariableDescriptor$cfg());
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInitializationBeforeDeclaration(VariableInitContext $this$isInitializationBeforeDeclaration) {
        boolean bl;
        boolean bl2;
        VariableControlFlowState variableControlFlowState = $this$isInitializationBeforeDeclaration.getEnterInitState$cfg();
        if (variableControlFlowState != null) {
            if (variableControlFlowState.isDeclared()) {
                return false;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return false;
        VariableControlFlowState variableControlFlowState2 = $this$isInitializationBeforeDeclaration.getExitInitState$cfg();
        if (variableControlFlowState2 != null) {
            if (variableControlFlowState2.isDeclared()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        VariableControlFlowState variableControlFlowState3 = $this$isInitializationBeforeDeclaration.getEnterInitState$cfg();
        if (variableControlFlowState3 == null) return true;
        if (!variableControlFlowState3.mayBeInitialized()) return true;
        return false;
    }

    private final boolean checkInitializationForCustomSetter(VariableInitContext ctxt, KtExpression expression2) {
        KtExpression variable;
        VariableDescriptor variableDescriptor;
        block7: {
            block6: {
                variableDescriptor = ctxt.getVariableDescriptor$cfg();
                if (!(variableDescriptor instanceof PropertyDescriptor)) break block6;
                VariableControlFlowState variableControlFlowState = ctxt.getEnterInitState$cfg();
                if (variableControlFlowState != null ? variableControlFlowState.mayBeInitialized() : false) break block6;
                VariableControlFlowState variableControlFlowState2 = ctxt.getExitInitState$cfg();
                if ((variableControlFlowState2 != null ? variableControlFlowState2.mayBeInitialized() : false) && Intrinsics.areEqual(this.trace.get(BindingContext.BACKING_FIELD_REQUIRED, variableDescriptor), true)) break block7;
            }
            return false;
        }
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            throw new AssertionError((Object)(variableDescriptor + " is not related to KtProperty"));
        }
        KtProperty property2 = ktProperty;
        KtPropertyAccessor setter2 = property2.getSetter();
        if (!(DeclarationsCheckerKt.getEffectiveModality((PropertyDescriptor)variableDescriptor, this.languageVersionSettings) != Modality.FINAL || setter2 != null && setter2.hasBody())) {
            return false;
        }
        KtExpression ktExpression = variable = expression2 instanceof KtDotQualifiedExpression && ((KtDotQualifiedExpression)expression2).getReceiverExpression() instanceof KtThisExpression ? ((KtDotQualifiedExpression)expression2).getSelectorExpression() : expression2;
        if (variable instanceof KtSimpleNameExpression) {
            this.trace.record(BindingContext.IS_UNINITIALIZED, variableDescriptor);
            return true;
        }
        return false;
    }

    private final void recordInitializedVariables(Pseudocode pseudocode, Map<Instruction, ? extends Edges<? extends VariableInitReadOnlyControlFlowInfo>> initializersMap) {
        Edges<? extends VariableInitReadOnlyControlFlowInfo> edges = initializersMap.get(pseudocode.getExitInstruction());
        if (edges == null) {
            return;
        }
        Edges<? extends VariableInitReadOnlyControlFlowInfo> initializers = edges;
        Set<VariableDescriptor> declaredVariables = this.getPseudocodeVariablesData().getDeclaredVariables(pseudocode, false);
        for (VariableDescriptor variable : declaredVariables) {
            if (!(variable instanceof PropertyDescriptor)) continue;
            VariableControlFlowState variableControlFlowState = (VariableControlFlowState)initializers.getIncoming().getOrNull(variable);
            if (variableControlFlowState != null ? variableControlFlowState.definitelyInitialized() : false) continue;
            this.trace.record(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, variable);
            this.trace.record(BindingContext.IS_UNINITIALIZED, variable);
        }
    }

    private final void markUnusedVariables() {
        Map<Instruction, Edges<ReadOnlyControlFlowInfo<VariableDescriptor, VariableUseState>>> variableStatusData = this.getPseudocodeVariablesData().getVariableUseStatusData();
        HashMap reportedDiagnosticMap = new HashMap();
        HashMap unusedValueExpressions = new HashMap();
        HashSet usedValueExpressions = new HashSet();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.BACKWARD, variableStatusData, (arg_0, arg_1, arg_2) -> ControlFlowInformationProviderImpl.markUnusedVariables$lambda$8(this, reportedDiagnosticMap, unusedValueExpressions, usedValueExpressions, arg_0, arg_1, arg_2));
        unusedValueExpressions.keySet().removeAll(usedValueExpressions);
        for (Map.Entry entry : ((Map)unusedValueExpressions).entrySet()) {
            IElementType operationToken;
            KtExpression expressionInQuestion = (KtExpression)entry.getKey();
            Pair variableInContext = (Pair)entry.getValue();
            VariableDescriptor variableDescriptor = (VariableDescriptor)variableInContext.component1();
            VariableUseContext ctxt = (VariableUseContext)variableInContext.component2();
            KtExpression ktExpression = expressionInQuestion;
            if (ktExpression instanceof KtBinaryExpression) {
                if (((KtBinaryExpression)expressionInQuestion).getOperationToken() != KtTokens.EQ) continue;
                if (((KtBinaryExpression)expressionInQuestion).getRight() != null) {
                    KtExpression it;
                    boolean bl = false;
                    if (this.isLocalVariableWithDelegate(variableDescriptor)) continue;
                    ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.UNUSED_VALUE.on((KtBinaryExpression)expressionInQuestion, it, variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                }
                continue;
            }
            if (!(ktExpression instanceof KtPostfixExpression) || (operationToken = ((KtPostfixExpression)expressionInQuestion).getOperationReference().getReferencedNameElementType()) != KtTokens.PLUSPLUS && operationToken != KtTokens.MINUSMINUS) continue;
            ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.UNUSED_CHANGED_VALUE.on((KtElement)((PsiElement)expressionInQuestion), expressionInQuestion);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final boolean isLocalVariableWithDelegate(VariableDescriptor $this$isLocalVariableWithDelegate) {
        return $this$isLocalVariableWithDelegate instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)$this$isLocalVariableWithDelegate).isDelegated();
    }

    private final boolean isLocalVariableWithProvideDelegate(VariableDescriptor $this$isLocalVariableWithProvideDelegate) {
        if (!this.isLocalVariableWithDelegate($this$isLocalVariableWithProvideDelegate)) {
            return false;
        }
        if (!($this$isLocalVariableWithProvideDelegate instanceof VariableDescriptorWithAccessors)) {
            return false;
        }
        return this.trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, $this$isLocalVariableWithProvideDelegate) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void processUnusedDeclaration(KtNamedDeclaration element, VariableDescriptor variableDescriptor, VariableUseContext ctxt, VariableUseState variableUseState) {
        if (element.getNameIdentifier() == null) {
            return;
        }
        if (!VariableUseState.Companion.isUsed(variableUseState)) {
            if (UnderscoreUtilKt.isSingleUnderscore(element)) {
                return;
            }
            if (element instanceof KtDestructuringDeclarationEntry) {
                PsiElement psiElement = ((KtDestructuringDeclarationEntry)element).getParent().getParent();
                if ((psiElement != null ? psiElement.getParent() : null) instanceof KtParameterList) {
                    ParametrizedDiagnostic<KtDestructuringDeclarationEntry> parametrizedDiagnostic = Errors.UNUSED_DESTRUCTURED_PARAMETER_ENTRY.on((KtDestructuringDeclarationEntry)element, variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                    return;
                }
            }
            if (KtPsiUtil.isRemovableVariableDeclaration(element)) {
                if (this.isLocalVariableWithProvideDelegate(variableDescriptor)) return;
                ParametrizedDiagnostic<KtNamedDeclaration> parametrizedDiagnostic = Errors.UNUSED_VARIABLE.on((KtNamedDeclaration)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                this.report(parametrizedDiagnostic, ctxt);
                return;
            }
            if (!(element instanceof KtParameter)) return;
            this.processUnusedParameter(ctxt, (KtParameter)element, variableDescriptor);
            return;
        }
        if (variableUseState == VariableUseState.ONLY_WRITTEN_NEVER_READ && KtPsiUtil.isRemovableVariableDeclaration(element)) {
            if (this.isLocalVariableWithDelegate(variableDescriptor)) return;
            ParametrizedDiagnostic<KtNamedDeclaration> parametrizedDiagnostic = Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE.on((KtNamedDeclaration)((PsiElement)element), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            this.report(parametrizedDiagnostic, ctxt);
            return;
        }
        if (variableUseState != VariableUseState.WRITTEN_AFTER_READ) return;
        if (!(element instanceof KtVariableDeclaration)) return;
        KtVariableDeclaration ktVariableDeclaration = (KtVariableDeclaration)element;
        if (ktVariableDeclaration instanceof KtProperty) {
            KtExpression ktExpression = ((KtProperty)element).getInitializer();
            if (ktExpression == null) return;
            KtExpression it = ktExpression;
            boolean bl = false;
            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on((KtExpression)((PsiElement)it), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            this.report(parametrizedDiagnostic, ctxt);
            return;
        }
        if (!(ktVariableDeclaration instanceof KtDestructuringDeclarationEntry)) return;
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER.on((KtExpression)((PsiElement)element), variableDescriptor);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        this.report(parametrizedDiagnostic, ctxt);
    }

    private final void processUnusedParameter(VariableUseContext ctxt, KtParameter element, VariableDescriptor variableDescriptor) {
        FunctionDescriptor functionDescriptor;
        block22: {
            block21: {
                DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
                Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                if (functionDescriptor.isExpect() || functionDescriptor.isActual() || DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor)) break block21;
                BindingContext bindingContext = this.trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (this.diagnosticSuppressor.shouldReportUnusedParameter(variableDescriptor, bindingContext) && this.diagnosticSuppressor.shouldReportUnusedParameter(variableDescriptor)) break block22;
            }
            return;
        }
        PsiElement owner = element.getParent().getParent();
        if (owner instanceof KtPrimaryConstructor) {
            if (!element.hasValOrVar()) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)functionDescriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters, "getContainingDeclaration(...)");
                ClassifierDescriptorWithTypeParameters containingClass = classifierDescriptorWithTypeParameters;
                if (!DescriptorUtils.isAnnotationClass(containingClass)) {
                    ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                    this.report(parametrizedDiagnostic, ctxt);
                }
            }
        } else if (owner instanceof KtFunction) {
            boolean anonymous;
            boolean bl = anonymous = owner instanceof KtFunctionLiteral || owner instanceof KtNamedFunction && ((KtNamedFunction)owner).getName() == null;
            if (anonymous && !this.languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) {
                return;
            }
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(bindingContext, this.languageVersionSettings);
            boolean isMain = owner instanceof KtNamedFunction && MainFunctionDetector.isMain$default(mainFunctionDetector, (KtNamedFunction)owner, false, false, 6, null);
            Name name2 = functionDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
            Name functionName = name2;
            if (isMain) {
                if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    return;
                }
                if (!this.languageVersionSettings.supportsFeature(LanguageFeature.WarningOnMainUnusedParameter)) {
                    if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)owner) == null) {
                        this.trace.record(BindingContext.UNUSED_MAIN_PARAMETER, element);
                    }
                    return;
                }
                if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)owner) != null) {
                    return;
                }
            }
            if (functionDescriptor.isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(functionName)) {
                return;
            }
            if (ModalityUtilsKt.isOverridableOrOverrides(functionDescriptor) || ((KtFunction)owner).hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                return;
            }
            if (anonymous) {
                ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_ANONYMOUS_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            } else {
                ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                this.report(parametrizedDiagnostic, ctxt);
            }
        } else if (owner instanceof KtPropertyAccessor) {
            ParametrizedDiagnostic<KtParameter> parametrizedDiagnostic = Errors.UNUSED_PARAMETER.on((KtParameter)((PsiElement)element), variableDescriptor);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            this.report(parametrizedDiagnostic, ctxt);
        }
    }

    private final void markUnusedExpressions() {
        HashMap reportedDiagnosticMap = new HashMap();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, arg_0 -> ControlFlowInformationProviderImpl.markUnusedExpressions$lambda$11(this, reportedDiagnosticMap, arg_0));
    }

    private final void markStatements() {
        PseudocodeTraverserKt.traverseIncludingDeadCode(this.pseudocode, arg_0 -> ControlFlowInformationProviderImpl.markStatements$lambda$12(this, arg_0));
    }

    private final void recordUsedAsExpression(KtExpression $this$recordUsedAsExpression) {
        BindingContextUtilsKt.recordUsedAsExpression($this$recordUsedAsExpression, this.trace, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void markAnnotationArguments() {
        if (this.subroutine.getContainingKtFile().isCompiled()) {
            return;
        }
        if (this.subroutine instanceof KtAnnotationEntry) {
            this.markAnnotationArguments((KtAnnotationEntry)this.subroutine);
        } else {
            PsiElement[] psiElementArray = this.subroutine.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            Object[] $this$forEach$iv = psiElementArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEachDescendantOfType$iv;
                PsiElement child = (PsiElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(child);
                PsiElement psiElement = child;
                Function1<KtAnnotationEntry, Unit> action$iv = arg_0 -> ControlFlowInformationProviderImpl.markAnnotationArguments$lambda$15$lambda$14(this, arg_0);
                boolean $i$f$forEachDescendantOfType = false;
                PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv);
                $this$forEachDescendantOfType$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(PsiElement element) {
                        Intrinsics.checkNotNullParameter(element, "element");
                        PsiElement it = element;
                        boolean bl = false;
                        if (!(it instanceof KtDeclaration) || it instanceof KtParameter) {
                            super.visitElement(element);
                        }
                        if (element instanceof KtAnnotationEntry) {
                            this.$action.invoke(element);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markAnnotationArguments(KtAnnotationEntry entry) {
        for (ValueArgument valueArgument : entry.getValueArguments()) {
            void $this$forEachDescendantOfType$iv;
            KtExpression ktExpression = valueArgument.getArgumentExpression();
            if (ktExpression == null) continue;
            PsiElement psiElement = ktExpression;
            Function1<KtExpression, Unit> action$iv = arg_0 -> ControlFlowInformationProviderImpl.markAnnotationArguments$lambda$16(this, arg_0);
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
        }
    }

    private final void checkIfExpressions() {
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, arg_0 -> ControlFlowInformationProviderImpl.checkIfExpressions$lambda$17(this, arg_0));
    }

    private final void checkImplicitCastOnConditionalExpression(KtExpression expression2) {
        List branchExpressions = ControlFlowInformationProviderImpl.Companion.collectResultingExpressionsOfConditionalExpression(expression2);
        KotlinType expectedExpressionType = (KotlinType)this.trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2);
        if (expectedExpressionType != null && expectedExpressionType != TypeUtils.DONT_CARE) {
            return;
        }
        KotlinType kotlinType = this.trace.getType(expression2);
        if (kotlinType == null) {
            return;
        }
        KotlinType expressionType = kotlinType;
        if (KotlinBuiltIns.isAnyOrNullableAny(expressionType)) {
            KotlinType branchType;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            boolean isUsedAsResultOfLambda = BindingContextUtilsKt.isUsedAsResultOfLambda(expression2, bindingContext);
            for (KtExpression branchExpression : branchExpressions) {
                if (this.trace.getType(branchExpression) == null) {
                    return;
                }
                if (!KotlinBuiltIns.isAnyOrNullableAny(branchType) && (!isUsedAsResultOfLambda || !KotlinBuiltIns.isUnitOrNullableUnit(branchType))) continue;
                return;
            }
            for (KtExpression branchExpression : branchExpressions) {
                if (this.trace.getType(branchExpression) == null || KotlinBuiltIns.isNothing(branchType)) continue;
                this.trace.report(Errors.IMPLICIT_CAST_TO_ANY.on((KtExpression)((PsiElement)ControlFlowInformationProviderImpl.Companion.getResultingExpression(branchExpression)), branchType, expressionType));
            }
        }
    }

    private final void checkWhenExpressions() {
        Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> initializers = this.getPseudocodeVariablesData().getVariableInitializers();
        PseudocodeTraverserKt.traverse(this.pseudocode, TraversalOrder.FORWARD, arg_0 -> ControlFlowInformationProviderImpl.checkWhenExpressions$lambda$21(initializers, this, arg_0));
    }

    private final void checkWhenStatement(KotlinType subjectType, KtWhenExpression element, BindingContext context) {
        List<WhenMissingCase> sealedMissingCases;
        ClassDescriptor sealedClassDescriptor;
        List<WhenMissingCase> enumMissingCases;
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType);
        if (enumClassDescriptor != null && !((Collection)(enumMissingCases = WhenChecker.getEnumMissingCases(element, context, enumClassDescriptor))).isEmpty()) {
            this.trace.report(Errors.NON_EXHAUSTIVE_WHEN.on((KtWhenExpression)((PsiElement)element), enumMissingCases));
        }
        if ((sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed(subjectType)) != null && !((Collection)(sealedMissingCases = WhenChecker.getSealedMissingCases(element, context, sealedClassDescriptor))).isEmpty()) {
            this.trace.report(Errors.NON_EXHAUSTIVE_WHEN_ON_SEALED_CLASS.on((KtWhenExpression)((PsiElement)element), sealedMissingCases));
        }
    }

    private final void checkExhaustiveWhenStatement(KotlinType subjectType, KtWhenExpression element, List<? extends WhenMissingCase> missingCases) {
        AlgebraicTypeKind kind;
        AlgebraicTypeKind algebraicTypeKind;
        if (missingCases.isEmpty()) {
            return;
        }
        if (WhenChecker.getClassDescriptorOfTypeIfSealed(subjectType) != null) {
            algebraicTypeKind = AlgebraicTypeKind.Sealed;
        } else if (WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType) != null) {
            algebraicTypeKind = AlgebraicTypeKind.Enum;
        } else {
            KotlinType kotlinType = subjectType;
            algebraicTypeKind = kind = (kotlinType != null ? TypeUtilsKt.isBooleanOrNullableBoolean(kotlinType) : false) ? AlgebraicTypeKind.Boolean : null;
        }
        if (kind != null) {
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonExhaustiveWhenOnAlgebraicTypes)) {
                this.trace.report(Errors.NO_ELSE_IN_WHEN.on((KtWhenExpression)((PsiElement)element), missingCases));
            } else {
                this.trace.report(Errors.NON_EXHAUSTIVE_WHEN_STATEMENT.on((KtWhenExpression)((PsiElement)element), kind.getDisplayName(), missingCases));
            }
        }
    }

    private final void checkConstructorConsistency() {
        KtElement ktElement = this.subroutine;
        if (ktElement instanceof KtClassOrObject) {
            ConstructorConsistencyChecker.Companion.check((KtClassOrObject)this.subroutine, this.trace, this.pseudocode, this.getPseudocodeVariablesData());
        } else if (ktElement instanceof KtSecondaryConstructor) {
            ConstructorConsistencyChecker.Companion.check((KtSecondaryConstructor)this.subroutine, this.trace, this.pseudocode, this.getPseudocodeVariablesData());
        }
    }

    private final void markAndCheckTailCalls() {
        DeclarationDescriptor declarationDescriptor = this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.subroutine);
        FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor subroutineDescriptor = functionDescriptor;
        this.markAndCheckRecursiveTailCalls(subroutineDescriptor);
    }

    private final void markAndCheckRecursiveTailCalls(FunctionDescriptor subroutineDescriptor) {
        if (!subroutineDescriptor.isTailrec()) {
            return;
        }
        if (this.subroutine instanceof KtNamedFunction && !((KtNamedFunction)this.subroutine).hasBody()) {
            return;
        }
        HashMap calls = new HashMap();
        ControlFlowInformationProviderImpl this_$iv = this;
        boolean $i$f$traverseCalls = false;
        PseudocodeTraverserKt.traverse(this_$iv.pseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, Unit>)new Function1<Instruction, Unit>(subroutineDescriptor, this, calls){
            final /* synthetic */ FunctionDescriptor $subroutineDescriptor$inlined;
            final /* synthetic */ ControlFlowInformationProviderImpl this$0;
            final /* synthetic */ HashMap $calls$inlined;
            {
                this.$subroutineDescriptor$inlined = functionDescriptor;
                this.this$0 = controlFlowInformationProviderImpl;
                this.$calls$inlined = hashMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Instruction instruction) {
                void resolvedCall2;
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                if (!(instruction instanceof CallInstruction)) {
                    return;
                }
                ResolvedCall<?> resolvedCall3 = ((CallInstruction)instruction).getResolvedCall();
                CallInstruction instruction2 = (CallInstruction)instruction;
                boolean bl = false;
                D d = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
                D functionDescriptor = d;
                if (Intrinsics.areEqual(functionDescriptor.getOriginal(), this.$subroutineDescriptor$inlined) && (resolvedCall2.getCall().getValueArguments().size() == functionDescriptor.getValueParameters().size() || functionDescriptor.getOverriddenDescriptors().isEmpty())) {
                    KtElement element = instruction2.getElement();
                    if (ControlFlowInformationProviderImpl.access$isInsideTry(this.this$0, element)) {
                        ((Map)this.$calls$inlined).put(element, TailRecursionKind.IN_TRY);
                    } else {
                        BindingContext bindingContext = ControlFlowInformationProviderImpl.access$getTrace$p(this.this$0).getBindingContext();
                        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                        boolean sameDispatchReceiver = ResolvedCallUtilKt.hasThisOrNoDispatchReceiver(resolvedCall2, bindingContext);
                        TailRecursionKind kind = sameDispatchReceiver && ControlFlowInformationProviderImpl.isTailCall$default(this.this$0, instruction2, null, 1, null) ? TailRecursionKind.TAIL_CALL : TailRecursionKind.NON_TAIL;
                        TailRecursionKind kindAndCall = (TailRecursionKind)((Object)this.$calls$inlined.get(element));
                        ((Map)this.$calls$inlined).put(element, org.jetbrains.kotlin.cfg.ControlFlowInformationProviderImpl$Companion.access$combineKinds(ControlFlowInformationProviderImpl.Companion, kind, kindAndCall));
                    }
                }
            }
        });
        boolean hasTailCalls = false;
        block5: for (Map.Entry entry : ((Map)calls).entrySet()) {
            KtElement element = (KtElement)entry.getKey();
            TailRecursionKind kind = (TailRecursionKind)((Object)entry.getValue());
            switch (WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
                case 1: {
                    hasTailCalls = true;
                    continue block5;
                }
                case 2: {
                    this.trace.report(Errors.TAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED.on(element));
                    continue block5;
                }
                case 3: {
                    this.trace.report(Errors.NON_TAIL_RECURSIVE_CALL.on(element));
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!hasTailCalls && this.subroutine instanceof KtNamedFunction) {
            this.trace.report(Errors.NO_TAIL_CALLS_FOUND.on((KtNamedFunction)this.subroutine));
        }
    }

    private final boolean isInsideTry(KtElement element) {
        Class[] classArray = new Class[]{KtTryExpression.class, KtFunction.class, KtAnonymousInitializer.class};
        return PsiTreeUtil.getParentOfType((PsiElement)element, classArray) instanceof KtTryExpression;
    }

    private final boolean isTailCall(CallInstruction $this$isTailCall, KtElement subroutine) {
        TailInstructionDetector tailInstructionDetector = new TailInstructionDetector(subroutine);
        return PseudocodeTraverserKt.traverseFollowingInstructions($this$isTailCall, new HashSet(), TraversalOrder.FORWARD, arg_0 -> ControlFlowInformationProviderImpl.isTailCall$lambda$23($this$isTailCall, tailInstructionDetector, arg_0));
    }

    static /* synthetic */ boolean isTailCall$default(ControlFlowInformationProviderImpl controlFlowInformationProviderImpl, CallInstruction callInstruction, KtElement ktElement, int n, Object object) {
        if ((n & 1) != 0) {
            ktElement = controlFlowInformationProviderImpl.subroutine;
        }
        return controlFlowInformationProviderImpl.isTailCall(callInstruction, ktElement);
    }

    private final void report(Diagnostic diagnostic, VariableContext ctxt) {
        Instruction instruction = ctxt.getInstruction$cfg();
        if (instruction.getCopies().isEmpty()) {
            this.trace.report(diagnostic);
            return;
        }
        Map<Instruction, DiagnosticFactory<?>> previouslyReported = ctxt.getReportedDiagnosticMap$cfg();
        previouslyReported.put(instruction, diagnostic.getFactory());
        boolean alreadyReported = false;
        boolean sameErrorForAllCopies = true;
        for (Instruction copy : instruction.getCopies()) {
            DiagnosticFactory<?> previouslyReportedErrorFactory = previouslyReported.get(copy);
            if (previouslyReportedErrorFactory != null) {
                alreadyReported = true;
            }
            if (previouslyReportedErrorFactory == diagnostic.getFactory()) continue;
            sameErrorForAllCopies = false;
        }
        if (ControlFlowInformationProviderImpl.Companion.mustBeReportedOnAllCopies(diagnostic.getFactory())) {
            if (sameErrorForAllCopies) {
                this.trace.report(diagnostic);
            }
        } else if (!alreadyReported) {
            this.trace.report(diagnostic);
        }
    }

    private final PsiElement getDeparenthesizedParent(PsiElement $this$deparenthesizedParent) {
        PsiElement result2 = $this$deparenthesizedParent.getParent();
        while (result2 instanceof KtParenthesizedExpression || result2 instanceof KtLabeledExpression || result2 instanceof KtAnnotatedExpression) {
            result2 = ((KtExpressionImpl)result2).getParent();
        }
        PsiElement psiElement = result2;
        Intrinsics.checkNotNull(psiElement);
        return psiElement;
    }

    private static final PseudocodeVariablesData pseudocodeVariablesData_delegate$lambda$0(ControlFlowInformationProviderImpl this$0) {
        Pseudocode pseudocode = this$0.pseudocode;
        BindingContext bindingContext = this$0.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        return new PseudocodeVariablesData(pseudocode, bindingContext);
    }

    private static final Unit markUninitializedVariables$lambda$1(ControlFlowInformationProviderImpl this$0, HashMap $reportedDiagnosticMap, BlockScopeVariableInfo $blockScopeVariableInfo, Set $declaredVariables, HashSet $varWithUninitializedErrorGenerated, HashSet $varWithValReassignErrorGenerated, boolean $processClassOrObject, Instruction instruction, VariableInitReadOnlyControlFlowInfo enterData, VariableInitReadOnlyControlFlowInfo exitData) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        Intrinsics.checkNotNullParameter(enterData, "enterData");
        Intrinsics.checkNotNullParameter(exitData, "exitData");
        VariableInitContext ctxt = this$0.new VariableInitContext(instruction, $reportedDiagnosticMap, enterData, exitData, $blockScopeVariableInfo);
        if (ctxt.getVariableDescriptor$cfg() == null) {
            return Unit.INSTANCE;
        }
        if (instruction instanceof ReadValueInstruction) {
            KtElement element = ((ReadValueInstruction)instruction).getElement();
            if (PseudocodeUtil.isThisOrNoDispatchReceiver((AccessValueInstruction)instruction, this$0.trace.getBindingContext()) && $declaredVariables.contains(ctxt.getVariableDescriptor$cfg())) {
                this$0.checkIsInitialized(ctxt, element, $varWithUninitializedErrorGenerated);
            }
            return Unit.INSTANCE;
        }
        if (!(instruction instanceof WriteValueInstruction)) {
            return Unit.INSTANCE;
        }
        KtElement ktElement = ((WriteValueInstruction)instruction).getLValue();
        KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression element = ktExpression;
        boolean error = this$0.checkValReassignment(ctxt, element, (WriteValueInstruction)instruction, $varWithValReassignErrorGenerated);
        if (!error && $processClassOrObject) {
            error = this$0.checkAssignmentBeforeDeclaration(ctxt, element);
        }
        if (!error && $processClassOrObject) {
            this$0.checkInitializationForCustomSetter(ctxt, element);
        }
        return Unit.INSTANCE;
    }

    private static final boolean reportVisibilityWarningForInternalFakeSetterOverride$lambda$7(CallableMemberDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getKind().isReal();
    }

    private static final Unit markUnusedVariables$lambda$8(ControlFlowInformationProviderImpl this$0, HashMap $reportedDiagnosticMap, HashMap $unusedValueExpressions, HashSet $usedValueExpressions, Instruction instruction, ReadOnlyControlFlowInfo enterData, ReadOnlyControlFlowInfo readOnlyControlFlowInfo) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        Intrinsics.checkNotNullParameter(enterData, "enterData");
        Intrinsics.checkNotNullParameter(readOnlyControlFlowInfo, "<unused var>");
        VariableUseContext ctxt = this$0.new VariableUseContext(instruction, $reportedDiagnosticMap);
        Set<VariableDescriptor> declaredVariables = this$0.getPseudocodeVariablesData().getDeclaredVariables(instruction.getOwner(), false);
        VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, this$0.trace.getBindingContext());
        if (variableDescriptor == null || !declaredVariables.contains(variableDescriptor) || !ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), variableDescriptor)) {
            return Unit.INSTANCE;
        }
        VariableUseState variableUseState = (VariableUseState)((Object)enterData.getOrNull(variableDescriptor));
        Instruction instruction2 = instruction;
        if (instruction2 instanceof WriteValueInstruction) {
            if (this$0.trace.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null) {
                return Unit.INSTANCE;
            }
            KtElement ktElement = ((WriteValueInstruction)instruction).getElement();
            KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
            if (ktExpression == null) {
                return Unit.INSTANCE;
            }
            KtExpression expressionInQuestion = ktExpression;
            if (variableUseState != VariableUseState.READ) {
                ((Map)$unusedValueExpressions).put(expressionInQuestion, TuplesKt.to(variableDescriptor, ctxt));
            } else {
                $usedValueExpressions.add(expressionInQuestion);
            }
        } else if (instruction2 instanceof VariableDeclarationInstruction) {
            KtDeclaration ktDeclaration = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
            KtNamedDeclaration ktNamedDeclaration = ktDeclaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktDeclaration : null;
            if (ktNamedDeclaration == null) {
                return Unit.INSTANCE;
            }
            KtNamedDeclaration element = ktNamedDeclaration;
            this$0.processUnusedDeclaration(element, variableDescriptor, ctxt, variableUseState);
        }
        return Unit.INSTANCE;
    }

    private static final Unit markUnusedExpressions$lambda$11(ControlFlowInformationProviderImpl this$0, HashMap $reportedDiagnosticMap, Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        if (!(instruction instanceof KtElementInstruction)) {
            return Unit.INSTANCE;
        }
        KtElement ktElement = ((KtElementInstruction)instruction).getElement();
        KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression element = ktExpression;
        BindingContext bindingContext = this$0.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        if (BindingContextUtilsKt.isUsedAsStatement(element, bindingContext) && PseudocodeUtilsKt.getSideEffectFree(instruction)) {
            SimpleDiagnostic<KtElement> simpleDiagnostic;
            VariableContext context = this$0.new VariableContext(instruction, $reportedDiagnosticMap);
            if (element instanceof KtLambdaExpression) {
                SimpleDiagnostic<KtLambdaExpression> simpleDiagnostic2 = Errors.UNUSED_LAMBDA_EXPRESSION.on((KtLambdaExpression)element);
                simpleDiagnostic = simpleDiagnostic2;
                Intrinsics.checkNotNullExpressionValue(simpleDiagnostic2, "on(...)");
            } else {
                SimpleDiagnostic<KtElement> simpleDiagnostic3 = Errors.UNUSED_EXPRESSION.on((KtElement)((PsiElement)element));
                simpleDiagnostic = simpleDiagnostic3;
                Intrinsics.checkNotNullExpressionValue(simpleDiagnostic3, "on(...)");
            }
            this$0.report(simpleDiagnostic, context);
        }
        return Unit.INSTANCE;
    }

    private static final Unit markStatements$lambda$12(ControlFlowInformationProviderImpl this$0, Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
        PseudoValue value2 = instructionWithValue != null ? instructionWithValue.getOutputValue() : null;
        Pseudocode pseudocode = instruction.getOwner();
        List<Instruction> usages = pseudocode.getUsages(value2);
        boolean isUsedAsExpression = !((Collection)usages).isEmpty();
        boolean isUsedAsResultOfLambda = ControlFlowInformationProviderImpl.Companion.isUsedAsResultOfLambda(usages);
        for (KtElement element : pseudocode.getValueElements(value2)) {
            BindingContextUtilsKt.recordUsedAsExpression(element, this$0.trace, isUsedAsExpression);
            this$0.trace.record(BindingContext.USED_AS_RESULT_OF_LAMBDA, element, isUsedAsResultOfLambda);
            if (!isUsedAsExpression) continue;
            KtElement ktElement = element;
            if (ktElement instanceof KtTryExpression) {
                KtBlockExpression ktBlockExpression = ((KtTryExpression)element).getTryBlock();
                Intrinsics.checkNotNullExpressionValue(ktBlockExpression, "getTryBlock(...)");
                this$0.recordUsedAsExpression(ktBlockExpression);
                for (KtCatchClause ktCatchClause : ((KtTryExpression)element).getCatchClauses()) {
                    KtExpression ktExpression = ktCatchClause.getCatchBody();
                    if (ktExpression == null) continue;
                    this$0.recordUsedAsExpression(ktExpression);
                }
                continue;
            }
            if (ktElement instanceof KtIfExpression) {
                KtExpression ktExpression = ((KtIfExpression)element).getThen();
                KtBlockExpression ktBlockExpression = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
                if (ktBlockExpression != null) {
                    this$0.recordUsedAsExpression(ktBlockExpression);
                }
                KtExpression ktExpression2 = ((KtIfExpression)element).getElse();
                KtBlockExpression ktBlockExpression2 = ktExpression2 instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null;
                if (ktBlockExpression2 != null) {
                    this$0.recordUsedAsExpression(ktBlockExpression2);
                }
                continue;
            }
            if (!(ktElement instanceof KtWhenExpression)) continue;
            for (KtWhenEntry ktWhenEntry : ((KtWhenExpression)element).getEntries()) {
                KtExpression ktExpression = ktWhenEntry.getExpression();
                KtBlockExpression ktBlockExpression = ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
                if (ktBlockExpression == null) continue;
                this$0.recordUsedAsExpression(ktBlockExpression);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit markAnnotationArguments$lambda$15$lambda$14(ControlFlowInformationProviderImpl this$0, KtAnnotationEntry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.markAnnotationArguments(it);
        return Unit.INSTANCE;
    }

    private static final Unit markAnnotationArguments$lambda$16(ControlFlowInformationProviderImpl this$0, KtExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        BindingContextUtilsKt.recordUsedAsExpression(it, this$0.trace, true);
        return Unit.INSTANCE;
    }

    private static final Unit checkIfExpressions$lambda$17(ControlFlowInformationProviderImpl this$0, Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
        PseudoValue value2 = instructionWithValue != null ? instructionWithValue.getOutputValue() : null;
        for (KtElement element : instruction.getOwner().getValueElements(value2)) {
            PsiElement parent2;
            if (!(element instanceof KtIfExpression)) continue;
            KtExpression thenExpression = ((KtIfExpression)element).getThen();
            KtExpression elseExpression = ((KtIfExpression)element).getElse();
            boolean isEhxaustive = thenExpression != null && elseExpression != null;
            BindingContext bindingContext = this$0.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            if (BindingContextUtilsKt.isUsedAsExpression(element, bindingContext)) {
                if (!isEhxaustive) {
                    this$0.trace.report(Errors.INVALID_IF_AS_EXPRESSION.on(((KtIfExpression)element).getIfKeyword()));
                    continue;
                }
                this$0.checkImplicitCastOnConditionalExpression((KtExpression)element);
                continue;
            }
            if (this$0.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonExhaustiveIfInRhsOfElvis) || isEhxaustive || !((parent2 = this$0.getDeparenthesizedParent(element)) instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.ELVIS) continue;
            this$0.trace.report(Errors.INVALID_IF_AS_EXPRESSION_WARNING.on(((KtIfExpression)element).getIfKeyword()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit checkWhenExpressions$lambda$21(Map $initializers, ControlFlowInformationProviderImpl this$0, Instruction instruction) {
        Instruction next;
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        if (instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getKind() == MagicKind.EXHAUSTIVE_WHEN_ELSE && (next = ((MagicInstruction)instruction).getNext()) instanceof MergeInstruction) {
            VariableInitReadOnlyControlFlowInfo magicInfo;
            Edges edges = (Edges)$initializers.get(next);
            VariableInitReadOnlyControlFlowInfo mergeInfo = edges != null ? (VariableInitReadOnlyControlFlowInfo)edges.getIncoming() : null;
            Edges edges2 = (Edges)$initializers.get(instruction);
            VariableInitReadOnlyControlFlowInfo variableInitReadOnlyControlFlowInfo = magicInfo = edges2 != null ? (VariableInitReadOnlyControlFlowInfo)edges2.getOutgoing() : null;
            if (mergeInfo != null && magicInfo != null && ((MergeInstruction)next).getElement() instanceof KtWhenExpression && magicInfo.checkDefiniteInitializationInWhen(mergeInfo)) {
                this$0.trace.record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, ((MergeInstruction)next).getElement());
            }
        }
        InstructionWithValue instructionWithValue = instruction instanceof InstructionWithValue ? (InstructionWithValue)instruction : null;
        PseudoValue value2 = instructionWithValue != null ? instructionWithValue.getOutputValue() : null;
        for (KtElement element : instruction.getOwner().getValueElements(value2)) {
            PsiElement parent2;
            Object v6;
            List<WhenMissingCase> missingCases;
            BindingContext context;
            boolean usedAsExpression;
            block17: {
                if (!(element instanceof KtWhenExpression)) continue;
                BindingContext bindingContext = this$0.trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                usedAsExpression = BindingContextUtilsKt.isUsedAsExpression(element, bindingContext);
                if (usedAsExpression) {
                    this$0.checkImplicitCastOnConditionalExpression((KtExpression)element);
                }
                Intrinsics.checkNotNullExpressionValue(this$0.trace.getBindingContext(), "getBindingContext(...)");
                missingCases = WhenChecker.INSTANCE.getMissingCases((KtWhenExpression)element, context);
                List<KtWhenEntry> list = ((KtWhenExpression)element).getEntries();
                Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    KtWhenEntry it = (KtWhenEntry)t;
                    boolean bl = false;
                    if (!it.isElse()) continue;
                    v6 = t;
                    break block17;
                }
                v6 = null;
            }
            KtWhenEntry elseEntry = v6;
            KtExpression subjectExpression = ((KtWhenExpression)element).getSubjectExpression();
            if (usedAsExpression && !((Collection)missingCases).isEmpty()) {
                Object v7;
                block18: {
                    if (elseEntry != null) continue;
                    this$0.trace.report(Errors.NO_ELSE_IN_WHEN.on((KtWhenExpression)element, missingCases));
                    Iterable $this$firstOrNull$iv = missingCases;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        WhenMissingCase it = (WhenMissingCase)element$iv;
                        boolean bl = false;
                        if (!(it instanceof WhenMissingCase.ConditionTypeIsExpect)) continue;
                        v7 = element$iv;
                        break block18;
                    }
                    v7 = null;
                }
                if ((WhenMissingCase)v7 != null) {
                    WhenMissingCase it;
                    boolean bl = false;
                    if (!(it instanceof WhenMissingCase.ConditionTypeIsExpect)) {
                        String string2 = "Failed requirement.";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this$0.trace.report(Errors.EXPECT_TYPE_IN_WHEN_WITHOUT_ELSE.on((KtWhenExpression)element, ((WhenMissingCase.ConditionTypeIsExpect)it).getTypeOfDeclaration()));
                }
            } else if (subjectExpression != null) {
                KtWhenExpression ktWhenExpression = (KtWhenExpression)element;
                BindingContext bindingContext = this$0.trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                KotlinType subjectType = WhenChecker.whenSubjectType(ktWhenExpression, bindingContext);
                if (elseEntry != null) {
                    if (!missingCases.isEmpty() || subjectType == null || FlexibleTypesKt.isFlexible(subjectType)) continue;
                    ClassifierDescriptor it = subjectType.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor subjectClass = it instanceof ClassDescriptor ? (ClassDescriptor)it : null;
                    KtElement pseudocodeElement = instruction.getOwner().getCorrespondingElement();
                    DeclarationDescriptor pseudocodeDescriptor = this$0.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, pseudocodeElement);
                    if (subjectClass != null && !KotlinBuiltIns.isBooleanOrNullableBoolean(subjectType)) {
                        DeclarationDescriptor declarationDescriptor = pseudocodeDescriptor;
                        if (!Intrinsics.areEqual(DescriptorUtilsKt.getModule(subjectClass), declarationDescriptor != null ? DescriptorUtilsKt.getModule(declarationDescriptor) : null)) continue;
                    }
                    this$0.trace.report(Errors.REDUNDANT_ELSE_IN_WHEN.on((KtWhenEntry)((PsiElement)elseEntry)));
                    continue;
                }
                EnumWhenTracker enumWhenTracker = this$0.enumWhenTracker;
                if (enumWhenTracker != null) {
                    IncrementalTrackerUtilKt.record(enumWhenTracker, subjectType, subjectExpression, elseEntry);
                }
                if (!usedAsExpression) {
                    if (this$0.languageVersionSettings.supportsFeature(LanguageFeature.WarnAboutNonExhaustiveWhenOnAlgebraicTypes)) {
                        this$0.checkExhaustiveWhenStatement(subjectType, (KtWhenExpression)element, missingCases);
                    } else {
                        this$0.checkWhenStatement(subjectType, (KtWhenExpression)element, context);
                    }
                }
            }
            if (usedAsExpression || !(!((Collection)missingCases).isEmpty()) || elseEntry != null || this$0.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonExhaustiveIfInRhsOfElvis) || !((parent2 = this$0.getDeparenthesizedParent(element)) instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.ELVIS) continue;
            this$0.trace.report(Errors.NO_ELSE_IN_WHEN_WARNING.on((KtWhenExpression)element, missingCases));
        }
        return Unit.INSTANCE;
    }

    private static final TraverseInstructionResult isTailCall$lambda$23(CallInstruction $this_isTailCall, TailInstructionDetector $tailInstructionDetector, Instruction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $this_isTailCall) || (Boolean)it.accept($tailInstructionDetector) != false ? TraverseInstructionResult.CONTINUE : TraverseInstructionResult.HALT;
    }

    public static final /* synthetic */ boolean access$isInsideTry(ControlFlowInformationProviderImpl $this, KtElement element) {
        return $this.isInsideTry(element);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$AlgebraicTypeKind;", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "Sealed", "Enum", "Boolean", "cfg"})
    private static final class AlgebraicTypeKind
    extends Enum<AlgebraicTypeKind> {
        @NotNull
        private final String displayName;
        public static final /* enum */ AlgebraicTypeKind Sealed = new AlgebraicTypeKind("sealed class/interface");
        public static final /* enum */ AlgebraicTypeKind Enum = new AlgebraicTypeKind("enum");
        public static final /* enum */ AlgebraicTypeKind Boolean = new AlgebraicTypeKind("Boolean");
        private static final /* synthetic */ AlgebraicTypeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AlgebraicTypeKind(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static AlgebraicTypeKind[] values() {
            return (AlgebraicTypeKind[])$VALUES.clone();
        }

        public static AlgebraicTypeKind valueOf(String value2) {
            return java.lang.Enum.valueOf(AlgebraicTypeKind.class, value2);
        }

        @NotNull
        public static EnumEntries<AlgebraicTypeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algebraicTypeKindArray = new AlgebraicTypeKind[]{AlgebraicTypeKind.Sealed, AlgebraicTypeKind.Enum, AlgebraicTypeKind.Boolean};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0002J\u0014\u0010\u001a\u001a\u00020\u00052\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$Companion;", "", "<init>", "()V", "isUsedAsResultOfLambda", "", "usages", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "collectResultingExpressionsOfConditionalExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "collectResultingExpressionsOfConditionalExpressionRec", "", "resultingExpressions", "", "getResultingExpression", "combineKinds", "Lorg/jetbrains/kotlin/cfg/TailRecursionKind;", "kind", "existingKind", "check", "a", "b", "x", "y", "mustBeReportedOnAllCopies", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "cfg"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUsedAsResultOfLambda(List<? extends Instruction> usages) {
            for (Instruction instruction : usages) {
                if (!(instruction instanceof ReturnValueInstruction)) continue;
                KtElement returnElement = ((ReturnValueInstruction)instruction).getElement();
                PsiElement parentElement = returnElement.getParent();
                if (returnElement instanceof KtReturnExpression || parentElement instanceof KtDeclaration && !(parentElement instanceof KtFunctionLiteral)) continue;
                return true;
            }
            return false;
        }

        private final List<KtExpression> collectResultingExpressionsOfConditionalExpression(KtExpression expression2) {
            ArrayList leafBranches = new ArrayList();
            this.collectResultingExpressionsOfConditionalExpressionRec(expression2, leafBranches);
            return leafBranches;
        }

        private final void collectResultingExpressionsOfConditionalExpressionRec(KtExpression expression2, List<KtExpression> resultingExpressions) {
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtIfExpression) {
                this.collectResultingExpressionsOfConditionalExpressionRec(((KtIfExpression)expression2).getThen(), resultingExpressions);
                this.collectResultingExpressionsOfConditionalExpressionRec(((KtIfExpression)expression2).getElse(), resultingExpressions);
            } else if (ktExpression instanceof KtWhenExpression) {
                for (KtWhenEntry whenEntry : ((KtWhenExpression)expression2).getEntries()) {
                    this.collectResultingExpressionsOfConditionalExpressionRec(whenEntry.getExpression(), resultingExpressions);
                }
            } else if (ktExpression instanceof Object) {
                KtExpression resultingExpression = this.getResultingExpression(expression2);
                if (resultingExpression instanceof KtIfExpression || resultingExpression instanceof KtWhenExpression) {
                    this.collectResultingExpressionsOfConditionalExpressionRec(resultingExpression, resultingExpressions);
                } else {
                    resultingExpressions.add(resultingExpression);
                }
            }
        }

        private final KtExpression getResultingExpression(KtExpression expression2) {
            KtExpression finger = expression2;
            while (true) {
                KtExpression deparenthesized = KtPsiUtil.deparenthesize(finger);
                if ((deparenthesized = KtPsiUtil.getExpressionOrLastStatementInBlock(deparenthesized)) == null || deparenthesized == finger) break;
                finger = deparenthesized;
            }
            return finger;
        }

        private final TailRecursionKind combineKinds(TailRecursionKind kind, TailRecursionKind existingKind) {
            return existingKind == null || existingKind == kind ? kind : (this.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.TAIL_CALL) ? TailRecursionKind.IN_TRY : (this.check((Object)kind, (Object)existingKind, (Object)TailRecursionKind.IN_TRY, (Object)TailRecursionKind.NON_TAIL) ? TailRecursionKind.IN_TRY : TailRecursionKind.NON_TAIL));
        }

        private final boolean check(Object a, Object b, Object x, Object y) {
            return a == x && b == y || a == y && b == x;
        }

        private final boolean mustBeReportedOnAllCopies(DiagnosticFactory<?> diagnosticFactory) {
            return diagnosticFactory == Errors.UNUSED_VARIABLE || diagnosticFactory == Errors.UNUSED_PARAMETER || diagnosticFactory == Errors.UNUSED_ANONYMOUS_PARAMETER || diagnosticFactory == Errors.UNUSED_CHANGED_VALUE;
        }

        public static final /* synthetic */ TailRecursionKind access$combineKinds(Companion $this, TailRecursionKind kind, TailRecursionKind existingKind) {
            return $this.combineKinds(kind, existingKind);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$Factory;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider$Factory;", "<init>", "()V", "createControlFlowInformationProvider", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "cfg"})
    public static final class Factory
    implements ControlFlowInformationProvider.Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        public ControlFlowInformationProvider createControlFlowInformationProvider(@NotNull KtElement declaration, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @NotNull EnumWhenTracker enumWhenTracker) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(diagnosticSuppressor, "diagnosticSuppressor");
            Intrinsics.checkNotNullParameter(enumWhenTracker, "enumWhenTracker");
            return new ControlFlowInformationProviderImpl(declaration, trace, languageVersionSettings, diagnosticSuppressor, enumWhenTracker);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$ReturnedExpressionsInfo;", "", "returnedExpressions", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "hasReturnsInInlinedLambda", "", "<init>", "(Ljava/util/Collection;Z)V", "getReturnedExpressions", "()Ljava/util/Collection;", "getHasReturnsInInlinedLambda", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "cfg"})
    private static final class ReturnedExpressionsInfo {
        @NotNull
        private final Collection<KtElement> returnedExpressions;
        private final boolean hasReturnsInInlinedLambda;

        public ReturnedExpressionsInfo(@NotNull Collection<? extends KtElement> returnedExpressions, boolean hasReturnsInInlinedLambda) {
            Intrinsics.checkNotNullParameter(returnedExpressions, "returnedExpressions");
            this.returnedExpressions = returnedExpressions;
            this.hasReturnsInInlinedLambda = hasReturnsInInlinedLambda;
        }

        @NotNull
        public final Collection<KtElement> getReturnedExpressions() {
            return this.returnedExpressions;
        }

        public final boolean getHasReturnsInInlinedLambda() {
            return this.hasReturnsInInlinedLambda;
        }

        @NotNull
        public final Collection<KtElement> component1() {
            return this.returnedExpressions;
        }

        public final boolean component2() {
            return this.hasReturnsInInlinedLambda;
        }

        @NotNull
        public final ReturnedExpressionsInfo copy(@NotNull Collection<? extends KtElement> returnedExpressions, boolean hasReturnsInInlinedLambda) {
            Intrinsics.checkNotNullParameter(returnedExpressions, "returnedExpressions");
            return new ReturnedExpressionsInfo(returnedExpressions, hasReturnsInInlinedLambda);
        }

        public static /* synthetic */ ReturnedExpressionsInfo copy$default(ReturnedExpressionsInfo returnedExpressionsInfo, Collection collection, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                collection = returnedExpressionsInfo.returnedExpressions;
            }
            if ((n & 2) != 0) {
                bl = returnedExpressionsInfo.hasReturnsInInlinedLambda;
            }
            return returnedExpressionsInfo.copy(collection, bl);
        }

        @NotNull
        public String toString() {
            return "ReturnedExpressionsInfo(returnedExpressions=" + this.returnedExpressions + ", hasReturnsInInlinedLambda=" + this.hasReturnsInInlinedLambda + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.returnedExpressions).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasReturnsInInlinedLambda);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReturnedExpressionsInfo)) {
                return false;
            }
            ReturnedExpressionsInfo returnedExpressionsInfo = (ReturnedExpressionsInfo)other;
            if (!Intrinsics.areEqual(this.returnedExpressions, returnedExpressionsInfo.returnedExpressions)) {
                return false;
            }
            return this.hasReturnsInInlinedLambda == returnedExpressionsInfo.hasReturnsInInlinedLambda;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0092\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "reportedDiagnosticMap", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "<init>", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;)V", "getInstruction$cfg", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getReportedDiagnosticMap$cfg", "()Ljava/util/Map;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getVariableDescriptor$cfg", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "cfg"})
    private class VariableContext {
        @NotNull
        private final Instruction instruction;
        @NotNull
        private final Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap;
        @Nullable
        private final VariableDescriptor variableDescriptor;

        public VariableContext(@NotNull Instruction instruction, Map<Instruction, DiagnosticFactory<?>> reportedDiagnosticMap) {
            Intrinsics.checkNotNullParameter(instruction, "instruction");
            Intrinsics.checkNotNullParameter(reportedDiagnosticMap, "reportedDiagnosticMap");
            this.instruction = instruction;
            this.reportedDiagnosticMap = reportedDiagnosticMap;
            this.variableDescriptor = PseudocodeUtil.extractVariableDescriptorFromReference(this.instruction, ControlFlowInformationProviderImpl.this.trace.getBindingContext());
        }

        @NotNull
        public final Instruction getInstruction$cfg() {
            return this.instruction;
        }

        @NotNull
        public final Map<Instruction, DiagnosticFactory<?>> getReportedDiagnosticMap$cfg() {
            return this.reportedDiagnosticMap;
        }

        @Nullable
        public final VariableDescriptor getVariableDescriptor$cfg() {
            return this.variableDescriptor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\tH\u0002R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableInitContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "map", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "in", "Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;", "out", "blockScopeVariableInfo", "Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "<init>", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;Lorg/jetbrains/kotlin/cfg/variable/VariableInitReadOnlyControlFlowInfo;Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;)V", "enterInitState", "Lorg/jetbrains/kotlin/cfg/variable/VariableControlFlowState;", "getEnterInitState$cfg", "()Lorg/jetbrains/kotlin/cfg/variable/VariableControlFlowState;", "exitInitState", "getExitInitState$cfg", "initialize", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "cfg"})
    private final class VariableInitContext
    extends VariableContext {
        @Nullable
        private final VariableControlFlowState enterInitState;
        @Nullable
        private final VariableControlFlowState exitInitState;

        public VariableInitContext(@NotNull Instruction instruction, @NotNull Map<Instruction, DiagnosticFactory<?>> map, @NotNull VariableInitReadOnlyControlFlowInfo in, @NotNull VariableInitReadOnlyControlFlowInfo out, BlockScopeVariableInfo blockScopeVariableInfo) {
            Intrinsics.checkNotNullParameter(instruction, "instruction");
            Intrinsics.checkNotNullParameter(map, "map");
            Intrinsics.checkNotNullParameter(in, "in");
            Intrinsics.checkNotNullParameter(out, "out");
            Intrinsics.checkNotNullParameter(blockScopeVariableInfo, "blockScopeVariableInfo");
            super(instruction, map);
            this.enterInitState = this.initialize(this.getVariableDescriptor$cfg(), blockScopeVariableInfo, in);
            this.exitInitState = this.initialize(this.getVariableDescriptor$cfg(), blockScopeVariableInfo, out);
        }

        @Nullable
        public final VariableControlFlowState getEnterInitState$cfg() {
            return this.enterInitState;
        }

        @Nullable
        public final VariableControlFlowState getExitInitState$cfg() {
            return this.exitInitState;
        }

        private final VariableControlFlowState initialize(VariableDescriptor variableDescriptor, BlockScopeVariableInfo blockScopeVariableInfo, VariableInitReadOnlyControlFlowInfo map) {
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            if (variableDescriptor2 == null) {
                return null;
            }
            VariableControlFlowState state = (VariableControlFlowState)map.getOrNull(variableDescriptor2);
            if (state != null) {
                return state;
            }
            return PseudocodeVariablesData.Companion.getDefaultValueForInitializers(variableDescriptor, this.getInstruction$cfg(), blockScopeVariableInfo);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableUseContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl$VariableContext;", "Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "map", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "<init>", "(Lorg/jetbrains/kotlin/cfg/ControlFlowInformationProviderImpl;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Ljava/util/Map;)V", "cfg"})
    private final class VariableUseContext
    extends VariableContext {
        public VariableUseContext(@NotNull Instruction instruction, Map<Instruction, DiagnosticFactory<?>> map) {
            Intrinsics.checkNotNullParameter(instruction, "instruction");
            Intrinsics.checkNotNullParameter(map, "map");
            super(instruction, map);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TailRecursionKind.values().length];
            try {
                nArray[TailRecursionKind.TAIL_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TailRecursionKind.IN_TRY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TailRecursionKind.NON_TAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

