/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.output;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.NoPermissionException;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aR\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042>\u0010\u0005\u001a:\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"writeAll", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputDir", "Ljava/io/File;", "report", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "sources", "output", "writeAllTo", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportOutputFiles", "", "cli"})
public final class OutputUtilsKt {
    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @Nullable Function2<? super List<? extends File>, ? super File, Unit> report2) {
        Intrinsics.checkNotNullParameter($this$writeAll, "<this>");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        for (OutputFile file2 : $this$writeAll.asList()) {
            List<File> sources = file2.getSourceFiles();
            File output = new File(outputDir, file2.getRelativePath());
            Function2<? super List<? extends File>, ? super File, Unit> function2 = report2;
            if (function2 != null) {
                function2.invoke(sources, output);
            }
            try {
                FileUtil.writeToFile(output, file2.asByteArray());
            }
            catch (FileNotFoundException e) {
                if (outputDir.isDirectory()) {
                    throw new NoPermissionException("error while writing " + output + " (Permission denied)", e);
                }
                throw e;
            }
        }
    }

    public static final void writeAllTo(@NotNull OutputFileCollection $this$writeAllTo, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter($this$writeAllTo, "<this>");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        OutputUtilsKt.writeAll($this$writeAllTo, outputDir, null);
    }

    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @NotNull MessageCollector messageCollector, boolean reportOutputFiles) {
        Intrinsics.checkNotNullParameter($this$writeAll, "<this>");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        try {
            if (!reportOutputFiles) {
                OutputUtilsKt.writeAllTo($this$writeAll, outputDir);
            } else {
                OutputUtilsKt.writeAll($this$writeAll, outputDir, (arg_0, arg_1) -> OutputUtilsKt.writeAll$lambda$0(messageCollector, arg_0, arg_1));
            }
        }
        catch (NoPermissionException e) {
            String string2 = e.getMessage();
            Intrinsics.checkNotNull(string2);
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, string2, null, 4, null);
        }
        catch (FileNotFoundException e) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "directory not found: " + outputDir, null, 4, null);
        }
    }

    private static final Unit writeAll$lambda$0(MessageCollector $messageCollector, List sources, File output) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        Intrinsics.checkNotNullParameter(output, "output");
        String string2 = OutputMessageUtil.formatOutputMessage(sources, output);
        Intrinsics.checkNotNullExpressionValue(string2, "formatOutputMessage(...)");
        MessageCollector.report$default($messageCollector, CompilerMessageSeverity.OUTPUT, string2, null, 4, null);
        return Unit.INSTANCE;
    }
}

