/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "<init>", "()V", "javaToKotlinNameMap", "", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class FirJavaAnnotationsChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirJavaAnnotationsChecker INSTANCE = new FirJavaAnnotationsChecker();
    @NotNull
    private static final Map<ClassId, ClassId> javaToKotlinNameMap;

    private FirJavaAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnnotation expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirArgumentList argumentList;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Object object = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        if (!Intrinsics.areEqual(object != null && (object = ((FirDeclaration)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null, KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        ConeKotlinType annotationType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(expression2.getAnnotationTypeRef()));
        Object object2 = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(annotationType);
        if (object2 == null || (object2 = ToSymbolUtilsKt.toClassSymbol((ConeClassLikeLookupTag)object2, context.getSession())) == null) {
            return;
        }
        Object classSymbol = object2;
        if (!(((FirBasedSymbol)classSymbol).getOrigin() instanceof FirDeclarationOrigin.Java)) {
            return;
        }
        ConeClassLikeLookupTag lookupTag = ((FirClassSymbol)classSymbol).toLookupTag();
        ClassId classId = javaToKotlinNameMap.get(lookupTag.getClassId());
        if (classId != null) {
            ClassId betterName = classId;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getDEPRECATED_JAVA_ANNOTATION(), (Object)betterName.asSingleFqName(), (DiagnosticContext)context, null, 16, null);
        }
        if (expression2 instanceof FirAnnotationCall && (argumentList = ((FirAnnotationCall)expression2).getArgumentList()) instanceof FirResolvedArgumentList) {
            Object object3 = ((FirResolvedArgumentList)argumentList).getOriginalArgumentList();
            if (object3 == null || (object3 = ((FirArgumentList)object3).getArguments()) == null) {
                return;
            }
            Object arguments = object3;
            Iterator iterator2 = arguments.iterator();
            while (iterator2.hasNext()) {
                FirExpression key = (FirExpression)iterator2.next();
                if (key instanceof FirWrappedArgumentExpression) continue;
                FirValueParameter firValueParameter = ((FirResolvedArgumentList)argumentList).getMapping().get(key);
                Name it = firValueParameter != null ? firValueParameter.getName() : null;
                boolean bl = false;
                boolean bl2 = it != null && !Intrinsics.areEqual(it, StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue());
                if (!bl2) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)key.getSource(), FirJvmErrors.INSTANCE.getPOSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget(), StandardClassIds.Annotations.INSTANCE.getTarget()), TuplesKt.to(JvmStandardClassIds.Annotations.Java.INSTANCE.getRetention(), StandardClassIds.Annotations.INSTANCE.getRetention()), TuplesKt.to(JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), StandardClassIds.Annotations.INSTANCE.getDeprecated()), TuplesKt.to(JvmStandardClassIds.Annotations.Java.INSTANCE.getDocumented(), StandardClassIds.Annotations.INSTANCE.getMustBeDocumented())};
        javaToKotlinNameMap = MapsKt.mapOf(pairArray);
    }
}

