/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.config.phaser.PhaserState;
import org.jetbrains.kotlin.config.phaser.SimpleNamedCompilerPhase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.dce.DceDumpNameCache;
import org.jetbrains.kotlin.ir.backend.js.dce.DceKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrIcClassModel;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragment;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.clean.ClassPostProcessor;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"optimizeProgramByIr", "", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "removeUnusedAssociatedObjects", "", "optimizeFragmentByJsAst", "fragment", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrProgramFragment;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "backend.js"})
@SourceDebugExtension(value={"SMAP\noptimizations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 optimizations.kt\norg/jetbrains/kotlin/ir/backend/js/OptimizationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1878#2,2:60\n1869#2,2:62\n1880#2:64\n1869#2,2:66\n1869#2:68\n1869#2,2:69\n1869#2,2:71\n1870#2:73\n1#3:65\n*S KotlinDebug\n*F\n+ 1 optimizations.kt\norg/jetbrains/kotlin/ir/backend/js/OptimizationsKt\n*L\n31#1:60,2\n32#1:62,2\n31#1:64\n53#1:66,2\n54#1:68\n55#1:69,2\n56#1:71,2\n54#1:73\n*E\n"})
public final class OptimizationsKt {
    public static final void optimizeProgramByIr(@NotNull Iterable<? extends IrModuleFragment> modules2, @NotNull JsIrBackendContext context, @NotNull ModuleKind moduleKind, boolean removeUnusedAssociatedObjects) {
        Intrinsics.checkNotNullParameter(modules2, "modules");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter((Object)moduleKind, "moduleKind");
        DceDumpNameCache dceDumpNameCache = new DceDumpNameCache();
        DceKt.eliminateDeadDeclarations(modules2, context, moduleKind, removeUnusedAssociatedObjects, dceDumpNameCache);
        PhaserState phaserState = new PhaserState(null, 0, 0, null, 15, null);
        Iterable $this$forEachIndexed$iv = JsLoweringPhasesKt.getOptimizationLoweringList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SimpleNamedCompilerPhase lowering = (SimpleNamedCompilerPhase)item$iv;
            boolean bl = false;
            Iterable<? extends IrModuleFragment> $this$forEach$iv = modules2;
            boolean $i$f$forEach = false;
            Iterator<? extends IrModuleFragment> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                IrModuleFragment element$iv;
                IrModuleFragment module2 = element$iv = iterator2.next();
                boolean bl2 = false;
                lowering.invoke(context.getPhaseConfig(), phaserState, (LoggingContext)context, module2);
            }
        }
    }

    public static final void optimizeFragmentByJsAst(@NotNull JsIrProgramFragment fragment, @NotNull JsStaticContext context) {
        JsName jsName;
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(context, "context");
        IrField irField = ((IrProperty)context.getBackendContext().getIntrinsics().getVoid().getOwner()).getBackingField();
        if (irField != null) {
            IrField p0 = irField;
            boolean bl = false;
            jsName = context.getNameForField(p0);
        } else {
            jsName = null;
        }
        JsName voidName = jsName;
        RecursiveJsVisitor optimizer2 = new RecursiveJsVisitor(voidName){
            final /* synthetic */ JsName $voidName;
            {
                this.$voidName = $voidName;
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter(x, "x");
                super.visitFunction(x);
                new FunctionPostProcessor(x, this.$voidName).apply();
            }

            public void visitClass(JsClass x) {
                Intrinsics.checkNotNullParameter(x, "x");
                super.visitClass(x);
                new ClassPostProcessor(x).apply();
            }
        };
        List<JsStatement> list = fragment.getDeclarations().getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            it.accept(optimizer2);
        }
        $this$forEach$iv = fragment.getClasses().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it;
            JsIrIcClassModel klass = (JsIrIcClassModel)element$iv;
            boolean bl = false;
            List<JsStatement> list2 = klass.getPostDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (JsStatement)element$iv2;
                boolean bl2 = false;
                it.accept(optimizer2);
            }
            List<JsStatement> list3 = klass.getPreDeclarationBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
            $this$forEach$iv2 = list3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (JsStatement)element$iv2;
                boolean bl3 = false;
                it.accept(optimizer2);
            }
        }
    }
}

