/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.overrides.CopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.overrides.IrUnimplementedOverridesStrategy;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"buildFakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "unimplementedOverridesStrategy", "Lorg/jetbrains/kotlin/ir/overrides/IrUnimplementedOverridesStrategy;", "makeExternal", "", "value", "", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nFakeOverrideBuilderStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOverrideBuilderStrategy.kt\norg/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
public final class FakeOverrideBuilderStrategyKt {
    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType, @NotNull IrOverridableMember member, @NotNull IrClass clazz, @NotNull IrUnimplementedOverridesStrategy unimplementedOverridesStrategy) {
        IrOverridableMember irOverridableMember;
        Intrinsics.checkNotNullParameter(superType, "superType");
        Intrinsics.checkNotNullParameter(member, "member");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(unimplementedOverridesStrategy, "unimplementedOverridesStrategy");
        if (!(superType instanceof IrSimpleType)) {
            boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$62 = false;
            String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$62 = "superType is " + superType + ", expected IrSimpleType";
            throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$62.toString());
        }
        IrClassifierSymbol classifier = ((IrSimpleType)superType).getClassifier();
        if (!(classifier instanceof IrClassSymbol)) {
            boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$72 = false;
            String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$72 = "superType classifier is not IrClassSymbol: " + classifier;
            throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$72.toString());
        }
        List<IrTypeParameter> typeParameters2 = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrClassSymbol)classifier).getOwner());
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType).getArguments();
        if (!(typeParameters2.size() == superArguments.size())) {
            boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$82 = false;
            String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$82 = "typeParameters = " + typeParameters2 + " size != typeArguments = " + superArguments + " size ";
            throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$82.toString());
        }
        Map substitutionMap = new LinkedHashMap();
        int n = ((Collection)typeParameters2).size();
        for (int i = 0; i < n; ++i) {
            IrTypeParameter tp = typeParameters2.get(i);
            IrTypeArgument ta = superArguments.get(i);
            if (!(ta instanceof IrTypeProjection)) {
                boolean $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$92 = false;
                String $i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$92 = "Unexpected super type argument: " + RenderIrElementKt.render$default(ta, null, 1, null) + " @ " + i;
                throw new IllegalArgumentException($i$a$-require-FakeOverrideBuilderStrategyKt$buildFakeOverrideMember$92.toString());
            }
            if (!(((IrTypeProjection)ta).getVariance() == Variance.INVARIANT)) {
                boolean bl = false;
                String string2 = "Unexpected variance in super type argument: " + (Object)((Object)((IrTypeProjection)ta).getVariance()) + " @" + i;
                throw new IllegalArgumentException(string2.toString());
            }
            substitutionMap.put(tp.getSymbol(), ((IrTypeProjection)ta).getType());
        }
        IrOverridableMember $this$buildFakeOverrideMember_u24lambda_u245 = irOverridableMember = new CopyIrTreeWithSymbolsForFakeOverrides(member, substitutionMap, clazz, unimplementedOverridesStrategy).copy();
        boolean bl = false;
        FakeOverrideBuilderStrategyKt.makeExternal($this$buildFakeOverrideMember_u24lambda_u245, clazz.isExternal());
        return irOverridableMember;
    }

    public static /* synthetic */ IrOverridableMember buildFakeOverrideMember$default(IrType irType, IrOverridableMember irOverridableMember, IrClass irClass, IrUnimplementedOverridesStrategy irUnimplementedOverridesStrategy, int n, Object object) {
        if ((n & 8) != 0) {
            irUnimplementedOverridesStrategy = IrUnimplementedOverridesStrategy.ProcessAsFakeOverrides.INSTANCE;
        }
        return FakeOverrideBuilderStrategyKt.buildFakeOverrideMember(irType, irOverridableMember, irClass, irUnimplementedOverridesStrategy);
    }

    private static final void makeExternal(IrOverridableMember $this$makeExternal, boolean value2) {
        IrOverridableMember irOverridableMember = $this$makeExternal;
        if (irOverridableMember instanceof IrSimpleFunction) {
            ((IrSimpleFunction)$this$makeExternal).setExternal(value2);
        } else if (irOverridableMember instanceof IrProperty) {
            ((IrProperty)$this$makeExternal).setExternal(value2);
            IrSimpleFunction irSimpleFunction = ((IrProperty)$this$makeExternal).getGetter();
            if (irSimpleFunction != null) {
                irSimpleFunction.setExternal(value2);
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)$this$makeExternal).getSetter();
            if (irSimpleFunction2 != null) {
                irSimpleFunction2.setExternal(value2);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

