/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public final class GrCharConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        GrExpression rValue;
        if (lType == null) {
            GrCharConverter.$$$reportNull$$$0(0);
        }
        if (rType == null) {
            GrCharConverter.$$$reportNull$$$0(1);
        }
        if (position == null) {
            GrCharConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GrCharConverter.$$$reportNull$$$0(3);
        }
        if (!PsiTypes.charType().equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(lType))) {
            return null;
        }
        if (PsiTypes.charType().equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(rType))) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isNumericType(rType)) {
            if (rType instanceof PsiPrimitiveType || TypesUtil.unboxPrimitiveTypeWrapper(rType) instanceof PsiPrimitiveType) {
                return PsiTypes.charType().equals((Object)lType) ? ConversionResult.OK : ConversionResult.ERROR;
            }
            return ConversionResult.ERROR;
        }
        if (context instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)context;
            rValue = assignmentExpression.getRValue();
        } else if (context instanceof GrVariable) {
            GrVariable assignmentExpression = (GrVariable)context;
            rValue = assignmentExpression.getInitializerGroovy();
        } else {
            rValue = null;
        }
        if (rValue instanceof GrListOrMap && ((GrListOrMap)rValue).isEmpty()) {
            return ConversionResult.WARNING;
        }
        if (PsiTypes.booleanType().equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(rType))) {
            return switch (position) {
                case GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.RETURN_VALUE -> ConversionResult.WARNING;
                default -> null;
            };
        }
        if (position == GrTypeConverter.Position.RETURN_VALUE) {
            return null;
        }
        if (!TypesUtil.isClassType(rType, "java.lang.String")) {
            return null;
        }
        return GrCharConverter.checkSingleSymbolLiteral(context) ? ConversionResult.OK : ConversionResult.ERROR;
    }

    public static boolean checkSingleSymbolLiteral(GroovyPsiElement context) {
        GrLiteral literal = GrCharConverter.getLiteral(context);
        Object value = literal == null ? null : literal.getValue();
        return value != null && value.toString().length() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "lType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "position";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter";
        objectArray[2] = "isConvertible";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

