/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl.ijent.nio.toggle;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeService;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystem;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystemProvider;
import com.intellij.platform.ide.impl.wsl.ijent.nio.toggle.IjentWslNioFsToggleStrategyKt;
import com.intellij.platform.ide.impl.wsl.ijent.nio.toggle.WslEelDescriptor;
import com.intellij.platform.ijent.community.impl.IjentFailSafeFileSystemPosixApiKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.community.impl.nio.telemetry.TracingFileSystemProvider;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import com.intellij.util.containers.ContainerUtil;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR3\u0010\u000b\u001a'\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f\u0012\u000e\u0012\f0\u0010\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/ide/impl/wsl/ijent/nio/toggle/IjentWslNioFsToggleStrategy;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "enabledInDistros", "", "Lcom/intellij/execution/wsl/WSLDistribution;", "getEnabledInDistros$intellij_platform_ide_impl_wsl", "()Ljava/util/Set;", "providersCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider;", "enableForAllWslDistributions", "", "handleWslDistributionAddition", "distro", "handleWslDistributionDeletion", "switchToIjentFs", "switchToTracingWsl9pFs", "unregisterAll", "intellij.platform.ide.impl.wsl"})
@ApiStatus.Internal
@VisibleForTesting
public final class IjentWslNioFsToggleStrategy {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Set<WSLDistribution> enabledInDistros;
    @NotNull
    private final ConcurrentMap<String, IjentWslNioFileSystemProvider> providersCache;

    public IjentWslNioFsToggleStrategy(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentSet(...)");
        this.enabledInDistros = set;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.providersCache = concurrentMap;
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IjentWslNioFsToggleStrategy._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Set<WSLDistribution> getEnabledInDistros$intellij_platform_ide_impl_wsl() {
        return this.enabledInDistros;
    }

    public final void enableForAllWslDistributions() {
        BiConsumer<Set, Set> listener = (arg_0, arg_1) -> IjentWslNioFsToggleStrategy.enableForAllWslDistributions$lambda$1(this, arg_0, arg_1);
        WslDistributionManager wslDistributionManager = WslDistributionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)wslDistributionManager, (String)"getInstance(...)");
        WslDistributionManager wslDistributionManager2 = wslDistributionManager;
        wslDistributionManager2.addWslDistributionsChangeListener(listener);
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IjentWslNioFsToggleStrategy.enableForAllWslDistributions$lambda$2(wslDistributionManager2, listener, arg_0));
        for (WSLDistribution distro : wslDistributionManager2.getInstalledDistributions()) {
            Intrinsics.checkNotNull((Object)distro);
            this.handleWslDistributionAddition(distro);
        }
    }

    private final void handleWslDistributionAddition(WSLDistribution distro) {
        ((Collection)this.enabledInDistros).add(distro);
        this.switchToIjentFs(distro);
    }

    private final void handleWslDistributionDeletion(WSLDistribution distro) {
        ((Collection)this.enabledInDistros).remove(distro);
        IjentWslNioFsToggleStrategyKt.access$recomputeEel(distro, IjentWslNioFsToggleStrategy::handleWslDistributionDeletion$lambda$3);
    }

    public final void switchToIjentFs(@NotNull WSLDistribution distro) {
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        TracingFileSystemProvider ijentFsProvider = new TracingFileSystemProvider((FileSystemProvider)IjentNioFileSystemProvider.Companion.getInstance());
        try {
            String string = distro.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String distributionId = string;
            IjentFileSystemApi ijentFs = IjentFailSafeFileSystemPosixApiKt.IjentFailSafeFileSystemPosixApi((CoroutineScope)this.coroutineScope, (EelDescriptor)new WslEelDescriptor(new WSLDistribution(distributionId)));
            ijentFsProvider.newFileSystem(new URI("ijent", "wsl", "/" + distro.getId(), null, null), IjentNioFileSystemProvider.Companion.newFileSystemMap(ijentFs));
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        IjentWslNioFsToggleStrategyKt.access$recomputeEel(distro, (arg_0, arg_1) -> IjentWslNioFsToggleStrategy.switchToIjentFs$lambda$6(this, distro, ijentFsProvider, arg_0, arg_1));
    }

    public final void switchToTracingWsl9pFs(@NotNull WSLDistribution distro) {
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        IjentWslNioFsToggleStrategyKt.access$recomputeEel(distro, (arg_0, arg_1) -> IjentWslNioFsToggleStrategy.switchToTracingWsl9pFs$lambda$7(distro, arg_0, arg_1));
    }

    public final void unregisterAll() {
        EelNioBridgeService service = EelNioBridgeService.Companion.getInstanceSync();
        List distros = new ArrayList();
        this.enabledInDistros.removeIf(arg_0 -> IjentWslNioFsToggleStrategy.unregisterAll$lambda$9(arg_0 -> IjentWslNioFsToggleStrategy.unregisterAll$lambda$8(distros, arg_0), arg_0));
        for (WSLDistribution distro : distros) {
            service.unregister((EelDescriptor)new WslEelDescriptor(distro));
        }
    }

    private static final Unit _init_$lambda$0(IjentWslNioFsToggleStrategy this$0, Throwable it) {
        this$0.unregisterAll();
        return Unit.INSTANCE;
    }

    private static final void enableForAllWslDistributions$lambda$1(IjentWslNioFsToggleStrategy this$0, Set old, Set set) {
        Intrinsics.checkNotNull((Object)set);
        Intrinsics.checkNotNull((Object)old);
        for (WSLDistribution distro : SetsKt.minus((Set)set, (Iterable)old)) {
            this$0.handleWslDistributionAddition(distro);
        }
        for (WSLDistribution distro : SetsKt.minus((Set)old, (Iterable)set)) {
            this$0.handleWslDistributionDeletion(distro);
        }
    }

    private static final Unit enableForAllWslDistributions$lambda$2(WslDistributionManager $wslDistributionManager, BiConsumer $listener, Throwable it) {
        $wslDistributionManager.removeWslDistributionsChangeListener($listener);
        return Unit.INSTANCE;
    }

    private static final FileSystem handleWslDistributionDeletion$lambda$3(FileSystemProvider fileSystemProvider, FileSystem actualFs) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"<unused var>");
        return actualFs;
    }

    private static final IjentWslNioFileSystemProvider switchToIjentFs$lambda$6$lambda$4(WSLDistribution $distro, TracingFileSystemProvider $ijentFsProvider, FileSystemProvider $underlyingProvider, String it) {
        return new IjentWslNioFileSystemProvider($distro, (FileSystemProvider)$ijentFsProvider, (FileSystemProvider)new TracingFileSystemProvider($underlyingProvider));
    }

    private static final IjentWslNioFileSystemProvider switchToIjentFs$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (IjentWslNioFileSystemProvider)$tmp0.invoke(p0);
    }

    private static final FileSystem switchToIjentFs$lambda$6(IjentWslNioFsToggleStrategy this$0, WSLDistribution $distro, TracingFileSystemProvider $ijentFsProvider, FileSystemProvider underlyingProvider, FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)underlyingProvider, (String)"underlyingProvider");
        IjentWslNioFileSystemProvider fileSystemProvider = this$0.providersCache.computeIfAbsent($distro.getId(), arg_0 -> IjentWslNioFsToggleStrategy.switchToIjentFs$lambda$6$lambda$5(arg_0 -> IjentWslNioFsToggleStrategy.switchToIjentFs$lambda$6$lambda$4($distro, $ijentFsProvider, underlyingProvider, arg_0), arg_0));
        URI uRI = $distro.getUNCRootPath().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        IjentWslNioFileSystem fileSystem2 = fileSystemProvider.getFileSystem(uRI);
        IjentWslNioFsToggleStrategyKt.access$getLOG$p().info("Switching " + $distro + " to IJent WSL nio.FS: " + fileSystem2);
        return fileSystem2;
    }

    private static final FileSystem switchToTracingWsl9pFs$lambda$7(WSLDistribution $distro, FileSystemProvider underlyingProvider, FileSystem previousFs) {
        Intrinsics.checkNotNullParameter((Object)underlyingProvider, (String)"underlyingProvider");
        IjentWslNioFsToggleStrategyKt.access$getLOG$p().info("Switching " + $distro + " to the original file system but with tracing");
        try {
            FileSystem fileSystem = previousFs;
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return IjentWslNioFsToggleStrategyKt.access$getLocalFileSystem((FileSystemProvider)new TracingFileSystemProvider(underlyingProvider));
    }

    private static final boolean unregisterAll$lambda$8(List $distros, WSLDistribution it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)$distros).add(it);
        return true;
    }

    private static final boolean unregisterAll$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

