/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010$\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\fH\u0002J,\u0010*\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\"\u0010-\u001a\u0004\u0018\u00010&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010.\u001a\u00020\tH\u0002J(\u0010/\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\"H\u0002J*\u00103\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020&H\u0002J2\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020&2\u0006\u0010!\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00108\u001a\u000209H\u0002J*\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<2\u0006\u0010!\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020&2\u0006\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020AH\u0002J \u0010B\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020&2\u0006\u0010D\u001a\u00020\"H\u0002J\u001e\u0010E\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010!\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "isEffectivelyPrivateApiFunction", "", "inlinableParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "inlinableKtParameters", "Lorg/jetbrains/kotlin/psi/KtElement;", "<set-?>", "supportDefaultValueInline", "getSupportDefaultValueInline", "()Z", "setSupportDefaultValueInline", "(Z)V", "supportDefaultValueInline$delegate", "Lkotlin/properties/ReadWriteProperty;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkNotInDefaultParameter", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isInsideCall", "checkValueParameter", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "targetArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "targetParameterDescriptor", "checkCallWithReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getCalleeDescriptor", "unwrapVariableAsFunction", "checkLambdaInvokeOrExtensionCall", "lambdaDescriptor", "callDescriptor", "receiverExpression", "checkRecursion", "replacementForReport", "isInvokeOrInlineExtension", "checkVisibilityAndAccess", "calledDescriptor", "call", "Lorg/jetbrains/kotlin/psi/Call;", "checkPrivateClassMemberAccess", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkSuperCalls", "callableDescriptor", "isDefinedInInlineFunction", "startDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "checkNonLocalReturn", "inlinableParameterDescriptor", "parameterUsage", "reportDeprecationOnReplacement", "frontend"})
@SourceDebugExtension(value={"SMAP\nInlineChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,383:1\n1#2:384\n1#2:398\n774#3:385\n865#3,2:386\n1617#3,9:388\n1869#3:397\n1870#3:399\n1626#3:400\n196#4:401\n*S KotlinDebug\n*F\n+ 1 InlineChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker\n*L\n60#1:398\n58#1:385\n58#1:386,2\n60#1:388,9\n60#1:397\n60#1:399\n60#1:400\n101#1:401\n*E\n"})
public final class InlineChecker
implements CallChecker {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final EffectiveVisibility inlineFunEffectiveVisibility;
    private final boolean isEffectivelyPrivateApiFunction;
    @NotNull
    private final List<ValueParameterDescriptor> inlinableParameters;
    @NotNull
    private final List<KtElement> inlinableKtParameters;
    @NotNull
    private final ReadWriteProperty supportDefaultValueInline$delegate;

    /*
     * WARNING - void declaration
     */
    public InlineChecker(@NotNull FunctionDescriptor descriptor) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        boolean bl = InlineUtil.isInline(this.descriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineChecker$22 = false;
            String $i$a$-assert-InlineChecker$22 = "This extension should be created only for inline functions: " + this.descriptor;
            throw new AssertionError((Object)$i$a$-assert-InlineChecker$22);
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = this.descriptor;
        DescriptorVisibility descriptorVisibility = this.descriptor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
        this.inlineFunEffectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(declarationDescriptorWithVisibility, descriptorVisibility, true);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(this.descriptor);
        List<ValueParameterDescriptor> list = this.descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable iterable = list;
        InlineChecker inlineChecker = this;
        boolean $i$f$filter = false;
        void var4_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (!InlineUtil.isInlineParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        inlineChecker.inlinableParameters = (List)destination$iv$iv;
        $this$filter$iv = this.inlinableParameters;
        inlineChecker = this;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl4 = false;
            SourceElement sourceElement = it.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            if ((kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        inlineChecker.inlinableKtParameters = (List)destination$iv$iv;
        this.supportDefaultValueInline$delegate = Delegates.INSTANCE.notNull();
    }

    private final boolean getSupportDefaultValueInline() {
        return (Boolean)this.supportDefaultValueInline$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSupportDefaultValueInline(boolean bl) {
        this.supportDefaultValueInline$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Call call = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"getCall(...)");
        Call call2 = call;
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression2 = ktExpression;
        this.setSupportDefaultValueInline(context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters));
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object targetDescriptor = obj;
        if (PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)targetDescriptor)) {
            return;
        }
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetDescriptor)) {
            if (this.checkNotInDefaultParameter(context, expression2) && !this.isInsideCall(expression2)) {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            }
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            ResolvedValueArgument value = entry.getValue();
            if (value instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value.getArguments()) {
                Intrinsics.checkNotNull((Object)argument);
                Intrinsics.checkNotNull((Object)valueDescriptor);
                this.checkValueParameter(context, (CallableDescriptor)targetDescriptor, argument, valueDescriptor);
            }
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        KtExpression replacementForReport = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, (KtElement)expression2, (KtElement)replacementForReport, context, call2);
        this.checkRecursion(context, (CallableDescriptor)targetDescriptor, (KtElement)expression2, (KtElement)replacementForReport);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNotInDefaultParameter(CallCheckerContext context, KtExpression expression2) {
        boolean allow;
        void $this$getParentOfType$iv;
        if (!this.getSupportDefaultValueInline()) return true;
        PsiElement psiElement = (PsiElement)expression2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtParameter.class, (boolean)strict$iv);
        if (ktParameter == null) return true;
        KtParameter it = ktParameter;
        boolean bl = false;
        if (!this.inlinableKtParameters.contains(it)) {
            return true;
        }
        boolean bl2 = allow = false;
        if (!allow) {
            context.getTrace().report(Errors.NOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
        boolean bl3 = allow;
        if (!bl3) return false;
        return true;
    }

    private final boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent((KtExpression)expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)((KtOperationExpression)parent2))) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            PsiElement current = (PsiElement)expression2;
            while (current != parent2) {
                if (current instanceof KtBinaryExpressionWithTypeRHS) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)current.getParent(), (String)"getParent(...)");
            }
        }
        return parent2 != null;
    }

    private final void checkValueParameter(CallCheckerContext context, CallableDescriptor targetDescriptor, ValueArgument targetArgument, ValueParameterDescriptor targetParameterDescriptor) {
        KtExpression ktExpression = targetArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        CallableDescriptor argumentCallee = this.getCalleeDescriptor(context, argumentExpression, false);
        if (argumentCallee != null && CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)argumentCallee)) {
            if (this.checkNotInDefaultParameter(context, argumentExpression)) {
                if (InlineUtil.isInline(targetDescriptor) && InlineUtil.isInlineParameter(targetParameterDescriptor)) {
                    if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                        context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)argumentExpression), (KtElement)argumentExpression));
                    } else {
                        this.checkNonLocalReturn(context, argumentCallee, argumentExpression);
                    }
                } else {
                    context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)argumentExpression), argumentExpression, this.descriptor));
                }
            }
        }
    }

    private final void checkCallWithReceiver(CallCheckerContext context, CallableDescriptor targetDescriptor, ReceiverValue receiver, KtExpression expression2) {
        if (receiver == null) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        KtExpression receiverExpression = null;
        ReceiverValue receiverValue = receiver;
        if (receiverValue instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = this.getCalleeDescriptor(context, receiverExpression, true);
        } else if (receiverValue instanceof ExtensionReceiver) {
            boolean bl;
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"<get-declarationDescriptor>(...)");
            CallableDescriptor extension = callableDescriptor;
            varDescriptor = extension.getExtensionReceiverParameter();
            boolean bl2 = bl = varDescriptor != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Extension should have receiverParameterDescriptor: " + extension;
                throw new AssertionError((Object)string);
            }
            receiverExpression = expression2;
        } else {
            varDescriptor = null;
            receiverExpression = null;
        }
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)varDescriptor)) {
            CallableDescriptor callableDescriptor = varDescriptor;
            Intrinsics.checkNotNull((Object)callableDescriptor);
            KtExpression ktExpression = receiverExpression;
            Intrinsics.checkNotNull((Object)ktExpression);
            this.checkLambdaInvokeOrExtensionCall(context, callableDescriptor, targetDescriptor, ktExpression);
        }
    }

    private final CallableDescriptor getCalleeDescriptor(CallCheckerContext context, KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        KtElement ktElement = (KtElement)expression2;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = thisCall;
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    private final void checkLambdaInvokeOrExtensionCall(CallCheckerContext context, CallableDescriptor lambdaDescriptor, CallableDescriptor callDescriptor, KtExpression receiverExpression) {
        boolean inlinableCall = this.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            if (InlineUtil.isInline(callDescriptor) && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidExtensionCallsOnInlineFunctionalParameters)) {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE_WARNING.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
            } else {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
            }
        } else {
            this.checkNonLocalReturn(context, lambdaDescriptor, receiverExpression);
        }
    }

    private final void checkRecursion(CallCheckerContext context, CallableDescriptor targetDescriptor, KtElement expression2, KtElement replacementForReport) {
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context.getTrace().report(Errors.RECURSION_IN_INLINE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            this.reportDeprecationOnReplacement(context, expression2, replacementForReport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvokeOrInlineExtension(CallableDescriptor descriptor) {
        if (!(descriptor instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((SimpleFunctionDescriptor)descriptor).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!Intrinsics.areEqual((Object)descriptor.getName(), (Object)OperatorNameConventions.INVOKE)) return false;
        if (!(containingDeclaration instanceof ClassDescriptor)) return false;
        SimpleType simpleType = ((ClassDescriptor)containingDeclaration).getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        if (!FunctionTypesKt.isBuiltinFunctionalType(simpleType)) return false;
        return true;
    }

    private final void checkVisibilityAndAccess(CallableDescriptor calledDescriptor, KtElement expression2, KtElement replacementForReport, CallCheckerContext context, Call call) {
        EffectiveVisibility effectiveVisibility;
        if (this.isDefinedInInlineFunction(calledDescriptor)) {
            effectiveVisibility = (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE;
        } else {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = calledDescriptor;
            DescriptorVisibility descriptorVisibility = calledDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
            effectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(declarationDescriptorWithVisibility, descriptorVisibility, true);
        }
        EffectiveVisibility calledFunEffectiveVisibility = effectiveVisibility;
        boolean isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
        boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
        if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && calledDescriptor.getVisibility() != DescriptorVisibilities.LOCAL) {
            context.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on((KtElement)((PsiElement)expression2), calledDescriptor, this.descriptor));
            this.reportDeprecationOnReplacement(context, expression2, replacementForReport);
        } else {
            this.checkPrivateClassMemberAccess(calledDescriptor, expression2, replacementForReport, context);
            if (isInlineFunPublicOrPublishedApi) {
                this.checkSuperCalls(calledDescriptor, call, expression2, context);
            }
        }
        boolean isConstructorCall = calledDescriptor instanceof ConstructorDescriptor;
        if (!(isConstructorCall && expression2 instanceof KtConstructorCalleeExpression || !isInlineFunPublicOrPublishedApi || this.inlineFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE || calledFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE)) {
            if (isConstructorCall) {
                context.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE.on(context.getLanguageVersionSettings(), (PsiElement)expression2, calledDescriptor));
            } else {
                context.getTrace().report(Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.on(context.getLanguageVersionSettings(), (PsiElement)expression2, calledDescriptor));
            }
            this.reportDeprecationOnReplacement(context, expression2, replacementForReport);
        }
    }

    private final void checkPrivateClassMemberAccess(DeclarationDescriptor declarationDescriptor, KtElement expression2, KtElement replacementForReport, CallCheckerContext context) {
        if (!this.isEffectivelyPrivateApiFunction) {
            if (DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
                context.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
                this.reportDeprecationOnReplacement(context, expression2, replacementForReport);
            } else if (DescriptorUtilsKt.isMemberOfCompanionOfPrivateClass(declarationDescriptor)) {
                context.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE_WARNING.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
                this.reportDeprecationOnReplacement(context, expression2, replacementForReport);
            }
        }
    }

    private final void checkSuperCalls(CallableDescriptor callableDescriptor, Call call, KtElement expression2, CallCheckerContext context) {
        KtSuperExpression superCall = CallResolverUtilKt.getSuperCallExpression(call);
        if (superCall != null) {
            KotlinType kotlinType = (KotlinType)context.getTrace().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, superCall);
            if (kotlinType == null) {
                return;
            }
            KotlinType thisTypeForSuperCall = kotlinType;
            ClassifierDescriptor classifierDescriptor = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = classifierDescriptor instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)((Object)classifierDescriptor) : null;
            if (declarationDescriptorWithVisibility == null) {
                return;
            }
            DeclarationDescriptorWithVisibility descriptor = declarationDescriptorWithVisibility;
            if (!this.isDefinedInInlineFunction(descriptor)) {
                BindingTrace bindingTrace = context.getTrace();
                LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
                PsiElement psiElement = expression2.getParent().getParent();
                if (psiElement == null) {
                    psiElement = (PsiElement)superCall;
                }
                bindingTrace.report(Errors.SUPER_CALL_FROM_PUBLIC_INLINE.on(languageVersionSettings, psiElement, callableDescriptor));
            }
        }
    }

    private final boolean isDefinedInInlineFunction(DeclarationDescriptorWithVisibility startDescriptor) {
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private final void checkNonLocalReturn(CallCheckerContext context, CallableDescriptor inlinableParameterDescriptor, KtExpression parameterUsage) {
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context.getResolutionContext())) {
            context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)parameterUsage), (KtElement)parameterUsage));
        }
    }

    private final void reportDeprecationOnReplacement(CallCheckerContext $this$reportDeprecationOnReplacement, KtElement expression2, KtElement replacementForReport) {
        if (!expression2.isPhysical() && replacementForReport != null) {
            $this$reportDeprecationOnReplacement.getTrace().report(Errors.DEPRECATED_IMPLICIT_NON_PUBLIC_API_ACCESS.on((KtElement)((PsiElement)replacementForReport)));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(InlineChecker.class, "supportDefaultValueInline", "getSupportDefaultValueInline()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

