/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.DoubleValue;
import org.jetbrains.eval4j.FloatValue;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.LongValue;
import org.jetbrains.eval4j.NOT_A_VALUE;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.VOID_VALUE;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIFailureException;
import org.jetbrains.eval4j.jdi.JdiEvalKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\t\u001a\f\u0010\u0007\u001a\u00020\u0002*\u0004\u0018\u00010\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\"\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"makeInitialFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/eval4j/Value;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "arguments", "", "asValue", "Lorg/jetbrains/eval4j/ObjectValue;", "Lcom/sun/jdi/ObjectReference;", "Lcom/sun/jdi/Value;", "asType", "Lorg/jetbrains/org/objectweb/asm/Type;", "Lcom/sun/jdi/Type;", "jdiObj", "getJdiObj", "(Lorg/jetbrains/eval4j/Value;)Lcom/sun/jdi/ObjectReference;", "jdiClass", "Lcom/sun/jdi/ClassObjectReference;", "getJdiClass", "(Lorg/jetbrains/eval4j/Value;)Lcom/sun/jdi/ClassObjectReference;", "asJdiValue", "vm", "Lcom/sun/jdi/VirtualMachine;", "expectedType", "Lkotlin/Function0;", "kotlin.jvm-debugger.eval4j"})
public final class JdiValuesKt {
    @NotNull
    public static final Frame<Value> makeInitialFrame(@NotNull MethodNode methodNode, @NotNull List<? extends Value> arguments2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        boolean isStatic = (methodNode.access & 8) != 0;
        Type[] params = Type.getArgumentTypes((String)methodNode.desc);
        boolean bl2 = bl = arguments2.size() == (isStatic ? params.length : params.length + 1);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JdiValuesKt$makeInitialFrame$232 = false;
            String $i$a$-assert-JdiValuesKt$makeInitialFrame$232 = "Wrong number of arguments for " + methodNode + ": " + arguments2;
            throw new AssertionError((Object)$i$a$-assert-JdiValuesKt$makeInitialFrame$232);
        }
        Frame frame = new Frame(methodNode.maxLocals, methodNode.maxStack);
        Type type2 = Type.getReturnType((String)methodNode.desc);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getReturnType(...)");
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)ValuesKt.makeNotInitializedValue(type2));
        int index2 = 0;
        for (Value value : arguments2) {
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value);
            if (value.getSize() != 2) continue;
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE);
        }
        while (index2 < methodNode.maxLocals) {
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE);
        }
        return frame;
    }

    @NotNull
    public static final ObjectValue asValue(@Nullable ObjectReference $this$asValue) {
        ObjectValue objectValue;
        ObjectReference objectReference = $this$asValue;
        if (objectReference == null) {
            objectValue = ValuesKt.getNULL_VALUE();
        } else if (objectReference instanceof StringReference) {
            objectValue = new ObjectValue($this$asValue, JdiEvalKt.getSTRING_TYPE());
        } else {
            Type type2 = InstructionAdapter.OBJECT_TYPE;
            objectValue = new ObjectValue($this$asValue, type2){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($receiver, $super_call_param$1);
                }

                public Type getAsmType() {
                    V v = this.getValue();
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                    com.sun.jdi.Type type2 = ((ObjectReference)v).type();
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type(...)");
                    return JdiValuesKt.asType(type2);
                }
            };
        }
        return objectValue;
    }

    @NotNull
    public static final Value asValue(@Nullable com.sun.jdi.Value $this$asValue) {
        Value value;
        com.sun.jdi.Value value2 = $this$asValue;
        if (value2 == null) {
            value = ValuesKt.getNULL_VALUE();
        } else if (value2 instanceof VoidValue) {
            value = VOID_VALUE.INSTANCE;
        } else if (value2 instanceof BooleanValue) {
            int n = ((BooleanValue)$this$asValue).intValue();
            Type type2 = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"BOOLEAN_TYPE");
            value = new IntValue(n, type2);
        } else if (value2 instanceof ByteValue) {
            int n = ((ByteValue)$this$asValue).intValue();
            Type type3 = Type.BYTE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"BYTE_TYPE");
            value = new IntValue(n, type3);
        } else if (value2 instanceof ShortValue) {
            int n = ((ShortValue)$this$asValue).intValue();
            Type type4 = Type.SHORT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"SHORT_TYPE");
            value = new IntValue(n, type4);
        } else if (value2 instanceof CharValue) {
            int n = ((CharValue)$this$asValue).intValue();
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"CHAR_TYPE");
            value = new IntValue(n, type5);
        } else if (value2 instanceof IntegerValue) {
            int n = ((IntegerValue)$this$asValue).intValue();
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"INT_TYPE");
            value = new IntValue(n, type6);
        } else if (value2 instanceof com.sun.jdi.LongValue) {
            value = new LongValue(((com.sun.jdi.LongValue)$this$asValue).longValue());
        } else if (value2 instanceof com.sun.jdi.FloatValue) {
            value = new FloatValue(((com.sun.jdi.FloatValue)$this$asValue).floatValue());
        } else if (value2 instanceof com.sun.jdi.DoubleValue) {
            value = new DoubleValue(((com.sun.jdi.DoubleValue)$this$asValue).doubleValue());
        } else if (value2 instanceof ObjectReference) {
            value = JdiValuesKt.asValue((ObjectReference)$this$asValue);
        } else {
            throw new JDIFailureException("Unknown value: " + $this$asValue, null, 2, null);
        }
        return value;
    }

    @NotNull
    public static final Type asType(@NotNull com.sun.jdi.Type $this$asType) {
        Intrinsics.checkNotNullParameter((Object)$this$asType, (String)"<this>");
        Type type2 = Type.getType((String)$this$asType.signature());
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        return type2;
    }

    @Nullable
    public static final ObjectReference getJdiObj(@NotNull Value $this$jdiObj) {
        Intrinsics.checkNotNullParameter((Object)$this$jdiObj, (String)"<this>");
        return (ObjectReference)ValuesKt.obj$default($this$jdiObj, null, 1, null);
    }

    @Nullable
    public static final ClassObjectReference getJdiClass(@NotNull Value $this$jdiClass) {
        Intrinsics.checkNotNullParameter((Object)$this$jdiClass, (String)"<this>");
        return (ClassObjectReference)JdiValuesKt.getJdiObj($this$jdiClass);
    }

    @Nullable
    public static final com.sun.jdi.Value asJdiValue(@NotNull Value $this$asJdiValue, @NotNull VirtualMachine vm, @NotNull Function0<Type> expectedType) {
        com.sun.jdi.Value value;
        Intrinsics.checkNotNullParameter((Object)$this$asJdiValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        Value value2 = $this$asJdiValue;
        if (Intrinsics.areEqual((Object)value2, (Object)ValuesKt.getNULL_VALUE())) {
            value = null;
        } else if (Intrinsics.areEqual((Object)value2, (Object)VOID_VALUE.INSTANCE)) {
            value = vm.mirrorOfVoid();
        } else if (value2 instanceof IntValue) {
            PrimitiveValue primitiveValue;
            Type type2 = (Type)expectedType.invoke();
            if (Intrinsics.areEqual((Object)type2, (Object)Type.BOOLEAN_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getBoolean($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.BYTE_TYPE)) {
                primitiveValue = vm.mirrorOf((byte)ValuesKt.getInt($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.SHORT_TYPE)) {
                primitiveValue = vm.mirrorOf((short)ValuesKt.getInt($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.CHAR_TYPE)) {
                primitiveValue = vm.mirrorOf((char)ValuesKt.getInt($this$asJdiValue));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.INT_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getInt($this$asJdiValue));
            } else {
                throw new JDIFailureException("Unknown value type: " + $this$asJdiValue, null, 2, null);
            }
            value = primitiveValue;
        } else if (value2 instanceof LongValue) {
            value = vm.mirrorOf(((Number)((LongValue)$this$asJdiValue).getValue()).longValue());
        } else if (value2 instanceof FloatValue) {
            value = vm.mirrorOf(((Number)((FloatValue)$this$asJdiValue).getValue()).floatValue());
        } else if (value2 instanceof DoubleValue) {
            value = vm.mirrorOf(((Number)((DoubleValue)$this$asJdiValue).getValue()).doubleValue());
        } else if (value2 instanceof ObjectValue) {
            Object v = ((ObjectValue)$this$asJdiValue).getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            value = (ObjectReference)v;
        } else {
            throw new JDIFailureException("Unknown value: " + $this$asJdiValue, null, 2, null);
        }
        return value;
    }
}

