/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.kmp.HmppSourceModuleDependencyFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.kmp.NegatedModuleDependencyFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.kmp.NonHmppSourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.kmp.SourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.PlatformModuleInfoKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "collectModuleDependencies", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "sourceRootType", "Lorg/jetbrains/kotlin/config/KotlinSourceRootType;", "includeExportedDependencies", "", "collectionMode", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$CollectionMode;", "getOrderEnumerator", "Lcom/intellij/openapi/roots/OrderEnumerator;", "isApplicable", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "collectModuleDependenciesForOrderEntry", "", "Companion", "CollectionMode", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nKotlinModuleDependencyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n52#2:150\n774#3:151\n865#3,2:152\n*S KotlinDebug\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector\n*L\n53#1:150\n116#1:151\n116#1:152,2\n*E\n"})
public final class ModuleDependencyCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public ModuleDependencyCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Collection<IdeaModuleInfo> collectModuleDependencies(@NotNull Module module, @NotNull TargetPlatform platform, @NotNull KotlinSourceRootType sourceRootType, boolean includeExportedDependencies, @NotNull CollectionMode collectionMode) {
        NegatedModuleDependencyFilter negatedModuleDependencyFilter;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)sourceRootType, (String)"sourceRootType");
        Intrinsics.checkNotNullParameter((Object)((Object)collectionMode), (String)"collectionMode");
        ArrayList debugInfo = LOG.isDebugEnabled() ? new ArrayList() : null;
        OrderEnumerator orderEnumerator = this.getOrderEnumerator(module, sourceRootType, includeExportedDependencies);
        SourceModuleDependenciesFilter sourceModuleDependenciesFilter = KotlinFacetUtils.isHMPPEnabled(module) ? (SourceModuleDependenciesFilter)new HmppSourceModuleDependencyFilter(platform) : (SourceModuleDependenciesFilter)new NonHmppSourceModuleDependenciesFilter(platform);
        boolean condition$iv = collectionMode == CollectionMode.COLLECT_IGNORED;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void p0 = $this$applyIf$iv;
            boolean bl = false;
            negatedModuleDependencyFilter = new NegatedModuleDependencyFilter((SourceModuleDependenciesFilter)p0);
        } else {
            negatedModuleDependencyFilter = $this$applyIf$iv;
        }
        SourceModuleDependenciesFilter dependencyFilter = negatedModuleDependencyFilter;
        LinkedHashSet result2 = new LinkedHashSet();
        orderEnumerator.forEach(arg_0 -> ModuleDependencyCollector.collectModuleDependencies$lambda$1(arg_0 -> ModuleDependencyCollector.collectModuleDependencies$lambda$0(this, sourceRootType, debugInfo, dependencyFilter, result2, arg_0), arg_0));
        if (debugInfo != null) {
            StringBuilder stringBuilder;
            StringBuilder $this$collectModuleDependencies_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$collectModuleDependencies_u24lambda_u242.append("Building dependency list for module " + $this$collectModuleDependencies_u24lambda_u242).append('\n');
            $this$collectModuleDependencies_u24lambda_u242.append("Platform = " + platform + ", isForTests = " + Intrinsics.areEqual((Object)sourceRootType, (Object)TestSourceKotlinRootType.INSTANCE)).append('\n');
            CollectionsKt.joinTo$default((Iterable)debugInfo, (Appendable)$this$collectModuleDependencies_u24lambda_u242, (CharSequence)"; ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)112, null);
            String debugString = stringBuilder.toString();
            LOG.debug(debugString);
        }
        return result2;
    }

    public static /* synthetic */ Collection collectModuleDependencies$default(ModuleDependencyCollector moduleDependencyCollector, Module module, TargetPlatform targetPlatform, KotlinSourceRootType kotlinSourceRootType, boolean bl, CollectionMode collectionMode, int n, Object object) {
        if ((n & 0x10) != 0) {
            collectionMode = CollectionMode.COLLECT_NON_IGNORED;
        }
        return moduleDependencyCollector.collectModuleDependencies(module, targetPlatform, kotlinSourceRootType, bl, collectionMode);
    }

    private final OrderEnumerator getOrderEnumerator(Module module, KotlinSourceRootType sourceRootType, boolean includeExportedDependencies) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        OrderEnumerator orderEnumerator = rootManager.orderEntries().compileOnly();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"compileOnly(...)");
        OrderEnumerator dependencyEnumerator = orderEnumerator;
        if (includeExportedDependencies) {
            dependencyEnumerator.recursively().exportedOnly();
        }
        if (Intrinsics.areEqual((Object)sourceRootType, (Object)SourceKotlinRootType.INSTANCE) && BuildSystemTypeKt.getBuildSystemType(module) == BuildSystemType.JPS) {
            dependencyEnumerator.productionOnly();
        }
        return dependencyEnumerator;
    }

    private final boolean isApplicable(OrderEntry orderEntry, KotlinSourceRootType sourceRootType) {
        if (!orderEntry.isValid()) {
            return false;
        }
        return !(orderEntry instanceof ExportableOrderEntry) || Intrinsics.areEqual((Object)sourceRootType, (Object)TestSourceKotlinRootType.INSTANCE) || orderEntry instanceof ModuleOrderEntry && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() || ((ExportableOrderEntry)orderEntry).getScope().isForProductionCompile();
    }

    private final List<IdeaModuleInfo> collectModuleDependenciesForOrderEntry(OrderEntry orderEntry, KotlinSourceRootType sourceRootType) {
        List<Object> list2;
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module = ((ModuleSourceOrderEntry)orderEntry).getOwnerModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getOwnerModule(...)");
            list2 = ModuleDependencyCollector.collectModuleDependenciesForOrderEntry$toInfos(module, sourceRootType);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Module module2 = module;
            list2 = Intrinsics.areEqual((Object)sourceRootType, (Object)SourceKotlinRootType.INSTANCE) && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() ? CollectionsKt.listOfNotNull((Object)KotlinProjectStructureUtils.getTestSourceInfo(module2)) : ModuleDependencyCollector.collectModuleDependenciesForOrderEntry$toInfos(module2, sourceRootType);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                return CollectionsKt.emptyList();
            }
            Library library2 = library;
            list2 = LibraryInfoCache.Companion.getInstance(this.project).get(library2);
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return CollectionsKt.emptyList();
            }
            Sdk sdk2 = sdk;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(this.project, sdk2));
        } else {
            throw new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    private static final boolean collectModuleDependencies$lambda$0(ModuleDependencyCollector this$0, KotlinSourceRootType $sourceRootType, ArrayList $debugInfo, SourceModuleDependenciesFilter $dependencyFilter, LinkedHashSet $result, OrderEntry orderEntry) {
        block4: {
            block3: {
                Intrinsics.checkNotNull((Object)orderEntry);
                if (!this$0.isApplicable(orderEntry, $sourceRootType)) break block3;
                ArrayList arrayList = $debugInfo;
                if (arrayList != null) {
                    arrayList.add("Add entry " + orderEntry.getPresentableName());
                }
                for (IdeaModuleInfo moduleInfo : this$0.collectModuleDependenciesForOrderEntry(orderEntry, $sourceRootType)) {
                    if (!PlatformModuleInfoKt.isSupportedDependency($dependencyFilter, moduleInfo)) continue;
                    ArrayList arrayList2 = $debugInfo;
                    if (arrayList2 != null) {
                        arrayList2.add("Add module " + moduleInfo.getDisplayedName());
                    }
                    $result.add(moduleInfo);
                }
                break block4;
            }
            ArrayList arrayList = $debugInfo;
            if (arrayList == null) break block4;
            arrayList.add("Skip entry " + orderEntry.getPresentableName());
        }
        return true;
    }

    private static final boolean collectModuleDependencies$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ModuleSourceInfo> collectModuleDependenciesForOrderEntry$toInfos(Module $this$collectModuleDependenciesForOrderEntry_u24toInfos, KotlinSourceRootType $sourceRootType) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = KotlinProjectStructureUtils.getSourceModuleInfos($this$collectModuleDependenciesForOrderEntry_u24toInfos);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)$sourceRootType, (Object)TestSourceKotlinRootType.INSTANCE) || it instanceof ModuleProductionSourceInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = Logger.getInstance(ModuleDependencyCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$CollectionMode;", "", "<init>", "(Ljava/lang/String;I)V", "COLLECT_IGNORED", "COLLECT_NON_IGNORED", "kotlin.base.project-structure"})
    public static final class CollectionMode
    extends Enum<CollectionMode> {
        public static final /* enum */ CollectionMode COLLECT_IGNORED = new CollectionMode();
        public static final /* enum */ CollectionMode COLLECT_NON_IGNORED = new CollectionMode();
        private static final /* synthetic */ CollectionMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CollectionMode[] values() {
            return (CollectionMode[])$VALUES.clone();
        }

        public static CollectionMode valueOf(String value) {
            return Enum.valueOf(CollectionMode.class, value);
        }

        @NotNull
        public static EnumEntries<CollectionMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = collectionModeArray = new CollectionMode[]{CollectionMode.COLLECT_IGNORED, CollectionMode.COLLECT_NON_IGNORED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleDependencyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,149:1\n30#2,2:150\n*S KotlinDebug\n*F\n+ 1 KotlinModuleDependencyUtils.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleDependencyCollector$Companion\n*L\n30#1:150,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleDependencyCollector getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ModuleDependencyCollector> serviceClass$iv = ModuleDependencyCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleDependencyCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

