/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.handlers.GenerateLambdaInfo;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinFunctionInsertHandler$Normal$handleInsert$;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinFunctionInsertHandlerKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0015\b\u0004\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "<init>", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Normal", "Infix", "OnlyName", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Infix;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Normal;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$OnlyName;", "kotlin.completion.impl.k1"})
public abstract class KotlinFunctionInsertHandler
extends KotlinCallableInsertHandler {
    private KotlinFunctionInsertHandler(CallType<?> callType) {
        super(callType);
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        super.handleInsert(context, item);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
        psiDocumentManager.commitDocument(context.getDocument());
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(context.getDocument());
    }

    public /* synthetic */ KotlinFunctionInsertHandler(CallType callType, DefaultConstructorMarker $constructor_marker) {
        this(callType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Infix;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "kotlin.completion.impl.k1"})
    public static final class Infix
    extends KotlinFunctionInsertHandler {
        @NotNull
        public static final Infix INSTANCE = new Infix();

        private Infix() {
            super(CallType.INFIX.INSTANCE, null);
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            super.handleInsert(context, item);
            if (context.getCompletionChar() == ' ') {
                context.setAddCompletionChar(false);
            }
            int tailOffset = context.getTailOffset();
            context.getDocument().insertString(tailOffset, (CharSequence)" ");
            context.getEditor().getCaretModel().moveToOffset(tailOffset + 1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BC\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJH\u0010\u0016\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Normal;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "inputTypeArguments", "", "inputValueArguments", "argumentText", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/completion/handlers/GenerateLambdaInfo;", "argumentsOnly", "<init>", "(Lorg/jetbrains/kotlin/idea/util/CallType;ZZLjava/lang/String;Lorg/jetbrains/kotlin/idea/completion/handlers/GenerateLambdaInfo;Z)V", "getInputTypeArguments", "()Z", "getInputValueArguments", "getArgumentText", "()Ljava/lang/String;", "getLambdaInfo", "()Lorg/jetbrains/kotlin/idea/completion/handlers/GenerateLambdaInfo;", "getArgumentsOnly", "copy", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "addArguments", "offsetElement", "Lcom/intellij/psi/PsiElement;", "shouldPlaceCaretInBrackets", "completionChar", "", "isInsertSpacesInOneLineFunctionEnabled", "file", "Lcom/intellij/psi/PsiFile;", "kotlin.completion.impl.k1"})
    @SourceDebugExtension(value={"SMAP\nKotlinFunctionInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFunctionInsertHandler.kt\norg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Normal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,553:1\n1#2:554\n573#3:555\n*S KotlinDebug\n*F\n+ 1 KotlinFunctionInsertHandler.kt\norg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Normal\n*L\n405#1:555\n*E\n"})
    public static final class Normal
    extends KotlinFunctionInsertHandler {
        private final boolean inputTypeArguments;
        private final boolean inputValueArguments;
        @NotNull
        private final String argumentText;
        @Nullable
        private final GenerateLambdaInfo lambdaInfo;
        private final boolean argumentsOnly;

        public Normal(@NotNull CallType<?> callType, boolean inputTypeArguments, boolean inputValueArguments, @NotNull String argumentText, @Nullable GenerateLambdaInfo lambdaInfo, boolean argumentsOnly) {
            Intrinsics.checkNotNullParameter(callType, (String)"callType");
            Intrinsics.checkNotNullParameter((Object)argumentText, (String)"argumentText");
            super(callType, null);
            this.inputTypeArguments = inputTypeArguments;
            this.inputValueArguments = inputValueArguments;
            this.argumentText = argumentText;
            this.lambdaInfo = lambdaInfo;
            this.argumentsOnly = argumentsOnly;
            if (this.lambdaInfo != null) {
                boolean bl = Intrinsics.areEqual((Object)this.argumentText, (Object)"");
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }

        public /* synthetic */ Normal(CallType callType, boolean bl, boolean bl2, String string, GenerateLambdaInfo generateLambdaInfo, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = "";
            }
            if ((n & 0x10) != 0) {
                generateLambdaInfo = null;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            this(callType, bl, bl2, string, generateLambdaInfo, bl3);
        }

        public final boolean getInputTypeArguments() {
            return this.inputTypeArguments;
        }

        public final boolean getInputValueArguments() {
            return this.inputValueArguments;
        }

        @NotNull
        public final String getArgumentText() {
            return this.argumentText;
        }

        @Nullable
        public final GenerateLambdaInfo getLambdaInfo() {
            return this.lambdaInfo;
        }

        public final boolean getArgumentsOnly() {
            return this.argumentsOnly;
        }

        @NotNull
        public final Normal copy(@NotNull CallType<?> callType, boolean inputTypeArguments, boolean inputValueArguments, @NotNull String argumentText, @Nullable GenerateLambdaInfo lambdaInfo, boolean argumentsOnly) {
            Intrinsics.checkNotNullParameter(callType, (String)"callType");
            Intrinsics.checkNotNullParameter((Object)argumentText, (String)"argumentText");
            return new Normal(callType, inputTypeArguments, inputValueArguments, argumentText, lambdaInfo, argumentsOnly);
        }

        public static /* synthetic */ Normal copy$default(Normal normal, CallType callType, boolean bl, boolean bl2, String string, GenerateLambdaInfo generateLambdaInfo, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                callType = normal.getCallType();
            }
            if ((n & 2) != 0) {
                bl = normal.inputTypeArguments;
            }
            if ((n & 4) != 0) {
                bl2 = normal.inputValueArguments;
            }
            if ((n & 8) != 0) {
                string = normal.argumentText;
            }
            if ((n & 0x10) != 0) {
                generateLambdaInfo = normal.lambdaInfo;
            }
            if ((n & 0x20) != 0) {
                bl3 = normal.argumentsOnly;
            }
            return normal.copy(callType, bl, bl2, string, generateLambdaInfo, bl3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            block11: {
                SmartPsiElementPointer smartPsiElementPointer;
                KtDotQualifiedExpression ktDotQualifiedExpression;
                void $this$getLastParentOfTypeInRow$iv;
                PsiElement psiElement;
                PsiElement psiElement2;
                int n;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
                Document document = context.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                if (!this.argumentsOnly) {
                    HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context);
                    super.handleInsert(context, item);
                }
                psiDocumentManager.commitDocument(document2);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
                OffsetMap offsetMap = context.getOffsetMap();
                Intrinsics.checkNotNull((Object)offsetMap);
                OffsetKey offsetKey = CompletionInitializationContext.START_OFFSET;
                Intrinsics.checkNotNullExpressionValue((Object)offsetKey, (String)"START_OFFSET");
                Integer n2 = KotlinFunctionInsertHandlerKt.access$get(offsetMap, offsetKey);
                if (n2 != null) {
                    n = n2;
                } else {
                    Integer n3;
                    OffsetKey offsetKey2 = InsertionContext.TAIL_OFFSET;
                    Intrinsics.checkNotNullExpressionValue((Object)offsetKey2, (String)"TAIL_OFFSET");
                    Integer n4 = KotlinFunctionInsertHandlerKt.access$get(offsetMap, offsetKey2);
                    if (n4 != null) {
                        int it = ((Number)n4).intValue();
                        boolean bl = false;
                        n3 = it - 1;
                    } else {
                        n3 = null;
                    }
                    if (n3 != null) {
                        n = n3;
                    } else {
                        throw new IllegalStateException("No valid offsets found in context: " + offsetMap);
                    }
                }
                int elementOffset = n;
                PsiElement psiElement3 = context.getFile().findElementAt(elementOffset);
                if (psiElement3 == null) {
                    return;
                }
                PsiElement element = psiElement3;
                this.addArguments(context, element);
                if (!Intrinsics.areEqual(this.getCallType(), (Object)CallType.DEFAULT.INSTANCE) || (psiElement2 = context.getFile().findElementAt(elementOffset)) == null || (psiElement = psiElement2.getParent()) == null) break block11;
                PsiElement it = psiElement;
                boolean $i$f$getLastParentOfTypeInRow = false;
                Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)$this$getLastParentOfTypeInRow$iv), (Function1)Normal$handleInsert$$inlined$getLastParentOfTypeInRow$1.INSTANCE));
                if (!(object instanceof KtDotQualifiedExpression)) {
                    object = null;
                }
                if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)((KtDotQualifiedExpression)object))) != null && (smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktDotQualifiedExpression))) != null) {
                    SmartPsiElementPointer it2 = smartPsiElementPointer;
                    boolean bl = false;
                    psiDocumentManager.commitDocument(document2);
                    KtDotQualifiedExpression ktDotQualifiedExpression2 = (KtDotQualifiedExpression)it2.getElement();
                    if (ktDotQualifiedExpression2 != null) {
                        KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression2;
                        ShortenReferences.process$default(KotlinCallableInsertHandler.Companion.getSHORTEN_REFERENCES(), (KtElement)dotQualifiedExpression, null, 2, null);
                    }
                }
            }
        }

        private final void addArguments(InsertionContext context, PsiElement offsetElement) {
            Integer n;
            Integer openingBracketOffset;
            int offset1;
            char completionChar = context.getCompletionChar();
            if (completionChar == '(') {
                context.setAddCompletionChar(false);
            }
            int offset = context.getTailOffset();
            Document document = context.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            Editor editor = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            CharSequence chars = null;
            CharSequence charSequence = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            chars = charSequence;
            boolean isSmartEnterCompletion = completionChar == '\r';
            boolean isReplaceCompletion = completionChar == '\t';
            boolean isNormalCompletion = completionChar == '\n';
            boolean insertLambda = this.lambdaInfo != null && completionChar != '(' && (!isReplaceCompletion || !HandlerUtilsKt.isCharAt(chars, offset, '('));
            char openingBracket = insertLambda ? (char)'{' : '(';
            char closingBracket = insertLambda ? (char)'}' : ')';
            boolean insertTypeArguments = this.inputTypeArguments && (isNormalCompletion || isReplaceCompletion || isSmartEnterCompletion);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            if (isReplaceCompletion && (offset1 = HandlerUtilsKt.skipSpaces(chars, offset)) < chars.length() && chars.charAt(offset1) == '<') {
                PsiElement parent2;
                psiDocumentManager.commitDocument(document2);
                PsiElement psiElement = context.getFile().findElementAt(offset1);
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement token = psiElement;
                if (Intrinsics.areEqual((Object)token.getNode().getElementType(), (Object)KtTokens.LT) && (parent2 = token.getParent()) instanceof KtTypeArgumentList) {
                    String string = ((KtTypeArgumentList)parent2).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (StringsKt.indexOf$default((CharSequence)string, (char)'\n', (int)0, (boolean)false, (int)6, null) < 0) {
                        offset = PsiUtilsKt.getEndOffset((PsiElement)parent2);
                        insertTypeArguments = false;
                    }
                }
            }
            if (insertLambda) {
                GenerateLambdaInfo generateLambdaInfo = this.lambdaInfo;
                Intrinsics.checkNotNull((Object)generateLambdaInfo);
                if (generateLambdaInfo.getExplicitParameters()) {
                    insertTypeArguments = false;
                }
            }
            if (insertTypeArguments) {
                document2.insertString(offset, (CharSequence)"<>");
                CharSequence charSequence2 = document2.getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getCharsSequence(...)");
                chars = charSequence2;
                editor2.getCaretModel().moveToOffset(offset + 1);
                offset += 2;
            }
            Integer n2 = openingBracketOffset = HandlerUtilsKt.indexOfSkippingSpace(chars, openingBracket, offset);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                n = HandlerUtilsKt.indexOfSkippingSpace(chars, closingBracket, it + 1);
            } else {
                n = null;
            }
            Integer closeBracketOffset = n;
            int inBracketsShift = 0;
            if (insertLambda) {
                GenerateLambdaInfo generateLambdaInfo = this.lambdaInfo;
                Intrinsics.checkNotNull((Object)generateLambdaInfo);
                if (generateLambdaInfo.getExplicitParameters() && closeBracketOffset == null) {
                    openingBracketOffset = null;
                }
            }
            if (openingBracketOffset == null) {
                if (insertLambda) {
                    switch (completionChar) {
                        case ' ': 
                        case '{': {
                            context.setAddCompletionChar(false);
                        }
                    }
                    PsiFile psiFile = context.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                    if (this.isInsertSpacesInOneLineFunctionEnabled(psiFile)) {
                        document2.insertString(offset, (CharSequence)" {  }");
                        inBracketsShift = 1;
                    } else {
                        document2.insertString(offset, (CharSequence)" {}");
                    }
                } else if (isSmartEnterCompletion) {
                    document2.insertString(offset, (CharSequence)"(");
                } else {
                    document2.insertString(offset, (CharSequence)"()");
                }
                psiDocumentManager.commitDocument(document2);
                CharSequence charSequence3 = document2.getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getCharsSequence(...)");
                Integer n3 = HandlerUtilsKt.indexOfSkippingSpace(charSequence3, openingBracket, offset);
                Intrinsics.checkNotNull((Object)n3);
                openingBracketOffset = n3;
                CharSequence charSequence4 = document2.getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence4, (String)"getCharsSequence(...)");
                closeBracketOffset = HandlerUtilsKt.indexOfSkippingSpace(charSequence4, closingBracket, openingBracketOffset + 1);
            }
            if (insertLambda) {
                GenerateLambdaInfo generateLambdaInfo = this.lambdaInfo;
                Intrinsics.checkNotNull((Object)generateLambdaInfo);
                if (generateLambdaInfo.getExplicitParameters()) {
                    int n4 = openingBracketOffset;
                    Integer n5 = closeBracketOffset;
                    Intrinsics.checkNotNull((Object)n5);
                    KotlinFunctionInsertHandlerKt.access$insertLambdaSignatureTemplate(n4, n5, this.lambdaInfo.getLambdaType(), context, context);
                    return;
                }
            }
            document2.insertString(openingBracketOffset + 1, (CharSequence)this.argumentText);
            if (closeBracketOffset != null) {
                closeBracketOffset = closeBracketOffset + this.argumentText.length();
            }
            if (!insertTypeArguments) {
                if (this.shouldPlaceCaretInBrackets(completionChar) || closeBracketOffset == null) {
                    editor2.getCaretModel().moveToOffset(openingBracketOffset + 1 + inBracketsShift);
                    AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project2);
                    if (autoPopupController != null) {
                        autoPopupController.autoPopupParameterInfo(editor2, offsetElement);
                    }
                } else {
                    editor2.getCaretModel().moveToOffset(closeBracketOffset + 1);
                }
            }
        }

        private final boolean shouldPlaceCaretInBrackets(char completionChar) {
            switch (completionChar) {
                case ',': 
                case '.': 
                case '=': {
                    return false;
                }
            }
            if (completionChar == '(') {
                return true;
            }
            return this.inputValueArguments || this.lambdaInfo != null;
        }

        private final boolean isInsertSpacesInOneLineFunctionEnabled(PsiFile file) {
            return CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)file).INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$OnlyName;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "<init>", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "kotlin.completion.impl.k1"})
    public static final class OnlyName
    extends KotlinFunctionInsertHandler {
        public OnlyName(@NotNull CallType<?> callType) {
            Intrinsics.checkNotNullParameter(callType, (String)"callType");
            super(callType, null);
        }
    }
}

