/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinExpressionWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentPatcher;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "expressionWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinExpressionWrapper;", "addWrapper", "wrapper", "wrapFragmentExpressionIfNeeded", "", "stats", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;", "replaceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "newExpressionText", "", "extractExpressionWithText", "Lkotlin/Pair;", "Companion", "kotlin.jvm-debugger.evaluation"})
final class KotlinCodeFragmentPatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final List<KotlinExpressionWrapper> expressionWrappers;
    @NotNull
    private static final Logger LOG;

    public KotlinCodeFragmentPatcher(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.expressionWrappers = new ArrayList();
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final KotlinCodeFragmentPatcher addWrapper(@NotNull KotlinExpressionWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this.expressionWrappers.add(wrapper);
        return this;
    }

    public final void wrapFragmentExpressionIfNeeded(@NotNull CodeFragmentCompilationStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Pair<KtExpression, String> pair = this.extractExpressionWithText();
        if (pair == null) {
            return;
        }
        Pair<KtExpression, String> pair2 = pair;
        KtExpression expression = (KtExpression)pair2.component1();
        String expressionText = (String)pair2.component2();
        Object object = stats.startAndMeasureWrapAnalysisUnderReadAction-IoAF18A(() -> KotlinCodeFragmentPatcher.wrapFragmentExpressionIfNeeded$lambda$0(expressionText, this, expression));
        ResultKt.throwOnFailure((Object)object);
        String newExpressionText = (String)object;
        if (!Intrinsics.areEqual((Object)newExpressionText, (Object)expressionText)) {
            this.replaceExpression(expression, newExpressionText);
        }
    }

    private final void replaceExpression(KtExpression expression, String newExpressionText) {
        KtExpression newExpression = (KtExpression)ActionsKt.runReadAction(() -> KotlinCodeFragmentPatcher.replaceExpression$lambda$1(expression, newExpressionText));
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> KotlinCodeFragmentPatcher.replaceExpression$lambda$3(expression, newExpression), (int)1, null);
    }

    private final Pair<KtExpression, String> extractExpressionWithText() {
        return (Pair)ActionsKt.runReadAction(() -> KotlinCodeFragmentPatcher.extractExpressionWithText$lambda$4(this));
    }

    private static final String wrapFragmentExpressionIfNeeded$lambda$0(String $expressionText, KotlinCodeFragmentPatcher this$0, KtExpression $expression) {
        String newExpressionText = $expressionText;
        for (KotlinExpressionWrapper wrapper : this$0.expressionWrappers) {
            if (!wrapper.isApplicable($expression)) continue;
            newExpressionText = wrapper.createWrappedExpressionText(newExpressionText);
        }
        return newExpressionText;
    }

    private static final KtExpression replaceExpression$lambda$1(KtExpression $expression, String $newExpressionText) {
        Project project = $expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new KtPsiFactory(project, false, 2, null).createExpression($newExpressionText);
    }

    private static final Unit replaceExpression$lambda$3$lambda$2(KtExpression $expression, KtExpression $newExpression) {
        $expression.replace((PsiElement)$newExpression);
        return Unit.INSTANCE;
    }

    private static final Unit replaceExpression$lambda$3(KtExpression $expression, KtExpression $newExpression) {
        Project project = $expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ApplicationUtilsKt.executeWriteCommand(project, KotlinDebuggerEvaluationBundle.message("wrap.expression", new Object[0]), (Function0<Unit>)((Function0)() -> KotlinCodeFragmentPatcher.replaceExpression$lambda$3$lambda$2($expression, $newExpression)));
        return Unit.INSTANCE;
    }

    private static final Pair extractExpressionWithText$lambda$4(KotlinCodeFragmentPatcher this$0) {
        KtExpression ktExpression;
        KtCodeFragment ktCodeFragment = this$0.codeFragment;
        if (ktCodeFragment instanceof KtExpressionCodeFragment) {
            ktExpression = ((KtExpressionCodeFragment)this$0.codeFragment).getContentElement();
        } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
            List list2 = ((KtBlockCodeFragment)this$0.codeFragment).getContentElement().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list2);
        } else {
            LOG.error("Invalid code fragment type: " + this$0.getClass());
            ktExpression = null;
        }
        KtExpression expression = ktExpression;
        return expression == null ? null : new Pair((Object)expression, (Object)expression.getText());
    }

    static {
        Logger logger = Logger.getInstance(KotlinCodeFragmentPatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentPatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

