/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.CallableReturnTypeUpdaterUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/PublicApiImplicitTypeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "reportInternal", "", "reportPrivate", "<init>", "(ZZ)V", "problemText", "", "getProblemText", "()Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "kotlin.code-insight.inspections.k2"})
public final class PublicApiImplicitTypeInspection
extends AbstractKotlinInspection {
    @JvmField
    public boolean reportInternal;
    @JvmField
    public boolean reportPrivate;

    public PublicApiImplicitTypeInspection(boolean reportInternal, boolean reportPrivate) {
        this.reportInternal = reportInternal;
        this.reportPrivate = reportPrivate;
    }

    public /* synthetic */ PublicApiImplicitTypeInspection(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    private final String getProblemText() {
        return !this.reportInternal && !this.reportPrivate ? KotlinBundle.message((String)"for.api.stability.it.s.recommended.to.specify.explicitly.public.protected.declaration.types", (Object[])new Object[0]) : KotlinBundle.message((String)"for.api.stability.it.s.recommended.to.specify.explicitly.declaration.types", (Object[])new Object[0]);
    }

    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(holder2, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PublicApiImplicitTypeInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitNamedDeclaration(KtNamedDeclaration declaration) {
                void this_$iv$iv;
                void useSiteElement$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!(declaration instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration).getTypeReference() != null) {
                    return;
                }
                PsiElement psiElement = ((KtCallableDeclaration)declaration).getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement nameIdentifier = psiElement;
                if (declaration instanceof KtFunction && (((KtFunction)declaration).getBodyBlockExpression() != null || !((KtFunction)declaration).hasBody())) {
                    return;
                }
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
                boolean bl = ktClassOrObject != null ? ktClassOrObject.isLocal() : false;
                if (bl) {
                    return;
                }
                if (declaration instanceof KtFunction && ((KtFunction)declaration).isLocal()) {
                    return;
                }
                if (declaration instanceof KtProperty && ((KtProperty)declaration).isLocal()) {
                    return;
                }
                if (declaration instanceof KtParameter) {
                    return;
                }
                KtElement ktElement = (KtElement)declaration;
                ProblemsHolder problemsHolder = this.$holder;
                PublicApiImplicitTypeInspection publicApiImplicitTypeInspection = this.this$0;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                void useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        boolean bl2 = false;
                        KaSession $this$visitNamedDeclaration_u24lambda_u240 = analysisSession$iv$iv;
                        boolean bl3 = false;
                        if (this.shouldReportDeclarationVisibility($this$visitNamedDeclaration_u24lambda_u240, (KtCallableDeclaration)declaration)) {
                            CallableReturnTypeUpdaterUtils.TypeInfo typeInfo = CallableReturnTypeUpdaterUtils.INSTANCE.getTypeInfo($this$visitNamedDeclaration_u24lambda_u240, (KtCallableDeclaration)declaration, problemsHolder.isOnTheFly());
                            LocalQuickFix fix3 = UtilsKt.asQuickFix((ModCommandAction)new CallableReturnTypeUpdaterUtils.SpecifyExplicitTypeQuickFix((KtCallableDeclaration)declaration, typeInfo));
                            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix3};
                            problemsHolder.registerProblem(nameIdentifier, PublicApiImplicitTypeInspection.access$getProblemText(publicApiImplicitTypeInspection), localQuickFixArray);
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv$iv);
                }
            }

            private final boolean shouldReportDeclarationVisibility(KaSession $context_receiver_0, KtCallableDeclaration declaration) {
                KaDeclarationSymbol declarationSymbol = $context_receiver_0.getSymbol((KtDeclaration)declaration);
                if (this.this$0.reportInternal && declarationSymbol.getVisibility() == KaSymbolVisibility.INTERNAL || this.this$0.reportPrivate && declarationSymbol.getVisibility() == KaSymbolVisibility.PRIVATE) {
                    return true;
                }
                boolean reportPublic = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration).getFlag(AnalysisFlags.getExplicitApiMode()) == ExplicitApiMode.DISABLED;
                return reportPublic && $context_receiver_0.isPublicApi(declarationSymbol);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"reportInternal", (String)KotlinBundle.message((String)"apply.also.to.internal.members", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportPrivate", (String)KotlinBundle.message((String)"apply.also.to.private.members", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public PublicApiImplicitTypeInspection() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ String access$getProblemText(PublicApiImplicitTypeInspection $this) {
        return $this.getProblemText();
    }
}

