/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell.frontend;

import com.intellij.execution.jshell.protocol.CodeSnippet;
import com.intellij.execution.jshell.protocol.Event;
import com.intellij.execution.jshell.protocol.Message;
import com.intellij.execution.jshell.protocol.MessageReader;
import com.intellij.execution.jshell.protocol.MessageWriter;
import com.intellij.execution.jshell.protocol.Request;
import com.intellij.execution.jshell.protocol.Response;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import jdk.jshell.ExpressionSnippet;
import jdk.jshell.ImportSnippet;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.MethodSnippet;
import jdk.jshell.PersistentSnippet;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.TypeDeclSnippet;
import jdk.jshell.VarSnippet;

public class Main {
    private static final String ARG_CLASSPATH = "--class-path";
    private static final String ARG_CLASSPATH_FILE = "--@class-path";
    private static final Consumer<String> NULL_CONSUMER = s -> {};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        MessageReader reader = new MessageReader((InputStream)new BufferedInputStream(System.in), Request.class);
        MessageWriter writer = new MessageWriter((OutputStream)new BufferedOutputStream(System.out));
        try (JShell shell = JShell.create();){
            Request request;
            Main.configureJShell(args, shell);
            block15: while ((request = (Request)reader.receive(NULL_CONSUMER)) != null) {
                Request.Command command = request.getCommand();
                if (command == Request.Command.EXIT) {
                    return;
                }
                Response response = new Response(request.getUid(), new Event[0]);
                try {
                    SourceCodeAnalysis.CompletionInfo info;
                    List cp = request.getClassPath();
                    if (cp != null && !cp.isEmpty()) {
                        for (String path : cp) {
                            shell.addToClasspath(path);
                        }
                    }
                    if (command == Request.Command.DROP_STATE) {
                        shell.snippets().forEach(snippet -> Main.exportEvents(shell, shell.drop((Snippet)snippet), response));
                        continue;
                    }
                    if (command != Request.Command.EVAL) continue;
                    ArrayList<Object> toEval = new ArrayList<Object>();
                    String input = request.getCodeText();
                    do {
                        SourceCodeAnalysis.Completeness completeness;
                        if ((completeness = (info = shell.sourceCodeAnalysis().analyzeCompletion(input)).completeness()).isComplete()) {
                            toEval.add(completeness == SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI ? info.source() + ";" : info.source());
                            continue;
                        }
                        if (completeness == SourceCodeAnalysis.Completeness.EMPTY) continue;
                        toEval.add(info.source());
                    } while ((input = info.remaining()) != null && !input.isEmpty());
                    Iterator iterator = toEval.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block15;
                        String inputElement = (String)iterator.next();
                        Main.exportEvents(shell, shell.eval(inputElement), response);
                    }
                }
                finally {
                    writer.send((Message)response);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("\nJShell terminated.");
        }
    }

    private static void exportEvents(JShell shell, List<SnippetEvent> events, Response response) {
        for (SnippetEvent event : events) {
            Snippet.Status status = event.status();
            Snippet snippet = event.snippet();
            Event e = new Event(Main.createCodeSnippet(snippet), Main.createCodeSnippet(event.causeSnippet()), Main.convertEnum(status, CodeSnippet.Status.class), Main.convertEnum(event.previousStatus(), CodeSnippet.Status.class), event.value());
            JShellException exception = event.exception();
            if (exception != null) {
                e.setExceptionText(exception.getMessage());
            }
            if (status == Snippet.Status.RECOVERABLE_DEFINED || status == Snippet.Status.RECOVERABLE_NOT_DEFINED || status == Snippet.Status.REJECTED) {
                StringBuilder buf = new StringBuilder();
                shell.diagnostics(snippet).forEach(diagnostic -> {
                    String message = diagnostic.getMessage(Locale.US);
                    if (message != null && !message.isEmpty()) {
                        if (buf.length() > 0) {
                            buf.append("\n");
                        }
                        if (diagnostic.isError()) {
                            buf.append("ERROR: ");
                        }
                        buf.append(message);
                    }
                });
                if (buf.length() > 0) {
                    e.setDiagnostic(buf.toString());
                }
            }
            response.addEvent(e);
        }
    }

    private static void configureJShell(String[] args, JShell shell) throws IOException {
        boolean cpFound = false;
        boolean cpFileFound = false;
        for (String arg : args) {
            if (ARG_CLASSPATH.equals(arg)) {
                cpFound = true;
                continue;
            }
            if (ARG_CLASSPATH_FILE.equals(arg)) {
                cpFileFound = true;
                continue;
            }
            if (cpFound) {
                cpFound = false;
                for (String path : arg.split(File.pathSeparator)) {
                    shell.addToClasspath(path);
                }
                continue;
            }
            if (!cpFileFound) continue;
            cpFileFound = false;
            File cpFile = new File(arg);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cpFile), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    shell.addToClasspath(line);
                    line = reader.readLine();
                }
            }
        }
    }

    private static CodeSnippet createCodeSnippet(Snippet snippet) {
        return snippet == null ? null : new CodeSnippet(snippet.id(), Main.convertEnum(snippet.kind(), CodeSnippet.Kind.class), Main.convertEnum(snippet.subKind(), CodeSnippet.SubKind.class), snippet.source(), Main.createPresentation(snippet));
    }

    private static String createPresentation(Snippet snippet) {
        if (snippet instanceof ExpressionSnippet) {
            ExpressionSnippet expr = (ExpressionSnippet)snippet;
            return expr.typeName() + " " + expr.name();
        }
        if (snippet instanceof ImportSnippet) {
            return ((ImportSnippet)snippet).fullname();
        }
        if (snippet instanceof MethodSnippet) {
            MethodSnippet methodSnippet = (MethodSnippet)snippet;
            StringBuilder buf = new StringBuilder(Main.getReturnType(methodSnippet));
            if (buf.length() > 0) {
                buf.append(" ");
            }
            return buf.append(methodSnippet.name()).append("(").append(methodSnippet.parameterTypes()).append(")").toString();
        }
        if (snippet instanceof TypeDeclSnippet) {
            return ((TypeDeclSnippet)snippet).name();
        }
        if (snippet instanceof VarSnippet) {
            VarSnippet varSnippet = (VarSnippet)snippet;
            return varSnippet.typeName() + " " + varSnippet.name();
        }
        if (snippet instanceof PersistentSnippet) {
            return ((PersistentSnippet)snippet).name();
        }
        return null;
    }

    private static String getReturnType(MethodSnippet methodSnippet) {
        String sig = methodSnippet.signature();
        int idx = sig == null ? -1 : sig.lastIndexOf(")");
        return idx > 0 ? sig.substring(idx + 1) : "";
    }

    private static <TI extends Enum<TI>, TO extends Enum<TO>> TO convertEnum(Enum<TI> from, Class<TO> toEnumOfClass) {
        if (from != null) {
            try {
                return Enum.valueOf(toEnumOfClass, from.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Enum.valueOf(toEnumOfClass, "UNKNOWN");
    }
}

