/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.counting.giga;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.giga.VirtualCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GigaCounter
implements Counter {
    private static final long serialVersionUID = 8266734684040886875L;
    private static final int FILES_PER_COUNTER = 100;
    private static final int TOKENS_PER_COUNTER = 100000;
    private final List<Map<List<Integer>, Integer>> simpleCounters;
    private List<byte[]> graveyard;
    private final int procs;
    private static volatile ForkJoinPool fjp;
    private int[][] counts;
    private volatile boolean[] occupied;
    private VirtualCounter counter;

    public GigaCounter() {
        this(Runtime.getRuntime().availableProcessors() / 2);
    }

    public GigaCounter(int procs) {
        this.procs = procs;
        if (fjp == null) {
            fjp = new ForkJoinPool(this.procs);
        }
        this.simpleCounters = IntStream.range(0, this.procs).mapToObj(i -> new HashMap()).collect(Collectors.toList());
        this.occupied = new boolean[this.simpleCounters.size()];
        this.counts = new int[this.simpleCounters.size()][2];
        this.graveyard = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public int getCount() {
        this.resolve();
        return this.counter.getCount();
    }

    @Override
    public long[] getCounts(List<Integer> indices) {
        this.resolve();
        return this.counter.getCounts(indices);
    }

    @Override
    public int getCountOfCount(int n, int count) {
        this.resolve();
        return this.counter.getCountOfCount(n, count);
    }

    @Override
    public int getSuccessorCount() {
        this.resolve();
        return this.counter.getSuccessorCount();
    }

    @Override
    public int getSuccessorCount(List<Integer> indices) {
        this.resolve();
        return this.counter.getSuccessorCount(indices);
    }

    @Override
    public List<Integer> getTopSuccessors(List<Integer> indices, int limit) {
        this.resolve();
        return this.counter.getTopSuccessors(indices, limit);
    }

    @Override
    public int[] getDistinctCounts(int range, List<Integer> indices) {
        this.resolve();
        return this.counter.getDistinctCounts(range, indices);
    }

    @Override
    public void countBatch(List<List<Integer>> indices) {
        if (this.counter != null) {
            this.counter.countBatch(indices);
        } else {
            this.submitTask(indices);
        }
    }

    @Override
    public void count(List<Integer> indices) {
        if (this.counter != null) {
            this.counter.count(indices);
        } else {
            this.submitTask(indices);
        }
    }

    private void submitTask(List<?> task) {
        if (task.isEmpty()) {
            return;
        }
        int ptr = this.getNextAvailable();
        this.occupied[ptr] = true;
        while (fjp.getPoolSize() > 100) {
        }
        fjp.submit(() -> {
            this.testGraveYard(ptr);
            if (task.get(0) instanceof List) {
                task.forEach(x -> this.simpleCounters.get(ptr).merge((List)x, 1, Integer::sum));
            } else {
                this.simpleCounters.get(ptr).merge(task, 1, Integer::sum);
            }
            int[] nArray = this.counts[ptr];
            nArray[0] = nArray[0] + 1;
            this.occupied[ptr] = false;
        });
    }

    @Override
    public void unCount(List<Integer> indices) {
        this.resolve();
        this.counter.unCount(indices);
    }

    private synchronized void resolve() {
        if (this.counter != null) {
            return;
        }
        while (IntStream.range(0, this.simpleCounters.size()).anyMatch(i -> this.occupied[i])) {
        }
        if (this.graveyard.size() >= 10) {
            System.out.println("Resolving to VirtualCounter");
        }
        long t = System.currentTimeMillis();
        this.simpleCounters.stream().filter(c -> !c.isEmpty()).forEach(this::pack);
        this.simpleCounters.clear();
        this.counter = new VirtualCounter(16);
        this.unPackAll();
        if (this.graveyard.size() >= 10) {
            System.out.println("Resolved in " + (System.currentTimeMillis() - t) / 1000L + "s");
        }
        System.gc();
    }

    private void pack(Map<List<Integer>, Integer> c) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeInt(c.size());
            c.entrySet().stream().sorted((e1, e2) -> this.compareLists((List)e1.getKey(), (List)e2.getKey())).forEach(e -> {
                List key = (List)e.getKey();
                Integer value = (Integer)e.getValue();
                try {
                    out.writeInt(key.size());
                    Iterator iterator = key.iterator();
                    while (iterator.hasNext()) {
                        int k = (Integer)iterator.next();
                        out.writeInt(k);
                    }
                    out.writeInt(value);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
            out.close();
            this.graveyard.add(baos.toByteArray());
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void unPackAll() {
        int[] done = new int[]{0};
        IntStream.range(0, this.procs).parallel().forEach(i -> {
            for (int j = i; j < this.graveyard.size(); j += this.procs) {
                try {
                    ByteArrayInputStream baos = new ByteArrayInputStream(this.graveyard.get(j));
                    ObjectInputStream in = new ObjectInputStream(baos);
                    int size = in.readInt();
                    for (int q = 0; q < size; ++q) {
                        int len = in.readInt();
                        ArrayList<Integer> key = new ArrayList<Integer>(len);
                        for (int k = 0; k < len; ++k) {
                            key.add(in.readInt());
                        }
                        int freq = in.readInt();
                        this.counter.count(key, freq);
                    }
                    in.close();
                    this.graveyard.set(j, null);
                    if (this.graveyard.size() < 10 || (done[0] = done[0] + 1) % (this.graveyard.size() / 10) != 0) continue;
                    System.out.print(100 * done[0] / this.graveyard.size() + "%...");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.graveyard.size() >= 10) {
            System.out.println();
        }
    }

    private int compareLists(List<Integer> key1, List<Integer> key2) {
        for (int i = 0; i < key1.size() && i < key2.size(); ++i) {
            int compare = Integer.compare(key1.get(i), key2.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(key1.size(), key2.size());
    }

    private int getNextAvailable() {
        int ptr = 0;
        while (this.occupied[ptr]) {
            ptr = (ptr + 1) % this.simpleCounters.size();
        }
        return ptr;
    }

    private void testGraveYard(int ptr) {
        if (this.counts[ptr][0] > 100 || this.counts[ptr][1] > 100000) {
            this.pack(this.simpleCounters.get(ptr));
            this.simpleCounters.set(ptr, new HashMap());
            this.counts[ptr][0] = 0;
            this.counts[ptr][1] = 0;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.resolve();
        this.counter.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.counter = new VirtualCounter(0);
        this.counter.readExternal(in);
    }
}

