/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabeledComponent
extends JPanel {
    JPanel rightPanel;
    String labelStr;
    String valueLabelStr;
    String compoundStr;
    JLabel label;
    JComponent comp;

    public LabeledComponent(String text, JComponent comp) {
        this(text, 0, comp);
    }

    public LabeledComponent(String text, int mnemonic, JComponent comp) {
        super(new BorderLayout(6, 6));
        this.labelStr = text;
        this.label = new JLabel(text, 4);
        this.comp = comp;
        this.label.setLabelFor(comp);
        if (mnemonic > 0) {
            this.label.setDisplayedMnemonic(mnemonic);
        }
        this.add((Component)this.label, "West");
        this.add((Component)comp, "Center");
    }

    public void setLabel(String str) {
        this.labelStr = str;
        this.updateLabel();
    }

    public void setValueLabel(String str) {
        this.valueLabelStr = str;
        this.updateLabel();
    }

    private void updateLabel() {
        String str = this.labelStr;
        this.label.setText(str);
        this.compoundStr = str;
        JComponent container = (JComponent)this.getParent();
        LabeledComponent.layout(container);
    }

    public static void layout(Container container) {
        LabeledComponent lc;
        int wMax = 0;
        for (Component c : container.getComponents()) {
            if (!(c instanceof LabeledComponent)) continue;
            lc = (LabeledComponent)c;
            lc.label.setPreferredSize(null);
            int w = lc.label.getPreferredSize().width;
            if (w <= wMax) continue;
            wMax = w;
        }
        for (Component c : container.getComponents()) {
            if (!(c instanceof LabeledComponent)) continue;
            lc = (LabeledComponent)c;
            JLabel label = lc.label;
            int h = label.getPreferredSize().height;
            label.setPreferredSize(new Dimension(wMax, h));
            label.setHorizontalAlignment(4);
        }
    }
}

