/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TempArray;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Isosurface
extends MeshCollection
implements MeshDataServer {
    protected IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    protected IsosurfaceMesh thisMesh;
    private String actualID;
    protected boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private float[] moLinearCombination;
    private int colorType;
    private short defaultColix;
    private short meshColix;
    private P3 center;
    private float scale3d;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    private String scriptAppendix = "";
    protected SurfaceGenerator sg;
    private float withinDistance2;
    private boolean isWithinNot;
    private Lst<P3> withinPoints;
    private float[] cutoffRange;
    boolean allowMesh = true;
    private String script;
    private boolean iHaveModelIndex;
    private int nLCAO = 0;
    private P4 lcaoDir = new P4();
    private boolean associateNormals;
    private String oldFileName;
    private String newFileName;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();
    public int[] keyXy;

    @Override
    public void allocMesh(String thisID, Mesh m) {
        int index = this.meshCount++;
        this.isomeshes = (IsosurfaceMesh[])AU.ensureLength(this.isomeshes, this.meshCount * 2);
        this.meshes = this.isomeshes;
        this.isomeshes[index] = m == null ? new IsosurfaceMesh(this.vwr, thisID, this.colix, index) : (IsosurfaceMesh)m;
        this.thisMesh = this.isomeshes[index];
        this.currentMesh = this.isomeshes[index];
        this.currentMesh.index = index;
        if (this.sg != null) {
            this.jvxlData = this.thisMesh.jvxlData;
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    protected void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.vwr, this, null, this.jvxlData);
        this.sg.params.showTiming = this.vwr.getBoolean(603979934);
        this.sg.version = "Jmol " + Viewer.getJmolVersion();
    }

    protected void clearSg() {
        this.sg = null;
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        this.setPropI(propertyName, value, bs);
    }

    protected void setPropI(String propertyName, Object value, BS bs) {
        int i;
        if ("cache" == propertyName) {
            if (this.currentMesh == null) {
                return;
            }
            String id = this.currentMesh.thisID;
            int imodel = this.currentMesh.modelIndex;
            this.vwr.cachePut("cache://isosurface_" + id, ((String)this.getPropI("jvxlDataXml", -1)).getBytes());
            this.deleteMeshI(this.currentMesh.index);
            this.setPropI("init", null, null);
            this.setPropI("thisID", id, null);
            this.setPropI("modelIndex", imodel, null);
            this.setPropI("fileName", "cache://isosurface_" + id, null);
            this.setPropI("readFile", null, null);
            this.setPropI("finalize", "isosurface ID " + PT.esc(id) + (imodel >= 0 ? " modelIndex " + imodel : "") + " /*file*/" + PT.esc("cache://isosurface_" + id), null);
            this.setPropI("clear", null, null);
            return;
        }
        if ("delete" == propertyName) {
            this.setPropertySuper(propertyName, value, bs);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("remapInherited" == propertyName) {
            int i2 = this.meshCount;
            while (--i2 >= 0) {
                if (this.isomeshes[i2] == null || !"#inherit;".equals(this.isomeshes[i2].colorCommand)) continue;
                this.isomeshes[i2].remapColors(this.vwr, null, Float.NaN);
            }
            return;
        }
        if ("remapColor" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.remapColors(this.vwr, (ColorEncoder)value, this.translucentLevel);
            }
            return;
        }
        if ("thisID" == propertyName) {
            if (this.actualID != null) {
                value = this.actualID;
            }
            this.setPropertySuper("thisID", value, null);
            return;
        }
        if ("params" == propertyName) {
            if (this.thisMesh != null) {
                this.ensureMeshSource();
                this.thisMesh.checkAllocColixes();
                Object[] data = value;
                short[] colixes = (short[])data[0];
                int[] atomMap = null;
                if (colixes != null) {
                    for (int i3 = 0; i3 < colixes.length; ++i3) {
                        short colix = colixes[i3];
                        float f = 0.0f;
                        if (f > 0.01f) {
                            colix = C.getColixTranslucent3(colix, true, f);
                        }
                        colixes[i3] = colix;
                    }
                    atomMap = new int[bs.length()];
                    int pt = 0;
                    int i4 = bs.nextSetBit(0);
                    while (i4 >= 0) {
                        atomMap[i4] = pt++;
                        i4 = bs.nextSetBit(i4 + 1);
                    }
                }
                this.thisMesh.setVertexColixesForAtoms(this.vwr, colixes, atomMap, bs);
                this.thisMesh.setVertexColorMap();
            }
            return;
        }
        if ("atomcolor" == propertyName) {
            if (this.thisMesh != null) {
                this.ensureMeshSource();
                this.thisMesh.colorVertices(C.getColixO(value), bs, true);
            }
            return;
        }
        if ("pointSize" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.volumeRenderPointSize = ((Float)value).floatValue();
            }
            return;
        }
        if ("vertexcolor" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.colorVertices(C.getColixO(value), bs, false);
            }
            return;
        }
        if ("colorPhase" == propertyName) {
            Object[] colors = value;
            short colix0 = C.getColix((Integer)colors[0]);
            short colix1 = C.getColix((Integer)colors[1]);
            String id = this.thisMesh != null ? this.thisMesh.thisID : (PT.isWild(this.previousMeshID) ? this.previousMeshID : null);
            Lst<Mesh> list = this.getMeshList(id, false);
            int i5 = list.size();
            while (--i5 >= 0) {
                this.setColorPhase((IsosurfaceMesh)list.get(i5), colix0, colix1);
            }
            return;
        }
        if ("color" == propertyName) {
            String color = C.getHexCode(C.getColixO(value));
            if (this.thisMesh != null) {
                this.setIsoMeshColor(this.thisMesh, color);
            } else {
                Lst<Mesh> list = this.getMeshList(PT.isWild(this.previousMeshID) ? this.previousMeshID : null, false);
                int i6 = list.size();
                while (--i6 >= 0) {
                    this.setIsoMeshColor((IsosurfaceMesh)list.get(i6), color);
                }
            }
            this.setPropertySuper(propertyName, value, bs);
            return;
        }
        if ("nocontour" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.deleteContours();
            }
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            this.setMeshI();
            return;
        }
        if ("newObject" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.clearType(this.thisMesh.meshType, false);
            }
            return;
        }
        if ("moveIsosurface" == propertyName) {
            if (this.thisMesh != null && !this.thisMesh.isModelConnected) {
                this.thisMesh.updateCoordinates((M4)value, null);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("refreshTrajectories" == propertyName) {
            int m = (Integer)((Object[])value)[0];
            int i7 = this.meshCount;
            while (--i7 >= 0) {
                if (this.meshes[i7].modelIndex != m || this.meshes[i7].connectedAtoms == null && !this.meshes[i7].isModelConnected) continue;
                ((IsosurfaceMesh)this.meshes[i7]).updateCoordinates((M4)((Object[])value)[2], (BS)((Object[])value)[1]);
            }
            return;
        }
        if ("modelIndex" == propertyName) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)value;
                this.isFixed = this.modelIndex < 0;
                this.sg.params.modelIndex = Math.abs(this.modelIndex);
            }
            return;
        }
        if ("lcaoCartoon" == propertyName || "lonePair" == propertyName || "radical" == propertyName) {
            V3[] info = (V3[])value;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setProp("lcaoCartoonCenter", info[2], null)) {
                this.drawLcaoCartoon(info[0], info[1], info[3], "lonePair" == propertyName ? 2 : ("radical" == propertyName ? 1 : 0), this.thisMesh == null ? false : this.thisMesh.reverseColor);
            }
            return;
        }
        if ("select" == propertyName && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == propertyName && this.iHaveBitSets) {
            return;
        }
        if ("reversecolor" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.reverseColor = value == Boolean.TRUE;
            }
            return;
        }
        if ("meshcolor" == propertyName) {
            int rgb = (Integer)value;
            this.meshColix = C.getColix(rgb);
            if (this.thisMesh != null) {
                this.thisMesh.meshColix = this.meshColix;
            }
            return;
        }
        if ("offset" == propertyName) {
            P3 offset = P3.newP((P3)value);
            if (offset.lengthSquared() == 0.0f) {
                offset = null;
            }
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(null, offset, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("rotate" == propertyName) {
            P4 pt4 = (P4)value;
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(Quat.newP4(pt4), null, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("bsDisplay" == propertyName) {
            this.bsDisplay = (BS)value;
            return;
        }
        if ("displayWithin" == propertyName) {
            Object[] o = value;
            this.displayWithinDistance2 = ((Float)o[0]).floatValue();
            this.isDisplayWithinNot = this.displayWithinDistance2 < 0.0f;
            this.displayWithinDistance2 *= this.displayWithinDistance2;
            this.displayWithinPoints = (Lst)o[3];
            if (this.displayWithinPoints.size() == 0) {
                this.displayWithinPoints = this.ms.getAtomPointVector((BS)o[2]);
            }
            return;
        }
        if ("finalize" == propertyName) {
            if (this.thisMesh != null) {
                String cmd = (String)value;
                if (cmd != null && !cmd.startsWith("; isosurface map")) {
                    this.thisMesh.setDiscreteColixes(this.sg.params.contoursDiscrete, this.sg.params.contourColixes);
                    this.setJvxlInfo();
                }
                this.setScriptInfo(cmd);
            }
            this.clearSg();
            return;
        }
        if ("connections" == propertyName) {
            if (this.currentMesh != null) {
                this.connections = (int[])value;
                if (this.connections[0] >= 0 && this.connections[0] < this.ms.ac) {
                    this.currentMesh.connectedAtoms = this.connections;
                } else {
                    this.currentMesh.connectedAtoms = null;
                    this.connections = null;
                }
            }
            return;
        }
        if ("fixLattice" == propertyName) {
            if (this.thisMesh != null) {
                this.thisMesh.fixLattice();
            }
            return;
        }
        if ("slab" == propertyName) {
            if (value instanceof Integer) {
                if (this.thisMesh != null) {
                    this.thisMesh.jvxlData.slabValue = (Integer)value;
                }
                return;
            }
            if (this.thisMesh != null) {
                Object[] slabInfo = value;
                int tok = (Integer)slabInfo[0];
                switch (tok) {
                    case 1073742018: {
                        Object[] data = (Object[])slabInfo[1];
                        Mesh m = this.getMesh((String)data[1]);
                        if (m == null) {
                            return;
                        }
                        data[1] = m;
                    }
                }
                this.slabPolygons(slabInfo);
                return;
            }
        }
        if ("cap" == propertyName && this.thisMesh != null && this.thisMesh.pc != 0) {
            this.thisMesh.getMeshSlicer().slabPolygons((Object[])value, true);
            this.thisMesh.initialize(this.thisMesh.lighting, null, null);
            return;
        }
        if ("map" == propertyName) {
            if (this.sg != null) {
                this.sg.params.isMapped = true;
            }
            this.setProperty("squareData", Boolean.FALSE, null);
            if (this.thisMesh == null || this.thisMesh.vc == 0) {
                return;
            }
        }
        if ("probes" == propertyName) {
            if (this.sg != null) {
                this.sg.params.probes = (P3[])value;
                this.sg.params.probeValues = new float[this.sg.params.probes.length];
            }
            return;
        }
        if ("deleteVdw" == propertyName) {
            int i8 = this.meshCount;
            while (--i8 >= 0) {
                if (this.isomeshes[i8].bsVdw == null || bs != null && !bs.intersects(this.isomeshes[i8].bsVdw)) continue;
                this.deleteMeshI(i8);
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("mapColor" == propertyName || "readFile" == propertyName) {
            if (value == null) {
                if (this.sg.params.filesData == null) {
                    value = this.getFileReader(this.sg.params.fileName);
                } else {
                    value = this.sg.params.filesData;
                    String[] a = (String[])this.sg.params.filesData[0];
                    Object[] b = new Object[a.length];
                    i = b.length;
                    while (--i >= 0 && value != null) {
                        b[i] = this.getFileReader(a[i]);
                        if (b[i] != null) continue;
                        value = null;
                    }
                    if (value != null) {
                        this.sg.params.filesData[0] = b;
                    }
                }
                if (value == null) {
                    return;
                }
            }
        } else if ("atomIndex" == propertyName) {
            this.atomIndex = (Integer)value;
            if (this.thisMesh != null) {
                this.thisMesh.atomIndex = this.atomIndex;
            }
        } else if ("center" == propertyName) {
            this.center.setT((P3)value);
        } else if ("colorRGB" == propertyName) {
            int rgb = (Integer)value;
            if (rgb == 1296041985) {
                this.colorType = rgb;
            } else {
                this.colorType = 0;
                this.defaultColix = C.getColix(rgb);
            }
        } else if ("contour" == propertyName) {
            this.explicitContours = true;
        } else if ("functionXY" == propertyName) {
            if (this.sg.params.state == 2) {
                this.setScriptInfo(null);
            }
        } else if ("init" == propertyName) {
            this.newSg();
        } else if ("getSurfaceSets" == propertyName) {
            if (this.thisMesh != null) {
                BS bsSets;
                if (value instanceof BS) {
                    bsSets = (BS)value;
                    if (bsSets.isEmpty()) {
                        bsSets = null;
                    }
                } else {
                    bsSets = new BS();
                    int[] a = (int[])value;
                    i = a.length;
                    while (--i >= 0) {
                        if (a[i] <= 0) continue;
                        bsSets.set(a[i] - 1);
                    }
                }
                this.thisMesh.jvxlData.thisSet = bsSets;
                this.thisMesh.calculatedVolume = null;
                this.thisMesh.calculatedArea = null;
            }
        } else if ("localName" == propertyName) {
            value = this.vwr.getOutputChannel((String)value, null);
            propertyName = "outputChannel";
        } else if ("molecularOrbital" == propertyName) {
            M4 mat4;
            this.isFixed = false;
            this.setMeshI();
            if (value instanceof Integer) {
                this.moNumber = (Integer)value;
                this.moLinearCombination = null;
            } else {
                this.moLinearCombination = (float[])value;
                this.moNumber = 0;
            }
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
            if (!(this.sg != null && this.sg.params.isMapped || (mat4 = this.ms.am[this.currentMesh.modelIndex].mat4) == null)) {
                M4 minv = M4.newM4(mat4);
                minv.invert();
                this.setPropI("modelInvRotation", minv, null);
            }
        } else if ("phase" == propertyName) {
            this.isPhaseColored = true;
        } else if ("plane" != propertyName && "pocket" != propertyName) {
            if ("scale3d" == propertyName) {
                this.scale3d = ((Float)value).floatValue();
                if (this.thisMesh != null) {
                    this.thisMesh.scale3d = this.thisMesh.jvxlData.scale3d = this.scale3d;
                    this.thisMesh.altVertices = null;
                }
            } else if ("title" == propertyName) {
                if (value instanceof String && "-".equals(value)) {
                    value = null;
                }
                this.setPropertySuper(propertyName, value, bs);
                value = this.title;
            } else if ("withinPoints" == propertyName) {
                Object o = value;
                this.withinDistance2 = ((Float)o[0]).floatValue();
                this.isWithinNot = this.withinDistance2 < 0.0f;
                this.withinDistance2 *= this.withinDistance2;
                this.withinPoints = (Lst)o[3];
                if (this.withinPoints.size() == 0) {
                    this.withinPoints = this.ms.getAtomPointVector((BS)o[2]);
                }
            } else if (("nci" == propertyName || "orbital" == propertyName) && this.sg != null) {
                this.sg.params.testFlags = this.vwr.getBoolean(603979962) ? 2 : 0;
            } else if ("cutoffRange" == propertyName) {
                this.cutoffRange = (float[])value;
            }
        }
        if (this.sg != null && this.sg.setProp(propertyName, value, bs)) {
            if (this.sg.isValid) {
                if ("molecularOrbital" == propertyName) {
                    this.currentMesh.isModelConnected = true;
                    this.currentMesh.mat4 = this.ms.am[this.currentMesh.modelIndex].mat4;
                }
                return;
            }
            propertyName = "delete";
        }
        if ("init" == propertyName) {
            this.explicitID = false;
            this.scriptAppendix = "";
            String script = value instanceof String ? (String)value : null;
            int pt = script == null ? -1 : script.indexOf("# ID=");
            this.actualID = pt >= 0 ? PT.getQuotedStringAt(script, pt) : null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            if (script != null && !(this.iHaveBitSets = this.getScriptBitSets(script, null))) {
                this.sg.setProp("select", bs, null);
            }
            this.initializeIsosurface();
            this.sg.params.modelIndex = this.isFixed ? -1 : this.modelIndex;
            return;
        }
        if ("clear" == propertyName) {
            this.discardTempData(true);
            return;
        }
        if ("colorDensity" == propertyName) {
            if (value != null && this.currentMesh != null) {
                this.currentMesh.volumeRenderPointSize = ((Float)value).floatValue();
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])value[2])[0];
            int firstAtomDeleted = ((int[])value[2])[1];
            int nAtomsDeleted = ((int[])value[2])[2];
            int i9 = this.meshCount;
            while (--i9 >= 0) {
                Mesh m = this.meshes[i9];
                if (m == null) continue;
                if (m.connectedAtoms != null) {
                    int iAtom = m.connectedAtoms[0];
                    if (iAtom >= firstAtomDeleted + nAtomsDeleted) {
                        m.connectedAtoms[0] = iAtom - nAtomsDeleted;
                    } else if (iAtom >= firstAtomDeleted) {
                        m.connectedAtoms = null;
                    }
                }
                m.connectedAtoms = null;
                if (m.modelIndex == modelIndex) {
                    --this.meshCount;
                    if (m == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])AU.deleteElements(this.meshes, i9, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (m.modelIndex <= modelIndex) continue;
                --m.modelIndex;
                if (m.atomIndex < firstAtomDeleted) continue;
                m.atomIndex -= nAtomsDeleted;
            }
            return;
        }
        this.setPropertySuper(propertyName, value, bs);
    }

    private Object getFileReader(String fileName) {
        Object value = this.vwr.fm.getBufferedReaderOrErrorMessageFromName(fileName, null, true, true);
        if (value instanceof String) {
            Logger.error("Isosurface: could not open file " + fileName + " -- " + value);
            return null;
        }
        if (!(value instanceof BufferedReader)) {
            try {
                value = Rdr.getBufferedReader((BufferedInputStream)value, "ISO-8859-1");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    private void setIsoMeshColor(IsosurfaceMesh m, String color) {
        m.jvxlData.baseColor = color;
        m.isColorSolid = true;
        m.pcs = null;
        m.colorsExplicit = false;
        m.colorEncoder = null;
        m.vertexColorMap = null;
    }

    private void setColorPhase(IsosurfaceMesh m, short colix0, short colix1) {
        m.colorPhased = true;
        m.colix = m.jvxlData.minColorIndex = colix0;
        m.jvxlData.maxColorIndex = colix1;
        m.jvxlData.isBicolorMap = true;
        m.jvxlData.colorDensity = false;
        m.isColorSolid = false;
        m.remapColors(this.vwr, null, this.translucentLevel);
    }

    private void ensureMeshSource() {
        boolean haveColors;
        boolean bl = haveColors = this.thisMesh.vertexSource != null;
        if (haveColors) {
            int i = this.thisMesh.vc;
            while (--i >= 0) {
                if (this.thisMesh.vertexSource[i] >= 0) continue;
                haveColors = false;
                break;
            }
        }
        if (!haveColors) {
            int[] source = this.thisMesh.vertexSource;
            short[] vertexColixes = this.thisMesh.vcs;
            short colix = this.thisMesh.isColorSolid ? this.thisMesh.colix : (short)0;
            this.setProperty("init", null, null);
            this.setProperty("map", Boolean.FALSE, null);
            this.setProperty("property", new float[this.ms.ac], null);
            if (colix != 0) {
                this.thisMesh.colorCommand = "color isosurface " + C.getHexCode(colix);
                this.setProperty("color", C.getArgb(colix), null);
            }
            if (source != null) {
                int i = this.thisMesh.vc;
                while (--i >= 0) {
                    if (source[i] >= 0) continue;
                    source[i] = this.thisMesh.vertexSource[i];
                }
                this.thisMesh.vertexSource = source;
                this.thisMesh.vcs = vertexColixes;
            }
        }
    }

    protected void slabPolygons(Object[] slabInfo) {
        this.thisMesh.calculatedVolume = null;
        this.thisMesh.calculatedArea = null;
        this.thisMesh.getMeshSlicer().slabPolygons(slabInfo, false);
        this.thisMesh.reinitializeLightingAndColor(this.vwr);
    }

    private void setPropertySuper(String propertyName, Object value, BS bs) {
        if (propertyName == "thisID" && this.currentMesh != null && this.currentMesh.thisID != null && this.currentMesh.thisID.equals(value)) {
            this.checkExplicit((String)value);
            return;
        }
        this.currentMesh = this.thisMesh;
        this.setPropMC(propertyName, value, bs);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public boolean getPropertyData(String property, Object[] data) {
        int index;
        if (property == "keys") {
            Lst keys = data[1] instanceof Lst ? (Lst)data[1] : new Lst();
            data[1] = keys;
            keys.addLast("info");
            keys.addLast("data");
            keys.addLast("atoms");
        }
        if (property == "colorEncoder") {
            IsosurfaceMesh m = (IsosurfaceMesh)this.getMesh((String)data[0]);
            return m != null && (data[1] = m.colorEncoder) != null;
        }
        if (property == "intersectPlane") {
            IsosurfaceMesh m = (IsosurfaceMesh)this.getMesh((String)data[0]);
            if (m == null || data.length < 4) {
                return false;
            }
            data[3] = m.modelIndex;
            m.getMeshSlicer().getIntersection(0.0f, (P4)data[1], null, (Lst)data[2], null, null, null, false, false, 134217750, false);
            return true;
        }
        if (property == "getBoundingBox") {
            String id = (String)data[0];
            IsosurfaceMesh m = (IsosurfaceMesh)this.getMesh(id);
            if (m == null || m.vs == null) {
                return false;
            }
            data[2] = m.jvxlData.boundingBox;
            if (m.mat4 != null) {
                P3[] d = new P3[]{P3.newP(m.jvxlData.boundingBox[0]), P3.newP(m.jvxlData.boundingBox[1])};
                V3 v = new V3();
                m.mat4.getTranslation(v);
                d[0].add(v);
                d[1].add(v);
                data[2] = d;
            }
            return true;
        }
        if (property == "unitCell") {
            IsosurfaceMesh m = (IsosurfaceMesh)this.getMesh((String)data[0]);
            return m != null && (data[1] = m.getUnitCell()) != null;
        }
        if (property == "getCenter" && (index = ((Integer)data[1]).intValue()) == Integer.MIN_VALUE) {
            String id = (String)data[0];
            IsosurfaceMesh m = (IsosurfaceMesh)this.getMesh(id);
            if (m == null || m.vs == null) {
                return false;
            }
            P3 p = P3.newP(m.jvxlData.boundingBox[0]);
            p.add(m.jvxlData.boundingBox[1]);
            p.scale(0.5f);
            if (m.mat4 != null) {
                V3 v = new V3();
                m.mat4.getTranslation(v);
                p.add(v);
            }
            data[2] = p;
            return true;
        }
        return this.getPropDataMC(property, data);
    }

    @Override
    public Object getProperty(String property, int index) {
        return this.getPropI(property, index);
    }

    protected Object getPropI(String property, int index) {
        IsosurfaceMesh m = this.thisMesh;
        if (index >= 0 && (index >= this.meshCount || (m = this.isomeshes[index]) == null)) {
            return null;
        }
        Object ret = this.getPropMC(property, index);
        if (ret != null) {
            return ret;
        }
        if (property == "message") {
            String s = "";
            if (!this.jvxlData.isValid) {
                return "invalid! (no atoms selected?)";
            }
            if (!Float.isNaN(this.jvxlData.integration)) {
                s = s + "integration " + this.jvxlData.integration;
            }
            if (this.shapeID == 24 || this.shapeID == 27 || this.shapeID == 28) {
                s = this.jvxlData.cutoffRange == null ? s + " with cutoff=" + this.jvxlData.cutoff : s + " with cutoffRange=" + Escape.eAF(this.jvxlData.cutoffRange);
            }
            if (this.shapeID == 27 || this.shapeID == 28) {
                return s;
            }
            if (this.jvxlData.dataMin != Float.MAX_VALUE) {
                s = s + " min=" + this.jvxlData.dataMin + " max=" + this.jvxlData.dataMax;
            }
            s = s + "; " + JC.shapeClassBases[this.shapeID].toLowerCase() + " count: " + this.getPropMC("count", index);
            return s + this.getPropI("dataRangeStr", index) + this.jvxlData.msg;
        }
        if (property == "dataRange") {
            return this.getDataRange(m);
        }
        if (property == "dataRangeStr") {
            float[] dataRange = this.getDataRange(m);
            return dataRange != null && dataRange[0] != Float.MAX_VALUE && dataRange[0] != dataRange[1] ? "\nisosurface full data range " + dataRange[0] + " to " + dataRange[1] + " with color scheme spanning " + dataRange[2] + " to " + dataRange[3] : "";
        }
        if (property == "moNumber") {
            return this.moNumber;
        }
        if (property == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (property == "nSets") {
            int n;
            int n2 = n = m == null ? Integer.MIN_VALUE : m.nSets;
            if (n == 0) {
                this.calculateVolumeOrArea(m, true);
                n = m.nSets;
            }
            return n == Integer.MIN_VALUE ? 0 : Math.abs(m.nSets);
        }
        if (property == "area") {
            return m == null ? Float.valueOf(Float.NaN) : this.calculateVolumeOrArea(m, true);
        }
        if (property == "volume") {
            return m == null ? Float.valueOf(Float.NaN) : this.calculateVolumeOrArea(m, false);
        }
        if (m == null) {
            return null;
        }
        if (property == "output") {
            return m.jvxlData.sbOut == null && m.jvxlData.jvxlFileTitle == null ? null : m.jvxlData.jvxlFileTitle + "\n" + (m.jvxlData.sbOut == null ? "" : m.jvxlData.sbOut.toString());
        }
        if (property == "cutoff") {
            return Float.valueOf(this.jvxlData.cutoff);
        }
        if (property == "cutoffRange") {
            return this.jvxlData.cutoffRange;
        }
        if (property == "minMaxInfo") {
            return new float[]{this.jvxlData.dataMin, this.jvxlData.dataMax};
        }
        if (property == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (property == "contours") {
            return m.getContours();
        }
        if (property == "pmesh" || property == "pmeshbin") {
            return m.getPmeshData(property == "pmeshbin");
        }
        if (property == "ply" || property == "plybin") {
            return m.getPLYData(property == "plybin");
        }
        if (property == "jvxlDataXml" || property == "jvxlMeshXml") {
            MeshData meshData = null;
            this.jvxlData.slabInfo = null;
            if (property == "jvxlMeshXml" || this.jvxlData.vertexDataOnly || m.bsSlabDisplay != null && m.bsSlabGhost == null) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1, m);
                meshData.polygonColorData = Isosurface.getPolygonColorData(meshData.pc, meshData.pcs, meshData.colorsExplicit ? meshData.pis : (int[][])null, meshData.bsSlabDisplay);
            } else if (m.bsSlabGhost != null) {
                this.jvxlData.slabInfo = m.slabOptions.toString();
            }
            SB sb = new SB();
            this.getMeshCommand(sb, m.index);
            m.setJvxlColorMap(true);
            return JvxlCoder.jvxlGetFile(this.jvxlData, meshData, this.title, "", true, 1, sb.toString(), null);
        }
        if (property == "jvxlFileInfo") {
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        if (property == "command") {
            SB sb = new SB();
            Lst<Mesh> list = this.getMeshList(index < 0 ? this.previousMeshID : m.thisID, false);
            int i = list.size();
            while (--i >= 0) {
                this.getMeshCommand(sb, ((Mesh)list.get((int)i)).index);
            }
            return sb.toString();
        }
        if (property == "atoms") {
            return m.surfaceAtoms;
        }
        if (property == "colorEncoder") {
            return m.colorEncoder;
        }
        if (property == "values" || property == "value") {
            return m.probeValues;
        }
        return null;
    }

    private float[] getDataRange(IsosurfaceMesh mesh) {
        return mesh == null ? null : mesh.getDataRange();
    }

    private Object calculateVolumeOrArea(IsosurfaceMesh mesh, boolean isArea) {
        if (isArea) {
            if (mesh.calculatedArea != null) {
                return mesh.calculatedArea;
            }
        } else if (mesh.calculatedVolume != null) {
            return mesh.calculatedVolume;
        }
        MeshData meshData = new MeshData();
        this.fillMeshData(meshData, 1, mesh);
        meshData.nSets = mesh.nSets;
        meshData.vertexSets = mesh.vertexSets;
        if (!isArea && mesh.jvxlData.colorDensity) {
            float f = mesh.jvxlData.voxelVolume;
            mesh.calculatedVolume = Float.valueOf(f *= (float)(mesh.bsSlabDisplay == null ? mesh.vc : mesh.bsSlabDisplay.cardinality()));
            return mesh.calculatedVolume;
        }
        Object ret = MeshData.calculateVolumeOrArea(meshData, mesh.jvxlData.thisSet, isArea, false);
        if (mesh.nSets <= 0) {
            mesh.nSets = -meshData.nSets;
        }
        if (isArea) {
            mesh.calculatedArea = ret;
        } else {
            mesh.calculatedVolume = ret;
        }
        return ret;
    }

    public static String getPolygonColorData(int ccount, short[] colixes, int[][] polygons, BS bsSlabDisplay) {
        boolean isExplicit;
        boolean bl = isExplicit = polygons != null;
        if (colixes == null && polygons == null) {
            return null;
        }
        SB list1 = new SB();
        int count = 0;
        short colix = 0;
        int color = 0;
        int colorNext = 0;
        boolean done = false;
        int i = 0;
        while (true) {
            if (i >= ccount) {
                done = true;
                if (!true) break;
            }
            if (done || bsSlabDisplay == null || bsSlabDisplay.get(i)) {
                if (done || (isExplicit ? (colorNext = polygons[i][4]) != color : colixes[i] != colix)) {
                    if (count != 0) {
                        list1.append(" ").appendI(count).append(" ").appendI(isExplicit ? color : (colix == 0 ? 0 : C.getArgb(colix)));
                    }
                    if (done) break;
                    if (isExplicit) {
                        color = colorNext;
                    } else {
                        colix = colixes[i];
                    }
                    count = 1;
                } else {
                    ++count;
                }
            }
            ++i;
        }
        list1.append("\n");
        return list1.toString();
    }

    @Override
    public String getShapeState() {
        this.clean();
        SB sb = new SB();
        sb.append("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            this.getMeshCommand(sb, i);
        }
        return sb.toString();
    }

    private void getMeshCommand(SB sb, int i) {
        IsosurfaceMesh imesh = (IsosurfaceMesh)this.meshes[i];
        if (imesh == null || imesh.scriptCommand == null) {
            return;
        }
        String cmd = imesh.scriptCommand;
        int modelCount = this.ms.mc;
        if (modelCount > 1) {
            Isosurface.appendCmd(sb, "frame " + this.vwr.getModelNumberDotted(imesh.modelIndex));
        }
        cmd = PT.rep(cmd, ";; isosurface map", " map");
        if ((cmd = PT.rep(cmd, "; isosurface map", " map")).endsWith(" map")) {
            cmd = cmd.substring(0, cmd.length() - 4);
        }
        cmd = cmd.replace('\t', ' ');
        int pt = (cmd = PT.rep(cmd, ";#", "; #")).indexOf("; #");
        if (pt >= 0) {
            cmd = cmd.substring(0, pt);
        }
        if (imesh.connectedAtoms != null) {
            cmd = cmd + " connect " + Escape.eAI(imesh.connectedAtoms);
        }
        cmd = PT.trim(cmd, ";");
        if (imesh.linkedMesh != null) {
            cmd = cmd + " LINK";
        }
        if (this.myType == "lcaoCartoon" && imesh.atomIndex >= 0) {
            cmd = cmd + " ATOMINDEX " + imesh.atomIndex;
        }
        Isosurface.appendCmd(sb, cmd);
        String id = this.myType + " ID " + PT.esc(imesh.thisID);
        if (imesh.jvxlData.thisSet != null && !imesh.jvxlData.thisSet.isEmpty()) {
            Isosurface.appendCmd(sb, id + (imesh.jvxlData.thisSet.cardinality() == 1 ? " set " + (imesh.jvxlData.thisSet.nextSetBit(0) + 1) : " subset " + imesh.jvxlData.thisSet));
        }
        if (imesh.mat4 != null && !imesh.isModelConnected) {
            Isosurface.appendCmd(sb, id + " move " + Escape.matrixToScript(imesh.mat4));
        }
        if (imesh.scale3d != 0.0f) {
            Isosurface.appendCmd(sb, id + " scale3d " + imesh.scale3d);
        }
        if (imesh.jvxlData.slabValue != Integer.MIN_VALUE) {
            Isosurface.appendCmd(sb, id + " slab " + imesh.jvxlData.slabValue);
        }
        if (imesh.slabOptions != null) {
            Isosurface.appendCmd(sb, imesh.slabOptions.toString());
        }
        if (cmd.charAt(0) != '#') {
            boolean colorArrayed;
            if (this.allowMesh) {
                Isosurface.appendCmd(sb, imesh.getState(this.myType));
            }
            if (!imesh.isColorSolid && imesh.colorType == 0 && C.isColixTranslucent(imesh.colix)) {
                Isosurface.appendCmd(sb, "color " + this.myType + " " + Isosurface.getTranslucentLabel(imesh.colix));
            }
            if (imesh.colorCommand != null && imesh.colorType == 0 && !imesh.colorCommand.equals("#inherit;")) {
                Isosurface.appendCmd(sb, imesh.colorCommand);
            }
            boolean bl = colorArrayed = imesh.isColorSolid && imesh.pcs != null;
            if (imesh.isColorSolid && imesh.colorType == 0 && !imesh.colorsExplicit && !colorArrayed) {
                Isosurface.appendCmd(sb, Isosurface.getColorCommandUnk(this.myType, imesh.colix, this.translucentAllowed));
            } else if (imesh.jvxlData.isBicolorMap && imesh.colorPhased) {
                Isosurface.appendCmd(sb, "color isosurface phase " + Isosurface.encodeColor(imesh.jvxlData.minColorIndex) + " " + Isosurface.encodeColor(imesh.jvxlData.maxColorIndex));
            }
            if (imesh.vertexColorMap != null) {
                for (Map.Entry entry : imesh.vertexColorMap.entrySet()) {
                    BS bs = (BS)entry.getValue();
                    if (bs.isEmpty()) continue;
                    Isosurface.appendCmd(sb, "color " + this.myType + " " + Escape.eBS(bs) + " " + (String)entry.getKey());
                }
            }
        }
    }

    private boolean getScriptBitSets(String script, BS[] bsCmd) {
        BS bs;
        int j;
        int i;
        this.script = script;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (script != null && (i = script.indexOf("MODEL({")) >= 0 && (j = script.indexOf("})", i)) > 0) {
            bs = BS.unescape(script.substring(i + 3, j + 1));
            this.modelIndex = bs == null ? -1 : bs.nextSetBit(0);
            boolean bl = this.iHaveModelIndex = this.modelIndex >= 0;
        }
        if (script == null) {
            return false;
        }
        this.getCapSlabInfo(script);
        i = script.indexOf("# ({");
        if (i < 0) {
            return false;
        }
        j = script.indexOf("})", i);
        if (j < 0) {
            return false;
        }
        bs = BS.unescape(script.substring(i + 2, j + 2));
        if (bsCmd == null) {
            this.sg.setProp("select", bs, null);
        } else {
            bsCmd[0] = bs;
        }
        i = script.indexOf("({", j);
        if (i < 0) {
            return true;
        }
        j = script.indexOf("})", i);
        if (j < 0) {
            return false;
        }
        bs = BS.unescape(script.substring(i + 1, j + 1));
        if (bsCmd == null) {
            this.sg.setProp("ignore", bs, null);
        } else {
            bsCmd[1] = bs;
        }
        i = script.indexOf("/({", j);
        if (i == j + 2) {
            j = script.indexOf("})", i);
            if (j < 0) {
                return false;
            }
            bs = BS.unescape(script.substring(i + 3, j + 1));
            if (bsCmd == null) {
                this.ms.setTrajectoryBs(bs);
            } else {
                bsCmd[2] = bs;
            }
        }
        return true;
    }

    protected void getCapSlabInfo(String script) {
        int i = script.indexOf("# SLAB=");
        if (i >= 0) {
            this.sg.setProp("slab", this.getCapSlabObject(PT.getQuotedStringAt(script, i), false), null);
        }
        if ((i = script.indexOf("# CAP=")) >= 0) {
            this.sg.setProp("slab", this.getCapSlabObject(PT.getQuotedStringAt(script, i), true), null);
        }
    }

    private Object[] getCapSlabObject(String s, boolean isCap) {
        try {
            if (s.indexOf("array") == 0) {
                String[] pts = PT.split(s.substring(6, s.length() - 1), ",");
                return TempArray.getSlabObjectType(1812599299, new P3[]{(P3)Escape.uP(pts[0]), (P3)Escape.uP(pts[1]), (P3)Escape.uP(pts[2]), (P3)Escape.uP(pts[3])}, isCap, null);
            }
            Object plane = Escape.uP(s);
            if (plane instanceof P4) {
                return TempArray.getSlabObjectType(134217750, plane, isCap, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void initializeIsosurface() {
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.vwr.am.cmi;
        }
        this.atomIndex = -1;
        this.bsDisplay = null;
        this.center = P3.new3(Float.NaN, 0.0f, 0.0f);
        this.colix = (short)5;
        this.connections = null;
        this.cutoffRange = null;
        this.meshColix = 0;
        this.defaultColix = 0;
        this.colorType = 0;
        this.displayWithinPoints = null;
        this.explicitContours = false;
        this.isFixed = this.modelIndex < 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.linkedMesh = null;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.scale3d = 0.0f;
        this.title = null;
        this.translucentLevel = 0.0f;
        this.withinPoints = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void setMeshI() {
        this.thisMesh.visible = true;
        this.thisMesh.atomIndex = this.atomIndex;
        this.thisMesh.modelIndex = this.thisMesh.atomIndex >= 0 ? (int)this.ms.at[this.atomIndex].mi : (this.isFixed ? -1 : (this.modelIndex >= 0 ? this.modelIndex : this.vwr.am.cmi));
        this.thisMesh.scriptCommand = this.script;
        this.thisMesh.ptCenter.setT(this.center);
        this.thisMesh.scale3d = this.thisMesh.jvxlData.jvxlPlane == null ? 0.0f : this.scale3d;
    }

    protected void discardTempData(boolean discardAll) {
        if (!discardAll) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.jvxlData.wasCubic) {
            return this.colix;
        }
        int argb = this.sg.params.cutoff >= 0.0f ? -11525984 : -6283184;
        return C.getColix(argb);
    }

    private void drawLcaoCartoon(V3 z, V3 x, V3 rotAxis, int nElectrons, boolean reverseColor) {
        IsosurfaceMesh meshA;
        String id;
        boolean isReverse;
        boolean addAnti;
        String lcaoCartoon = this.sg.setLcao();
        boolean bl = addAnti = lcaoCartoon.indexOf("anti-sp") >= 0;
        if (addAnti) {
            lcaoCartoon = lcaoCartoon.substring(5);
        }
        float rotRadians = rotAxis.x + rotAxis.y + rotAxis.z;
        this.defaultColix = C.getColix(this.sg.params.colorPos);
        short colixNeg = C.getColix(this.sg.params.colorNeg);
        if (reverseColor) {
            short c = colixNeg;
            colixNeg = this.defaultColix;
            this.defaultColix = c;
        }
        V3 y = new V3();
        boolean bl2 = isReverse = lcaoCartoon.length() > 0 && lcaoCartoon.charAt(0) == '-';
        if (isReverse) {
            lcaoCartoon = lcaoCartoon.substring(1);
        }
        float sense = isReverse ? -1 : 1;
        y.cross(z, x);
        if (rotRadians != 0.0f) {
            A4 a = new A4();
            if (rotAxis.x != 0.0f) {
                a.setVA(x, rotRadians);
            } else if (rotAxis.y != 0.0f) {
                a.setVA(y, rotRadians);
            } else {
                a.setVA(z, rotRadians);
            }
            M3 m = new M3().setAA(a);
            m.rotate(x);
            m.rotate(y);
            m.rotate(z);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        String string = this.thisMesh == null ? (nElectrons > 0 ? "lp" : "lcao") + ++this.nLCAO + "_" + lcaoCartoon : (id = this.thisMesh.thisID);
        if (this.thisMesh == null) {
            this.allocMesh(id, null);
        }
        if (lcaoCartoon.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            meshA = this.thisMesh;
            this.createLcaoLobe(x, sense, nElectrons);
            if (nElectrons > 0) {
                return;
            }
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(x, -sense, 0);
            this.thisMesh.colix = colixNeg;
            this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            return;
        }
        if (lcaoCartoon.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            meshA = this.thisMesh;
            this.createLcaoLobe(y, sense, nElectrons);
            if (nElectrons > 0) {
                return;
            }
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(y, -sense, 0);
            this.thisMesh.colix = colixNeg;
            this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            return;
        }
        meshA = this.thisMesh;
        if (lcaoCartoon.equals("pz")) {
            meshA.thisID = meshA.thisID + "a";
            this.createLcaoLobe(z, sense, nElectrons);
            if (nElectrons > 0) {
                return;
            }
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(z, -sense, 0);
            this.thisMesh.colix = colixNeg;
            this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            return;
        }
        if (lcaoCartoon.equals("pza") || lcaoCartoon.indexOf("sp") == 0 || lcaoCartoon.indexOf("d") == 0 || lcaoCartoon.indexOf("lp") == 0) {
            this.createLcaoLobe(z, sense, nElectrons);
            if (addAnti && nElectrons == 0) {
                meshA.thisID = meshA.thisID + "a";
                this.setProperty("thisID", id + "b", null);
                this.createLcaoLobe(z, -sense / 2.0f, 0);
                this.thisMesh.colix = colixNeg;
                this.linkedMesh = this.thisMesh.linkedMesh = meshA;
            }
            return;
        }
        if (lcaoCartoon.equals("pzb")) {
            this.createLcaoLobe(z, -sense, nElectrons);
            return;
        }
        if (lcaoCartoon.equals("pxa")) {
            this.createLcaoLobe(x, sense, nElectrons);
            return;
        }
        if (lcaoCartoon.equals("pxb")) {
            this.createLcaoLobe(x, -sense, nElectrons);
            return;
        }
        if (lcaoCartoon.equals("pya")) {
            this.createLcaoLobe(y, sense, nElectrons);
            return;
        }
        if (lcaoCartoon.equals("pyb")) {
            this.createLcaoLobe(y, -sense, nElectrons);
            return;
        }
        if (lcaoCartoon.equals("spacefill") || lcaoCartoon.equals("cpk")) {
            this.createLcaoLobe(null, 2.0f * this.ms.at[this.atomIndex].getRadius(), nElectrons);
            return;
        }
        this.createLcaoLobe(null, 1.0f, nElectrons);
    }

    private void createLcaoLobe(V3 lobeAxis, float factor, int nElectrons) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        if (lobeAxis == null) {
            this.setProperty("sphere", Float.valueOf(factor / 2.0f), null);
        } else {
            this.lcaoDir.x = lobeAxis.x * factor;
            this.lcaoDir.y = lobeAxis.y * factor;
            this.lcaoDir.z = lobeAxis.z * factor;
            this.lcaoDir.w = 0.7f;
            this.setProperty(nElectrons == 2 ? "lp" : (nElectrons == 1 ? "rad" : "lobe"), this.lcaoDir, null);
        }
        this.thisMesh.colix = this.defaultColix;
        this.setScriptInfo(null);
    }

    @Override
    public void invalidateTriangles() {
        this.thisMesh.invalidatePolygons();
    }

    @Override
    public void setOutputChannel(GenericBinaryDocument binaryDoc, OC out) {
        binaryDoc.setOutputChannel(out);
    }

    @Override
    public void fillMeshData(MeshData meshData, int mode, IsosurfaceMesh mesh) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
            }
            if (!this.thisMesh.isMerged) {
                this.thisMesh.clearType(this.myType, this.sg.params.iAddGridPoints);
            }
            this.thisMesh.connectedAtoms = this.connections;
            this.thisMesh.colix = this.getDefaultColix();
            this.thisMesh.colorType = this.colorType;
            this.thisMesh.meshColix = this.meshColix;
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        if (mesh == null) {
            mesh = this.thisMesh;
        }
        if (mesh == null) {
            return;
        }
        switch (mode) {
            case 1: {
                meshData.mergeVertexCount0 = mesh.mergeVertexCount0;
                meshData.vs = mesh.vs;
                meshData.vertexSource = mesh.vertexSource;
                meshData.vvs = mesh.vvs;
                meshData.vc = mesh.vc;
                meshData.vertexIncrement = mesh.vertexIncrement;
                meshData.pc = mesh.pc;
                meshData.pis = mesh.pis;
                meshData.pcs = mesh.pcs;
                meshData.bsSlabDisplay = mesh.bsSlabDisplay;
                meshData.bsSlabGhost = mesh.bsSlabGhost;
                meshData.slabColix = mesh.slabColix;
                meshData.slabMeshType = mesh.slabMeshType;
                meshData.polygonCount0 = mesh.polygonCount0;
                meshData.vertexCount0 = mesh.vertexCount0;
                meshData.slabOptions = mesh.slabOptions;
                meshData.colorsExplicit = mesh.colorsExplicit;
                return;
            }
            case 2: {
                if (mesh.vcs == null || mesh.vc > mesh.vcs.length) {
                    mesh.vcs = new short[mesh.vc];
                }
                meshData.vcs = mesh.vcs;
                return;
            }
            case 3: {
                mesh.surfaceSet = meshData.surfaceSet;
                mesh.vertexSets = meshData.vertexSets;
                mesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                mesh.vs = meshData.vs;
                mesh.vvs = meshData.vvs;
                mesh.vc = meshData.vc;
                mesh.vertexIncrement = meshData.vertexIncrement;
                mesh.vertexSource = meshData.vertexSource;
                mesh.pc = meshData.pc;
                mesh.pis = meshData.pis;
                mesh.pcs = meshData.pcs;
                mesh.bsSlabDisplay = meshData.bsSlabDisplay;
                mesh.bsSlabGhost = meshData.bsSlabGhost;
                mesh.slabColix = meshData.slabColix;
                mesh.slabMeshType = meshData.slabMeshType;
                mesh.polygonCount0 = meshData.polygonCount0;
                mesh.vertexCount0 = meshData.vertexCount0;
                mesh.mergeVertexCount0 = meshData.mergeVertexCount0;
                mesh.slabOptions = meshData.slabOptions;
                mesh.colorsExplicit = meshData.colorsExplicit;
                return;
            }
        }
    }

    @Override
    public boolean notifySurfaceGenerationCompleted() {
        this.setMeshI();
        this.setBsVdw();
        this.thisMesh.surfaceAtoms = this.sg.params.bsSelected;
        this.thisMesh.insideOut = this.sg.params.isInsideOut();
        this.thisMesh.isModelConnected = this.sg.params.isModelConnected;
        this.thisMesh.vertexSource = this.sg.params.vertexSource;
        this.thisMesh.oabc = this.sg.getOriginVaVbVc();
        this.thisMesh.calculatedArea = null;
        this.thisMesh.calculatedVolume = null;
        this.thisMesh.probeValues = this.sg.params.probeValues;
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.params.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.params.thePlane);
            if (this.jvxlData.fixedLattice != null) {
                this.thisMesh.lattice = this.jvxlData.fixedLattice;
                this.thisMesh.fixLattice();
            }
            return this.thisMesh.setColorsFromJvxlData(this.sg.params.colorRgb);
        }
        if (!this.sg.params.allowVolumeRender) {
            this.thisMesh.jvxlData.allowVolumeRender = false;
        }
        this.thisMesh.setColorsFromJvxlData(this.sg.params.colorRgb);
        if (this.thisMesh.jvxlData.slabInfo != null) {
            this.vwr.runScriptCautiously("isosurface " + this.thisMesh.jvxlData.slabInfo);
        }
        if (this.sg.params.psi_monteCarloCount > 0) {
            this.thisMesh.diameter = -1;
        }
        return false;
    }

    @Override
    public void notifySurfaceMappingCompleted() {
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.params.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.params.thePlane);
        }
        this.setBsVdw();
        this.thisMesh.isColorSolid = false;
        this.thisMesh.colorDensity = this.jvxlData.colorDensity;
        this.thisMesh.volumeRenderPointSize = this.jvxlData.pointSize;
        this.thisMesh.colorEncoder = this.sg.params.colorEncoder;
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.explicitContours = true;
        }
        if (this.explicitContours && this.thisMesh.jvxlData.jvxlPlane != null) {
            this.thisMesh.havePlanarContours = true;
        }
        this.setPropertySuper("token", this.explicitContours ? 1073742046 : 1073741938, null);
        this.setPropertySuper("token", this.explicitContours ? 0x4000004A : 1073742039, null);
        if (!this.thisMesh.isMerged) {
            this.thisMesh.setJvxlDataRendering();
        }
        if (this.sg.params.slabInfo != null) {
            this.thisMesh.slabPolygonsList(this.sg.params.slabInfo, false);
            this.thisMesh.reinitializeLightingAndColor(this.vwr);
        }
        this.thisMesh.setColorCommand();
    }

    private void setBsVdw() {
        if (this.sg.bsVdw == null) {
            return;
        }
        if (this.thisMesh.bsVdw == null) {
            this.thisMesh.bsVdw = new BS();
        }
        this.thisMesh.bsVdw.or(this.sg.bsVdw);
    }

    @Override
    public P3[] calculateGeodesicSurface(BS bsSelected, float envelopeRadius) {
        return this.vwr.calculateSurface(bsSelected, envelopeRadius);
    }

    @Override
    public int getSurfacePointIndexAndFraction(float cutoff, boolean isCutoffAbsolute, int x, int y, int z, P3i offset, int vA, int vB, float valueA, float valueB, T3 pointA, V3 edgeVector, boolean isContourType, float[] fReturn) {
        return 0;
    }

    @Override
    public int addVertexCopy(T3 vertexXYZ, float value, int assocVertex, boolean asCopy) {
        if (this.cutoffRange != null && (value < this.cutoffRange[0] || value > this.cutoffRange[1])) {
            return -1;
        }
        return this.withinPoints != null && !Mesh.checkWithin(vertexXYZ, this.withinPoints, this.withinDistance2, this.isWithinNot) ? -1 : this.thisMesh.addVertexCopy(vertexXYZ, value, assocVertex, this.associateNormals, asCopy);
    }

    @Override
    public int addTriangleCheck(int iA, int iB, int iC, int check, int iContour, boolean isAbsolute, int color) {
        return iA < 0 || iB < 0 || iC < 0 || isAbsolute && !MeshData.checkCutoff(iA, iB, iC, this.thisMesh.vvs) ? -1 : this.thisMesh.addTriangleCheck(iA, iB, iC, check, iContour, color);
    }

    protected void setScriptInfo(String strCommand) {
        int pt;
        String script = strCommand == null ? this.sg.params.script : strCommand;
        int n = pt = script == null ? -1 : script.indexOf("; isosurface map");
        if (pt == 0) {
            if (this.thisMesh.scriptCommand == null) {
                return;
            }
            pt = this.thisMesh.scriptCommand.indexOf("; isosurface map");
            if (pt >= 0) {
                this.thisMesh.scriptCommand = this.thisMesh.scriptCommand.substring(0, pt);
            }
            this.thisMesh.scriptCommand = this.thisMesh.scriptCommand + script;
            return;
        }
        this.thisMesh.title = this.sg.params.title;
        this.thisMesh.dataType = this.sg.params.dataType;
        this.thisMesh.scale3d = this.sg.params.scale3d;
        if (script != null) {
            if (this.oldFileName != null) {
                script = script.replace(this.oldFileName, this.newFileName);
            }
            if (script.charAt(0) == ' ') {
                script = this.myType + " ID " + PT.esc(this.thisMesh.thisID) + script;
                pt = script.indexOf("; isosurface map");
            }
        }
        this.thisMesh.scriptCommand = pt > 0 && this.scriptAppendix.length() > 0 ? script.substring(0, pt) + this.scriptAppendix + script.substring(pt) : script + this.scriptAppendix;
        if (!this.explicitID && script != null && (pt = script.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = PT.getQuotedStringAt(script, pt);
        }
    }

    @Override
    public void addRequiredFile(String fileName) {
        fileName = " # /*file*/\"" + fileName + "\"";
        if (this.scriptAppendix.indexOf(fileName) < 0) {
            this.scriptAppendix = this.scriptAppendix + fileName;
        }
    }

    @Override
    public void setRequiredFile(String oldName, String fileName) {
        this.oldFileName = oldName;
        this.newFileName = fileName;
    }

    private void setJvxlInfo() {
        if (this.sg.jvxlData != this.jvxlData || this.sg.jvxlData != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.jvxlData;
        }
    }

    @Override
    public Object getShapeDetail() {
        Lst<Hashtable<String, Object>> V = new Lst<Hashtable<String, Object>>();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            IsosurfaceMesh mesh = this.isomeshes[i];
            if (mesh == null || mesh.vs == null || mesh.vc == 0 && mesh.pc == 0) continue;
            this.addMeshInfo(mesh, info);
            V.addLast(info);
        }
        return V;
    }

    protected void addMeshInfo(IsosurfaceMesh mesh, Map<String, Object> info) {
        info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
        info.put("visible", mesh.visible);
        info.put("vertexCount", mesh.vc);
        if (mesh.calculatedVolume != null) {
            info.put("volume", mesh.calculatedVolume);
        }
        if (mesh.calculatedArea != null) {
            info.put("area", mesh.calculatedArea);
        }
        if (!Float.isNaN(mesh.ptCenter.x)) {
            info.put("center", mesh.ptCenter);
        }
        if (mesh.mat4 != null) {
            info.put("mat4", mesh.mat4);
        }
        if (mesh.scale3d != 0.0f) {
            info.put("scale3d", Float.valueOf(mesh.scale3d));
        }
        info.put("xyzMin", mesh.jvxlData.boundingBox[0]);
        info.put("xyzMax", mesh.jvxlData.boundingBox[1]);
        String s = JvxlCoder.jvxlGetInfo(mesh.jvxlData);
        if (s != null) {
            info.put("jvxlInfo", s.replace('\n', ' '));
        }
        info.put("modelIndex", mesh.modelIndex);
        info.put("color", CU.colorPtFromInt(C.getArgb(mesh.colix), null));
        if (mesh.colorEncoder != null) {
            info.put("colorKey", mesh.colorEncoder.getColorKey());
        }
        if (mesh.title != null) {
            info.put("title", mesh.title);
        }
        if (mesh.jvxlData.contourValues != null || mesh.jvxlData.contourValuesUsed != null) {
            info.put("contours", mesh.getContourList(this.vwr));
        }
    }

    @Override
    public float[] getPlane(int x) {
        return null;
    }

    @Override
    public float getValue(int x, int y, int z, int ptyz) {
        return 0.0f;
    }

    @Override
    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        if (this.keyXy != null && x >= this.keyXy[0] && y >= this.keyXy[1] && x < this.keyXy[2] && y < this.keyXy[3]) {
            this.hoverKey(x, y);
            return true;
        }
        if (!this.vwr.getDrawHover()) {
            return false;
        }
        String s = this.findValue(x, y, false, bsVisible);
        if (s == null) {
            return false;
        }
        this.vwr.hoverOnPt(x, y, s, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    private void hoverKey(int x, int y) {
        try {
            String s;
            float f = 1.0f - 1.0f * (float)(y - this.keyXy[1]) / (float)(this.keyXy[3] - this.keyXy[1]);
            if (this.thisMesh.showContourLines) {
                Lst<Object>[] vContours = this.thisMesh.getContours();
                if (vContours == null) {
                    if (this.thisMesh.jvxlData.contourValues == null) {
                        return;
                    }
                    int i = (int)Math.floor(f * (float)this.thisMesh.jvxlData.contourValues.length);
                    if (i < 0 || i > this.thisMesh.jvxlData.contourValues.length) {
                        return;
                    }
                    s = "" + this.thisMesh.jvxlData.contourValues[i];
                } else {
                    int i = (int)Math.floor(f * (float)vContours.length);
                    if (i < 0 || i > vContours.length) {
                        return;
                    }
                    s = "" + ((Float)vContours[i].get(2)).floatValue();
                }
            } else {
                float g = this.thisMesh.colorEncoder.quantize(f, true);
                f = this.thisMesh.colorEncoder.quantize(f, false);
                s = "" + g + " - " + f;
            }
            this.vwr.hoverOnPt(x, y, s, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int x, int y, int action, BS bsVisible, boolean drawPicking) {
        if (!drawPicking) {
            return null;
        }
        if (!this.vwr.isBound(action, 18)) {
            return null;
        }
        int dmin2 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        int imesh = -1;
        int jmaxz = -1;
        int jminz = -1;
        int maxz = Integer.MIN_VALUE;
        int minz = Integer.MAX_VALUE;
        boolean pickFront = true;
        for (int i = 0; i < this.meshCount; ++i) {
            T3[] centers;
            IsosurfaceMesh m = this.isomeshes[i];
            if (!this.isPickable(m, bsVisible)) continue;
            T3[] t3Array = centers = pickFront ? m.vs : m.getCenters();
            if (centers == null) continue;
            int j = centers.length;
            while (--j >= 0) {
                int d2;
                T3 v = centers[j];
                if (v == null || (d2 = this.coordinateInRange(x, y, v, dmin2, this.ptXY)) < 0) continue;
                if (this.ptXY.z < minz) {
                    if (pickFront) {
                        imesh = i;
                    }
                    minz = this.ptXY.z;
                    jminz = j;
                }
                if (this.ptXY.z <= maxz) continue;
                if (!pickFront) {
                    imesh = i;
                }
                maxz = this.ptXY.z;
                jmaxz = j;
            }
        }
        if (imesh < 0) {
            return null;
        }
        this.pickedMesh = this.isomeshes[imesh];
        this.setPropertySuper("thisID", this.pickedMesh.thisID, null);
        this.pickedVertex = pickFront ? jminz : jmaxz;
        int iFace = this.pickedVertex;
        P3 ptRet = new P3();
        ptRet.setT(pickFront ? this.pickedMesh.vs[this.pickedVertex] : ((IsosurfaceMesh)this.pickedMesh).centers[iFace]);
        this.pickedModel = (short)this.pickedMesh.modelIndex;
        Map<String, Object> map = this.getPickedPoint(ptRet, this.pickedModel);
        this.setStatusPicked(-4, ptRet, map);
        return map;
    }

    private boolean isPickable(IsosurfaceMesh m, BS bsVisible) {
        return m.visibilityFlags != 0 && (m.modelIndex < 0 || bsVisible.get(m.modelIndex)) && !C.isColixTranslucent(m.colix);
    }

    private String findValue(int x, int y, boolean isPicking, BS bsVisible) {
        int dmin2 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        int pickedVertex = -1;
        Lst<Object> pickedContour = null;
        IsosurfaceMesh m = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int k;
            m = this.isomeshes[i];
            if (!this.isPickable(m, bsVisible)) continue;
            Lst<Object>[] vs = m.jvxlData.vContours;
            int ilast = m.firstRealVertex < 0 ? 0 : m.firstRealVertex;
            int pickedJ = 0;
            if (vs != null && vs.length > 0) {
                for (int j = 0; j < vs.length; ++j) {
                    Lst<Object> vc = vs[j];
                    int n = vc.size() - 1;
                    for (int k2 = 6; k2 < n; ++k2) {
                        T3 v = (T3)vc.get(k2);
                        int d2 = this.coordinateInRange(x, y, v, dmin2, this.ptXY);
                        if (d2 < 0) continue;
                        dmin2 = d2;
                        pickedContour = vc;
                        pickedJ = j;
                        this.pickedMesh = m;
                        this.pickedPt = v;
                    }
                }
                if (pickedContour == null) continue;
                return pickedContour.get(2).toString() + (Logger.debugging ? " " + pickedJ : "");
            }
            if (m.jvxlData.jvxlPlane != null && m.vvs != null) {
                P3[] vertices = m.mat4 == null && m.scale3d == 0.0f ? m.vs : m.getOffsetVertices(m.jvxlData.jvxlPlane);
                int k3 = m.vc;
                while (--k3 >= ilast) {
                    P3 v = vertices[k3];
                    int d2 = this.coordinateInRange(x, y, v, dmin2, this.ptXY);
                    if (d2 < 0) continue;
                    dmin2 = d2;
                    pickedVertex = k3;
                    this.pickedMesh = m;
                    this.pickedPt = v;
                }
                if (pickedVertex == -1) continue;
                break;
            }
            if (m.vvs == null) continue;
            if (m.bsSlabDisplay != null) {
                k = m.bsSlabDisplay.nextSetBit(0);
                while (k >= 0) {
                    int[] p = m.pis[k];
                    if (p != null) {
                        for (int l = 0; l < 3; ++l) {
                            T3 v = m.vs[p[l]];
                            int d2 = this.coordinateInRange(x, y, v, dmin2, this.ptXY);
                            if (d2 < 0) continue;
                            dmin2 = d2;
                            pickedVertex = p[l];
                            this.pickedMesh = m;
                            this.pickedPt = v;
                        }
                    }
                    k = m.bsSlabDisplay.nextSetBit(k + 1);
                }
            } else {
                k = m.vc;
                while (--k >= ilast) {
                    T3 v = m.vs[k];
                    int d2 = this.coordinateInRange(x, y, v, dmin2, this.ptXY);
                    if (d2 < 0) continue;
                    dmin2 = d2;
                    pickedVertex = k;
                    this.pickedMesh = m;
                    this.pickedPt = v;
                }
            }
            if (pickedVertex != -1) break;
        }
        return pickedVertex == -1 ? null : (Logger.debugging ? "$" + m.thisID + "[" + (pickedVertex + 1) + "] " + m.vs[pickedVertex] + ": " : m.thisID + ": ") + m.vvs[pickedVertex];
    }

    public String getCmd(int index) {
        SB sb = new SB().append("\n");
        this.getMeshCommand(sb, index);
        return sb.toString();
    }

    @Override
    protected Object getValues(Mesh mesh) {
        return mesh == null ? null : ((IsosurfaceMesh)mesh).getValidValues(null);
    }

    @Override
    protected Object getVertices(Mesh mesh) {
        return mesh == null ? null : ((IsosurfaceMesh)mesh).getValidVertices(null);
    }
}

