/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jsonkiosk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javajs.util.JSJSONParser;
import javax.swing.SwingUtilities;
import naga.ConnectionAcceptor;
import naga.NIOServerSocket;
import naga.NIOService;
import naga.NIOSocket;
import naga.ServerSocketObserverAdapter;
import naga.SocketObserver;
import naga.SocketObserverAdapter;
import naga.packetreader.AsciiLinePacketReader;
import naga.packetwriter.RawPacketWriter;
import org.jmol.util.JSONWriter;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;

public class JsonNioService
extends NIOService
implements JsonNioServer {
    public static final int VERSION = 1;
    protected String myName;
    protected boolean halt;
    protected int port;
    private Thread clientThread;
    private Thread serverThread;
    private NIOSocket inSocket;
    protected NIOSocket outSocket;
    private NIOServerSocket serverSocket;
    Viewer vwr;
    protected JsonNioClient client;
    protected int version = 2;
    private final String ROLES = "out.......in........quit......";

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void startService(int port, JsonNioClient client, Viewer jmolViewer, String name, int version) throws IOException {
        this.version = version;
        this.port = Math.abs(port);
        this.client = client;
        this.vwr = jmolViewer;
        String string = this.myName = name == null ? "" : name;
        if (port < 0) {
            this.startServerService();
            return;
        }
        Logger.info("JsonNioService" + this.myName + " using port " + port);
        if (port != 0) {
            this.inSocket = this.openSocket("127.0.0.1", port);
            this.inSocket.setPacketReader(new AsciiLinePacketReader());
            this.inSocket.setPacketWriter(RawPacketWriter.INSTANCE);
            this.inSocket.listen(new SocketObserver(){

                @Override
                public void connectionOpened(NIOSocket nioSocket) {
                    JsonNioService.this.initialize("out", nioSocket);
                }

                @Override
                public void packetReceived(NIOSocket socket, byte[] packet) {
                    JsonNioService.this.processMessage(packet, socket);
                }

                @Override
                public void connectionBroken(NIOSocket nioSocket, Exception exception) {
                    JsonNioService.this.halt = true;
                    Logger.info(Thread.currentThread().getName() + " inSocket connectionBroken");
                }

                @Override
                public void packetSent(NIOSocket arg0, Object arg1) {
                }
            });
            this.outSocket = this.inSocket;
        }
        if (port != 0) {
            this.clientThread = new Thread((Runnable)new JsonNioClientThread(), "JsonNiosThread" + this.myName);
            this.clientThread.start();
        }
    }

    @Override
    public boolean hasOuputSocket() {
        return this.outSocket != null;
    }

    @Override
    public void sendToJmol(int port, String msg) {
        try {
            if (port == 2) {
                return;
            }
            if (port != this.port) {
                if (this.inSocket != null && this.inSocket != this.outSocket) {
                    this.inSocket.close();
                }
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                if (this.clientThread != null) {
                    this.clientThread.interrupt();
                    this.clientThread = null;
                }
                this.startService(port, this.client, this.vwr, this.myName + ".", 1);
            }
            this.sendMessage(null, msg, this.outSocket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processMessage(byte[] packet, NIOSocket socket) {
        try {
            Logger.info("JNIOS received " + packet.length + " bytes from socket " + socket.getPort());
            if (packet.length < 100) {
                Map<String, Object> json = JsonNioService.toMap(packet);
                if ("JmolApp".equals(json.get("magic"))) {
                    switch ("out.......in........quit......".indexOf(JsonNioService.getString(json, "role"))) {
                        case 0: {
                            this.outSocket = socket;
                            if (this.inSocket == null) {
                                this.inSocket = this.outSocket;
                            }
                            this.reply(2, "OK");
                            break;
                        }
                        case 10: {
                            this.inSocket = socket;
                            if (this.outSocket == null) {
                                this.outSocket = this.inSocket;
                            }
                            this.reply(2, "OK");
                        }
                    }
                } else {
                    switch ("out.......in........quit......".indexOf(JsonNioService.getString(json, "type"))) {
                        case 20: {
                            this.halt = true;
                            this.reply(2, "JsonNioService" + this.myName + " closing");
                            Logger.info("JsonNiosService quitting");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    System.exit(0);
                                }
                            });
                        }
                    }
                }
            }
            this.client.processNioMessage(packet);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void sendMessage(Map<String, Object> map, String msg, NIOSocket socket) {
        if (socket == null && (socket = this.outSocket) == null || map == null && msg == null) {
            return;
        }
        try {
            byte[] out;
            if (map != null) {
                out = JsonNioService.toJSONBytes(map);
            } else if (msg.indexOf("{") == 0) {
                if (!msg.endsWith("\n")) {
                    msg = msg + "\n";
                }
                out = this.clean(msg.getBytes("UTF-8"));
            } else {
                map = new LinkedHashMap<String, Object>();
                map.put("type", "command");
                map.put("command", msg);
                out = JsonNioService.toJSONBytes(map);
            }
            this.sendBytes(out, socket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reply(int port, final Object data) {
        if (port != 2 || this.outSocket == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", "reply");
                map.put("reply", data);
                JsonNioService.this.sendMessage(map, null, JsonNioService.this.outSocket);
            }
        });
    }

    private void sendBytes(byte[] bytes, NIOSocket socket) {
        if (socket == null && (socket = this.outSocket) == null || bytes == null) {
            return;
        }
        Logger.info("JsonNioService sending " + bytes.length + " bytes to port " + socket.getPort());
        if (Logger.debugging) {
            Logger.debug(new String(bytes));
        }
        try {
            socket.write(bytes);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private byte[] clean(byte[] out) {
        int n;
        int pt = -1;
        int i = n = out.length;
        while (--i >= 0) {
            if (out[i] != 10) continue;
            if (pt < 0) {
                pt = i;
            }
            out[i] = 32;
        }
        if (out[n - 1] > 32) {
            if (pt >= 0) {
                i = pt;
                while (++i < n) {
                    out[i - 1] = out[i];
                }
            } else {
                byte[] buf = new byte[n + 1];
                System.arraycopy(out, 0, buf, 0, n);
                out = buf;
            }
        }
        out[n - 1] = 10;
        return out;
    }

    @Override
    public void close() {
        Logger.info("JsonNioService" + this.myName + " close");
        try {
            this.halt = true;
            super.close();
            if (this.clientThread != null) {
                this.clientThread.interrupt();
                this.clientThread = null;
            }
            if (this.serverThread != null) {
                this.serverThread.interrupt();
                this.serverThread = null;
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.client != null) {
            this.client.nioClosed(this);
        }
    }

    protected void initialize(String role, NIOSocket nioSocket) {
        Logger.info("JsonNioService" + this.myName + " initialize " + role);
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("magic", "JmolApp");
        json.put("role", role);
        json.put("from", this.hashCode() + this.myName);
        this.sendMessage(json, null, nioSocket);
    }

    private void startServerService() {
        try {
            this.serverSocket = this.openServerSocket(this.port);
            this.serverSocket.listen(new ServerSocketObserverAdapter(){

                @Override
                public void newConnection(NIOSocket nioSocket) {
                    Logger.info(Thread.currentThread().getName() + " Received connection: " + nioSocket);
                    nioSocket.setPacketReader(new AsciiLinePacketReader());
                    nioSocket.setPacketWriter(RawPacketWriter.INSTANCE);
                    nioSocket.listen(new SocketObserverAdapter(){

                        @Override
                        public void packetReceived(NIOSocket socket, byte[] packet) {
                            JsonNioService.this.processMessage(packet, socket);
                        }

                        @Override
                        public void connectionOpened(NIOSocket arg0) {
                        }

                        @Override
                        public void connectionBroken(NIOSocket socket, Exception arg1) {
                            Logger.info("JsonNioService" + JsonNioService.this.myName + " server connection broken");
                            if (socket == JsonNioService.this.outSocket) {
                                JsonNioService.this.outSocket = null;
                            }
                        }
                    });
                }
            });
            this.serverSocket.setConnectionAcceptor(new ConnectionAcceptor(){

                @Override
                public boolean acceptConnection(InetSocketAddress arg0) {
                    boolean isOK = arg0.getAddress().isLoopbackAddress();
                    return isOK;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread = new Thread((Runnable)new JsonNioServerThread(), "JsonNioServerThread" + this.myName);
        this.serverThread.start();
    }

    public static byte[] toJSONBytes(Map<String, Object> map) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JSONWriter writer = new JSONWriter();
        writer.setWhiteSpace(false);
        writer.setStream(stream);
        writer.writeObject(map);
        writer.closeStream();
        return stream.toByteArray();
    }

    public static Map<String, Object> toMap(byte[] packet) {
        return new JSJSONParser().parseMap(new String(packet), false);
    }

    public static String getString(Map<String, Object> map, String key) {
        Object val = map.get(key);
        return val == null ? "" : val.toString();
    }

    public static long getLong(Map<String, Object> map, String key) throws Exception {
        if (!map.containsKey(key)) {
            throw new Exception("JSON key not found:" + key);
        }
        return Long.parseLong(map.get(key).toString());
    }

    public static int getInt(Map<String, Object> map, String key) throws Exception {
        if (!map.containsKey(key)) {
            throw new Exception("JSON key not found:" + key);
        }
        return Integer.parseInt(map.get(key).toString());
    }

    public static double getDouble(Map<String, Object> map, String key) throws Exception {
        if (!map.containsKey(key)) {
            throw new Exception("JSON key not found:" + key);
        }
        return Double.parseDouble(map.get(key).toString());
    }

    protected class JsonNioClientThread
    implements Runnable {
        protected JsonNioClientThread() {
        }

        @Override
        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectNonBlocking();
                    JsonNioService.this.client.serverCycle();
                    Thread.sleep(50L);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            JsonNioService.this.close();
        }
    }

    protected class JsonNioServerThread
    implements Runnable {
        protected JsonNioServerThread() {
        }

        @Override
        public void run() {
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectBlocking();
                    Logger.info(Thread.currentThread().getName() + " JsonNioServerSocket on " + JsonNioService.this.port);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JsonNioService.this.close();
        }
    }
}

