/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class FutureTask<V>
implements RunnableFuture<V> {
    private volatile int state;
    private static final int NEW = 0;
    private static final int COMPLETING = 1;
    private static final int NORMAL = 2;
    private static final int EXCEPTIONAL = 3;
    private static final int CANCELLED = 4;
    private static final int INTERRUPTING = 5;
    private static final int INTERRUPTED = 6;
    private Callable<V> callable;
    private Object outcome;
    private volatile Thread runner;
    private volatile WaitNode waiters;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;
    private static final long runnerOffset;
    private static final long waitersOffset;

    private V report(int s) throws ExecutionException {
        Object x = this.outcome;
        if (s == 2) {
            return (V)x;
        }
        if (s >= 4) {
            throw new CancellationException();
        }
        throw new ExecutionException((Throwable)x);
    }

    public FutureTask(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
        this.state = 0;
    }

    public FutureTask(Runnable runnable, V result) {
        this.callable = Executors.callable(runnable, result);
        this.state = 0;
    }

    @Override
    public boolean isCancelled() {
        return this.state >= 4;
    }

    @Override
    public boolean isDone() {
        return this.state != 0;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.state != 0) {
            return false;
        }
        if (mayInterruptIfRunning) {
            if (!UNSAFE.compareAndSwapInt(this, stateOffset, 0, 5)) {
                return false;
            }
            Thread t = this.runner;
            if (t != null) {
                t.interrupt();
            }
            UNSAFE.putOrderedInt(this, stateOffset, 6);
        } else if (!UNSAFE.compareAndSwapInt(this, stateOffset, 0, 4)) {
            return false;
        }
        this.finishCompletion();
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        int s = this.state;
        if (s <= 1) {
            s = this.awaitDone(false, 0L);
        }
        return this.report(s);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException();
        }
        int s = this.state;
        if (s <= 1 && (s = this.awaitDone(true, unit.toNanos(timeout))) <= 1) {
            throw new TimeoutException();
        }
        return this.report(s);
    }

    protected void done() {
    }

    protected void set(V v) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = v;
            UNSAFE.putOrderedInt(this, stateOffset, 2);
            this.finishCompletion();
        }
    }

    protected void setException(Throwable t) {
        if (UNSAFE.compareAndSwapInt(this, stateOffset, 0, 1)) {
            this.outcome = t;
            UNSAFE.putOrderedInt(this, stateOffset, 3);
            this.finishCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
                return;
            }
            try {
                boolean ran;
                V result;
                Callable<V> c = this.callable;
                if (c == null || this.state != 0) break block8;
                try {
                    result = c.call();
                    ran = true;
                }
                catch (Throwable ex) {
                    result = null;
                    ran = false;
                    this.setException(ex);
                }
                if (ran) {
                    this.set(result);
                }
            }
            finally {
                this.runner = null;
                int s = this.state;
                if (s >= 5) {
                    this.handlePossibleCancellationInterrupt(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runAndReset() {
        if (this.state != 0 || !UNSAFE.compareAndSwapObject(this, runnerOffset, null, Thread.currentThread())) {
            return false;
        }
        boolean ran = false;
        int s = this.state;
        try {
            Callable<V> c = this.callable;
            if (c != null && s == 0) {
                try {
                    c.call();
                    ran = true;
                }
                catch (Throwable ex) {
                    this.setException(ex);
                }
            }
        }
        finally {
            this.runner = null;
            s = this.state;
            if (s >= 5) {
                this.handlePossibleCancellationInterrupt(s);
            }
        }
        return ran && s == 0;
    }

    private void handlePossibleCancellationInterrupt(int s) {
        if (s == 5) {
            while (this.state == 5) {
                Thread.yield();
            }
        }
    }

    private void finishCompletion() {
        WaitNode q;
        block0: while ((q = this.waiters) != null) {
            if (!UNSAFE.compareAndSwapObject(this, waitersOffset, q, null)) continue;
            while (true) {
                WaitNode next;
                Thread t;
                if ((t = q.thread) != null) {
                    q.thread = null;
                    LockSupport.unpark(t);
                }
                if ((next = q.next) == null) break block0;
                q.next = null;
                q = next;
            }
        }
        this.done();
        this.callable = null;
    }

    private int awaitDone(boolean timed, long nanos) throws InterruptedException {
        long deadline = timed ? System.nanoTime() + nanos : 0L;
        WaitNode q = null;
        boolean queued = false;
        while (true) {
            if (Thread.interrupted()) {
                this.removeWaiter(q);
                throw new InterruptedException();
            }
            int s = this.state;
            if (s > 1) {
                if (q != null) {
                    q.thread = null;
                }
                return s;
            }
            if (s == 1) {
                Thread.yield();
                continue;
            }
            if (q == null) {
                q = new WaitNode();
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, waitersOffset, q.next, q);
                continue;
            }
            if (timed) {
                nanos = deadline - System.nanoTime();
                if (nanos <= 0L) {
                    this.removeWaiter(q);
                    return this.state;
                }
                LockSupport.parkNanos(this, nanos);
                continue;
            }
            LockSupport.park(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode node) {
        if (node != null) {
            node.thread = null;
            block0: while (true) {
                pred = null;
                q = this.waiters;
                while (q != null) {
                    s = q.next;
                    if (q.thread != null) {
                        pred = q;
                    } else if (pred != null) {
                        pred.next = s;
                        if (pred.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (FutureTask.UNSAFE.compareAndSwapObject(this, FutureTask.waitersOffset, q, s)) ** break;
                        continue block0;
                    }
                    q = s;
                }
                break;
            }
        }
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<FutureTask> k = FutureTask.class;
            stateOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("state"));
            runnerOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("runner"));
            waitersOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("waiters"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class WaitNode {
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode() {
        }
    }
}

