/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.PrintWriter;

class NPrintWriter
extends PrintWriter {
    private int numLines = 5;
    private int numPrinted = 0;

    public NPrintWriter(int numberOfLines) {
        super(System.out);
        this.numLines = numberOfLines;
    }

    @Override
    public void println(char[] array) {
        if (this.numPrinted >= this.numLines) {
            return;
        }
        char[] partialArray = null;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '\n') {
                ++this.numPrinted;
            }
            if (this.numPrinted != this.numLines) continue;
            System.arraycopy(array, 0, partialArray, 0, i);
        }
        if (partialArray != null) {
            super.print(partialArray);
        }
        if (this.numPrinted == this.numLines) {
            return;
        }
        super.println(array);
        ++this.numPrinted;
    }
}

