/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.net.URI;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.Extension;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.security.provider.certpath.CertPathChecker;

public abstract class PKIXRevocationChecker
extends PKIXCertPathChecker
implements CertPathChecker {
    private URI ocspResponder;
    private X509Certificate ocspResponderCert;
    private List<Extension> ocspExtensions = Collections.emptyList();
    private Map<X509Certificate, byte[]> ocspStapled = Collections.emptyMap();
    private Set<Option> options = Collections.emptySet();

    protected PKIXRevocationChecker() {
    }

    public void setOCSPResponder(URI uri) {
        this.ocspResponder = uri;
    }

    public URI getOCSPResponder() {
        return this.ocspResponder;
    }

    public void setOCSPResponderCert(X509Certificate cert) {
        this.ocspResponderCert = cert;
    }

    public X509Certificate getOCSPResponderCert() {
        return this.ocspResponderCert;
    }

    public void setOCSPExtensions(List<Extension> extensions) {
        this.ocspExtensions = extensions == null ? Collections.emptyList() : new ArrayList<Extension>(extensions);
    }

    public List<Extension> getOCSPExtensions() {
        return Collections.unmodifiableList(this.ocspExtensions);
    }

    public void setOCSPStapledResponses(Map<X509Certificate, byte[]> responses) {
        if (responses == null) {
            this.ocspStapled = Collections.emptyMap();
        } else {
            HashMap<X509Certificate, byte[]> copy = new HashMap<X509Certificate, byte[]>(responses.size());
            for (Map.Entry<X509Certificate, byte[]> e : responses.entrySet()) {
                copy.put(e.getKey(), (byte[])e.getValue().clone());
            }
            this.ocspStapled = copy;
        }
    }

    public Map<X509Certificate, byte[]> getOCSPStapledResponses() {
        HashMap<X509Certificate, byte[]> copy = new HashMap<X509Certificate, byte[]>(this.ocspStapled.size());
        for (Map.Entry<X509Certificate, byte[]> e : this.ocspStapled.entrySet()) {
            copy.put(e.getKey(), (byte[])e.getValue().clone());
        }
        return copy;
    }

    public void setOptions(Set<Option> options) {
        this.options = options == null ? Collections.emptySet() : new HashSet<Option>(options);
    }

    public Set<Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    @Override
    public Object clone() {
        PKIXRevocationChecker copy = (PKIXRevocationChecker)super.clone();
        copy.ocspExtensions = new ArrayList<Extension>(this.ocspExtensions);
        copy.ocspStapled = new HashMap<X509Certificate, byte[]>(this.ocspStapled);
        for (Map.Entry<X509Certificate, byte[]> entry : copy.ocspStapled.entrySet()) {
            byte[] encoded = entry.getValue();
            entry.setValue((byte[])encoded.clone());
        }
        copy.options = new HashSet<Option>(this.options);
        return copy;
    }

    @Override
    public void check(Certificate cert) throws CertPathValidatorException {
        this.check(cert, Collections.emptySet());
    }

    public static enum Option {
        ONLY_END_ENTITY,
        PREFER_CRLS,
        SOFT_FAIL;

    }
}

