/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.builder;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.IRScope;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.builder.IRLoop;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

class EnsureBlockInfo {
    final Label regionStart;
    final Label start;
    final Label end;
    final Label dummyRescueBlockLabel;
    Variable savedGlobalException;
    boolean needsBacktrace;
    final Label bodyRescuer;
    final IRLoop innermostLoop;
    final List<Instr> instrs;

    public EnsureBlockInfo(IRScope s2, IRLoop l, Label bodyRescuer) {
        this.regionStart = s2.getNewLabel("BEGIN");
        this.start = s2.getNewLabel("RESC_START");
        this.end = s2.getNewLabel("AFTER_RESC");
        this.dummyRescueBlockLabel = s2.getNewLabel("RESC_DUMMY");
        this.instrs = new ArrayList<Instr>();
        this.savedGlobalException = null;
        this.innermostLoop = l;
        this.bodyRescuer = bodyRescuer;
        this.needsBacktrace = true;
    }

    public void addInstr(Instr i2) {
        this.instrs.add(i2);
    }

    public void addInstrAtBeginning(Instr i2) {
        this.instrs.add(0, i2);
    }

    public void emitBody(IRBuilder b2) {
        b2.addInstr(new LabelInstr(this.start));
        for (Instr i2 : this.instrs) {
            b2.addInstr(i2);
        }
    }

    public void cloneIntoHostScope(IRBuilder builder) {
        if (this.savedGlobalException != null) {
            if (!this.needsBacktrace) {
                builder.addInstr(builder.getManager().needsBacktrace(true));
            }
            this.addInstr(new RuntimeHelperCall(builder.temp(), RuntimeHelperCall.Methods.RESET_GVAR_UNDERSCORE, new Operand[]{this.savedGlobalException}));
        }
        if (this.instrs.size() == 0) {
            return;
        }
        SimpleCloneInfo ii = new SimpleCloneInfo(builder.scope, true);
        ii.renameLabel(this.start);
        for (Instr i2 : this.instrs) {
            if (!(i2 instanceof LabelInstr)) continue;
            ii.renameLabel(((LabelInstr)i2).getLabel());
        }
        builder.addInstr(new LabelInstr(ii.getRenamedLabel(this.start)));
        builder.addInstr(new ExceptionRegionStartMarkerInstr(this.bodyRescuer));
        for (Instr instr : this.instrs) {
            CallBase call2;
            Operand block;
            Instr clonedInstr = instr.clone(ii);
            if (clonedInstr instanceof CallBase && (block = (call2 = (CallBase)clonedInstr).getClosureArg(NullBlock.INSTANCE)) instanceof WrappedIRClosure) {
                builder.scope.addClosure(((WrappedIRClosure)block).getClosure());
            }
            builder.addInstr(clonedInstr);
        }
        builder.addInstr(new ExceptionRegionEndMarkerInstr());
    }
}

