/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jruby.RubyInstanceConfig;
import org.jruby.common.RubyWarnings;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class ArgumentProcessor {
    public static final String SEPARATOR = "(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):";
    private final List<Argument> arguments;
    private int argumentIndex = 0;
    private final boolean processArgv;
    private final boolean rubyOpts;
    final RubyInstanceConfig config;
    private boolean endOfArguments = false;
    private int characterIndex = 0;
    private boolean dashUpperU = false;
    private static final Pattern VERSION_FLAG = Pattern.compile("^--[12]\\.[89012]$");
    private static final Set<String> KNOWN_PROPERTIES = new HashSet<String>(Options.PROPERTIES.size() + 16, 1.0f);
    private static final List<String> KNOWN_PROPERTY_PREFIXES;
    private static final Map<String, BiFunction<ArgumentProcessor, Boolean, Void>> FEATURES;

    public ArgumentProcessor(String[] arguments, RubyInstanceConfig config) {
        this(arguments, true, false, false, config);
    }

    public ArgumentProcessor(String[] arguments, boolean processArgv, boolean dashed, boolean rubyOpts, RubyInstanceConfig config) {
        this.config = config;
        if (arguments != null && arguments.length > 0) {
            this.arguments = new ArrayList<Argument>(arguments.length);
            for (String argument : arguments) {
                this.arguments.add(new Argument(argument, dashed));
            }
        } else {
            this.arguments = new ArrayList<Argument>(0);
        }
        this.processArgv = processArgv;
        this.rubyOpts = rubyOpts;
    }

    public void processArguments() {
        this.processArguments(true);
    }

    public void processArguments(boolean inline) {
        ArgumentProcessor.checkProperties();
        while (this.argumentIndex < this.arguments.size() && this.isInterpreterArgument(this.arguments.get((int)this.argumentIndex).originalValue)) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (inline && !this.config.isInlineScript() && this.config.getScriptFileName() == null && !this.config.isForceStdin() && this.argumentIndex < this.arguments.size()) {
            this.config.setScriptFileName(this.arguments.get((int)this.argumentIndex).originalValue);
            ++this.argumentIndex;
        }
        if (this.processArgv) {
            this.processArgv();
        }
    }

    private void processArgv() {
        ArrayList<String> arglist = new ArrayList<String>();
        while (this.argumentIndex < this.arguments.size()) {
            String arg2 = this.arguments.get((int)this.argumentIndex).originalValue;
            if (this.config.isArgvGlobalsOn() && arg2.startsWith("-")) {
                int split2 = (arg2 = arg2.substring(1)).indexOf(61);
                if (split2 > 0) {
                    String key2 = arg2.substring(0, split2);
                    String val = arg2.substring(split2 + 1);
                    String globalName = key2.replace('-', '_');
                    this.config.getOptionGlobals().put(globalName, val);
                } else {
                    this.config.getOptionGlobals().put(arg2, null);
                }
            } else {
                this.config.setArgvGlobalsOn(false);
                arglist.add(arg2);
            }
            ++this.argumentIndex;
        }
        arglist.addAll(Arrays.asList(this.config.getArgv()));
        this.config.setArgv(arglist.toArray(new String[arglist.size()]));
    }

    private boolean isInterpreterArgument(String argument) {
        return argument.length() > 0 && (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private String getArgumentError(String additionalError) {
        return "jruby: invalid argument\n" + additionalError + "\n";
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void processArgument() {
        argument = this.arguments.get(this.argumentIndex).getDashedValue();
        if (argument.length() == 1) {
            this.endOfArguments = true;
            this.config.setForceStdin(true);
            return;
        }
        this.characterIndex = 1;
        block60: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case '0': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    temp = this.grabOptionalValue();
                    if (null == temp) {
                        this.config.setRecordSeparator("\u0000");
                        break block60;
                    }
                    if (temp.equals("0")) {
                        this.config.setRecordSeparator("\n\n");
                        break block60;
                    }
                    if (temp.equals("777")) {
                        this.config.setRecordSeparator("\uffff");
                        break block60;
                    }
                    try {
                        val = Integer.parseInt(temp, 8);
                        this.config.setRecordSeparator(String.valueOf((char)val));
                        break block60;
                    }
                    catch (Exception e) {
                        mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                        mee.setUsageError(true);
                        throw mee;
                    }
                }
                case 'a': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setSplit(true);
                    break;
                }
                case 'c': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setShouldCheckSyntax(true);
                    break;
                }
                case 'C': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    try {
                        saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                        base = new File(this.config.getCurrentDirectory());
                        newDir = new File(saved);
                        if (saved.startsWith("uri:classloader:")) {
                            this.config.setCurrentDirectory(saved);
                        } else if (newDir.isAbsolute()) {
                            this.config.setCurrentDirectory(newDir.getCanonicalPath());
                        } else {
                            this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                        }
                        if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                            throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                        }
                        break block60;
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                    }
                }
                case 'd': {
                    this.config.setDebug(true);
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                    break;
                }
                case 'e': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.getInlineScript().append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to report")));
                    this.config.getInlineScript().append('\n');
                    this.config.setHasInlineScript(true);
                    break block60;
                }
                case 'E': {
                    if (this.dashUpperU) {
                        mee = this.fakeRuntimeError("jruby: default_internal already set to UTF-8");
                        throw mee;
                    }
                    this.processEncodingOption("-E", this.grabValue(this.getArgumentError("unknown encoding name")));
                    break block60;
                }
                case 'F': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setInputFieldSeparator(this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation")));
                    break block60;
                }
                case 'h': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setShouldPrintUsage(true);
                    this.config.setShouldRunInterpreter(false);
                    break;
                }
                case 'i': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setInPlaceBackupExtension(this.grabOptionalValue());
                    if (this.config.getInPlaceBackupExtension() != null) break block60;
                    this.config.setInPlaceBackupExtension("");
                    break block60;
                }
                case 'I': {
                    s = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                    separator = ":".equals(File.pathSeparator) != false ? "(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):" : File.pathSeparator;
                    paths = Arrays.stream(s.split(separator)).map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processArgument$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                    this.config.getLoadPaths().addAll((Collection<String>)paths.collect(Collectors.toList()));
                    break block60;
                }
                case 'J': {
                    js = this.grabOptionalValue();
                    this.config.getError().println("warning: " + (String)argument + " argument ignored (launched in same VM?)");
                    if (!js.equals("-cp") && !js.equals("-classpath")) break block60;
                    while (this.grabOptionalValue() != null) {
                    }
                    this.grabValue(this.getArgumentError(" -J-cp must be followed by a path expression"));
                    break block60;
                }
                case 'K': {
                    eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                    kcode = KCode.create(eArg);
                    if (kcode == KCode.NIL) break;
                    this.config.setKCode(kcode);
                    this.config.setSourceEncoding(this.config.getKCode().getEncoding().toString());
                    if (this.config.getExternalEncoding() != null) break;
                    this.config.setExternalEncoding(this.config.getKCode().getEncoding().toString());
                    break;
                }
                case 'l': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setProcessLineEnds(true);
                    break;
                }
                case 'n': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'p': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setAssumePrinting(true);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'r': {
                    this.config.getRequiredLibraries().add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                    break block60;
                }
                case 's': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setArgvGlobalsOn(true);
                    break;
                }
                case 'G': {
                    this.config.setLoadGemfile(true);
                    break;
                }
                case 'S': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.runBinScript();
                    break block60;
                }
                case 'U': {
                    this.dashUpperU = true;
                    this.config.setInternalEncoding("UTF-8");
                    break;
                }
                case 'v': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                    this.config.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                    break;
                }
                case 'W': {
                    temp = this.grabOptionalValue();
                    if (temp == null) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                        break block60;
                    }
                    if (temp.equals("0")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.NIL);
                        break block60;
                    }
                    if (temp.equals("1")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.FALSE);
                        break block60;
                    }
                    if (temp.equals("2")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                        break block60;
                    }
                    var9_4 = temp;
                    var10_25 = -1;
                    switch (var9_4.hashCode()) {
                        case 1518658925: {
                            if (!var9_4.equals(":deprecated")) break;
                            var10_25 = 0;
                            break;
                        }
                        case -914686139: {
                            if (!var9_4.equals(":no-deprecated")) break;
                            var10_25 = 1;
                            break;
                        }
                        case -242067934: {
                            if (!var9_4.equals(":experimental")) break;
                            var10_25 = 2;
                            break;
                        }
                        case 2070501882: {
                            if (!var9_4.equals(":no-experimental")) break;
                            var10_25 = 3;
                            break;
                        }
                        case 1711441846: {
                            if (!var9_4.equals(":performance")) break;
                            var10_25 = 4;
                            break;
                        }
                        case -707811106: {
                            if (!var9_4.equals(":no-performance")) break;
                            var10_25 = 5;
                        }
                    }
                    switch (var10_25) {
                        case 0: {
                            this.config.getWarningCategories().add(RubyWarnings.Category.DEPRECATED);
                            break;
                        }
                        case 1: {
                            this.config.getWarningCategories().remove((Object)RubyWarnings.Category.DEPRECATED);
                            break;
                        }
                        case 2: {
                            this.config.getWarningCategories().add(RubyWarnings.Category.EXPERIMENTAL);
                            break;
                        }
                        case 3: {
                            this.config.getWarningCategories().remove((Object)RubyWarnings.Category.EXPERIMENTAL);
                            break;
                        }
                        case 4: {
                            this.config.getWarningCategories().add(RubyWarnings.Category.PERFORMANCE);
                            break;
                        }
                        case 5: {
                            this.config.getWarningCategories().remove((Object)RubyWarnings.Category.PERFORMANCE);
                            break;
                        }
                        default: {
                            if (temp.charAt(0) == ':') {
                                this.config.getError().println("warning: unknown warning category: " + temp.substring(1));
                                break;
                            }
                            mee = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or a valid category"));
                            mee.setUsageError(true);
                            throw mee;
                        }
                    }
                    break block60;
                }
                case 'x': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    try {
                        saved = this.grabOptionalValue();
                        if (saved != null) {
                            base = new File(this.config.getCurrentDirectory());
                            newDir = new File(saved);
                            if (saved.startsWith("uri:classloader:")) {
                                this.config.setCurrentDirectory(saved);
                            } else if (newDir.isAbsolute()) {
                                this.config.setCurrentDirectory(newDir.getCanonicalPath());
                            } else {
                                this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                            }
                            if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                                throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                            }
                        }
                        this.config.setXFlag(true);
                        break block60;
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -x must be followed by a valid directory"));
                    }
                }
                case 'X': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    extendedOption = this.grabOptionalValue();
                    if (extendedOption == null) {
                        if (SafePropertyAccessor.getBoolean("jruby.launcher.nopreamble", false)) {
                            throw new MainExitException(0, OutputStrings.getExtendedHelp());
                        }
                        throw new MainExitException(0, "jruby: missing argument\n" + OutputStrings.getExtendedHelp());
                    }
                    if (extendedOption.equals("-O")) {
                        this.config.setObjectSpaceEnabled(false);
                        break block60;
                    }
                    if (extendedOption.equals("+O")) {
                        this.config.setObjectSpaceEnabled(true);
                        break block60;
                    }
                    if (extendedOption.equals("-C") || extendedOption.equals("-CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block60;
                    }
                    if (extendedOption.equals("+C") || extendedOption.equals("+CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        break block60;
                    }
                    if (extendedOption.endsWith("...")) {
                        Options.listPrefix(extendedOption.substring(0, extendedOption.length() - "...".length()));
                        this.config.setShouldRunInterpreter(false);
                        break block60;
                    }
                    if (extendedOption.endsWith("?")) {
                        Options.listContains(extendedOption.substring(0, extendedOption.length() - 1));
                        this.config.setShouldRunInterpreter(false);
                        break block60;
                    }
                    mee = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'y': {
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setParserDebug(true);
                    break block60;
                }
                case '-': {
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--compat")) {
                        this.characterIndex = argument.length();
                        this.grabValue(this.getArgumentError("--compat takes an argument, but will be ignored"));
                        this.config.getError().println("warning: " + (String)argument + " ignored");
                        break block60;
                    }
                    if (argument.equals("--copyright")) {
                        this.disallowedInRubyOpts((CharSequence)argument);
                        this.config.setShowCopyright(true);
                        this.config.setShouldRunInterpreter(false);
                        break block60;
                    }
                    if (argument.equals("--debug")) {
                        this.disallowedInRubyOpts((CharSequence)argument);
                        Options.DEBUG_FULLTRACE.force("true");
                        RubyInstanceConfig.FULL_TRACE_ENABLED = true;
                        this.config.setDebuggingFrozenStringLiteral(true);
                        break block60;
                    }
                    if (argument.startsWith("--debug=")) {
                        for (String debug : ArgumentProcessor.valueListFor((String)argument, "debug")) {
                            all = debug.equals("all");
                            if (all || debug.equals("frozen-string-literal")) {
                                this.config.setDebuggingFrozenStringLiteral(true);
                                continue;
                            }
                            this.config.getError().println("warning: unknown argument for --debug: '" + debug + "'");
                        }
                        break block60;
                    }
                    if (argument.startsWith("--encoding")) {
                        len = argument.length();
                        if (len == "--encoding".length()) {
                            this.characterIndex = len;
                            encodingValue = this.grabValue(this.getArgumentError("missing argument for --encoding"), false);
                        } else {
                            splitIndex = argument.indexOf(61);
                            if (splitIndex == -1 || len == splitIndex + 1) {
                                throw new MainExitException(0, "jruby: missing argument for --encoding");
                            }
                            encodingValue = argument.substring(splitIndex + 1);
                        }
                        this.processEncodingOption("--encoding", encodingValue);
                        break block60;
                    }
                    if (argument.equals("--jdb")) {
                        this.config.setDebug(true);
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.disallowedInRubyOpts((CharSequence)argument);
                        this.config.setShouldPrintUsage(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--properties")) {
                        this.config.setShouldPrintProperties(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--version")) {
                        this.disallowedInRubyOpts((CharSequence)argument);
                        this.config.setShowVersion(true);
                        this.config.setShouldRunInterpreter(false);
                        break block60;
                    }
                    if (argument.equals("--bytecode")) {
                        this.config.setShowBytecode(true);
                        break block60;
                    }
                    if (argument.equals("--fast")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        break block60;
                    }
                    if (argument.startsWith("--profile")) {
                        this.characterIndex = argument.length();
                        dotIndex = argument.indexOf(46);
                        if (dotIndex == -1) {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.FLAT);
                            break block60;
                        }
                        profilingMode = argument.substring(dotIndex + 1, argument.length());
                        if (profilingMode.equals("out")) {
                            outputFile = this.grabValue(this.getArgumentError("--profile.out requires an output file argument"));
                            try {
                                this.config.setProfileOutput(new ProfileOutput(new File(outputFile)));
                                break block60;
                            }
                            catch (FileNotFoundException e) {
                                throw new MainExitException(1, String.format("jruby: %s", new Object[]{e.getMessage()}));
                            }
                        }
                        if (profilingMode.equals("service")) {
                            service = this.grabValue(this.getArgumentError("--profile.service requires an class name argument"));
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.SERVICE);
                            this.config.setProfilingService(service);
                            break block60;
                        }
                        try {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.valueOf(profilingMode.toUpperCase()));
                            break block60;
                        }
                        catch (IllegalArgumentException e) {
                            throw new MainExitException(1, String.format("jruby: unknown profiler mode \"%s\"", new Object[]{profilingMode}));
                        }
                    }
                    if (ArgumentProcessor.VERSION_FLAG.matcher((CharSequence)argument).matches()) {
                        this.config.getError().println("warning: " + (String)argument + " ignored");
                        break block60;
                    }
                    if (argument.equals("--debug-frozen-string-literal")) {
                        this.config.setDebuggingFrozenStringLiteral(true);
                        break block60;
                    }
                    if (argument.startsWith("--disable")) {
                        len = argument.length();
                        if (len == "--disable".length()) {
                            this.characterIndex = len;
                            feature /* !! */  = this.grabValue(this.getArgumentError("missing argument for --disable"), false);
                            argument = "--disable=" + (String)feature /* !! */ ;
                        }
                        for (String disable : ArgumentProcessor.valueListFor((String)argument, "disable")) {
                            this.enableDisableFeature(disable, false);
                        }
                        break block60;
                    }
                    if (argument.startsWith("--enable")) {
                        len = argument.length();
                        if (len == "--enable".length()) {
                            this.characterIndex = len;
                            feature /* !! */  = this.grabValue(this.getArgumentError("missing argument for --enable"), false);
                            argument = "--enable=" + (String)feature /* !! */ ;
                        }
                        for (String enable : ArgumentProcessor.valueListFor((String)argument, "enable")) {
                            this.enableDisableFeature(enable, true);
                        }
                        break block60;
                    }
                    if (argument.equals("--gemfile")) {
                        this.config.setLoadGemfile(true);
                        break block60;
                    }
                    if (argument.equals("--dump")) {
                        this.characterIndex = argument.length();
                        dumpArg = this.grabValue("missing argument for --dump", false);
                        if (dumpArg.equals("version")) {
                            this.config.setShowVersion(true);
                            this.config.setShouldRunInterpreter(false);
                            break block60;
                        }
                        if (dumpArg.equals("copyright")) {
                            this.config.setShowCopyright(true);
                            this.config.setShouldRunInterpreter(false);
                            break block60;
                        }
                        if (dumpArg.equals("usage")) {
                            this.config.setShouldPrintUsage(true);
                            this.config.setShouldRunInterpreter(false);
                            break block60;
                        }
                        if (dumpArg.equals("yydebug")) {
                            this.config.setParserDebug(true);
                            break block60;
                        }
                        if (dumpArg.equals("syntax")) {
                            this.config.setShouldCheckSyntax(true);
                            break;
                        }
                        if (dumpArg.equals("insns")) {
                            this.config.setShowBytecode(true);
                            break;
                        }
                        mee = new MainExitException(1, "--dump only supports [version, copyright, usage, yydebug, syntax, insns] on JRuby");
                        mee.setUsageError(true);
                        throw mee;
                    }
                    if (argument.equals("--dev")) {
                        Options.COMPILE_INVOKEDYNAMIC.force("false");
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block60;
                    }
                    if (argument.equals("--server") || argument.equals("--client")) break block60;
                    if (!argument.equals("--yydebug")) ** GOTO lbl447
                    this.disallowedInRubyOpts((CharSequence)argument);
                    this.config.setParserDebug(true);
                    ** GOTO lbl492
lbl447:
                    // 1 sources

                    if (argument.equals("--verbose")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break block60;
                    }
                    if (argument.startsWith("--backtrace-limit=")) {
                        limit = ArgumentProcessor.valueListFor((String)argument, "backtrace-limit")[0];
                        this.config.setBacktraceLimit(Integer.parseInt(limit));
                        break block60;
                    }
                    if (argument.startsWith("--external-encoding=")) {
                        externalEncoding = ArgumentProcessor.valueListFor((String)argument, "external-encoding")[0];
                        this.config.setExternalEncoding(externalEncoding);
                        break block60;
                    }
                    if (argument.startsWith("--external-encoding")) {
                        this.characterIndex = argument.length();
                        externalEncoding = this.grabValue("missing argument for --external-encoding", false);
                        this.config.setExternalEncoding(externalEncoding);
                        break block60;
                    }
                    if (argument.startsWith("--internal-encoding=")) {
                        internalEncoding = ArgumentProcessor.valueListFor((String)argument, "internal-encoding")[0];
                        this.config.setInternalEncoding(internalEncoding);
                        break block60;
                    }
                    if (argument.startsWith("--internal-encoding")) {
                        this.characterIndex = argument.length();
                        internalEncoding = this.grabValue("missing argument for --internal-encoding", false);
                        this.config.setInternalEncoding(internalEncoding);
                        break block60;
                    }
                    if (!argument.startsWith("--backtrace-limit=")) ** GOTO lbl480
                    backtraceLimit = ArgumentProcessor.valueListFor((String)argument, "backtrace-limit")[0];
                    try {
                        limit = Integer.parseInt(backtraceLimit);
                        this.config.setBacktraceLimit(limit);
                        ** GOTO lbl492
                    }
                    catch (NumberFormatException nfe) {
                        throw new MainExitException(1, "jruby: wrong limit for backtrace length");
                    }
lbl480:
                    // 1 sources

                    if (argument.startsWith("--backtrace-limit")) {
                        this.characterIndex = argument.length();
                        backtraceLimit = this.grabValue("missing argument for --backtrace-limit", false);
                        try {
                            limit = Integer.parseInt(backtraceLimit);
                            this.config.setBacktraceLimit(limit);
                            break block60;
                        }
                        catch (NumberFormatException nfe) {
                            throw new MainExitException(1, "jruby: wrong limit for backtrace length");
                        }
                    }
                    if (argument.equals("--")) {
                        this.endOfArguments = true;
                        break;
                    }
                }
lbl492:
                // 5 sources

                default: {
                    throw new MainExitException(1, "jruby: unknown option " + (String)argument);
                }
            }
            ++this.characterIndex;
        }
    }

    private void enableDisableFeature(String name2, boolean enable2) {
        BiFunction<ArgumentProcessor, Boolean, Void> feature = FEATURES.get(name2);
        if (feature == null) {
            this.config.getError().println("warning: unknown argument for --" + (enable2 ? "enable" : "disable") + ": '" + name2 + "'");
        } else {
            feature.apply(this, enable2);
        }
    }

    private static String[] valueListFor(String argument, String key2) {
        int length2 = key2.length() + 3;
        String[] values2 = argument.substring(length2).split(",");
        if (values2.length == 0) {
            ArgumentProcessor.errorMissingEquals(key2);
        }
        return values2;
    }

    private void disallowedInRubyOpts(CharSequence option) {
        if (this.rubyOpts) {
            throw this.fakeRuntimeError("jruby: invalid switch in RUBYOPT: " + String.valueOf(option));
        }
    }

    private MainExitException fakeRuntimeError(String message2) {
        return new MainExitException(1, message2 + " (RuntimeError)");
    }

    private static void errorMissingEquals(String label2) {
        MainExitException mee = new MainExitException(1, "missing argument for --" + label2 + "\n");
        mee.setUsageError(true);
        throw mee;
    }

    private void processEncodingOption(String optionString, String value2) {
        List<String> encodings = StringSupport.split(value2, ':', 3);
        switch (encodings.size()) {
            case 3: {
                throw new MainExitException(1, "extra argument for " + optionString + ": " + encodings.get(2));
            }
            case 2: {
                this.config.setInternalEncoding(encodings.get(1));
            }
            case 1: {
                this.config.setExternalEncoding(encodings.get(0));
            }
        }
    }

    private void runBinScript() {
        String scriptName = this.grabValue("jruby: provide a bin script to execute");
        if (scriptName.equals("irb")) {
            scriptName = "jirb";
        }
        this.config.setScriptFileName(this.resolveScript(scriptName));
        if (this.config.getScriptFileName() == null) {
            this.config.setScriptFileName(scriptName);
            this.config.getRequiredLibraries().add("jruby/commands");
            this.config.getInlineScript().append("JRuby::Commands.").append(scriptName);
            this.config.getInlineScript().append("\n");
            this.config.setHasInlineScript(true);
        }
        this.endOfArguments = true;
    }

    private String resolve(String path2, String scriptName) {
        if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
            this.config.getError().println("Trying path: " + path2);
        }
        try {
            FileResource fullName = JRubyFile.createRestrictedResource(path2, scriptName);
            if (fullName.exists() && fullName.isFile()) {
                if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                    this.config.getError().println("Found: " + fullName.absolutePath());
                }
                return fullName.absolutePath();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private String resolveScript(String scriptName) {
        String result2 = this.resolve(this.config.getCurrentDirectory(), scriptName);
        if (result2 != null) {
            return scriptName;
        }
        result2 = this.resolve(this.config.getJRubyHome() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve(this.config.getCurrentDirectory() + "/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        result2 = this.resolve("uri:classloader:/bin", scriptName);
        if (result2 != null) {
            return result2;
        }
        String maybePath = this.config.getEnvironment().get("PATH");
        if (maybePath != null) {
            String path2 = maybePath.toString();
            String[] paths = path2.split(File.pathSeparator);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                result2 = this.resolve(new File(paths[i2]).getAbsolutePath(), scriptName);
                if (result2 == null) continue;
                return result2;
            }
        }
        if (this.config.isDebug()) {
            this.config.getError().println("warning: could not resolve -S script: " + scriptName);
        }
        return null;
    }

    @Deprecated
    public String resolveScriptUsingClassLoader(String scriptName) {
        if (RubyInstanceConfig.defaultClassLoader().getResourceAsStream("bin/" + scriptName) != null) {
            return "classpath:/bin/" + scriptName;
        }
        return null;
    }

    private String grabValue(String errorMessage) {
        return this.grabValue(errorMessage, true);
    }

    private String grabValue(String errorMessage, boolean usageError) {
        String optValue = this.grabOptionalValue();
        if (optValue != null) {
            return optValue;
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.size()) {
            return this.arguments.get((int)this.argumentIndex).originalValue;
        }
        MainExitException mee = new MainExitException(1, errorMessage);
        if (usageError) {
            mee.setUsageError(true);
        }
        throw mee;
    }

    private String grabOptionalValue() {
        ++this.characterIndex;
        String argValue = this.arguments.get((int)this.argumentIndex).originalValue;
        if (this.characterIndex < argValue.length()) {
            return argValue.substring(this.characterIndex);
        }
        return null;
    }

    private static void checkProperties() {
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("jruby.") || ArgumentProcessor.isPropertySupported(propertyName)) continue;
            System.err.println("jruby: warning: unknown property " + propertyName);
        }
    }

    private static boolean isPropertySupported(String propertyName) {
        if (KNOWN_PROPERTIES.contains(propertyName)) {
            return true;
        }
        for (String prefix : KNOWN_PROPERTY_PREFIXES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ String lambda$processArgument$0(String path2) {
        return new JRubyFile(path2).getAbsolutePath();
    }

    static {
        Options.addPropertyNames(KNOWN_PROPERTIES);
        KNOWN_PROPERTIES.add("jruby.home");
        KNOWN_PROPERTIES.add("jruby.script");
        KNOWN_PROPERTIES.add("jruby.shell");
        KNOWN_PROPERTIES.add("jruby.lib");
        KNOWN_PROPERTIES.add("jruby.bindir");
        KNOWN_PROPERTIES.add("jruby.jar");
        KNOWN_PROPERTIES.add("jruby.compat.version");
        KNOWN_PROPERTIES.add("jruby.reflection");
        KNOWN_PROPERTIES.add("jruby.thread.pool.enabled");
        KNOWN_PROPERTIES.add("jruby.memory.max");
        KNOWN_PROPERTIES.add("jruby.stack.max");
        KNOWN_PROPERTY_PREFIXES = new ArrayList<String>(4);
        KNOWN_PROPERTY_PREFIXES.add("jruby.openssl.");
        HashMap<String, BiFunction<ArgumentProcessor, Boolean, Void>> features = new HashMap<String, BiFunction<ArgumentProcessor, Boolean, Void>>(12, 1.0f);
        features.put("all", new BiFunction<ArgumentProcessor, Boolean, Void>(){

            @Override
            public Void apply(ArgumentProcessor processor, Boolean enable2) {
                for (Map.Entry<String, BiFunction<ArgumentProcessor, Boolean, Void>> entry : FEATURES.entrySet()) {
                    if (entry.getKey().equals("all")) continue;
                    entry.getValue().apply(processor, enable2);
                }
                return null;
            }
        });
        features.put("gem", (processor, enable2) -> {
            processor.config.setDisableGems(enable2 == false);
            return null;
        });
        features.put("gems", (processor, enable2) -> {
            processor.config.setDisableGems(enable2 == false);
            return null;
        });
        BiFunction<ArgumentProcessor, Boolean, Void> function = (processor, enable2) -> {
            processor.config.setDisableDidYouMean(enable2 == false);
            return null;
        };
        features.put("did-you-mean", function);
        features.put("did_you_mean", function);
        features.put("rubyopt", (processor, enable2) -> {
            processor.config.setDisableRUBYOPT(enable2 == false);
            return null;
        });
        function = (processor, enable2) -> {
            processor.config.setFrozenStringLiteral((boolean)enable2);
            return null;
        };
        features.put("frozen-string-literal", function);
        features.put("frozen_string_literal", function);
        FEATURES = features;
    }

    private static final class Argument {
        final String originalValue;
        private String dashedValue;

        Argument(String value2, boolean dashed) {
            this.originalValue = value2;
            this.dashedValue = dashed ? null : value2;
        }

        final String getDashedValue() {
            Object dashedValue = this.dashedValue;
            if (dashedValue == null) {
                String value2 = this.originalValue;
                this.dashedValue = dashedValue = !value2.startsWith("-") ? "-" + value2 : value2;
            }
            return dashedValue;
        }

        public String toString() {
            return this.getDashedValue();
        }
    }
}

