/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.FakeLanguage;
import org.languagetool.Language;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.patterns.RuleSet;

public class RuleSetTest {
    private static final AnalyzedSentence sampleSentence = new AnalyzedSentence(new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("token", "pos", "lemma"))});

    @Test
    public void textHintsAreHonored() {
        PatternRule suitable = RuleSetTest.ruleOf(PatternRuleBuilderHelper.csToken((String)"token"));
        RuleSetTest.assertRulesForSentence(RuleSet.textHinted(Collections.singletonList(suitable)), suitable);
        suitable = RuleSetTest.ruleOf(PatternRuleBuilderHelper.token((String)"Token"));
        RuleSetTest.assertRulesForSentence(RuleSet.textHinted(Collections.singletonList(suitable)), suitable);
        suitable = RuleSetTest.ruleOf(PatternRuleBuilderHelper.tokenRegex((String)"token|another"));
        RuleSetTest.assertRulesForSentence(RuleSet.textHinted(Collections.singletonList(suitable)), suitable);
        RuleSetTest.assertRulesForSentence(RuleSet.textHinted(Collections.singletonList(RuleSetTest.ruleOf(PatternRuleBuilderHelper.csToken((String)"unsuitable")))), new PatternRule[0]);
    }

    @Test
    public void lemmaHintsAreHonored() {
        PatternRule suitable = RuleSetTest.ruleOf(new PatternTokenBuilder().token("lemma").matchInflectedForms().build());
        RuleSetTest.assertRulesForSentence(RuleSet.textLemmaHinted(Collections.singletonList(suitable)), suitable);
        suitable = RuleSetTest.ruleOf(new PatternTokenBuilder().token("Lemma").matchInflectedForms().build());
        RuleSetTest.assertRulesForSentence(RuleSet.textLemmaHinted(Collections.singletonList(suitable)), suitable);
        suitable = RuleSetTest.ruleOf(new PatternTokenBuilder().csTokenRegex("lemm[ab]").matchInflectedForms().build());
        RuleSetTest.assertRulesForSentence(RuleSet.textLemmaHinted(Collections.singletonList(suitable)), suitable);
        PatternToken unsuitable = new PatternTokenBuilder().csToken("unsuitable").matchInflectedForms().build();
        RuleSetTest.assertRulesForSentence(RuleSet.textLemmaHinted(Collections.singletonList(RuleSetTest.ruleOf(unsuitable))), new PatternRule[0]);
        PatternRule unrelated = RuleSetTest.ruleOf(PatternRuleBuilderHelper.pos((String)"somePos"));
        RuleSetTest.assertRulesForSentence(RuleSet.textLemmaHinted(Arrays.asList(RuleSetTest.ruleOf(unsuitable), unrelated)), unrelated);
    }

    private static void assertRulesForSentence(RuleSet ruleSet, PatternRule ... expected) {
        Assert.assertEquals(Arrays.asList(expected), (Object)ruleSet.rulesForSentence(sampleSentence));
    }

    private static PatternRule ruleOf(PatternToken token) {
        return new PatternRule("", (Language)new FakeLanguage(), Collections.singletonList(token), "", "", "");
    }
}

