/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ByteArrayFileStream;
import com.hankcs.hanlp.corpus.io.ByteArrayOtherStream;
import com.hankcs.hanlp.utility.Predefine;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ByteArrayStream
extends ByteArray {
    protected int bufferSize;

    public ByteArrayStream(byte[] bytes, int bufferSize) {
        super(bytes);
        this.bufferSize = bufferSize;
    }

    public static ByteArrayStream createByteArrayStream(String path) {
        if (HanLP.Config.IOAdapter == null) {
            return ByteArrayFileStream.createByteArrayFileStream(path);
        }
        try {
            InputStream is = HanLP.Config.IOAdapter.open(path);
            if (is instanceof FileInputStream) {
                return ByteArrayFileStream.createByteArrayFileStream((FileInputStream)is);
            }
            return ByteArrayOtherStream.createByteArrayOtherStream(is);
        }
        catch (IOException e) {
            Predefine.logger.warning("\u6253\u5f00\u5931\u8d25\uff1a" + path);
            return null;
        }
    }

    @Override
    public int nextInt() {
        this.ensureAvailableBytes(4);
        return super.nextInt();
    }

    @Override
    public char nextChar() {
        this.ensureAvailableBytes(2);
        return super.nextChar();
    }

    @Override
    public double nextDouble() {
        this.ensureAvailableBytes(8);
        return super.nextDouble();
    }

    @Override
    public byte nextByte() {
        this.ensureAvailableBytes(1);
        return super.nextByte();
    }

    @Override
    public float nextFloat() {
        this.ensureAvailableBytes(4);
        return super.nextFloat();
    }

    protected abstract void ensureAvailableBytes(int var1);
}

