/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeFactory;

public final class StandardTokenizer
extends Tokenizer {
    private StandardTokenizerImpl scanner;
    public static final int ALPHANUM = 0;
    public static final int NUM = 1;
    public static final int SOUTHEAST_ASIAN = 2;
    public static final int IDEOGRAPHIC = 3;
    public static final int HIRAGANA = 4;
    public static final int KATAKANA = 5;
    public static final int HANGUL = 6;
    public static final int EMOJI = 7;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<NUM>", "<SOUTHEAST_ASIAN>", "<IDEOGRAPHIC>", "<HIRAGANA>", "<KATAKANA>", "<HANGUL>", "<EMOJI>"};
    public static final int MAX_TOKEN_LENGTH_LIMIT = 0x100000;
    private int skippedPositions;
    private int maxTokenLength = 255;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public void setMaxTokenLength(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("maxTokenLength must be greater than zero");
        }
        if (length > 0x100000) {
            throw new IllegalArgumentException("maxTokenLength may not exceed 1048576");
        }
        if (length != this.maxTokenLength) {
            this.maxTokenLength = length;
            this.scanner.setBufferSize(length);
        }
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public StandardTokenizer() {
        this.init();
    }

    public StandardTokenizer(AttributeFactory factory2) {
        super(factory2);
        this.init();
    }

    private void init() {
        this.scanner = new StandardTokenizerImpl(this.input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.length()));
                this.typeAtt.setType(TOKEN_TYPES[tokenType]);
                return true;
            }
            ++this.skippedPositions;
        }
        return false;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.scanner.yyreset(this.input);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
        this.skippedPositions = 0;
    }
}

