/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

public class TreeExpansionBroadcaster
implements TreeExpansionListener {
    private Object source;
    private EventListenerList listeners;

    public TreeExpansionBroadcaster(Object source2) {
        this.source = source2;
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        this.getEventListenerList().add(TreeExpansionListener.class, l);
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        if (!this.hasListeners()) {
            return;
        }
        this.listeners.remove(TreeExpansionListener.class, l);
    }

    private EventListenerList getEventListenerList() {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        return this.listeners;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        this.fireTreeExpanded(this.retarget(event));
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        this.fireTreeCollapsed(this.retarget(event));
    }

    private void fireTreeExpanded(TreeExpansionEvent event) {
        TreeExpansionListener[] ls = (TreeExpansionListener[])this.listeners.getListeners(TreeExpansionListener.class);
        for (int i = ls.length - 1; i >= 0; --i) {
            ls[i].treeExpanded(event);
        }
    }

    private void fireTreeCollapsed(TreeExpansionEvent event) {
        TreeExpansionListener[] ls = (TreeExpansionListener[])this.listeners.getListeners(TreeExpansionListener.class);
        for (int i = ls.length - 1; i >= 0; --i) {
            ls[i].treeCollapsed(event);
        }
    }

    private TreeExpansionEvent retarget(TreeExpansionEvent event) {
        return new TreeExpansionEvent(this.source, event.getPath());
    }

    private boolean hasListeners() {
        return this.listeners != null && this.listeners.getListenerCount() > 0;
    }
}

