(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2["mermaid-zenuml"] = factory());
})(this, function() {
  "use strict";
  const id$1 = "zenuml";
  const detector = (txt) => {
    return /^\s*zenuml/.test(txt);
  };
  const loader = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => zenumlDefinition);
    return { id: id$1, diagram: diagram2 };
  };
  const plugin = {
    id: id$1,
    detector,
    loader
  };
  const warning = (s10) => {
    console.error("Log function was called before initialization", s10);
  };
  const log = {
    trace: warning,
    debug: warning,
    info: warning,
    warn: warning,
    error: warning,
    fatal: warning
  };
  let getConfig;
  const injectUtils = (_log, _setLogLevel, _getConfig, _sanitizeText, _setupGraphViewbox) => {
    _log.info("Mermaid utils injected");
    log.trace = _log.trace;
    log.debug = _log.debug;
    log.info = _log.info;
    log.warn = _log.warn;
    log.error = _log.error;
    log.fatal = _log.fatal;
    getConfig = _getConfig;
  };
  const parser = {
    parser: { yy: {} },
    parse: () => {
    }
  };
  var v6 = Object.defineProperty;
  var b6 = (t10, e10, n10) => e10 in t10 ? v6(t10, e10, { enumerable: true, configurable: true, writable: true, value: n10 }) : t10[e10] = n10;
  var W$1 = (t10, e10, n10) => (b6(t10, typeof e10 != "symbol" ? e10 + "" : e10, n10), n10);
  var Y0 = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : typeof global < "u" ? global : typeof self < "u" ? self : {};
  function w6(t10) {
    try {
      return JSON.stringify(t10);
    } catch {
      return '"[Circular]"';
    }
  }
  var E6 = T6;
  function T6(t10, e10, n10) {
    var r10 = n10 && n10.stringify || w6, s10 = 1;
    if (typeof t10 == "object" && t10 !== null) {
      var i10 = e10.length + s10;
      if (i10 === 1)
        return t10;
      var o10 = new Array(i10);
      o10[0] = r10(t10);
      for (var l10 = 1; l10 < i10; l10++)
        o10[l10] = r10(e10[l10]);
      return o10.join(" ");
    }
    if (typeof t10 != "string")
      return t10;
    var a10 = e10.length;
    if (a10 === 0)
      return t10;
    for (var c10 = "", u10 = 1 - s10, h10 = -1, d10 = t10 && t10.length || 0, p10 = 0; p10 < d10; ) {
      if (t10.charCodeAt(p10) === 37 && p10 + 1 < d10) {
        switch (h10 = h10 > -1 ? h10 : 0, t10.charCodeAt(p10 + 1)) {
          case 100:
          case 102:
            if (u10 >= a10 || e10[u10] == null)
              break;
            h10 < p10 && (c10 += t10.slice(h10, p10)), c10 += Number(e10[u10]), h10 = p10 + 2, p10++;
            break;
          case 105:
            if (u10 >= a10 || e10[u10] == null)
              break;
            h10 < p10 && (c10 += t10.slice(h10, p10)), c10 += Math.floor(Number(e10[u10])), h10 = p10 + 2, p10++;
            break;
          case 79:
          case 111:
          case 106:
            if (u10 >= a10 || e10[u10] === void 0)
              break;
            h10 < p10 && (c10 += t10.slice(h10, p10));
            var g = typeof e10[u10];
            if (g === "string") {
              c10 += "'" + e10[u10] + "'", h10 = p10 + 2, p10++;
              break;
            }
            if (g === "function") {
              c10 += e10[u10].name || "<anonymous>", h10 = p10 + 2, p10++;
              break;
            }
            c10 += r10(e10[u10]), h10 = p10 + 2, p10++;
            break;
          case 115:
            if (u10 >= a10)
              break;
            h10 < p10 && (c10 += t10.slice(h10, p10)), c10 += String(e10[u10]), h10 = p10 + 2, p10++;
            break;
          case 37:
            h10 < p10 && (c10 += t10.slice(h10, p10)), c10 += "%", h10 = p10 + 2, p10++, u10--;
            break;
        }
        ++u10;
      }
      ++p10;
    }
    return h10 === -1 ? t10 : (h10 < d10 && (c10 += t10.slice(h10)), c10);
  }
  const kc = E6;
  var S6 = wn$1;
  const a0 = D6().console || {}, A6 = {
    mapHttpRequest: X0,
    mapHttpResponse: X0,
    wrapRequestSerializer: z1,
    wrapResponseSerializer: z1,
    wrapErrorSerializer: z1,
    req: X0,
    res: X0,
    err: M6
  };
  function k6(t10, e10) {
    return Array.isArray(t10) ? t10.filter(function(r10) {
      return r10 !== "!stdSerializers.err";
    }) : t10 === true ? Object.keys(e10) : false;
  }
  function wn$1(t10) {
    t10 = t10 || {}, t10.browser = t10.browser || {};
    const e10 = t10.browser.transmit;
    if (e10 && typeof e10.send != "function")
      throw Error("pino: transmit option must have a send function");
    const n10 = t10.browser.write || a0;
    t10.browser.write && (t10.browser.asObject = true);
    const r10 = t10.serializers || {}, s10 = k6(t10.browser.serialize, r10);
    let i10 = t10.browser.serialize;
    Array.isArray(t10.browser.serialize) && t10.browser.serialize.indexOf("!stdSerializers.err") > -1 && (i10 = false);
    const o10 = ["error", "fatal", "warn", "info", "debug", "trace"];
    typeof n10 == "function" && (n10.error = n10.fatal = n10.warn = n10.info = n10.debug = n10.trace = n10), (t10.enabled === false || t10.browser.disabled) && (t10.level = "silent");
    const l10 = t10.level || "info", a10 = Object.create(n10);
    a10.log || (a10.log = c0), Object.defineProperty(a10, "levelVal", {
      get: u10
    }), Object.defineProperty(a10, "level", {
      get: h10,
      set: d10
    });
    const c10 = {
      transmit: e10,
      serialize: s10,
      asObject: t10.browser.asObject,
      levels: o10,
      timestamp: N6(t10)
    };
    a10.levels = wn$1.levels, a10.level = l10, a10.setMaxListeners = a10.getMaxListeners = a10.emit = a10.addListener = a10.on = a10.prependListener = a10.once = a10.prependOnceListener = a10.removeListener = a10.removeAllListeners = a10.listeners = a10.listenerCount = a10.eventNames = a10.write = a10.flush = c0, a10.serializers = r10, a10._serialize = s10, a10._stdErrSerialize = i10, a10.child = p10, e10 && (a10._logEvent = _o());
    function u10() {
      return this.level === "silent" ? 1 / 0 : this.levels.values[this.level];
    }
    function h10() {
      return this._level;
    }
    function d10(g) {
      if (g !== "silent" && !this.levels.values[g])
        throw Error("unknown level " + g);
      this._level = g, Yr(c10, a10, "error", "log"), Yr(c10, a10, "fatal", "error"), Yr(c10, a10, "warn", "error"), Yr(c10, a10, "info", "log"), Yr(c10, a10, "debug", "log"), Yr(c10, a10, "trace", "log");
    }
    function p10(g, L) {
      if (!g)
        throw new Error("missing bindings for child Pino");
      L = L || {}, s10 && g.serializers && (L.serializers = g.serializers);
      const T = L.serializers;
      if (s10 && T) {
        var _10 = Object.assign({}, r10, T), x = t10.browser.serialize === true ? Object.keys(_10) : s10;
        delete g.serializers, qi([g], x, _10, this._stdErrSerialize);
      }
      function C(E) {
        this._childLevel = (E._childLevel | 0) + 1, this.error = Xr(E, g, "error"), this.fatal = Xr(E, g, "fatal"), this.warn = Xr(E, g, "warn"), this.info = Xr(E, g, "info"), this.debug = Xr(E, g, "debug"), this.trace = Xr(E, g, "trace"), _10 && (this.serializers = _10, this._serialize = x), e10 && (this._logEvent = _o(
          [].concat(E._logEvent.bindings, g)
        ));
      }
      return C.prototype = this, new C(this);
    }
    return a10;
  }
  wn$1.levels = {
    values: {
      fatal: 60,
      error: 50,
      warn: 40,
      info: 30,
      debug: 20,
      trace: 10
    },
    labels: {
      10: "trace",
      20: "debug",
      30: "info",
      40: "warn",
      50: "error",
      60: "fatal"
    }
  };
  wn$1.stdSerializers = A6;
  wn$1.stdTimeFunctions = Object.assign({}, { nullTime: Mu, epochTime: Nu, unixTime: P6, isoTime: F6 });
  function Yr(t10, e10, n10, r10) {
    const s10 = Object.getPrototypeOf(e10);
    e10[n10] = e10.levelVal > e10.levels.values[n10] ? c0 : s10[n10] ? s10[n10] : a0[n10] || a0[r10] || c0, R6(t10, e10, n10);
  }
  function R6(t10, e10, n10) {
    !t10.transmit && e10[n10] === c0 || (e10[n10] = function(r10) {
      return function() {
        const i10 = t10.timestamp(), o10 = new Array(arguments.length), l10 = Object.getPrototypeOf && Object.getPrototypeOf(this) === a0 ? a0 : this;
        for (var a10 = 0; a10 < o10.length; a10++)
          o10[a10] = arguments[a10];
        if (t10.serialize && !t10.asObject && qi(o10, this._serialize, this.serializers, this._stdErrSerialize), t10.asObject ? r10.call(l10, O6(this, n10, o10, i10)) : r10.apply(l10, o10), t10.transmit) {
          const c10 = t10.transmit.level || e10.level, u10 = wn$1.levels.values[c10], h10 = wn$1.levels.values[n10];
          if (h10 < u10)
            return;
          I6(this, {
            ts: i10,
            methodLevel: n10,
            methodValue: h10,
            transmitLevel: c10,
            transmitValue: wn$1.levels.values[t10.transmit.level || e10.level],
            send: t10.transmit.send,
            val: e10.levelVal
          }, o10);
        }
      };
    }(e10[n10]));
  }
  function O6(t10, e10, n10, r10) {
    t10._serialize && qi(n10, t10._serialize, t10.serializers, t10._stdErrSerialize);
    const s10 = n10.slice();
    let i10 = s10[0];
    const o10 = {};
    r10 && (o10.time = r10), o10.level = wn$1.levels.values[e10];
    let l10 = (t10._childLevel | 0) + 1;
    if (l10 < 1 && (l10 = 1), i10 !== null && typeof i10 == "object") {
      for (; l10-- && typeof s10[0] == "object"; )
        Object.assign(o10, s10.shift());
      i10 = s10.length ? kc(s10.shift(), s10) : void 0;
    } else
      typeof i10 == "string" && (i10 = kc(s10.shift(), s10));
    return i10 !== void 0 && (o10.msg = i10), o10;
  }
  function qi(t10, e10, n10, r10) {
    for (const s10 in t10)
      if (r10 && t10[s10] instanceof Error)
        t10[s10] = wn$1.stdSerializers.err(t10[s10]);
      else if (typeof t10[s10] == "object" && !Array.isArray(t10[s10]))
        for (const i10 in t10[s10])
          e10 && e10.indexOf(i10) > -1 && i10 in n10 && (t10[s10][i10] = n10[i10](t10[s10][i10]));
  }
  function Xr(t10, e10, n10) {
    return function() {
      const r10 = new Array(1 + arguments.length);
      r10[0] = e10;
      for (var s10 = 1; s10 < r10.length; s10++)
        r10[s10] = arguments[s10 - 1];
      return t10[n10].apply(this, r10);
    };
  }
  function I6(t10, e10, n10) {
    const r10 = e10.send, s10 = e10.ts, i10 = e10.methodLevel, o10 = e10.methodValue, l10 = e10.val, a10 = t10._logEvent.bindings;
    qi(
      n10,
      t10._serialize || Object.keys(t10.serializers),
      t10.serializers,
      t10._stdErrSerialize === void 0 ? true : t10._stdErrSerialize
    ), t10._logEvent.ts = s10, t10._logEvent.messages = n10.filter(function(c10) {
      return a10.indexOf(c10) === -1;
    }), t10._logEvent.level.label = i10, t10._logEvent.level.value = o10, r10(i10, t10._logEvent, l10), t10._logEvent = _o(a10);
  }
  function _o(t10) {
    return {
      ts: 0,
      messages: [],
      bindings: t10 || [],
      level: { label: "", value: 0 }
    };
  }
  function M6(t10) {
    const e10 = {
      type: t10.constructor.name,
      msg: t10.message,
      stack: t10.stack
    };
    for (const n10 in t10)
      e10[n10] === void 0 && (e10[n10] = t10[n10]);
    return e10;
  }
  function N6(t10) {
    return typeof t10.timestamp == "function" ? t10.timestamp : t10.timestamp === false ? Mu : Nu;
  }
  function X0() {
    return {};
  }
  function z1(t10) {
    return t10;
  }
  function c0() {
  }
  function Mu() {
    return false;
  }
  function Nu() {
    return Date.now();
  }
  function P6() {
    return Math.round(Date.now() / 1e3);
  }
  function F6() {
    return new Date(Date.now()).toISOString();
  }
  function D6() {
    function t10(e10) {
      return typeof e10 < "u" && e10;
    }
    try {
      return typeof globalThis < "u" || Object.defineProperty(Object.prototype, "globalThis", {
        get: function() {
          return delete Object.prototype.globalThis, this.globalThis = this;
        },
        configurable: true
      }), globalThis;
    } catch {
      return t10(self) || t10(window) || t10(this) || {};
    }
  }
  const B6 = S6({
    level: "warn"
  }), Rc = ["log", "trace", "debug", "info", "warn", "error"];
  function $6(t10, e10) {
    t10[e10] = (console[e10] || console.log).bind(console);
  }
  function H6(t10, e10, n10) {
    t10[e10] = (console[e10] || console.log).bind(
      console,
      n10[0],
      n10[1]
    );
  }
  function U6(t10) {
    Rc.forEach((n10) => $6(t10, n10));
    const e10 = t10.child;
    return t10.child = function(n10) {
      const r10 = e10.call(t10, n10);
      return Rc.forEach(
        (s10) => H6(r10, s10, ["%c" + n10.name || "", "color: #00f"])
      ), r10;
    }, t10;
  }
  const b0 = U6(B6);
  function ws(t10, e10) {
    const n10 = /* @__PURE__ */ Object.create(null), r10 = t10.split(",");
    for (let s10 = 0; s10 < r10.length; s10++)
      n10[r10[s10]] = true;
    return e10 ? (s10) => !!n10[s10.toLowerCase()] : (s10) => !!n10[s10];
  }
  const V6 = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt", z6 = /* @__PURE__ */ ws(V6);
  function Ce$1(t10) {
    if (K$1(t10)) {
      const e10 = {};
      for (let n10 = 0; n10 < t10.length; n10++) {
        const r10 = t10[n10], s10 = Ke$1(r10) ? W6(r10) : Ce$1(r10);
        if (s10)
          for (const i10 in s10)
            e10[i10] = s10[i10];
      }
      return e10;
    } else {
      if (Ke$1(t10))
        return t10;
      if (Se(t10))
        return t10;
    }
  }
  const G6 = /;(?![^(]*\))/g, j6 = /:([^]+)/, Z6 = /\/\*.*?\*\//gs;
  function W6(t10) {
    const e10 = {};
    return t10.replace(Z6, "").split(G6).forEach((n10) => {
      if (n10) {
        const r10 = n10.split(j6);
        r10.length > 1 && (e10[r10[0].trim()] = r10[1].trim());
      }
    }), e10;
  }
  function ve$1(t10) {
    let e10 = "";
    if (Ke$1(t10))
      e10 = t10;
    else if (K$1(t10))
      for (let n10 = 0; n10 < t10.length; n10++) {
        const r10 = ve$1(t10[n10]);
        r10 && (e10 += r10 + " ");
      }
    else if (Se(t10))
      for (const n10 in t10)
        t10[n10] && (e10 += n10 + " ");
    return e10.trim();
  }
  function q6(t10) {
    if (!t10)
      return null;
    let { class: e10, style: n10 } = t10;
    return e10 && !Ke$1(e10) && (t10.class = ve$1(e10)), n10 && (t10.style = Ce$1(n10)), t10;
  }
  const K6 = "itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly", Pu = /* @__PURE__ */ ws(K6);
  function Fu(t10) {
    return !!t10 || t10 === "";
  }
  function Y6(t10, e10) {
    if (t10.length !== e10.length)
      return false;
    let n10 = true;
    for (let r10 = 0; n10 && r10 < t10.length; r10++)
      n10 = jn(t10[r10], e10[r10]);
    return n10;
  }
  function jn(t10, e10) {
    if (t10 === e10)
      return true;
    let n10 = Oc(t10), r10 = Oc(e10);
    if (n10 || r10)
      return n10 && r10 ? t10.getTime() === e10.getTime() : false;
    if (n10 = u0(t10), r10 = u0(e10), n10 || r10)
      return t10 === e10;
    if (n10 = K$1(t10), r10 = K$1(e10), n10 || r10)
      return n10 && r10 ? Y6(t10, e10) : false;
    if (n10 = Se(t10), r10 = Se(e10), n10 || r10) {
      if (!n10 || !r10)
        return false;
      const s10 = Object.keys(t10).length, i10 = Object.keys(e10).length;
      if (s10 !== i10)
        return false;
      for (const o10 in t10) {
        const l10 = t10.hasOwnProperty(o10), a10 = e10.hasOwnProperty(o10);
        if (l10 && !a10 || !l10 && a10 || !jn(t10[o10], e10[o10]))
          return false;
      }
    }
    return String(t10) === String(e10);
  }
  function w0(t10, e10) {
    return t10.findIndex((n10) => jn(n10, e10));
  }
  const Ve$1 = (t10) => Ke$1(t10) ? t10 : t10 == null ? "" : K$1(t10) || Se(t10) && (t10.toString === Bu || !ue$1(t10.toString)) ? JSON.stringify(t10, Du, 2) : String(t10), Du = (t10, e10) => e10 && e10.__v_isRef ? Du(t10, e10.value) : is(e10) ? {
    [`Map(${e10.size})`]: [...e10.entries()].reduce((n10, [r10, s10]) => (n10[`${r10} =>`] = s10, n10), {})
  } : Gr(e10) ? {
    [`Set(${e10.size})`]: [...e10.values()]
  } : Se(e10) && !K$1(e10) && !Ei(e10) ? String(e10) : e10, Ge$1 = {}, ss = [], Bt$1 = () => {
  }, X6 = () => false, Q6 = /^on[^a-z]/, Yn = (t10) => Q6.test(t10), Ll = (t10) => t10.startsWith("onUpdate:"), Oe$1 = Object.assign, _l = (t10, e10) => {
    const n10 = t10.indexOf(e10);
    n10 > -1 && t10.splice(n10, 1);
  }, J6 = Object.prototype.hasOwnProperty, Me = (t10, e10) => J6.call(t10, e10), K$1 = Array.isArray, is = (t10) => E0(t10) === "[object Map]", Gr = (t10) => E0(t10) === "[object Set]", Oc = (t10) => E0(t10) === "[object Date]", ue$1 = (t10) => typeof t10 == "function", Ke$1 = (t10) => typeof t10 == "string", u0 = (t10) => typeof t10 == "symbol", Se = (t10) => t10 !== null && typeof t10 == "object", Ki = (t10) => Se(t10) && ue$1(t10.then) && ue$1(t10.catch), Bu = Object.prototype.toString, E0 = (t10) => Bu.call(t10), e8 = (t10) => E0(t10).slice(8, -1), Ei = (t10) => E0(t10) === "[object Object]", yl = (t10) => Ke$1(t10) && t10 !== "NaN" && t10[0] !== "-" && "" + parseInt(t10, 10) === t10, os = /* @__PURE__ */ ws(
    ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
  ), Yi = (t10) => {
    const e10 = /* @__PURE__ */ Object.create(null);
    return (n10) => e10[n10] || (e10[n10] = t10(n10));
  }, t8 = /-(\w)/g, Rt$1 = Yi((t10) => t10.replace(t8, (e10, n10) => n10 ? n10.toUpperCase() : "")), n8 = /\B([A-Z])/g, St$1 = Yi((t10) => t10.replace(n8, "-$1").toLowerCase()), T0 = Yi((t10) => t10.charAt(0).toUpperCase() + t10.slice(1)), ls = Yi((t10) => t10 ? `on${T0(t10)}` : ""), ms = (t10, e10) => !Object.is(t10, e10), cr = (t10, e10) => {
    for (let n10 = 0; n10 < t10.length; n10++)
      t10[n10](e10);
  }, Ti = (t10, e10, n10) => {
    Object.defineProperty(t10, e10, {
      configurable: true,
      enumerable: false,
      value: n10
    });
  }, An$1 = (t10) => {
    const e10 = parseFloat(t10);
    return isNaN(e10) ? t10 : e10;
  };
  let Ic;
  const r8 = () => Ic || (Ic = typeof globalThis < "u" ? globalThis : typeof self < "u" ? self : typeof window < "u" ? window : typeof global < "u" ? global : {});
  let Zt$1;
  class Cl {
    constructor(e10 = false) {
      this.detached = e10, this.active = true, this.effects = [], this.cleanups = [], this.parent = Zt$1, !e10 && Zt$1 && (this.index = (Zt$1.scopes || (Zt$1.scopes = [])).push(this) - 1);
    }
    run(e10) {
      if (this.active) {
        const n10 = Zt$1;
        try {
          return Zt$1 = this, e10();
        } finally {
          Zt$1 = n10;
        }
      }
    }
    on() {
      Zt$1 = this;
    }
    off() {
      Zt$1 = this.parent;
    }
    stop(e10) {
      if (this.active) {
        let n10, r10;
        for (n10 = 0, r10 = this.effects.length; n10 < r10; n10++)
          this.effects[n10].stop();
        for (n10 = 0, r10 = this.cleanups.length; n10 < r10; n10++)
          this.cleanups[n10]();
        if (this.scopes)
          for (n10 = 0, r10 = this.scopes.length; n10 < r10; n10++)
            this.scopes[n10].stop(true);
        if (!this.detached && this.parent && !e10) {
          const s10 = this.parent.scopes.pop();
          s10 && s10 !== this && (this.parent.scopes[this.index] = s10, s10.index = this.index);
        }
        this.parent = void 0, this.active = false;
      }
    }
  }
  function $u(t10) {
    return new Cl(t10);
  }
  function Hu(t10, e10 = Zt$1) {
    e10 && e10.active && e10.effects.push(t10);
  }
  function s8() {
    return Zt$1;
  }
  function i8(t10) {
    Zt$1 && Zt$1.cleanups.push(t10);
  }
  const vl = (t10) => {
    const e10 = new Set(t10);
    return e10.w = 0, e10.n = 0, e10;
  }, Uu = (t10) => (t10.w & pr) > 0, Vu = (t10) => (t10.n & pr) > 0, o8 = ({ deps: t10 }) => {
    if (t10.length)
      for (let e10 = 0; e10 < t10.length; e10++)
        t10[e10].w |= pr;
  }, l8 = (t10) => {
    const { deps: e10 } = t10;
    if (e10.length) {
      let n10 = 0;
      for (let r10 = 0; r10 < e10.length; r10++) {
        const s10 = e10[r10];
        Uu(s10) && !Vu(s10) ? s10.delete(t10) : e10[n10++] = s10, s10.w &= ~pr, s10.n &= ~pr;
      }
      e10.length = n10;
    }
  }, yo = /* @__PURE__ */ new WeakMap();
  let Ks = 0, pr = 1;
  const Co = 30;
  let hn$1;
  const Ir = Symbol(""), vo = Symbol("");
  class S0 {
    constructor(e10, n10 = null, r10) {
      this.fn = e10, this.scheduler = n10, this.active = true, this.deps = [], this.parent = void 0, Hu(this, r10);
    }
    run() {
      if (!this.active)
        return this.fn();
      let e10 = hn$1, n10 = ur;
      for (; e10; ) {
        if (e10 === this)
          return;
        e10 = e10.parent;
      }
      try {
        return this.parent = hn$1, hn$1 = this, ur = true, pr = 1 << ++Ks, Ks <= Co ? o8(this) : Mc(this), this.fn();
      } finally {
        Ks <= Co && l8(this), pr = 1 << --Ks, hn$1 = this.parent, ur = n10, this.parent = void 0, this.deferStop && this.stop();
      }
    }
    stop() {
      hn$1 === this ? this.deferStop = true : this.active && (Mc(this), this.onStop && this.onStop(), this.active = false);
    }
  }
  function Mc(t10) {
    const { deps: e10 } = t10;
    if (e10.length) {
      for (let n10 = 0; n10 < e10.length; n10++)
        e10[n10].delete(t10);
      e10.length = 0;
    }
  }
  function a8(t10, e10) {
    t10.effect && (t10 = t10.effect.fn);
    const n10 = new S0(t10);
    e10 && (Oe$1(n10, e10), e10.scope && Hu(n10, e10.scope)), (!e10 || !e10.lazy) && n10.run();
    const r10 = n10.run.bind(n10);
    return r10.effect = n10, r10;
  }
  function c8(t10) {
    t10.effect.stop();
  }
  let ur = true;
  const zu = [];
  function Es() {
    zu.push(ur), ur = false;
  }
  function Ts() {
    const t10 = zu.pop();
    ur = t10 === void 0 ? true : t10;
  }
  function Ht$1(t10, e10, n10) {
    if (ur && hn$1) {
      let r10 = yo.get(t10);
      r10 || yo.set(t10, r10 = /* @__PURE__ */ new Map());
      let s10 = r10.get(n10);
      s10 || r10.set(n10, s10 = vl()), Gu(s10);
    }
  }
  function Gu(t10, e10) {
    let n10 = false;
    Ks <= Co ? Vu(t10) || (t10.n |= pr, n10 = !Uu(t10)) : n10 = !t10.has(hn$1), n10 && (t10.add(hn$1), hn$1.deps.push(t10));
  }
  function kn(t10, e10, n10, r10, s10, i10) {
    const o10 = yo.get(t10);
    if (!o10)
      return;
    let l10 = [];
    if (e10 === "clear")
      l10 = [...o10.values()];
    else if (n10 === "length" && K$1(t10)) {
      const a10 = An$1(r10);
      o10.forEach((c10, u10) => {
        (u10 === "length" || u10 >= a10) && l10.push(c10);
      });
    } else
      switch (n10 !== void 0 && l10.push(o10.get(n10)), e10) {
        case "add":
          K$1(t10) ? yl(n10) && l10.push(o10.get("length")) : (l10.push(o10.get(Ir)), is(t10) && l10.push(o10.get(vo)));
          break;
        case "delete":
          K$1(t10) || (l10.push(o10.get(Ir)), is(t10) && l10.push(o10.get(vo)));
          break;
        case "set":
          is(t10) && l10.push(o10.get(Ir));
          break;
      }
    if (l10.length === 1)
      l10[0] && bo(l10[0]);
    else {
      const a10 = [];
      for (const c10 of l10)
        c10 && a10.push(...c10);
      bo(vl(a10));
    }
  }
  function bo(t10, e10) {
    const n10 = K$1(t10) ? t10 : [...t10];
    for (const r10 of n10)
      r10.computed && Nc(r10);
    for (const r10 of n10)
      r10.computed || Nc(r10);
  }
  function Nc(t10, e10) {
    (t10 !== hn$1 || t10.allowRecurse) && (t10.scheduler ? t10.scheduler() : t10.run());
  }
  const u8 = /* @__PURE__ */ ws("__proto__,__v_isRef,__isVue"), ju = new Set(
    /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((t10) => t10 !== "arguments" && t10 !== "caller").map((t10) => Symbol[t10]).filter(u0)
  ), h8 = /* @__PURE__ */ Xi(), d8 = /* @__PURE__ */ Xi(false, true), f8 = /* @__PURE__ */ Xi(true), p8 = /* @__PURE__ */ Xi(true, true), Pc = /* @__PURE__ */ g8();
  function g8() {
    const t10 = {};
    return ["includes", "indexOf", "lastIndexOf"].forEach((e10) => {
      t10[e10] = function(...n10) {
        const r10 = we$1(this);
        for (let i10 = 0, o10 = this.length; i10 < o10; i10++)
          Ht$1(r10, "get", i10 + "");
        const s10 = r10[e10](...n10);
        return s10 === -1 || s10 === false ? r10[e10](...n10.map(we$1)) : s10;
      };
    }), ["push", "pop", "shift", "unshift", "splice"].forEach((e10) => {
      t10[e10] = function(...n10) {
        Es();
        const r10 = we$1(this)[e10].apply(this, n10);
        return Ts(), r10;
      };
    }), t10;
  }
  function Xi(t10 = false, e10 = false) {
    return function(r10, s10, i10) {
      if (s10 === "__v_isReactive")
        return !t10;
      if (s10 === "__v_isReadonly")
        return t10;
      if (s10 === "__v_isShallow")
        return e10;
      if (s10 === "__v_raw" && i10 === (t10 ? e10 ? Qu : Xu : e10 ? Yu : Ku).get(r10))
        return r10;
      const o10 = K$1(r10);
      if (!t10 && o10 && Me(Pc, s10))
        return Reflect.get(Pc, s10, i10);
      const l10 = Reflect.get(r10, s10, i10);
      return (u0(s10) ? ju.has(s10) : u8(s10)) || (t10 || Ht$1(r10, "get", s10), e10) ? l10 : gt(l10) ? o10 && yl(s10) ? l10 : l10.value : Se(l10) ? t10 ? wl(l10) : Rn$1(l10) : l10;
    };
  }
  const m8 = /* @__PURE__ */ Zu(), x8 = /* @__PURE__ */ Zu(true);
  function Zu(t10 = false) {
    return function(n10, r10, s10, i10) {
      let o10 = n10[r10];
      if ($r(o10) && gt(o10) && !gt(s10))
        return false;
      if (!t10 && (!h0(s10) && !$r(s10) && (o10 = we$1(o10), s10 = we$1(s10)), !K$1(n10) && gt(o10) && !gt(s10)))
        return o10.value = s10, true;
      const l10 = K$1(n10) && yl(r10) ? Number(r10) < n10.length : Me(n10, r10), a10 = Reflect.set(n10, r10, s10, i10);
      return n10 === we$1(i10) && (l10 ? ms(s10, o10) && kn(n10, "set", r10, s10) : kn(n10, "add", r10, s10)), a10;
    };
  }
  function L8(t10, e10) {
    const n10 = Me(t10, e10);
    t10[e10];
    const r10 = Reflect.deleteProperty(t10, e10);
    return r10 && n10 && kn(t10, "delete", e10, void 0), r10;
  }
  function _8(t10, e10) {
    const n10 = Reflect.has(t10, e10);
    return (!u0(e10) || !ju.has(e10)) && Ht$1(t10, "has", e10), n10;
  }
  function y8(t10) {
    return Ht$1(t10, "iterate", K$1(t10) ? "length" : Ir), Reflect.ownKeys(t10);
  }
  const Wu = {
    get: h8,
    set: m8,
    deleteProperty: L8,
    has: _8,
    ownKeys: y8
  }, qu = {
    get: f8,
    set(t10, e10) {
      return true;
    },
    deleteProperty(t10, e10) {
      return true;
    }
  }, C8 = /* @__PURE__ */ Oe$1({}, Wu, {
    get: d8,
    set: x8
  }), v8 = /* @__PURE__ */ Oe$1({}, qu, {
    get: p8
  }), bl = (t10) => t10, Qi = (t10) => Reflect.getPrototypeOf(t10);
  function Q0(t10, e10, n10 = false, r10 = false) {
    t10 = t10.__v_raw;
    const s10 = we$1(t10), i10 = we$1(e10);
    n10 || (e10 !== i10 && Ht$1(s10, "get", e10), Ht$1(s10, "get", i10));
    const { has: o10 } = Qi(s10), l10 = r10 ? bl : n10 ? Sl : d0;
    if (o10.call(s10, e10))
      return l10(t10.get(e10));
    if (o10.call(s10, i10))
      return l10(t10.get(i10));
    t10 !== s10 && t10.get(e10);
  }
  function J0(t10, e10 = false) {
    const n10 = this.__v_raw, r10 = we$1(n10), s10 = we$1(t10);
    return e10 || (t10 !== s10 && Ht$1(r10, "has", t10), Ht$1(r10, "has", s10)), t10 === s10 ? n10.has(t10) : n10.has(t10) || n10.has(s10);
  }
  function ei(t10, e10 = false) {
    return t10 = t10.__v_raw, !e10 && Ht$1(we$1(t10), "iterate", Ir), Reflect.get(t10, "size", t10);
  }
  function Fc(t10) {
    t10 = we$1(t10);
    const e10 = we$1(this);
    return Qi(e10).has.call(e10, t10) || (e10.add(t10), kn(e10, "add", t10, t10)), this;
  }
  function Dc(t10, e10) {
    e10 = we$1(e10);
    const n10 = we$1(this), { has: r10, get: s10 } = Qi(n10);
    let i10 = r10.call(n10, t10);
    i10 || (t10 = we$1(t10), i10 = r10.call(n10, t10));
    const o10 = s10.call(n10, t10);
    return n10.set(t10, e10), i10 ? ms(e10, o10) && kn(n10, "set", t10, e10) : kn(n10, "add", t10, e10), this;
  }
  function Bc(t10) {
    const e10 = we$1(this), { has: n10, get: r10 } = Qi(e10);
    let s10 = n10.call(e10, t10);
    s10 || (t10 = we$1(t10), s10 = n10.call(e10, t10)), r10 && r10.call(e10, t10);
    const i10 = e10.delete(t10);
    return s10 && kn(e10, "delete", t10, void 0), i10;
  }
  function $c() {
    const t10 = we$1(this), e10 = t10.size !== 0, n10 = t10.clear();
    return e10 && kn(t10, "clear", void 0, void 0), n10;
  }
  function ti(t10, e10) {
    return function(r10, s10) {
      const i10 = this, o10 = i10.__v_raw, l10 = we$1(o10), a10 = e10 ? bl : t10 ? Sl : d0;
      return !t10 && Ht$1(l10, "iterate", Ir), o10.forEach((c10, u10) => r10.call(s10, a10(c10), a10(u10), i10));
    };
  }
  function ni(t10, e10, n10) {
    return function(...r10) {
      const s10 = this.__v_raw, i10 = we$1(s10), o10 = is(i10), l10 = t10 === "entries" || t10 === Symbol.iterator && o10, a10 = t10 === "keys" && o10, c10 = s10[t10](...r10), u10 = n10 ? bl : e10 ? Sl : d0;
      return !e10 && Ht$1(i10, "iterate", a10 ? vo : Ir), {
        next() {
          const { value: h10, done: d10 } = c10.next();
          return d10 ? { value: h10, done: d10 } : {
            value: l10 ? [u10(h10[0]), u10(h10[1])] : u10(h10),
            done: d10
          };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function Jn(t10) {
    return function(...e10) {
      return t10 === "delete" ? false : this;
    };
  }
  function b8() {
    const t10 = {
      get(i10) {
        return Q0(this, i10);
      },
      get size() {
        return ei(this);
      },
      has: J0,
      add: Fc,
      set: Dc,
      delete: Bc,
      clear: $c,
      forEach: ti(false, false)
    }, e10 = {
      get(i10) {
        return Q0(this, i10, false, true);
      },
      get size() {
        return ei(this);
      },
      has: J0,
      add: Fc,
      set: Dc,
      delete: Bc,
      clear: $c,
      forEach: ti(false, true)
    }, n10 = {
      get(i10) {
        return Q0(this, i10, true);
      },
      get size() {
        return ei(this, true);
      },
      has(i10) {
        return J0.call(this, i10, true);
      },
      add: Jn("add"),
      set: Jn("set"),
      delete: Jn("delete"),
      clear: Jn("clear"),
      forEach: ti(true, false)
    }, r10 = {
      get(i10) {
        return Q0(this, i10, true, true);
      },
      get size() {
        return ei(this, true);
      },
      has(i10) {
        return J0.call(this, i10, true);
      },
      add: Jn("add"),
      set: Jn("set"),
      delete: Jn("delete"),
      clear: Jn("clear"),
      forEach: ti(true, true)
    };
    return ["keys", "values", "entries", Symbol.iterator].forEach((i10) => {
      t10[i10] = ni(i10, false, false), n10[i10] = ni(i10, true, false), e10[i10] = ni(i10, false, true), r10[i10] = ni(i10, true, true);
    }), [
      t10,
      n10,
      e10,
      r10
    ];
  }
  const [w8, E8, T8, S8] = /* @__PURE__ */ b8();
  function Ji(t10, e10) {
    const n10 = e10 ? t10 ? S8 : T8 : t10 ? E8 : w8;
    return (r10, s10, i10) => s10 === "__v_isReactive" ? !t10 : s10 === "__v_isReadonly" ? t10 : s10 === "__v_raw" ? r10 : Reflect.get(Me(n10, s10) && s10 in r10 ? n10 : r10, s10, i10);
  }
  const A8 = {
    get: /* @__PURE__ */ Ji(false, false)
  }, k8 = {
    get: /* @__PURE__ */ Ji(false, true)
  }, R8 = {
    get: /* @__PURE__ */ Ji(true, false)
  }, O8 = {
    get: /* @__PURE__ */ Ji(true, true)
  }, Ku = /* @__PURE__ */ new WeakMap(), Yu = /* @__PURE__ */ new WeakMap(), Xu = /* @__PURE__ */ new WeakMap(), Qu = /* @__PURE__ */ new WeakMap();
  function I8(t10) {
    switch (t10) {
      case "Object":
      case "Array":
        return 1;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2;
      default:
        return 0;
    }
  }
  function M8(t10) {
    return t10.__v_skip || !Object.isExtensible(t10) ? 0 : I8(e8(t10));
  }
  function Rn$1(t10) {
    return $r(t10) ? t10 : e1(t10, false, Wu, A8, Ku);
  }
  function Ju(t10) {
    return e1(t10, false, C8, k8, Yu);
  }
  function wl(t10) {
    return e1(t10, true, qu, R8, Xu);
  }
  function N8(t10) {
    return e1(t10, true, v8, O8, Qu);
  }
  function e1(t10, e10, n10, r10, s10) {
    if (!Se(t10) || t10.__v_raw && !(e10 && t10.__v_isReactive))
      return t10;
    const i10 = s10.get(t10);
    if (i10)
      return i10;
    const o10 = M8(t10);
    if (o10 === 0)
      return t10;
    const l10 = new Proxy(t10, o10 === 2 ? r10 : n10);
    return s10.set(t10, l10), l10;
  }
  function Un(t10) {
    return $r(t10) ? Un(t10.__v_raw) : !!(t10 && t10.__v_isReactive);
  }
  function $r(t10) {
    return !!(t10 && t10.__v_isReadonly);
  }
  function h0(t10) {
    return !!(t10 && t10.__v_isShallow);
  }
  function El(t10) {
    return Un(t10) || $r(t10);
  }
  function we$1(t10) {
    const e10 = t10 && t10.__v_raw;
    return e10 ? we$1(e10) : t10;
  }
  function Tl(t10) {
    return Ti(t10, "__v_skip", true), t10;
  }
  const d0 = (t10) => Se(t10) ? Rn$1(t10) : t10, Sl = (t10) => Se(t10) ? wl(t10) : t10;
  function Al(t10) {
    ur && hn$1 && (t10 = we$1(t10), Gu(t10.dep || (t10.dep = vl())));
  }
  function t1(t10, e10) {
    t10 = we$1(t10), t10.dep && bo(t10.dep);
  }
  function gt(t10) {
    return !!(t10 && t10.__v_isRef === true);
  }
  function ge(t10) {
    return t3(t10, false);
  }
  function e3(t10) {
    return t3(t10, true);
  }
  function t3(t10, e10) {
    return gt(t10) ? t10 : new P8(t10, e10);
  }
  class P8 {
    constructor(e10, n10) {
      this.__v_isShallow = n10, this.dep = void 0, this.__v_isRef = true, this._rawValue = n10 ? e10 : we$1(e10), this._value = n10 ? e10 : d0(e10);
    }
    get value() {
      return Al(this), this._value;
    }
    set value(e10) {
      const n10 = this.__v_isShallow || h0(e10) || $r(e10);
      e10 = n10 ? e10 : we$1(e10), ms(e10, this._rawValue) && (this._rawValue = e10, this._value = n10 ? e10 : d0(e10), t1(this));
    }
  }
  function F8(t10) {
    t1(t10);
  }
  function _e(t10) {
    return gt(t10) ? t10.value : t10;
  }
  const D8 = {
    get: (t10, e10, n10) => _e(Reflect.get(t10, e10, n10)),
    set: (t10, e10, n10, r10) => {
      const s10 = t10[e10];
      return gt(s10) && !gt(n10) ? (s10.value = n10, true) : Reflect.set(t10, e10, n10, r10);
    }
  };
  function kl(t10) {
    return Un(t10) ? t10 : new Proxy(t10, D8);
  }
  class B8 {
    constructor(e10) {
      this.dep = void 0, this.__v_isRef = true;
      const { get: n10, set: r10 } = e10(() => Al(this), () => t1(this));
      this._get = n10, this._set = r10;
    }
    get value() {
      return this._get();
    }
    set value(e10) {
      this._set(e10);
    }
  }
  function $8(t10) {
    return new B8(t10);
  }
  function Rl(t10) {
    const e10 = K$1(t10) ? new Array(t10.length) : {};
    for (const n10 in t10)
      e10[n10] = n3(t10, n10);
    return e10;
  }
  class H8 {
    constructor(e10, n10, r10) {
      this._object = e10, this._key = n10, this._defaultValue = r10, this.__v_isRef = true;
    }
    get value() {
      const e10 = this._object[this._key];
      return e10 === void 0 ? this._defaultValue : e10;
    }
    set value(e10) {
      this._object[this._key] = e10;
    }
  }
  function n3(t10, e10, n10) {
    const r10 = t10[e10];
    return gt(r10) ? r10 : new H8(t10, e10, n10);
  }
  var r3;
  class U8 {
    constructor(e10, n10, r10, s10) {
      this._setter = n10, this.dep = void 0, this.__v_isRef = true, this[r3] = false, this._dirty = true, this.effect = new S0(e10, () => {
        this._dirty || (this._dirty = true, t1(this));
      }), this.effect.computed = this, this.effect.active = this._cacheable = !s10, this.__v_isReadonly = r10;
    }
    get value() {
      const e10 = we$1(this);
      return Al(e10), (e10._dirty || !e10._cacheable) && (e10._dirty = false, e10._value = e10.effect.run()), e10._value;
    }
    set value(e10) {
      this._setter(e10);
    }
  }
  r3 = "__v_isReadonly";
  function V8(t10, e10, n10 = false) {
    let r10, s10;
    const i10 = ue$1(t10);
    return i10 ? (r10 = t10, s10 = Bt$1) : (r10 = t10.get, s10 = t10.set), new U8(r10, s10, i10 || !s10, n10);
  }
  function z8(t10, ...e10) {
  }
  function En$1(t10, e10, n10, r10) {
    let s10;
    try {
      s10 = r10 ? t10(...r10) : t10();
    } catch (i10) {
      jr(i10, e10, n10);
    }
    return s10;
  }
  function $t$1(t10, e10, n10, r10) {
    if (ue$1(t10)) {
      const i10 = En$1(t10, e10, n10, r10);
      return i10 && Ki(i10) && i10.catch((o10) => {
        jr(o10, e10, n10);
      }), i10;
    }
    const s10 = [];
    for (let i10 = 0; i10 < t10.length; i10++)
      s10.push($t$1(t10[i10], e10, n10, r10));
    return s10;
  }
  function jr(t10, e10, n10, r10 = true) {
    const s10 = e10 ? e10.vnode : null;
    if (e10) {
      let i10 = e10.parent;
      const o10 = e10.proxy, l10 = n10;
      for (; i10; ) {
        const c10 = i10.ec;
        if (c10) {
          for (let u10 = 0; u10 < c10.length; u10++)
            if (c10[u10](t10, o10, l10) === false)
              return;
        }
        i10 = i10.parent;
      }
      const a10 = e10.appContext.config.errorHandler;
      if (a10) {
        En$1(a10, null, 10, [t10, o10, l10]);
        return;
      }
    }
    G8(t10, n10, s10, r10);
  }
  function G8(t10, e10, n10, r10 = true) {
    console.error(t10);
  }
  let f0 = false, wo = false;
  const vt = [];
  let Cn$1 = 0;
  const as = [];
  let $n = null, Tr = 0;
  const s3 = /* @__PURE__ */ Promise.resolve();
  let Ol = null;
  function gr(t10) {
    const e10 = Ol || s3;
    return t10 ? e10.then(this ? t10.bind(this) : t10) : e10;
  }
  function j8(t10) {
    let e10 = Cn$1 + 1, n10 = vt.length;
    for (; e10 < n10; ) {
      const r10 = e10 + n10 >>> 1;
      p0(vt[r10]) < t10 ? e10 = r10 + 1 : n10 = r10;
    }
    return e10;
  }
  function n1(t10) {
    (!vt.length || !vt.includes(t10, f0 && t10.allowRecurse ? Cn$1 + 1 : Cn$1)) && (t10.id == null ? vt.push(t10) : vt.splice(j8(t10.id), 0, t10), i3());
  }
  function i3() {
    !f0 && !wo && (wo = true, Ol = s3.then(o3));
  }
  function Z8(t10) {
    const e10 = vt.indexOf(t10);
    e10 > Cn$1 && vt.splice(e10, 1);
  }
  function Il(t10) {
    K$1(t10) ? as.push(...t10) : (!$n || !$n.includes(t10, t10.allowRecurse ? Tr + 1 : Tr)) && as.push(t10), i3();
  }
  function Hc(t10, e10 = f0 ? Cn$1 + 1 : 0) {
    for (; e10 < vt.length; e10++) {
      const n10 = vt[e10];
      n10 && n10.pre && (vt.splice(e10, 1), e10--, n10());
    }
  }
  function Si(t10) {
    if (as.length) {
      const e10 = [...new Set(as)];
      if (as.length = 0, $n) {
        $n.push(...e10);
        return;
      }
      for ($n = e10, $n.sort((n10, r10) => p0(n10) - p0(r10)), Tr = 0; Tr < $n.length; Tr++)
        $n[Tr]();
      $n = null, Tr = 0;
    }
  }
  const p0 = (t10) => t10.id == null ? 1 / 0 : t10.id, W8 = (t10, e10) => {
    const n10 = p0(t10) - p0(e10);
    if (n10 === 0) {
      if (t10.pre && !e10.pre)
        return -1;
      if (e10.pre && !t10.pre)
        return 1;
    }
    return n10;
  };
  function o3(t10) {
    wo = false, f0 = true, vt.sort(W8);
    try {
      for (Cn$1 = 0; Cn$1 < vt.length; Cn$1++) {
        const n10 = vt[Cn$1];
        n10 && n10.active !== false && En$1(n10, null, 14);
      }
    } finally {
      Cn$1 = 0, vt.length = 0, Si(), f0 = false, Ol = null, (vt.length || as.length) && o3();
    }
  }
  let ns, ri = [];
  function l3(t10, e10) {
    var n10, r10;
    ns = t10, ns ? (ns.enabled = true, ri.forEach(({ event: s10, args: i10 }) => ns.emit(s10, ...i10)), ri = []) : typeof window < "u" && window.HTMLElement && !(!((r10 = (n10 = window.navigator) === null || n10 === void 0 ? void 0 : n10.userAgent) === null || r10 === void 0) && r10.includes("jsdom")) ? ((e10.__VUE_DEVTOOLS_HOOK_REPLAY__ = e10.__VUE_DEVTOOLS_HOOK_REPLAY__ || []).push((i10) => {
      l3(i10, e10);
    }), setTimeout(() => {
      ns || (e10.__VUE_DEVTOOLS_HOOK_REPLAY__ = null, ri = []);
    }, 3e3)) : ri = [];
  }
  function q8(t10, e10, ...n10) {
  }
  const Ml = {
    MODE: 2
  };
  function K8(t10) {
    Oe$1(Ml, t10);
  }
  function Uc(t10, e10) {
    const n10 = e10 && e10.type.compatConfig;
    return n10 && t10 in n10 ? n10[t10] : Ml[t10];
  }
  function Ue$1(t10, e10, n10 = false) {
    if (!n10 && e10 && e10.type.__isBuiltIn)
      return false;
    const r10 = Uc("MODE", e10) || 2, s10 = Uc(t10, e10);
    return (ue$1(r10) ? r10(e10 && e10.type) : r10) === 2 ? s10 !== false : s10 === true || s10 === "suppress-warning";
  }
  function _t$1(t10, e10, ...n10) {
    if (!Ue$1(t10, e10))
      throw new Error(`${t10} compat has been disabled.`);
  }
  function Zn(t10, e10, ...n10) {
    return Ue$1(t10, e10);
  }
  function r1(t10, e10, ...n10) {
    return Ue$1(t10, e10);
  }
  const Eo = /* @__PURE__ */ new WeakMap();
  function Nl(t10) {
    let e10 = Eo.get(t10);
    return e10 || Eo.set(t10, e10 = /* @__PURE__ */ Object.create(null)), e10;
  }
  function Pl(t10, e10, n10) {
    if (K$1(e10))
      e10.forEach((r10) => Pl(t10, r10, n10));
    else {
      e10.startsWith("hook:") ? _t$1("INSTANCE_EVENT_HOOKS", t10, e10) : _t$1("INSTANCE_EVENT_EMITTER", t10);
      const r10 = Nl(t10);
      (r10[e10] || (r10[e10] = [])).push(n10);
    }
    return t10.proxy;
  }
  function Y8(t10, e10, n10) {
    const r10 = (...s10) => {
      Fl(t10, e10, r10), n10.call(t10.proxy, ...s10);
    };
    return r10.fn = n10, Pl(t10, e10, r10), t10.proxy;
  }
  function Fl(t10, e10, n10) {
    _t$1("INSTANCE_EVENT_EMITTER", t10);
    const r10 = t10.proxy;
    if (!e10)
      return Eo.set(t10, /* @__PURE__ */ Object.create(null)), r10;
    if (K$1(e10))
      return e10.forEach((o10) => Fl(t10, o10, n10)), r10;
    const s10 = Nl(t10), i10 = s10[e10];
    return i10 ? n10 ? (s10[e10] = i10.filter((o10) => !(o10 === n10 || o10.fn === n10)), r10) : (s10[e10] = void 0, r10) : r10;
  }
  function X8(t10, e10, n10) {
    const r10 = Nl(t10)[e10];
    return r10 && $t$1(r10.map((s10) => s10.bind(t10.proxy)), t10, 6, n10), t10.proxy;
  }
  const s1 = "onModelCompat:";
  function Q8(t10) {
    const { type: e10, shapeFlag: n10, props: r10, dynamicProps: s10 } = t10, i10 = e10;
    if (n10 & 6 && r10 && "modelValue" in r10) {
      if (!Ue$1(
        "COMPONENT_V_MODEL",
        { type: e10 }
      ))
        return;
      const o10 = i10.model || {};
      a3(o10, i10.mixins);
      const { prop: l10 = "value", event: a10 = "input" } = o10;
      l10 !== "modelValue" && (r10[l10] = r10.modelValue, delete r10.modelValue), s10 && (s10[s10.indexOf("modelValue")] = l10), r10[s1 + a10] = r10["onUpdate:modelValue"], delete r10["onUpdate:modelValue"];
    }
  }
  function a3(t10, e10) {
    e10 && e10.forEach((n10) => {
      n10.model && Oe$1(t10, n10.model), n10.mixins && a3(t10, n10.mixins);
    });
  }
  function J8(t10, e10, n10) {
    if (!Ue$1("COMPONENT_V_MODEL", t10))
      return;
    const r10 = t10.vnode.props, s10 = r10 && r10[s1 + e10];
    s10 && En$1(s10, t10, 6, n10);
  }
  function ed(t10, e10, ...n10) {
    if (t10.isUnmounted)
      return;
    const r10 = t10.vnode.props || Ge$1;
    let s10 = n10;
    const i10 = e10.startsWith("update:"), o10 = i10 && e10.slice(7);
    if (o10 && o10 in r10) {
      const u10 = `${o10 === "modelValue" ? "model" : o10}Modifiers`, { number: h10, trim: d10 } = r10[u10] || Ge$1;
      d10 && (s10 = n10.map((p10) => Ke$1(p10) ? p10.trim() : p10)), h10 && (s10 = n10.map(An$1));
    }
    let l10, a10 = r10[l10 = ls(e10)] || r10[l10 = ls(Rt$1(e10))];
    !a10 && i10 && (a10 = r10[l10 = ls(St$1(e10))]), a10 && $t$1(a10, t10, 6, s10);
    const c10 = r10[l10 + "Once"];
    if (c10) {
      if (!t10.emitted)
        t10.emitted = {};
      else if (t10.emitted[l10])
        return;
      t10.emitted[l10] = true, $t$1(c10, t10, 6, s10);
    }
    return J8(t10, e10, s10), X8(t10, e10, s10);
  }
  function c3(t10, e10, n10 = false) {
    const r10 = e10.emitsCache, s10 = r10.get(t10);
    if (s10 !== void 0)
      return s10;
    const i10 = t10.emits;
    let o10 = {}, l10 = false;
    if (!ue$1(t10)) {
      const a10 = (c10) => {
        const u10 = c3(c10, e10, true);
        u10 && (l10 = true, Oe$1(o10, u10));
      };
      !n10 && e10.mixins.length && e10.mixins.forEach(a10), t10.extends && a10(t10.extends), t10.mixins && t10.mixins.forEach(a10);
    }
    return !i10 && !l10 ? (Se(t10) && r10.set(t10, null), null) : (K$1(i10) ? i10.forEach((a10) => o10[a10] = null) : Oe$1(o10, i10), Se(t10) && r10.set(t10, o10), o10);
  }
  function i1(t10, e10) {
    return !t10 || !Yn(e10) ? false : e10.startsWith(s1) ? true : (e10 = e10.slice(2).replace(/Once$/, ""), Me(t10, e10[0].toLowerCase() + e10.slice(1)) || Me(t10, St$1(e10)) || Me(t10, e10));
  }
  let ut = null, cs = null;
  function g0(t10) {
    const e10 = ut;
    return ut = t10, cs = t10 && t10.type.__scopeId || null, cs || (cs = t10 && t10.type._scopeId || null), e10;
  }
  function Ss(t10) {
    cs = t10;
  }
  function As() {
    cs = null;
  }
  const td = (t10) => jt$1;
  function jt$1(t10, e10 = ut, n10) {
    if (!e10 || t10._n)
      return t10;
    const r10 = (...s10) => {
      r10._d && Io(-1);
      const i10 = g0(e10);
      let o10;
      try {
        o10 = t10(...s10);
      } finally {
        g0(i10), r10._d && Io(1);
      }
      return o10;
    };
    return r10._n = true, r10._c = true, r10._d = true, n10 && (r10._ns = true), r10;
  }
  function yi(t10) {
    const { type: e10, vnode: n10, proxy: r10, withProxy: s10, props: i10, propsOptions: [o10], slots: l10, attrs: a10, emit: c10, render: u10, renderCache: h10, data: d10, setupState: p10, ctx: g, inheritAttrs: L } = t10;
    let T, _10;
    const x = g0(t10);
    try {
      if (n10.shapeFlag & 4) {
        const E = s10 || r10;
        T = Wt$1(u10.call(E, E, h10, i10, p10, d10, g)), _10 = a10;
      } else {
        const E = e10;
        T = Wt$1(E.length > 1 ? E(i10, { attrs: a10, slots: l10, emit: c10 }) : E(i10, null)), _10 = e10.props ? a10 : rd(a10);
      }
    } catch (E) {
      Js.length = 0, jr(E, t10, 1), T = V$1(yt);
    }
    let C = T;
    if (_10 && L !== false) {
      const E = Object.keys(_10), { shapeFlag: M10 } = C;
      E.length && M10 & 7 && (o10 && E.some(Ll) && (_10 = sd(_10, o10)), C = an$1(C, _10));
    }
    if (Ue$1("INSTANCE_ATTRS_CLASS_STYLE", t10) && n10.shapeFlag & 4 && C.shapeFlag & 7) {
      const { class: E, style: M10 } = n10.props || {};
      (E || M10) && (C = an$1(C, {
        class: E,
        style: M10
      }));
    }
    return n10.dirs && (C = an$1(C), C.dirs = C.dirs ? C.dirs.concat(n10.dirs) : n10.dirs), n10.transition && (C.transition = n10.transition), T = C, g0(x), T;
  }
  function nd(t10) {
    let e10;
    for (let n10 = 0; n10 < t10.length; n10++) {
      const r10 = t10[n10];
      if (Jt$1(r10)) {
        if (r10.type !== yt || r10.children === "v-if") {
          if (e10)
            return;
          e10 = r10;
        }
      } else
        return;
    }
    return e10;
  }
  const rd = (t10) => {
    let e10;
    for (const n10 in t10)
      (n10 === "class" || n10 === "style" || Yn(n10)) && ((e10 || (e10 = {}))[n10] = t10[n10]);
    return e10;
  }, sd = (t10, e10) => {
    const n10 = {};
    for (const r10 in t10)
      (!Ll(r10) || !(r10.slice(9) in e10)) && (n10[r10] = t10[r10]);
    return n10;
  };
  function id(t10, e10, n10) {
    const { props: r10, children: s10, component: i10 } = t10, { props: o10, children: l10, patchFlag: a10 } = e10, c10 = i10.emitsOptions;
    if (e10.dirs || e10.transition)
      return true;
    if (n10 && a10 >= 0) {
      if (a10 & 1024)
        return true;
      if (a10 & 16)
        return r10 ? Vc(r10, o10, c10) : !!o10;
      if (a10 & 8) {
        const u10 = e10.dynamicProps;
        for (let h10 = 0; h10 < u10.length; h10++) {
          const d10 = u10[h10];
          if (o10[d10] !== r10[d10] && !i1(c10, d10))
            return true;
        }
      }
    } else
      return (s10 || l10) && (!l10 || !l10.$stable) ? true : r10 === o10 ? false : r10 ? o10 ? Vc(r10, o10, c10) : true : !!o10;
    return false;
  }
  function Vc(t10, e10, n10) {
    const r10 = Object.keys(e10);
    if (r10.length !== Object.keys(t10).length)
      return true;
    for (let s10 = 0; s10 < r10.length; s10++) {
      const i10 = r10[s10];
      if (e10[i10] !== t10[i10] && !i1(n10, i10))
        return true;
    }
    return false;
  }
  function Dl({ vnode: t10, parent: e10 }, n10) {
    for (; e10 && e10.subTree === t10; )
      (t10 = e10.vnode).el = n10, e10 = e10.parent;
  }
  const u3 = (t10) => t10.__isSuspense, od = {
    name: "Suspense",
    __isSuspense: true,
    process(t10, e10, n10, r10, s10, i10, o10, l10, a10, c10) {
      t10 == null ? ad(e10, n10, r10, s10, i10, o10, l10, a10, c10) : cd(t10, e10, n10, r10, s10, o10, l10, a10, c10);
    },
    hydrate: ud,
    create: Bl,
    normalize: hd
  }, ld = od;
  function m0(t10, e10) {
    const n10 = t10.props && t10.props[e10];
    ue$1(n10) && n10();
  }
  function ad(t10, e10, n10, r10, s10, i10, o10, l10, a10) {
    const { p: c10, o: { createElement: u10 } } = a10, h10 = u10("div"), d10 = t10.suspense = Bl(t10, s10, r10, e10, h10, n10, i10, o10, l10, a10);
    c10(null, d10.pendingBranch = t10.ssContent, h10, null, r10, d10, i10, o10), d10.deps > 0 ? (m0(t10, "onPending"), m0(t10, "onFallback"), c10(
      null,
      t10.ssFallback,
      e10,
      n10,
      r10,
      null,
      i10,
      o10
    ), us(d10, t10.ssFallback)) : d10.resolve();
  }
  function cd(t10, e10, n10, r10, s10, i10, o10, l10, { p: a10, um: c10, o: { createElement: u10 } }) {
    const h10 = e10.suspense = t10.suspense;
    h10.vnode = e10, e10.el = t10.el;
    const d10 = e10.ssContent, p10 = e10.ssFallback, { activeBranch: g, pendingBranch: L, isInFallback: T, isHydrating: _10 } = h10;
    if (L)
      h10.pendingBranch = d10, vn$1(d10, L) ? (a10(L, d10, h10.hiddenContainer, null, s10, h10, i10, o10, l10), h10.deps <= 0 ? h10.resolve() : T && (a10(
        g,
        p10,
        n10,
        r10,
        s10,
        null,
        i10,
        o10,
        l10
      ), us(h10, p10))) : (h10.pendingId++, _10 ? (h10.isHydrating = false, h10.activeBranch = L) : c10(L, s10, h10), h10.deps = 0, h10.effects.length = 0, h10.hiddenContainer = u10("div"), T ? (a10(null, d10, h10.hiddenContainer, null, s10, h10, i10, o10, l10), h10.deps <= 0 ? h10.resolve() : (a10(
        g,
        p10,
        n10,
        r10,
        s10,
        null,
        i10,
        o10,
        l10
      ), us(h10, p10))) : g && vn$1(d10, g) ? (a10(g, d10, n10, r10, s10, h10, i10, o10, l10), h10.resolve(true)) : (a10(null, d10, h10.hiddenContainer, null, s10, h10, i10, o10, l10), h10.deps <= 0 && h10.resolve()));
    else if (g && vn$1(d10, g))
      a10(g, d10, n10, r10, s10, h10, i10, o10, l10), us(h10, d10);
    else if (m0(e10, "onPending"), h10.pendingBranch = d10, h10.pendingId++, a10(null, d10, h10.hiddenContainer, null, s10, h10, i10, o10, l10), h10.deps <= 0)
      h10.resolve();
    else {
      const { timeout: x, pendingId: C } = h10;
      x > 0 ? setTimeout(() => {
        h10.pendingId === C && h10.fallback(p10);
      }, x) : x === 0 && h10.fallback(p10);
    }
  }
  function Bl(t10, e10, n10, r10, s10, i10, o10, l10, a10, c10, u10 = false) {
    const { p: h10, m: d10, um: p10, n: g, o: { parentNode: L, remove: T } } = c10, _10 = An$1(t10.props && t10.props.timeout), x = {
      vnode: t10,
      parent: e10,
      parentComponent: n10,
      isSVG: o10,
      container: r10,
      hiddenContainer: s10,
      anchor: i10,
      deps: 0,
      pendingId: 0,
      timeout: typeof _10 == "number" ? _10 : -1,
      activeBranch: null,
      pendingBranch: null,
      isInFallback: true,
      isHydrating: u10,
      isUnmounted: false,
      effects: [],
      resolve(C = false) {
        const { vnode: E, activeBranch: M10, pendingBranch: $, pendingId: j, effects: R, parentComponent: ae2, container: le2 } = x;
        if (x.isHydrating)
          x.isHydrating = false;
        else if (!C) {
          const Le2 = M10 && $.transition && $.transition.mode === "out-in";
          Le2 && (M10.transition.afterLeave = () => {
            j === x.pendingId && d10($, le2, re2, 0);
          });
          let { anchor: re2 } = x;
          M10 && (re2 = g(M10), p10(M10, ae2, x, true)), Le2 || d10($, le2, re2, 0);
        }
        us(x, $), x.pendingBranch = null, x.isInFallback = false;
        let he = x.parent, He2 = false;
        for (; he; ) {
          if (he.pendingBranch) {
            he.effects.push(...R), He2 = true;
            break;
          }
          he = he.parent;
        }
        He2 || Il(R), x.effects = [], m0(E, "onResolve");
      },
      fallback(C) {
        if (!x.pendingBranch)
          return;
        const { vnode: E, activeBranch: M10, parentComponent: $, container: j, isSVG: R } = x;
        m0(E, "onFallback");
        const ae2 = g(M10), le2 = () => {
          !x.isInFallback || (h10(
            null,
            C,
            j,
            ae2,
            $,
            null,
            R,
            l10,
            a10
          ), us(x, C));
        }, he = C.transition && C.transition.mode === "out-in";
        he && (M10.transition.afterLeave = le2), x.isInFallback = true, p10(
          M10,
          $,
          null,
          true
        ), he || le2();
      },
      move(C, E, M10) {
        x.activeBranch && d10(x.activeBranch, C, E, M10), x.container = C;
      },
      next() {
        return x.activeBranch && g(x.activeBranch);
      },
      registerDep(C, E) {
        const M10 = !!x.pendingBranch;
        M10 && x.deps++;
        const $ = C.vnode.el;
        C.asyncDep.catch((j) => {
          jr(j, C, 0);
        }).then((j) => {
          if (C.isUnmounted || x.isUnmounted || x.pendingId !== C.suspenseId)
            return;
          C.asyncResolved = true;
          const { vnode: R } = C;
          Mo(C, j, false), $ && (R.el = $);
          const ae2 = !$ && C.subTree.el;
          E(
            C,
            R,
            L($ || C.subTree.el),
            $ ? null : g(C.subTree),
            x,
            o10,
            a10
          ), ae2 && T(ae2), Dl(C, R.el), M10 && --x.deps === 0 && x.resolve();
        });
      },
      unmount(C, E) {
        x.isUnmounted = true, x.activeBranch && p10(x.activeBranch, n10, C, E), x.pendingBranch && p10(x.pendingBranch, n10, C, E);
      }
    };
    return x;
  }
  function ud(t10, e10, n10, r10, s10, i10, o10, l10, a10) {
    const c10 = e10.suspense = Bl(e10, r10, n10, t10.parentNode, document.createElement("div"), null, s10, i10, o10, l10, true), u10 = a10(t10, c10.pendingBranch = e10.ssContent, n10, c10, i10, o10);
    return c10.deps === 0 && c10.resolve(), u10;
  }
  function hd(t10) {
    const { shapeFlag: e10, children: n10 } = t10, r10 = e10 & 32;
    t10.ssContent = zc(r10 ? n10.default : n10), t10.ssFallback = r10 ? zc(n10.fallback) : V$1(yt);
  }
  function zc(t10) {
    let e10;
    if (ue$1(t10)) {
      const n10 = Vr && t10._c;
      n10 && (t10._d = false, k$1()), t10 = t10(), n10 && (t10._d = true, e10 = Dt$1, e5());
    }
    return K$1(t10) && (t10 = nd(t10)), t10 = Wt$1(t10), e10 && !t10.dynamicChildren && (t10.dynamicChildren = e10.filter((n10) => n10 !== t10)), t10;
  }
  function h3(t10, e10) {
    e10 && e10.pendingBranch ? K$1(t10) ? e10.effects.push(...t10) : e10.effects.push(t10) : Il(t10);
  }
  function us(t10, e10) {
    t10.activeBranch = e10;
    const { vnode: n10, parentComponent: r10 } = t10, s10 = n10.el = e10.el;
    r10 && r10.subTree === n10 && (r10.vnode.el = s10, Dl(r10, s10));
  }
  function Ut$1(t10, e10) {
    if (dt) {
      let n10 = dt.provides;
      const r10 = dt.parent && dt.parent.provides;
      r10 === n10 && (n10 = dt.provides = Object.create(r10)), n10[t10] = e10;
    }
  }
  function lt(t10, e10, n10 = false) {
    const r10 = dt || ut;
    if (r10) {
      const s10 = r10.parent == null ? r10.vnode.appContext && r10.vnode.appContext.provides : r10.parent.provides;
      if (s10 && t10 in s10)
        return s10[t10];
      if (arguments.length > 1)
        return n10 && ue$1(e10) ? e10.call(r10.proxy) : e10;
    }
  }
  function Qt$1(t10, e10) {
    return A0(t10, null, e10);
  }
  function d3(t10, e10) {
    return A0(t10, null, { flush: "post" });
  }
  function dd(t10, e10) {
    return A0(t10, null, { flush: "sync" });
  }
  const si = {};
  function Yt$1(t10, e10, n10) {
    return A0(t10, e10, n10);
  }
  function A0(t10, e10, { immediate: n10, deep: r10, flush: s10, onTrack: i10, onTrigger: o10 } = Ge$1) {
    const l10 = dt;
    let a10, c10 = false, u10 = false;
    if (gt(t10) ? (a10 = () => t10.value, c10 = h0(t10)) : Un(t10) ? (a10 = () => t10, r10 = true) : K$1(t10) ? (u10 = true, c10 = t10.some((C) => Un(C) || h0(C)), a10 = () => t10.map((C) => {
      if (gt(C))
        return C.value;
      if (Un(C))
        return ir(C);
      if (ue$1(C))
        return En$1(C, l10, 2);
    })) : ue$1(t10) ? e10 ? a10 = () => En$1(t10, l10, 2) : a10 = () => {
      if (!(l10 && l10.isUnmounted))
        return h10 && h10(), $t$1(t10, l10, 3, [d10]);
    } : a10 = Bt$1, e10 && !r10) {
      const C = a10;
      a10 = () => {
        const E = C();
        return K$1(E) && r1("WATCH_ARRAY", l10) && ir(E), E;
      };
    }
    if (e10 && r10) {
      const C = a10;
      a10 = () => ir(C());
    }
    let h10, d10 = (C) => {
      h10 = _10.onStop = () => {
        En$1(C, l10, 4);
      };
    }, p10;
    if (Ls)
      if (d10 = Bt$1, e10 ? n10 && $t$1(e10, l10, 3, [
        a10(),
        u10 ? [] : void 0,
        d10
      ]) : a10(), s10 === "sync") {
        const C = a5();
        p10 = C.__watcherHandles || (C.__watcherHandles = []);
      } else
        return Bt$1;
    let g = u10 ? new Array(t10.length).fill(si) : si;
    const L = () => {
      if (!!_10.active)
        if (e10) {
          const C = _10.run();
          (r10 || c10 || (u10 ? C.some((E, M10) => ms(E, g[M10])) : ms(C, g)) || K$1(C) && Ue$1("WATCH_ARRAY", l10)) && (h10 && h10(), $t$1(e10, l10, 3, [
            C,
            g === si ? void 0 : u10 && g[0] === si ? [] : g,
            d10
          ]), g = C);
        } else
          _10.run();
    };
    L.allowRecurse = !!e10;
    let T;
    s10 === "sync" ? T = L : s10 === "post" ? T = () => at(L, l10 && l10.suspense) : (L.pre = true, l10 && (L.id = l10.uid), T = () => n1(L));
    const _10 = new S0(a10, T);
    e10 ? n10 ? L() : g = _10.run() : s10 === "post" ? at(_10.run.bind(_10), l10 && l10.suspense) : _10.run();
    const x = () => {
      _10.stop(), l10 && l10.scope && _l(l10.scope.effects, _10);
    };
    return p10 && p10.push(x), x;
  }
  function fd(t10, e10, n10) {
    const r10 = this.proxy, s10 = Ke$1(t10) ? t10.includes(".") ? f3(r10, t10) : () => r10[t10] : t10.bind(r10, r10);
    let i10;
    ue$1(e10) ? i10 = e10 : (i10 = e10.handler, n10 = e10);
    const o10 = dt;
    mr(this);
    const l10 = A0(s10, i10.bind(r10), n10);
    return o10 ? mr(o10) : hr(), l10;
  }
  function f3(t10, e10) {
    const n10 = e10.split(".");
    return () => {
      let r10 = t10;
      for (let s10 = 0; s10 < n10.length && r10; s10++)
        r10 = r10[n10[s10]];
      return r10;
    };
  }
  function ir(t10, e10) {
    if (!Se(t10) || t10.__v_skip || (e10 = e10 || /* @__PURE__ */ new Set(), e10.has(t10)))
      return t10;
    if (e10.add(t10), gt(t10))
      ir(t10.value, e10);
    else if (K$1(t10))
      for (let n10 = 0; n10 < t10.length; n10++)
        ir(t10[n10], e10);
    else if (Gr(t10) || is(t10))
      t10.forEach((n10) => {
        ir(n10, e10);
      });
    else if (Ei(t10))
      for (const n10 in t10)
        ir(t10[n10], e10);
    return t10;
  }
  function $l() {
    const t10 = {
      isMounted: false,
      isLeaving: false,
      isUnmounting: false,
      leavingVNodes: /* @__PURE__ */ new Map()
    };
    return We$1(() => {
      t10.isMounted = true;
    }), x0(() => {
      t10.isUnmounting = true;
    }), t10;
  }
  const rn$1 = [Function, Array], p3 = {
    name: "BaseTransition",
    props: {
      mode: String,
      appear: Boolean,
      persisted: Boolean,
      onBeforeEnter: rn$1,
      onEnter: rn$1,
      onAfterEnter: rn$1,
      onEnterCancelled: rn$1,
      onBeforeLeave: rn$1,
      onLeave: rn$1,
      onAfterLeave: rn$1,
      onLeaveCancelled: rn$1,
      onBeforeAppear: rn$1,
      onAppear: rn$1,
      onAfterAppear: rn$1,
      onAppearCancelled: rn$1
    },
    setup(t10, { slots: e10 }) {
      const n10 = Pn(), r10 = $l();
      let s10;
      return () => {
        const i10 = e10.default && o1(e10.default(), true);
        if (!i10 || !i10.length)
          return;
        let o10 = i10[0];
        if (i10.length > 1) {
          for (const L of i10)
            if (L.type !== yt) {
              o10 = L;
              break;
            }
        }
        const l10 = we$1(t10), { mode: a10 } = l10;
        if (r10.isLeaving)
          return G1(o10);
        const c10 = Gc(o10);
        if (!c10)
          return G1(o10);
        const u10 = xs(c10, l10, r10, n10);
        Hr(c10, u10);
        const h10 = n10.subTree, d10 = h10 && Gc(h10);
        let p10 = false;
        const { getTransitionKey: g } = c10.type;
        if (g) {
          const L = g();
          s10 === void 0 ? s10 = L : L !== s10 && (s10 = L, p10 = true);
        }
        if (d10 && d10.type !== yt && (!vn$1(c10, d10) || p10)) {
          const L = xs(d10, l10, r10, n10);
          if (Hr(d10, L), a10 === "out-in")
            return r10.isLeaving = true, L.afterLeave = () => {
              r10.isLeaving = false, n10.update.active !== false && n10.update();
            }, G1(o10);
          a10 === "in-out" && c10.type !== yt && (L.delayLeave = (T, _10, x) => {
            const C = g3(r10, d10);
            C[String(d10.key)] = d10, T._leaveCb = () => {
              _10(), T._leaveCb = void 0, delete u10.delayedLeave;
            }, u10.delayedLeave = x;
          });
        }
        return o10;
      };
    }
  };
  p3.__isBuiltIn = true;
  const Hl = p3;
  function g3(t10, e10) {
    const { leavingVNodes: n10 } = t10;
    let r10 = n10.get(e10.type);
    return r10 || (r10 = /* @__PURE__ */ Object.create(null), n10.set(e10.type, r10)), r10;
  }
  function xs(t10, e10, n10, r10) {
    const { appear: s10, mode: i10, persisted: o10 = false, onBeforeEnter: l10, onEnter: a10, onAfterEnter: c10, onEnterCancelled: u10, onBeforeLeave: h10, onLeave: d10, onAfterLeave: p10, onLeaveCancelled: g, onBeforeAppear: L, onAppear: T, onAfterAppear: _10, onAppearCancelled: x } = e10, C = String(t10.key), E = g3(n10, t10), M10 = (R, ae2) => {
      R && $t$1(R, r10, 9, ae2);
    }, $ = (R, ae2) => {
      const le2 = ae2[1];
      M10(R, ae2), K$1(R) ? R.every((he) => he.length <= 1) && le2() : R.length <= 1 && le2();
    }, j = {
      mode: i10,
      persisted: o10,
      beforeEnter(R) {
        let ae2 = l10;
        if (!n10.isMounted)
          if (s10)
            ae2 = L || l10;
          else
            return;
        R._leaveCb && R._leaveCb(true);
        const le2 = E[C];
        le2 && vn$1(t10, le2) && le2.el._leaveCb && le2.el._leaveCb(), M10(ae2, [R]);
      },
      enter(R) {
        let ae2 = a10, le2 = c10, he = u10;
        if (!n10.isMounted)
          if (s10)
            ae2 = T || a10, le2 = _10 || c10, he = x || u10;
          else
            return;
        let He2 = false;
        const Le2 = R._enterCb = (re2) => {
          He2 || (He2 = true, re2 ? M10(he, [R]) : M10(le2, [R]), j.delayedLeave && j.delayedLeave(), R._enterCb = void 0);
        };
        ae2 ? $(ae2, [R, Le2]) : Le2();
      },
      leave(R, ae2) {
        const le2 = String(t10.key);
        if (R._enterCb && R._enterCb(true), n10.isUnmounting)
          return ae2();
        M10(h10, [R]);
        let he = false;
        const He2 = R._leaveCb = (Le2) => {
          he || (he = true, ae2(), Le2 ? M10(g, [R]) : M10(p10, [R]), R._leaveCb = void 0, E[le2] === t10 && delete E[le2]);
        };
        E[le2] = t10, d10 ? $(d10, [R, He2]) : He2();
      },
      clone(R) {
        return xs(R, e10, n10, r10);
      }
    };
    return j;
  }
  function G1(t10) {
    if (k0(t10))
      return t10 = an$1(t10), t10.children = null, t10;
  }
  function Gc(t10) {
    return k0(t10) ? t10.children ? t10.children[0] : void 0 : t10;
  }
  function Hr(t10, e10) {
    t10.shapeFlag & 6 && t10.component ? Hr(t10.component.subTree, e10) : t10.shapeFlag & 128 ? (t10.ssContent.transition = e10.clone(t10.ssContent), t10.ssFallback.transition = e10.clone(t10.ssFallback)) : t10.transition = e10;
  }
  function o1(t10, e10 = false, n10) {
    let r10 = [], s10 = 0;
    for (let i10 = 0; i10 < t10.length; i10++) {
      let o10 = t10[i10];
      const l10 = n10 == null ? o10.key : String(n10) + String(o10.key != null ? o10.key : i10);
      o10.type === Fe$1 ? (o10.patchFlag & 128 && s10++, r10 = r10.concat(o1(o10.children, e10, l10))) : (e10 || o10.type !== yt) && r10.push(l10 != null ? an$1(o10, { key: l10 }) : o10);
    }
    if (s10 > 1)
      for (let i10 = 0; i10 < r10.length; i10++)
        r10[i10].patchFlag = -2;
    return r10;
  }
  function Ye$1(t10) {
    return ue$1(t10) ? { setup: t10, name: t10.name } : t10;
  }
  const Mr = (t10) => !!t10.type.__asyncLoader;
  function hs(t10) {
    ue$1(t10) && (t10 = { loader: t10 });
    const {
      loader: e10,
      loadingComponent: n10,
      errorComponent: r10,
      delay: s10 = 200,
      timeout: i10,
      suspensible: o10 = true,
      onError: l10
    } = t10;
    let a10 = null, c10, u10 = 0;
    const h10 = () => (u10++, a10 = null, d10()), d10 = () => {
      let p10;
      return a10 || (p10 = a10 = e10().catch((g) => {
        if (g = g instanceof Error ? g : new Error(String(g)), l10)
          return new Promise((L, T) => {
            l10(g, () => L(h10()), () => T(g), u10 + 1);
          });
        throw g;
      }).then((g) => p10 !== a10 && a10 ? a10 : (g && (g.__esModule || g[Symbol.toStringTag] === "Module") && (g = g.default), c10 = g, g)));
    };
    return Ye$1({
      name: "AsyncComponentWrapper",
      __asyncLoader: d10,
      get __asyncResolved() {
        return c10;
      },
      setup() {
        const p10 = dt;
        if (c10)
          return () => j1(c10, p10);
        const g = (x) => {
          a10 = null, jr(x, p10, 13, !r10);
        };
        if (o10 && p10.suspense || Ls)
          return d10().then((x) => () => j1(x, p10)).catch((x) => (g(x), () => r10 ? V$1(r10, {
            error: x
          }) : null));
        const L = ge(false), T = ge(), _10 = ge(!!s10);
        return s10 && setTimeout(() => {
          _10.value = false;
        }, s10), i10 != null && setTimeout(() => {
          if (!L.value && !T.value) {
            const x = new Error(`Async component timed out after ${i10}ms.`);
            g(x), T.value = x;
          }
        }, i10), d10().then(() => {
          L.value = true, p10.parent && k0(p10.parent.vnode) && n1(p10.parent.update);
        }).catch((x) => {
          g(x), T.value = x;
        }), () => {
          if (L.value && c10)
            return j1(c10, p10);
          if (T.value && r10)
            return V$1(r10, {
              error: T.value
            });
          if (n10 && !_10.value)
            return V$1(n10);
        };
      }
    });
  }
  function j1(t10, e10) {
    const { ref: n10, props: r10, children: s10, ce: i10 } = e10.vnode, o10 = V$1(t10, r10, s10);
    return o10.ref = n10, o10.ce = i10, delete e10.vnode.ce, o10;
  }
  const k0 = (t10) => t10.type.__isKeepAlive, m3 = {
    name: "KeepAlive",
    __isKeepAlive: true,
    props: {
      include: [String, RegExp, Array],
      exclude: [String, RegExp, Array],
      max: [String, Number]
    },
    setup(t10, { slots: e10 }) {
      const n10 = Pn(), r10 = n10.ctx;
      if (!r10.renderer)
        return () => {
          const x = e10.default && e10.default();
          return x && x.length === 1 ? x[0] : x;
        };
      const s10 = /* @__PURE__ */ new Map(), i10 = /* @__PURE__ */ new Set();
      let o10 = null;
      const l10 = n10.suspense, { renderer: { p: a10, m: c10, um: u10, o: { createElement: h10 } } } = r10, d10 = h10("div");
      r10.activate = (x, C, E, M10, $) => {
        const j = x.component;
        c10(x, C, E, 0, l10), a10(j.vnode, x, C, E, j, l10, M10, x.slotScopeIds, $), at(() => {
          j.isDeactivated = false, j.a && cr(j.a);
          const R = x.props && x.props.onVnodeMounted;
          R && Nt$1(R, j.parent, x);
        }, l10);
      }, r10.deactivate = (x) => {
        const C = x.component;
        c10(x, d10, null, 1, l10), at(() => {
          C.da && cr(C.da);
          const E = x.props && x.props.onVnodeUnmounted;
          E && Nt$1(E, C.parent, x), C.isDeactivated = true;
        }, l10);
      };
      function p10(x) {
        Z1(x), u10(x, n10, l10, true);
      }
      function g(x) {
        s10.forEach((C, E) => {
          const M10 = Fo(C.type);
          M10 && (!x || !x(M10)) && L(E);
        });
      }
      function L(x) {
        const C = s10.get(x);
        !o10 || C.type !== o10.type ? p10(C) : o10 && Z1(o10), s10.delete(x), i10.delete(x);
      }
      Yt$1(
        () => [t10.include, t10.exclude],
        ([x, C]) => {
          x && g((E) => Ys(x, E)), C && g((E) => !Ys(C, E));
        },
        { flush: "post", deep: true }
      );
      let T = null;
      const _10 = () => {
        T != null && s10.set(T, W1(n10.subTree));
      };
      return We$1(_10), R0(_10), x0(() => {
        s10.forEach((x) => {
          const { subTree: C, suspense: E } = n10, M10 = W1(C);
          if (x.type === M10.type) {
            Z1(M10);
            const $ = M10.component.da;
            $ && at($, E);
            return;
          }
          p10(x);
        });
      }), () => {
        if (T = null, !e10.default)
          return null;
        const x = e10.default(), C = x[0];
        if (x.length > 1)
          return o10 = null, x;
        if (!Jt$1(C) || !(C.shapeFlag & 4) && !(C.shapeFlag & 128))
          return o10 = null, C;
        let E = W1(C);
        const M10 = E.type, $ = Fo(Mr(E) ? E.type.__asyncResolved || {} : M10), { include: j, exclude: R, max: ae2 } = t10;
        if (j && (!$ || !Ys(j, $)) || R && $ && Ys(R, $))
          return o10 = E, C;
        const le2 = E.key == null ? M10 : E.key, he = s10.get(le2);
        return E.el && (E = an$1(E), C.shapeFlag & 128 && (C.ssContent = E)), T = le2, he ? (E.el = he.el, E.component = he.component, E.transition && Hr(E, E.transition), E.shapeFlag |= 512, i10.delete(le2), i10.add(le2)) : (i10.add(le2), ae2 && i10.size > parseInt(ae2, 10) && L(i10.values().next().value)), E.shapeFlag |= 256, o10 = E, u3(C.type) ? C : E;
      };
    }
  };
  m3.__isBuildIn = true;
  const x3 = m3;
  function Ys(t10, e10) {
    return K$1(t10) ? t10.some((n10) => Ys(n10, e10)) : Ke$1(t10) ? t10.split(",").includes(e10) : t10.test ? t10.test(e10) : false;
  }
  function L3(t10, e10) {
    y3(t10, "a", e10);
  }
  function _3(t10, e10) {
    y3(t10, "da", e10);
  }
  function y3(t10, e10, n10 = dt) {
    const r10 = t10.__wdc || (t10.__wdc = () => {
      let s10 = n10;
      for (; s10; ) {
        if (s10.isDeactivated)
          return;
        s10 = s10.parent;
      }
      return t10();
    });
    if (l1(e10, r10, n10), n10) {
      let s10 = n10.parent;
      for (; s10 && s10.parent; )
        k0(s10.parent.vnode) && pd(r10, e10, n10, s10), s10 = s10.parent;
    }
  }
  function pd(t10, e10, n10, r10) {
    const s10 = l1(e10, t10, r10, true);
    ht(() => {
      _l(r10[e10], s10);
    }, n10);
  }
  function Z1(t10) {
    t10.shapeFlag &= -257, t10.shapeFlag &= -513;
  }
  function W1(t10) {
    return t10.shapeFlag & 128 ? t10.ssContent : t10;
  }
  function l1(t10, e10, n10 = dt, r10 = false) {
    if (n10) {
      const s10 = n10[t10] || (n10[t10] = []), i10 = e10.__weh || (e10.__weh = (...o10) => {
        if (n10.isUnmounted)
          return;
        Es(), mr(n10);
        const l10 = $t$1(e10, n10, t10, o10);
        return hr(), Ts(), l10;
      });
      return r10 ? s10.unshift(i10) : s10.push(i10), i10;
    }
  }
  const Xn = (t10) => (e10, n10 = dt) => (!Ls || t10 === "sp") && l1(t10, (...r10) => e10(...r10), n10), C3 = Xn("bm"), We$1 = Xn("m"), v3 = Xn("bu"), R0 = Xn("u"), x0 = Xn("bum"), ht = Xn("um"), b3 = Xn("sp"), w3 = Xn("rtg"), E3 = Xn("rtc");
  function T3(t10, e10 = dt) {
    l1("ec", t10, e10);
  }
  function gd(t10) {
    _t$1("INSTANCE_CHILDREN", t10);
    const e10 = t10.subTree, n10 = [];
    return e10 && S3(e10, n10), n10;
  }
  function S3(t10, e10) {
    if (t10.component)
      e10.push(t10.component.proxy);
    else if (t10.shapeFlag & 16) {
      const n10 = t10.children;
      for (let r10 = 0; r10 < n10.length; r10++)
        S3(n10[r10], e10);
    }
  }
  function A3(t10) {
    _t$1("INSTANCE_LISTENERS", t10);
    const e10 = {}, n10 = t10.vnode.props;
    if (!n10)
      return e10;
    for (const r10 in n10)
      Yn(r10) && (e10[r10[2].toLowerCase() + r10.slice(3)] = n10[r10]);
    return e10;
  }
  const md = {
    beforeMount: "bind",
    mounted: "inserted",
    updated: ["update", "componentUpdated"],
    unmounted: "unbind"
  };
  function xd(t10, e10, n10) {
    const r10 = md[t10];
    if (r10)
      if (K$1(r10)) {
        const s10 = [];
        return r10.forEach((i10) => {
          const o10 = e10[i10];
          o10 && (Zn("CUSTOM_DIR", n10, i10, t10), s10.push(o10));
        }), s10.length ? s10 : void 0;
      } else
        return e10[r10] && Zn("CUSTOM_DIR", n10, r10, t10), e10[r10];
  }
  function a1(t10, e10) {
    const n10 = ut;
    if (n10 === null)
      return t10;
    const r10 = p1(n10) || n10.proxy, s10 = t10.dirs || (t10.dirs = []);
    for (let i10 = 0; i10 < e10.length; i10++) {
      let [o10, l10, a10, c10 = Ge$1] = e10[i10];
      o10 && (ue$1(o10) && (o10 = {
        mounted: o10,
        updated: o10
      }), o10.deep && ir(l10), s10.push({
        dir: o10,
        instance: r10,
        value: l10,
        oldValue: void 0,
        arg: a10,
        modifiers: c10
      }));
    }
    return t10;
  }
  function yn$1(t10, e10, n10, r10) {
    const s10 = t10.dirs, i10 = e10 && e10.dirs;
    for (let o10 = 0; o10 < s10.length; o10++) {
      const l10 = s10[o10];
      i10 && (l10.oldValue = i10[o10].value);
      let a10 = l10.dir[r10];
      a10 || (a10 = xd(r10, l10.dir, n10)), a10 && (Es(), $t$1(a10, n10, 8, [
        t10.el,
        l10,
        t10,
        e10
      ]), Ts());
    }
  }
  const Ul = "components", Ld = "directives", _d = "filters";
  function me$1(t10, e10) {
    return c1(Ul, t10, true, e10) || t10;
  }
  const k3 = Symbol();
  function ks(t10) {
    return Ke$1(t10) ? c1(Ul, t10, false) || t10 : t10 || k3;
  }
  function R3(t10) {
    return c1(Ld, t10);
  }
  function O3(t10) {
    return c1(_d, t10);
  }
  function c1(t10, e10, n10 = true, r10 = false) {
    const s10 = ut || dt;
    if (s10) {
      const i10 = s10.type;
      if (t10 === Ul) {
        const l10 = Fo(i10, false);
        if (l10 && (l10 === e10 || l10 === Rt$1(e10) || l10 === T0(Rt$1(e10))))
          return i10;
      }
      const o10 = jc(s10[t10] || i10[t10], e10) || jc(s10.appContext[t10], e10);
      return !o10 && r10 ? i10 : o10;
    }
  }
  function jc(t10, e10) {
    return t10 && (t10[e10] || t10[Rt$1(e10)] || t10[T0(Rt$1(e10))]);
  }
  function yd(t10) {
    const e10 = t10.type, n10 = e10.render;
    if (!(!n10 || n10._rc || n10._compatChecked || n10._compatWrapped)) {
      if (n10.length >= 2) {
        n10._compatChecked = true;
        return;
      }
      if (r1("RENDER_FUNCTION", t10)) {
        const r10 = e10.render = function() {
          return n10.call(this, Ai);
        };
        r10._compatWrapped = true;
      }
    }
  }
  function Ai(t10, e10, n10) {
    if (t10 || (t10 = yt), typeof t10 == "string") {
      const i10 = St$1(t10);
      (i10 === "transition" || i10 === "transition-group" || i10 === "keep-alive") && (t10 = `__compat__${i10}`), t10 = ks(t10);
    }
    const r10 = arguments.length, s10 = K$1(e10);
    return r10 === 2 || s10 ? Se(e10) && !s10 ? Jt$1(e10) ? ii(V$1(t10, null, [e10])) : ii(Wc(V$1(t10, Zc(e10, t10)), e10)) : ii(V$1(t10, null, e10)) : (Jt$1(n10) && (n10 = [n10]), ii(Wc(V$1(t10, Zc(e10, t10), n10), e10)));
  }
  const Cd = /* @__PURE__ */ ws("staticStyle,staticClass,directives,model,hook");
  function Zc(t10, e10) {
    if (!t10)
      return null;
    const n10 = {};
    for (const r10 in t10)
      if (r10 === "attrs" || r10 === "domProps" || r10 === "props")
        Oe$1(n10, t10[r10]);
      else if (r10 === "on" || r10 === "nativeOn") {
        const s10 = t10[r10];
        for (const i10 in s10) {
          let o10 = vd(i10);
          r10 === "nativeOn" && (o10 += "Native");
          const l10 = n10[o10], a10 = s10[i10];
          l10 !== a10 && (l10 ? n10[o10] = [].concat(l10, a10) : n10[o10] = a10);
        }
      } else
        Cd(r10) || (n10[r10] = t10[r10]);
    if (t10.staticClass && (n10.class = ve$1([t10.staticClass, n10.class])), t10.staticStyle && (n10.style = Ce$1([t10.staticStyle, n10.style])), t10.model && Se(e10)) {
      const { prop: r10 = "value", event: s10 = "input" } = e10.model || {};
      n10[r10] = t10.model.value, n10[s1 + s10] = t10.model.callback;
    }
    return n10;
  }
  function vd(t10) {
    return t10[0] === "&" && (t10 = t10.slice(1) + "Passive"), t10[0] === "~" && (t10 = t10.slice(1) + "Once"), t10[0] === "!" && (t10 = t10.slice(1) + "Capture"), ls(t10);
  }
  function Wc(t10, e10) {
    return e10 && e10.directives ? a1(t10, e10.directives.map(({ name: n10, value: r10, arg: s10, modifiers: i10 }) => [
      R3(n10),
      r10,
      s10,
      i10
    ])) : t10;
  }
  function ii(t10) {
    const { props: e10, children: n10 } = t10;
    let r10;
    if (t10.shapeFlag & 6 && K$1(n10)) {
      r10 = {};
      for (let i10 = 0; i10 < n10.length; i10++) {
        const o10 = n10[i10], l10 = Jt$1(o10) && o10.props && o10.props.slot || "default", a10 = r10[l10] || (r10[l10] = []);
        Jt$1(o10) && o10.type === "template" ? a10.push(o10.children) : a10.push(o10);
      }
      if (r10)
        for (const i10 in r10) {
          const o10 = r10[i10];
          r10[i10] = () => o10, r10[i10]._ns = true;
        }
    }
    const s10 = e10 && e10.scopedSlots;
    return s10 && (delete e10.scopedSlots, r10 ? Oe$1(r10, s10) : r10 = s10), r10 && d1(t10, r10), t10;
  }
  function I3(t10) {
    if (Ue$1("RENDER_FUNCTION", ut, true) && Ue$1("PRIVATE_APIS", ut, true)) {
      const e10 = ut, n10 = () => t10.component && t10.component.proxy;
      let r10;
      Object.defineProperties(t10, {
        tag: { get: () => t10.type },
        data: { get: () => t10.props || {}, set: (s10) => t10.props = s10 },
        elm: { get: () => t10.el },
        componentInstance: { get: n10 },
        child: { get: n10 },
        text: { get: () => Ke$1(t10.children) ? t10.children : null },
        context: { get: () => e10 && e10.proxy },
        componentOptions: {
          get: () => {
            if (t10.shapeFlag & 4)
              return r10 || (r10 = {
                Ctor: t10.type,
                propsData: t10.props,
                children: t10.children
              });
          }
        }
      });
    }
  }
  const q1 = /* @__PURE__ */ new Map(), M3 = {
    get(t10, e10) {
      const n10 = t10[e10];
      return n10 && n10();
    }
  };
  function bd(t10) {
    if (q1.has(t10))
      return q1.get(t10);
    const e10 = t10.render, n10 = (r10, s10) => {
      const i10 = Pn(), o10 = {
        props: r10,
        children: i10.vnode.children || [],
        data: i10.vnode.props || {},
        scopedSlots: s10.slots,
        parent: i10.parent && i10.parent.proxy,
        slots() {
          return new Proxy(s10.slots, M3);
        },
        get listeners() {
          return A3(i10);
        },
        get injections() {
          if (t10.inject) {
            const l10 = {};
            return $3(t10.inject, l10), l10;
          }
          return {};
        }
      };
      return e10(Ai, o10);
    };
    return n10.props = t10.props, n10.displayName = t10.name, n10.compatConfig = t10.compatConfig, n10.inheritAttrs = false, q1.set(t10, n10), n10;
  }
  function On$1(t10, e10, n10, r10) {
    let s10;
    const i10 = n10 && n10[r10];
    if (K$1(t10) || Ke$1(t10)) {
      s10 = new Array(t10.length);
      for (let o10 = 0, l10 = t10.length; o10 < l10; o10++)
        s10[o10] = e10(t10[o10], o10, void 0, i10 && i10[o10]);
    } else if (typeof t10 == "number") {
      s10 = new Array(t10);
      for (let o10 = 0; o10 < t10; o10++)
        s10[o10] = e10(o10 + 1, o10, void 0, i10 && i10[o10]);
    } else if (Se(t10))
      if (t10[Symbol.iterator])
        s10 = Array.from(t10, (o10, l10) => e10(o10, l10, void 0, i10 && i10[l10]));
      else {
        const o10 = Object.keys(t10);
        s10 = new Array(o10.length);
        for (let l10 = 0, a10 = o10.length; l10 < a10; l10++) {
          const c10 = o10[l10];
          s10[l10] = e10(t10[c10], c10, l10, i10 && i10[l10]);
        }
      }
    else
      s10 = [];
    return n10 && (n10[r10] = s10), s10;
  }
  function N3(t10, e10) {
    for (let n10 = 0; n10 < e10.length; n10++) {
      const r10 = e10[n10];
      if (K$1(r10))
        for (let s10 = 0; s10 < r10.length; s10++)
          t10[r10[s10].name] = r10[s10].fn;
      else
        r10 && (t10[r10.name] = r10.key ? (...s10) => {
          const i10 = r10.fn(...s10);
          return i10 && (i10.key = r10.key), i10;
        } : r10.fn);
    }
    return t10;
  }
  function Vl(t10, e10, n10 = {}, r10, s10) {
    if (ut.isCE || ut.parent && Mr(ut.parent) && ut.parent.isCE)
      return e10 !== "default" && (n10.name = e10), V$1("slot", n10, r10 && r10());
    let i10 = t10[e10];
    i10 && i10._c && (i10._d = false), k$1();
    const o10 = i10 && P3(i10(n10)), l10 = Re$1(Fe$1, {
      key: n10.key || o10 && o10.key || `_${e10}`
    }, o10 || (r10 ? r10() : []), o10 && t10._ === 1 ? 64 : -2);
    return !s10 && l10.scopeId && (l10.slotScopeIds = [l10.scopeId + "-s"]), i10 && i10._c && (i10._d = true), l10;
  }
  function P3(t10) {
    return t10.some((e10) => Jt$1(e10) ? !(e10.type === yt || e10.type === Fe$1 && !P3(e10.children)) : true) ? t10 : null;
  }
  function F3(t10, e10) {
    const n10 = {};
    for (const r10 in t10)
      n10[e10 && /[A-Z]/.test(r10) ? `on:${r10}` : ls(r10)] = t10[r10];
    return n10;
  }
  function wd(t10) {
    const e10 = {};
    for (let n10 = 0; n10 < t10.length; n10++)
      t10[n10] && Oe$1(e10, t10[n10]);
    return e10;
  }
  function Ed(t10, e10, n10, r10, s10) {
    if (n10 && Se(n10)) {
      K$1(n10) && (n10 = wd(n10));
      for (const i10 in n10)
        if (os(i10))
          t10[i10] = n10[i10];
        else if (i10 === "class")
          t10.class = ve$1([t10.class, n10.class]);
        else if (i10 === "style")
          t10.style = ve$1([t10.style, n10.style]);
        else {
          const o10 = t10.attrs || (t10.attrs = {}), l10 = Rt$1(i10), a10 = St$1(i10);
          if (!(l10 in o10) && !(a10 in o10) && (o10[i10] = n10[i10], s10)) {
            const c10 = t10.on || (t10.on = {});
            c10[`update:${i10}`] = function(u10) {
              n10[i10] = u10;
            };
          }
        }
    }
    return t10;
  }
  function Td(t10, e10) {
    return f1(t10, F3(e10));
  }
  function Sd(t10, e10, n10, r10, s10) {
    return s10 && (r10 = f1(r10, s10)), Vl(t10.slots, e10, r10, n10 && (() => n10));
  }
  function Ad(t10, e10, n10) {
    return N3(e10 || { $stable: !n10 }, D3(t10));
  }
  function D3(t10) {
    for (let e10 = 0; e10 < t10.length; e10++) {
      const n10 = t10[e10];
      n10 && (K$1(n10) ? D3(n10) : n10.name = n10.key || "default");
    }
    return t10;
  }
  const qc = /* @__PURE__ */ new WeakMap();
  function kd(t10, e10) {
    let n10 = qc.get(t10);
    if (n10 || qc.set(t10, n10 = []), n10[e10])
      return n10[e10];
    const r10 = t10.type.staticRenderFns[e10], s10 = t10.proxy;
    return n10[e10] = r10.call(s10, null, s10);
  }
  function Rd(t10, e10, n10, r10, s10, i10) {
    const l10 = t10.appContext.config.keyCodes || {}, a10 = l10[n10] || r10;
    if (i10 && s10 && !l10[n10])
      return Kc(i10, s10);
    if (a10)
      return Kc(a10, e10);
    if (s10)
      return St$1(s10) !== n10;
  }
  function Kc(t10, e10) {
    return K$1(t10) ? !t10.includes(e10) : t10 !== e10;
  }
  function Od(t10) {
    return t10;
  }
  function Id(t10, e10) {
    for (let n10 = 0; n10 < e10.length; n10 += 2) {
      const r10 = e10[n10];
      typeof r10 == "string" && r10 && (t10[e10[n10]] = e10[n10 + 1]);
    }
    return t10;
  }
  function Md(t10, e10) {
    return typeof t10 == "string" ? e10 + t10 : t10;
  }
  function Nd(t10) {
    const e10 = (r10, s10, i10) => {
      r10[s10] = i10;
    }, n10 = (r10, s10) => {
      delete r10[s10];
    };
    Oe$1(t10, {
      $set: (r10) => (_t$1("INSTANCE_SET", r10), e10),
      $delete: (r10) => (_t$1("INSTANCE_DELETE", r10), n10),
      $mount: (r10) => (_t$1("GLOBAL_MOUNT", null), r10.ctx._compat_mount || Bt$1),
      $destroy: (r10) => (_t$1("INSTANCE_DESTROY", r10), r10.ctx._compat_destroy || Bt$1),
      $slots: (r10) => Ue$1("RENDER_FUNCTION", r10) && r10.render && r10.render._compatWrapped ? new Proxy(r10.slots, M3) : r10.slots,
      $scopedSlots: (r10) => {
        _t$1("INSTANCE_SCOPED_SLOTS", r10);
        const s10 = {};
        for (const i10 in r10.slots) {
          const o10 = r10.slots[i10];
          o10._ns || (s10[i10] = o10);
        }
        return s10;
      },
      $on: (r10) => Pl.bind(null, r10),
      $once: (r10) => Y8.bind(null, r10),
      $off: (r10) => Fl.bind(null, r10),
      $children: gd,
      $listeners: A3
    }), Ue$1("PRIVATE_APIS", null) && Oe$1(t10, {
      $vnode: (r10) => r10.vnode,
      $options: (r10) => {
        const s10 = Oe$1({}, O0(r10));
        return s10.parent = r10.proxy.$parent, s10.propsData = r10.vnode.props, s10;
      },
      _self: (r10) => r10.proxy,
      _uid: (r10) => r10.uid,
      _data: (r10) => r10.data,
      _isMounted: (r10) => r10.isMounted,
      _isDestroyed: (r10) => r10.isUnmounted,
      $createElement: () => Ai,
      _c: () => Ai,
      _o: () => Od,
      _n: () => An$1,
      _s: () => Ve$1,
      _l: () => On$1,
      _t: (r10) => Sd.bind(null, r10),
      _q: () => jn,
      _i: () => w0,
      _m: (r10) => kd.bind(null, r10),
      _f: () => O3,
      _k: (r10) => Rd.bind(null, r10),
      _b: () => Ed,
      _v: () => dn$1,
      _e: () => xe$1,
      _u: () => Ad,
      _g: () => Td,
      _d: () => Id,
      _p: () => Md
    });
  }
  const To = (t10) => t10 ? s5(t10) ? p1(t10) || t10.proxy : To(t10.parent) : null, ds = /* @__PURE__ */ Oe$1(/* @__PURE__ */ Object.create(null), {
    $: (t10) => t10,
    $el: (t10) => t10.vnode.el,
    $data: (t10) => t10.data,
    $props: (t10) => t10.props,
    $attrs: (t10) => t10.attrs,
    $slots: (t10) => t10.slots,
    $refs: (t10) => t10.refs,
    $parent: (t10) => To(t10.parent),
    $root: (t10) => To(t10.root),
    $emit: (t10) => t10.emit,
    $options: (t10) => O0(t10),
    $forceUpdate: (t10) => t10.f || (t10.f = () => n1(t10.update)),
    $nextTick: (t10) => t10.n || (t10.n = gr.bind(t10.proxy)),
    $watch: (t10) => fd.bind(t10)
  });
  Nd(ds);
  const K1 = (t10, e10) => t10 !== Ge$1 && !t10.__isScriptSetup && Me(t10, e10), So = {
    get({ _: t10 }, e10) {
      const { ctx: n10, setupState: r10, data: s10, props: i10, accessCache: o10, type: l10, appContext: a10 } = t10;
      let c10;
      if (e10[0] !== "$") {
        const p10 = o10[e10];
        if (p10 !== void 0)
          switch (p10) {
            case 1:
              return r10[e10];
            case 2:
              return s10[e10];
            case 4:
              return n10[e10];
            case 3:
              return i10[e10];
          }
        else {
          if (K1(r10, e10))
            return o10[e10] = 1, r10[e10];
          if (s10 !== Ge$1 && Me(s10, e10))
            return o10[e10] = 2, s10[e10];
          if ((c10 = t10.propsOptions[0]) && Me(c10, e10))
            return o10[e10] = 3, i10[e10];
          if (n10 !== Ge$1 && Me(n10, e10))
            return o10[e10] = 4, n10[e10];
          Ao && (o10[e10] = 0);
        }
      }
      const u10 = ds[e10];
      let h10, d10;
      if (u10)
        return e10 === "$attrs" && Ht$1(t10, "get", e10), u10(t10);
      if ((h10 = l10.__cssModules) && (h10 = h10[e10]))
        return h10;
      if (n10 !== Ge$1 && Me(n10, e10))
        return o10[e10] = 4, n10[e10];
      if (d10 = a10.config.globalProperties, Me(d10, e10)) {
        const p10 = Object.getOwnPropertyDescriptor(d10, e10);
        if (p10.get)
          return p10.get.call(t10.proxy);
        {
          const g = d10[e10];
          return ue$1(g) ? Object.assign(g.bind(t10.proxy), g) : g;
        }
      }
    },
    set({ _: t10 }, e10, n10) {
      const { data: r10, setupState: s10, ctx: i10 } = t10;
      return K1(s10, e10) ? (s10[e10] = n10, true) : r10 !== Ge$1 && Me(r10, e10) ? (r10[e10] = n10, true) : Me(t10.props, e10) || e10[0] === "$" && e10.slice(1) in t10 ? false : (i10[e10] = n10, true);
    },
    has({ _: { data: t10, setupState: e10, accessCache: n10, ctx: r10, appContext: s10, propsOptions: i10 } }, o10) {
      let l10;
      return !!n10[o10] || t10 !== Ge$1 && Me(t10, o10) || K1(e10, o10) || (l10 = i10[0]) && Me(l10, o10) || Me(r10, o10) || Me(ds, o10) || Me(s10.config.globalProperties, o10);
    },
    defineProperty(t10, e10, n10) {
      return n10.get != null ? t10._.accessCache[e10] = 0 : Me(n10, "value") && this.set(t10, e10, n10.value, null), Reflect.defineProperty(t10, e10, n10);
    }
  }, Pd = /* @__PURE__ */ Oe$1({}, So, {
    get(t10, e10) {
      if (e10 !== Symbol.unscopables)
        return So.get(t10, e10, t10);
    },
    has(t10, e10) {
      return e10[0] !== "_" && !z6(e10);
    }
  });
  function B3(t10, e10) {
    for (const n10 in e10) {
      const r10 = t10[n10], s10 = e10[n10];
      n10 in t10 && Ei(r10) && Ei(s10) ? B3(r10, s10) : t10[n10] = s10;
    }
    return t10;
  }
  let Ao = true;
  function Fd(t10) {
    const e10 = O0(t10), n10 = t10.proxy, r10 = t10.ctx;
    Ao = false, e10.beforeCreate && Yc(e10.beforeCreate, t10, "bc");
    const {
      data: s10,
      computed: i10,
      methods: o10,
      watch: l10,
      provide: a10,
      inject: c10,
      created: u10,
      beforeMount: h10,
      mounted: d10,
      beforeUpdate: p10,
      updated: g,
      activated: L,
      deactivated: T,
      beforeDestroy: _10,
      beforeUnmount: x,
      destroyed: C,
      unmounted: E,
      render: M10,
      renderTracked: $,
      renderTriggered: j,
      errorCaptured: R,
      serverPrefetch: ae2,
      expose: le2,
      inheritAttrs: he,
      components: He2,
      directives: Le2,
      filters: re2
    } = e10;
    if (c10 && $3(c10, r10, null, t10.appContext.config.unwrapInjectedRef), o10)
      for (const X10 in o10) {
        const de2 = o10[X10];
        ue$1(de2) && (r10[X10] = de2.bind(n10));
      }
    if (s10) {
      const X10 = s10.call(n10, n10);
      Se(X10) && (t10.data = Rn$1(X10));
    }
    if (Ao = true, i10)
      for (const X10 in i10) {
        const de2 = i10[X10], Xe2 = ue$1(de2) ? de2.bind(n10, n10) : ue$1(de2.get) ? de2.get.bind(n10, n10) : Bt$1, Qe2 = !ue$1(de2) && ue$1(de2.set) ? de2.set.bind(n10) : Bt$1, Ot = G$1({
          get: Xe2,
          set: Qe2
        });
        Object.defineProperty(r10, X10, {
          enumerable: true,
          configurable: true,
          get: () => Ot.value,
          set: (it) => Ot.value = it
        });
      }
    if (l10)
      for (const X10 in l10)
        H3(l10[X10], r10, n10, X10);
    if (a10) {
      const X10 = ue$1(a10) ? a10.call(n10) : a10;
      Reflect.ownKeys(X10).forEach((de2) => {
        Ut$1(de2, X10[de2]);
      });
    }
    u10 && Yc(u10, t10, "c");
    function D10(X10, de2) {
      K$1(de2) ? de2.forEach((Xe2) => X10(Xe2.bind(n10))) : de2 && X10(de2.bind(n10));
    }
    if (D10(C3, h10), D10(We$1, d10), D10(v3, p10), D10(R0, g), D10(L3, L), D10(_3, T), D10(T3, R), D10(E3, $), D10(w3, j), D10(x0, x), D10(ht, E), D10(b3, ae2), _10 && Zn("OPTIONS_BEFORE_DESTROY", t10) && D10(x0, _10), C && Zn("OPTIONS_DESTROYED", t10) && D10(ht, C), K$1(le2))
      if (le2.length) {
        const X10 = t10.exposed || (t10.exposed = {});
        le2.forEach((de2) => {
          Object.defineProperty(X10, de2, {
            get: () => n10[de2],
            set: (Xe2) => n10[de2] = Xe2
          });
        });
      } else
        t10.exposed || (t10.exposed = {});
    M10 && t10.render === Bt$1 && (t10.render = M10), he != null && (t10.inheritAttrs = he), He2 && (t10.components = He2), Le2 && (t10.directives = Le2), re2 && Ue$1("FILTERS", t10) && (t10.filters = re2);
  }
  function $3(t10, e10, n10 = Bt$1, r10 = false) {
    K$1(t10) && (t10 = ko(t10));
    for (const s10 in t10) {
      const i10 = t10[s10];
      let o10;
      Se(i10) ? "default" in i10 ? o10 = lt(i10.from || s10, i10.default, true) : o10 = lt(i10.from || s10) : o10 = lt(i10), gt(o10) && r10 ? Object.defineProperty(e10, s10, {
        enumerable: true,
        configurable: true,
        get: () => o10.value,
        set: (l10) => o10.value = l10
      }) : e10[s10] = o10;
    }
  }
  function Yc(t10, e10, n10) {
    $t$1(K$1(t10) ? t10.map((r10) => r10.bind(e10.proxy)) : t10.bind(e10.proxy), e10, n10);
  }
  function H3(t10, e10, n10, r10) {
    const s10 = r10.includes(".") ? f3(n10, r10) : () => n10[r10];
    if (Ke$1(t10)) {
      const i10 = e10[t10];
      ue$1(i10) && Yt$1(s10, i10);
    } else if (ue$1(t10))
      Yt$1(s10, t10.bind(n10));
    else if (Se(t10))
      if (K$1(t10))
        t10.forEach((i10) => H3(i10, e10, n10, r10));
      else {
        const i10 = ue$1(t10.handler) ? t10.handler.bind(n10) : e10[t10.handler];
        ue$1(i10) && Yt$1(s10, i10, t10);
      }
  }
  function O0(t10) {
    const e10 = t10.type, { mixins: n10, extends: r10 } = e10, { mixins: s10, optionsCache: i10, config: { optionMergeStrategies: o10 } } = t10.appContext, l10 = i10.get(e10);
    let a10;
    return l10 ? a10 = l10 : !s10.length && !n10 && !r10 ? Ue$1("PRIVATE_APIS", t10) ? (a10 = Oe$1({}, e10), a10.parent = t10.parent && t10.parent.proxy, a10.propsData = t10.vnode.props) : a10 = e10 : (a10 = {}, s10.length && s10.forEach((c10) => Nr(a10, c10, o10, true)), Nr(a10, e10, o10)), Se(e10) && i10.set(e10, a10), a10;
  }
  function Nr(t10, e10, n10, r10 = false) {
    ue$1(e10) && (e10 = e10.options);
    const { mixins: s10, extends: i10 } = e10;
    i10 && Nr(t10, i10, n10, true), s10 && s10.forEach((o10) => Nr(t10, o10, n10, true));
    for (const o10 in e10)
      if (!(r10 && o10 === "expose")) {
        const l10 = Pr[o10] || n10 && n10[o10];
        t10[o10] = l10 ? l10(t10[o10], e10[o10]) : e10[o10];
      }
    return t10;
  }
  const Pr = {
    data: Xc,
    props: nr,
    emits: nr,
    methods: nr,
    computed: nr,
    beforeCreate: Et,
    created: Et,
    beforeMount: Et,
    mounted: Et,
    beforeUpdate: Et,
    updated: Et,
    beforeDestroy: Et,
    beforeUnmount: Et,
    destroyed: Et,
    unmounted: Et,
    activated: Et,
    deactivated: Et,
    errorCaptured: Et,
    serverPrefetch: Et,
    components: nr,
    directives: nr,
    watch: Bd,
    provide: Xc,
    inject: Dd
  };
  Pr.filters = nr;
  function Xc(t10, e10) {
    return e10 ? t10 ? function() {
      return (Ue$1("OPTIONS_DATA_MERGE", null) ? B3 : Oe$1)(ue$1(t10) ? t10.call(this, this) : t10, ue$1(e10) ? e10.call(this, this) : e10);
    } : e10 : t10;
  }
  function Dd(t10, e10) {
    return nr(ko(t10), ko(e10));
  }
  function ko(t10) {
    if (K$1(t10)) {
      const e10 = {};
      for (let n10 = 0; n10 < t10.length; n10++)
        e10[t10[n10]] = t10[n10];
      return e10;
    }
    return t10;
  }
  function Et(t10, e10) {
    return t10 ? [...new Set([].concat(t10, e10))] : e10;
  }
  function nr(t10, e10) {
    return t10 ? Oe$1(Oe$1(/* @__PURE__ */ Object.create(null), t10), e10) : e10;
  }
  function Bd(t10, e10) {
    if (!t10)
      return e10;
    if (!e10)
      return t10;
    const n10 = Oe$1(/* @__PURE__ */ Object.create(null), t10);
    for (const r10 in e10)
      n10[r10] = Et(t10[r10], e10[r10]);
    return n10;
  }
  function $d(t10, e10, n10) {
    return new Proxy({}, {
      get(r10, s10) {
        if (s10 === "$options")
          return O0(t10);
        if (s10 in e10)
          return e10[s10];
        const i10 = t10.type.inject;
        if (i10) {
          if (K$1(i10)) {
            if (i10.includes(s10))
              return lt(s10);
          } else if (s10 in i10)
            return lt(s10);
        }
      }
    });
  }
  function U3(t10, e10) {
    return !!(t10 === "is" || (t10 === "class" || t10 === "style") && Ue$1("INSTANCE_ATTRS_CLASS_STYLE", e10) || Yn(t10) && Ue$1("INSTANCE_LISTENERS", e10) || t10.startsWith("routerView") || t10 === "registerRouteInstance");
  }
  function Hd(t10, e10, n10, r10 = false) {
    const s10 = {}, i10 = {};
    Ti(i10, u1, 1), t10.propsDefaults = /* @__PURE__ */ Object.create(null), V3(t10, e10, s10, i10);
    for (const o10 in t10.propsOptions[0])
      o10 in s10 || (s10[o10] = void 0);
    n10 ? t10.props = r10 ? s10 : Ju(s10) : t10.type.props ? t10.props = s10 : t10.props = i10, t10.attrs = i10;
  }
  function Ud(t10, e10, n10, r10) {
    const { props: s10, attrs: i10, vnode: { patchFlag: o10 } } = t10, l10 = we$1(s10), [a10] = t10.propsOptions;
    let c10 = false;
    if ((r10 || o10 > 0) && !(o10 & 16)) {
      if (o10 & 8) {
        const u10 = t10.vnode.dynamicProps;
        for (let h10 = 0; h10 < u10.length; h10++) {
          let d10 = u10[h10];
          if (i1(t10.emitsOptions, d10))
            continue;
          const p10 = e10[d10];
          if (a10)
            if (Me(i10, d10))
              p10 !== i10[d10] && (i10[d10] = p10, c10 = true);
            else {
              const g = Rt$1(d10);
              s10[g] = Ro(a10, l10, g, p10, t10, false);
            }
          else {
            if (Yn(d10) && d10.endsWith("Native"))
              d10 = d10.slice(0, -6);
            else if (U3(d10, t10))
              continue;
            p10 !== i10[d10] && (i10[d10] = p10, c10 = true);
          }
        }
      }
    } else {
      V3(t10, e10, s10, i10) && (c10 = true);
      let u10;
      for (const h10 in l10)
        (!e10 || !Me(e10, h10) && ((u10 = St$1(h10)) === h10 || !Me(e10, u10))) && (a10 ? n10 && (n10[h10] !== void 0 || n10[u10] !== void 0) && (s10[h10] = Ro(a10, l10, h10, void 0, t10, true)) : delete s10[h10]);
      if (i10 !== l10)
        for (const h10 in i10)
          (!e10 || !Me(e10, h10) && !Me(e10, h10 + "Native")) && (delete i10[h10], c10 = true);
    }
    c10 && kn(t10, "set", "$attrs");
  }
  function V3(t10, e10, n10, r10) {
    const [s10, i10] = t10.propsOptions;
    let o10 = false, l10;
    if (e10)
      for (let a10 in e10) {
        if (os(a10) || (a10.startsWith("onHook:") && Zn("INSTANCE_EVENT_HOOKS", t10, a10.slice(2).toLowerCase()), a10 === "inline-template"))
          continue;
        const c10 = e10[a10];
        let u10;
        if (s10 && Me(s10, u10 = Rt$1(a10)))
          !i10 || !i10.includes(u10) ? n10[u10] = c10 : (l10 || (l10 = {}))[u10] = c10;
        else if (!i1(t10.emitsOptions, a10)) {
          if (Yn(a10) && a10.endsWith("Native"))
            a10 = a10.slice(0, -6);
          else if (U3(a10, t10))
            continue;
          (!(a10 in r10) || c10 !== r10[a10]) && (r10[a10] = c10, o10 = true);
        }
      }
    if (i10) {
      const a10 = we$1(n10), c10 = l10 || Ge$1;
      for (let u10 = 0; u10 < i10.length; u10++) {
        const h10 = i10[u10];
        n10[h10] = Ro(s10, a10, h10, c10[h10], t10, !Me(c10, h10));
      }
    }
    return o10;
  }
  function Ro(t10, e10, n10, r10, s10, i10) {
    const o10 = t10[n10];
    if (o10 != null) {
      const l10 = Me(o10, "default");
      if (l10 && r10 === void 0) {
        const a10 = o10.default;
        if (o10.type !== Function && ue$1(a10)) {
          const { propsDefaults: c10 } = s10;
          n10 in c10 ? r10 = c10[n10] : (mr(s10), r10 = c10[n10] = a10.call(Ue$1("PROPS_DEFAULT_THIS", s10) ? $d(s10, e10) : null, e10), hr());
        } else
          r10 = a10;
      }
      o10[0] && (i10 && !l10 ? r10 = false : o10[1] && (r10 === "" || r10 === St$1(n10)) && (r10 = true));
    }
    return r10;
  }
  function z3(t10, e10, n10 = false) {
    const r10 = e10.propsCache, s10 = r10.get(t10);
    if (s10)
      return s10;
    const i10 = t10.props, o10 = {}, l10 = [];
    let a10 = false;
    if (!ue$1(t10)) {
      const u10 = (h10) => {
        ue$1(h10) && (h10 = h10.options), a10 = true;
        const [d10, p10] = z3(h10, e10, true);
        Oe$1(o10, d10), p10 && l10.push(...p10);
      };
      !n10 && e10.mixins.length && e10.mixins.forEach(u10), t10.extends && u10(t10.extends), t10.mixins && t10.mixins.forEach(u10);
    }
    if (!i10 && !a10)
      return Se(t10) && r10.set(t10, ss), ss;
    if (K$1(i10))
      for (let u10 = 0; u10 < i10.length; u10++) {
        const h10 = Rt$1(i10[u10]);
        Qc(h10) && (o10[h10] = Ge$1);
      }
    else if (i10)
      for (const u10 in i10) {
        const h10 = Rt$1(u10);
        if (Qc(h10)) {
          const d10 = i10[u10], p10 = o10[h10] = K$1(d10) || ue$1(d10) ? { type: d10 } : Object.assign({}, d10);
          if (p10) {
            const g = t2(Boolean, p10.type), L = t2(String, p10.type);
            p10[0] = g > -1, p10[1] = L < 0 || g < L, (g > -1 || Me(p10, "default")) && l10.push(h10);
          }
        }
      }
    const c10 = [o10, l10];
    return Se(t10) && r10.set(t10, c10), c10;
  }
  function Qc(t10) {
    return t10[0] !== "$";
  }
  function Jc(t10) {
    const e10 = t10 && t10.toString().match(/^\s*function (\w+)/);
    return e10 ? e10[1] : t10 === null ? "null" : "";
  }
  function e2(t10, e10) {
    return Jc(t10) === Jc(e10);
  }
  function t2(t10, e10) {
    return K$1(e10) ? e10.findIndex((n10) => e2(n10, t10)) : ue$1(e10) && e2(e10, t10) ? 0 : -1;
  }
  const G3 = (t10) => t10[0] === "_" || t10 === "$stable", zl = (t10) => K$1(t10) ? t10.map(Wt$1) : [Wt$1(t10)], Vd = (t10, e10, n10) => {
    if (e10._n)
      return e10;
    const r10 = jt$1((...s10) => zl(e10(...s10)), n10);
    return r10._c = false, r10;
  }, j3 = (t10, e10, n10) => {
    const r10 = t10._ctx;
    for (const s10 in t10) {
      if (G3(s10))
        continue;
      const i10 = t10[s10];
      if (ue$1(i10))
        e10[s10] = Vd(s10, i10, r10);
      else if (i10 != null) {
        const o10 = zl(i10);
        e10[s10] = () => o10;
      }
    }
  }, Z3 = (t10, e10) => {
    const n10 = zl(e10);
    t10.slots.default = () => n10;
  }, zd = (t10, e10) => {
    if (t10.vnode.shapeFlag & 32) {
      const n10 = e10._;
      n10 ? (t10.slots = we$1(e10), Ti(e10, "_", n10)) : j3(e10, t10.slots = {});
    } else
      t10.slots = {}, e10 && Z3(t10, e10);
    Ti(t10.slots, u1, 1);
  }, Gd = (t10, e10, n10) => {
    const { vnode: r10, slots: s10 } = t10;
    let i10 = true, o10 = Ge$1;
    if (r10.shapeFlag & 32) {
      const l10 = e10._;
      l10 ? n10 && l10 === 1 ? i10 = false : (Oe$1(s10, e10), !n10 && l10 === 1 && delete s10._) : (i10 = !e10.$stable, j3(e10, s10)), o10 = e10;
    } else
      e10 && (Z3(t10, e10), o10 = { default: 1 });
    if (i10)
      for (const l10 in s10)
        !G3(l10) && !(l10 in o10) && delete s10[l10];
  };
  function jd(t10) {
    t10.optionMergeStrategies = new Proxy({}, {
      get(e10, n10) {
        if (n10 in e10)
          return e10[n10];
        if (n10 in Pr && Zn("CONFIG_OPTION_MERGE_STRATS", null))
          return Pr[n10];
      }
    });
  }
  let Ft$1, Sr;
  function Zd(t10, e10) {
    Ft$1 = e10({});
    const n10 = Sr = function a10(c10 = {}) {
      return r10(c10, a10);
    };
    function r10(a10 = {}, c10) {
      _t$1("GLOBAL_MOUNT", null);
      const { data: u10 } = a10;
      u10 && !ue$1(u10) && Zn("OPTIONS_DATA_FN", null) && (a10.data = () => u10);
      const h10 = t10(a10);
      c10 !== n10 && W3(h10, c10);
      const d10 = h10._createRoot(a10);
      return a10.el ? d10.$mount(a10.el) : d10;
    }
    n10.version = "2.6.14-compat:3.2.45", n10.config = Ft$1.config, n10.use = (a10, ...c10) => (a10 && ue$1(a10.install) ? a10.install(n10, ...c10) : ue$1(a10) && a10(n10, ...c10), n10), n10.mixin = (a10) => (Ft$1.mixin(a10), n10), n10.component = (a10, c10) => c10 ? (Ft$1.component(a10, c10), n10) : Ft$1.component(a10), n10.directive = (a10, c10) => c10 ? (Ft$1.directive(a10, c10), n10) : Ft$1.directive(a10), n10.options = { _base: n10 };
    let s10 = 1;
    n10.cid = s10, n10.nextTick = gr;
    const i10 = /* @__PURE__ */ new WeakMap();
    function o10(a10 = {}) {
      if (_t$1("GLOBAL_EXTEND", null), ue$1(a10) && (a10 = a10.options), i10.has(a10))
        return i10.get(a10);
      const c10 = this;
      function u10(d10) {
        return r10(d10 ? Nr(Oe$1({}, u10.options), d10, Pr) : u10.options, u10);
      }
      u10.super = c10, u10.prototype = Object.create(n10.prototype), u10.prototype.constructor = u10;
      const h10 = {};
      for (const d10 in c10.options) {
        const p10 = c10.options[d10];
        h10[d10] = K$1(p10) ? p10.slice() : Se(p10) ? Oe$1(/* @__PURE__ */ Object.create(null), p10) : p10;
      }
      return u10.options = Nr(h10, a10, Pr), u10.options._base = u10, u10.extend = o10.bind(u10), u10.mixin = c10.mixin, u10.use = c10.use, u10.cid = ++s10, i10.set(a10, u10), u10;
    }
    n10.extend = o10.bind(n10), n10.set = (a10, c10, u10) => {
      _t$1("GLOBAL_SET", null), a10[c10] = u10;
    }, n10.delete = (a10, c10) => {
      _t$1("GLOBAL_DELETE", null), delete a10[c10];
    }, n10.observable = (a10) => (_t$1("GLOBAL_OBSERVABLE", null), Rn$1(a10)), n10.filter = (a10, c10) => c10 ? (Ft$1.filter(a10, c10), n10) : Ft$1.filter(a10);
    const l10 = {
      warn: Bt$1,
      extend: Oe$1,
      mergeOptions: (a10, c10, u10) => Nr(a10, c10, u10 ? void 0 : Pr),
      defineReactive: ef
    };
    return Object.defineProperty(n10, "util", {
      get() {
        return _t$1("GLOBAL_PRIVATE_UTIL", null), l10;
      }
    }), n10.configureCompat = K8, n10;
  }
  function Wd(t10, e10, n10) {
    qd(t10, e10), jd(t10.config), Ft$1 && (Xd(t10, e10, n10), Kd(t10), Yd(t10));
  }
  function qd(t10, e10) {
    e10.filters = {}, t10.filter = (n10, r10) => (_t$1("FILTERS", null), r10 ? (e10.filters[n10] = r10, t10) : e10.filters[n10]);
  }
  function Kd(t10) {
    Object.defineProperties(t10, {
      prototype: {
        get() {
          return t10.config.globalProperties;
        }
      },
      nextTick: { value: gr },
      extend: { value: Sr.extend },
      set: { value: Sr.set },
      delete: { value: Sr.delete },
      observable: { value: Sr.observable },
      util: {
        get() {
          return Sr.util;
        }
      }
    });
  }
  function Yd(t10) {
    t10._context.mixins = [...Ft$1._context.mixins], ["components", "directives", "filters"].forEach((e10) => {
      t10._context[e10] = Object.create(Ft$1._context[e10]);
    });
    for (const e10 in Ft$1.config) {
      if (e10 === "isNativeTag" || Po() && (e10 === "isCustomElement" || e10 === "compilerOptions"))
        continue;
      const n10 = Ft$1.config[e10];
      t10.config[e10] = Se(n10) ? Object.create(n10) : n10, e10 === "ignoredElements" && Ue$1("CONFIG_IGNORED_ELEMENTS", null) && !Po() && K$1(n10) && (t10.config.compilerOptions.isCustomElement = (r10) => n10.some((s10) => Ke$1(s10) ? s10 === r10 : s10.test(r10)));
    }
    W3(t10, Sr);
  }
  function W3(t10, e10) {
    const n10 = Ue$1("GLOBAL_PROTOTYPE", null);
    n10 && (t10.config.globalProperties = Object.create(e10.prototype));
    const r10 = Object.getOwnPropertyDescriptors(e10.prototype);
    for (const s10 in r10)
      s10 !== "constructor" && n10 && Object.defineProperty(t10.config.globalProperties, s10, r10[s10]);
  }
  function Xd(t10, e10, n10) {
    let r10 = false;
    t10._createRoot = (s10) => {
      const i10 = t10._component, o10 = V$1(i10, s10.propsData || null);
      o10.appContext = e10;
      const l10 = !ue$1(i10) && !i10.render && !i10.template, a10 = () => {
      }, c10 = jl(o10, null, null);
      return l10 && (c10.render = a10), Zl(c10), o10.component = c10, o10.isCompatRoot = true, c10.ctx._compat_mount = (u10) => {
        if (r10)
          return;
        let h10;
        if (typeof u10 == "string") {
          const p10 = document.querySelector(u10);
          if (!p10)
            return;
          h10 = p10;
        } else
          h10 = u10 || document.createElement("div");
        const d10 = h10 instanceof SVGElement;
        return l10 && c10.render === a10 && (c10.render = null, i10.template = h10.innerHTML, Wl(c10, false, true)), h10.innerHTML = "", n10(o10, h10, d10), h10 instanceof Element && (h10.removeAttribute("v-cloak"), h10.setAttribute("data-v-app", "")), r10 = true, t10._container = h10, h10.__vue_app__ = t10, c10.proxy;
      }, c10.ctx._compat_destroy = () => {
        if (r10)
          n10(null, t10._container), delete t10._container.__vue_app__;
        else {
          const { bum: u10, scope: h10, um: d10 } = c10;
          u10 && cr(u10), Ue$1("INSTANCE_EVENT_HOOKS", c10) && c10.emit("hook:beforeDestroy"), h10 && h10.stop(), d10 && cr(d10), Ue$1("INSTANCE_EVENT_HOOKS", c10) && c10.emit("hook:destroyed");
        }
      }, c10.proxy;
    };
  }
  const Qd = [
    "push",
    "pop",
    "shift",
    "unshift",
    "splice",
    "sort",
    "reverse"
  ], Jd = /* @__PURE__ */ new WeakSet();
  function ef(t10, e10, n10) {
    if (Se(n10) && !Un(n10) && !Jd.has(n10)) {
      const s10 = Rn$1(n10);
      K$1(n10) ? Qd.forEach((i10) => {
        n10[i10] = (...o10) => {
          Array.prototype[i10].call(s10, ...o10);
        };
      }) : Object.keys(n10).forEach((i10) => {
        try {
          Y1(n10, i10, n10[i10]);
        } catch {
        }
      });
    }
    const r10 = t10.$;
    r10 && t10 === r10.proxy ? (Y1(r10.ctx, e10, n10), r10.accessCache = /* @__PURE__ */ Object.create(null)) : Un(t10) ? t10[e10] = n10 : Y1(t10, e10, n10);
  }
  function Y1(t10, e10, n10) {
    n10 = Se(n10) ? Rn$1(n10) : n10, Object.defineProperty(t10, e10, {
      enumerable: true,
      configurable: true,
      get() {
        return Ht$1(t10, "get", e10), n10;
      },
      set(r10) {
        n10 = Se(r10) ? Rn$1(r10) : r10, kn(t10, "set", e10, r10);
      }
    });
  }
  function q3() {
    return {
      app: null,
      config: {
        isNativeTag: X6,
        performance: false,
        globalProperties: {},
        optionMergeStrategies: {},
        errorHandler: void 0,
        warnHandler: void 0,
        compilerOptions: {}
      },
      mixins: [],
      components: {},
      directives: {},
      provides: /* @__PURE__ */ Object.create(null),
      optionsCache: /* @__PURE__ */ new WeakMap(),
      propsCache: /* @__PURE__ */ new WeakMap(),
      emitsCache: /* @__PURE__ */ new WeakMap()
    };
  }
  let tf = 0;
  function nf(t10, e10) {
    return function(r10, s10 = null) {
      ue$1(r10) || (r10 = Object.assign({}, r10)), s10 != null && !Se(s10) && (s10 = null);
      const i10 = q3(), o10 = /* @__PURE__ */ new Set();
      let l10 = false;
      const a10 = i10.app = {
        _uid: tf++,
        _component: r10,
        _props: s10,
        _container: null,
        _context: i10,
        _instance: null,
        version: u5,
        get config() {
          return i10.config;
        },
        set config(c10) {
        },
        use(c10, ...u10) {
          return o10.has(c10) || (c10 && ue$1(c10.install) ? (o10.add(c10), c10.install(a10, ...u10)) : ue$1(c10) && (o10.add(c10), c10(a10, ...u10))), a10;
        },
        mixin(c10) {
          return i10.mixins.includes(c10) || i10.mixins.push(c10), a10;
        },
        component(c10, u10) {
          return u10 ? (i10.components[c10] = u10, a10) : i10.components[c10];
        },
        directive(c10, u10) {
          return u10 ? (i10.directives[c10] = u10, a10) : i10.directives[c10];
        },
        mount(c10, u10, h10) {
          if (!l10) {
            const d10 = V$1(r10, s10);
            return d10.appContext = i10, u10 && e10 ? e10(d10, c10) : t10(d10, c10, h10), l10 = true, a10._container = c10, c10.__vue_app__ = a10, p1(d10.component) || d10.component.proxy;
          }
        },
        unmount() {
          l10 && (t10(null, a10._container), delete a10._container.__vue_app__);
        },
        provide(c10, u10) {
          return i10.provides[c10] = u10, a10;
        }
      };
      return Wd(a10, i10, t10), a10;
    };
  }
  function ki(t10, e10, n10, r10, s10 = false) {
    if (K$1(t10)) {
      t10.forEach((d10, p10) => ki(d10, e10 && (K$1(e10) ? e10[p10] : e10), n10, r10, s10));
      return;
    }
    if (Mr(r10) && !s10)
      return;
    const i10 = r10.shapeFlag & 4 ? p1(r10.component) || r10.component.proxy : r10.el, o10 = s10 ? null : i10, { i: l10, r: a10 } = t10, c10 = e10 && e10.r, u10 = l10.refs === Ge$1 ? l10.refs = {} : l10.refs, h10 = l10.setupState;
    if (c10 != null && c10 !== a10 && (Ke$1(c10) ? (u10[c10] = null, Me(h10, c10) && (h10[c10] = null)) : gt(c10) && (c10.value = null)), ue$1(a10))
      En$1(a10, l10, 12, [o10, u10]);
    else {
      const d10 = Ke$1(a10), p10 = gt(a10);
      if (d10 || p10) {
        const g = () => {
          if (t10.f) {
            const L = d10 ? Me(h10, a10) ? h10[a10] : u10[a10] : a10.value;
            s10 ? K$1(L) && _l(L, i10) : K$1(L) ? L.includes(i10) || L.push(i10) : d10 ? (u10[a10] = [i10], Me(h10, a10) && (h10[a10] = u10[a10])) : (a10.value = [i10], t10.k && (u10[t10.k] = a10.value));
          } else
            d10 ? (u10[a10] = o10, Me(h10, a10) && (h10[a10] = o10)) : p10 && (a10.value = o10, t10.k && (u10[t10.k] = o10));
        };
        o10 ? (g.id = -1, at(g, n10)) : g();
      }
    }
  }
  let er = false;
  const oi = (t10) => /svg/.test(t10.namespaceURI) && t10.tagName !== "foreignObject", li = (t10) => t10.nodeType === 8;
  function rf(t10) {
    const { mt: e10, p: n10, o: { patchProp: r10, createText: s10, nextSibling: i10, parentNode: o10, remove: l10, insert: a10, createComment: c10 } } = t10, u10 = (_10, x) => {
      if (!x.hasChildNodes()) {
        n10(null, _10, x), Si(), x._vnode = _10;
        return;
      }
      er = false, h10(x.firstChild, _10, null, null, null), Si(), x._vnode = _10, er && console.error("Hydration completed but contains mismatches.");
    }, h10 = (_10, x, C, E, M10, $ = false) => {
      const j = li(_10) && _10.data === "[", R = () => L(_10, x, C, E, M10, j), { type: ae2, ref: le2, shapeFlag: he, patchFlag: He2 } = x;
      let Le2 = _10.nodeType;
      x.el = _10, He2 === -2 && ($ = false, x.dynamicChildren = null);
      let re2 = null;
      switch (ae2) {
        case Ur:
          Le2 !== 3 ? x.children === "" ? (a10(x.el = s10(""), o10(_10), _10), re2 = _10) : re2 = R() : (_10.data !== x.children && (er = true, _10.data = x.children), re2 = i10(_10));
          break;
        case yt:
          Le2 !== 8 || j ? re2 = R() : re2 = i10(_10);
          break;
        case Fr:
          if (j && (_10 = i10(_10), Le2 = _10.nodeType), Le2 === 1 || Le2 === 3) {
            re2 = _10;
            const Ne2 = !x.children.length;
            for (let D10 = 0; D10 < x.staticCount; D10++)
              Ne2 && (x.children += re2.nodeType === 1 ? re2.outerHTML : re2.data), D10 === x.staticCount - 1 && (x.anchor = re2), re2 = i10(re2);
            return j ? i10(re2) : re2;
          } else
            R();
          break;
        case Fe$1:
          j ? re2 = g(_10, x, C, E, M10, $) : re2 = R();
          break;
        default:
          if (he & 1)
            Le2 !== 1 || x.type.toLowerCase() !== _10.tagName.toLowerCase() ? re2 = R() : re2 = d10(_10, x, C, E, M10, $);
          else if (he & 6) {
            x.slotScopeIds = M10;
            const Ne2 = o10(_10);
            if (e10(x, Ne2, null, C, E, oi(Ne2), $), re2 = j ? T(_10) : i10(_10), re2 && li(re2) && re2.data === "teleport end" && (re2 = i10(re2)), Mr(x)) {
              let D10;
              j ? (D10 = V$1(Fe$1), D10.anchor = re2 ? re2.previousSibling : Ne2.lastChild) : D10 = _10.nodeType === 3 ? dn$1("") : V$1("div"), D10.el = _10, x.component.subTree = D10;
            }
          } else
            he & 64 ? Le2 !== 8 ? re2 = R() : re2 = x.type.hydrate(_10, x, C, E, M10, $, t10, p10) : he & 128 && (re2 = x.type.hydrate(_10, x, C, E, oi(o10(_10)), M10, $, t10, h10));
      }
      return le2 != null && ki(le2, null, E, x), re2;
    }, d10 = (_10, x, C, E, M10, $) => {
      $ = $ || !!x.dynamicChildren;
      const { type: j, props: R, patchFlag: ae2, shapeFlag: le2, dirs: he } = x, He2 = j === "input" && he || j === "option";
      if (He2 || ae2 !== -1) {
        if (he && yn$1(x, null, C, "created"), R)
          if (He2 || !$ || ae2 & 48)
            for (const re2 in R)
              (He2 && re2.endsWith("value") || Yn(re2) && !os(re2)) && r10(_10, re2, null, R[re2], false, void 0, C);
          else
            R.onClick && r10(_10, "onClick", null, R.onClick, false, void 0, C);
        let Le2;
        if ((Le2 = R && R.onVnodeBeforeMount) && Nt$1(Le2, C, x), he && yn$1(x, null, C, "beforeMount"), ((Le2 = R && R.onVnodeMounted) || he) && h3(() => {
          Le2 && Nt$1(Le2, C, x), he && yn$1(x, null, C, "mounted");
        }, E), le2 & 16 && !(R && (R.innerHTML || R.textContent))) {
          let re2 = p10(_10.firstChild, x, _10, C, E, M10, $);
          for (; re2; ) {
            er = true;
            const Ne2 = re2;
            re2 = re2.nextSibling, l10(Ne2);
          }
        } else
          le2 & 8 && _10.textContent !== x.children && (er = true, _10.textContent = x.children);
      }
      return _10.nextSibling;
    }, p10 = (_10, x, C, E, M10, $, j) => {
      j = j || !!x.dynamicChildren;
      const R = x.children, ae2 = R.length;
      for (let le2 = 0; le2 < ae2; le2++) {
        const he = j ? R[le2] : R[le2] = Wt$1(R[le2]);
        if (_10)
          _10 = h10(_10, he, E, M10, $, j);
        else {
          if (he.type === Ur && !he.children)
            continue;
          er = true, n10(null, he, C, null, E, M10, oi(C), $);
        }
      }
      return _10;
    }, g = (_10, x, C, E, M10, $) => {
      const { slotScopeIds: j } = x;
      j && (M10 = M10 ? M10.concat(j) : j);
      const R = o10(_10), ae2 = p10(i10(_10), x, R, C, E, M10, $);
      return ae2 && li(ae2) && ae2.data === "]" ? i10(x.anchor = ae2) : (er = true, a10(x.anchor = c10("]"), R, ae2), ae2);
    }, L = (_10, x, C, E, M10, $) => {
      if (er = true, x.el = null, $) {
        const ae2 = T(_10);
        for (; ; ) {
          const le2 = i10(_10);
          if (le2 && le2 !== ae2)
            l10(le2);
          else
            break;
        }
      }
      const j = i10(_10), R = o10(_10);
      return l10(_10), n10(null, x, R, j, C, E, oi(R), M10), j;
    }, T = (_10) => {
      let x = 0;
      for (; _10; )
        if (_10 = i10(_10), _10 && li(_10) && (_10.data === "[" && x++, _10.data === "]")) {
          if (x === 0)
            return i10(_10);
          x--;
        }
      return _10;
    };
    return [u10, h10];
  }
  const at = h3;
  function K3(t10) {
    return X3(t10);
  }
  function Y3(t10) {
    return X3(t10, rf);
  }
  function X3(t10, e10) {
    const n10 = r8();
    n10.__VUE__ = true;
    const { insert: r10, remove: s10, patchProp: i10, createElement: o10, createText: l10, createComment: a10, setText: c10, setElementText: u10, parentNode: h10, nextSibling: d10, setScopeId: p10 = Bt$1, insertStaticContent: g } = t10, L = (m, y10, S, I10 = null, O = null, H = null, Y10 = false, U10 = null, z = !!y10.dynamicChildren) => {
      if (m === y10)
        return;
      m && !vn$1(m, y10) && (I10 = tt(m), it(m, O, H, true), m = null), y10.patchFlag === -2 && (z = false, y10.dynamicChildren = null);
      const { type: P, ref: F, shapeFlag: ie2 } = y10;
      switch (P) {
        case Ur:
          T(m, y10, S, I10);
          break;
        case yt:
          _10(m, y10, S, I10);
          break;
        case Fr:
          m == null && x(y10, S, I10, Y10);
          break;
        case Fe$1:
          He2(m, y10, S, I10, O, H, Y10, U10, z);
          break;
        default:
          ie2 & 1 ? M10(m, y10, S, I10, O, H, Y10, U10, z) : ie2 & 6 ? Le2(m, y10, S, I10, O, H, Y10, U10, z) : (ie2 & 64 || ie2 & 128) && P.process(m, y10, S, I10, O, H, Y10, U10, z, mt);
      }
      F != null && O && ki(F, m && m.ref, H, y10 || m, !y10);
    }, T = (m, y10, S, I10) => {
      if (m == null)
        r10(y10.el = l10(y10.children), S, I10);
      else {
        const O = y10.el = m.el;
        y10.children !== m.children && c10(O, y10.children);
      }
    }, _10 = (m, y10, S, I10) => {
      m == null ? r10(y10.el = a10(y10.children || ""), S, I10) : y10.el = m.el;
    }, x = (m, y10, S, I10) => {
      [m.el, m.anchor] = g(m.children, y10, S, I10, m.el, m.anchor);
    }, C = ({ el: m, anchor: y10 }, S, I10) => {
      let O;
      for (; m && m !== y10; )
        O = d10(m), r10(m, S, I10), m = O;
      r10(y10, S, I10);
    }, E = ({ el: m, anchor: y10 }) => {
      let S;
      for (; m && m !== y10; )
        S = d10(m), s10(m), m = S;
      s10(y10);
    }, M10 = (m, y10, S, I10, O, H, Y10, U10, z) => {
      Y10 = Y10 || y10.type === "svg", m == null ? $(y10, S, I10, O, H, Y10, U10, z) : ae2(m, y10, O, H, Y10, U10, z);
    }, $ = (m, y10, S, I10, O, H, Y10, U10) => {
      let z, P;
      const { type: F, props: ie2, shapeFlag: Q, transition: ne2, dirs: be2 } = m;
      if (z = m.el = o10(m.type, H, ie2 && ie2.is, ie2), Q & 8 ? u10(z, m.children) : Q & 16 && R(m.children, z, null, I10, O, H && F !== "foreignObject", Y10, U10), be2 && yn$1(m, null, I10, "created"), ie2) {
        for (const De2 in ie2)
          De2 !== "value" && !os(De2) && i10(z, De2, null, ie2[De2], H, m.children, I10, O, ke2);
        "value" in ie2 && i10(z, "value", null, ie2.value), (P = ie2.onVnodeBeforeMount) && Nt$1(P, I10, m);
      }
      j(z, m, m.scopeId, Y10, I10), be2 && yn$1(m, null, I10, "beforeMount");
      const Pe2 = (!O || O && !O.pendingBranch) && ne2 && !ne2.persisted;
      Pe2 && ne2.beforeEnter(z), r10(z, y10, S), ((P = ie2 && ie2.onVnodeMounted) || Pe2 || be2) && at(() => {
        P && Nt$1(P, I10, m), Pe2 && ne2.enter(z), be2 && yn$1(m, null, I10, "mounted");
      }, O);
    }, j = (m, y10, S, I10, O) => {
      if (S && p10(m, S), I10)
        for (let H = 0; H < I10.length; H++)
          p10(m, I10[H]);
      if (O) {
        let H = O.subTree;
        if (y10 === H) {
          const Y10 = O.vnode;
          j(m, Y10, Y10.scopeId, Y10.slotScopeIds, O.parent);
        }
      }
    }, R = (m, y10, S, I10, O, H, Y10, U10, z = 0) => {
      for (let P = z; P < m.length; P++) {
        const F = m[P] = U10 ? rr(m[P]) : Wt$1(m[P]);
        L(null, F, y10, S, I10, O, H, Y10, U10);
      }
    }, ae2 = (m, y10, S, I10, O, H, Y10) => {
      const U10 = y10.el = m.el;
      let { patchFlag: z, dynamicChildren: P, dirs: F } = y10;
      z |= m.patchFlag & 16;
      const ie2 = m.props || Ge$1, Q = y10.props || Ge$1;
      let ne2;
      S && vr(S, false), (ne2 = Q.onVnodeBeforeUpdate) && Nt$1(ne2, S, y10, m), F && yn$1(y10, m, S, "beforeUpdate"), S && vr(S, true);
      const be2 = O && y10.type !== "foreignObject";
      if (P ? le2(m.dynamicChildren, P, U10, S, I10, be2, H) : Y10 || de2(m, y10, U10, null, S, I10, be2, H, false), z > 0) {
        if (z & 16)
          he(U10, y10, ie2, Q, S, I10, O);
        else if (z & 2 && ie2.class !== Q.class && i10(U10, "class", null, Q.class, O), z & 4 && i10(U10, "style", ie2.style, Q.style, O), z & 8) {
          const Pe2 = y10.dynamicProps;
          for (let De2 = 0; De2 < Pe2.length; De2++) {
            const Je2 = Pe2[De2], J10 = ie2[Je2], ce2 = Q[Je2];
            (ce2 !== J10 || Je2 === "value") && i10(U10, Je2, J10, ce2, O, m.children, S, I10, ke2);
          }
        }
        z & 1 && m.children !== y10.children && u10(U10, y10.children);
      } else
        !Y10 && P == null && he(U10, y10, ie2, Q, S, I10, O);
      ((ne2 = Q.onVnodeUpdated) || F) && at(() => {
        ne2 && Nt$1(ne2, S, y10, m), F && yn$1(y10, m, S, "updated");
      }, I10);
    }, le2 = (m, y10, S, I10, O, H, Y10) => {
      for (let U10 = 0; U10 < y10.length; U10++) {
        const z = m[U10], P = y10[U10], F = z.el && (z.type === Fe$1 || !vn$1(z, P) || z.shapeFlag & 70) ? h10(z.el) : S;
        L(z, P, F, null, I10, O, H, Y10, true);
      }
    }, he = (m, y10, S, I10, O, H, Y10) => {
      if (S !== I10) {
        if (S !== Ge$1)
          for (const U10 in S)
            !os(U10) && !(U10 in I10) && i10(m, U10, S[U10], null, Y10, y10.children, O, H, ke2);
        for (const U10 in I10) {
          if (os(U10))
            continue;
          const z = I10[U10], P = S[U10];
          z !== P && U10 !== "value" && i10(m, U10, P, z, Y10, y10.children, O, H, ke2);
        }
        "value" in I10 && i10(m, "value", S.value, I10.value);
      }
    }, He2 = (m, y10, S, I10, O, H, Y10, U10, z) => {
      const P = y10.el = m ? m.el : l10(""), F = y10.anchor = m ? m.anchor : l10("");
      let { patchFlag: ie2, dynamicChildren: Q, slotScopeIds: ne2 } = y10;
      ne2 && (U10 = U10 ? U10.concat(ne2) : ne2), m == null ? (r10(P, S, I10), r10(F, S, I10), R(y10.children, S, F, O, H, Y10, U10, z)) : ie2 > 0 && ie2 & 64 && Q && m.dynamicChildren ? (le2(m.dynamicChildren, Q, S, O, H, Y10, U10), (y10.key != null || O && y10 === O.subTree) && Gl(m, y10, true)) : de2(m, y10, S, F, O, H, Y10, U10, z);
    }, Le2 = (m, y10, S, I10, O, H, Y10, U10, z) => {
      y10.slotScopeIds = U10, m == null ? y10.shapeFlag & 512 ? O.ctx.activate(y10, S, I10, Y10, z) : re2(y10, S, I10, O, H, Y10, z) : Ne2(m, y10, z);
    }, re2 = (m, y10, S, I10, O, H, Y10) => {
      const U10 = m.isCompatRoot && m.component, z = U10 || (m.component = jl(m, I10, O));
      if (k0(m) && (z.ctx.renderer = mt), U10 || Zl(z), z.asyncDep) {
        if (O && O.registerDep(z, D10), !m.el) {
          const P = z.subTree = V$1(yt);
          _10(null, P, y10, S);
        }
        return;
      }
      D10(z, m, y10, S, O, H, Y10);
    }, Ne2 = (m, y10, S) => {
      const I10 = y10.component = m.component;
      if (id(m, y10, S))
        if (I10.asyncDep && !I10.asyncResolved) {
          X10(I10, y10, S);
          return;
        } else
          I10.next = y10, Z8(I10.update), I10.update();
      else
        y10.el = m.el, I10.vnode = y10;
    }, D10 = (m, y10, S, I10, O, H, Y10) => {
      const U10 = () => {
        if (m.isMounted) {
          let { next: F, bu: ie2, u: Q, parent: ne2, vnode: be2 } = m, Pe2 = F, De2;
          vr(m, false), F ? (F.el = be2.el, X10(m, F, Y10)) : F = be2, ie2 && cr(ie2), (De2 = F.props && F.props.onVnodeBeforeUpdate) && Nt$1(De2, ne2, F, be2), Ue$1("INSTANCE_EVENT_HOOKS", m) && m.emit("hook:beforeUpdate"), vr(m, true);
          const Je2 = yi(m), J10 = m.subTree;
          m.subTree = Je2, L(
            J10,
            Je2,
            h10(J10.el),
            tt(J10),
            m,
            O,
            H
          ), F.el = Je2.el, Pe2 === null && Dl(m, Je2.el), Q && at(Q, O), (De2 = F.props && F.props.onVnodeUpdated) && at(() => Nt$1(De2, ne2, F, be2), O), Ue$1("INSTANCE_EVENT_HOOKS", m) && at(() => m.emit("hook:updated"), O);
        } else {
          let F;
          const { el: ie2, props: Q } = y10, { bm: ne2, m: be2, parent: Pe2 } = m, De2 = Mr(y10);
          if (vr(m, false), ne2 && cr(ne2), !De2 && (F = Q && Q.onVnodeBeforeMount) && Nt$1(F, Pe2, y10), Ue$1("INSTANCE_EVENT_HOOKS", m) && m.emit("hook:beforeMount"), vr(m, true), ie2 && Mt2) {
            const Je2 = () => {
              m.subTree = yi(m), Mt2(ie2, m.subTree, m, O, null);
            };
            De2 ? y10.type.__asyncLoader().then(
              () => !m.isUnmounted && Je2()
            ) : Je2();
          } else {
            const Je2 = m.subTree = yi(m);
            L(null, Je2, S, I10, m, O, H), y10.el = Je2.el;
          }
          if (be2 && at(be2, O), !De2 && (F = Q && Q.onVnodeMounted)) {
            const Je2 = y10;
            at(() => Nt$1(F, Pe2, Je2), O);
          }
          Ue$1("INSTANCE_EVENT_HOOKS", m) && at(() => m.emit("hook:mounted"), O), (y10.shapeFlag & 256 || Pe2 && Mr(Pe2.vnode) && Pe2.vnode.shapeFlag & 256) && (m.a && at(m.a, O), Ue$1("INSTANCE_EVENT_HOOKS", m) && at(() => m.emit("hook:activated"), O)), m.isMounted = true, y10 = S = I10 = null;
        }
      }, z = m.effect = new S0(
        U10,
        () => n1(P),
        m.scope
      ), P = m.update = () => z.run();
      P.id = m.uid, vr(m, true), P();
    }, X10 = (m, y10, S) => {
      y10.component = m;
      const I10 = m.vnode.props;
      m.vnode = y10, m.next = null, Ud(m, y10.props, I10, S), Gd(m, y10.children, S), Es(), Hc(), Ts();
    }, de2 = (m, y10, S, I10, O, H, Y10, U10, z = false) => {
      const P = m && m.children, F = m ? m.shapeFlag : 0, ie2 = y10.children, { patchFlag: Q, shapeFlag: ne2 } = y10;
      if (Q > 0) {
        if (Q & 128) {
          Qe2(P, ie2, S, I10, O, H, Y10, U10, z);
          return;
        } else if (Q & 256) {
          Xe2(P, ie2, S, I10, O, H, Y10, U10, z);
          return;
        }
      }
      ne2 & 8 ? (F & 16 && ke2(P, O, H), ie2 !== P && u10(S, ie2)) : F & 16 ? ne2 & 16 ? Qe2(P, ie2, S, I10, O, H, Y10, U10, z) : ke2(P, O, H, true) : (F & 8 && u10(S, ""), ne2 & 16 && R(ie2, S, I10, O, H, Y10, U10, z));
    }, Xe2 = (m, y10, S, I10, O, H, Y10, U10, z) => {
      m = m || ss, y10 = y10 || ss;
      const P = m.length, F = y10.length, ie2 = Math.min(P, F);
      let Q;
      for (Q = 0; Q < ie2; Q++) {
        const ne2 = y10[Q] = z ? rr(y10[Q]) : Wt$1(y10[Q]);
        L(m[Q], ne2, S, null, O, H, Y10, U10, z);
      }
      P > F ? ke2(m, O, H, true, false, ie2) : R(y10, S, I10, O, H, Y10, U10, z, ie2);
    }, Qe2 = (m, y10, S, I10, O, H, Y10, U10, z) => {
      let P = 0;
      const F = y10.length;
      let ie2 = m.length - 1, Q = F - 1;
      for (; P <= ie2 && P <= Q; ) {
        const ne2 = m[P], be2 = y10[P] = z ? rr(y10[P]) : Wt$1(y10[P]);
        if (vn$1(ne2, be2))
          L(ne2, be2, S, null, O, H, Y10, U10, z);
        else
          break;
        P++;
      }
      for (; P <= ie2 && P <= Q; ) {
        const ne2 = m[ie2], be2 = y10[Q] = z ? rr(y10[Q]) : Wt$1(y10[Q]);
        if (vn$1(ne2, be2))
          L(ne2, be2, S, null, O, H, Y10, U10, z);
        else
          break;
        ie2--, Q--;
      }
      if (P > ie2) {
        if (P <= Q) {
          const ne2 = Q + 1, be2 = ne2 < F ? y10[ne2].el : I10;
          for (; P <= Q; )
            L(null, y10[P] = z ? rr(y10[P]) : Wt$1(y10[P]), S, be2, O, H, Y10, U10, z), P++;
        }
      } else if (P > Q)
        for (; P <= ie2; )
          it(m[P], O, H, true), P++;
      else {
        const ne2 = P, be2 = P, Pe2 = /* @__PURE__ */ new Map();
        for (P = be2; P <= Q; P++) {
          const ft = y10[P] = z ? rr(y10[P]) : Wt$1(y10[P]);
          ft.key != null && Pe2.set(ft.key, P);
        }
        let De2, Je2 = 0;
        const J10 = Q - be2 + 1;
        let ce2 = false, Ee2 = 0;
        const Ie = new Array(J10);
        for (P = 0; P < J10; P++)
          Ie[P] = 0;
        for (P = ne2; P <= ie2; P++) {
          const ft = m[P];
          if (Je2 >= J10) {
            it(ft, O, H, true);
            continue;
          }
          let nn2;
          if (ft.key != null)
            nn2 = Pe2.get(ft.key);
          else
            for (De2 = be2; De2 <= Q; De2++)
              if (Ie[De2 - be2] === 0 && vn$1(ft, y10[De2])) {
                nn2 = De2;
                break;
              }
          nn2 === void 0 ? it(ft, O, H, true) : (Ie[nn2 - be2] = P + 1, nn2 >= Ee2 ? Ee2 = nn2 : ce2 = true, L(ft, y10[nn2], S, null, O, H, Y10, U10, z), Je2++);
        }
        const xt = ce2 ? sf(Ie) : ss;
        for (De2 = xt.length - 1, P = J10 - 1; P >= 0; P--) {
          const ft = be2 + P, nn2 = y10[ft], Ac = ft + 1 < F ? y10[ft + 1].el : I10;
          Ie[P] === 0 ? L(null, nn2, S, Ac, O, H, Y10, U10, z) : ce2 && (De2 < 0 || P !== xt[De2] ? Ot(nn2, S, Ac, 2) : De2--);
        }
      }
    }, Ot = (m, y10, S, I10, O = null) => {
      const { el: H, type: Y10, transition: U10, children: z, shapeFlag: P } = m;
      if (P & 6) {
        Ot(m.component.subTree, y10, S, I10);
        return;
      }
      if (P & 128) {
        m.suspense.move(y10, S, I10);
        return;
      }
      if (P & 64) {
        Y10.move(m, y10, S, mt);
        return;
      }
      if (Y10 === Fe$1) {
        r10(H, y10, S);
        for (let ie2 = 0; ie2 < z.length; ie2++)
          Ot(z[ie2], y10, S, I10);
        r10(m.anchor, y10, S);
        return;
      }
      if (Y10 === Fr) {
        C(m, y10, S);
        return;
      }
      if (I10 !== 2 && P & 1 && U10)
        if (I10 === 0)
          U10.beforeEnter(H), r10(H, y10, S), at(() => U10.enter(H), O);
        else {
          const { leave: ie2, delayLeave: Q, afterLeave: ne2 } = U10, be2 = () => r10(H, y10, S), Pe2 = () => {
            ie2(H, () => {
              be2(), ne2 && ne2();
            });
          };
          Q ? Q(H, be2, Pe2) : Pe2();
        }
      else
        r10(H, y10, S);
    }, it = (m, y10, S, I10 = false, O = false) => {
      const { type: H, props: Y10, ref: U10, children: z, dynamicChildren: P, shapeFlag: F, patchFlag: ie2, dirs: Q } = m;
      if (U10 != null && ki(U10, null, S, m, true), F & 256) {
        y10.ctx.deactivate(m);
        return;
      }
      const ne2 = F & 1 && Q, be2 = !Mr(m);
      let Pe2;
      if (be2 && (Pe2 = Y10 && Y10.onVnodeBeforeUnmount) && Nt$1(Pe2, y10, m), F & 6)
        Ae(m.component, S, I10);
      else {
        if (F & 128) {
          m.suspense.unmount(S, I10);
          return;
        }
        ne2 && yn$1(m, null, y10, "beforeUnmount"), F & 64 ? m.type.remove(m, y10, S, O, mt, I10) : P && (H !== Fe$1 || ie2 > 0 && ie2 & 64) ? ke2(P, y10, S, false, true) : (H === Fe$1 && ie2 & 384 || !O && F & 16) && ke2(z, y10, S), I10 && N(m);
      }
      (be2 && (Pe2 = Y10 && Y10.onVnodeUnmounted) || ne2) && at(() => {
        Pe2 && Nt$1(Pe2, y10, m), ne2 && yn$1(m, null, y10, "unmounted");
      }, S);
    }, N = (m) => {
      const { type: y10, el: S, anchor: I10, transition: O } = m;
      if (y10 === Fe$1) {
        se2(S, I10);
        return;
      }
      if (y10 === Fr) {
        E(m);
        return;
      }
      const H = () => {
        s10(S), O && !O.persisted && O.afterLeave && O.afterLeave();
      };
      if (m.shapeFlag & 1 && O && !O.persisted) {
        const { leave: Y10, delayLeave: U10 } = O, z = () => Y10(S, H);
        U10 ? U10(m.el, H, z) : z();
      } else
        H();
    }, se2 = (m, y10) => {
      let S;
      for (; m !== y10; )
        S = d10(m), s10(m), m = S;
      s10(y10);
    }, Ae = (m, y10, S) => {
      const { bum: I10, scope: O, update: H, subTree: Y10, um: U10 } = m;
      I10 && cr(I10), Ue$1("INSTANCE_EVENT_HOOKS", m) && m.emit("hook:beforeDestroy"), O.stop(), H && (H.active = false, it(Y10, m, y10, S)), U10 && at(U10, y10), Ue$1("INSTANCE_EVENT_HOOKS", m) && at(() => m.emit("hook:destroyed"), y10), at(() => {
        m.isUnmounted = true;
      }, y10), y10 && y10.pendingBranch && !y10.isUnmounted && m.asyncDep && !m.asyncResolved && m.suspenseId === y10.pendingId && (y10.deps--, y10.deps === 0 && y10.resolve());
    }, ke2 = (m, y10, S, I10 = false, O = false, H = 0) => {
      for (let Y10 = H; Y10 < m.length; Y10++)
        it(m[Y10], y10, S, I10, O);
    }, tt = (m) => m.shapeFlag & 6 ? tt(m.component.subTree) : m.shapeFlag & 128 ? m.suspense.next() : d10(m.anchor || m.el), xn2 = (m, y10, S) => {
      m == null ? y10._vnode && it(y10._vnode, null, null, true) : L(y10._vnode || null, m, y10, null, null, null, S), Hc(), Si(), y10._vnode = m;
    }, mt = {
      p: L,
      um: it,
      m: Ot,
      r: N,
      mt: re2,
      mc: R,
      pc: de2,
      pbc: le2,
      n: tt,
      o: t10
    };
    let It2, Mt2;
    return e10 && ([It2, Mt2] = e10(mt)), {
      render: xn2,
      hydrate: It2,
      createApp: nf(xn2, It2)
    };
  }
  function vr({ effect: t10, update: e10 }, n10) {
    t10.allowRecurse = e10.allowRecurse = n10;
  }
  function Gl(t10, e10, n10 = false) {
    const r10 = t10.children, s10 = e10.children;
    if (K$1(r10) && K$1(s10))
      for (let i10 = 0; i10 < r10.length; i10++) {
        const o10 = r10[i10];
        let l10 = s10[i10];
        l10.shapeFlag & 1 && !l10.dynamicChildren && ((l10.patchFlag <= 0 || l10.patchFlag === 32) && (l10 = s10[i10] = rr(s10[i10]), l10.el = o10.el), n10 || Gl(o10, l10)), l10.type === Ur && (l10.el = o10.el);
      }
  }
  function sf(t10) {
    const e10 = t10.slice(), n10 = [0];
    let r10, s10, i10, o10, l10;
    const a10 = t10.length;
    for (r10 = 0; r10 < a10; r10++) {
      const c10 = t10[r10];
      if (c10 !== 0) {
        if (s10 = n10[n10.length - 1], t10[s10] < c10) {
          e10[r10] = s10, n10.push(r10);
          continue;
        }
        for (i10 = 0, o10 = n10.length - 1; i10 < o10; )
          l10 = i10 + o10 >> 1, t10[n10[l10]] < c10 ? i10 = l10 + 1 : o10 = l10;
        c10 < t10[n10[i10]] && (i10 > 0 && (e10[r10] = n10[i10 - 1]), n10[i10] = r10);
      }
    }
    for (i10 = n10.length, o10 = n10[i10 - 1]; i10-- > 0; )
      n10[i10] = o10, o10 = e10[o10];
    return n10;
  }
  const of = (t10) => t10.__isTeleport, Qs = (t10) => t10 && (t10.disabled || t10.disabled === ""), n2 = (t10) => typeof SVGElement < "u" && t10 instanceof SVGElement, Oo = (t10, e10) => {
    const n10 = t10 && t10.to;
    return Ke$1(n10) ? e10 ? e10(n10) : null : n10;
  }, lf = {
    __isTeleport: true,
    process(t10, e10, n10, r10, s10, i10, o10, l10, a10, c10) {
      const { mc: u10, pc: h10, pbc: d10, o: { insert: p10, querySelector: g, createText: L, createComment: T } } = c10, _10 = Qs(e10.props);
      let { shapeFlag: x, children: C, dynamicChildren: E } = e10;
      if (t10 == null) {
        const M10 = e10.el = L(""), $ = e10.anchor = L("");
        p10(M10, n10, r10), p10($, n10, r10);
        const j = e10.target = Oo(e10.props, g), R = e10.targetAnchor = L("");
        j && (p10(R, j), o10 = o10 || n2(j));
        const ae2 = (le2, he) => {
          x & 16 && u10(C, le2, he, s10, i10, o10, l10, a10);
        };
        _10 ? ae2(n10, $) : j && ae2(j, R);
      } else {
        e10.el = t10.el;
        const M10 = e10.anchor = t10.anchor, $ = e10.target = t10.target, j = e10.targetAnchor = t10.targetAnchor, R = Qs(t10.props), ae2 = R ? n10 : $, le2 = R ? M10 : j;
        if (o10 = o10 || n2($), E ? (d10(t10.dynamicChildren, E, ae2, s10, i10, o10, l10), Gl(t10, e10, true)) : a10 || h10(t10, e10, ae2, le2, s10, i10, o10, l10, false), _10)
          R || ai(e10, n10, M10, c10, 1);
        else if ((e10.props && e10.props.to) !== (t10.props && t10.props.to)) {
          const he = e10.target = Oo(e10.props, g);
          he && ai(e10, he, null, c10, 0);
        } else
          R && ai(e10, $, j, c10, 1);
      }
      J3(e10);
    },
    remove(t10, e10, n10, r10, { um: s10, o: { remove: i10 } }, o10) {
      const { shapeFlag: l10, children: a10, anchor: c10, targetAnchor: u10, target: h10, props: d10 } = t10;
      if (h10 && i10(u10), (o10 || !Qs(d10)) && (i10(c10), l10 & 16))
        for (let p10 = 0; p10 < a10.length; p10++) {
          const g = a10[p10];
          s10(g, e10, n10, true, !!g.dynamicChildren);
        }
    },
    move: ai,
    hydrate: af
  };
  function ai(t10, e10, n10, { o: { insert: r10 }, m: s10 }, i10 = 2) {
    i10 === 0 && r10(t10.targetAnchor, e10, n10);
    const { el: o10, anchor: l10, shapeFlag: a10, children: c10, props: u10 } = t10, h10 = i10 === 2;
    if (h10 && r10(o10, e10, n10), (!h10 || Qs(u10)) && a10 & 16)
      for (let d10 = 0; d10 < c10.length; d10++)
        s10(c10[d10], e10, n10, 2);
    h10 && r10(l10, e10, n10);
  }
  function af(t10, e10, n10, r10, s10, i10, { o: { nextSibling: o10, parentNode: l10, querySelector: a10 } }, c10) {
    const u10 = e10.target = Oo(e10.props, a10);
    if (u10) {
      const h10 = u10._lpa || u10.firstChild;
      if (e10.shapeFlag & 16)
        if (Qs(e10.props))
          e10.anchor = c10(o10(t10), e10, l10(t10), n10, r10, s10, i10), e10.targetAnchor = h10;
        else {
          e10.anchor = o10(t10);
          let d10 = h10;
          for (; d10; )
            if (d10 = o10(d10), d10 && d10.nodeType === 8 && d10.data === "teleport anchor") {
              e10.targetAnchor = d10, u10._lpa = e10.targetAnchor && o10(e10.targetAnchor);
              break;
            }
          c10(h10, e10, u10, n10, r10, s10, i10);
        }
      J3(e10);
    }
    return e10.anchor && o10(e10.anchor);
  }
  const Q3 = lf;
  function J3(t10) {
    const e10 = t10.ctx;
    if (e10 && e10.ut) {
      let n10 = t10.children[0].el;
      for (; n10 !== t10.targetAnchor; )
        n10.nodeType === 1 && n10.setAttribute("data-v-owner", e10.uid), n10 = n10.nextSibling;
      e10.ut();
    }
  }
  const X1 = /* @__PURE__ */ new Map();
  function cf(t10) {
    if (X1.has(t10))
      return X1.get(t10);
    let e10, n10;
    const r10 = new Promise((o10, l10) => {
      e10 = o10, n10 = l10;
    }), s10 = t10(e10, n10);
    let i10;
    return Ki(s10) ? i10 = hs(() => s10) : Se(s10) && !Jt$1(s10) && !K$1(s10) ? i10 = hs({
      loader: () => s10.component,
      loadingComponent: s10.loading,
      errorComponent: s10.error,
      delay: s10.delay,
      timeout: s10.timeout
    }) : s10 == null ? i10 = hs(() => r10) : i10 = t10, X1.set(t10, i10), i10;
  }
  function uf(t10, e10) {
    return t10.__isBuiltIn ? t10 : (ue$1(t10) && t10.cid && (t10 = t10.options), ue$1(t10) && r1("COMPONENT_ASYNC", e10, t10) ? cf(t10) : Se(t10) && t10.functional && Zn("COMPONENT_FUNCTIONAL", e10, t10) ? bd(t10) : t10);
  }
  const Fe$1 = Symbol(void 0), Ur = Symbol(void 0), yt = Symbol(void 0), Fr = Symbol(void 0), Js = [];
  let Dt$1 = null;
  function k$1(t10 = false) {
    Js.push(Dt$1 = t10 ? null : []);
  }
  function e5() {
    Js.pop(), Dt$1 = Js[Js.length - 1] || null;
  }
  let Vr = 1;
  function Io(t10) {
    Vr += t10;
  }
  function t5(t10) {
    return t10.dynamicChildren = Vr > 0 ? Dt$1 || ss : null, e5(), Vr > 0 && Dt$1 && Dt$1.push(t10), t10;
  }
  function q$1(t10, e10, n10, r10, s10, i10) {
    return t5(A(t10, e10, n10, r10, s10, i10, true));
  }
  function Re$1(t10, e10, n10, r10, s10) {
    return t5(V$1(t10, e10, n10, r10, s10, true));
  }
  function Jt$1(t10) {
    return t10 ? t10.__v_isVNode === true : false;
  }
  function vn$1(t10, e10) {
    return t10.type === e10.type && t10.key === e10.key;
  }
  function hf(t10) {
  }
  const u1 = "__vInternal", n5 = ({ key: t10 }) => t10 != null ? t10 : null, Ci = ({ ref: t10, ref_key: e10, ref_for: n10 }) => t10 != null ? Ke$1(t10) || gt(t10) || ue$1(t10) ? { i: ut, r: t10, k: e10, f: !!n10 } : t10 : null;
  function A(t10, e10 = null, n10 = null, r10 = 0, s10 = null, i10 = t10 === Fe$1 ? 0 : 1, o10 = false, l10 = false) {
    const a10 = {
      __v_isVNode: true,
      __v_skip: true,
      type: t10,
      props: e10,
      key: e10 && n5(e10),
      ref: e10 && Ci(e10),
      scopeId: cs,
      slotScopeIds: null,
      children: n10,
      component: null,
      suspense: null,
      ssContent: null,
      ssFallback: null,
      dirs: null,
      transition: null,
      el: null,
      anchor: null,
      target: null,
      targetAnchor: null,
      staticCount: 0,
      shapeFlag: i10,
      patchFlag: r10,
      dynamicProps: s10,
      dynamicChildren: null,
      appContext: null,
      ctx: ut
    };
    return l10 ? (d1(a10, n10), i10 & 128 && t10.normalize(a10)) : n10 && (a10.shapeFlag |= Ke$1(n10) ? 8 : 16), Vr > 0 && !o10 && Dt$1 && (a10.patchFlag > 0 || i10 & 6) && a10.patchFlag !== 32 && Dt$1.push(a10), Q8(a10), I3(a10), a10;
  }
  const V$1 = df;
  function df(t10, e10 = null, n10 = null, r10 = 0, s10 = null, i10 = false) {
    if ((!t10 || t10 === k3) && (t10 = yt), Jt$1(t10)) {
      const l10 = an$1(t10, e10, true);
      return n10 && d1(l10, n10), Vr > 0 && !i10 && Dt$1 && (l10.shapeFlag & 6 ? Dt$1[Dt$1.indexOf(t10)] = l10 : Dt$1.push(l10)), l10.patchFlag |= -2, l10;
    }
    if (Lf(t10) && (t10 = t10.__vccOpts), t10 = uf(t10, ut), e10) {
      e10 = r5(e10);
      let { class: l10, style: a10 } = e10;
      l10 && !Ke$1(l10) && (e10.class = ve$1(l10)), Se(a10) && (El(a10) && !K$1(a10) && (a10 = Oe$1({}, a10)), e10.style = Ce$1(a10));
    }
    const o10 = Ke$1(t10) ? 1 : u3(t10) ? 128 : of(t10) ? 64 : Se(t10) ? 4 : ue$1(t10) ? 2 : 0;
    return A(t10, e10, n10, r10, s10, o10, i10, true);
  }
  function r5(t10) {
    return t10 ? El(t10) || u1 in t10 ? Oe$1({}, t10) : t10 : null;
  }
  function an$1(t10, e10, n10 = false) {
    const { props: r10, ref: s10, patchFlag: i10, children: o10 } = t10, l10 = e10 ? f1(r10 || {}, e10) : r10, a10 = {
      __v_isVNode: true,
      __v_skip: true,
      type: t10.type,
      props: l10,
      key: l10 && n5(l10),
      ref: e10 && e10.ref ? n10 && s10 ? K$1(s10) ? s10.concat(Ci(e10)) : [s10, Ci(e10)] : Ci(e10) : s10,
      scopeId: t10.scopeId,
      slotScopeIds: t10.slotScopeIds,
      children: o10,
      target: t10.target,
      targetAnchor: t10.targetAnchor,
      staticCount: t10.staticCount,
      shapeFlag: t10.shapeFlag,
      patchFlag: e10 && t10.type !== Fe$1 ? i10 === -1 ? 16 : i10 | 16 : i10,
      dynamicProps: t10.dynamicProps,
      dynamicChildren: t10.dynamicChildren,
      appContext: t10.appContext,
      dirs: t10.dirs,
      transition: t10.transition,
      component: t10.component,
      suspense: t10.suspense,
      ssContent: t10.ssContent && an$1(t10.ssContent),
      ssFallback: t10.ssFallback && an$1(t10.ssFallback),
      el: t10.el,
      anchor: t10.anchor,
      ctx: t10.ctx
    };
    return I3(a10), a10;
  }
  function dn$1(t10 = " ", e10 = 0) {
    return V$1(Ur, null, t10, e10);
  }
  function h1(t10, e10) {
    const n10 = V$1(Fr, null, t10);
    return n10.staticCount = e10, n10;
  }
  function xe$1(t10 = "", e10 = false) {
    return e10 ? (k$1(), Re$1(yt, null, t10)) : V$1(yt, null, t10);
  }
  function Wt$1(t10) {
    return t10 == null || typeof t10 == "boolean" ? V$1(yt) : K$1(t10) ? V$1(
      Fe$1,
      null,
      t10.slice()
    ) : typeof t10 == "object" ? rr(t10) : V$1(Ur, null, String(t10));
  }
  function rr(t10) {
    return t10.el === null && t10.patchFlag !== -1 || t10.memo ? t10 : an$1(t10);
  }
  function d1(t10, e10) {
    let n10 = 0;
    const { shapeFlag: r10 } = t10;
    if (e10 == null)
      e10 = null;
    else if (K$1(e10))
      n10 = 16;
    else if (typeof e10 == "object")
      if (r10 & 65) {
        const s10 = e10.default;
        s10 && (s10._c && (s10._d = false), d1(t10, s10()), s10._c && (s10._d = true));
        return;
      } else {
        n10 = 32;
        const s10 = e10._;
        !s10 && !(u1 in e10) ? e10._ctx = ut : s10 === 3 && ut && (ut.slots._ === 1 ? e10._ = 1 : (e10._ = 2, t10.patchFlag |= 1024));
      }
    else
      ue$1(e10) ? (e10 = { default: e10, _ctx: ut }, n10 = 32) : (e10 = String(e10), r10 & 64 ? (n10 = 16, e10 = [dn$1(e10)]) : n10 = 8);
    t10.children = e10, t10.shapeFlag |= n10;
  }
  function f1(...t10) {
    const e10 = {};
    for (let n10 = 0; n10 < t10.length; n10++) {
      const r10 = t10[n10];
      for (const s10 in r10)
        if (s10 === "class")
          e10.class !== r10.class && (e10.class = ve$1([e10.class, r10.class]));
        else if (s10 === "style")
          e10.style = Ce$1([e10.style, r10.style]);
        else if (Yn(s10)) {
          const i10 = e10[s10], o10 = r10[s10];
          o10 && i10 !== o10 && !(K$1(i10) && i10.includes(o10)) && (e10[s10] = i10 ? [].concat(i10, o10) : o10);
        } else
          s10 !== "" && (e10[s10] = r10[s10]);
    }
    return e10;
  }
  function Nt$1(t10, e10, n10, r10 = null) {
    $t$1(t10, e10, 7, [
      n10,
      r10
    ]);
  }
  const ff = q3();
  let pf = 0;
  function jl(t10, e10, n10) {
    const r10 = t10.type, s10 = (e10 ? e10.appContext : t10.appContext) || ff, i10 = {
      uid: pf++,
      vnode: t10,
      type: r10,
      parent: e10,
      appContext: s10,
      root: null,
      next: null,
      subTree: null,
      effect: null,
      update: null,
      scope: new Cl(true),
      render: null,
      proxy: null,
      exposed: null,
      exposeProxy: null,
      withProxy: null,
      provides: e10 ? e10.provides : Object.create(s10.provides),
      accessCache: null,
      renderCache: [],
      components: null,
      directives: null,
      propsOptions: z3(r10, s10),
      emitsOptions: c3(r10, s10),
      emit: null,
      emitted: null,
      propsDefaults: Ge$1,
      inheritAttrs: r10.inheritAttrs,
      ctx: Ge$1,
      data: Ge$1,
      props: Ge$1,
      attrs: Ge$1,
      slots: Ge$1,
      refs: Ge$1,
      setupState: Ge$1,
      setupContext: null,
      suspense: n10,
      suspenseId: n10 ? n10.pendingId : 0,
      asyncDep: null,
      asyncResolved: false,
      isMounted: false,
      isUnmounted: false,
      isDeactivated: false,
      bc: null,
      c: null,
      bm: null,
      m: null,
      bu: null,
      u: null,
      um: null,
      bum: null,
      da: null,
      a: null,
      rtg: null,
      rtc: null,
      ec: null,
      sp: null
    };
    return i10.ctx = { _: i10 }, i10.root = e10 ? e10.root : i10, i10.emit = ed.bind(null, i10), t10.ce && t10.ce(i10), i10;
  }
  let dt = null;
  const Pn = () => dt || ut, mr = (t10) => {
    dt = t10, t10.scope.on();
  }, hr = () => {
    dt && dt.scope.off(), dt = null;
  };
  function s5(t10) {
    return t10.vnode.shapeFlag & 4;
  }
  let Ls = false;
  function Zl(t10, e10 = false) {
    Ls = e10;
    const { props: n10, children: r10 } = t10.vnode, s10 = s5(t10);
    Hd(t10, n10, s10, e10), zd(t10, r10);
    const i10 = s10 ? gf(t10, e10) : void 0;
    return Ls = false, i10;
  }
  function gf(t10, e10) {
    const n10 = t10.type;
    t10.accessCache = /* @__PURE__ */ Object.create(null), t10.proxy = Tl(new Proxy(t10.ctx, So));
    const { setup: r10 } = n10;
    if (r10) {
      const s10 = t10.setupContext = r10.length > 1 ? i5(t10) : null;
      mr(t10), Es();
      const i10 = En$1(r10, t10, 0, [t10.props, s10]);
      if (Ts(), hr(), Ki(i10)) {
        if (i10.then(hr, hr), e10)
          return i10.then((o10) => {
            Mo(t10, o10, e10);
          }).catch((o10) => {
            jr(o10, t10, 0);
          });
        t10.asyncDep = i10;
      } else
        Mo(t10, i10, e10);
    } else
      Wl(t10, e10);
  }
  function Mo(t10, e10, n10) {
    ue$1(e10) ? t10.type.__ssrInlineRender ? t10.ssrRender = e10 : t10.render = e10 : Se(e10) && (t10.setupState = kl(e10)), Wl(t10, n10);
  }
  let Ri, No;
  function mf(t10) {
    Ri = t10, No = (e10) => {
      e10.render._rc && (e10.withProxy = new Proxy(e10.ctx, Pd));
    };
  }
  const Po = () => !Ri;
  function Wl(t10, e10, n10) {
    const r10 = t10.type;
    if (yd(t10), !t10.render) {
      if (!e10 && Ri && !r10.render) {
        const s10 = t10.vnode.props && t10.vnode.props["inline-template"] || r10.template || O0(t10).template;
        if (s10) {
          const { isCustomElement: i10, compilerOptions: o10 } = t10.appContext.config, { delimiters: l10, compilerOptions: a10 } = r10, c10 = Oe$1(Oe$1({
            isCustomElement: i10,
            delimiters: l10
          }, o10), a10);
          c10.compatConfig = Object.create(Ml), r10.compatConfig && Oe$1(c10.compatConfig, r10.compatConfig), r10.render = Ri(s10, c10);
        }
      }
      t10.render = r10.render || Bt$1, No && No(t10);
    }
    n10 || (mr(t10), Es(), Fd(t10), Ts(), hr());
  }
  function xf(t10) {
    return new Proxy(t10.attrs, {
      get(e10, n10) {
        return Ht$1(t10, "get", "$attrs"), e10[n10];
      }
    });
  }
  function i5(t10) {
    const e10 = (r10) => {
      t10.exposed = r10 || {};
    };
    let n10;
    return {
      get attrs() {
        return n10 || (n10 = xf(t10));
      },
      slots: t10.slots,
      emit: t10.emit,
      expose: e10
    };
  }
  function p1(t10) {
    if (t10.exposed)
      return t10.exposeProxy || (t10.exposeProxy = new Proxy(kl(Tl(t10.exposed)), {
        get(e10, n10) {
          if (n10 in e10)
            return e10[n10];
          if (n10 in ds)
            return ds[n10](t10);
        },
        has(e10, n10) {
          return n10 in e10 || n10 in ds;
        }
      }));
  }
  function Fo(t10, e10 = true) {
    return ue$1(t10) ? t10.displayName || t10.name : t10.name || e10 && t10.__name;
  }
  function Lf(t10) {
    return ue$1(t10) && "__vccOpts" in t10;
  }
  const G$1 = (t10, e10) => V8(t10, e10, Ls);
  function _f() {
    return null;
  }
  function yf() {
    return null;
  }
  function Cf(t10) {
  }
  function vf(t10, e10) {
    return null;
  }
  function bf() {
    return o5().slots;
  }
  function wf() {
    return o5().attrs;
  }
  function o5() {
    const t10 = Pn();
    return t10.setupContext || (t10.setupContext = i5(t10));
  }
  function Ef(t10, e10) {
    const n10 = K$1(t10) ? t10.reduce((r10, s10) => (r10[s10] = {}, r10), {}) : t10;
    for (const r10 in e10) {
      const s10 = n10[r10];
      s10 ? K$1(s10) || ue$1(s10) ? n10[r10] = { type: s10, default: e10[r10] } : s10.default = e10[r10] : s10 === null && (n10[r10] = { default: e10[r10] });
    }
    return n10;
  }
  function Tf(t10, e10) {
    const n10 = {};
    for (const r10 in t10)
      e10.includes(r10) || Object.defineProperty(n10, r10, {
        enumerable: true,
        get: () => t10[r10]
      });
    return n10;
  }
  function Sf(t10) {
    const e10 = Pn();
    let n10 = t10();
    return hr(), Ki(n10) && (n10 = n10.catch((r10) => {
      throw mr(e10), r10;
    })), [n10, () => mr(e10)];
  }
  function ct(t10, e10, n10) {
    const r10 = arguments.length;
    return r10 === 2 ? Se(e10) && !K$1(e10) ? Jt$1(e10) ? V$1(t10, null, [e10]) : V$1(t10, e10) : V$1(t10, null, e10) : (r10 > 3 ? n10 = Array.prototype.slice.call(arguments, 2) : r10 === 3 && Jt$1(n10) && (n10 = [n10]), V$1(t10, e10, n10));
  }
  const l5 = Symbol(""), a5 = () => lt(l5);
  function Af() {
  }
  function kf(t10, e10, n10, r10) {
    const s10 = n10[r10];
    if (s10 && c5(s10, t10))
      return s10;
    const i10 = e10();
    return i10.memo = t10.slice(), n10[r10] = i10;
  }
  function c5(t10, e10) {
    const n10 = t10.memo;
    if (n10.length != e10.length)
      return false;
    for (let r10 = 0; r10 < n10.length; r10++)
      if (ms(n10[r10], e10[r10]))
        return false;
    return Vr > 0 && Dt$1 && Dt$1.push(t10), true;
  }
  const u5 = "3.2.45", Rf = {
    createComponentInstance: jl,
    setupComponent: Zl,
    renderComponentRoot: yi,
    setCurrentRenderingInstance: g0,
    isVNode: Jt$1,
    normalizeVNode: Wt$1
  }, Of = Rf, If = O3, Mf = {
    warnDeprecation: q8,
    createCompatVue: Zd,
    isCompatEnabled: Ue$1,
    checkCompatEnabled: r1,
    softAssertCompatEnabled: Zn
  }, In = Mf, Nf = "http://www.w3.org/2000/svg", Ar = typeof document < "u" ? document : null, r2 = Ar && /* @__PURE__ */ Ar.createElement("template"), Pf = {
    insert: (t10, e10, n10) => {
      e10.insertBefore(t10, n10 || null);
    },
    remove: (t10) => {
      const e10 = t10.parentNode;
      e10 && e10.removeChild(t10);
    },
    createElement: (t10, e10, n10, r10) => {
      const s10 = e10 ? Ar.createElementNS(Nf, t10) : Ar.createElement(t10, n10 ? { is: n10 } : void 0);
      return t10 === "select" && r10 && r10.multiple != null && s10.setAttribute("multiple", r10.multiple), s10;
    },
    createText: (t10) => Ar.createTextNode(t10),
    createComment: (t10) => Ar.createComment(t10),
    setText: (t10, e10) => {
      t10.nodeValue = e10;
    },
    setElementText: (t10, e10) => {
      t10.textContent = e10;
    },
    parentNode: (t10) => t10.parentNode,
    nextSibling: (t10) => t10.nextSibling,
    querySelector: (t10) => Ar.querySelector(t10),
    setScopeId(t10, e10) {
      t10.setAttribute(e10, "");
    },
    insertStaticContent(t10, e10, n10, r10, s10, i10) {
      const o10 = n10 ? n10.previousSibling : e10.lastChild;
      if (s10 && (s10 === i10 || s10.nextSibling))
        for (; e10.insertBefore(s10.cloneNode(true), n10), !(s10 === i10 || !(s10 = s10.nextSibling)); )
          ;
      else {
        r2.innerHTML = r10 ? `<svg>${t10}</svg>` : t10;
        const l10 = r2.content;
        if (r10) {
          const a10 = l10.firstChild;
          for (; a10.firstChild; )
            l10.appendChild(a10.firstChild);
          l10.removeChild(a10);
        }
        e10.insertBefore(l10, n10);
      }
      return [
        o10 ? o10.nextSibling : e10.firstChild,
        n10 ? n10.previousSibling : e10.lastChild
      ];
    }
  };
  function Ff(t10, e10, n10) {
    const r10 = t10._vtc;
    r10 && (e10 = (e10 ? [e10, ...r10] : [...r10]).join(" ")), e10 == null ? t10.removeAttribute("class") : n10 ? t10.setAttribute("class", e10) : t10.className = e10;
  }
  function Df(t10, e10, n10) {
    const r10 = t10.style, s10 = Ke$1(n10);
    if (n10 && !s10) {
      for (const i10 in n10)
        Do(r10, i10, n10[i10]);
      if (e10 && !Ke$1(e10))
        for (const i10 in e10)
          n10[i10] == null && Do(r10, i10, "");
    } else {
      const i10 = r10.display;
      s10 ? e10 !== n10 && (r10.cssText = n10) : e10 && t10.removeAttribute("style"), "_vod" in t10 && (r10.display = i10);
    }
  }
  const s2 = /\s*!important$/;
  function Do(t10, e10, n10) {
    if (K$1(n10))
      n10.forEach((r10) => Do(t10, e10, r10));
    else if (n10 == null && (n10 = ""), e10.startsWith("--"))
      t10.setProperty(e10, n10);
    else {
      const r10 = Bf(t10, e10);
      s2.test(n10) ? t10.setProperty(St$1(r10), n10.replace(s2, ""), "important") : t10[r10] = n10;
    }
  }
  const i2 = ["Webkit", "Moz", "ms"], Q1 = {};
  function Bf(t10, e10) {
    const n10 = Q1[e10];
    if (n10)
      return n10;
    let r10 = Rt$1(e10);
    if (r10 !== "filter" && r10 in t10)
      return Q1[e10] = r10;
    r10 = T0(r10);
    for (let s10 = 0; s10 < i2.length; s10++) {
      const i10 = i2[s10] + r10;
      if (i10 in t10)
        return Q1[e10] = i10;
    }
    return e10;
  }
  const o2 = "http://www.w3.org/1999/xlink";
  function $f(t10, e10, n10, r10, s10) {
    if (r10 && e10.startsWith("xlink:"))
      n10 == null ? t10.removeAttributeNS(o2, e10.slice(6, e10.length)) : t10.setAttributeNS(o2, e10, n10);
    else {
      if (Uf(t10, e10, n10, s10))
        return;
      const i10 = Pu(e10);
      n10 == null || i10 && !Fu(n10) ? t10.removeAttribute(e10) : t10.setAttribute(e10, i10 ? "" : n10);
    }
  }
  const Hf = /* @__PURE__ */ ws("contenteditable,draggable,spellcheck");
  function Uf(t10, e10, n10, r10 = null) {
    if (Hf(e10)) {
      const s10 = n10 === null ? "false" : typeof n10 != "boolean" && n10 !== void 0 ? "true" : null;
      if (s10 && In.softAssertCompatEnabled("ATTR_ENUMERATED_COERCION", r10, e10, n10, s10))
        return t10.setAttribute(e10, s10), true;
    } else if (n10 === false && !Pu(e10) && In.softAssertCompatEnabled("ATTR_FALSE_VALUE", r10, e10))
      return t10.removeAttribute(e10), true;
    return false;
  }
  function Vf(t10, e10, n10, r10, s10, i10, o10) {
    if (e10 === "innerHTML" || e10 === "textContent") {
      r10 && o10(r10, s10, i10), t10[e10] = n10 == null ? "" : n10;
      return;
    }
    if (e10 === "value" && t10.tagName !== "PROGRESS" && !t10.tagName.includes("-")) {
      t10._value = n10;
      const a10 = n10 == null ? "" : n10;
      (t10.value !== a10 || t10.tagName === "OPTION") && (t10.value = a10), n10 == null && t10.removeAttribute(e10);
      return;
    }
    let l10 = false;
    if (n10 === "" || n10 == null) {
      const a10 = typeof t10[e10];
      a10 === "boolean" ? n10 = Fu(n10) : n10 == null && a10 === "string" ? (n10 = "", l10 = true) : a10 === "number" && (n10 = 0, l10 = true);
    } else if (n10 === false && In.isCompatEnabled("ATTR_FALSE_VALUE", s10)) {
      const a10 = typeof t10[e10];
      (a10 === "string" || a10 === "number") && (n10 = a10 === "number" ? 0 : "", l10 = true);
    }
    try {
      t10[e10] = n10;
    } catch {
    }
    l10 && t10.removeAttribute(e10);
  }
  function Hn(t10, e10, n10, r10) {
    t10.addEventListener(e10, n10, r10);
  }
  function zf(t10, e10, n10, r10) {
    t10.removeEventListener(e10, n10, r10);
  }
  function Gf(t10, e10, n10, r10, s10 = null) {
    const i10 = t10._vei || (t10._vei = {}), o10 = i10[e10];
    if (r10 && o10)
      o10.value = r10;
    else {
      const [l10, a10] = jf(e10);
      if (r10) {
        const c10 = i10[e10] = qf(r10, s10);
        Hn(t10, l10, c10, a10);
      } else
        o10 && (zf(t10, l10, o10, a10), i10[e10] = void 0);
    }
  }
  const l2 = /(?:Once|Passive|Capture)$/;
  function jf(t10) {
    let e10;
    if (l2.test(t10)) {
      e10 = {};
      let r10;
      for (; r10 = t10.match(l2); )
        t10 = t10.slice(0, t10.length - r10[0].length), e10[r10[0].toLowerCase()] = true;
    }
    return [t10[2] === ":" ? t10.slice(3) : St$1(t10.slice(2)), e10];
  }
  let J1 = 0;
  const Zf = /* @__PURE__ */ Promise.resolve(), Wf = () => J1 || (Zf.then(() => J1 = 0), J1 = Date.now());
  function qf(t10, e10) {
    const n10 = (r10) => {
      if (!r10._vts)
        r10._vts = Date.now();
      else if (r10._vts <= n10.attached)
        return;
      $t$1(Kf(r10, n10.value), e10, 5, [r10]);
    };
    return n10.value = t10, n10.attached = Wf(), n10;
  }
  function Kf(t10, e10) {
    if (K$1(e10)) {
      const n10 = t10.stopImmediatePropagation;
      return t10.stopImmediatePropagation = () => {
        n10.call(t10), t10._stopped = true;
      }, e10.map((r10) => (s10) => !s10._stopped && r10 && r10(s10));
    } else
      return e10;
  }
  const a2 = /^on[a-z]/, Yf = (t10, e10, n10, r10, s10 = false, i10, o10, l10, a10) => {
    e10 === "class" ? Ff(t10, r10, s10) : e10 === "style" ? Df(t10, n10, r10) : Yn(e10) ? Ll(e10) || Gf(t10, e10, n10, r10, o10) : (e10[0] === "." ? (e10 = e10.slice(1), true) : e10[0] === "^" ? (e10 = e10.slice(1), false) : Xf(t10, e10, r10, s10)) ? Vf(t10, e10, r10, i10, o10, l10, a10) : (e10 === "true-value" ? t10._trueValue = r10 : e10 === "false-value" && (t10._falseValue = r10), $f(t10, e10, r10, s10, o10));
  };
  function Xf(t10, e10, n10, r10) {
    return r10 ? !!(e10 === "innerHTML" || e10 === "textContent" || e10 in t10 && a2.test(e10) && ue$1(n10)) : e10 === "spellcheck" || e10 === "draggable" || e10 === "translate" || e10 === "form" || e10 === "list" && t10.tagName === "INPUT" || e10 === "type" && t10.tagName === "TEXTAREA" || a2.test(e10) && Ke$1(n10) ? false : e10 in t10;
  }
  function h5(t10, e10) {
    const n10 = Ye$1(t10);
    class r10 extends g1 {
      constructor(i10) {
        super(n10, i10, e10);
      }
    }
    return r10.def = n10, r10;
  }
  const Qf = (t10) => h5(t10, T5), Jf = typeof HTMLElement < "u" ? HTMLElement : class {
  };
  class g1 extends Jf {
    constructor(e10, n10 = {}, r10) {
      super(), this._def = e10, this._props = n10, this._instance = null, this._connected = false, this._resolved = false, this._numberProps = null, this.shadowRoot && r10 ? r10(this._createVNode(), this.shadowRoot) : (this.attachShadow({ mode: "open" }), this._def.__asyncLoader || this._resolveProps(this._def));
    }
    connectedCallback() {
      this._connected = true, this._instance || (this._resolved ? this._update() : this._resolveDef());
    }
    disconnectedCallback() {
      this._connected = false, gr(() => {
        this._connected || (Ho(null, this.shadowRoot), this._instance = null);
      });
    }
    _resolveDef() {
      this._resolved = true;
      for (let r10 = 0; r10 < this.attributes.length; r10++)
        this._setAttr(this.attributes[r10].name);
      new MutationObserver((r10) => {
        for (const s10 of r10)
          this._setAttr(s10.attributeName);
      }).observe(this, { attributes: true });
      const e10 = (r10, s10 = false) => {
        const { props: i10, styles: o10 } = r10;
        let l10;
        if (i10 && !K$1(i10))
          for (const a10 in i10) {
            const c10 = i10[a10];
            (c10 === Number || c10 && c10.type === Number) && (a10 in this._props && (this._props[a10] = An$1(this._props[a10])), (l10 || (l10 = /* @__PURE__ */ Object.create(null)))[Rt$1(a10)] = true);
          }
        this._numberProps = l10, s10 && this._resolveProps(r10), this._applyStyles(o10), this._update();
      }, n10 = this._def.__asyncLoader;
      n10 ? n10().then((r10) => e10(r10, true)) : e10(this._def);
    }
    _resolveProps(e10) {
      const { props: n10 } = e10, r10 = K$1(n10) ? n10 : Object.keys(n10 || {});
      for (const s10 of Object.keys(this))
        s10[0] !== "_" && r10.includes(s10) && this._setProp(s10, this[s10], true, false);
      for (const s10 of r10.map(Rt$1))
        Object.defineProperty(this, s10, {
          get() {
            return this._getProp(s10);
          },
          set(i10) {
            this._setProp(s10, i10);
          }
        });
    }
    _setAttr(e10) {
      let n10 = this.getAttribute(e10);
      const r10 = Rt$1(e10);
      this._numberProps && this._numberProps[r10] && (n10 = An$1(n10)), this._setProp(r10, n10, false);
    }
    _getProp(e10) {
      return this._props[e10];
    }
    _setProp(e10, n10, r10 = true, s10 = true) {
      n10 !== this._props[e10] && (this._props[e10] = n10, s10 && this._instance && this._update(), r10 && (n10 === true ? this.setAttribute(St$1(e10), "") : typeof n10 == "string" || typeof n10 == "number" ? this.setAttribute(St$1(e10), n10 + "") : n10 || this.removeAttribute(St$1(e10))));
    }
    _update() {
      Ho(this._createVNode(), this.shadowRoot);
    }
    _createVNode() {
      const e10 = V$1(this._def, Oe$1({}, this._props));
      return this._instance || (e10.ce = (n10) => {
        this._instance = n10, n10.isCE = true;
        const r10 = (i10, o10) => {
          this.dispatchEvent(new CustomEvent(i10, {
            detail: o10
          }));
        };
        n10.emit = (i10, ...o10) => {
          r10(i10, o10), St$1(i10) !== i10 && r10(St$1(i10), o10);
        };
        let s10 = this;
        for (; s10 = s10 && (s10.parentNode || s10.host); )
          if (s10 instanceof g1) {
            n10.parent = s10._instance, n10.provides = s10._instance.provides;
            break;
          }
      }), e10;
    }
    _applyStyles(e10) {
      e10 && e10.forEach((n10) => {
        const r10 = document.createElement("style");
        r10.textContent = n10, this.shadowRoot.appendChild(r10);
      });
    }
  }
  function e9(t10 = "$style") {
    {
      const e10 = Pn();
      if (!e10)
        return Ge$1;
      const n10 = e10.type.__cssModules;
      if (!n10)
        return Ge$1;
      const r10 = n10[t10];
      return r10 || Ge$1;
    }
  }
  function t9(t10) {
    const e10 = Pn();
    if (!e10)
      return;
    const n10 = e10.ut = (s10 = t10(e10.proxy)) => {
      Array.from(document.querySelectorAll(`[data-v-owner="${e10.uid}"]`)).forEach((i10) => $o(i10, s10));
    }, r10 = () => {
      const s10 = t10(e10.proxy);
      Bo(e10.subTree, s10), n10(s10);
    };
    d3(r10), We$1(() => {
      const s10 = new MutationObserver(r10);
      s10.observe(e10.subTree.el.parentNode, { childList: true }), ht(() => s10.disconnect());
    });
  }
  function Bo(t10, e10) {
    if (t10.shapeFlag & 128) {
      const n10 = t10.suspense;
      t10 = n10.activeBranch, n10.pendingBranch && !n10.isHydrating && n10.effects.push(() => {
        Bo(n10.activeBranch, e10);
      });
    }
    for (; t10.component; )
      t10 = t10.component.subTree;
    if (t10.shapeFlag & 1 && t10.el)
      $o(t10.el, e10);
    else if (t10.type === Fe$1)
      t10.children.forEach((n10) => Bo(n10, e10));
    else if (t10.type === Fr) {
      let { el: n10, anchor: r10 } = t10;
      for (; n10 && ($o(n10, e10), n10 !== r10); )
        n10 = n10.nextSibling;
    }
  }
  function $o(t10, e10) {
    if (t10.nodeType === 1) {
      const n10 = t10.style;
      for (const r10 in e10)
        n10.setProperty(`--${r10}`, e10[r10]);
    }
  }
  const tr = "transition", Hs = "animation", I0 = (t10, { slots: e10 }) => ct(Hl, f5(t10), e10);
  I0.displayName = "Transition";
  I0.__isBuiltIn = true;
  const d5 = {
    name: String,
    type: String,
    css: {
      type: Boolean,
      default: true
    },
    duration: [String, Number, Object],
    enterFromClass: String,
    enterActiveClass: String,
    enterToClass: String,
    appearFromClass: String,
    appearActiveClass: String,
    appearToClass: String,
    leaveFromClass: String,
    leaveActiveClass: String,
    leaveToClass: String
  }, n9 = I0.props = /* @__PURE__ */ Oe$1({}, Hl.props, d5), br = (t10, e10 = []) => {
    K$1(t10) ? t10.forEach((n10) => n10(...e10)) : t10 && t10(...e10);
  }, c2 = (t10) => t10 ? K$1(t10) ? t10.some((e10) => e10.length > 1) : t10.length > 1 : false;
  function f5(t10) {
    const e10 = {};
    for (const D10 in t10)
      D10 in d5 || (e10[D10] = t10[D10]);
    if (t10.css === false)
      return e10;
    const { name: n10 = "v", type: r10, duration: s10, enterFromClass: i10 = `${n10}-enter-from`, enterActiveClass: o10 = `${n10}-enter-active`, enterToClass: l10 = `${n10}-enter-to`, appearFromClass: a10 = i10, appearActiveClass: c10 = o10, appearToClass: u10 = l10, leaveFromClass: h10 = `${n10}-leave-from`, leaveActiveClass: d10 = `${n10}-leave-active`, leaveToClass: p10 = `${n10}-leave-to` } = t10, g = In.isCompatEnabled("TRANSITION_CLASSES", null);
    let L, T, _10;
    if (g) {
      const D10 = (X10) => X10.replace(/-from$/, "");
      t10.enterFromClass || (L = D10(i10)), t10.appearFromClass || (T = D10(a10)), t10.leaveFromClass || (_10 = D10(h10));
    }
    const x = r9(s10), C = x && x[0], E = x && x[1], { onBeforeEnter: M10, onEnter: $, onEnterCancelled: j, onLeave: R, onLeaveCancelled: ae2, onBeforeAppear: le2 = M10, onAppear: he = $, onAppearCancelled: He2 = j } = e10, Le2 = (D10, X10, de2) => {
      Ln(D10, X10 ? u10 : l10), Ln(D10, X10 ? c10 : o10), de2 && de2();
    }, re2 = (D10, X10) => {
      D10._isLeaving = false, Ln(D10, h10), Ln(D10, p10), Ln(D10, d10), X10 && X10();
    }, Ne2 = (D10) => (X10, de2) => {
      const Xe2 = D10 ? he : $, Qe2 = () => Le2(X10, D10, de2);
      br(Xe2, [X10, Qe2]), u2(() => {
        Ln(X10, D10 ? a10 : i10), g && Ln(X10, D10 ? T : L), on$1(X10, D10 ? u10 : l10), c2(Xe2) || h2(X10, r10, C, Qe2);
      });
    };
    return Oe$1(e10, {
      onBeforeEnter(D10) {
        br(M10, [D10]), on$1(D10, i10), g && on$1(D10, L), on$1(D10, o10);
      },
      onBeforeAppear(D10) {
        br(le2, [D10]), on$1(D10, a10), g && on$1(D10, T), on$1(D10, c10);
      },
      onEnter: Ne2(false),
      onAppear: Ne2(true),
      onLeave(D10, X10) {
        D10._isLeaving = true;
        const de2 = () => re2(D10, X10);
        on$1(D10, h10), g && on$1(D10, _10), g5(), on$1(D10, d10), u2(() => {
          !D10._isLeaving || (Ln(D10, h10), g && Ln(D10, _10), on$1(D10, p10), c2(R) || h2(D10, r10, E, de2));
        }), br(R, [D10, de2]);
      },
      onEnterCancelled(D10) {
        Le2(D10, false), br(j, [D10]);
      },
      onAppearCancelled(D10) {
        Le2(D10, true), br(He2, [D10]);
      },
      onLeaveCancelled(D10) {
        re2(D10), br(ae2, [D10]);
      }
    });
  }
  function r9(t10) {
    if (t10 == null)
      return null;
    if (Se(t10))
      return [eo(t10.enter), eo(t10.leave)];
    {
      const e10 = eo(t10);
      return [e10, e10];
    }
  }
  function eo(t10) {
    return An$1(t10);
  }
  function on$1(t10, e10) {
    e10.split(/\s+/).forEach((n10) => n10 && t10.classList.add(n10)), (t10._vtc || (t10._vtc = /* @__PURE__ */ new Set())).add(e10);
  }
  function Ln(t10, e10) {
    e10.split(/\s+/).forEach((r10) => r10 && t10.classList.remove(r10));
    const { _vtc: n10 } = t10;
    n10 && (n10.delete(e10), n10.size || (t10._vtc = void 0));
  }
  function u2(t10) {
    requestAnimationFrame(() => {
      requestAnimationFrame(t10);
    });
  }
  let s9 = 0;
  function h2(t10, e10, n10, r10) {
    const s10 = t10._endId = ++s9, i10 = () => {
      s10 === t10._endId && r10();
    };
    if (n10)
      return setTimeout(i10, n10);
    const { type: o10, timeout: l10, propCount: a10 } = p5(t10, e10);
    if (!o10)
      return r10();
    const c10 = o10 + "end";
    let u10 = 0;
    const h10 = () => {
      t10.removeEventListener(c10, d10), i10();
    }, d10 = (p10) => {
      p10.target === t10 && ++u10 >= a10 && h10();
    };
    setTimeout(() => {
      u10 < a10 && h10();
    }, l10 + 1), t10.addEventListener(c10, d10);
  }
  function p5(t10, e10) {
    const n10 = window.getComputedStyle(t10), r10 = (g) => (n10[g] || "").split(", "), s10 = r10(`${tr}Delay`), i10 = r10(`${tr}Duration`), o10 = d2(s10, i10), l10 = r10(`${Hs}Delay`), a10 = r10(`${Hs}Duration`), c10 = d2(l10, a10);
    let u10 = null, h10 = 0, d10 = 0;
    e10 === tr ? o10 > 0 && (u10 = tr, h10 = o10, d10 = i10.length) : e10 === Hs ? c10 > 0 && (u10 = Hs, h10 = c10, d10 = a10.length) : (h10 = Math.max(o10, c10), u10 = h10 > 0 ? o10 > c10 ? tr : Hs : null, d10 = u10 ? u10 === tr ? i10.length : a10.length : 0);
    const p10 = u10 === tr && /\b(transform|all)(,|$)/.test(r10(`${tr}Property`).toString());
    return {
      type: u10,
      timeout: h10,
      propCount: d10,
      hasTransform: p10
    };
  }
  function d2(t10, e10) {
    for (; t10.length < e10.length; )
      t10 = t10.concat(t10);
    return Math.max(...e10.map((n10, r10) => f2(n10) + f2(t10[r10])));
  }
  function f2(t10) {
    return Number(t10.slice(0, -1).replace(",", ".")) * 1e3;
  }
  function g5() {
    return document.body.offsetHeight;
  }
  const m5 = /* @__PURE__ */ new WeakMap(), x5 = /* @__PURE__ */ new WeakMap(), L5 = {
    name: "TransitionGroup",
    props: /* @__PURE__ */ Oe$1({}, n9, {
      tag: String,
      moveClass: String
    }),
    setup(t10, { slots: e10 }) {
      const n10 = Pn(), r10 = $l();
      let s10, i10;
      return R0(() => {
        if (!s10.length)
          return;
        const o10 = t10.moveClass || `${t10.name || "v"}-move`;
        if (!a9(s10[0].el, n10.vnode.el, o10))
          return;
        s10.forEach(i9), s10.forEach(o9);
        const l10 = s10.filter(l9);
        g5(), l10.forEach((a10) => {
          const c10 = a10.el, u10 = c10.style;
          on$1(c10, o10), u10.transform = u10.webkitTransform = u10.transitionDuration = "";
          const h10 = c10._moveCb = (d10) => {
            d10 && d10.target !== c10 || (!d10 || /transform$/.test(d10.propertyName)) && (c10.removeEventListener("transitionend", h10), c10._moveCb = null, Ln(c10, o10));
          };
          c10.addEventListener("transitionend", h10);
        });
      }), () => {
        const o10 = we$1(t10), l10 = f5(o10);
        let a10 = o10.tag || Fe$1;
        !o10.tag && In.checkCompatEnabled("TRANSITION_GROUP_ROOT", n10.parent) && (a10 = "span"), s10 = i10, i10 = e10.default ? o1(e10.default()) : [];
        for (let c10 = 0; c10 < i10.length; c10++) {
          const u10 = i10[c10];
          u10.key != null && Hr(u10, xs(u10, l10, r10, n10));
        }
        if (s10)
          for (let c10 = 0; c10 < s10.length; c10++) {
            const u10 = s10[c10];
            Hr(u10, xs(u10, l10, r10, n10)), m5.set(u10, u10.el.getBoundingClientRect());
          }
        return V$1(a10, null, i10);
      };
    }
  };
  L5.__isBuiltIn = true;
  const _5 = L5;
  function i9(t10) {
    const e10 = t10.el;
    e10._moveCb && e10._moveCb(), e10._enterCb && e10._enterCb();
  }
  function o9(t10) {
    x5.set(t10, t10.el.getBoundingClientRect());
  }
  function l9(t10) {
    const e10 = m5.get(t10), n10 = x5.get(t10), r10 = e10.left - n10.left, s10 = e10.top - n10.top;
    if (r10 || s10) {
      const i10 = t10.el.style;
      return i10.transform = i10.webkitTransform = `translate(${r10}px,${s10}px)`, i10.transitionDuration = "0s", t10;
    }
  }
  function a9(t10, e10, n10) {
    const r10 = t10.cloneNode();
    t10._vtc && t10._vtc.forEach((o10) => {
      o10.split(/\s+/).forEach((l10) => l10 && r10.classList.remove(l10));
    }), n10.split(/\s+/).forEach((o10) => o10 && r10.classList.add(o10)), r10.style.display = "none";
    const s10 = e10.nodeType === 1 ? e10 : e10.parentNode;
    s10.appendChild(r10);
    const { hasTransform: i10 } = p5(r10);
    return s10.removeChild(r10), i10;
  }
  const xr = (t10) => {
    const e10 = t10.props["onUpdate:modelValue"] || t10.props["onModelCompat:input"];
    return K$1(e10) ? (n10) => cr(e10, n10) : e10;
  };
  function c9(t10) {
    t10.target.composing = true;
  }
  function p2(t10) {
    const e10 = t10.target;
    e10.composing && (e10.composing = false, e10.dispatchEvent(new Event("input")));
  }
  const Oi = {
    created(t10, { modifiers: { lazy: e10, trim: n10, number: r10 } }, s10) {
      t10._assign = xr(s10);
      const i10 = r10 || s10.props && s10.props.type === "number";
      Hn(t10, e10 ? "change" : "input", (o10) => {
        if (o10.target.composing)
          return;
        let l10 = t10.value;
        n10 && (l10 = l10.trim()), i10 && (l10 = An$1(l10)), t10._assign(l10);
      }), n10 && Hn(t10, "change", () => {
        t10.value = t10.value.trim();
      }), e10 || (Hn(t10, "compositionstart", c9), Hn(t10, "compositionend", p2), Hn(t10, "change", p2));
    },
    mounted(t10, { value: e10 }) {
      t10.value = e10 == null ? "" : e10;
    },
    beforeUpdate(t10, { value: e10, modifiers: { lazy: n10, trim: r10, number: s10 } }, i10) {
      if (t10._assign = xr(i10), t10.composing || document.activeElement === t10 && t10.type !== "range" && (n10 || r10 && t10.value.trim() === e10 || (s10 || t10.type === "number") && An$1(t10.value) === e10))
        return;
      const o10 = e10 == null ? "" : e10;
      t10.value !== o10 && (t10.value = o10);
    }
  }, ql = {
    deep: true,
    created(t10, e10, n10) {
      t10._assign = xr(n10), Hn(t10, "change", () => {
        const r10 = t10._modelValue, s10 = _s(t10), i10 = t10.checked, o10 = t10._assign;
        if (K$1(r10)) {
          const l10 = w0(r10, s10), a10 = l10 !== -1;
          if (i10 && !a10)
            o10(r10.concat(s10));
          else if (!i10 && a10) {
            const c10 = [...r10];
            c10.splice(l10, 1), o10(c10);
          }
        } else if (Gr(r10)) {
          const l10 = new Set(r10);
          i10 ? l10.add(s10) : l10.delete(s10), o10(l10);
        } else
          o10(C5(t10, i10));
      });
    },
    mounted: g2,
    beforeUpdate(t10, e10, n10) {
      t10._assign = xr(n10), g2(t10, e10, n10);
    }
  };
  function g2(t10, { value: e10, oldValue: n10 }, r10) {
    t10._modelValue = e10, K$1(e10) ? t10.checked = w0(e10, r10.props.value) > -1 : Gr(e10) ? t10.checked = e10.has(r10.props.value) : e10 !== n10 && (t10.checked = jn(e10, C5(t10, true)));
  }
  const Kl = {
    created(t10, { value: e10 }, n10) {
      t10.checked = jn(e10, n10.props.value), t10._assign = xr(n10), Hn(t10, "change", () => {
        t10._assign(_s(t10));
      });
    },
    beforeUpdate(t10, { value: e10, oldValue: n10 }, r10) {
      t10._assign = xr(r10), e10 !== n10 && (t10.checked = jn(e10, r10.props.value));
    }
  }, y5 = {
    deep: true,
    created(t10, { value: e10, modifiers: { number: n10 } }, r10) {
      const s10 = Gr(e10);
      Hn(t10, "change", () => {
        const i10 = Array.prototype.filter.call(t10.options, (o10) => o10.selected).map((o10) => n10 ? An$1(_s(o10)) : _s(o10));
        t10._assign(t10.multiple ? s10 ? new Set(i10) : i10 : i10[0]);
      }), t10._assign = xr(r10);
    },
    mounted(t10, { value: e10 }) {
      m2(t10, e10);
    },
    beforeUpdate(t10, e10, n10) {
      t10._assign = xr(n10);
    },
    updated(t10, { value: e10 }) {
      m2(t10, e10);
    }
  };
  function m2(t10, e10) {
    const n10 = t10.multiple;
    if (!(n10 && !K$1(e10) && !Gr(e10))) {
      for (let r10 = 0, s10 = t10.options.length; r10 < s10; r10++) {
        const i10 = t10.options[r10], o10 = _s(i10);
        if (n10)
          K$1(e10) ? i10.selected = w0(e10, o10) > -1 : i10.selected = e10.has(o10);
        else if (jn(_s(i10), e10)) {
          t10.selectedIndex !== r10 && (t10.selectedIndex = r10);
          return;
        }
      }
      !n10 && t10.selectedIndex !== -1 && (t10.selectedIndex = -1);
    }
  }
  function _s(t10) {
    return "_value" in t10 ? t10._value : t10.value;
  }
  function C5(t10, e10) {
    const n10 = e10 ? "_trueValue" : "_falseValue";
    return n10 in t10 ? t10[n10] : e10;
  }
  const Yl = {
    created(t10, e10, n10) {
      ci(t10, e10, n10, null, "created");
    },
    mounted(t10, e10, n10) {
      ci(t10, e10, n10, null, "mounted");
    },
    beforeUpdate(t10, e10, n10, r10) {
      ci(t10, e10, n10, r10, "beforeUpdate");
    },
    updated(t10, e10, n10, r10) {
      ci(t10, e10, n10, r10, "updated");
    }
  };
  function v5(t10, e10) {
    switch (t10) {
      case "SELECT":
        return y5;
      case "TEXTAREA":
        return Oi;
      default:
        switch (e10) {
          case "checkbox":
            return ql;
          case "radio":
            return Kl;
          default:
            return Oi;
        }
    }
  }
  function ci(t10, e10, n10, r10, s10) {
    const o10 = v5(t10.tagName, n10.props && n10.props.type)[s10];
    o10 && o10(t10, e10, n10, r10);
  }
  function u9() {
    Oi.getSSRProps = ({ value: t10 }) => ({ value: t10 }), Kl.getSSRProps = ({ value: t10 }, e10) => {
      if (e10.props && jn(e10.props.value, t10))
        return { checked: true };
    }, ql.getSSRProps = ({ value: t10 }, e10) => {
      if (K$1(t10)) {
        if (e10.props && w0(t10, e10.props.value) > -1)
          return { checked: true };
      } else if (Gr(t10)) {
        if (e10.props && t10.has(e10.props.value))
          return { checked: true };
      } else if (t10)
        return { checked: true };
    }, Yl.getSSRProps = (t10, e10) => {
      if (typeof e10.type != "string")
        return;
      const n10 = v5(
        e10.type.toUpperCase(),
        e10.props && e10.props.type
      );
      if (n10.getSSRProps)
        return n10.getSSRProps(t10, e10);
    };
  }
  const h9 = ["ctrl", "shift", "alt", "meta"], d9 = {
    stop: (t10) => t10.stopPropagation(),
    prevent: (t10) => t10.preventDefault(),
    self: (t10) => t10.target !== t10.currentTarget,
    ctrl: (t10) => !t10.ctrlKey,
    shift: (t10) => !t10.shiftKey,
    alt: (t10) => !t10.altKey,
    meta: (t10) => !t10.metaKey,
    left: (t10) => "button" in t10 && t10.button !== 0,
    middle: (t10) => "button" in t10 && t10.button !== 1,
    right: (t10) => "button" in t10 && t10.button !== 2,
    exact: (t10, e10) => h9.some((n10) => t10[`${n10}Key`] && !e10.includes(n10))
  }, M0 = (t10, e10) => (n10, ...r10) => {
    for (let s10 = 0; s10 < e10.length; s10++) {
      const i10 = d9[e10[s10]];
      if (i10 && i10(n10, e10))
        return;
    }
    return t10(n10, ...r10);
  }, f9 = {
    esc: "escape",
    space: " ",
    up: "arrow-up",
    left: "arrow-left",
    right: "arrow-right",
    down: "arrow-down",
    delete: "backspace"
  }, p9 = (t10, e10) => {
    let n10, r10 = null;
    return r10 = Pn(), In.isCompatEnabled("CONFIG_KEY_CODES", r10) && r10 && (n10 = r10.appContext.config.keyCodes), (s10) => {
      if (!("key" in s10))
        return;
      const i10 = St$1(s10.key);
      if (e10.some((o10) => o10 === i10 || f9[o10] === i10))
        return t10(s10);
      {
        const o10 = String(s10.keyCode);
        if (In.isCompatEnabled("V_ON_KEYCODE_MODIFIER", r10) && e10.some((l10) => l10 == o10))
          return t10(s10);
        if (n10)
          for (const l10 of e10) {
            const a10 = n10[l10];
            if (a10 && (K$1(a10) ? a10.some((u10) => String(u10) === o10) : String(a10) === o10))
              return t10(s10);
          }
      }
    };
  }, N0 = {
    beforeMount(t10, { value: e10 }, { transition: n10 }) {
      t10._vod = t10.style.display === "none" ? "" : t10.style.display, n10 && e10 ? n10.beforeEnter(t10) : Us(t10, e10);
    },
    mounted(t10, { value: e10 }, { transition: n10 }) {
      n10 && e10 && n10.enter(t10);
    },
    updated(t10, { value: e10, oldValue: n10 }, { transition: r10 }) {
      !e10 != !n10 && (r10 ? e10 ? (r10.beforeEnter(t10), Us(t10, true), r10.enter(t10)) : r10.leave(t10, () => {
        Us(t10, false);
      }) : Us(t10, e10));
    },
    beforeUnmount(t10, { value: e10 }) {
      Us(t10, e10);
    }
  };
  function Us(t10, e10) {
    t10.style.display = e10 ? t10._vod : "none";
  }
  function g9() {
    N0.getSSRProps = ({ value: t10 }) => {
      if (!t10)
        return { style: { display: "none" } };
    };
  }
  const b5 = /* @__PURE__ */ Oe$1({ patchProp: Yf }, Pf);
  let e0, x2 = false;
  function w5() {
    return e0 || (e0 = K3(b5));
  }
  function E5() {
    return e0 = x2 ? e0 : Y3(b5), x2 = true, e0;
  }
  const Ho = (...t10) => {
    w5().render(...t10);
  }, T5 = (...t10) => {
    E5().hydrate(...t10);
  }, P0 = (...t10) => {
    const e10 = w5().createApp(...t10), { mount: n10 } = e10;
    return e10.mount = (r10) => {
      const s10 = S5(r10);
      if (!s10)
        return;
      const i10 = e10._component;
      !ue$1(i10) && !i10.render && !i10.template && (i10.template = s10.innerHTML), s10.innerHTML = "";
      const o10 = n10(s10, false, s10 instanceof SVGElement);
      return s10 instanceof Element && (s10.removeAttribute("v-cloak"), s10.setAttribute("data-v-app", "")), o10;
    }, e10;
  }, m9 = (...t10) => {
    const e10 = E5().createApp(...t10), { mount: n10 } = e10;
    return e10.mount = (r10) => {
      const s10 = S5(r10);
      if (s10)
        return n10(s10, true, s10 instanceof SVGElement);
    }, e10;
  };
  function S5(t10) {
    return Ke$1(t10) ? document.querySelector(t10) : t10;
  }
  let L2 = false;
  const x9 = () => {
    L2 || (L2 = true, u9(), g9());
  };
  var L9 = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    render: Ho,
    hydrate: T5,
    createApp: P0,
    createSSRApp: m9,
    initDirectivesForSSR: x9,
    defineCustomElement: h5,
    defineSSRCustomElement: Qf,
    VueElement: g1,
    useCssModule: e9,
    useCssVars: t9,
    Transition: I0,
    TransitionGroup: _5,
    vModelText: Oi,
    vModelCheckbox: ql,
    vModelRadio: Kl,
    vModelSelect: y5,
    vModelDynamic: Yl,
    withModifiers: M0,
    withKeys: p9,
    vShow: N0,
    reactive: Rn$1,
    ref: ge,
    readonly: wl,
    unref: _e,
    proxyRefs: kl,
    isRef: gt,
    toRef: n3,
    toRefs: Rl,
    isProxy: El,
    isReactive: Un,
    isReadonly: $r,
    isShallow: h0,
    customRef: $8,
    triggerRef: F8,
    shallowRef: e3,
    shallowReactive: Ju,
    shallowReadonly: N8,
    markRaw: Tl,
    toRaw: we$1,
    effect: a8,
    stop: c8,
    ReactiveEffect: S0,
    effectScope: $u,
    EffectScope: Cl,
    getCurrentScope: s8,
    onScopeDispose: i8,
    computed: G$1,
    watch: Yt$1,
    watchEffect: Qt$1,
    watchPostEffect: d3,
    watchSyncEffect: dd,
    onBeforeMount: C3,
    onMounted: We$1,
    onBeforeUpdate: v3,
    onUpdated: R0,
    onBeforeUnmount: x0,
    onUnmounted: ht,
    onActivated: L3,
    onDeactivated: _3,
    onRenderTracked: E3,
    onRenderTriggered: w3,
    onErrorCaptured: T3,
    onServerPrefetch: b3,
    provide: Ut$1,
    inject: lt,
    nextTick: gr,
    defineComponent: Ye$1,
    defineAsyncComponent: hs,
    useAttrs: wf,
    useSlots: bf,
    defineProps: _f,
    defineEmits: yf,
    defineExpose: Cf,
    withDefaults: vf,
    mergeDefaults: Ef,
    createPropsRestProxy: Tf,
    withAsyncContext: Sf,
    getCurrentInstance: Pn,
    h: ct,
    createVNode: V$1,
    cloneVNode: an$1,
    mergeProps: f1,
    isVNode: Jt$1,
    Fragment: Fe$1,
    Text: Ur,
    Comment: yt,
    Static: Fr,
    Teleport: Q3,
    Suspense: ld,
    KeepAlive: x3,
    BaseTransition: Hl,
    withDirectives: a1,
    useSSRContext: a5,
    ssrContextKey: l5,
    createRenderer: K3,
    createHydrationRenderer: Y3,
    queuePostFlushCb: Il,
    warn: z8,
    handleError: jr,
    callWithErrorHandling: En$1,
    callWithAsyncErrorHandling: $t$1,
    resolveComponent: me$1,
    resolveDirective: R3,
    resolveDynamicComponent: ks,
    registerRuntimeCompiler: mf,
    isRuntimeOnly: Po,
    useTransitionState: $l,
    resolveTransitionHooks: xs,
    setTransitionHooks: Hr,
    getTransitionRawChildren: o1,
    initCustomFormatter: Af,
    get devtools() {
      return ns;
    },
    setDevtoolsHook: l3,
    withCtx: jt$1,
    pushScopeId: Ss,
    popScopeId: As,
    withScopeId: td,
    renderList: On$1,
    toHandlers: F3,
    renderSlot: Vl,
    createSlots: N3,
    withMemo: kf,
    isMemoSame: c5,
    openBlock: k$1,
    createBlock: Re$1,
    setBlockTracking: Io,
    createTextVNode: dn$1,
    createCommentVNode: xe$1,
    createStaticVNode: h1,
    createElementVNode: A,
    createElementBlock: q$1,
    guardReactiveProps: r5,
    toDisplayString: Ve$1,
    camelize: Rt$1,
    capitalize: T0,
    toHandlerKey: ls,
    normalizeProps: q6,
    normalizeClass: ve$1,
    normalizeStyle: Ce$1,
    transformVNodeArgs: hf,
    version: u5,
    ssrUtils: Of,
    resolveFilter: If,
    compatUtils: In
  });
  function _9(...t10) {
    const e10 = P0(...t10);
    return In.isCompatEnabled("RENDER_FUNCTION", null) && (e10.component("__compat__transition", I0), e10.component("__compat__transition-group", _5), e10.component("__compat__keep-alive", x3), e10._context.directives.show = N0, e10._context.directives.model = Yl), e10;
  }
  function y9() {
    const t10 = In.createCompatVue(P0, _9);
    return Oe$1(t10, L9), t10;
  }
  const A5 = y9();
  A5.compile = () => {
  };
  function C9() {
    return k5().__VUE_DEVTOOLS_GLOBAL_HOOK__;
  }
  function k5() {
    return typeof navigator < "u" && typeof window < "u" ? window : typeof global < "u" ? global : {};
  }
  const v9 = typeof Proxy == "function", b9 = "devtools-plugin:setup", w9 = "plugin:settings:set";
  let Qr, Uo;
  function E9() {
    var t10;
    return Qr !== void 0 || (typeof window < "u" && window.performance ? (Qr = true, Uo = window.performance) : typeof global < "u" && ((t10 = global.perf_hooks) === null || t10 === void 0 ? void 0 : t10.performance) ? (Qr = true, Uo = global.perf_hooks.performance) : Qr = false), Qr;
  }
  function T9() {
    return E9() ? Uo.now() : Date.now();
  }
  class S9 {
    constructor(e10, n10) {
      this.target = null, this.targetQueue = [], this.onQueue = [], this.plugin = e10, this.hook = n10;
      const r10 = {};
      if (e10.settings)
        for (const o10 in e10.settings) {
          const l10 = e10.settings[o10];
          r10[o10] = l10.defaultValue;
        }
      const s10 = `__vue-devtools-plugin-settings__${e10.id}`;
      let i10 = Object.assign({}, r10);
      try {
        const o10 = localStorage.getItem(s10), l10 = JSON.parse(o10);
        Object.assign(i10, l10);
      } catch {
      }
      this.fallbacks = {
        getSettings() {
          return i10;
        },
        setSettings(o10) {
          try {
            localStorage.setItem(s10, JSON.stringify(o10));
          } catch {
          }
          i10 = o10;
        },
        now() {
          return T9();
        }
      }, n10 && n10.on(w9, (o10, l10) => {
        o10 === this.plugin.id && this.fallbacks.setSettings(l10);
      }), this.proxiedOn = new Proxy({}, {
        get: (o10, l10) => this.target ? this.target.on[l10] : (...a10) => {
          this.onQueue.push({
            method: l10,
            args: a10
          });
        }
      }), this.proxiedTarget = new Proxy({}, {
        get: (o10, l10) => this.target ? this.target[l10] : l10 === "on" ? this.proxiedOn : Object.keys(this.fallbacks).includes(l10) ? (...a10) => (this.targetQueue.push({
          method: l10,
          args: a10,
          resolve: () => {
          }
        }), this.fallbacks[l10](...a10)) : (...a10) => new Promise((c10) => {
          this.targetQueue.push({
            method: l10,
            args: a10,
            resolve: c10
          });
        })
      });
    }
    async setRealTarget(e10) {
      this.target = e10;
      for (const n10 of this.onQueue)
        this.target.on[n10.method](...n10.args);
      for (const n10 of this.targetQueue)
        n10.resolve(await this.target[n10.method](...n10.args));
    }
  }
  function A9(t10, e10) {
    const n10 = t10, r10 = k5(), s10 = C9(), i10 = v9 && n10.enableEarlyProxy;
    if (s10 && (r10.__VUE_DEVTOOLS_PLUGIN_API_AVAILABLE__ || !i10))
      s10.emit(b9, t10, e10);
    else {
      const o10 = i10 ? new S9(n10, s10) : null;
      (r10.__VUE_DEVTOOLS_PLUGINS__ = r10.__VUE_DEVTOOLS_PLUGINS__ || []).push({
        pluginDescriptor: n10,
        setupFn: e10,
        proxy: o10
      }), o10 && e10(o10.proxiedTarget);
    }
  }
  /*!
   * vuex v4.1.0
   * (c) 2022 Evan You
   * @license MIT
   */
  var R5 = "store";
  function Fn(t10) {
    return t10 === void 0 && (t10 = null), lt(t10 !== null ? t10 : R5);
  }
  function Rs(t10, e10) {
    Object.keys(t10).forEach(function(n10) {
      return e10(t10[n10], n10);
    });
  }
  function O5(t10) {
    return t10 !== null && typeof t10 == "object";
  }
  function k9(t10) {
    return t10 && typeof t10.then == "function";
  }
  function R9(t10, e10) {
    return function() {
      return t10(e10);
    };
  }
  function I5(t10, e10, n10) {
    return e10.indexOf(t10) < 0 && (n10 && n10.prepend ? e10.unshift(t10) : e10.push(t10)), function() {
      var r10 = e10.indexOf(t10);
      r10 > -1 && e10.splice(r10, 1);
    };
  }
  function M5(t10, e10) {
    t10._actions = /* @__PURE__ */ Object.create(null), t10._mutations = /* @__PURE__ */ Object.create(null), t10._wrappedGetters = /* @__PURE__ */ Object.create(null), t10._modulesNamespaceMap = /* @__PURE__ */ Object.create(null);
    var n10 = t10.state;
    m1(t10, n10, [], t10._modules.root, true), Xl(t10, n10, e10);
  }
  function Xl(t10, e10, n10) {
    var r10 = t10._state, s10 = t10._scope;
    t10.getters = {}, t10._makeLocalGettersCache = /* @__PURE__ */ Object.create(null);
    var i10 = t10._wrappedGetters, o10 = {}, l10 = {}, a10 = $u(true);
    a10.run(function() {
      Rs(i10, function(c10, u10) {
        o10[u10] = R9(c10, t10), l10[u10] = G$1(function() {
          return o10[u10]();
        }), Object.defineProperty(t10.getters, u10, {
          get: function() {
            return l10[u10].value;
          },
          enumerable: true
        });
      });
    }), t10._state = Rn$1({
      data: e10
    }), t10._scope = a10, t10.strict && P9(t10), r10 && n10 && t10._withCommit(function() {
      r10.data = null;
    }), s10 && s10.stop();
  }
  function m1(t10, e10, n10, r10, s10) {
    var i10 = !n10.length, o10 = t10._modules.getNamespace(n10);
    if (r10.namespaced && (t10._modulesNamespaceMap[o10], t10._modulesNamespaceMap[o10] = r10), !i10 && !s10) {
      var l10 = Ql(e10, n10.slice(0, -1)), a10 = n10[n10.length - 1];
      t10._withCommit(function() {
        l10[a10] = r10.state;
      });
    }
    var c10 = r10.context = O9(t10, o10, n10);
    r10.forEachMutation(function(u10, h10) {
      var d10 = o10 + h10;
      I9(t10, d10, u10, c10);
    }), r10.forEachAction(function(u10, h10) {
      var d10 = u10.root ? h10 : o10 + h10, p10 = u10.handler || u10;
      M9(t10, d10, p10, c10);
    }), r10.forEachGetter(function(u10, h10) {
      var d10 = o10 + h10;
      N9(t10, d10, u10, c10);
    }), r10.forEachChild(function(u10, h10) {
      m1(t10, e10, n10.concat(h10), u10, s10);
    });
  }
  function O9(t10, e10, n10) {
    var r10 = e10 === "", s10 = {
      dispatch: r10 ? t10.dispatch : function(i10, o10, l10) {
        var a10 = Ii(i10, o10, l10), c10 = a10.payload, u10 = a10.options, h10 = a10.type;
        return (!u10 || !u10.root) && (h10 = e10 + h10), t10.dispatch(h10, c10);
      },
      commit: r10 ? t10.commit : function(i10, o10, l10) {
        var a10 = Ii(i10, o10, l10), c10 = a10.payload, u10 = a10.options, h10 = a10.type;
        (!u10 || !u10.root) && (h10 = e10 + h10), t10.commit(h10, c10, u10);
      }
    };
    return Object.defineProperties(s10, {
      getters: {
        get: r10 ? function() {
          return t10.getters;
        } : function() {
          return N5(t10, e10);
        }
      },
      state: {
        get: function() {
          return Ql(t10.state, n10);
        }
      }
    }), s10;
  }
  function N5(t10, e10) {
    if (!t10._makeLocalGettersCache[e10]) {
      var n10 = {}, r10 = e10.length;
      Object.keys(t10.getters).forEach(function(s10) {
        if (s10.slice(0, r10) === e10) {
          var i10 = s10.slice(r10);
          Object.defineProperty(n10, i10, {
            get: function() {
              return t10.getters[s10];
            },
            enumerable: true
          });
        }
      }), t10._makeLocalGettersCache[e10] = n10;
    }
    return t10._makeLocalGettersCache[e10];
  }
  function I9(t10, e10, n10, r10) {
    var s10 = t10._mutations[e10] || (t10._mutations[e10] = []);
    s10.push(function(o10) {
      n10.call(t10, r10.state, o10);
    });
  }
  function M9(t10, e10, n10, r10) {
    var s10 = t10._actions[e10] || (t10._actions[e10] = []);
    s10.push(function(o10) {
      var l10 = n10.call(t10, {
        dispatch: r10.dispatch,
        commit: r10.commit,
        getters: r10.getters,
        state: r10.state,
        rootGetters: t10.getters,
        rootState: t10.state
      }, o10);
      return k9(l10) || (l10 = Promise.resolve(l10)), t10._devtoolHook ? l10.catch(function(a10) {
        throw t10._devtoolHook.emit("vuex:error", a10), a10;
      }) : l10;
    });
  }
  function N9(t10, e10, n10, r10) {
    t10._wrappedGetters[e10] || (t10._wrappedGetters[e10] = function(i10) {
      return n10(
        r10.state,
        r10.getters,
        i10.state,
        i10.getters
      );
    });
  }
  function P9(t10) {
    Yt$1(function() {
      return t10._state.data;
    }, function() {
    }, { deep: true, flush: "sync" });
  }
  function Ql(t10, e10) {
    return e10.reduce(function(n10, r10) {
      return n10[r10];
    }, t10);
  }
  function Ii(t10, e10, n10) {
    return O5(t10) && t10.type && (n10 = e10, e10 = t10, t10 = t10.type), { type: t10, payload: e10, options: n10 };
  }
  var F9 = "vuex bindings", _2 = "vuex:mutations", to = "vuex:actions", Jr = "vuex", D9 = 0;
  function B9(t10, e10) {
    A9(
      {
        id: "org.vuejs.vuex",
        app: t10,
        label: "Vuex",
        homepage: "https://next.vuex.vuejs.org/",
        logo: "https://vuejs.org/images/icons/favicon-96x96.png",
        packageName: "vuex",
        componentStateTypes: [F9]
      },
      function(n10) {
        n10.addTimelineLayer({
          id: _2,
          label: "Vuex Mutations",
          color: y2
        }), n10.addTimelineLayer({
          id: to,
          label: "Vuex Actions",
          color: y2
        }), n10.addInspector({
          id: Jr,
          label: "Vuex",
          icon: "storage",
          treeFilterPlaceholder: "Filter stores..."
        }), n10.on.getInspectorTree(function(r10) {
          if (r10.app === t10 && r10.inspectorId === Jr)
            if (r10.filter) {
              var s10 = [];
              B5(s10, e10._modules.root, r10.filter, ""), r10.rootNodes = s10;
            } else
              r10.rootNodes = [
                D5(e10._modules.root, "")
              ];
        }), n10.on.getInspectorState(function(r10) {
          if (r10.app === t10 && r10.inspectorId === Jr) {
            var s10 = r10.nodeId;
            N5(e10, s10), r10.state = U9(
              z9(e10._modules, s10),
              s10 === "root" ? e10.getters : e10._makeLocalGettersCache,
              s10
            );
          }
        }), n10.on.editInspectorState(function(r10) {
          if (r10.app === t10 && r10.inspectorId === Jr) {
            var s10 = r10.nodeId, i10 = r10.path;
            s10 !== "root" && (i10 = s10.split("/").filter(Boolean).concat(i10)), e10._withCommit(function() {
              r10.set(e10._state.data, i10, r10.state.value);
            });
          }
        }), e10.subscribe(function(r10, s10) {
          var i10 = {};
          r10.payload && (i10.payload = r10.payload), i10.state = s10, n10.notifyComponentUpdate(), n10.sendInspectorTree(Jr), n10.sendInspectorState(Jr), n10.addTimelineEvent({
            layerId: _2,
            event: {
              time: Date.now(),
              title: r10.type,
              data: i10
            }
          });
        }), e10.subscribeAction({
          before: function(r10, s10) {
            var i10 = {};
            r10.payload && (i10.payload = r10.payload), r10._id = D9++, r10._time = Date.now(), i10.state = s10, n10.addTimelineEvent({
              layerId: to,
              event: {
                time: r10._time,
                title: r10.type,
                groupId: r10._id,
                subtitle: "start",
                data: i10
              }
            });
          },
          after: function(r10, s10) {
            var i10 = {}, o10 = Date.now() - r10._time;
            i10.duration = {
              _custom: {
                type: "duration",
                display: o10 + "ms",
                tooltip: "Action duration",
                value: o10
              }
            }, r10.payload && (i10.payload = r10.payload), i10.state = s10, n10.addTimelineEvent({
              layerId: to,
              event: {
                time: Date.now(),
                title: r10.type,
                groupId: r10._id,
                subtitle: "end",
                data: i10
              }
            });
          }
        });
      }
    );
  }
  var y2 = 8702998, $9 = 6710886, H9 = 16777215, P5 = {
    label: "namespaced",
    textColor: H9,
    backgroundColor: $9
  };
  function F5(t10) {
    return t10 && t10 !== "root" ? t10.split("/").slice(-2, -1)[0] : "Root";
  }
  function D5(t10, e10) {
    return {
      id: e10 || "root",
      label: F5(e10),
      tags: t10.namespaced ? [P5] : [],
      children: Object.keys(t10._children).map(
        function(n10) {
          return D5(
            t10._children[n10],
            e10 + n10 + "/"
          );
        }
      )
    };
  }
  function B5(t10, e10, n10, r10) {
    r10.includes(n10) && t10.push({
      id: r10 || "root",
      label: r10.endsWith("/") ? r10.slice(0, r10.length - 1) : r10 || "Root",
      tags: e10.namespaced ? [P5] : []
    }), Object.keys(e10._children).forEach(function(s10) {
      B5(t10, e10._children[s10], n10, r10 + s10 + "/");
    });
  }
  function U9(t10, e10, n10) {
    e10 = n10 === "root" ? e10 : e10[n10];
    var r10 = Object.keys(e10), s10 = {
      state: Object.keys(t10.state).map(function(o10) {
        return {
          key: o10,
          editable: true,
          value: t10.state[o10]
        };
      })
    };
    if (r10.length) {
      var i10 = V9(e10);
      s10.getters = Object.keys(i10).map(function(o10) {
        return {
          key: o10.endsWith("/") ? F5(o10) : o10,
          editable: false,
          value: Vo(function() {
            return i10[o10];
          })
        };
      });
    }
    return s10;
  }
  function V9(t10) {
    var e10 = {};
    return Object.keys(t10).forEach(function(n10) {
      var r10 = n10.split("/");
      if (r10.length > 1) {
        var s10 = e10, i10 = r10.pop();
        r10.forEach(function(o10) {
          s10[o10] || (s10[o10] = {
            _custom: {
              value: {},
              display: o10,
              tooltip: "Module",
              abstract: true
            }
          }), s10 = s10[o10]._custom.value;
        }), s10[i10] = Vo(function() {
          return t10[n10];
        });
      } else
        e10[n10] = Vo(function() {
          return t10[n10];
        });
    }), e10;
  }
  function z9(t10, e10) {
    var n10 = e10.split("/").filter(function(r10) {
      return r10;
    });
    return n10.reduce(
      function(r10, s10, i10) {
        var o10 = r10[s10];
        if (!o10)
          throw new Error('Missing module "' + s10 + '" for path "' + e10 + '".');
        return i10 === n10.length - 1 ? o10 : o10._children;
      },
      e10 === "root" ? t10 : t10.root._children
    );
  }
  function Vo(t10) {
    try {
      return t10();
    } catch (e10) {
      return e10;
    }
  }
  var fn$1 = function(e10, n10) {
    this.runtime = n10, this._children = /* @__PURE__ */ Object.create(null), this._rawModule = e10;
    var r10 = e10.state;
    this.state = (typeof r10 == "function" ? r10() : r10) || {};
  }, $5 = { namespaced: { configurable: true } };
  $5.namespaced.get = function() {
    return !!this._rawModule.namespaced;
  };
  fn$1.prototype.addChild = function(e10, n10) {
    this._children[e10] = n10;
  };
  fn$1.prototype.removeChild = function(e10) {
    delete this._children[e10];
  };
  fn$1.prototype.getChild = function(e10) {
    return this._children[e10];
  };
  fn$1.prototype.hasChild = function(e10) {
    return e10 in this._children;
  };
  fn$1.prototype.update = function(e10) {
    this._rawModule.namespaced = e10.namespaced, e10.actions && (this._rawModule.actions = e10.actions), e10.mutations && (this._rawModule.mutations = e10.mutations), e10.getters && (this._rawModule.getters = e10.getters);
  };
  fn$1.prototype.forEachChild = function(e10) {
    Rs(this._children, e10);
  };
  fn$1.prototype.forEachGetter = function(e10) {
    this._rawModule.getters && Rs(this._rawModule.getters, e10);
  };
  fn$1.prototype.forEachAction = function(e10) {
    this._rawModule.actions && Rs(this._rawModule.actions, e10);
  };
  fn$1.prototype.forEachMutation = function(e10) {
    this._rawModule.mutations && Rs(this._rawModule.mutations, e10);
  };
  Object.defineProperties(fn$1.prototype, $5);
  var Zr = function(e10) {
    this.register([], e10, false);
  };
  Zr.prototype.get = function(e10) {
    return e10.reduce(function(n10, r10) {
      return n10.getChild(r10);
    }, this.root);
  };
  Zr.prototype.getNamespace = function(e10) {
    var n10 = this.root;
    return e10.reduce(function(r10, s10) {
      return n10 = n10.getChild(s10), r10 + (n10.namespaced ? s10 + "/" : "");
    }, "");
  };
  Zr.prototype.update = function(e10) {
    H5([], this.root, e10);
  };
  Zr.prototype.register = function(e10, n10, r10) {
    var s10 = this;
    r10 === void 0 && (r10 = true);
    var i10 = new fn$1(n10, r10);
    if (e10.length === 0)
      this.root = i10;
    else {
      var o10 = this.get(e10.slice(0, -1));
      o10.addChild(e10[e10.length - 1], i10);
    }
    n10.modules && Rs(n10.modules, function(l10, a10) {
      s10.register(e10.concat(a10), l10, r10);
    });
  };
  Zr.prototype.unregister = function(e10) {
    var n10 = this.get(e10.slice(0, -1)), r10 = e10[e10.length - 1], s10 = n10.getChild(r10);
    !s10 || !s10.runtime || n10.removeChild(r10);
  };
  Zr.prototype.isRegistered = function(e10) {
    var n10 = this.get(e10.slice(0, -1)), r10 = e10[e10.length - 1];
    return n10 ? n10.hasChild(r10) : false;
  };
  function H5(t10, e10, n10) {
    if (e10.update(n10), n10.modules)
      for (var r10 in n10.modules) {
        if (!e10.getChild(r10))
          return;
        H5(
          t10.concat(r10),
          e10.getChild(r10),
          n10.modules[r10]
        );
      }
  }
  function U5(t10) {
    return new Vt$1(t10);
  }
  var Vt$1 = function(e10) {
    var n10 = this;
    e10 === void 0 && (e10 = {});
    var r10 = e10.plugins;
    r10 === void 0 && (r10 = []);
    var s10 = e10.strict;
    s10 === void 0 && (s10 = false);
    var i10 = e10.devtools;
    this._committing = false, this._actions = /* @__PURE__ */ Object.create(null), this._actionSubscribers = [], this._mutations = /* @__PURE__ */ Object.create(null), this._wrappedGetters = /* @__PURE__ */ Object.create(null), this._modules = new Zr(e10), this._modulesNamespaceMap = /* @__PURE__ */ Object.create(null), this._subscribers = [], this._makeLocalGettersCache = /* @__PURE__ */ Object.create(null), this._scope = null, this._devtools = i10;
    var o10 = this, l10 = this, a10 = l10.dispatch, c10 = l10.commit;
    this.dispatch = function(d10, p10) {
      return a10.call(o10, d10, p10);
    }, this.commit = function(d10, p10, g) {
      return c10.call(o10, d10, p10, g);
    }, this.strict = s10;
    var u10 = this._modules.root.state;
    m1(this, u10, [], this._modules.root), Xl(this, u10), r10.forEach(function(h10) {
      return h10(n10);
    });
  }, Jl = { state: { configurable: true } };
  Vt$1.prototype.install = function(e10, n10) {
    e10.provide(n10 || R5, this), e10.config.globalProperties.$store = this;
    var r10 = this._devtools !== void 0 ? this._devtools : false;
    r10 && B9(e10, this);
  };
  Jl.state.get = function() {
    return this._state.data;
  };
  Jl.state.set = function(t10) {
  };
  Vt$1.prototype.commit = function(e10, n10, r10) {
    var s10 = this, i10 = Ii(e10, n10, r10), o10 = i10.type, l10 = i10.payload, a10 = { type: o10, payload: l10 }, c10 = this._mutations[o10];
    !c10 || (this._withCommit(function() {
      c10.forEach(function(h10) {
        h10(l10);
      });
    }), this._subscribers.slice().forEach(function(u10) {
      return u10(a10, s10.state);
    }));
  };
  Vt$1.prototype.dispatch = function(e10, n10) {
    var r10 = this, s10 = Ii(e10, n10), i10 = s10.type, o10 = s10.payload, l10 = { type: i10, payload: o10 }, a10 = this._actions[i10];
    if (!!a10) {
      try {
        this._actionSubscribers.slice().filter(function(u10) {
          return u10.before;
        }).forEach(function(u10) {
          return u10.before(l10, r10.state);
        });
      } catch {
      }
      var c10 = a10.length > 1 ? Promise.all(a10.map(function(u10) {
        return u10(o10);
      })) : a10[0](o10);
      return new Promise(function(u10, h10) {
        c10.then(function(d10) {
          try {
            r10._actionSubscribers.filter(function(p10) {
              return p10.after;
            }).forEach(function(p10) {
              return p10.after(l10, r10.state);
            });
          } catch {
          }
          u10(d10);
        }, function(d10) {
          try {
            r10._actionSubscribers.filter(function(p10) {
              return p10.error;
            }).forEach(function(p10) {
              return p10.error(l10, r10.state, d10);
            });
          } catch {
          }
          h10(d10);
        });
      });
    }
  };
  Vt$1.prototype.subscribe = function(e10, n10) {
    return I5(e10, this._subscribers, n10);
  };
  Vt$1.prototype.subscribeAction = function(e10, n10) {
    var r10 = typeof e10 == "function" ? { before: e10 } : e10;
    return I5(r10, this._actionSubscribers, n10);
  };
  Vt$1.prototype.watch = function(e10, n10, r10) {
    var s10 = this;
    return Yt$1(function() {
      return e10(s10.state, s10.getters);
    }, n10, Object.assign({}, r10));
  };
  Vt$1.prototype.replaceState = function(e10) {
    var n10 = this;
    this._withCommit(function() {
      n10._state.data = e10;
    });
  };
  Vt$1.prototype.registerModule = function(e10, n10, r10) {
    r10 === void 0 && (r10 = {}), typeof e10 == "string" && (e10 = [e10]), this._modules.register(e10, n10), m1(this, this.state, e10, this._modules.get(e10), r10.preserveState), Xl(this, this.state);
  };
  Vt$1.prototype.unregisterModule = function(e10) {
    var n10 = this;
    typeof e10 == "string" && (e10 = [e10]), this._modules.unregister(e10), this._withCommit(function() {
      var r10 = Ql(n10.state, e10.slice(0, -1));
      delete r10[e10[e10.length - 1]];
    }), M5(this);
  };
  Vt$1.prototype.hasModule = function(e10) {
    return typeof e10 == "string" && (e10 = [e10]), this._modules.isRegistered(e10);
  };
  Vt$1.prototype.hotUpdate = function(e10) {
    this._modules.update(e10), M5(this, true);
  };
  Vt$1.prototype._withCommit = function(e10) {
    var n10 = this._committing;
    this._committing = true, e10(), this._committing = n10;
  };
  Object.defineProperties(Vt$1.prototype, Jl);
  var yr = ta(function(t10, e10) {
    var n10 = {};
    return ea(e10).forEach(function(r10) {
      var s10 = r10.key, i10 = r10.val;
      n10[s10] = function() {
        var l10 = this.$store.state, a10 = this.$store.getters;
        if (t10) {
          var c10 = na(this.$store, "mapState", t10);
          if (!c10)
            return;
          l10 = c10.context.state, a10 = c10.context.getters;
        }
        return typeof i10 == "function" ? i10.call(this, l10, a10) : l10[i10];
      }, n10[s10].vuex = true;
    }), n10;
  }), V5 = ta(function(t10, e10) {
    var n10 = {};
    return ea(e10).forEach(function(r10) {
      var s10 = r10.key, i10 = r10.val;
      n10[s10] = function() {
        for (var l10 = [], a10 = arguments.length; a10--; )
          l10[a10] = arguments[a10];
        var c10 = this.$store.commit;
        if (t10) {
          var u10 = na(this.$store, "mapMutations", t10);
          if (!u10)
            return;
          c10 = u10.context.commit;
        }
        return typeof i10 == "function" ? i10.apply(this, [c10].concat(l10)) : c10.apply(this.$store, [i10].concat(l10));
      };
    }), n10;
  }), pn$1 = ta(function(t10, e10) {
    var n10 = {};
    return ea(e10).forEach(function(r10) {
      var s10 = r10.key, i10 = r10.val;
      i10 = t10 + i10, n10[s10] = function() {
        if (!(t10 && !na(this.$store, "mapGetters", t10)))
          return this.$store.getters[i10];
      }, n10[s10].vuex = true;
    }), n10;
  });
  function ea(t10) {
    return G9(t10) ? Array.isArray(t10) ? t10.map(function(e10) {
      return { key: e10, val: e10 };
    }) : Object.keys(t10).map(function(e10) {
      return { key: e10, val: t10[e10] };
    }) : [];
  }
  function G9(t10) {
    return Array.isArray(t10) || O5(t10);
  }
  function ta(t10) {
    return function(e10, n10) {
      return typeof e10 != "string" ? (n10 = e10, e10 = "") : e10.charAt(e10.length - 1) !== "/" && (e10 += "/"), t10(e10, n10);
    };
  }
  function na(t10, e10, n10) {
    var r10 = t10._modulesNamespaceMap[n10];
    return r10;
  }
  var j9 = typeof Y0 == "object" && Y0 && Y0.Object === Object && Y0, z5 = j9, Z9 = z5, W9 = typeof self == "object" && self && self.Object === Object && self, q9 = Z9 || W9 || Function("return this")(), Wr = q9, K9 = Wr, Y9 = function() {
    return K9.Date.now();
  }, X9 = Y9;
  String.prototype.seed = String.prototype.seed || Math.round(Math.random() * Math.pow(2, 32));
  String.prototype.hashCode = function() {
    const t10 = this.toString();
    let e10, n10;
    const r10 = t10.length & 3, s10 = t10.length - r10;
    let i10 = String.prototype.seed;
    const o10 = 3432918353, l10 = 461845907;
    let a10 = 0;
    for (; a10 < s10; )
      n10 = t10.charCodeAt(a10) & 255 | (t10.charCodeAt(++a10) & 255) << 8 | (t10.charCodeAt(++a10) & 255) << 16 | (t10.charCodeAt(++a10) & 255) << 24, ++a10, n10 = (n10 & 65535) * o10 + (((n10 >>> 16) * o10 & 65535) << 16) & 4294967295, n10 = n10 << 15 | n10 >>> 17, n10 = (n10 & 65535) * l10 + (((n10 >>> 16) * l10 & 65535) << 16) & 4294967295, i10 ^= n10, i10 = i10 << 13 | i10 >>> 19, e10 = (i10 & 65535) * 5 + (((i10 >>> 16) * 5 & 65535) << 16) & 4294967295, i10 = (e10 & 65535) + 27492 + (((e10 >>> 16) + 58964 & 65535) << 16);
    switch (n10 = 0, r10) {
      case 3:
        n10 ^= (t10.charCodeAt(a10 + 2) & 255) << 16;
      case 2:
        n10 ^= (t10.charCodeAt(a10 + 1) & 255) << 8;
      case 1:
        n10 ^= t10.charCodeAt(a10) & 255, n10 = (n10 & 65535) * o10 + (((n10 >>> 16) * o10 & 65535) << 16) & 4294967295, n10 = n10 << 15 | n10 >>> 17, n10 = (n10 & 65535) * l10 + (((n10 >>> 16) * l10 & 65535) << 16) & 4294967295, i10 ^= n10;
    }
    return i10 ^= t10.length, i10 ^= i10 >>> 16, i10 = (i10 & 65535) * 2246822507 + (((i10 >>> 16) * 2246822507 & 65535) << 16) & 4294967295, i10 ^= i10 >>> 13, i10 = (i10 & 65535) * 3266489909 + (((i10 >>> 16) * 3266489909 & 65535) << 16) & 4294967295, i10 ^= i10 >>> 16, i10 >>> 0;
  };
  /*! https://mths.be/codepointat v0.2.0 by @mathias */
  String.prototype.codePointAt || function() {
    var t10 = function() {
      let n10;
      try {
        const r10 = {}, s10 = Object.defineProperty;
        n10 = s10(r10, r10, r10) && s10;
      } catch {
      }
      return n10;
    }();
    const e10 = function(n10) {
      if (this == null)
        throw TypeError();
      const r10 = String(this), s10 = r10.length;
      let i10 = n10 ? Number(n10) : 0;
      if (i10 !== i10 && (i10 = 0), i10 < 0 || i10 >= s10)
        return;
      const o10 = r10.charCodeAt(i10);
      let l10;
      return o10 >= 55296 && o10 <= 56319 && s10 > i10 + 1 && (l10 = r10.charCodeAt(i10 + 1), l10 >= 56320 && l10 <= 57343) ? (o10 - 55296) * 1024 + l10 - 56320 + 65536 : o10;
    };
    t10 ? t10(String.prototype, "codePointAt", {
      value: e10,
      configurable: true,
      writable: true
    }) : String.prototype.codePointAt = e10;
  }();
  /*! https://mths.be/fromcodepoint v0.2.1 by @mathias */
  String.fromCodePoint || function() {
    const t10 = function() {
      let s10;
      try {
        const i10 = {}, o10 = Object.defineProperty;
        s10 = o10(i10, i10, i10) && o10;
      } catch {
      }
      return s10;
    }(), e10 = String.fromCharCode, n10 = Math.floor, r10 = function(s10) {
      const o10 = [];
      let l10, a10, c10 = -1;
      const u10 = arguments.length;
      if (!u10)
        return "";
      let h10 = "";
      for (; ++c10 < u10; ) {
        let d10 = Number(arguments[c10]);
        if (!isFinite(d10) || d10 < 0 || d10 > 1114111 || n10(d10) !== d10)
          throw RangeError("Invalid code point: " + d10);
        d10 <= 65535 ? o10.push(d10) : (d10 -= 65536, l10 = (d10 >> 10) + 55296, a10 = d10 % 1024 + 56320, o10.push(l10, a10)), (c10 + 1 === u10 || o10.length > 16384) && (h10 += e10.apply(null, o10), o10.length = 0);
      }
      return h10;
    };
    t10 ? t10(String, "fromCodePoint", {
      value: r10,
      configurable: true,
      writable: true
    }) : String.fromCodePoint = r10;
  }();
  class B {
    constructor() {
      this.source = null, this.type = null, this.channel = null, this.start = null, this.stop = null, this.tokenIndex = null, this.line = null, this.column = null, this._text = null;
    }
    getTokenSource() {
      return this.source[0];
    }
    getInputStream() {
      return this.source[1];
    }
    get text() {
      return this._text;
    }
    set text(e10) {
      this._text = e10;
    }
  }
  B.INVALID_TYPE = 0;
  B.EPSILON = -2;
  B.MIN_USER_TOKEN_TYPE = 1;
  B.EOF = -1;
  B.DEFAULT_CHANNEL = 0;
  B.HIDDEN_CHANNEL = 1;
  function ys(t10, e10) {
    if (!Array.isArray(t10) || !Array.isArray(e10))
      return false;
    if (t10 === e10)
      return true;
    if (t10.length !== e10.length)
      return false;
    for (let n10 = 0; n10 < t10.length; n10++)
      if (t10[n10] !== e10[n10] && (!t10[n10].equals || !t10[n10].equals(e10[n10])))
        return false;
    return true;
  }
  let en$1 = class en2 {
    constructor() {
      this.count = 0, this.hash = 0;
    }
    update() {
      for (let e10 = 0; e10 < arguments.length; e10++) {
        const n10 = arguments[e10];
        if (n10 != null)
          if (Array.isArray(n10))
            this.update.apply(this, n10);
          else {
            let r10 = 0;
            switch (typeof n10) {
              case "undefined":
              case "function":
                continue;
              case "number":
              case "boolean":
                r10 = n10;
                break;
              case "string":
                r10 = n10.hashCode();
                break;
              default:
                n10.updateHashCode ? n10.updateHashCode(this) : console.log("No updateHashCode for " + n10.toString());
                continue;
            }
            r10 = r10 * 3432918353, r10 = r10 << 15 | r10 >>> 32 - 15, r10 = r10 * 461845907, this.count = this.count + 1;
            let s10 = this.hash ^ r10;
            s10 = s10 << 13 | s10 >>> 32 - 13, s10 = s10 * 5 + 3864292196, this.hash = s10;
          }
      }
    }
    finish() {
      let e10 = this.hash ^ this.count * 4;
      return e10 = e10 ^ e10 >>> 16, e10 = e10 * 2246822507, e10 = e10 ^ e10 >>> 13, e10 = e10 * 3266489909, e10 = e10 ^ e10 >>> 16, e10;
    }
    static hashStuff() {
      const e10 = new en2();
      return e10.update.apply(e10, arguments), e10.finish();
    }
  };
  function G5(t10) {
    return t10 ? t10.hashCode() : -1;
  }
  function j5(t10, e10) {
    return t10 ? t10.equals(e10) : t10 === e10;
  }
  function Q9(t10) {
    return t10 === null ? "null" : t10;
  }
  function or(t10) {
    return Array.isArray(t10) ? "[" + t10.map(Q9).join(", ") + "]" : "null";
  }
  const ui = "h-";
  let Xt$1 = class Xt {
    constructor(e10, n10) {
      this.data = {}, this.hashFunction = e10 || G5, this.equalsFunction = n10 || j5;
    }
    add(e10) {
      const n10 = ui + this.hashFunction(e10);
      if (n10 in this.data) {
        const r10 = this.data[n10];
        for (let s10 = 0; s10 < r10.length; s10++)
          if (this.equalsFunction(e10, r10[s10]))
            return r10[s10];
        return r10.push(e10), e10;
      } else
        return this.data[n10] = [e10], e10;
    }
    has(e10) {
      return this.get(e10) != null;
    }
    get(e10) {
      const n10 = ui + this.hashFunction(e10);
      if (n10 in this.data) {
        const r10 = this.data[n10];
        for (let s10 = 0; s10 < r10.length; s10++)
          if (this.equalsFunction(e10, r10[s10]))
            return r10[s10];
      }
      return null;
    }
    values() {
      return Object.keys(this.data).filter((e10) => e10.startsWith(ui)).flatMap((e10) => this.data[e10], this);
    }
    toString() {
      return or(this.values());
    }
    get length() {
      return Object.keys(this.data).filter((e10) => e10.startsWith(ui)).map((e10) => this.data[e10].length, this).reduce((e10, n10) => e10 + n10, 0);
    }
  };
  let $e$1 = class $e2 {
    hashCode() {
      const e10 = new en$1();
      return this.updateHashCode(e10), e10.finish();
    }
    evaluate(e10, n10) {
    }
    evalPrecedence(e10, n10) {
      return this;
    }
    static andContext(e10, n10) {
      if (e10 === null || e10 === $e2.NONE)
        return n10;
      if (n10 === null || n10 === $e2.NONE)
        return e10;
      const r10 = new t0(e10, n10);
      return r10.opnds.length === 1 ? r10.opnds[0] : r10;
    }
    static orContext(e10, n10) {
      if (e10 === null)
        return n10;
      if (n10 === null)
        return e10;
      if (e10 === $e2.NONE || n10 === $e2.NONE)
        return $e2.NONE;
      const r10 = new n0(e10, n10);
      return r10.opnds.length === 1 ? r10.opnds[0] : r10;
    }
  };
  class t0 extends $e$1 {
    constructor(e10, n10) {
      super();
      const r10 = new Xt$1();
      e10 instanceof t0 ? e10.opnds.map(function(i10) {
        r10.add(i10);
      }) : r10.add(e10), n10 instanceof t0 ? n10.opnds.map(function(i10) {
        r10.add(i10);
      }) : r10.add(n10);
      const s10 = Z5(r10);
      if (s10.length > 0) {
        let i10 = null;
        s10.map(function(o10) {
          (i10 === null || o10.precedence < i10.precedence) && (i10 = o10);
        }), r10.add(i10);
      }
      this.opnds = Array.from(r10.values());
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof t0 ? ys(this.opnds, e10.opnds) : false;
    }
    updateHashCode(e10) {
      e10.update(this.opnds, "AND");
    }
    evaluate(e10, n10) {
      for (let r10 = 0; r10 < this.opnds.length; r10++)
        if (!this.opnds[r10].evaluate(e10, n10))
          return false;
      return true;
    }
    evalPrecedence(e10, n10) {
      let r10 = false;
      const s10 = [];
      for (let o10 = 0; o10 < this.opnds.length; o10++) {
        const l10 = this.opnds[o10], a10 = l10.evalPrecedence(e10, n10);
        if (r10 |= a10 !== l10, a10 === null)
          return null;
        a10 !== $e$1.NONE && s10.push(a10);
      }
      if (!r10)
        return this;
      if (s10.length === 0)
        return $e$1.NONE;
      let i10 = null;
      return s10.map(function(o10) {
        i10 = i10 === null ? o10 : $e$1.andContext(i10, o10);
      }), i10;
    }
    toString() {
      const e10 = this.opnds.map((n10) => n10.toString());
      return (e10.length > 3 ? e10.slice(3) : e10).join("&&");
    }
  }
  class n0 extends $e$1 {
    constructor(e10, n10) {
      super();
      const r10 = new Xt$1();
      e10 instanceof n0 ? e10.opnds.map(function(i10) {
        r10.add(i10);
      }) : r10.add(e10), n10 instanceof n0 ? n10.opnds.map(function(i10) {
        r10.add(i10);
      }) : r10.add(n10);
      const s10 = Z5(r10);
      if (s10.length > 0) {
        const i10 = s10.sort(function(l10, a10) {
          return l10.compareTo(a10);
        }), o10 = i10[i10.length - 1];
        r10.add(o10);
      }
      this.opnds = Array.from(r10.values());
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof n0 ? ys(this.opnds, e10.opnds) : false;
    }
    updateHashCode(e10) {
      e10.update(this.opnds, "OR");
    }
    evaluate(e10, n10) {
      for (let r10 = 0; r10 < this.opnds.length; r10++)
        if (this.opnds[r10].evaluate(e10, n10))
          return true;
      return false;
    }
    evalPrecedence(e10, n10) {
      let r10 = false;
      for (let o10 = 0; o10 < this.opnds.length; o10++) {
        const l10 = this.opnds[o10], a10 = l10.evalPrecedence(e10, n10);
        if (r10 |= a10 !== l10, a10 === $e$1.NONE)
          return $e$1.NONE;
      }
      return r10 ? null : this;
    }
    toString() {
      const e10 = this.opnds.map((n10) => n10.toString());
      return (e10.length > 3 ? e10.slice(3) : e10).join("||");
    }
  }
  function Z5(t10) {
    const e10 = [];
    return t10.values().map(function(n10) {
      n10 instanceof $e$1.PrecedencePredicate && e10.push(n10);
    }), e10;
  }
  function C2(t10, e10) {
    if (t10 === null) {
      const n10 = { state: null, alt: null, context: null, semanticContext: null };
      return e10 && (n10.reachesIntoOuterContext = 0), n10;
    } else {
      const n10 = {};
      return n10.state = t10.state || null, n10.alt = t10.alt === void 0 ? null : t10.alt, n10.context = t10.context || null, n10.semanticContext = t10.semanticContext || null, e10 && (n10.reachesIntoOuterContext = t10.reachesIntoOuterContext || 0, n10.precedenceFilterSuppressed = t10.precedenceFilterSuppressed || false), n10;
    }
  }
  class ot {
    constructor(e10, n10) {
      this.checkContext(e10, n10), e10 = C2(e10), n10 = C2(n10, true), this.state = e10.state !== null ? e10.state : n10.state, this.alt = e10.alt !== null ? e10.alt : n10.alt, this.context = e10.context !== null ? e10.context : n10.context, this.semanticContext = e10.semanticContext !== null ? e10.semanticContext : n10.semanticContext !== null ? n10.semanticContext : $e$1.NONE, this.reachesIntoOuterContext = n10.reachesIntoOuterContext, this.precedenceFilterSuppressed = n10.precedenceFilterSuppressed;
    }
    checkContext(e10, n10) {
      (e10.context === null || e10.context === void 0) && (n10 === null || n10.context === null || n10.context === void 0) && (this.context = null);
    }
    hashCode() {
      const e10 = new en$1();
      return this.updateHashCode(e10), e10.finish();
    }
    updateHashCode(e10) {
      e10.update(this.state.stateNumber, this.alt, this.context, this.semanticContext);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof ot ? this.state.stateNumber === e10.state.stateNumber && this.alt === e10.alt && (this.context === null ? e10.context === null : this.context.equals(e10.context)) && this.semanticContext.equals(e10.semanticContext) && this.precedenceFilterSuppressed === e10.precedenceFilterSuppressed : false;
    }
    hashCodeForConfigSet() {
      const e10 = new en$1();
      return e10.update(this.state.stateNumber, this.alt, this.semanticContext), e10.finish();
    }
    equalsForConfigSet(e10) {
      return this === e10 ? true : e10 instanceof ot ? this.state.stateNumber === e10.state.stateNumber && this.alt === e10.alt && this.semanticContext.equals(e10.semanticContext) : false;
    }
    toString() {
      return "(" + this.state + "," + this.alt + (this.context !== null ? ",[" + this.context.toString() + "]" : "") + (this.semanticContext !== $e$1.NONE ? "," + this.semanticContext.toString() : "") + (this.reachesIntoOuterContext > 0 ? ",up=" + this.reachesIntoOuterContext : "") + ")";
    }
  }
  let Be$1 = class Be2 {
    constructor(e10, n10) {
      this.start = e10, this.stop = n10;
    }
    clone() {
      return new Be2(this.start, this.stop);
    }
    contains(e10) {
      return e10 >= this.start && e10 < this.stop;
    }
    toString() {
      return this.start === this.stop - 1 ? this.start.toString() : this.start.toString() + ".." + (this.stop - 1).toString();
    }
    get length() {
      return this.stop - this.start;
    }
  };
  Be$1.INVALID_INTERVAL = new Be$1(-1, -2);
  let cn$1 = class cn2 {
    constructor() {
      this.intervals = null, this.readOnly = false;
    }
    first(e10) {
      return this.intervals === null || this.intervals.length === 0 ? B.INVALID_TYPE : this.intervals[0].start;
    }
    addOne(e10) {
      this.addInterval(new Be$1(e10, e10 + 1));
    }
    addRange(e10, n10) {
      this.addInterval(new Be$1(e10, n10 + 1));
    }
    addInterval(e10) {
      if (this.intervals === null)
        this.intervals = [], this.intervals.push(e10.clone());
      else {
        for (let n10 = 0; n10 < this.intervals.length; n10++) {
          const r10 = this.intervals[n10];
          if (e10.stop < r10.start) {
            this.intervals.splice(n10, 0, e10);
            return;
          } else if (e10.stop === r10.start) {
            this.intervals[n10] = new Be$1(e10.start, r10.stop);
            return;
          } else if (e10.start <= r10.stop) {
            this.intervals[n10] = new Be$1(Math.min(r10.start, e10.start), Math.max(r10.stop, e10.stop)), this.reduce(n10);
            return;
          }
        }
        this.intervals.push(e10.clone());
      }
    }
    addSet(e10) {
      return e10.intervals !== null && e10.intervals.forEach((n10) => this.addInterval(n10), this), this;
    }
    reduce(e10) {
      if (e10 < this.intervals.length - 1) {
        const n10 = this.intervals[e10], r10 = this.intervals[e10 + 1];
        n10.stop >= r10.stop ? (this.intervals.splice(e10 + 1, 1), this.reduce(e10)) : n10.stop >= r10.start && (this.intervals[e10] = new Be$1(n10.start, r10.stop), this.intervals.splice(e10 + 1, 1));
      }
    }
    complement(e10, n10) {
      const r10 = new cn2();
      return r10.addInterval(new Be$1(e10, n10 + 1)), this.intervals !== null && this.intervals.forEach((s10) => r10.removeRange(s10)), r10;
    }
    contains(e10) {
      if (this.intervals === null)
        return false;
      for (let n10 = 0; n10 < this.intervals.length; n10++)
        if (this.intervals[n10].contains(e10))
          return true;
      return false;
    }
    removeRange(e10) {
      if (e10.start === e10.stop - 1)
        this.removeOne(e10.start);
      else if (this.intervals !== null) {
        let n10 = 0;
        for (let r10 = 0; r10 < this.intervals.length; r10++) {
          const s10 = this.intervals[n10];
          if (e10.stop <= s10.start)
            return;
          if (e10.start > s10.start && e10.stop < s10.stop) {
            this.intervals[n10] = new Be$1(s10.start, e10.start);
            const i10 = new Be$1(e10.stop, s10.stop);
            this.intervals.splice(n10, 0, i10);
            return;
          } else
            e10.start <= s10.start && e10.stop >= s10.stop ? (this.intervals.splice(n10, 1), n10 = n10 - 1) : e10.start < s10.stop ? this.intervals[n10] = new Be$1(s10.start, e10.start) : e10.stop < s10.stop && (this.intervals[n10] = new Be$1(e10.stop, s10.stop));
          n10 += 1;
        }
      }
    }
    removeOne(e10) {
      if (this.intervals !== null)
        for (let n10 = 0; n10 < this.intervals.length; n10++) {
          const r10 = this.intervals[n10];
          if (e10 < r10.start)
            return;
          if (e10 === r10.start && e10 === r10.stop - 1) {
            this.intervals.splice(n10, 1);
            return;
          } else if (e10 === r10.start) {
            this.intervals[n10] = new Be$1(r10.start + 1, r10.stop);
            return;
          } else if (e10 === r10.stop - 1) {
            this.intervals[n10] = new Be$1(r10.start, r10.stop - 1);
            return;
          } else if (e10 < r10.stop - 1) {
            const s10 = new Be$1(r10.start, e10);
            r10.start = e10 + 1, this.intervals.splice(n10, 0, s10);
            return;
          }
        }
    }
    toString(e10, n10, r10) {
      return e10 = e10 || null, n10 = n10 || null, r10 = r10 || false, this.intervals === null ? "{}" : e10 !== null || n10 !== null ? this.toTokenString(e10, n10) : r10 ? this.toCharString() : this.toIndexString();
    }
    toCharString() {
      const e10 = [];
      for (let n10 = 0; n10 < this.intervals.length; n10++) {
        const r10 = this.intervals[n10];
        r10.stop === r10.start + 1 ? r10.start === B.EOF ? e10.push("<EOF>") : e10.push("'" + String.fromCharCode(r10.start) + "'") : e10.push("'" + String.fromCharCode(r10.start) + "'..'" + String.fromCharCode(r10.stop - 1) + "'");
      }
      return e10.length > 1 ? "{" + e10.join(", ") + "}" : e10[0];
    }
    toIndexString() {
      const e10 = [];
      for (let n10 = 0; n10 < this.intervals.length; n10++) {
        const r10 = this.intervals[n10];
        r10.stop === r10.start + 1 ? r10.start === B.EOF ? e10.push("<EOF>") : e10.push(r10.start.toString()) : e10.push(r10.start.toString() + ".." + (r10.stop - 1).toString());
      }
      return e10.length > 1 ? "{" + e10.join(", ") + "}" : e10[0];
    }
    toTokenString(e10, n10) {
      const r10 = [];
      for (let s10 = 0; s10 < this.intervals.length; s10++) {
        const i10 = this.intervals[s10];
        for (let o10 = i10.start; o10 < i10.stop; o10++)
          r10.push(this.elementName(e10, n10, o10));
      }
      return r10.length > 1 ? "{" + r10.join(", ") + "}" : r10[0];
    }
    elementName(e10, n10, r10) {
      return r10 === B.EOF ? "<EOF>" : r10 === B.EPSILON ? "<EPSILON>" : e10[r10] || n10[r10];
    }
    get length() {
      return this.intervals.map((e10) => e10.length).reduce((e10, n10) => e10 + n10);
    }
  };
  let oe$1 = class oe2 {
    constructor() {
      this.atn = null, this.stateNumber = oe2.INVALID_STATE_NUMBER, this.stateType = null, this.ruleIndex = 0, this.epsilonOnlyTransitions = false, this.transitions = [], this.nextTokenWithinRule = null;
    }
    toString() {
      return this.stateNumber;
    }
    equals(e10) {
      return e10 instanceof oe2 ? this.stateNumber === e10.stateNumber : false;
    }
    isNonGreedyExitState() {
      return false;
    }
    addTransition(e10, n10) {
      n10 === void 0 && (n10 = -1), this.transitions.length === 0 ? this.epsilonOnlyTransitions = e10.isEpsilon : this.epsilonOnlyTransitions !== e10.isEpsilon && (this.epsilonOnlyTransitions = false), n10 === -1 ? this.transitions.push(e10) : this.transitions.splice(n10, 1, e10);
    }
  };
  oe$1.INVALID_TYPE = 0;
  oe$1.BASIC = 1;
  oe$1.RULE_START = 2;
  oe$1.BLOCK_START = 3;
  oe$1.PLUS_BLOCK_START = 4;
  oe$1.STAR_BLOCK_START = 5;
  oe$1.TOKEN_START = 6;
  oe$1.RULE_STOP = 7;
  oe$1.BLOCK_END = 8;
  oe$1.STAR_LOOP_BACK = 9;
  oe$1.STAR_LOOP_ENTRY = 10;
  oe$1.PLUS_LOOP_BACK = 11;
  oe$1.LOOP_END = 12;
  oe$1.serializationNames = [
    "INVALID",
    "BASIC",
    "RULE_START",
    "BLOCK_START",
    "PLUS_BLOCK_START",
    "STAR_BLOCK_START",
    "TOKEN_START",
    "RULE_STOP",
    "BLOCK_END",
    "STAR_LOOP_BACK",
    "STAR_LOOP_ENTRY",
    "PLUS_LOOP_BACK",
    "LOOP_END"
  ];
  oe$1.INVALID_STATE_NUMBER = -1;
  let At$1 = class At extends oe$1 {
    constructor() {
      return super(), this.stateType = oe$1.RULE_STOP, this;
    }
  };
  let ee$1 = class ee {
    constructor(e10) {
      if (e10 == null)
        throw "target cannot be null.";
      this.target = e10, this.isEpsilon = false, this.label = null;
    }
  };
  ee$1.EPSILON = 1;
  ee$1.RANGE = 2;
  ee$1.RULE = 3;
  ee$1.PREDICATE = 4;
  ee$1.ATOM = 5;
  ee$1.ACTION = 6;
  ee$1.SET = 7;
  ee$1.NOT_SET = 8;
  ee$1.WILDCARD = 9;
  ee$1.PRECEDENCE = 10;
  ee$1.serializationNames = [
    "INVALID",
    "EPSILON",
    "RANGE",
    "RULE",
    "PREDICATE",
    "ATOM",
    "ACTION",
    "SET",
    "NOT_SET",
    "WILDCARD",
    "PRECEDENCE"
  ];
  ee$1.serializationTypes = {
    EpsilonTransition: ee$1.EPSILON,
    RangeTransition: ee$1.RANGE,
    RuleTransition: ee$1.RULE,
    PredicateTransition: ee$1.PREDICATE,
    AtomTransition: ee$1.ATOM,
    ActionTransition: ee$1.ACTION,
    SetTransition: ee$1.SET,
    NotSetTransition: ee$1.NOT_SET,
    WildcardTransition: ee$1.WILDCARD,
    PrecedencePredicateTransition: ee$1.PRECEDENCE
  };
  class Mi extends ee$1 {
    constructor(e10, n10, r10, s10) {
      super(e10), this.ruleIndex = n10, this.precedence = r10, this.followState = s10, this.serializationType = ee$1.RULE, this.isEpsilon = true;
    }
    matches(e10, n10, r10) {
      return false;
    }
  }
  class ra extends ee$1 {
    constructor(e10, n10) {
      super(e10), this.serializationType = ee$1.SET, n10 != null ? this.label = n10 : (this.label = new cn$1(), this.label.addOne(B.INVALID_TYPE));
    }
    matches(e10, n10, r10) {
      return this.label.contains(e10);
    }
    toString() {
      return this.label.toString();
    }
  }
  class sa extends ra {
    constructor(e10, n10) {
      super(e10, n10), this.serializationType = ee$1.NOT_SET;
    }
    matches(e10, n10, r10) {
      return e10 >= n10 && e10 <= r10 && !super.matches(e10, n10, r10);
    }
    toString() {
      return "~" + super.toString();
    }
  }
  class W5 extends ee$1 {
    constructor(e10) {
      super(e10), this.serializationType = ee$1.WILDCARD;
    }
    matches(e10, n10, r10) {
      return e10 >= n10 && e10 <= r10;
    }
    toString() {
      return ".";
    }
  }
  class ia extends ee$1 {
    constructor(e10) {
      super(e10);
    }
  }
  class J9 {
  }
  class e7 extends J9 {
  }
  class q5 extends e7 {
  }
  class Ni extends q5 {
    getRuleContext() {
      throw new Error("missing interface implementation");
    }
  }
  class Wn extends q5 {
  }
  class x1 extends Wn {
  }
  function t7(t10, e10) {
    return t10 = t10.replace(/\t/g, "\\t").replace(/\n/g, "\\n").replace(/\r/g, "\\r"), e10 && (t10 = t10.replace(/ /g, "·")), t10;
  }
  const _n = {
    toStringTree: function(t10, e10, n10) {
      e10 = e10 || null, n10 = n10 || null, n10 !== null && (e10 = n10.ruleNames);
      let r10 = _n.getNodeText(t10, e10);
      r10 = t7(r10, false);
      const s10 = t10.getChildCount();
      if (s10 === 0)
        return r10;
      let i10 = "(" + r10 + " ";
      s10 > 0 && (r10 = _n.toStringTree(t10.getChild(0), e10), i10 = i10.concat(r10));
      for (let o10 = 1; o10 < s10; o10++)
        r10 = _n.toStringTree(t10.getChild(o10), e10), i10 = i10.concat(" " + r10);
      return i10 = i10.concat(")"), i10;
    },
    getNodeText: function(t10, e10, n10) {
      if (e10 = e10 || null, n10 = n10 || null, n10 !== null && (e10 = n10.ruleNames), e10 !== null)
        if (t10 instanceof Ni) {
          const i10 = t10.getRuleContext().getAltNumber();
          return i10 != 0 ? e10[t10.ruleIndex] + ":" + i10 : e10[t10.ruleIndex];
        } else {
          if (t10 instanceof x1)
            return t10.toString();
          if (t10 instanceof Wn && t10.symbol !== null)
            return t10.symbol.text;
        }
      const r10 = t10.getPayload();
      return r10 instanceof B ? r10.text : t10.getPayload().toString();
    },
    getChildren: function(t10) {
      const e10 = [];
      for (let n10 = 0; n10 < t10.getChildCount(); n10++)
        e10.push(t10.getChild(n10));
      return e10;
    },
    getAncestors: function(t10) {
      let e10 = [];
      for (t10 = t10.getParent(); t10 !== null; )
        e10 = [t10].concat(e10), t10 = t10.getParent();
      return e10;
    },
    findAllTokenNodes: function(t10, e10) {
      return _n.findAllNodes(t10, e10, true);
    },
    findAllRuleNodes: function(t10, e10) {
      return _n.findAllNodes(t10, e10, false);
    },
    findAllNodes: function(t10, e10, n10) {
      const r10 = [];
      return _n._findAllNodes(t10, e10, n10, r10), r10;
    },
    _findAllNodes: function(t10, e10, n10, r10) {
      n10 && t10 instanceof Wn ? t10.symbol.type === e10 && r10.push(t10) : !n10 && t10 instanceof Ni && t10.ruleIndex === e10 && r10.push(t10);
      for (let s10 = 0; s10 < t10.getChildCount(); s10++)
        _n._findAllNodes(t10.getChild(s10), e10, n10, r10);
    },
    descendants: function(t10) {
      let e10 = [t10];
      for (let n10 = 0; n10 < t10.getChildCount(); n10++)
        e10 = e10.concat(_n.descendants(t10.getChild(n10)));
      return e10;
    }
  };
  class Cs extends Ni {
    constructor(e10, n10) {
      super(), this.parentCtx = e10 || null, this.invokingState = n10 || -1;
    }
    depth() {
      let e10 = 0, n10 = this;
      for (; n10 !== null; )
        n10 = n10.parentCtx, e10 += 1;
      return e10;
    }
    isEmpty() {
      return this.invokingState === -1;
    }
    getSourceInterval() {
      return Be$1.INVALID_INTERVAL;
    }
    getRuleContext() {
      return this;
    }
    getPayload() {
      return this;
    }
    getText() {
      return this.getChildCount() === 0 ? "" : this.children.map(function(e10) {
        return e10.getText();
      }).join("");
    }
    getAltNumber() {
      return 0;
    }
    setAltNumber(e10) {
    }
    getChild(e10) {
      return null;
    }
    getChildCount() {
      return 0;
    }
    accept(e10) {
      return e10.visitChildren(this);
    }
    toStringTree(e10, n10) {
      return _n.toStringTree(this, e10, n10);
    }
    toString(e10, n10) {
      e10 = e10 || null, n10 = n10 || null;
      let r10 = this, s10 = "[";
      for (; r10 !== null && r10 !== n10; ) {
        if (e10 === null)
          r10.isEmpty() || (s10 += r10.invokingState);
        else {
          const i10 = r10.ruleIndex, o10 = i10 >= 0 && i10 < e10.length ? e10[i10] : "" + i10;
          s10 += o10;
        }
        r10.parentCtx !== null && (e10 !== null || !r10.parentCtx.isEmpty()) && (s10 += " "), r10 = r10.parentCtx;
      }
      return s10 += "]", s10;
    }
  }
  class Te {
    constructor(e10) {
      this.cachedHashCode = e10;
    }
    isEmpty() {
      return this === Te.EMPTY;
    }
    hasEmptyPath() {
      return this.getReturnState(this.length - 1) === Te.EMPTY_RETURN_STATE;
    }
    hashCode() {
      return this.cachedHashCode;
    }
    updateHashCode(e10) {
      e10.update(this.cachedHashCode);
    }
  }
  Te.EMPTY = null;
  Te.EMPTY_RETURN_STATE = 2147483647;
  Te.globalNodeCount = 1;
  Te.id = Te.globalNodeCount;
  class Mn extends Te {
    constructor(e10, n10) {
      const r10 = new en$1();
      r10.update(e10, n10);
      const s10 = r10.finish();
      return super(s10), this.parents = e10, this.returnStates = n10, this;
    }
    isEmpty() {
      return this.returnStates[0] === Te.EMPTY_RETURN_STATE;
    }
    getParent(e10) {
      return this.parents[e10];
    }
    getReturnState(e10) {
      return this.returnStates[e10];
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof Mn ? this.hashCode() !== e10.hashCode() ? false : ys(this.returnStates, e10.returnStates) && ys(this.parents, e10.parents) : false;
    }
    toString() {
      if (this.isEmpty())
        return "[]";
      {
        let e10 = "[";
        for (let n10 = 0; n10 < this.returnStates.length; n10++) {
          if (n10 > 0 && (e10 = e10 + ", "), this.returnStates[n10] === Te.EMPTY_RETURN_STATE) {
            e10 = e10 + "$";
            continue;
          }
          e10 = e10 + this.returnStates[n10], this.parents[n10] !== null ? e10 = e10 + " " + this.parents[n10] : e10 = e10 + "null";
        }
        return e10 + "]";
      }
    }
    get length() {
      return this.returnStates.length;
    }
  }
  let kt$1 = class kt2 extends Te {
    constructor(e10, n10) {
      let r10 = 0;
      const s10 = new en$1();
      e10 !== null ? s10.update(e10, n10) : s10.update(1), r10 = s10.finish(), super(r10), this.parentCtx = e10, this.returnState = n10;
    }
    getParent(e10) {
      return this.parentCtx;
    }
    getReturnState(e10) {
      return this.returnState;
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof kt2 ? this.hashCode() !== e10.hashCode() || this.returnState !== e10.returnState ? false : this.parentCtx == null ? e10.parentCtx == null : this.parentCtx.equals(e10.parentCtx) : false;
    }
    toString() {
      const e10 = this.parentCtx === null ? "" : this.parentCtx.toString();
      return e10.length === 0 ? this.returnState === Te.EMPTY_RETURN_STATE ? "$" : "" + this.returnState : "" + this.returnState + " " + e10;
    }
    get length() {
      return 1;
    }
    static create(e10, n10) {
      return n10 === Te.EMPTY_RETURN_STATE && e10 === null ? Te.EMPTY : new kt2(e10, n10);
    }
  };
  class zo extends kt$1 {
    constructor() {
      super(null, Te.EMPTY_RETURN_STATE);
    }
    isEmpty() {
      return true;
    }
    getParent(e10) {
      return null;
    }
    getReturnState(e10) {
      return this.returnState;
    }
    equals(e10) {
      return this === e10;
    }
    toString() {
      return "$";
    }
  }
  Te.EMPTY = new zo();
  const Vs = "h-";
  class F0 {
    constructor(e10, n10) {
      this.data = {}, this.hashFunction = e10 || G5, this.equalsFunction = n10 || j5;
    }
    set(e10, n10) {
      const r10 = Vs + this.hashFunction(e10);
      if (r10 in this.data) {
        const s10 = this.data[r10];
        for (let i10 = 0; i10 < s10.length; i10++) {
          const o10 = s10[i10];
          if (this.equalsFunction(e10, o10.key)) {
            const l10 = o10.value;
            return o10.value = n10, l10;
          }
        }
        return s10.push({ key: e10, value: n10 }), n10;
      } else
        return this.data[r10] = [{ key: e10, value: n10 }], n10;
    }
    containsKey(e10) {
      const n10 = Vs + this.hashFunction(e10);
      if (n10 in this.data) {
        const r10 = this.data[n10];
        for (let s10 = 0; s10 < r10.length; s10++) {
          const i10 = r10[s10];
          if (this.equalsFunction(e10, i10.key))
            return true;
        }
      }
      return false;
    }
    get(e10) {
      const n10 = Vs + this.hashFunction(e10);
      if (n10 in this.data) {
        const r10 = this.data[n10];
        for (let s10 = 0; s10 < r10.length; s10++) {
          const i10 = r10[s10];
          if (this.equalsFunction(e10, i10.key))
            return i10.value;
        }
      }
      return null;
    }
    entries() {
      return Object.keys(this.data).filter((e10) => e10.startsWith(Vs)).flatMap((e10) => this.data[e10], this);
    }
    getKeys() {
      return this.entries().map((e10) => e10.key);
    }
    getValues() {
      return this.entries().map((e10) => e10.value);
    }
    toString() {
      return "[" + this.entries().map((n10) => "{" + n10.key + ":" + n10.value + "}").join(", ") + "]";
    }
    get length() {
      return Object.keys(this.data).filter((e10) => e10.startsWith(Vs)).map((e10) => this.data[e10].length, this).reduce((e10, n10) => e10 + n10, 0);
    }
  }
  function oa(t10, e10) {
    if (e10 == null && (e10 = Cs.EMPTY), e10.parentCtx === null || e10 === Cs.EMPTY)
      return Te.EMPTY;
    const n10 = oa(t10, e10.parentCtx), s10 = t10.states[e10.invokingState].transitions[0];
    return kt$1.create(n10, s10.followState.stateNumber);
  }
  function K5(t10, e10, n10) {
    if (t10.isEmpty())
      return t10;
    let r10 = n10.get(t10) || null;
    if (r10 !== null)
      return r10;
    if (r10 = e10.get(t10), r10 !== null)
      return n10.set(t10, r10), r10;
    let s10 = false, i10 = [];
    for (let l10 = 0; l10 < i10.length; l10++) {
      const a10 = K5(t10.getParent(l10), e10, n10);
      if (s10 || a10 !== t10.getParent(l10)) {
        if (!s10) {
          i10 = [];
          for (let c10 = 0; c10 < t10.length; c10++)
            i10[c10] = t10.getParent(c10);
          s10 = true;
        }
        i10[l10] = a10;
      }
    }
    if (!s10)
      return e10.add(t10), n10.set(t10, t10), t10;
    let o10 = null;
    return i10.length === 0 ? o10 = Te.EMPTY : i10.length === 1 ? o10 = kt$1.create(i10[0], t10.getReturnState(0)) : o10 = new Mn(i10, t10.returnStates), e10.add(o10), n10.set(o10, o10), n10.set(t10, o10), o10;
  }
  function la(t10, e10, n10, r10) {
    if (t10 === e10)
      return t10;
    if (t10 instanceof kt$1 && e10 instanceof kt$1)
      return s7(t10, e10, n10, r10);
    if (n10) {
      if (t10 instanceof zo)
        return t10;
      if (e10 instanceof zo)
        return e10;
    }
    return t10 instanceof kt$1 && (t10 = new Mn([t10.getParent()], [t10.returnState])), e10 instanceof kt$1 && (e10 = new Mn([e10.getParent()], [e10.returnState])), n7(t10, e10, n10, r10);
  }
  function n7(t10, e10, n10, r10) {
    if (r10 !== null) {
      let u10 = r10.get(t10, e10);
      if (u10 !== null || (u10 = r10.get(e10, t10), u10 !== null))
        return u10;
    }
    let s10 = 0, i10 = 0, o10 = 0, l10 = [], a10 = [];
    for (; s10 < t10.returnStates.length && i10 < e10.returnStates.length; ) {
      const u10 = t10.parents[s10], h10 = e10.parents[i10];
      if (t10.returnStates[s10] === e10.returnStates[i10]) {
        const d10 = t10.returnStates[s10];
        d10 === Te.EMPTY_RETURN_STATE && u10 === null && h10 === null || u10 !== null && h10 !== null && u10 === h10 ? (a10[o10] = u10, l10[o10] = d10) : (a10[o10] = la(u10, h10, n10, r10), l10[o10] = d10), s10 += 1, i10 += 1;
      } else
        t10.returnStates[s10] < e10.returnStates[i10] ? (a10[o10] = u10, l10[o10] = t10.returnStates[s10], s10 += 1) : (a10[o10] = h10, l10[o10] = e10.returnStates[i10], i10 += 1);
      o10 += 1;
    }
    if (s10 < t10.returnStates.length)
      for (let u10 = s10; u10 < t10.returnStates.length; u10++)
        a10[o10] = t10.parents[u10], l10[o10] = t10.returnStates[u10], o10 += 1;
    else
      for (let u10 = i10; u10 < e10.returnStates.length; u10++)
        a10[o10] = e10.parents[u10], l10[o10] = e10.returnStates[u10], o10 += 1;
    if (o10 < a10.length) {
      if (o10 === 1) {
        const u10 = kt$1.create(
          a10[0],
          l10[0]
        );
        return r10 !== null && r10.set(t10, e10, u10), u10;
      }
      a10 = a10.slice(0, o10), l10 = l10.slice(0, o10);
    }
    const c10 = new Mn(a10, l10);
    return c10 === t10 ? (r10 !== null && r10.set(t10, e10, t10), t10) : c10 === e10 ? (r10 !== null && r10.set(t10, e10, e10), e10) : (r7(a10), r10 !== null && r10.set(t10, e10, c10), c10);
  }
  function r7(t10) {
    const e10 = new F0();
    for (let n10 = 0; n10 < t10.length; n10++) {
      const r10 = t10[n10];
      e10.containsKey(r10) || e10.set(r10, r10);
    }
    for (let n10 = 0; n10 < t10.length; n10++)
      t10[n10] = e10.get(t10[n10]);
  }
  function s7(t10, e10, n10, r10) {
    if (r10 !== null) {
      let i10 = r10.get(t10, e10);
      if (i10 !== null || (i10 = r10.get(e10, t10), i10 !== null))
        return i10;
    }
    const s10 = i7(t10, e10, n10);
    if (s10 !== null)
      return r10 !== null && r10.set(t10, e10, s10), s10;
    if (t10.returnState === e10.returnState) {
      const i10 = la(t10.parentCtx, e10.parentCtx, n10, r10);
      if (i10 === t10.parentCtx)
        return t10;
      if (i10 === e10.parentCtx)
        return e10;
      const o10 = kt$1.create(i10, t10.returnState);
      return r10 !== null && r10.set(t10, e10, o10), o10;
    } else {
      let i10 = null;
      if ((t10 === e10 || t10.parentCtx !== null && t10.parentCtx === e10.parentCtx) && (i10 = t10.parentCtx), i10 !== null) {
        const c10 = [t10.returnState, e10.returnState];
        t10.returnState > e10.returnState && (c10[0] = e10.returnState, c10[1] = t10.returnState);
        const u10 = [i10, i10], h10 = new Mn(u10, c10);
        return r10 !== null && r10.set(t10, e10, h10), h10;
      }
      const o10 = [t10.returnState, e10.returnState];
      let l10 = [t10.parentCtx, e10.parentCtx];
      t10.returnState > e10.returnState && (o10[0] = e10.returnState, o10[1] = t10.returnState, l10 = [e10.parentCtx, t10.parentCtx]);
      const a10 = new Mn(l10, o10);
      return r10 !== null && r10.set(t10, e10, a10), a10;
    }
  }
  function i7(t10, e10, n10) {
    if (n10) {
      if (t10 === Te.EMPTY || e10 === Te.EMPTY)
        return Te.EMPTY;
    } else {
      if (t10 === Te.EMPTY && e10 === Te.EMPTY)
        return Te.EMPTY;
      if (t10 === Te.EMPTY) {
        const r10 = [
          e10.returnState,
          Te.EMPTY_RETURN_STATE
        ], s10 = [e10.parentCtx, null];
        return new Mn(s10, r10);
      } else if (e10 === Te.EMPTY) {
        const r10 = [t10.returnState, Te.EMPTY_RETURN_STATE], s10 = [t10.parentCtx, null];
        return new Mn(s10, r10);
      }
    }
    return null;
  }
  class Tn {
    constructor() {
      this.data = [];
    }
    add(e10) {
      this.data[e10] = true;
    }
    or(e10) {
      Object.keys(e10.data).map((n10) => this.add(n10), this);
    }
    remove(e10) {
      delete this.data[e10];
    }
    has(e10) {
      return this.data[e10] === true;
    }
    values() {
      return Object.keys(this.data);
    }
    minValue() {
      return Math.min.apply(null, this.values());
    }
    hashCode() {
      return en$1.hashStuff(this.values());
    }
    equals(e10) {
      return e10 instanceof Tn && ys(this.data, e10.data);
    }
    toString() {
      return "{" + this.values().join(", ") + "}";
    }
    get length() {
      return this.values().length;
    }
  }
  class vs {
    constructor(e10) {
      this.atn = e10;
    }
    getDecisionLookahead(e10) {
      if (e10 === null)
        return null;
      const n10 = e10.transitions.length, r10 = [];
      for (let s10 = 0; s10 < n10; s10++) {
        r10[s10] = new cn$1();
        const i10 = new Xt$1(), o10 = false;
        this._LOOK(
          e10.transition(s10).target,
          null,
          Te.EMPTY,
          r10[s10],
          i10,
          new Tn(),
          o10,
          false
        ), (r10[s10].length === 0 || r10[s10].contains(vs.HIT_PRED)) && (r10[s10] = null);
      }
      return r10;
    }
    LOOK(e10, n10, r10) {
      const s10 = new cn$1(), i10 = true;
      r10 = r10 || null;
      const o10 = r10 !== null ? oa(e10.atn, r10) : null;
      return this._LOOK(e10, n10, o10, s10, new Xt$1(), new Tn(), i10, true), s10;
    }
    _LOOK(e10, n10, r10, s10, i10, o10, l10, a10) {
      const c10 = new ot({ state: e10, alt: 0, context: r10 }, null);
      if (!i10.has(c10)) {
        if (i10.add(c10), e10 === n10) {
          if (r10 === null) {
            s10.addOne(B.EPSILON);
            return;
          } else if (r10.isEmpty() && a10) {
            s10.addOne(B.EOF);
            return;
          }
        }
        if (e10 instanceof At$1) {
          if (r10 === null) {
            s10.addOne(B.EPSILON);
            return;
          } else if (r10.isEmpty() && a10) {
            s10.addOne(B.EOF);
            return;
          }
          if (r10 !== Te.EMPTY) {
            const u10 = o10.has(e10.ruleIndex);
            try {
              o10.remove(e10.ruleIndex);
              for (let h10 = 0; h10 < r10.length; h10++) {
                const d10 = this.atn.states[r10.getReturnState(h10)];
                this._LOOK(d10, n10, r10.getParent(h10), s10, i10, o10, l10, a10);
              }
            } finally {
              u10 && o10.add(e10.ruleIndex);
            }
            return;
          }
        }
        for (let u10 = 0; u10 < e10.transitions.length; u10++) {
          const h10 = e10.transitions[u10];
          if (h10.constructor === Mi) {
            if (o10.has(h10.target.ruleIndex))
              continue;
            const d10 = kt$1.create(r10, h10.followState.stateNumber);
            try {
              o10.add(h10.target.ruleIndex), this._LOOK(h10.target, n10, d10, s10, i10, o10, l10, a10);
            } finally {
              o10.remove(h10.target.ruleIndex);
            }
          } else if (h10 instanceof ia)
            l10 ? this._LOOK(h10.target, n10, r10, s10, i10, o10, l10, a10) : s10.addOne(vs.HIT_PRED);
          else if (h10.isEpsilon)
            this._LOOK(h10.target, n10, r10, s10, i10, o10, l10, a10);
          else if (h10.constructor === W5)
            s10.addRange(B.MIN_USER_TOKEN_TYPE, this.atn.maxTokenType);
          else {
            let d10 = h10.label;
            d10 !== null && (h10 instanceof sa && (d10 = d10.complement(B.MIN_USER_TOKEN_TYPE, this.atn.maxTokenType)), s10.addSet(d10));
          }
        }
      }
    }
  }
  vs.HIT_PRED = B.INVALID_TYPE;
  let et$1 = class et {
    constructor(e10, n10) {
      this.grammarType = e10, this.maxTokenType = n10, this.states = [], this.decisionToState = [], this.ruleToStartState = [], this.ruleToStopState = null, this.modeNameToStartState = {}, this.ruleToTokenType = null, this.lexerActions = null, this.modeToStartState = [];
    }
    nextTokensInContext(e10, n10) {
      return new vs(this).LOOK(e10, null, n10);
    }
    nextTokensNoContext(e10) {
      return e10.nextTokenWithinRule !== null || (e10.nextTokenWithinRule = this.nextTokensInContext(e10, null), e10.nextTokenWithinRule.readOnly = true), e10.nextTokenWithinRule;
    }
    nextTokens(e10, n10) {
      return n10 === void 0 ? this.nextTokensNoContext(e10) : this.nextTokensInContext(e10, n10);
    }
    addState(e10) {
      e10 !== null && (e10.atn = this, e10.stateNumber = this.states.length), this.states.push(e10);
    }
    removeState(e10) {
      this.states[e10.stateNumber] = null;
    }
    defineDecisionState(e10) {
      return this.decisionToState.push(e10), e10.decision = this.decisionToState.length - 1, e10.decision;
    }
    getDecisionState(e10) {
      return this.decisionToState.length === 0 ? null : this.decisionToState[e10];
    }
    getExpectedTokens(e10, n10) {
      if (e10 < 0 || e10 >= this.states.length)
        throw "Invalid state number.";
      const r10 = this.states[e10];
      let s10 = this.nextTokens(r10);
      if (!s10.contains(B.EPSILON))
        return s10;
      const i10 = new cn$1();
      for (i10.addSet(s10), i10.removeOne(B.EPSILON); n10 !== null && n10.invokingState >= 0 && s10.contains(B.EPSILON); ) {
        const l10 = this.states[n10.invokingState].transitions[0];
        s10 = this.nextTokens(l10.followState), i10.addSet(s10), i10.removeOne(B.EPSILON), n10 = n10.parentCtx;
      }
      return s10.contains(B.EPSILON) && i10.addOne(B.EOF), i10;
    }
  };
  et$1.INVALID_ALT_NUMBER = 0;
  const hi = {
    LEXER: 0,
    PARSER: 1
  };
  class v2 extends oe$1 {
    constructor() {
      super(), this.stateType = oe$1.BASIC;
    }
  }
  class Os extends oe$1 {
    constructor() {
      return super(), this.decision = -1, this.nonGreedy = false, this;
    }
  }
  class fs extends Os {
    constructor() {
      return super(), this.endState = null, this;
    }
  }
  class no extends oe$1 {
    constructor() {
      return super(), this.stateType = oe$1.BLOCK_END, this.startState = null, this;
    }
  }
  class es extends oe$1 {
    constructor() {
      return super(), this.stateType = oe$1.LOOP_END, this.loopBackState = null, this;
    }
  }
  class b2 extends oe$1 {
    constructor() {
      return super(), this.stateType = oe$1.RULE_START, this.stopState = null, this.isPrecedenceRule = false, this;
    }
  }
  class o7 extends Os {
    constructor() {
      return super(), this.stateType = oe$1.TOKEN_START, this;
    }
  }
  class w2 extends Os {
    constructor() {
      return super(), this.stateType = oe$1.PLUS_LOOP_BACK, this;
    }
  }
  class ro extends oe$1 {
    constructor() {
      return super(), this.stateType = oe$1.STAR_LOOP_BACK, this;
    }
  }
  class Er extends Os {
    constructor() {
      return super(), this.stateType = oe$1.STAR_LOOP_ENTRY, this.loopBackState = null, this.isPrecedenceDecision = null, this;
    }
  }
  class so extends fs {
    constructor() {
      return super(), this.stateType = oe$1.PLUS_BLOCK_START, this.loopBackState = null, this;
    }
  }
  class io extends fs {
    constructor() {
      return super(), this.stateType = oe$1.STAR_BLOCK_START, this;
    }
  }
  class E2 extends fs {
    constructor() {
      return super(), this.stateType = oe$1.BLOCK_START, this;
    }
  }
  class vi extends ee$1 {
    constructor(e10, n10) {
      super(e10), this.label_ = n10, this.label = this.makeLabel(), this.serializationType = ee$1.ATOM;
    }
    makeLabel() {
      const e10 = new cn$1();
      return e10.addOne(this.label_), e10;
    }
    matches(e10, n10, r10) {
      return this.label_ === e10;
    }
    toString() {
      return this.label_;
    }
  }
  class T2 extends ee$1 {
    constructor(e10, n10, r10) {
      super(e10), this.serializationType = ee$1.RANGE, this.start = n10, this.stop = r10, this.label = this.makeLabel();
    }
    makeLabel() {
      const e10 = new cn$1();
      return e10.addRange(this.start, this.stop), e10;
    }
    matches(e10, n10, r10) {
      return e10 >= this.start && e10 <= this.stop;
    }
    toString() {
      return "'" + String.fromCharCode(this.start) + "'..'" + String.fromCharCode(this.stop) + "'";
    }
  }
  class Y5 extends ee$1 {
    constructor(e10, n10, r10, s10) {
      super(e10), this.serializationType = ee$1.ACTION, this.ruleIndex = n10, this.actionIndex = r10 === void 0 ? -1 : r10, this.isCtxDependent = s10 === void 0 ? false : s10, this.isEpsilon = true;
    }
    matches(e10, n10, r10) {
      return false;
    }
    toString() {
      return "action_" + this.ruleIndex + ":" + this.actionIndex;
    }
  }
  class zs extends ee$1 {
    constructor(e10, n10) {
      super(e10), this.serializationType = ee$1.EPSILON, this.isEpsilon = true, this.outermostPrecedenceReturn = n10;
    }
    matches(e10, n10, r10) {
      return false;
    }
    toString() {
      return "epsilon";
    }
  }
  class L1 extends $e$1 {
    constructor(e10, n10, r10) {
      super(), this.ruleIndex = e10 === void 0 ? -1 : e10, this.predIndex = n10 === void 0 ? -1 : n10, this.isCtxDependent = r10 === void 0 ? false : r10;
    }
    evaluate(e10, n10) {
      const r10 = this.isCtxDependent ? n10 : null;
      return e10.sempred(r10, this.ruleIndex, this.predIndex);
    }
    updateHashCode(e10) {
      e10.update(this.ruleIndex, this.predIndex, this.isCtxDependent);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof L1 ? this.ruleIndex === e10.ruleIndex && this.predIndex === e10.predIndex && this.isCtxDependent === e10.isCtxDependent : false;
    }
    toString() {
      return "{" + this.ruleIndex + ":" + this.predIndex + "}?";
    }
  }
  $e$1.NONE = new L1();
  class X5 extends ia {
    constructor(e10, n10, r10, s10) {
      super(e10), this.serializationType = ee$1.PREDICATE, this.ruleIndex = n10, this.predIndex = r10, this.isCtxDependent = s10, this.isEpsilon = true;
    }
    matches(e10, n10, r10) {
      return false;
    }
    getPredicate() {
      return new L1(this.ruleIndex, this.predIndex, this.isCtxDependent);
    }
    toString() {
      return "pred_" + this.ruleIndex + ":" + this.predIndex;
    }
  }
  class _1 extends $e$1 {
    constructor(e10) {
      super(), this.precedence = e10 === void 0 ? 0 : e10;
    }
    evaluate(e10, n10) {
      return e10.precpred(n10, this.precedence);
    }
    evalPrecedence(e10, n10) {
      return e10.precpred(n10, this.precedence) ? $e$1.NONE : null;
    }
    compareTo(e10) {
      return this.precedence - e10.precedence;
    }
    updateHashCode(e10) {
      e10.update(this.precedence);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof _1 ? this.precedence === e10.precedence : false;
    }
    toString() {
      return "{" + this.precedence + ">=prec}?";
    }
  }
  $e$1.PrecedencePredicate = _1;
  class l7 extends ia {
    constructor(e10, n10) {
      super(e10), this.serializationType = ee$1.PRECEDENCE, this.precedence = n10, this.isEpsilon = true;
    }
    matches(e10, n10, r10) {
      return false;
    }
    getPredicate() {
      return new _1(this.precedence);
    }
    toString() {
      return this.precedence + " >= _p";
    }
  }
  class L0 {
    constructor(e10) {
      e10 === void 0 && (e10 = null), this.readOnly = false, this.verifyATN = e10 === null ? true : e10.verifyATN, this.generateRuleBypassTransitions = e10 === null ? false : e10.generateRuleBypassTransitions;
    }
  }
  L0.defaultOptions = new L0();
  L0.defaultOptions.readOnly = true;
  const Ct = {
    CHANNEL: 0,
    CUSTOM: 1,
    MODE: 2,
    MORE: 3,
    POP_MODE: 4,
    PUSH_MODE: 5,
    SKIP: 6,
    TYPE: 7
  };
  class Qn {
    constructor(e10) {
      this.actionType = e10, this.isPositionDependent = false;
    }
    hashCode() {
      const e10 = new en$1();
      return this.updateHashCode(e10), e10.finish();
    }
    updateHashCode(e10) {
      e10.update(this.actionType);
    }
    equals(e10) {
      return this === e10;
    }
  }
  class Go extends Qn {
    constructor() {
      super(Ct.SKIP);
    }
    execute(e10) {
      e10.skip();
    }
    toString() {
      return "skip";
    }
  }
  Go.INSTANCE = new Go();
  class aa extends Qn {
    constructor(e10) {
      super(Ct.CHANNEL), this.channel = e10;
    }
    execute(e10) {
      e10._channel = this.channel;
    }
    updateHashCode(e10) {
      e10.update(this.actionType, this.channel);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof aa ? this.channel === e10.channel : false;
    }
    toString() {
      return "channel(" + this.channel + ")";
    }
  }
  class ca extends Qn {
    constructor(e10, n10) {
      super(Ct.CUSTOM), this.ruleIndex = e10, this.actionIndex = n10, this.isPositionDependent = true;
    }
    execute(e10) {
      e10.action(null, this.ruleIndex, this.actionIndex);
    }
    updateHashCode(e10) {
      e10.update(this.actionType, this.ruleIndex, this.actionIndex);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof ca ? this.ruleIndex === e10.ruleIndex && this.actionIndex === e10.actionIndex : false;
    }
  }
  class jo extends Qn {
    constructor() {
      super(Ct.MORE);
    }
    execute(e10) {
      e10.more();
    }
    toString() {
      return "more";
    }
  }
  jo.INSTANCE = new jo();
  class ua extends Qn {
    constructor(e10) {
      super(Ct.TYPE), this.type = e10;
    }
    execute(e10) {
      e10.type = this.type;
    }
    updateHashCode(e10) {
      e10.update(this.actionType, this.type);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof ua ? this.type === e10.type : false;
    }
    toString() {
      return "type(" + this.type + ")";
    }
  }
  class ha extends Qn {
    constructor(e10) {
      super(Ct.PUSH_MODE), this.mode = e10;
    }
    execute(e10) {
      e10.pushMode(this.mode);
    }
    updateHashCode(e10) {
      e10.update(this.actionType, this.mode);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof ha ? this.mode === e10.mode : false;
    }
    toString() {
      return "pushMode(" + this.mode + ")";
    }
  }
  class Zo extends Qn {
    constructor() {
      super(Ct.POP_MODE);
    }
    execute(e10) {
      e10.popMode();
    }
    toString() {
      return "popMode";
    }
  }
  Zo.INSTANCE = new Zo();
  class da extends Qn {
    constructor(e10) {
      super(Ct.MODE), this.mode = e10;
    }
    execute(e10) {
      e10.mode(this.mode);
    }
    updateHashCode(e10) {
      e10.update(this.actionType, this.mode);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof da ? this.mode === e10.mode : false;
    }
    toString() {
      return "mode(" + this.mode + ")";
    }
  }
  const oo = 4;
  function di(t10, e10) {
    const n10 = [];
    return n10[t10 - 1] = e10, n10.map(function(r10) {
      return e10;
    });
  }
  class Q5 {
    constructor(e10) {
      e10 == null && (e10 = L0.defaultOptions), this.deserializationOptions = e10, this.stateFactories = null, this.actionFactories = null;
    }
    deserialize(e10) {
      const n10 = this.reset(e10);
      this.checkVersion(n10), n10 && this.skipUUID();
      const r10 = this.readATN();
      this.readStates(r10, n10), this.readRules(r10, n10), this.readModes(r10);
      const s10 = [];
      return this.readSets(r10, s10, this.readInt.bind(this)), n10 && this.readSets(r10, s10, this.readInt32.bind(this)), this.readEdges(r10, s10), this.readDecisions(r10), this.readLexerActions(r10, n10), this.markPrecedenceDecisions(r10), this.verifyATN(r10), this.deserializationOptions.generateRuleBypassTransitions && r10.grammarType === hi.PARSER && (this.generateRuleBypassTransitions(r10), this.verifyATN(r10)), r10;
    }
    reset(e10) {
      if ((e10.charCodeAt ? e10.charCodeAt(0) : e10[0]) === oo - 1) {
        const r10 = function(i10) {
          const o10 = i10.charCodeAt(0);
          return o10 > 1 ? o10 - 2 : o10 + 65534;
        }, s10 = e10.split("").map(r10);
        return s10[0] = e10.charCodeAt(0), this.data = s10, this.pos = 0, true;
      } else
        return this.data = e10, this.pos = 0, false;
    }
    skipUUID() {
      let e10 = 0;
      for (; e10++ < 8; )
        this.readInt();
    }
    checkVersion(e10) {
      const n10 = this.readInt();
      if (!e10 && n10 !== oo)
        throw "Could not deserialize ATN with version " + n10 + " (expected " + oo + ").";
    }
    readATN() {
      const e10 = this.readInt(), n10 = this.readInt();
      return new et$1(e10, n10);
    }
    readStates(e10, n10) {
      let r10, s10, i10;
      const o10 = [], l10 = [], a10 = this.readInt();
      for (let h10 = 0; h10 < a10; h10++) {
        const d10 = this.readInt();
        if (d10 === oe$1.INVALID_TYPE) {
          e10.addState(null);
          continue;
        }
        let p10 = this.readInt();
        n10 && p10 === 65535 && (p10 = -1);
        const g = this.stateFactory(d10, p10);
        if (d10 === oe$1.LOOP_END) {
          const L = this.readInt();
          o10.push([g, L]);
        } else if (g instanceof fs) {
          const L = this.readInt();
          l10.push([g, L]);
        }
        e10.addState(g);
      }
      for (r10 = 0; r10 < o10.length; r10++)
        s10 = o10[r10], s10[0].loopBackState = e10.states[s10[1]];
      for (r10 = 0; r10 < l10.length; r10++)
        s10 = l10[r10], s10[0].endState = e10.states[s10[1]];
      let c10 = this.readInt();
      for (r10 = 0; r10 < c10; r10++)
        i10 = this.readInt(), e10.states[i10].nonGreedy = true;
      let u10 = this.readInt();
      for (r10 = 0; r10 < u10; r10++)
        i10 = this.readInt(), e10.states[i10].isPrecedenceRule = true;
    }
    readRules(e10, n10) {
      let r10;
      const s10 = this.readInt();
      for (e10.grammarType === hi.LEXER && (e10.ruleToTokenType = di(s10, 0)), e10.ruleToStartState = di(s10, 0), r10 = 0; r10 < s10; r10++) {
        const i10 = this.readInt();
        if (e10.ruleToStartState[r10] = e10.states[i10], e10.grammarType === hi.LEXER) {
          let o10 = this.readInt();
          n10 && o10 === 65535 && (o10 = B.EOF), e10.ruleToTokenType[r10] = o10;
        }
      }
      for (e10.ruleToStopState = di(s10, 0), r10 = 0; r10 < e10.states.length; r10++) {
        const i10 = e10.states[r10];
        i10 instanceof At$1 && (e10.ruleToStopState[i10.ruleIndex] = i10, e10.ruleToStartState[i10.ruleIndex].stopState = i10);
      }
    }
    readModes(e10) {
      const n10 = this.readInt();
      for (let r10 = 0; r10 < n10; r10++) {
        let s10 = this.readInt();
        e10.modeToStartState.push(e10.states[s10]);
      }
    }
    readSets(e10, n10, r10) {
      const s10 = this.readInt();
      for (let i10 = 0; i10 < s10; i10++) {
        const o10 = new cn$1();
        n10.push(o10);
        const l10 = this.readInt();
        this.readInt() !== 0 && o10.addOne(-1);
        for (let c10 = 0; c10 < l10; c10++) {
          const u10 = r10(), h10 = r10();
          o10.addRange(u10, h10);
        }
      }
    }
    readEdges(e10, n10) {
      let r10, s10, i10, o10, l10;
      const a10 = this.readInt();
      for (r10 = 0; r10 < a10; r10++) {
        const c10 = this.readInt(), u10 = this.readInt(), h10 = this.readInt(), d10 = this.readInt(), p10 = this.readInt(), g = this.readInt();
        o10 = this.edgeFactory(e10, h10, c10, u10, d10, p10, g, n10), e10.states[c10].addTransition(o10);
      }
      for (r10 = 0; r10 < e10.states.length; r10++)
        for (i10 = e10.states[r10], s10 = 0; s10 < i10.transitions.length; s10++) {
          const c10 = i10.transitions[s10];
          if (!(c10 instanceof Mi))
            continue;
          let u10 = -1;
          e10.ruleToStartState[c10.target.ruleIndex].isPrecedenceRule && c10.precedence === 0 && (u10 = c10.target.ruleIndex), o10 = new zs(c10.followState, u10), e10.ruleToStopState[c10.target.ruleIndex].addTransition(o10);
        }
      for (r10 = 0; r10 < e10.states.length; r10++) {
        if (i10 = e10.states[r10], i10 instanceof fs) {
          if (i10.endState === null || i10.endState.startState !== null)
            throw "IllegalState";
          i10.endState.startState = i10;
        }
        if (i10 instanceof w2)
          for (s10 = 0; s10 < i10.transitions.length; s10++)
            l10 = i10.transitions[s10].target, l10 instanceof so && (l10.loopBackState = i10);
        else if (i10 instanceof ro)
          for (s10 = 0; s10 < i10.transitions.length; s10++)
            l10 = i10.transitions[s10].target, l10 instanceof Er && (l10.loopBackState = i10);
      }
    }
    readDecisions(e10) {
      const n10 = this.readInt();
      for (let r10 = 0; r10 < n10; r10++) {
        const s10 = this.readInt(), i10 = e10.states[s10];
        e10.decisionToState.push(i10), i10.decision = r10;
      }
    }
    readLexerActions(e10, n10) {
      if (e10.grammarType === hi.LEXER) {
        const r10 = this.readInt();
        e10.lexerActions = di(r10, null);
        for (let s10 = 0; s10 < r10; s10++) {
          const i10 = this.readInt();
          let o10 = this.readInt();
          n10 && o10 === 65535 && (o10 = -1);
          let l10 = this.readInt();
          n10 && l10 === 65535 && (l10 = -1), e10.lexerActions[s10] = this.lexerActionFactory(i10, o10, l10);
        }
      }
    }
    generateRuleBypassTransitions(e10) {
      let n10;
      const r10 = e10.ruleToStartState.length;
      for (n10 = 0; n10 < r10; n10++)
        e10.ruleToTokenType[n10] = e10.maxTokenType + n10 + 1;
      for (n10 = 0; n10 < r10; n10++)
        this.generateRuleBypassTransition(e10, n10);
    }
    generateRuleBypassTransition(e10, n10) {
      let r10, s10;
      const i10 = new E2();
      i10.ruleIndex = n10, e10.addState(i10);
      const o10 = new no();
      o10.ruleIndex = n10, e10.addState(o10), i10.endState = o10, e10.defineDecisionState(i10), o10.startState = i10;
      let l10 = null, a10 = null;
      if (e10.ruleToStartState[n10].isPrecedenceRule) {
        for (a10 = null, r10 = 0; r10 < e10.states.length; r10++)
          if (s10 = e10.states[r10], this.stateIsEndStateFor(s10, n10)) {
            a10 = s10, l10 = s10.loopBackState.transitions[0];
            break;
          }
        if (l10 === null)
          throw "Couldn't identify final state of the precedence rule prefix section.";
      } else
        a10 = e10.ruleToStopState[n10];
      for (r10 = 0; r10 < e10.states.length; r10++) {
        s10 = e10.states[r10];
        for (let d10 = 0; d10 < s10.transitions.length; d10++) {
          const p10 = s10.transitions[d10];
          p10 !== l10 && p10.target === a10 && (p10.target = o10);
        }
      }
      const c10 = e10.ruleToStartState[n10], u10 = c10.transitions.length;
      for (; u10 > 0; )
        i10.addTransition(c10.transitions[u10 - 1]), c10.transitions = c10.transitions.slice(-1);
      e10.ruleToStartState[n10].addTransition(new zs(i10)), o10.addTransition(new zs(a10));
      const h10 = new v2();
      e10.addState(h10), h10.addTransition(new vi(o10, e10.ruleToTokenType[n10])), i10.addTransition(new zs(h10));
    }
    stateIsEndStateFor(e10, n10) {
      if (e10.ruleIndex !== n10 || !(e10 instanceof Er))
        return null;
      const r10 = e10.transitions[e10.transitions.length - 1].target;
      return r10 instanceof es && r10.epsilonOnlyTransitions && r10.transitions[0].target instanceof At$1 ? e10 : null;
    }
    markPrecedenceDecisions(e10) {
      for (let n10 = 0; n10 < e10.states.length; n10++) {
        const r10 = e10.states[n10];
        if (r10 instanceof Er && e10.ruleToStartState[r10.ruleIndex].isPrecedenceRule) {
          const s10 = r10.transitions[r10.transitions.length - 1].target;
          s10 instanceof es && s10.epsilonOnlyTransitions && s10.transitions[0].target instanceof At$1 && (r10.isPrecedenceDecision = true);
        }
      }
    }
    verifyATN(e10) {
      if (!!this.deserializationOptions.verifyATN)
        for (let n10 = 0; n10 < e10.states.length; n10++) {
          const r10 = e10.states[n10];
          if (r10 !== null)
            if (this.checkCondition(r10.epsilonOnlyTransitions || r10.transitions.length <= 1), r10 instanceof so)
              this.checkCondition(r10.loopBackState !== null);
            else if (r10 instanceof Er)
              if (this.checkCondition(r10.loopBackState !== null), this.checkCondition(r10.transitions.length === 2), r10.transitions[0].target instanceof io)
                this.checkCondition(r10.transitions[1].target instanceof es), this.checkCondition(!r10.nonGreedy);
              else if (r10.transitions[0].target instanceof es)
                this.checkCondition(r10.transitions[1].target instanceof io), this.checkCondition(r10.nonGreedy);
              else
                throw "IllegalState";
            else
              r10 instanceof ro ? (this.checkCondition(r10.transitions.length === 1), this.checkCondition(r10.transitions[0].target instanceof Er)) : r10 instanceof es ? this.checkCondition(r10.loopBackState !== null) : r10 instanceof b2 ? this.checkCondition(r10.stopState !== null) : r10 instanceof fs ? this.checkCondition(r10.endState !== null) : r10 instanceof no ? this.checkCondition(r10.startState !== null) : r10 instanceof Os ? this.checkCondition(r10.transitions.length <= 1 || r10.decision >= 0) : this.checkCondition(r10.transitions.length <= 1 || r10 instanceof At$1);
        }
    }
    checkCondition(e10, n10) {
      if (!e10)
        throw n10 == null && (n10 = "IllegalState"), n10;
    }
    readInt() {
      return this.data[this.pos++];
    }
    readInt32() {
      const e10 = this.readInt(), n10 = this.readInt();
      return e10 | n10 << 16;
    }
    edgeFactory(e10, n10, r10, s10, i10, o10, l10, a10) {
      const c10 = e10.states[s10];
      switch (n10) {
        case ee$1.EPSILON:
          return new zs(c10);
        case ee$1.RANGE:
          return l10 !== 0 ? new T2(c10, B.EOF, o10) : new T2(c10, i10, o10);
        case ee$1.RULE:
          return new Mi(e10.states[i10], o10, l10, c10);
        case ee$1.PREDICATE:
          return new X5(c10, i10, o10, l10 !== 0);
        case ee$1.PRECEDENCE:
          return new l7(c10, i10);
        case ee$1.ATOM:
          return l10 !== 0 ? new vi(c10, B.EOF) : new vi(c10, i10);
        case ee$1.ACTION:
          return new Y5(c10, i10, o10, l10 !== 0);
        case ee$1.SET:
          return new ra(c10, a10[i10]);
        case ee$1.NOT_SET:
          return new sa(c10, a10[i10]);
        case ee$1.WILDCARD:
          return new W5(c10);
        default:
          throw "The specified transition type: " + n10 + " is not valid.";
      }
    }
    stateFactory(e10, n10) {
      if (this.stateFactories === null) {
        const r10 = [];
        r10[oe$1.INVALID_TYPE] = null, r10[oe$1.BASIC] = () => new v2(), r10[oe$1.RULE_START] = () => new b2(), r10[oe$1.BLOCK_START] = () => new E2(), r10[oe$1.PLUS_BLOCK_START] = () => new so(), r10[oe$1.STAR_BLOCK_START] = () => new io(), r10[oe$1.TOKEN_START] = () => new o7(), r10[oe$1.RULE_STOP] = () => new At$1(), r10[oe$1.BLOCK_END] = () => new no(), r10[oe$1.STAR_LOOP_BACK] = () => new ro(), r10[oe$1.STAR_LOOP_ENTRY] = () => new Er(), r10[oe$1.PLUS_LOOP_BACK] = () => new w2(), r10[oe$1.LOOP_END] = () => new es(), this.stateFactories = r10;
      }
      if (e10 > this.stateFactories.length || this.stateFactories[e10] === null)
        throw "The specified state type " + e10 + " is not valid.";
      {
        const r10 = this.stateFactories[e10]();
        if (r10 !== null)
          return r10.ruleIndex = n10, r10;
      }
    }
    lexerActionFactory(e10, n10, r10) {
      if (this.actionFactories === null) {
        const s10 = [];
        s10[Ct.CHANNEL] = (i10, o10) => new aa(i10), s10[Ct.CUSTOM] = (i10, o10) => new ca(i10, o10), s10[Ct.MODE] = (i10, o10) => new da(i10), s10[Ct.MORE] = (i10, o10) => jo.INSTANCE, s10[Ct.POP_MODE] = (i10, o10) => Zo.INSTANCE, s10[Ct.PUSH_MODE] = (i10, o10) => new ha(i10), s10[Ct.SKIP] = (i10, o10) => Go.INSTANCE, s10[Ct.TYPE] = (i10, o10) => new ua(i10), this.actionFactories = s10;
      }
      if (e10 > this.actionFactories.length || this.actionFactories[e10] === null)
        throw "The specified lexer action type " + e10 + " is not valid.";
      return this.actionFactories[e10](n10, r10);
    }
  }
  class y1 {
    syntaxError(e10, n10, r10, s10, i10, o10) {
    }
    reportAmbiguity(e10, n10, r10, s10, i10, o10, l10) {
    }
    reportAttemptingFullContext(e10, n10, r10, s10, i10, o10) {
    }
    reportContextSensitivity(e10, n10, r10, s10, i10, o10) {
    }
  }
  class Wo extends y1 {
    constructor() {
      super();
    }
    syntaxError(e10, n10, r10, s10, i10, o10) {
      console.error("line " + r10 + ":" + s10 + " " + i10);
    }
  }
  Wo.INSTANCE = new Wo();
  class a7 extends y1 {
    constructor(e10) {
      if (super(), e10 === null)
        throw "delegates";
      return this.delegates = e10, this;
    }
    syntaxError(e10, n10, r10, s10, i10, o10) {
      this.delegates.map((l10) => l10.syntaxError(e10, n10, r10, s10, i10, o10));
    }
    reportAmbiguity(e10, n10, r10, s10, i10, o10, l10) {
      this.delegates.map((a10) => a10.reportAmbiguity(e10, n10, r10, s10, i10, o10, l10));
    }
    reportAttemptingFullContext(e10, n10, r10, s10, i10, o10) {
      this.delegates.map((l10) => l10.reportAttemptingFullContext(e10, n10, r10, s10, i10, o10));
    }
    reportContextSensitivity(e10, n10, r10, s10, i10, o10) {
      this.delegates.map((l10) => l10.reportContextSensitivity(e10, n10, r10, s10, i10, o10));
    }
  }
  class C1 {
    constructor() {
      this._listeners = [Wo.INSTANCE], this._interp = null, this._stateNumber = -1;
    }
    checkVersion(e10) {
      const n10 = "4.11.0";
      n10 !== e10 && console.log("ANTLR runtime and generated code versions disagree: " + n10 + "!=" + e10);
    }
    addErrorListener(e10) {
      this._listeners.push(e10);
    }
    removeErrorListeners() {
      this._listeners = [];
    }
    getLiteralNames() {
      return Object.getPrototypeOf(this).constructor.literalNames || [];
    }
    getSymbolicNames() {
      return Object.getPrototypeOf(this).constructor.symbolicNames || [];
    }
    getTokenNames() {
      if (!this.tokenNames) {
        const e10 = this.getLiteralNames(), n10 = this.getSymbolicNames(), r10 = e10.length > n10.length ? e10.length : n10.length;
        this.tokenNames = [];
        for (let s10 = 0; s10 < r10; s10++)
          this.tokenNames[s10] = e10[s10] || n10[s10] || "<INVALID";
      }
      return this.tokenNames;
    }
    getTokenTypeMap() {
      const e10 = this.getTokenNames();
      if (e10 === null)
        throw "The current recognizer does not provide a list of token names.";
      let n10 = this.tokenTypeMapCache[e10];
      return n10 === void 0 && (n10 = e10.reduce(function(r10, s10, i10) {
        r10[s10] = i10;
      }), n10.EOF = B.EOF, this.tokenTypeMapCache[e10] = n10), n10;
    }
    getRuleIndexMap() {
      const e10 = this.ruleNames;
      if (e10 === null)
        throw "The current recognizer does not provide a list of rule names.";
      let n10 = this.ruleIndexMapCache[e10];
      return n10 === void 0 && (n10 = e10.reduce(function(r10, s10, i10) {
        r10[s10] = i10;
      }), this.ruleIndexMapCache[e10] = n10), n10;
    }
    getTokenType(e10) {
      const n10 = this.getTokenTypeMap()[e10];
      return n10 !== void 0 ? n10 : B.INVALID_TYPE;
    }
    getErrorHeader(e10) {
      const n10 = e10.getOffendingToken().line, r10 = e10.getOffendingToken().column;
      return "line " + n10 + ":" + r10;
    }
    getTokenErrorDisplay(e10) {
      if (e10 === null)
        return "<no token>";
      let n10 = e10.text;
      return n10 === null && (e10.type === B.EOF ? n10 = "<EOF>" : n10 = "<" + e10.type + ">"), n10 = n10.replace(`
`, "\\n").replace("\r", "\\r").replace("	", "\\t"), "'" + n10 + "'";
    }
    getErrorListenerDispatch() {
      return new a7(this._listeners);
    }
    sempred(e10, n10, r10) {
      return true;
    }
    precpred(e10, n10) {
      return true;
    }
    get state() {
      return this._stateNumber;
    }
    set state(e10) {
      this._stateNumber = e10;
    }
  }
  C1.tokenTypeMapCache = {};
  C1.ruleIndexMapCache = {};
  class zr extends B {
    constructor(e10, n10, r10, s10, i10) {
      super(), this.source = e10 !== void 0 ? e10 : zr.EMPTY_SOURCE, this.type = n10 !== void 0 ? n10 : null, this.channel = r10 !== void 0 ? r10 : B.DEFAULT_CHANNEL, this.start = s10 !== void 0 ? s10 : -1, this.stop = i10 !== void 0 ? i10 : -1, this.tokenIndex = -1, this.source[0] !== null ? (this.line = e10[0].line, this.column = e10[0].column) : this.column = -1;
    }
    clone() {
      const e10 = new zr(this.source, this.type, this.channel, this.start, this.stop);
      return e10.tokenIndex = this.tokenIndex, e10.line = this.line, e10.column = this.column, e10.text = this.text, e10;
    }
    toString() {
      let e10 = this.text;
      return e10 !== null ? e10 = e10.replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\t/g, "\\t") : e10 = "<no text>", "[@" + this.tokenIndex + "," + this.start + ":" + this.stop + "='" + e10 + "',<" + this.type + ">" + (this.channel > 0 ? ",channel=" + this.channel : "") + "," + this.line + ":" + this.column + "]";
    }
    get text() {
      if (this._text !== null)
        return this._text;
      const e10 = this.getInputStream();
      if (e10 === null)
        return null;
      const n10 = e10.size;
      return this.start < n10 && this.stop < n10 ? e10.getText(this.start, this.stop) : "<EOF>";
    }
    set text(e10) {
      this._text = e10;
    }
  }
  zr.EMPTY_SOURCE = [null, null];
  class c7 {
  }
  class qo extends c7 {
    constructor(e10) {
      super(), this.copyText = e10 === void 0 ? false : e10;
    }
    create(e10, n10, r10, s10, i10, o10, l10, a10) {
      const c10 = new zr(e10, n10, s10, i10, o10);
      return c10.line = l10, c10.column = a10, r10 !== null ? c10.text = r10 : this.copyText && e10[1] !== null && (c10.text = e10[1].getText(i10, o10)), c10;
    }
    createThin(e10, n10) {
      const r10 = new zr(null, e10);
      return r10.text = n10, r10;
    }
  }
  qo.DEFAULT = new qo();
  class Cr extends Error {
    constructor(e10) {
      super(e10.message), Error.captureStackTrace && Error.captureStackTrace(this, Cr), this.message = e10.message, this.recognizer = e10.recognizer, this.input = e10.input, this.ctx = e10.ctx, this.offendingToken = null, this.offendingState = -1, this.recognizer !== null && (this.offendingState = this.recognizer.state);
    }
    getExpectedTokens() {
      return this.recognizer !== null ? this.recognizer.atn.getExpectedTokens(this.offendingState, this.ctx) : null;
    }
    toString() {
      return this.message;
    }
  }
  class fa extends Cr {
    constructor(e10, n10, r10, s10) {
      super({ message: "", recognizer: e10, input: n10, ctx: null }), this.startIndex = r10, this.deadEndConfigs = s10;
    }
    toString() {
      let e10 = "";
      return this.startIndex >= 0 && this.startIndex < this.input.size && (e10 = this.input.getText(new Be$1(this.startIndex, this.startIndex))), "LexerNoViableAltException" + e10;
    }
  }
  class rt extends C1 {
    constructor(e10) {
      super(), this._input = e10, this._factory = qo.DEFAULT, this._tokenFactorySourcePair = [this, e10], this._interp = null, this._token = null, this._tokenStartCharIndex = -1, this._tokenStartLine = -1, this._tokenStartColumn = -1, this._hitEOF = false, this._channel = B.DEFAULT_CHANNEL, this._type = B.INVALID_TYPE, this._modeStack = [], this._mode = rt.DEFAULT_MODE, this._text = null;
    }
    reset() {
      this._input !== null && this._input.seek(0), this._token = null, this._type = B.INVALID_TYPE, this._channel = B.DEFAULT_CHANNEL, this._tokenStartCharIndex = -1, this._tokenStartColumn = -1, this._tokenStartLine = -1, this._text = null, this._hitEOF = false, this._mode = rt.DEFAULT_MODE, this._modeStack = [], this._interp.reset();
    }
    nextToken() {
      if (this._input === null)
        throw "nextToken requires a non-null input stream.";
      const e10 = this._input.mark();
      try {
        for (; ; ) {
          if (this._hitEOF)
            return this.emitEOF(), this._token;
          this._token = null, this._channel = B.DEFAULT_CHANNEL, this._tokenStartCharIndex = this._input.index, this._tokenStartColumn = this._interp.column, this._tokenStartLine = this._interp.line, this._text = null;
          let n10 = false;
          for (; ; ) {
            this._type = B.INVALID_TYPE;
            let r10 = rt.SKIP;
            try {
              r10 = this._interp.match(this._input, this._mode);
            } catch (s10) {
              if (s10 instanceof Cr)
                this.notifyListeners(s10), this.recover(s10);
              else
                throw console.log(s10.stack), s10;
            }
            if (this._input.LA(1) === B.EOF && (this._hitEOF = true), this._type === B.INVALID_TYPE && (this._type = r10), this._type === rt.SKIP) {
              n10 = true;
              break;
            }
            if (this._type !== rt.MORE)
              break;
          }
          if (!n10)
            return this._token === null && this.emit(), this._token;
        }
      } finally {
        this._input.release(e10);
      }
    }
    skip() {
      this._type = rt.SKIP;
    }
    more() {
      this._type = rt.MORE;
    }
    mode(e10) {
      this._mode = e10;
    }
    pushMode(e10) {
      this._interp.debug && console.log("pushMode " + e10), this._modeStack.push(this._mode), this.mode(e10);
    }
    popMode() {
      if (this._modeStack.length === 0)
        throw "Empty Stack";
      return this._interp.debug && console.log("popMode back to " + this._modeStack.slice(0, -1)), this.mode(this._modeStack.pop()), this._mode;
    }
    emitToken(e10) {
      this._token = e10;
    }
    emit() {
      const e10 = this._factory.create(
        this._tokenFactorySourcePair,
        this._type,
        this._text,
        this._channel,
        this._tokenStartCharIndex,
        this.getCharIndex() - 1,
        this._tokenStartLine,
        this._tokenStartColumn
      );
      return this.emitToken(e10), e10;
    }
    emitEOF() {
      const e10 = this.column, n10 = this.line, r10 = this._factory.create(
        this._tokenFactorySourcePair,
        B.EOF,
        null,
        B.DEFAULT_CHANNEL,
        this._input.index,
        this._input.index - 1,
        n10,
        e10
      );
      return this.emitToken(r10), r10;
    }
    getCharIndex() {
      return this._input.index;
    }
    getAllTokens() {
      const e10 = [];
      let n10 = this.nextToken();
      for (; n10.type !== B.EOF; )
        e10.push(n10), n10 = this.nextToken();
      return e10;
    }
    notifyListeners(e10) {
      const n10 = this._tokenStartCharIndex, r10 = this._input.index, s10 = this._input.getText(n10, r10), i10 = "token recognition error at: '" + this.getErrorDisplay(s10) + "'";
      this.getErrorListenerDispatch().syntaxError(
        this,
        null,
        this._tokenStartLine,
        this._tokenStartColumn,
        i10,
        e10
      );
    }
    getErrorDisplay(e10) {
      const n10 = [];
      for (let r10 = 0; r10 < e10.length; r10++)
        n10.push(e10[r10]);
      return n10.join("");
    }
    getErrorDisplayForChar(e10) {
      return e10.charCodeAt(0) === B.EOF ? "<EOF>" : e10 === `
` ? "\\n" : e10 === "	" ? "\\t" : e10 === "\r" ? "\\r" : e10;
    }
    getCharErrorDisplay(e10) {
      return "'" + this.getErrorDisplayForChar(e10) + "'";
    }
    recover(e10) {
      this._input.LA(1) !== B.EOF && (e10 instanceof fa ? this._interp.consume(this._input) : this._input.consume());
    }
    get inputStream() {
      return this._input;
    }
    set inputStream(e10) {
      this._input = null, this._tokenFactorySourcePair = [this, this._input], this.reset(), this._input = e10, this._tokenFactorySourcePair = [this, this._input];
    }
    get sourceName() {
      return this._input.sourceName;
    }
    get type() {
      return this._type;
    }
    set type(e10) {
      this._type = e10;
    }
    get line() {
      return this._interp.line;
    }
    set line(e10) {
      this._interp.line = e10;
    }
    get column() {
      return this._interp.column;
    }
    set column(e10) {
      this._interp.column = e10;
    }
    get text() {
      return this._text !== null ? this._text : this._interp.getText(this._input);
    }
    set text(e10) {
      this._text = e10;
    }
  }
  rt.DEFAULT_MODE = 0;
  rt.MORE = -2;
  rt.SKIP = -3;
  rt.DEFAULT_TOKEN_CHANNEL = B.DEFAULT_CHANNEL;
  rt.HIDDEN = B.HIDDEN_CHANNEL;
  rt.MIN_CHAR_VALUE = 0;
  rt.MAX_CHAR_VALUE = 1114111;
  function u7(t10) {
    return t10.hashCodeForConfigSet();
  }
  function h7(t10, e10) {
    return t10 === e10 ? true : t10 === null || e10 === null ? false : t10.equalsForConfigSet(e10);
  }
  let Tt$1 = class Tt2 {
    constructor(e10) {
      this.configLookup = new Xt$1(u7, h7), this.fullCtx = e10 === void 0 ? true : e10, this.readOnly = false, this.configs = [], this.uniqueAlt = 0, this.conflictingAlts = null, this.hasSemanticContext = false, this.dipsIntoOuterContext = false, this.cachedHashCode = -1;
    }
    add(e10, n10) {
      if (n10 === void 0 && (n10 = null), this.readOnly)
        throw "This set is readonly";
      e10.semanticContext !== $e$1.NONE && (this.hasSemanticContext = true), e10.reachesIntoOuterContext > 0 && (this.dipsIntoOuterContext = true);
      const r10 = this.configLookup.add(e10);
      if (r10 === e10)
        return this.cachedHashCode = -1, this.configs.push(e10), true;
      const s10 = !this.fullCtx, i10 = la(r10.context, e10.context, s10, n10);
      return r10.reachesIntoOuterContext = Math.max(r10.reachesIntoOuterContext, e10.reachesIntoOuterContext), e10.precedenceFilterSuppressed && (r10.precedenceFilterSuppressed = true), r10.context = i10, true;
    }
    getStates() {
      const e10 = new Xt$1();
      for (let n10 = 0; n10 < this.configs.length; n10++)
        e10.add(this.configs[n10].state);
      return e10;
    }
    getPredicates() {
      const e10 = [];
      for (let n10 = 0; n10 < this.configs.length; n10++) {
        const r10 = this.configs[n10].semanticContext;
        r10 !== $e$1.NONE && e10.push(r10.semanticContext);
      }
      return e10;
    }
    optimizeConfigs(e10) {
      if (this.readOnly)
        throw "This set is readonly";
      if (this.configLookup.length !== 0)
        for (let n10 = 0; n10 < this.configs.length; n10++) {
          const r10 = this.configs[n10];
          r10.context = e10.getCachedContext(r10.context);
        }
    }
    addAll(e10) {
      for (let n10 = 0; n10 < e10.length; n10++)
        this.add(e10[n10]);
      return false;
    }
    equals(e10) {
      return this === e10 || e10 instanceof Tt2 && ys(this.configs, e10.configs) && this.fullCtx === e10.fullCtx && this.uniqueAlt === e10.uniqueAlt && this.conflictingAlts === e10.conflictingAlts && this.hasSemanticContext === e10.hasSemanticContext && this.dipsIntoOuterContext === e10.dipsIntoOuterContext;
    }
    hashCode() {
      const e10 = new en$1();
      return e10.update(this.configs), e10.finish();
    }
    updateHashCode(e10) {
      this.readOnly ? (this.cachedHashCode === -1 && (this.cachedHashCode = this.hashCode()), e10.update(this.cachedHashCode)) : e10.update(this.hashCode());
    }
    isEmpty() {
      return this.configs.length === 0;
    }
    contains(e10) {
      if (this.configLookup === null)
        throw "This method is not implemented for readonly sets.";
      return this.configLookup.contains(e10);
    }
    containsFast(e10) {
      if (this.configLookup === null)
        throw "This method is not implemented for readonly sets.";
      return this.configLookup.containsFast(e10);
    }
    clear() {
      if (this.readOnly)
        throw "This set is readonly";
      this.configs = [], this.cachedHashCode = -1, this.configLookup = new Xt$1();
    }
    setReadonly(e10) {
      this.readOnly = e10, e10 && (this.configLookup = null);
    }
    toString() {
      return or(this.configs) + (this.hasSemanticContext ? ",hasSemanticContext=" + this.hasSemanticContext : "") + (this.uniqueAlt !== et$1.INVALID_ALT_NUMBER ? ",uniqueAlt=" + this.uniqueAlt : "") + (this.conflictingAlts !== null ? ",conflictingAlts=" + this.conflictingAlts : "") + (this.dipsIntoOuterContext ? ",dipsIntoOuterContext" : "");
    }
    get items() {
      return this.configs;
    }
    get length() {
      return this.configs.length;
    }
  };
  class Vn {
    constructor(e10, n10) {
      return e10 === null && (e10 = -1), n10 === null && (n10 = new Tt$1()), this.stateNumber = e10, this.configs = n10, this.edges = null, this.isAcceptState = false, this.prediction = 0, this.lexerActionExecutor = null, this.requiresFullContext = false, this.predicates = null, this;
    }
    getAltSet() {
      const e10 = new Xt$1();
      if (this.configs !== null)
        for (let n10 = 0; n10 < this.configs.length; n10++) {
          const r10 = this.configs[n10];
          e10.add(r10.alt);
        }
      return e10.length === 0 ? null : e10;
    }
    equals(e10) {
      return this === e10 || e10 instanceof Vn && this.configs.equals(e10.configs);
    }
    toString() {
      let e10 = "" + this.stateNumber + ":" + this.configs;
      return this.isAcceptState && (e10 = e10 + "=>", this.predicates !== null ? e10 = e10 + this.predicates : e10 = e10 + this.prediction), e10;
    }
    hashCode() {
      const e10 = new en$1();
      return e10.update(this.configs), e10.finish();
    }
  }
  let bn$1 = class bn {
    constructor(e10, n10) {
      return this.atn = e10, this.sharedContextCache = n10, this;
    }
    getCachedContext(e10) {
      if (this.sharedContextCache === null)
        return e10;
      const n10 = new F0();
      return K5(e10, this.sharedContextCache, n10);
    }
  };
  bn$1.ERROR = new Vn(2147483647, new Tt$1());
  class S2 extends Tt$1 {
    constructor() {
      super(), this.configLookup = new Xt$1();
    }
  }
  let Pt$1 = class Pt2 extends ot {
    constructor(e10, n10) {
      super(e10, n10);
      const r10 = e10.lexerActionExecutor || null;
      return this.lexerActionExecutor = r10 || (n10 !== null ? n10.lexerActionExecutor : null), this.passedThroughNonGreedyDecision = n10 !== null ? this.checkNonGreedyDecision(n10, this.state) : false, this.hashCodeForConfigSet = Pt2.prototype.hashCode, this.equalsForConfigSet = Pt2.prototype.equals, this;
    }
    updateHashCode(e10) {
      e10.update(this.state.stateNumber, this.alt, this.context, this.semanticContext, this.passedThroughNonGreedyDecision, this.lexerActionExecutor);
    }
    equals(e10) {
      return this === e10 || e10 instanceof Pt2 && this.passedThroughNonGreedyDecision === e10.passedThroughNonGreedyDecision && (this.lexerActionExecutor ? this.lexerActionExecutor.equals(e10.lexerActionExecutor) : !e10.lexerActionExecutor) && super.equals(e10);
    }
    checkNonGreedyDecision(e10, n10) {
      return e10.passedThroughNonGreedyDecision || n10 instanceof Os && n10.nonGreedy;
    }
  };
  class r0 extends Qn {
    constructor(e10, n10) {
      super(n10.actionType), this.offset = e10, this.action = n10, this.isPositionDependent = true;
    }
    execute(e10) {
      this.action.execute(e10);
    }
    updateHashCode(e10) {
      e10.update(this.actionType, this.offset, this.action);
    }
    equals(e10) {
      return this === e10 ? true : e10 instanceof r0 ? this.offset === e10.offset && this.action === e10.action : false;
    }
  }
  class rs {
    constructor(e10) {
      return this.lexerActions = e10 === null ? [] : e10, this.cachedHashCode = en$1.hashStuff(e10), this;
    }
    fixOffsetBeforeMatch(e10) {
      let n10 = null;
      for (let r10 = 0; r10 < this.lexerActions.length; r10++)
        this.lexerActions[r10].isPositionDependent && !(this.lexerActions[r10] instanceof r0) && (n10 === null && (n10 = this.lexerActions.concat([])), n10[r10] = new r0(
          e10,
          this.lexerActions[r10]
        ));
      return n10 === null ? this : new rs(n10);
    }
    execute(e10, n10, r10) {
      let s10 = false;
      const i10 = n10.index;
      try {
        for (let o10 = 0; o10 < this.lexerActions.length; o10++) {
          let l10 = this.lexerActions[o10];
          if (l10 instanceof r0) {
            const a10 = l10.offset;
            n10.seek(r10 + a10), l10 = l10.action, s10 = r10 + a10 !== i10;
          } else
            l10.isPositionDependent && (n10.seek(i10), s10 = false);
          l10.execute(e10);
        }
      } finally {
        s10 && n10.seek(i10);
      }
    }
    hashCode() {
      return this.cachedHashCode;
    }
    updateHashCode(e10) {
      e10.update(this.cachedHashCode);
    }
    equals(e10) {
      if (this === e10)
        return true;
      if (e10 instanceof rs) {
        if (this.cachedHashCode != e10.cachedHashCode)
          return false;
        if (this.lexerActions.length != e10.lexerActions.length)
          return false;
        {
          const n10 = this.lexerActions.length;
          for (let r10 = 0; r10 < n10; ++r10)
            if (!this.lexerActions[r10].equals(e10.lexerActions[r10]))
              return false;
          return true;
        }
      } else
        return false;
    }
    static append(e10, n10) {
      if (e10 === null)
        return new rs([n10]);
      const r10 = e10.lexerActions.concat([n10]);
      return new rs(r10);
    }
  }
  function A2(t10) {
    t10.index = -1, t10.line = 0, t10.column = -1, t10.dfaState = null;
  }
  class d7 {
    constructor() {
      A2(this);
    }
    reset() {
      A2(this);
    }
  }
  class nt extends bn$1 {
    constructor(e10, n10, r10, s10) {
      super(n10, s10), this.decisionToDFA = r10, this.recog = e10, this.startIndex = -1, this.line = 1, this.column = 0, this.mode = rt.DEFAULT_MODE, this.prevAccept = new d7();
    }
    copyState(e10) {
      this.column = e10.column, this.line = e10.line, this.mode = e10.mode, this.startIndex = e10.startIndex;
    }
    match(e10, n10) {
      this.mode = n10;
      const r10 = e10.mark();
      try {
        this.startIndex = e10.index, this.prevAccept.reset();
        const s10 = this.decisionToDFA[n10];
        return s10.s0 === null ? this.matchATN(e10) : this.execATN(e10, s10.s0);
      } finally {
        e10.release(r10);
      }
    }
    reset() {
      this.prevAccept.reset(), this.startIndex = -1, this.line = 1, this.column = 0, this.mode = rt.DEFAULT_MODE;
    }
    matchATN(e10) {
      const n10 = this.atn.modeToStartState[this.mode];
      nt.debug && console.log("matchATN mode " + this.mode + " start: " + n10);
      const r10 = this.mode, s10 = this.computeStartState(e10, n10), i10 = s10.hasSemanticContext;
      s10.hasSemanticContext = false;
      const o10 = this.addDFAState(s10);
      i10 || (this.decisionToDFA[this.mode].s0 = o10);
      const l10 = this.execATN(e10, o10);
      return nt.debug && console.log("DFA after matchATN: " + this.decisionToDFA[r10].toLexerString()), l10;
    }
    execATN(e10, n10) {
      nt.debug && console.log("start state closure=" + n10.configs), n10.isAcceptState && this.captureSimState(this.prevAccept, e10, n10);
      let r10 = e10.LA(1), s10 = n10;
      for (; ; ) {
        nt.debug && console.log("execATN loop starting closure: " + s10.configs);
        let i10 = this.getExistingTargetState(s10, r10);
        if (i10 === null && (i10 = this.computeTargetState(e10, s10, r10)), i10 === bn$1.ERROR || (r10 !== B.EOF && this.consume(e10), i10.isAcceptState && (this.captureSimState(this.prevAccept, e10, i10), r10 === B.EOF)))
          break;
        r10 = e10.LA(1), s10 = i10;
      }
      return this.failOrAccept(this.prevAccept, e10, s10.configs, r10);
    }
    getExistingTargetState(e10, n10) {
      if (e10.edges === null || n10 < nt.MIN_DFA_EDGE || n10 > nt.MAX_DFA_EDGE)
        return null;
      let r10 = e10.edges[n10 - nt.MIN_DFA_EDGE];
      return r10 === void 0 && (r10 = null), nt.debug && r10 !== null && console.log("reuse state " + e10.stateNumber + " edge to " + r10.stateNumber), r10;
    }
    computeTargetState(e10, n10, r10) {
      const s10 = new S2();
      return this.getReachableConfigSet(e10, n10.configs, s10, r10), s10.items.length === 0 ? (s10.hasSemanticContext || this.addDFAEdge(n10, r10, bn$1.ERROR), bn$1.ERROR) : this.addDFAEdge(n10, r10, null, s10);
    }
    failOrAccept(e10, n10, r10, s10) {
      if (this.prevAccept.dfaState !== null) {
        const i10 = e10.dfaState.lexerActionExecutor;
        return this.accept(
          n10,
          i10,
          this.startIndex,
          e10.index,
          e10.line,
          e10.column
        ), e10.dfaState.prediction;
      } else {
        if (s10 === B.EOF && n10.index === this.startIndex)
          return B.EOF;
        throw new fa(this.recog, n10, this.startIndex, r10);
      }
    }
    getReachableConfigSet(e10, n10, r10, s10) {
      let i10 = et$1.INVALID_ALT_NUMBER;
      for (let o10 = 0; o10 < n10.items.length; o10++) {
        const l10 = n10.items[o10], a10 = l10.alt === i10;
        if (!(a10 && l10.passedThroughNonGreedyDecision)) {
          nt.debug && console.log(`testing %s at %s
`, this.getTokenName(s10), l10.toString(this.recog, true));
          for (let c10 = 0; c10 < l10.state.transitions.length; c10++) {
            const u10 = l10.state.transitions[c10], h10 = this.getReachableTarget(u10, s10);
            if (h10 !== null) {
              let d10 = l10.lexerActionExecutor;
              d10 !== null && (d10 = d10.fixOffsetBeforeMatch(e10.index - this.startIndex));
              const p10 = s10 === B.EOF, g = new Pt$1({ state: h10, lexerActionExecutor: d10 }, l10);
              this.closure(
                e10,
                g,
                r10,
                a10,
                true,
                p10
              ) && (i10 = l10.alt);
            }
          }
        }
      }
    }
    accept(e10, n10, r10, s10, i10, o10) {
      nt.debug && console.log(`ACTION %s
`, n10), e10.seek(s10), this.line = i10, this.column = o10, n10 !== null && this.recog !== null && n10.execute(this.recog, e10, r10);
    }
    getReachableTarget(e10, n10) {
      return e10.matches(n10, 0, rt.MAX_CHAR_VALUE) ? e10.target : null;
    }
    computeStartState(e10, n10) {
      const r10 = Te.EMPTY, s10 = new S2();
      for (let i10 = 0; i10 < n10.transitions.length; i10++) {
        const o10 = n10.transitions[i10].target, l10 = new Pt$1({ state: o10, alt: i10 + 1, context: r10 }, null);
        this.closure(e10, l10, s10, false, false, false);
      }
      return s10;
    }
    closure(e10, n10, r10, s10, i10, o10) {
      let l10 = null;
      if (nt.debug && console.log("closure(" + n10.toString(this.recog, true) + ")"), n10.state instanceof At$1) {
        if (nt.debug && (this.recog !== null ? console.log(`closure at %s rule stop %s
`, this.recog.ruleNames[n10.state.ruleIndex], n10) : console.log(`closure at rule stop %s
`, n10)), n10.context === null || n10.context.hasEmptyPath()) {
          if (n10.context === null || n10.context.isEmpty())
            return r10.add(n10), true;
          r10.add(new Pt$1({ state: n10.state, context: Te.EMPTY }, n10)), s10 = true;
        }
        if (n10.context !== null && !n10.context.isEmpty()) {
          for (let a10 = 0; a10 < n10.context.length; a10++)
            if (n10.context.getReturnState(a10) !== Te.EMPTY_RETURN_STATE) {
              const c10 = n10.context.getParent(a10), u10 = this.atn.states[n10.context.getReturnState(a10)];
              l10 = new Pt$1({ state: u10, context: c10 }, n10), s10 = this.closure(
                e10,
                l10,
                r10,
                s10,
                i10,
                o10
              );
            }
        }
        return s10;
      }
      n10.state.epsilonOnlyTransitions || (!s10 || !n10.passedThroughNonGreedyDecision) && r10.add(n10);
      for (let a10 = 0; a10 < n10.state.transitions.length; a10++) {
        const c10 = n10.state.transitions[a10];
        l10 = this.getEpsilonTarget(e10, n10, c10, r10, i10, o10), l10 !== null && (s10 = this.closure(
          e10,
          l10,
          r10,
          s10,
          i10,
          o10
        ));
      }
      return s10;
    }
    getEpsilonTarget(e10, n10, r10, s10, i10, o10) {
      let l10 = null;
      if (r10.serializationType === ee$1.RULE) {
        const a10 = kt$1.create(n10.context, r10.followState.stateNumber);
        l10 = new Pt$1({ state: r10.target, context: a10 }, n10);
      } else {
        if (r10.serializationType === ee$1.PRECEDENCE)
          throw "Precedence predicates are not supported in lexers.";
        if (r10.serializationType === ee$1.PREDICATE)
          nt.debug && console.log("EVAL rule " + r10.ruleIndex + ":" + r10.predIndex), s10.hasSemanticContext = true, this.evaluatePredicate(e10, r10.ruleIndex, r10.predIndex, i10) && (l10 = new Pt$1({ state: r10.target }, n10));
        else if (r10.serializationType === ee$1.ACTION)
          if (n10.context === null || n10.context.hasEmptyPath()) {
            const a10 = rs.append(
              n10.lexerActionExecutor,
              this.atn.lexerActions[r10.actionIndex]
            );
            l10 = new Pt$1({ state: r10.target, lexerActionExecutor: a10 }, n10);
          } else
            l10 = new Pt$1({ state: r10.target }, n10);
        else
          r10.serializationType === ee$1.EPSILON ? l10 = new Pt$1({ state: r10.target }, n10) : (r10.serializationType === ee$1.ATOM || r10.serializationType === ee$1.RANGE || r10.serializationType === ee$1.SET) && o10 && r10.matches(B.EOF, 0, rt.MAX_CHAR_VALUE) && (l10 = new Pt$1({ state: r10.target }, n10));
      }
      return l10;
    }
    evaluatePredicate(e10, n10, r10, s10) {
      if (this.recog === null)
        return true;
      if (!s10)
        return this.recog.sempred(null, n10, r10);
      const i10 = this.column, o10 = this.line, l10 = e10.index, a10 = e10.mark();
      try {
        return this.consume(e10), this.recog.sempred(null, n10, r10);
      } finally {
        this.column = i10, this.line = o10, e10.seek(l10), e10.release(a10);
      }
    }
    captureSimState(e10, n10, r10) {
      e10.index = n10.index, e10.line = this.line, e10.column = this.column, e10.dfaState = r10;
    }
    addDFAEdge(e10, n10, r10, s10) {
      if (r10 === void 0 && (r10 = null), s10 === void 0 && (s10 = null), r10 === null && s10 !== null) {
        const i10 = s10.hasSemanticContext;
        if (s10.hasSemanticContext = false, r10 = this.addDFAState(s10), i10)
          return r10;
      }
      return n10 < nt.MIN_DFA_EDGE || n10 > nt.MAX_DFA_EDGE || (nt.debug && console.log("EDGE " + e10 + " -> " + r10 + " upon " + n10), e10.edges === null && (e10.edges = []), e10.edges[n10 - nt.MIN_DFA_EDGE] = r10), r10;
    }
    addDFAState(e10) {
      const n10 = new Vn(null, e10);
      let r10 = null;
      for (let l10 = 0; l10 < e10.items.length; l10++) {
        const a10 = e10.items[l10];
        if (a10.state instanceof At$1) {
          r10 = a10;
          break;
        }
      }
      r10 !== null && (n10.isAcceptState = true, n10.lexerActionExecutor = r10.lexerActionExecutor, n10.prediction = this.atn.ruleToTokenType[r10.state.ruleIndex]);
      const s10 = this.decisionToDFA[this.mode], i10 = s10.states.get(n10);
      if (i10 !== null)
        return i10;
      const o10 = n10;
      return o10.stateNumber = s10.states.length, e10.setReadonly(true), o10.configs = e10, s10.states.add(o10), o10;
    }
    getDFA(e10) {
      return this.decisionToDFA[e10];
    }
    getText(e10) {
      return e10.getText(this.startIndex, e10.index - 1);
    }
    consume(e10) {
      e10.LA(1) === `
`.charCodeAt(0) ? (this.line += 1, this.column = 0) : this.column += 1, e10.consume();
    }
    getTokenName(e10) {
      return e10 === -1 ? "EOF" : "'" + String.fromCharCode(e10) + "'";
    }
  }
  nt.debug = false;
  nt.dfa_debug = false;
  nt.MIN_DFA_EDGE = 0;
  nt.MAX_DFA_EDGE = 127;
  class J5 {
    constructor(e10, n10) {
      this.alt = n10, this.pred = e10;
    }
    toString() {
      return "(" + this.pred + ", " + this.alt + ")";
    }
  }
  class f7 {
    constructor() {
      this.data = {};
    }
    get(e10) {
      return this.data["k-" + e10] || null;
    }
    set(e10, n10) {
      this.data["k-" + e10] = n10;
    }
    values() {
      return Object.keys(this.data).filter((e10) => e10.startsWith("k-")).map((e10) => this.data[e10], this);
    }
  }
  const je$1 = {
    SLL: 0,
    LL: 1,
    LL_EXACT_AMBIG_DETECTION: 2,
    hasSLLConflictTerminatingPrediction: function(t10, e10) {
      if (je$1.allConfigsInRuleStopStates(e10))
        return true;
      if (t10 === je$1.SLL && e10.hasSemanticContext) {
        const r10 = new Tt$1();
        for (let s10 = 0; s10 < e10.items.length; s10++) {
          let i10 = e10.items[s10];
          i10 = new ot({ semanticContext: $e$1.NONE }, i10), r10.add(i10);
        }
        e10 = r10;
      }
      const n10 = je$1.getConflictingAltSubsets(e10);
      return je$1.hasConflictingAltSet(n10) && !je$1.hasStateAssociatedWithOneAlt(e10);
    },
    hasConfigInRuleStopState: function(t10) {
      for (let e10 = 0; e10 < t10.items.length; e10++)
        if (t10.items[e10].state instanceof At$1)
          return true;
      return false;
    },
    allConfigsInRuleStopStates: function(t10) {
      for (let e10 = 0; e10 < t10.items.length; e10++)
        if (!(t10.items[e10].state instanceof At$1))
          return false;
      return true;
    },
    resolvesToJustOneViableAlt: function(t10) {
      return je$1.getSingleViableAlt(t10);
    },
    allSubsetsConflict: function(t10) {
      return !je$1.hasNonConflictingAltSet(t10);
    },
    hasNonConflictingAltSet: function(t10) {
      for (let e10 = 0; e10 < t10.length; e10++)
        if (t10[e10].length === 1)
          return true;
      return false;
    },
    hasConflictingAltSet: function(t10) {
      for (let e10 = 0; e10 < t10.length; e10++)
        if (t10[e10].length > 1)
          return true;
      return false;
    },
    allSubsetsEqual: function(t10) {
      let e10 = null;
      for (let n10 = 0; n10 < t10.length; n10++) {
        const r10 = t10[n10];
        if (e10 === null)
          e10 = r10;
        else if (r10 !== e10)
          return false;
      }
      return true;
    },
    getUniqueAlt: function(t10) {
      const e10 = je$1.getAlts(t10);
      return e10.length === 1 ? e10.minValue() : et$1.INVALID_ALT_NUMBER;
    },
    getAlts: function(t10) {
      const e10 = new Tn();
      return t10.map(function(n10) {
        e10.or(n10);
      }), e10;
    },
    getConflictingAltSubsets: function(t10) {
      const e10 = new F0();
      return e10.hashFunction = function(n10) {
        en$1.hashStuff(n10.state.stateNumber, n10.context);
      }, e10.equalsFunction = function(n10, r10) {
        return n10.state.stateNumber === r10.state.stateNumber && n10.context.equals(r10.context);
      }, t10.items.map(function(n10) {
        let r10 = e10.get(n10);
        r10 === null && (r10 = new Tn(), e10.set(n10, r10)), r10.add(n10.alt);
      }), e10.getValues();
    },
    getStateToAltMap: function(t10) {
      const e10 = new f7();
      return t10.items.map(function(n10) {
        let r10 = e10.get(n10.state);
        r10 === null && (r10 = new Tn(), e10.set(n10.state, r10)), r10.add(n10.alt);
      }), e10;
    },
    hasStateAssociatedWithOneAlt: function(t10) {
      const e10 = je$1.getStateToAltMap(t10).values();
      for (let n10 = 0; n10 < e10.length; n10++)
        if (e10[n10].length === 1)
          return true;
      return false;
    },
    getSingleViableAlt: function(t10) {
      let e10 = null;
      for (let n10 = 0; n10 < t10.length; n10++) {
        const s10 = t10[n10].minValue();
        if (e10 === null)
          e10 = s10;
        else if (e10 !== s10)
          return et$1.INVALID_ALT_NUMBER;
      }
      return e10;
    }
  };
  class pa extends Cr {
    constructor(e10, n10, r10, s10, i10, o10) {
      o10 = o10 || e10._ctx, s10 = s10 || e10.getCurrentToken(), r10 = r10 || e10.getCurrentToken(), n10 = n10 || e10.getInputStream(), super({ message: "", recognizer: e10, input: n10, ctx: o10 }), this.deadEndConfigs = i10, this.startToken = r10, this.offendingToken = s10;
    }
  }
  class p7 {
    constructor(e10) {
      this.defaultMapCtor = e10 || F0, this.cacheMap = new this.defaultMapCtor();
    }
    get(e10, n10) {
      const r10 = this.cacheMap.get(e10) || null;
      return r10 === null ? null : r10.get(n10) || null;
    }
    set(e10, n10, r10) {
      let s10 = this.cacheMap.get(e10) || null;
      s10 === null && (s10 = new this.defaultMapCtor(), this.cacheMap.set(e10, s10)), s10.set(n10, r10);
    }
  }
  class g7 extends bn$1 {
    constructor(e10, n10, r10, s10) {
      super(n10, s10), this.parser = e10, this.decisionToDFA = r10, this.predictionMode = je$1.LL, this._input = null, this._startIndex = 0, this._outerContext = null, this._dfa = null, this.mergeCache = null, this.debug = false, this.debug_closure = false, this.debug_add = false, this.debug_list_atn_decisions = false, this.dfa_debug = false, this.retry_debug = false;
    }
    reset() {
    }
    adaptivePredict(e10, n10, r10) {
      (this.debug || this.debug_list_atn_decisions) && console.log("adaptivePredict decision " + n10 + " exec LA(1)==" + this.getLookaheadName(e10) + " line " + e10.LT(1).line + ":" + e10.LT(1).column), this._input = e10, this._startIndex = e10.index, this._outerContext = r10;
      const s10 = this.decisionToDFA[n10];
      this._dfa = s10;
      const i10 = e10.mark(), o10 = e10.index;
      try {
        let l10;
        if (s10.precedenceDfa ? l10 = s10.getPrecedenceStartState(this.parser.getPrecedence()) : l10 = s10.s0, l10 === null) {
          r10 === null && (r10 = Cs.EMPTY), (this.debug || this.debug_list_atn_decisions) && console.log("predictATN decision " + s10.decision + " exec LA(1)==" + this.getLookaheadName(e10) + ", outerContext=" + r10.toString(this.parser.ruleNames));
          const c10 = false;
          let u10 = this.computeStartState(s10.atnStartState, Cs.EMPTY, c10);
          s10.precedenceDfa ? (s10.s0.configs = u10, u10 = this.applyPrecedenceFilter(u10), l10 = this.addDFAState(s10, new Vn(null, u10)), s10.setPrecedenceStartState(this.parser.getPrecedence(), l10)) : (l10 = this.addDFAState(s10, new Vn(null, u10)), s10.s0 = l10);
        }
        const a10 = this.execATN(s10, l10, e10, o10, r10);
        return this.debug && console.log("DFA after predictATN: " + s10.toString(this.parser.literalNames, this.parser.symbolicNames)), a10;
      } finally {
        this._dfa = null, this.mergeCache = null, e10.seek(o10), e10.release(i10);
      }
    }
    execATN(e10, n10, r10, s10, i10) {
      (this.debug || this.debug_list_atn_decisions) && console.log("execATN decision " + e10.decision + " exec LA(1)==" + this.getLookaheadName(r10) + " line " + r10.LT(1).line + ":" + r10.LT(1).column);
      let o10, l10 = n10;
      this.debug && console.log("s0 = " + n10);
      let a10 = r10.LA(1);
      for (; ; ) {
        let c10 = this.getExistingTargetState(l10, a10);
        if (c10 === null && (c10 = this.computeTargetState(e10, l10, a10)), c10 === bn$1.ERROR) {
          const u10 = this.noViableAlt(r10, i10, l10.configs, s10);
          if (r10.seek(s10), o10 = this.getSynValidOrSemInvalidAltThatFinishedDecisionEntryRule(l10.configs, i10), o10 !== et$1.INVALID_ALT_NUMBER)
            return o10;
          throw u10;
        }
        if (c10.requiresFullContext && this.predictionMode !== je$1.SLL) {
          let u10 = null;
          if (c10.predicates !== null) {
            this.debug && console.log("DFA state has preds in DFA sim LL failover");
            const p10 = r10.index;
            if (p10 !== s10 && r10.seek(s10), u10 = this.evalSemanticContext(c10.predicates, i10, true), u10.length === 1)
              return this.debug && console.log("Full LL avoided"), u10.minValue();
            p10 !== s10 && r10.seek(p10);
          }
          this.dfa_debug && console.log("ctx sensitive state " + i10 + " in " + c10);
          const h10 = true, d10 = this.computeStartState(e10.atnStartState, i10, h10);
          return this.reportAttemptingFullContext(e10, u10, c10.configs, s10, r10.index), o10 = this.execATNWithFullContext(e10, c10, d10, r10, s10, i10), o10;
        }
        if (c10.isAcceptState) {
          if (c10.predicates === null)
            return c10.prediction;
          const u10 = r10.index;
          r10.seek(s10);
          const h10 = this.evalSemanticContext(c10.predicates, i10, true);
          if (h10.length === 0)
            throw this.noViableAlt(r10, i10, c10.configs, s10);
          return h10.length === 1 || this.reportAmbiguity(e10, c10, s10, u10, false, h10, c10.configs), h10.minValue();
        }
        l10 = c10, a10 !== B.EOF && (r10.consume(), a10 = r10.LA(1));
      }
    }
    getExistingTargetState(e10, n10) {
      const r10 = e10.edges;
      return r10 === null ? null : r10[n10 + 1] || null;
    }
    computeTargetState(e10, n10, r10) {
      const s10 = this.computeReachSet(n10.configs, r10, false);
      if (s10 === null)
        return this.addDFAEdge(e10, n10, r10, bn$1.ERROR), bn$1.ERROR;
      let i10 = new Vn(null, s10);
      const o10 = this.getUniqueAlt(s10);
      if (this.debug) {
        const l10 = je$1.getConflictingAltSubsets(s10);
        console.log("SLL altSubSets=" + or(l10) + ", configs=" + s10 + ", predict=" + o10 + ", allSubsetsConflict=" + je$1.allSubsetsConflict(l10) + ", conflictingAlts=" + this.getConflictingAlts(s10));
      }
      return o10 !== et$1.INVALID_ALT_NUMBER ? (i10.isAcceptState = true, i10.configs.uniqueAlt = o10, i10.prediction = o10) : je$1.hasSLLConflictTerminatingPrediction(this.predictionMode, s10) && (i10.configs.conflictingAlts = this.getConflictingAlts(s10), i10.requiresFullContext = true, i10.isAcceptState = true, i10.prediction = i10.configs.conflictingAlts.minValue()), i10.isAcceptState && i10.configs.hasSemanticContext && (this.predicateDFAState(i10, this.atn.getDecisionState(e10.decision)), i10.predicates !== null && (i10.prediction = et$1.INVALID_ALT_NUMBER)), i10 = this.addDFAEdge(e10, n10, r10, i10), i10;
    }
    predicateDFAState(e10, n10) {
      const r10 = n10.transitions.length, s10 = this.getConflictingAltsOrUniqueAlt(e10.configs), i10 = this.getPredsForAmbigAlts(s10, e10.configs, r10);
      i10 !== null ? (e10.predicates = this.getPredicatePredictions(s10, i10), e10.prediction = et$1.INVALID_ALT_NUMBER) : e10.prediction = s10.minValue();
    }
    execATNWithFullContext(e10, n10, r10, s10, i10, o10) {
      (this.debug || this.debug_list_atn_decisions) && console.log("execATNWithFullContext " + r10);
      const l10 = true;
      let a10 = false, c10, u10 = r10;
      s10.seek(i10);
      let h10 = s10.LA(1), d10 = -1;
      for (; ; ) {
        if (c10 = this.computeReachSet(u10, h10, l10), c10 === null) {
          const g = this.noViableAlt(s10, o10, u10, i10);
          s10.seek(i10);
          const L = this.getSynValidOrSemInvalidAltThatFinishedDecisionEntryRule(u10, o10);
          if (L !== et$1.INVALID_ALT_NUMBER)
            return L;
          throw g;
        }
        const p10 = je$1.getConflictingAltSubsets(c10);
        if (this.debug && console.log("LL altSubSets=" + p10 + ", predict=" + je$1.getUniqueAlt(p10) + ", resolvesToJustOneViableAlt=" + je$1.resolvesToJustOneViableAlt(p10)), c10.uniqueAlt = this.getUniqueAlt(c10), c10.uniqueAlt !== et$1.INVALID_ALT_NUMBER) {
          d10 = c10.uniqueAlt;
          break;
        } else if (this.predictionMode !== je$1.LL_EXACT_AMBIG_DETECTION) {
          if (d10 = je$1.resolvesToJustOneViableAlt(p10), d10 !== et$1.INVALID_ALT_NUMBER)
            break;
        } else if (je$1.allSubsetsConflict(p10) && je$1.allSubsetsEqual(p10)) {
          a10 = true, d10 = je$1.getSingleViableAlt(p10);
          break;
        }
        u10 = c10, h10 !== B.EOF && (s10.consume(), h10 = s10.LA(1));
      }
      return c10.uniqueAlt !== et$1.INVALID_ALT_NUMBER ? (this.reportContextSensitivity(e10, d10, c10, i10, s10.index), d10) : (this.reportAmbiguity(e10, n10, i10, s10.index, a10, null, c10), d10);
    }
    computeReachSet(e10, n10, r10) {
      this.debug && console.log("in computeReachSet, starting closure: " + e10), this.mergeCache === null && (this.mergeCache = new p7());
      const s10 = new Tt$1(r10);
      let i10 = null;
      for (let l10 = 0; l10 < e10.items.length; l10++) {
        const a10 = e10.items[l10];
        if (this.debug && console.log("testing " + this.getTokenName(n10) + " at " + a10), a10.state instanceof At$1) {
          (r10 || n10 === B.EOF) && (i10 === null && (i10 = []), i10.push(a10), this.debug_add && console.log("added " + a10 + " to skippedStopStates"));
          continue;
        }
        for (let c10 = 0; c10 < a10.state.transitions.length; c10++) {
          const u10 = a10.state.transitions[c10], h10 = this.getReachableTarget(u10, n10);
          if (h10 !== null) {
            const d10 = new ot({ state: h10 }, a10);
            s10.add(d10, this.mergeCache), this.debug_add && console.log("added " + d10 + " to intermediate");
          }
        }
      }
      let o10 = null;
      if (i10 === null && n10 !== B.EOF && (s10.items.length === 1 || this.getUniqueAlt(s10) !== et$1.INVALID_ALT_NUMBER) && (o10 = s10), o10 === null) {
        o10 = new Tt$1(r10);
        const l10 = new Xt$1(), a10 = n10 === B.EOF;
        for (let c10 = 0; c10 < s10.items.length; c10++)
          this.closure(s10.items[c10], o10, l10, false, r10, a10);
      }
      if (n10 === B.EOF && (o10 = this.removeAllConfigsNotInRuleStopState(o10, o10 === s10)), i10 !== null && (!r10 || !je$1.hasConfigInRuleStopState(o10)))
        for (let l10 = 0; l10 < i10.length; l10++)
          o10.add(i10[l10], this.mergeCache);
      return o10.items.length === 0 ? null : o10;
    }
    removeAllConfigsNotInRuleStopState(e10, n10) {
      if (je$1.allConfigsInRuleStopStates(e10))
        return e10;
      const r10 = new Tt$1(e10.fullCtx);
      for (let s10 = 0; s10 < e10.items.length; s10++) {
        const i10 = e10.items[s10];
        if (i10.state instanceof At$1) {
          r10.add(i10, this.mergeCache);
          continue;
        }
        if (n10 && i10.state.epsilonOnlyTransitions && this.atn.nextTokens(i10.state).contains(B.EPSILON)) {
          const l10 = this.atn.ruleToStopState[i10.state.ruleIndex];
          r10.add(new ot({ state: l10 }, i10), this.mergeCache);
        }
      }
      return r10;
    }
    computeStartState(e10, n10, r10) {
      const s10 = oa(this.atn, n10), i10 = new Tt$1(r10);
      for (let o10 = 0; o10 < e10.transitions.length; o10++) {
        const l10 = e10.transitions[o10].target, a10 = new ot({ state: l10, alt: o10 + 1, context: s10 }, null), c10 = new Xt$1();
        this.closure(a10, i10, c10, true, r10, false);
      }
      return i10;
    }
    applyPrecedenceFilter(e10) {
      let n10;
      const r10 = [], s10 = new Tt$1(e10.fullCtx);
      for (let i10 = 0; i10 < e10.items.length; i10++) {
        if (n10 = e10.items[i10], n10.alt !== 1)
          continue;
        const o10 = n10.semanticContext.evalPrecedence(this.parser, this._outerContext);
        o10 !== null && (r10[n10.state.stateNumber] = n10.context, o10 !== n10.semanticContext ? s10.add(new ot({ semanticContext: o10 }, n10), this.mergeCache) : s10.add(n10, this.mergeCache));
      }
      for (let i10 = 0; i10 < e10.items.length; i10++)
        if (n10 = e10.items[i10], n10.alt !== 1) {
          if (!n10.precedenceFilterSuppressed) {
            const o10 = r10[n10.state.stateNumber] || null;
            if (o10 !== null && o10.equals(n10.context))
              continue;
          }
          s10.add(n10, this.mergeCache);
        }
      return s10;
    }
    getReachableTarget(e10, n10) {
      return e10.matches(n10, 0, this.atn.maxTokenType) ? e10.target : null;
    }
    getPredsForAmbigAlts(e10, n10, r10) {
      let s10 = [];
      for (let o10 = 0; o10 < n10.items.length; o10++) {
        const l10 = n10.items[o10];
        e10.has(l10.alt) && (s10[l10.alt] = $e$1.orContext(s10[l10.alt] || null, l10.semanticContext));
      }
      let i10 = 0;
      for (let o10 = 1; o10 < r10 + 1; o10++) {
        const l10 = s10[o10] || null;
        l10 === null ? s10[o10] = $e$1.NONE : l10 !== $e$1.NONE && (i10 += 1);
      }
      return i10 === 0 && (s10 = null), this.debug && console.log("getPredsForAmbigAlts result " + or(s10)), s10;
    }
    getPredicatePredictions(e10, n10) {
      const r10 = [];
      let s10 = false;
      for (let i10 = 1; i10 < n10.length; i10++) {
        const o10 = n10[i10];
        e10 !== null && e10.has(i10) && r10.push(new J5(o10, i10)), o10 !== $e$1.NONE && (s10 = true);
      }
      return s10 ? r10 : null;
    }
    getSynValidOrSemInvalidAltThatFinishedDecisionEntryRule(e10, n10) {
      const r10 = this.splitAccordingToSemanticValidity(e10, n10), s10 = r10[0], i10 = r10[1];
      let o10 = this.getAltThatFinishedDecisionEntryRule(s10);
      return o10 !== et$1.INVALID_ALT_NUMBER || i10.items.length > 0 && (o10 = this.getAltThatFinishedDecisionEntryRule(i10), o10 !== et$1.INVALID_ALT_NUMBER) ? o10 : et$1.INVALID_ALT_NUMBER;
    }
    getAltThatFinishedDecisionEntryRule(e10) {
      const n10 = [];
      for (let r10 = 0; r10 < e10.items.length; r10++) {
        const s10 = e10.items[r10];
        (s10.reachesIntoOuterContext > 0 || s10.state instanceof At$1 && s10.context.hasEmptyPath()) && n10.indexOf(s10.alt) < 0 && n10.push(s10.alt);
      }
      return n10.length === 0 ? et$1.INVALID_ALT_NUMBER : Math.min.apply(null, n10);
    }
    splitAccordingToSemanticValidity(e10, n10) {
      const r10 = new Tt$1(e10.fullCtx), s10 = new Tt$1(e10.fullCtx);
      for (let i10 = 0; i10 < e10.items.length; i10++) {
        const o10 = e10.items[i10];
        o10.semanticContext !== $e$1.NONE ? o10.semanticContext.evaluate(this.parser, n10) ? r10.add(o10) : s10.add(o10) : r10.add(o10);
      }
      return [r10, s10];
    }
    evalSemanticContext(e10, n10, r10) {
      const s10 = new Tn();
      for (let i10 = 0; i10 < e10.length; i10++) {
        const o10 = e10[i10];
        if (o10.pred === $e$1.NONE) {
          if (s10.add(o10.alt), !r10)
            break;
          continue;
        }
        const l10 = o10.pred.evaluate(this.parser, n10);
        if ((this.debug || this.dfa_debug) && console.log("eval pred " + o10 + "=" + l10), l10 && ((this.debug || this.dfa_debug) && console.log("PREDICT " + o10.alt), s10.add(o10.alt), !r10))
          break;
      }
      return s10;
    }
    closure(e10, n10, r10, s10, i10, o10) {
      this.closureCheckingStopState(
        e10,
        n10,
        r10,
        s10,
        i10,
        0,
        o10
      );
    }
    closureCheckingStopState(e10, n10, r10, s10, i10, o10, l10) {
      if ((this.debug || this.debug_closure) && (console.log("closure(" + e10.toString(this.parser, true) + ")"), e10.reachesIntoOuterContext > 50))
        throw "problem";
      if (e10.state instanceof At$1)
        if (e10.context.isEmpty())
          if (i10) {
            n10.add(e10, this.mergeCache);
            return;
          } else
            this.debug && console.log("FALLING off rule " + this.getRuleName(e10.state.ruleIndex));
        else {
          for (let a10 = 0; a10 < e10.context.length; a10++) {
            if (e10.context.getReturnState(a10) === Te.EMPTY_RETURN_STATE) {
              if (i10) {
                n10.add(new ot({ state: e10.state, context: Te.EMPTY }, e10), this.mergeCache);
                continue;
              } else
                this.debug && console.log("FALLING off rule " + this.getRuleName(e10.state.ruleIndex)), this.closure_(
                  e10,
                  n10,
                  r10,
                  s10,
                  i10,
                  o10,
                  l10
                );
              continue;
            }
            const c10 = this.atn.states[e10.context.getReturnState(a10)], u10 = e10.context.getParent(a10), h10 = { state: c10, alt: e10.alt, context: u10, semanticContext: e10.semanticContext }, d10 = new ot(h10, null);
            d10.reachesIntoOuterContext = e10.reachesIntoOuterContext, this.closureCheckingStopState(d10, n10, r10, s10, i10, o10 - 1, l10);
          }
          return;
        }
      this.closure_(e10, n10, r10, s10, i10, o10, l10);
    }
    closure_(e10, n10, r10, s10, i10, o10, l10) {
      const a10 = e10.state;
      a10.epsilonOnlyTransitions || n10.add(e10, this.mergeCache);
      for (let c10 = 0; c10 < a10.transitions.length; c10++) {
        if (c10 === 0 && this.canDropLoopEntryEdgeInLeftRecursiveRule(e10))
          continue;
        const u10 = a10.transitions[c10], h10 = s10 && !(u10 instanceof Y5), d10 = this.getEpsilonTarget(e10, u10, h10, o10 === 0, i10, l10);
        if (d10 !== null) {
          let p10 = o10;
          if (e10.state instanceof At$1) {
            if (this._dfa !== null && this._dfa.precedenceDfa && u10.outermostPrecedenceReturn === this._dfa.atnStartState.ruleIndex && (d10.precedenceFilterSuppressed = true), d10.reachesIntoOuterContext += 1, r10.add(d10) !== d10)
              continue;
            n10.dipsIntoOuterContext = true, p10 -= 1, this.debug && console.log("dips into outer ctx: " + d10);
          } else {
            if (!u10.isEpsilon && r10.add(d10) !== d10)
              continue;
            u10 instanceof Mi && p10 >= 0 && (p10 += 1);
          }
          this.closureCheckingStopState(d10, n10, r10, h10, i10, p10, l10);
        }
      }
    }
    canDropLoopEntryEdgeInLeftRecursiveRule(e10) {
      const n10 = e10.state;
      if (n10.stateType !== oe$1.STAR_LOOP_ENTRY || n10.stateType !== oe$1.STAR_LOOP_ENTRY || !n10.isPrecedenceDecision || e10.context.isEmpty() || e10.context.hasEmptyPath())
        return false;
      const r10 = e10.context.length;
      for (let l10 = 0; l10 < r10; l10++)
        if (this.atn.states[e10.context.getReturnState(l10)].ruleIndex !== n10.ruleIndex)
          return false;
      const i10 = n10.transitions[0].target.endState.stateNumber, o10 = this.atn.states[i10];
      for (let l10 = 0; l10 < r10; l10++) {
        const a10 = e10.context.getReturnState(l10), c10 = this.atn.states[a10];
        if (c10.transitions.length !== 1 || !c10.transitions[0].isEpsilon)
          return false;
        const u10 = c10.transitions[0].target;
        if (!(c10.stateType === oe$1.BLOCK_END && u10 === n10) && c10 !== o10 && u10 !== o10 && !(u10.stateType === oe$1.BLOCK_END && u10.transitions.length === 1 && u10.transitions[0].isEpsilon && u10.transitions[0].target === n10))
          return false;
      }
      return true;
    }
    getRuleName(e10) {
      return this.parser !== null && e10 >= 0 ? this.parser.ruleNames[e10] : "<rule " + e10 + ">";
    }
    getEpsilonTarget(e10, n10, r10, s10, i10, o10) {
      switch (n10.serializationType) {
        case ee$1.RULE:
          return this.ruleTransition(e10, n10);
        case ee$1.PRECEDENCE:
          return this.precedenceTransition(e10, n10, r10, s10, i10);
        case ee$1.PREDICATE:
          return this.predTransition(e10, n10, r10, s10, i10);
        case ee$1.ACTION:
          return this.actionTransition(e10, n10);
        case ee$1.EPSILON:
          return new ot({ state: n10.target }, e10);
        case ee$1.ATOM:
        case ee$1.RANGE:
        case ee$1.SET:
          return o10 && n10.matches(B.EOF, 0, 1) ? new ot({ state: n10.target }, e10) : null;
        default:
          return null;
      }
    }
    actionTransition(e10, n10) {
      if (this.debug) {
        const r10 = n10.actionIndex === -1 ? 65535 : n10.actionIndex;
        console.log("ACTION edge " + n10.ruleIndex + ":" + r10);
      }
      return new ot({ state: n10.target }, e10);
    }
    precedenceTransition(e10, n10, r10, s10, i10) {
      this.debug && (console.log("PRED (collectPredicates=" + r10 + ") " + n10.precedence + ">=_p, ctx dependent=true"), this.parser !== null && console.log("context surrounding pred is " + or(this.parser.getRuleInvocationStack())));
      let o10 = null;
      if (r10 && s10)
        if (i10) {
          const l10 = this._input.index;
          this._input.seek(this._startIndex);
          const a10 = n10.getPredicate().evaluate(this.parser, this._outerContext);
          this._input.seek(l10), a10 && (o10 = new ot({ state: n10.target }, e10));
        } else {
          const l10 = $e$1.andContext(e10.semanticContext, n10.getPredicate());
          o10 = new ot({ state: n10.target, semanticContext: l10 }, e10);
        }
      else
        o10 = new ot({ state: n10.target }, e10);
      return this.debug && console.log("config from pred transition=" + o10), o10;
    }
    predTransition(e10, n10, r10, s10, i10) {
      this.debug && (console.log("PRED (collectPredicates=" + r10 + ") " + n10.ruleIndex + ":" + n10.predIndex + ", ctx dependent=" + n10.isCtxDependent), this.parser !== null && console.log("context surrounding pred is " + or(this.parser.getRuleInvocationStack())));
      let o10 = null;
      if (r10 && (n10.isCtxDependent && s10 || !n10.isCtxDependent))
        if (i10) {
          const l10 = this._input.index;
          this._input.seek(this._startIndex);
          const a10 = n10.getPredicate().evaluate(this.parser, this._outerContext);
          this._input.seek(l10), a10 && (o10 = new ot({ state: n10.target }, e10));
        } else {
          const l10 = $e$1.andContext(e10.semanticContext, n10.getPredicate());
          o10 = new ot({ state: n10.target, semanticContext: l10 }, e10);
        }
      else
        o10 = new ot({ state: n10.target }, e10);
      return this.debug && console.log("config from pred transition=" + o10), o10;
    }
    ruleTransition(e10, n10) {
      this.debug && console.log("CALL rule " + this.getRuleName(n10.target.ruleIndex) + ", ctx=" + e10.context);
      const r10 = n10.followState, s10 = kt$1.create(e10.context, r10.stateNumber);
      return new ot({ state: n10.target, context: s10 }, e10);
    }
    getConflictingAlts(e10) {
      const n10 = je$1.getConflictingAltSubsets(e10);
      return je$1.getAlts(n10);
    }
    getConflictingAltsOrUniqueAlt(e10) {
      let n10 = null;
      return e10.uniqueAlt !== et$1.INVALID_ALT_NUMBER ? (n10 = new Tn(), n10.add(e10.uniqueAlt)) : n10 = e10.conflictingAlts, n10;
    }
    getTokenName(e10) {
      if (e10 === B.EOF)
        return "EOF";
      if (this.parser !== null && this.parser.literalNames !== null)
        if (e10 >= this.parser.literalNames.length && e10 >= this.parser.symbolicNames.length)
          console.log("" + e10 + " ttype out of range: " + this.parser.literalNames), console.log("" + this.parser.getInputStream().getTokens());
        else
          return (this.parser.literalNames[e10] || this.parser.symbolicNames[e10]) + "<" + e10 + ">";
      return "" + e10;
    }
    getLookaheadName(e10) {
      return this.getTokenName(e10.LA(1));
    }
    dumpDeadEndConfigs(e10) {
      console.log("dead end configs: ");
      const n10 = e10.getDeadEndConfigs();
      for (let r10 = 0; r10 < n10.length; r10++) {
        const s10 = n10[r10];
        let i10 = "no edges";
        if (s10.state.transitions.length > 0) {
          const o10 = s10.state.transitions[0];
          o10 instanceof vi ? i10 = "Atom " + this.getTokenName(o10.label) : o10 instanceof ra && (i10 = (o10 instanceof sa ? "~" : "") + "Set " + o10.set);
        }
        console.error(s10.toString(this.parser, true) + ":" + i10);
      }
    }
    noViableAlt(e10, n10, r10, s10) {
      return new pa(this.parser, e10, e10.get(s10), e10.LT(1), r10, n10);
    }
    getUniqueAlt(e10) {
      let n10 = et$1.INVALID_ALT_NUMBER;
      for (let r10 = 0; r10 < e10.items.length; r10++) {
        const s10 = e10.items[r10];
        if (n10 === et$1.INVALID_ALT_NUMBER)
          n10 = s10.alt;
        else if (s10.alt !== n10)
          return et$1.INVALID_ALT_NUMBER;
      }
      return n10;
    }
    addDFAEdge(e10, n10, r10, s10) {
      if (this.debug && console.log("EDGE " + n10 + " -> " + s10 + " upon " + this.getTokenName(r10)), s10 === null)
        return null;
      if (s10 = this.addDFAState(e10, s10), n10 === null || r10 < -1 || r10 > this.atn.maxTokenType)
        return s10;
      if (n10.edges === null && (n10.edges = []), n10.edges[r10 + 1] = s10, this.debug) {
        const i10 = this.parser === null ? null : this.parser.literalNames, o10 = this.parser === null ? null : this.parser.symbolicNames;
        console.log(`DFA=
` + e10.toString(i10, o10));
      }
      return s10;
    }
    addDFAState(e10, n10) {
      if (n10 === bn$1.ERROR)
        return n10;
      const r10 = e10.states.get(n10);
      return r10 !== null ? r10 : (n10.stateNumber = e10.states.length, n10.configs.readOnly || (n10.configs.optimizeConfigs(this), n10.configs.setReadonly(true)), e10.states.add(n10), this.debug && console.log("adding new DFA state: " + n10), n10);
    }
    reportAttemptingFullContext(e10, n10, r10, s10, i10) {
      if (this.debug || this.retry_debug) {
        const o10 = new Be$1(s10, i10 + 1);
        console.log("reportAttemptingFullContext decision=" + e10.decision + ":" + r10 + ", input=" + this.parser.getTokenStream().getText(o10));
      }
      this.parser !== null && this.parser.getErrorListenerDispatch().reportAttemptingFullContext(this.parser, e10, s10, i10, n10, r10);
    }
    reportContextSensitivity(e10, n10, r10, s10, i10) {
      if (this.debug || this.retry_debug) {
        const o10 = new Be$1(s10, i10 + 1);
        console.log("reportContextSensitivity decision=" + e10.decision + ":" + r10 + ", input=" + this.parser.getTokenStream().getText(o10));
      }
      this.parser !== null && this.parser.getErrorListenerDispatch().reportContextSensitivity(this.parser, e10, s10, i10, n10, r10);
    }
    reportAmbiguity(e10, n10, r10, s10, i10, o10, l10) {
      if (this.debug || this.retry_debug) {
        const a10 = new Be$1(r10, s10 + 1);
        console.log("reportAmbiguity " + o10 + ":" + l10 + ", input=" + this.parser.getTokenStream().getText(a10));
      }
      this.parser !== null && this.parser.getErrorListenerDispatch().reportAmbiguity(this.parser, e10, r10, s10, i10, o10, l10);
    }
  }
  const m7 = { ATN: et$1, ATNDeserializer: Q5, LexerATNSimulator: nt, ParserATNSimulator: g7, PredictionMode: je$1 };
  class ga {
    constructor(e10, n10, r10) {
      this.dfa = e10, this.literalNames = n10 || [], this.symbolicNames = r10 || [];
    }
    toString() {
      if (this.dfa.s0 === null)
        return null;
      let e10 = "";
      const n10 = this.dfa.sortedStates();
      for (let r10 = 0; r10 < n10.length; r10++) {
        const s10 = n10[r10];
        if (s10.edges !== null) {
          const i10 = s10.edges.length;
          for (let o10 = 0; o10 < i10; o10++) {
            const l10 = s10.edges[o10] || null;
            l10 !== null && l10.stateNumber !== 2147483647 && (e10 = e10.concat(this.getStateString(s10)), e10 = e10.concat("-"), e10 = e10.concat(this.getEdgeLabel(o10)), e10 = e10.concat("->"), e10 = e10.concat(this.getStateString(l10)), e10 = e10.concat(`
`));
          }
        }
      }
      return e10.length === 0 ? null : e10;
    }
    getEdgeLabel(e10) {
      return e10 === 0 ? "EOF" : this.literalNames !== null || this.symbolicNames !== null ? this.literalNames[e10 - 1] || this.symbolicNames[e10 - 1] : String.fromCharCode(e10 - 1);
    }
    getStateString(e10) {
      const n10 = (e10.isAcceptState ? ":" : "") + "s" + e10.stateNumber + (e10.requiresFullContext ? "^" : "");
      return e10.isAcceptState ? e10.predicates !== null ? n10 + "=>" + or(e10.predicates) : n10 + "=>" + e10.prediction.toString() : n10;
    }
  }
  class e4 extends ga {
    constructor(e10) {
      super(e10, null);
    }
    getEdgeLabel(e10) {
      return "'" + String.fromCharCode(e10) + "'";
    }
  }
  class x7 {
    constructor(e10, n10) {
      if (n10 === void 0 && (n10 = 0), this.atnStartState = e10, this.decision = n10, this._states = new Xt$1(), this.s0 = null, this.precedenceDfa = false, e10 instanceof Er && e10.isPrecedenceDecision) {
        this.precedenceDfa = true;
        const r10 = new Vn(null, new Tt$1());
        r10.edges = [], r10.isAcceptState = false, r10.requiresFullContext = false, this.s0 = r10;
      }
    }
    getPrecedenceStartState(e10) {
      if (!this.precedenceDfa)
        throw "Only precedence DFAs may contain a precedence start state.";
      return e10 < 0 || e10 >= this.s0.edges.length ? null : this.s0.edges[e10] || null;
    }
    setPrecedenceStartState(e10, n10) {
      if (!this.precedenceDfa)
        throw "Only precedence DFAs may contain a precedence start state.";
      e10 < 0 || (this.s0.edges[e10] = n10);
    }
    setPrecedenceDfa(e10) {
      if (this.precedenceDfa !== e10) {
        if (this._states = new Xt$1(), e10) {
          const n10 = new Vn(null, new Tt$1());
          n10.edges = [], n10.isAcceptState = false, n10.requiresFullContext = false, this.s0 = n10;
        } else
          this.s0 = null;
        this.precedenceDfa = e10;
      }
    }
    sortedStates() {
      return this._states.values().sort(function(n10, r10) {
        return n10.stateNumber - r10.stateNumber;
      });
    }
    toString(e10, n10) {
      return e10 = e10 || null, n10 = n10 || null, this.s0 === null ? "" : new ga(this, e10, n10).toString();
    }
    toLexerString() {
      return this.s0 === null ? "" : new e4(this).toString();
    }
    get states() {
      return this._states;
    }
  }
  const L7 = { DFA: x7, DFASerializer: ga, LexerDFASerializer: e4, PredPrediction: J5 };
  class t4 {
    visitTerminal(e10) {
    }
    visitErrorNode(e10) {
    }
    enterEveryRule(e10) {
    }
    exitEveryRule(e10) {
    }
  }
  class _7 {
    visit(e10) {
      return Array.isArray(e10) ? e10.map(function(n10) {
        return n10.accept(this);
      }, this) : e10.accept(this);
    }
    visitChildren(e10) {
      return e10.children ? this.visit(e10.children) : null;
    }
    visitTerminal(e10) {
    }
    visitErrorNode(e10) {
    }
  }
  class Ko {
    walk(e10, n10) {
      if (n10 instanceof x1 || n10.isErrorNode !== void 0 && n10.isErrorNode())
        e10.visitErrorNode(n10);
      else if (n10 instanceof Wn)
        e10.visitTerminal(n10);
      else {
        this.enterRule(e10, n10);
        for (let s10 = 0; s10 < n10.getChildCount(); s10++) {
          const i10 = n10.getChild(s10);
          this.walk(e10, i10);
        }
        this.exitRule(e10, n10);
      }
    }
    enterRule(e10, n10) {
      const r10 = n10.getRuleContext();
      e10.enterEveryRule(r10), r10.enterRule(e10);
    }
    exitRule(e10, n10) {
      const r10 = n10.getRuleContext();
      r10.exitRule(e10), e10.exitEveryRule(r10);
    }
  }
  Ko.DEFAULT = new Ko();
  const y7 = { Trees: _n, RuleNode: Ni, ErrorNode: x1, TerminalNode: Wn, ParseTreeListener: t4, ParseTreeVisitor: _7, ParseTreeWalker: Ko };
  class s0 extends Cr {
    constructor(e10) {
      super({ message: "", recognizer: e10, input: e10.getInputStream(), ctx: e10._ctx }), this.offendingToken = e10.getCurrentToken();
    }
  }
  class n4 extends Cr {
    constructor(e10, n10, r10) {
      super({
        message: C7(n10, r10 || null),
        recognizer: e10,
        input: e10.getInputStream(),
        ctx: e10._ctx
      });
      const i10 = e10._interp.atn.states[e10.state].transitions[0];
      i10 instanceof X5 ? (this.ruleIndex = i10.ruleIndex, this.predicateIndex = i10.predIndex) : (this.ruleIndex = 0, this.predicateIndex = 0), this.predicate = n10, this.offendingToken = e10.getCurrentToken();
    }
  }
  function C7(t10, e10) {
    return e10 !== null ? e10 : "failed predicate: {" + t10 + "}?";
  }
  class v7 extends y1 {
    constructor(e10) {
      super(), e10 = e10 || true, this.exactOnly = e10;
    }
    reportAmbiguity(e10, n10, r10, s10, i10, o10, l10) {
      if (this.exactOnly && !i10)
        return;
      const a10 = "reportAmbiguity d=" + this.getDecisionDescription(e10, n10) + ": ambigAlts=" + this.getConflictingAlts(o10, l10) + ", input='" + e10.getTokenStream().getText(new Be$1(r10, s10)) + "'";
      e10.notifyErrorListeners(a10);
    }
    reportAttemptingFullContext(e10, n10, r10, s10, i10, o10) {
      const l10 = "reportAttemptingFullContext d=" + this.getDecisionDescription(e10, n10) + ", input='" + e10.getTokenStream().getText(new Be$1(r10, s10)) + "'";
      e10.notifyErrorListeners(l10);
    }
    reportContextSensitivity(e10, n10, r10, s10, i10, o10) {
      const l10 = "reportContextSensitivity d=" + this.getDecisionDescription(e10, n10) + ", input='" + e10.getTokenStream().getText(new Be$1(r10, s10)) + "'";
      e10.notifyErrorListeners(l10);
    }
    getDecisionDescription(e10, n10) {
      const r10 = n10.decision, s10 = n10.atnStartState.ruleIndex, i10 = e10.ruleNames;
      if (s10 < 0 || s10 >= i10.length)
        return "" + r10;
      const o10 = i10[s10] || null;
      return o10 === null || o10.length === 0 ? "" + r10 : `${r10} (${o10})`;
    }
    getConflictingAlts(e10, n10) {
      if (e10 !== null)
        return e10;
      const r10 = new Tn();
      for (let s10 = 0; s10 < n10.items.length; s10++)
        r10.add(n10.items[s10].alt);
      return `{${r10.values().join(", ")}}`;
    }
  }
  class ma extends Error {
    constructor() {
      super(), Error.captureStackTrace(this, ma);
    }
  }
  class b7 {
    reset(e10) {
    }
    recoverInline(e10) {
    }
    recover(e10, n10) {
    }
    sync(e10) {
    }
    inErrorRecoveryMode(e10) {
    }
    reportError(e10) {
    }
  }
  class xa extends b7 {
    constructor() {
      super(), this.errorRecoveryMode = false, this.lastErrorIndex = -1, this.lastErrorStates = null, this.nextTokensContext = null, this.nextTokenState = 0;
    }
    reset(e10) {
      this.endErrorCondition(e10);
    }
    beginErrorCondition(e10) {
      this.errorRecoveryMode = true;
    }
    inErrorRecoveryMode(e10) {
      return this.errorRecoveryMode;
    }
    endErrorCondition(e10) {
      this.errorRecoveryMode = false, this.lastErrorStates = null, this.lastErrorIndex = -1;
    }
    reportMatch(e10) {
      this.endErrorCondition(e10);
    }
    reportError(e10, n10) {
      this.inErrorRecoveryMode(e10) || (this.beginErrorCondition(e10), n10 instanceof pa ? this.reportNoViableAlternative(e10, n10) : n10 instanceof s0 ? this.reportInputMismatch(e10, n10) : n10 instanceof n4 ? this.reportFailedPredicate(e10, n10) : (console.log("unknown recognition error type: " + n10.constructor.name), console.log(n10.stack), e10.notifyErrorListeners(n10.getOffendingToken(), n10.getMessage(), n10)));
    }
    recover(e10, n10) {
      this.lastErrorIndex === e10.getInputStream().index && this.lastErrorStates !== null && this.lastErrorStates.indexOf(e10.state) >= 0 && e10.consume(), this.lastErrorIndex = e10._input.index, this.lastErrorStates === null && (this.lastErrorStates = []), this.lastErrorStates.push(e10.state);
      const r10 = this.getErrorRecoverySet(e10);
      this.consumeUntil(e10, r10);
    }
    sync(e10) {
      if (this.inErrorRecoveryMode(e10))
        return;
      const n10 = e10._interp.atn.states[e10.state], r10 = e10.getTokenStream().LA(1), s10 = e10.atn.nextTokens(n10);
      if (s10.contains(r10)) {
        this.nextTokensContext = null, this.nextTokenState = oe$1.INVALID_STATE_NUMBER;
        return;
      } else if (s10.contains(B.EPSILON)) {
        this.nextTokensContext === null && (this.nextTokensContext = e10._ctx, this.nextTokensState = e10._stateNumber);
        return;
      }
      switch (n10.stateType) {
        case oe$1.BLOCK_START:
        case oe$1.STAR_BLOCK_START:
        case oe$1.PLUS_BLOCK_START:
        case oe$1.STAR_LOOP_ENTRY:
          if (this.singleTokenDeletion(e10) !== null)
            return;
          throw new s0(e10);
        case oe$1.PLUS_LOOP_BACK:
        case oe$1.STAR_LOOP_BACK:
          {
            this.reportUnwantedToken(e10);
            const i10 = new cn$1();
            i10.addSet(e10.getExpectedTokens());
            const o10 = i10.addSet(this.getErrorRecoverySet(e10));
            this.consumeUntil(e10, o10);
          }
          break;
      }
    }
    reportNoViableAlternative(e10, n10) {
      const r10 = e10.getTokenStream();
      let s10;
      r10 !== null ? n10.startToken.type === B.EOF ? s10 = "<EOF>" : s10 = r10.getText(new Be$1(n10.startToken.tokenIndex, n10.offendingToken.tokenIndex)) : s10 = "<unknown input>";
      const i10 = "no viable alternative at input " + this.escapeWSAndQuote(s10);
      e10.notifyErrorListeners(i10, n10.offendingToken, n10);
    }
    reportInputMismatch(e10, n10) {
      const r10 = "mismatched input " + this.getTokenErrorDisplay(n10.offendingToken) + " expecting " + n10.getExpectedTokens().toString(e10.literalNames, e10.symbolicNames);
      e10.notifyErrorListeners(r10, n10.offendingToken, n10);
    }
    reportFailedPredicate(e10, n10) {
      const s10 = "rule " + e10.ruleNames[e10._ctx.ruleIndex] + " " + n10.message;
      e10.notifyErrorListeners(s10, n10.offendingToken, n10);
    }
    reportUnwantedToken(e10) {
      if (this.inErrorRecoveryMode(e10))
        return;
      this.beginErrorCondition(e10);
      const n10 = e10.getCurrentToken(), r10 = this.getTokenErrorDisplay(n10), s10 = this.getExpectedTokens(e10), i10 = "extraneous input " + r10 + " expecting " + s10.toString(e10.literalNames, e10.symbolicNames);
      e10.notifyErrorListeners(i10, n10, null);
    }
    reportMissingToken(e10) {
      if (this.inErrorRecoveryMode(e10))
        return;
      this.beginErrorCondition(e10);
      const n10 = e10.getCurrentToken(), s10 = "missing " + this.getExpectedTokens(e10).toString(e10.literalNames, e10.symbolicNames) + " at " + this.getTokenErrorDisplay(n10);
      e10.notifyErrorListeners(s10, n10, null);
    }
    recoverInline(e10) {
      const n10 = this.singleTokenDeletion(e10);
      if (n10 !== null)
        return e10.consume(), n10;
      if (this.singleTokenInsertion(e10))
        return this.getMissingSymbol(e10);
      throw new s0(e10);
    }
    singleTokenInsertion(e10) {
      const n10 = e10.getTokenStream().LA(1), r10 = e10._interp.atn, i10 = r10.states[e10.state].transitions[0].target;
      return r10.nextTokens(i10, e10._ctx).contains(n10) ? (this.reportMissingToken(e10), true) : false;
    }
    singleTokenDeletion(e10) {
      const n10 = e10.getTokenStream().LA(2);
      if (this.getExpectedTokens(e10).contains(n10)) {
        this.reportUnwantedToken(e10), e10.consume();
        const s10 = e10.getCurrentToken();
        return this.reportMatch(e10), s10;
      } else
        return null;
    }
    getMissingSymbol(e10) {
      const n10 = e10.getCurrentToken(), s10 = this.getExpectedTokens(e10).first();
      let i10;
      s10 === B.EOF ? i10 = "<missing EOF>" : i10 = "<missing " + e10.literalNames[s10] + ">";
      let o10 = n10;
      const l10 = e10.getTokenStream().LT(-1);
      return o10.type === B.EOF && l10 !== null && (o10 = l10), e10.getTokenFactory().create(
        o10.source,
        s10,
        i10,
        B.DEFAULT_CHANNEL,
        -1,
        -1,
        o10.line,
        o10.column
      );
    }
    getExpectedTokens(e10) {
      return e10.getExpectedTokens();
    }
    getTokenErrorDisplay(e10) {
      if (e10 === null)
        return "<no token>";
      let n10 = e10.text;
      return n10 === null && (e10.type === B.EOF ? n10 = "<EOF>" : n10 = "<" + e10.type + ">"), this.escapeWSAndQuote(n10);
    }
    escapeWSAndQuote(e10) {
      return e10 = e10.replace(/\n/g, "\\n"), e10 = e10.replace(/\r/g, "\\r"), e10 = e10.replace(/\t/g, "\\t"), "'" + e10 + "'";
    }
    getErrorRecoverySet(e10) {
      const n10 = e10._interp.atn;
      let r10 = e10._ctx;
      const s10 = new cn$1();
      for (; r10 !== null && r10.invokingState >= 0; ) {
        const o10 = n10.states[r10.invokingState].transitions[0], l10 = n10.nextTokens(o10.followState);
        s10.addSet(l10), r10 = r10.parentCtx;
      }
      return s10.removeOne(B.EPSILON), s10;
    }
    consumeUntil(e10, n10) {
      let r10 = e10.getTokenStream().LA(1);
      for (; r10 !== B.EOF && !n10.contains(r10); )
        e10.consume(), r10 = e10.getTokenStream().LA(1);
    }
  }
  class w7 extends xa {
    constructor() {
      super();
    }
    recover(e10, n10) {
      let r10 = e10._ctx;
      for (; r10 !== null; )
        r10.exception = n10, r10 = r10.parentCtx;
      throw new ma(n10);
    }
    recoverInline(e10) {
      this.recover(e10, new s0(e10));
    }
    sync(e10) {
    }
  }
  const E7 = {
    RecognitionException: Cr,
    NoViableAltException: pa,
    LexerNoViableAltException: fa,
    InputMismatchException: s0,
    FailedPredicateException: n4,
    DiagnosticErrorListener: v7,
    BailErrorStrategy: w7,
    DefaultErrorStrategy: xa,
    ErrorListener: y1
  };
  class kr {
    constructor(e10, n10) {
      if (this.name = "<empty>", this.strdata = e10, this.decodeToUnicodeCodePoints = n10 || false, this._index = 0, this.data = [], this.decodeToUnicodeCodePoints)
        for (let r10 = 0; r10 < this.strdata.length; ) {
          const s10 = this.strdata.codePointAt(r10);
          this.data.push(s10), r10 += s10 <= 65535 ? 1 : 2;
        }
      else {
        this.data = new Array(this.strdata.length);
        for (let r10 = 0; r10 < this.strdata.length; r10++) {
          const s10 = this.strdata.charCodeAt(r10);
          this.data[r10] = s10;
        }
      }
      this._size = this.data.length;
    }
    reset() {
      this._index = 0;
    }
    consume() {
      if (this._index >= this._size)
        throw "cannot consume EOF";
      this._index += 1;
    }
    LA(e10) {
      if (e10 === 0)
        return 0;
      e10 < 0 && (e10 += 1);
      const n10 = this._index + e10 - 1;
      return n10 < 0 || n10 >= this._size ? B.EOF : this.data[n10];
    }
    LT(e10) {
      return this.LA(e10);
    }
    mark() {
      return -1;
    }
    release(e10) {
    }
    seek(e10) {
      if (e10 <= this._index) {
        this._index = e10;
        return;
      }
      this._index = Math.min(e10, this._size);
    }
    getText(e10, n10) {
      if (n10 >= this._size && (n10 = this._size - 1), e10 >= this._size)
        return "";
      if (this.decodeToUnicodeCodePoints) {
        let r10 = "";
        for (let s10 = e10; s10 <= n10; s10++)
          r10 += String.fromCodePoint(this.data[s10]);
        return r10;
      } else
        return this.strdata.slice(e10, n10 + 1);
    }
    toString() {
      return this.strdata;
    }
    get index() {
      return this._index;
    }
    get size() {
      return this._size;
    }
  }
  const Yo = {}, T7 = {
    fromString: function(t10) {
      return new kr(t10, true);
    },
    fromBlob: function(t10, e10, n10, r10) {
      const s10 = new window.FileReader();
      s10.onload = function(i10) {
        const o10 = new kr(i10.target.result, true);
        n10(o10);
      }, s10.onerror = r10, s10.readAsText(t10, e10);
    },
    fromBuffer: function(t10, e10) {
      return new kr(t10.toString(e10), true);
    },
    fromPath: function(t10, e10, n10) {
      Yo.readFile(t10, e10, function(r10, s10) {
        let i10 = null;
        s10 !== null && (i10 = new kr(s10, true)), n10(r10, i10);
      });
    },
    fromPathSync: function(t10, e10) {
      const n10 = Yo.readFileSync(t10, e10);
      return new kr(n10, true);
    }
  };
  class S7 extends kr {
    constructor(e10, n10) {
      const r10 = Yo.readFileSync(e10, "utf8");
      super(r10, n10), this.fileName = e10;
    }
  }
  class A7 {
  }
  class k7 extends A7 {
    constructor(e10) {
      super(), this.tokenSource = e10, this.tokens = [], this.index = -1, this.fetchedEOF = false;
    }
    mark() {
      return 0;
    }
    release(e10) {
    }
    reset() {
      this.seek(0);
    }
    seek(e10) {
      this.lazyInit(), this.index = this.adjustSeekIndex(e10);
    }
    get(e10) {
      return this.lazyInit(), this.tokens[e10];
    }
    consume() {
      let e10 = false;
      if (this.index >= 0 ? this.fetchedEOF ? e10 = this.index < this.tokens.length - 1 : e10 = this.index < this.tokens.length : e10 = false, !e10 && this.LA(1) === B.EOF)
        throw "cannot consume EOF";
      this.sync(this.index + 1) && (this.index = this.adjustSeekIndex(this.index + 1));
    }
    sync(e10) {
      const n10 = e10 - this.tokens.length + 1;
      return n10 > 0 ? this.fetch(n10) >= n10 : true;
    }
    fetch(e10) {
      if (this.fetchedEOF)
        return 0;
      for (let n10 = 0; n10 < e10; n10++) {
        const r10 = this.tokenSource.nextToken();
        if (r10.tokenIndex = this.tokens.length, this.tokens.push(r10), r10.type === B.EOF)
          return this.fetchedEOF = true, n10 + 1;
      }
      return e10;
    }
    getTokens(e10, n10, r10) {
      if (r10 === void 0 && (r10 = null), e10 < 0 || n10 < 0)
        return null;
      this.lazyInit();
      const s10 = [];
      n10 >= this.tokens.length && (n10 = this.tokens.length - 1);
      for (let i10 = e10; i10 < n10; i10++) {
        const o10 = this.tokens[i10];
        if (o10.type === B.EOF)
          break;
        (r10 === null || r10.contains(o10.type)) && s10.push(o10);
      }
      return s10;
    }
    LA(e10) {
      return this.LT(e10).type;
    }
    LB(e10) {
      return this.index - e10 < 0 ? null : this.tokens[this.index - e10];
    }
    LT(e10) {
      if (this.lazyInit(), e10 === 0)
        return null;
      if (e10 < 0)
        return this.LB(-e10);
      const n10 = this.index + e10 - 1;
      return this.sync(n10), n10 >= this.tokens.length ? this.tokens[this.tokens.length - 1] : this.tokens[n10];
    }
    adjustSeekIndex(e10) {
      return e10;
    }
    lazyInit() {
      this.index === -1 && this.setup();
    }
    setup() {
      this.sync(0), this.index = this.adjustSeekIndex(0);
    }
    setTokenSource(e10) {
      this.tokenSource = e10, this.tokens = [], this.index = -1, this.fetchedEOF = false;
    }
    nextTokenOnChannel(e10, n10) {
      if (this.sync(e10), e10 >= this.tokens.length)
        return -1;
      let r10 = this.tokens[e10];
      for (; r10.channel !== this.channel; ) {
        if (r10.type === B.EOF)
          return -1;
        e10 += 1, this.sync(e10), r10 = this.tokens[e10];
      }
      return e10;
    }
    previousTokenOnChannel(e10, n10) {
      for (; e10 >= 0 && this.tokens[e10].channel !== n10; )
        e10 -= 1;
      return e10;
    }
    getHiddenTokensToRight(e10, n10) {
      if (n10 === void 0 && (n10 = -1), this.lazyInit(), e10 < 0 || e10 >= this.tokens.length)
        throw "" + e10 + " not in 0.." + this.tokens.length - 1;
      const r10 = this.nextTokenOnChannel(e10 + 1, rt.DEFAULT_TOKEN_CHANNEL), s10 = e10 + 1, i10 = r10 === -1 ? this.tokens.length - 1 : r10;
      return this.filterForChannel(s10, i10, n10);
    }
    getHiddenTokensToLeft(e10, n10) {
      if (n10 === void 0 && (n10 = -1), this.lazyInit(), e10 < 0 || e10 >= this.tokens.length)
        throw "" + e10 + " not in 0.." + this.tokens.length - 1;
      const r10 = this.previousTokenOnChannel(e10 - 1, rt.DEFAULT_TOKEN_CHANNEL);
      if (r10 === e10 - 1)
        return null;
      const s10 = r10 + 1, i10 = e10 - 1;
      return this.filterForChannel(s10, i10, n10);
    }
    filterForChannel(e10, n10, r10) {
      const s10 = [];
      for (let i10 = e10; i10 < n10 + 1; i10++) {
        const o10 = this.tokens[i10];
        r10 === -1 ? o10.channel !== rt.DEFAULT_TOKEN_CHANNEL && s10.push(o10) : o10.channel === r10 && s10.push(o10);
      }
      return s10.length === 0 ? null : s10;
    }
    getSourceName() {
      return this.tokenSource.getSourceName();
    }
    getText(e10) {
      this.lazyInit(), this.fill(), e10 == null && (e10 = new Be$1(0, this.tokens.length - 1));
      let n10 = e10.start;
      n10 instanceof B && (n10 = n10.tokenIndex);
      let r10 = e10.stop;
      if (r10 instanceof B && (r10 = r10.tokenIndex), n10 === null || r10 === null || n10 < 0 || r10 < 0)
        return "";
      r10 >= this.tokens.length && (r10 = this.tokens.length - 1);
      let s10 = "";
      for (let i10 = n10; i10 < r10 + 1; i10++) {
        const o10 = this.tokens[i10];
        if (o10.type === B.EOF)
          break;
        s10 = s10 + o10.text;
      }
      return s10;
    }
    fill() {
      for (this.lazyInit(); this.fetch(1e3) === 1e3; )
        ;
    }
  }
  class R7 extends k7 {
    constructor(e10, n10) {
      super(e10), this.channel = n10 === void 0 ? B.DEFAULT_CHANNEL : n10;
    }
    adjustSeekIndex(e10) {
      return this.nextTokenOnChannel(e10, this.channel);
    }
    LB(e10) {
      if (e10 === 0 || this.index - e10 < 0)
        return null;
      let n10 = this.index, r10 = 1;
      for (; r10 <= e10; )
        n10 = this.previousTokenOnChannel(n10 - 1, this.channel), r10 += 1;
      return n10 < 0 ? null : this.tokens[n10];
    }
    LT(e10) {
      if (this.lazyInit(), e10 === 0)
        return null;
      if (e10 < 0)
        return this.LB(-e10);
      let n10 = this.index, r10 = 1;
      for (; r10 < e10; )
        this.sync(n10 + 1) && (n10 = this.nextTokenOnChannel(n10 + 1, this.channel)), r10 += 1;
      return this.tokens[n10];
    }
    getNumberOfOnChannelTokens() {
      let e10 = 0;
      this.fill();
      for (let n10 = 0; n10 < this.tokens.length; n10++) {
        const r10 = this.tokens[n10];
        if (r10.channel === this.channel && (e10 += 1), r10.type === B.EOF)
          break;
      }
      return e10;
    }
  }
  class O7 extends t4 {
    constructor(e10) {
      super(), this.parser = e10;
    }
    enterEveryRule(e10) {
      console.log("enter   " + this.parser.ruleNames[e10.ruleIndex] + ", LT(1)=" + this.parser._input.LT(1).text);
    }
    visitTerminal(e10) {
      console.log("consume " + e10.symbol + " rule " + this.parser.ruleNames[this.parser._ctx.ruleIndex]);
    }
    exitEveryRule(e10) {
      console.log("exit    " + this.parser.ruleNames[e10.ruleIndex] + ", LT(1)=" + this.parser._input.LT(1).text);
    }
  }
  class r4 extends C1 {
    constructor(e10) {
      super(), this._input = null, this._errHandler = new xa(), this._precedenceStack = [], this._precedenceStack.push(0), this._ctx = null, this.buildParseTrees = true, this._tracer = null, this._parseListeners = null, this._syntaxErrors = 0, this.setInputStream(e10);
    }
    reset() {
      this._input !== null && this._input.seek(0), this._errHandler.reset(this), this._ctx = null, this._syntaxErrors = 0, this.setTrace(false), this._precedenceStack = [], this._precedenceStack.push(0), this._interp !== null && this._interp.reset();
    }
    match(e10) {
      let n10 = this.getCurrentToken();
      return n10.type === e10 ? (this._errHandler.reportMatch(this), this.consume()) : (n10 = this._errHandler.recoverInline(this), this.buildParseTrees && n10.tokenIndex === -1 && this._ctx.addErrorNode(n10)), n10;
    }
    matchWildcard() {
      let e10 = this.getCurrentToken();
      return e10.type > 0 ? (this._errHandler.reportMatch(this), this.consume()) : (e10 = this._errHandler.recoverInline(this), this._buildParseTrees && e10.tokenIndex === -1 && this._ctx.addErrorNode(e10)), e10;
    }
    getParseListeners() {
      return this._parseListeners || [];
    }
    addParseListener(e10) {
      if (e10 === null)
        throw "listener";
      this._parseListeners === null && (this._parseListeners = []), this._parseListeners.push(e10);
    }
    removeParseListener(e10) {
      if (this._parseListeners !== null) {
        const n10 = this._parseListeners.indexOf(e10);
        n10 >= 0 && this._parseListeners.splice(n10, 1), this._parseListeners.length === 0 && (this._parseListeners = null);
      }
    }
    removeParseListeners() {
      this._parseListeners = null;
    }
    triggerEnterRuleEvent() {
      if (this._parseListeners !== null) {
        const e10 = this._ctx;
        this._parseListeners.forEach(function(n10) {
          n10.enterEveryRule(e10), e10.enterRule(n10);
        });
      }
    }
    triggerExitRuleEvent() {
      if (this._parseListeners !== null) {
        const e10 = this._ctx;
        this._parseListeners.slice(0).reverse().forEach(function(n10) {
          e10.exitRule(n10), n10.exitEveryRule(e10);
        });
      }
    }
    getTokenFactory() {
      return this._input.tokenSource._factory;
    }
    setTokenFactory(e10) {
      this._input.tokenSource._factory = e10;
    }
    getATNWithBypassAlts() {
      const e10 = this.getSerializedATN();
      if (e10 === null)
        throw "The current parser does not support an ATN with bypass alternatives.";
      let n10 = this.bypassAltsAtnCache[e10];
      if (n10 === null) {
        const r10 = new L0();
        r10.generateRuleBypassTransitions = true, n10 = new Q5(r10).deserialize(e10), this.bypassAltsAtnCache[e10] = n10;
      }
      return n10;
    }
    getInputStream() {
      return this.getTokenStream();
    }
    setInputStream(e10) {
      this.setTokenStream(e10);
    }
    getTokenStream() {
      return this._input;
    }
    setTokenStream(e10) {
      this._input = null, this.reset(), this._input = e10;
    }
    getCurrentToken() {
      return this._input.LT(1);
    }
    notifyErrorListeners(e10, n10, r10) {
      n10 = n10 || null, r10 = r10 || null, n10 === null && (n10 = this.getCurrentToken()), this._syntaxErrors += 1;
      const s10 = n10.line, i10 = n10.column;
      this.getErrorListenerDispatch().syntaxError(this, n10, s10, i10, e10, r10);
    }
    consume() {
      const e10 = this.getCurrentToken();
      e10.type !== B.EOF && this.getInputStream().consume();
      const n10 = this._parseListeners !== null && this._parseListeners.length > 0;
      if (this.buildParseTrees || n10) {
        let r10;
        this._errHandler.inErrorRecoveryMode(this) ? r10 = this._ctx.addErrorNode(e10) : r10 = this._ctx.addTokenNode(e10), r10.invokingState = this.state, n10 && this._parseListeners.forEach(function(s10) {
          r10 instanceof x1 || r10.isErrorNode !== void 0 && r10.isErrorNode() ? s10.visitErrorNode(r10) : r10 instanceof Wn && s10.visitTerminal(r10);
        });
      }
      return e10;
    }
    addContextToParseTree() {
      this._ctx.parentCtx !== null && this._ctx.parentCtx.addChild(this._ctx);
    }
    enterRule(e10, n10, r10) {
      this.state = n10, this._ctx = e10, this._ctx.start = this._input.LT(1), this.buildParseTrees && this.addContextToParseTree(), this.triggerEnterRuleEvent();
    }
    exitRule() {
      this._ctx.stop = this._input.LT(-1), this.triggerExitRuleEvent(), this.state = this._ctx.invokingState, this._ctx = this._ctx.parentCtx;
    }
    enterOuterAlt(e10, n10) {
      e10.setAltNumber(n10), this.buildParseTrees && this._ctx !== e10 && this._ctx.parentCtx !== null && (this._ctx.parentCtx.removeLastChild(), this._ctx.parentCtx.addChild(e10)), this._ctx = e10;
    }
    getPrecedence() {
      return this._precedenceStack.length === 0 ? -1 : this._precedenceStack[this._precedenceStack.length - 1];
    }
    enterRecursionRule(e10, n10, r10, s10) {
      this.state = n10, this._precedenceStack.push(s10), this._ctx = e10, this._ctx.start = this._input.LT(1), this.triggerEnterRuleEvent();
    }
    pushNewRecursionContext(e10, n10, r10) {
      const s10 = this._ctx;
      s10.parentCtx = e10, s10.invokingState = n10, s10.stop = this._input.LT(-1), this._ctx = e10, this._ctx.start = s10.start, this.buildParseTrees && this._ctx.addChild(s10), this.triggerEnterRuleEvent();
    }
    unrollRecursionContexts(e10) {
      this._precedenceStack.pop(), this._ctx.stop = this._input.LT(-1);
      const n10 = this._ctx, r10 = this.getParseListeners();
      if (r10 !== null && r10.length > 0)
        for (; this._ctx !== e10; )
          this.triggerExitRuleEvent(), this._ctx = this._ctx.parentCtx;
      else
        this._ctx = e10;
      n10.parentCtx = e10, this.buildParseTrees && e10 !== null && e10.addChild(n10);
    }
    getInvokingContext(e10) {
      let n10 = this._ctx;
      for (; n10 !== null; ) {
        if (n10.ruleIndex === e10)
          return n10;
        n10 = n10.parentCtx;
      }
      return null;
    }
    precpred(e10, n10) {
      return n10 >= this._precedenceStack[this._precedenceStack.length - 1];
    }
    inContext(e10) {
      return false;
    }
    isExpectedToken(e10) {
      const n10 = this._interp.atn;
      let r10 = this._ctx;
      const s10 = n10.states[this.state];
      let i10 = n10.nextTokens(s10);
      if (i10.contains(e10))
        return true;
      if (!i10.contains(B.EPSILON))
        return false;
      for (; r10 !== null && r10.invokingState >= 0 && i10.contains(B.EPSILON); ) {
        const l10 = n10.states[r10.invokingState].transitions[0];
        if (i10 = n10.nextTokens(l10.followState), i10.contains(e10))
          return true;
        r10 = r10.parentCtx;
      }
      return !!(i10.contains(B.EPSILON) && e10 === B.EOF);
    }
    getExpectedTokens() {
      return this._interp.atn.getExpectedTokens(this.state, this._ctx);
    }
    getExpectedTokensWithinCurrentRule() {
      const e10 = this._interp.atn, n10 = e10.states[this.state];
      return e10.nextTokens(n10);
    }
    getRuleIndex(e10) {
      const n10 = this.getRuleIndexMap()[e10];
      return n10 !== null ? n10 : -1;
    }
    getRuleInvocationStack(e10) {
      e10 = e10 || null, e10 === null && (e10 = this._ctx);
      const n10 = [];
      for (; e10 !== null; ) {
        const r10 = e10.ruleIndex;
        r10 < 0 ? n10.push("n/a") : n10.push(this.ruleNames[r10]), e10 = e10.parentCtx;
      }
      return n10;
    }
    getDFAStrings() {
      return this._interp.decisionToDFA.toString();
    }
    dumpDFA() {
      let e10 = false;
      for (let n10 = 0; n10 < this._interp.decisionToDFA.length; n10++) {
        const r10 = this._interp.decisionToDFA[n10];
        r10.states.length > 0 && (e10 && console.log(), this.printer.println("Decision " + r10.decision + ":"), this.printer.print(r10.toString(this.literalNames, this.symbolicNames)), e10 = true);
      }
    }
    getSourceName() {
      return this._input.sourceName;
    }
    setTrace(e10) {
      e10 ? (this._tracer !== null && this.removeParseListener(this._tracer), this._tracer = new O7(this), this.addParseListener(this._tracer)) : (this.removeParseListener(this._tracer), this._tracer = null);
    }
  }
  r4.bypassAltsAtnCache = {};
  class I7 {
    constructor() {
      this.cache = new F0();
    }
    add(e10) {
      if (e10 === Te.EMPTY)
        return Te.EMPTY;
      const n10 = this.cache.get(e10) || null;
      return n10 !== null ? n10 : (this.cache.set(e10, e10), e10);
    }
    get(e10) {
      return this.cache.get(e10) || null;
    }
    get length() {
      return this.cache.length;
    }
  }
  class s4 extends Wn {
    constructor(e10) {
      super(), this.parentCtx = null, this.symbol = e10;
    }
    getChild(e10) {
      return null;
    }
    getSymbol() {
      return this.symbol;
    }
    getParent() {
      return this.parentCtx;
    }
    getPayload() {
      return this.symbol;
    }
    getSourceInterval() {
      if (this.symbol === null)
        return Be$1.INVALID_INTERVAL;
      const e10 = this.symbol.tokenIndex;
      return new Be$1(e10, e10);
    }
    getChildCount() {
      return 0;
    }
    accept(e10) {
      return e10.visitTerminal(this);
    }
    getText() {
      return this.symbol.text;
    }
    toString() {
      return this.symbol.type === B.EOF ? "<EOF>" : this.symbol.text;
    }
  }
  class k2 extends s4 {
    constructor(e10) {
      super(e10);
    }
    isErrorNode() {
      return true;
    }
    accept(e10) {
      return e10.visitErrorNode(this);
    }
  }
  class i4 extends Cs {
    constructor(e10, n10) {
      e10 = e10 || null, n10 = n10 || null, super(e10, n10), this.ruleIndex = -1, this.children = null, this.start = null, this.stop = null, this.exception = null;
    }
    copyFrom(e10) {
      this.parentCtx = e10.parentCtx, this.invokingState = e10.invokingState, this.children = null, this.start = e10.start, this.stop = e10.stop, e10.children && (this.children = [], e10.children.map(function(n10) {
        n10 instanceof k2 && (this.children.push(n10), n10.parentCtx = this);
      }, this));
    }
    enterRule(e10) {
    }
    exitRule(e10) {
    }
    addChild(e10) {
      return this.children === null && (this.children = []), this.children.push(e10), e10;
    }
    removeLastChild() {
      this.children !== null && this.children.pop();
    }
    addTokenNode(e10) {
      const n10 = new s4(e10);
      return this.addChild(n10), n10.parentCtx = this, n10;
    }
    addErrorNode(e10) {
      const n10 = new k2(e10);
      return this.addChild(n10), n10.parentCtx = this, n10;
    }
    getChild(e10, n10) {
      if (n10 = n10 || null, this.children === null || e10 < 0 || e10 >= this.children.length)
        return null;
      if (n10 === null)
        return this.children[e10];
      for (let r10 = 0; r10 < this.children.length; r10++) {
        const s10 = this.children[r10];
        if (s10 instanceof n10) {
          if (e10 === 0)
            return s10;
          e10 -= 1;
        }
      }
      return null;
    }
    getToken(e10, n10) {
      if (this.children === null || n10 < 0 || n10 >= this.children.length)
        return null;
      for (let r10 = 0; r10 < this.children.length; r10++) {
        const s10 = this.children[r10];
        if (s10 instanceof Wn && s10.symbol.type === e10) {
          if (n10 === 0)
            return s10;
          n10 -= 1;
        }
      }
      return null;
    }
    getTokens(e10) {
      if (this.children === null)
        return [];
      {
        const n10 = [];
        for (let r10 = 0; r10 < this.children.length; r10++) {
          const s10 = this.children[r10];
          s10 instanceof Wn && s10.symbol.type === e10 && n10.push(s10);
        }
        return n10;
      }
    }
    getTypedRuleContext(e10, n10) {
      return this.getChild(n10, e10);
    }
    getTypedRuleContexts(e10) {
      if (this.children === null)
        return [];
      {
        const n10 = [];
        for (let r10 = 0; r10 < this.children.length; r10++) {
          const s10 = this.children[r10];
          s10 instanceof e10 && n10.push(s10);
        }
        return n10;
      }
    }
    getChildCount() {
      return this.children === null ? 0 : this.children.length;
    }
    getSourceInterval() {
      return this.start === null || this.stop === null ? Be$1.INVALID_INTERVAL : new Be$1(this.start.tokenIndex, this.stop.tokenIndex);
    }
  }
  Cs.EMPTY = new i4();
  const M7 = { arrayToString: or }, b = {
    atn: m7,
    dfa: L7,
    tree: y7,
    error: E7,
    Token: B,
    CommonToken: zr,
    CharStreams: T7,
    InputStream: kr,
    FileStream: S7,
    CommonTokenStream: R7,
    Lexer: rt,
    Parser: r4,
    PredictionContextCache: I7,
    ParserRuleContext: i4,
    Interval: Be$1,
    IntervalSet: cn$1,
    LL1Analyzer: vs,
    Utils: M7
  }, N7 = [
    4,
    0,
    65,
    511,
    6,
    -1,
    6,
    -1,
    6,
    -1,
    2,
    0,
    7,
    0,
    2,
    1,
    7,
    1,
    2,
    2,
    7,
    2,
    2,
    3,
    7,
    3,
    2,
    4,
    7,
    4,
    2,
    5,
    7,
    5,
    2,
    6,
    7,
    6,
    2,
    7,
    7,
    7,
    2,
    8,
    7,
    8,
    2,
    9,
    7,
    9,
    2,
    10,
    7,
    10,
    2,
    11,
    7,
    11,
    2,
    12,
    7,
    12,
    2,
    13,
    7,
    13,
    2,
    14,
    7,
    14,
    2,
    15,
    7,
    15,
    2,
    16,
    7,
    16,
    2,
    17,
    7,
    17,
    2,
    18,
    7,
    18,
    2,
    19,
    7,
    19,
    2,
    20,
    7,
    20,
    2,
    21,
    7,
    21,
    2,
    22,
    7,
    22,
    2,
    23,
    7,
    23,
    2,
    24,
    7,
    24,
    2,
    25,
    7,
    25,
    2,
    26,
    7,
    26,
    2,
    27,
    7,
    27,
    2,
    28,
    7,
    28,
    2,
    29,
    7,
    29,
    2,
    30,
    7,
    30,
    2,
    31,
    7,
    31,
    2,
    32,
    7,
    32,
    2,
    33,
    7,
    33,
    2,
    34,
    7,
    34,
    2,
    35,
    7,
    35,
    2,
    36,
    7,
    36,
    2,
    37,
    7,
    37,
    2,
    38,
    7,
    38,
    2,
    39,
    7,
    39,
    2,
    40,
    7,
    40,
    2,
    41,
    7,
    41,
    2,
    42,
    7,
    42,
    2,
    43,
    7,
    43,
    2,
    44,
    7,
    44,
    2,
    45,
    7,
    45,
    2,
    46,
    7,
    46,
    2,
    47,
    7,
    47,
    2,
    48,
    7,
    48,
    2,
    49,
    7,
    49,
    2,
    50,
    7,
    50,
    2,
    51,
    7,
    51,
    2,
    52,
    7,
    52,
    2,
    53,
    7,
    53,
    2,
    54,
    7,
    54,
    2,
    55,
    7,
    55,
    2,
    56,
    7,
    56,
    2,
    57,
    7,
    57,
    2,
    58,
    7,
    58,
    2,
    59,
    7,
    59,
    2,
    60,
    7,
    60,
    2,
    61,
    7,
    61,
    2,
    62,
    7,
    62,
    2,
    63,
    7,
    63,
    2,
    64,
    7,
    64,
    2,
    65,
    7,
    65,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    2,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    1,
    4,
    1,
    4,
    1,
    4,
    1,
    4,
    1,
    4,
    1,
    4,
    1,
    4,
    1,
    4,
    1,
    5,
    1,
    5,
    1,
    5,
    1,
    5,
    1,
    5,
    1,
    5,
    1,
    5,
    1,
    5,
    1,
    6,
    1,
    6,
    1,
    6,
    1,
    6,
    1,
    7,
    1,
    7,
    1,
    7,
    1,
    8,
    1,
    8,
    1,
    8,
    1,
    9,
    1,
    9,
    1,
    9,
    1,
    10,
    1,
    10,
    1,
    11,
    1,
    11,
    4,
    11,
    201,
    8,
    11,
    11,
    11,
    12,
    11,
    202,
    1,
    12,
    1,
    12,
    1,
    12,
    1,
    13,
    1,
    13,
    1,
    13,
    1,
    14,
    1,
    14,
    1,
    14,
    1,
    15,
    1,
    15,
    1,
    15,
    1,
    16,
    1,
    16,
    1,
    17,
    1,
    17,
    1,
    18,
    1,
    18,
    1,
    18,
    1,
    19,
    1,
    19,
    1,
    19,
    1,
    20,
    1,
    20,
    1,
    21,
    1,
    21,
    1,
    22,
    1,
    22,
    1,
    23,
    1,
    23,
    1,
    24,
    1,
    24,
    1,
    25,
    1,
    25,
    1,
    26,
    1,
    26,
    1,
    27,
    1,
    27,
    1,
    28,
    1,
    28,
    1,
    29,
    1,
    29,
    1,
    30,
    1,
    30,
    1,
    31,
    1,
    31,
    1,
    32,
    1,
    32,
    1,
    33,
    1,
    33,
    1,
    34,
    1,
    34,
    1,
    34,
    1,
    34,
    1,
    34,
    1,
    35,
    1,
    35,
    1,
    35,
    1,
    35,
    1,
    35,
    1,
    35,
    1,
    36,
    1,
    36,
    1,
    36,
    1,
    36,
    1,
    36,
    1,
    36,
    1,
    36,
    3,
    36,
    273,
    8,
    36,
    1,
    37,
    1,
    37,
    1,
    37,
    1,
    38,
    1,
    38,
    1,
    38,
    1,
    38,
    1,
    38,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    39,
    3,
    39,
    309,
    8,
    39,
    1,
    40,
    1,
    40,
    1,
    40,
    1,
    40,
    1,
    40,
    1,
    40,
    1,
    40,
    1,
    41,
    1,
    41,
    1,
    41,
    1,
    41,
    1,
    42,
    1,
    42,
    1,
    42,
    1,
    42,
    1,
    43,
    1,
    43,
    1,
    43,
    1,
    43,
    1,
    43,
    1,
    43,
    1,
    44,
    1,
    44,
    1,
    44,
    1,
    44,
    1,
    45,
    1,
    45,
    1,
    45,
    1,
    46,
    1,
    46,
    1,
    46,
    1,
    46,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    49,
    1,
    49,
    1,
    49,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    3,
    50,
    376,
    8,
    50,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    1,
    51,
    3,
    51,
    404,
    8,
    51,
    1,
    52,
    1,
    52,
    5,
    52,
    408,
    8,
    52,
    10,
    52,
    12,
    52,
    411,
    9,
    52,
    1,
    53,
    1,
    53,
    1,
    54,
    1,
    54,
    5,
    54,
    417,
    8,
    54,
    10,
    54,
    12,
    54,
    420,
    9,
    54,
    1,
    55,
    4,
    55,
    423,
    8,
    55,
    11,
    55,
    12,
    55,
    424,
    1,
    56,
    4,
    56,
    428,
    8,
    56,
    11,
    56,
    12,
    56,
    429,
    1,
    56,
    1,
    56,
    5,
    56,
    434,
    8,
    56,
    10,
    56,
    12,
    56,
    437,
    9,
    56,
    1,
    56,
    1,
    56,
    4,
    56,
    441,
    8,
    56,
    11,
    56,
    12,
    56,
    442,
    3,
    56,
    445,
    8,
    56,
    1,
    57,
    1,
    57,
    1,
    57,
    1,
    57,
    5,
    57,
    451,
    8,
    57,
    10,
    57,
    12,
    57,
    454,
    9,
    57,
    1,
    57,
    3,
    57,
    457,
    8,
    57,
    1,
    58,
    1,
    58,
    1,
    58,
    1,
    58,
    1,
    59,
    1,
    59,
    1,
    59,
    1,
    59,
    5,
    59,
    467,
    8,
    59,
    10,
    59,
    12,
    59,
    470,
    9,
    59,
    1,
    59,
    1,
    59,
    1,
    59,
    1,
    59,
    1,
    60,
    1,
    60,
    1,
    61,
    1,
    61,
    5,
    61,
    480,
    8,
    61,
    10,
    61,
    12,
    61,
    483,
    9,
    61,
    1,
    61,
    1,
    61,
    1,
    61,
    1,
    61,
    5,
    61,
    489,
    8,
    61,
    10,
    61,
    12,
    61,
    492,
    9,
    61,
    1,
    62,
    4,
    62,
    495,
    8,
    62,
    11,
    62,
    12,
    62,
    496,
    1,
    63,
    1,
    63,
    1,
    63,
    1,
    63,
    1,
    64,
    4,
    64,
    504,
    8,
    64,
    11,
    64,
    12,
    64,
    505,
    1,
    65,
    1,
    65,
    1,
    65,
    1,
    65,
    1,
    468,
    0,
    66,
    3,
    1,
    5,
    2,
    7,
    3,
    9,
    4,
    11,
    5,
    13,
    6,
    15,
    7,
    17,
    8,
    19,
    9,
    21,
    10,
    23,
    0,
    25,
    11,
    27,
    12,
    29,
    13,
    31,
    14,
    33,
    15,
    35,
    16,
    37,
    17,
    39,
    18,
    41,
    19,
    43,
    20,
    45,
    21,
    47,
    22,
    49,
    23,
    51,
    24,
    53,
    25,
    55,
    26,
    57,
    27,
    59,
    28,
    61,
    29,
    63,
    30,
    65,
    31,
    67,
    32,
    69,
    33,
    71,
    34,
    73,
    35,
    75,
    36,
    77,
    37,
    79,
    38,
    81,
    39,
    83,
    40,
    85,
    41,
    87,
    42,
    89,
    43,
    91,
    44,
    93,
    45,
    95,
    46,
    97,
    47,
    99,
    48,
    101,
    49,
    103,
    50,
    105,
    51,
    107,
    52,
    109,
    53,
    111,
    54,
    113,
    55,
    115,
    56,
    117,
    57,
    119,
    58,
    121,
    59,
    123,
    60,
    125,
    61,
    127,
    62,
    129,
    63,
    131,
    64,
    133,
    65,
    3,
    0,
    1,
    2,
    7,
    2,
    0,
    9,
    9,
    32,
    32,
    3,
    0,
    48,
    57,
    65,
    70,
    97,
    102,
    4,
    0,
    48,
    57,
    65,
    90,
    95,
    95,
    97,
    122,
    3,
    0,
    65,
    90,
    95,
    95,
    97,
    122,
    1,
    0,
    48,
    57,
    3,
    0,
    10,
    10,
    13,
    13,
    34,
    34,
    2,
    0,
    10,
    10,
    13,
    13,
    532,
    0,
    3,
    1,
    0,
    0,
    0,
    0,
    5,
    1,
    0,
    0,
    0,
    0,
    7,
    1,
    0,
    0,
    0,
    0,
    9,
    1,
    0,
    0,
    0,
    0,
    11,
    1,
    0,
    0,
    0,
    0,
    13,
    1,
    0,
    0,
    0,
    0,
    15,
    1,
    0,
    0,
    0,
    0,
    17,
    1,
    0,
    0,
    0,
    0,
    19,
    1,
    0,
    0,
    0,
    0,
    21,
    1,
    0,
    0,
    0,
    0,
    25,
    1,
    0,
    0,
    0,
    0,
    27,
    1,
    0,
    0,
    0,
    0,
    29,
    1,
    0,
    0,
    0,
    0,
    31,
    1,
    0,
    0,
    0,
    0,
    33,
    1,
    0,
    0,
    0,
    0,
    35,
    1,
    0,
    0,
    0,
    0,
    37,
    1,
    0,
    0,
    0,
    0,
    39,
    1,
    0,
    0,
    0,
    0,
    41,
    1,
    0,
    0,
    0,
    0,
    43,
    1,
    0,
    0,
    0,
    0,
    45,
    1,
    0,
    0,
    0,
    0,
    47,
    1,
    0,
    0,
    0,
    0,
    49,
    1,
    0,
    0,
    0,
    0,
    51,
    1,
    0,
    0,
    0,
    0,
    53,
    1,
    0,
    0,
    0,
    0,
    55,
    1,
    0,
    0,
    0,
    0,
    57,
    1,
    0,
    0,
    0,
    0,
    59,
    1,
    0,
    0,
    0,
    0,
    61,
    1,
    0,
    0,
    0,
    0,
    63,
    1,
    0,
    0,
    0,
    0,
    65,
    1,
    0,
    0,
    0,
    0,
    67,
    1,
    0,
    0,
    0,
    0,
    69,
    1,
    0,
    0,
    0,
    0,
    71,
    1,
    0,
    0,
    0,
    0,
    73,
    1,
    0,
    0,
    0,
    0,
    75,
    1,
    0,
    0,
    0,
    0,
    77,
    1,
    0,
    0,
    0,
    0,
    79,
    1,
    0,
    0,
    0,
    0,
    81,
    1,
    0,
    0,
    0,
    0,
    83,
    1,
    0,
    0,
    0,
    0,
    85,
    1,
    0,
    0,
    0,
    0,
    87,
    1,
    0,
    0,
    0,
    0,
    89,
    1,
    0,
    0,
    0,
    0,
    91,
    1,
    0,
    0,
    0,
    0,
    93,
    1,
    0,
    0,
    0,
    0,
    95,
    1,
    0,
    0,
    0,
    0,
    97,
    1,
    0,
    0,
    0,
    0,
    99,
    1,
    0,
    0,
    0,
    0,
    101,
    1,
    0,
    0,
    0,
    0,
    103,
    1,
    0,
    0,
    0,
    0,
    105,
    1,
    0,
    0,
    0,
    0,
    107,
    1,
    0,
    0,
    0,
    0,
    109,
    1,
    0,
    0,
    0,
    0,
    111,
    1,
    0,
    0,
    0,
    0,
    113,
    1,
    0,
    0,
    0,
    0,
    115,
    1,
    0,
    0,
    0,
    0,
    117,
    1,
    0,
    0,
    0,
    0,
    119,
    1,
    0,
    0,
    0,
    0,
    121,
    1,
    0,
    0,
    0,
    0,
    123,
    1,
    0,
    0,
    0,
    0,
    125,
    1,
    0,
    0,
    0,
    1,
    127,
    1,
    0,
    0,
    0,
    1,
    129,
    1,
    0,
    0,
    0,
    2,
    131,
    1,
    0,
    0,
    0,
    2,
    133,
    1,
    0,
    0,
    0,
    3,
    135,
    1,
    0,
    0,
    0,
    5,
    139,
    1,
    0,
    0,
    0,
    7,
    147,
    1,
    0,
    0,
    0,
    9,
    158,
    1,
    0,
    0,
    0,
    11,
    167,
    1,
    0,
    0,
    0,
    13,
    175,
    1,
    0,
    0,
    0,
    15,
    183,
    1,
    0,
    0,
    0,
    17,
    187,
    1,
    0,
    0,
    0,
    19,
    190,
    1,
    0,
    0,
    0,
    21,
    193,
    1,
    0,
    0,
    0,
    23,
    196,
    1,
    0,
    0,
    0,
    25,
    198,
    1,
    0,
    0,
    0,
    27,
    204,
    1,
    0,
    0,
    0,
    29,
    207,
    1,
    0,
    0,
    0,
    31,
    210,
    1,
    0,
    0,
    0,
    33,
    213,
    1,
    0,
    0,
    0,
    35,
    216,
    1,
    0,
    0,
    0,
    37,
    218,
    1,
    0,
    0,
    0,
    39,
    220,
    1,
    0,
    0,
    0,
    41,
    223,
    1,
    0,
    0,
    0,
    43,
    226,
    1,
    0,
    0,
    0,
    45,
    228,
    1,
    0,
    0,
    0,
    47,
    230,
    1,
    0,
    0,
    0,
    49,
    232,
    1,
    0,
    0,
    0,
    51,
    234,
    1,
    0,
    0,
    0,
    53,
    236,
    1,
    0,
    0,
    0,
    55,
    238,
    1,
    0,
    0,
    0,
    57,
    240,
    1,
    0,
    0,
    0,
    59,
    242,
    1,
    0,
    0,
    0,
    61,
    244,
    1,
    0,
    0,
    0,
    63,
    246,
    1,
    0,
    0,
    0,
    65,
    248,
    1,
    0,
    0,
    0,
    67,
    250,
    1,
    0,
    0,
    0,
    69,
    252,
    1,
    0,
    0,
    0,
    71,
    254,
    1,
    0,
    0,
    0,
    73,
    259,
    1,
    0,
    0,
    0,
    75,
    272,
    1,
    0,
    0,
    0,
    77,
    274,
    1,
    0,
    0,
    0,
    79,
    277,
    1,
    0,
    0,
    0,
    81,
    308,
    1,
    0,
    0,
    0,
    83,
    310,
    1,
    0,
    0,
    0,
    85,
    317,
    1,
    0,
    0,
    0,
    87,
    321,
    1,
    0,
    0,
    0,
    89,
    325,
    1,
    0,
    0,
    0,
    91,
    331,
    1,
    0,
    0,
    0,
    93,
    335,
    1,
    0,
    0,
    0,
    95,
    338,
    1,
    0,
    0,
    0,
    97,
    342,
    1,
    0,
    0,
    0,
    99,
    348,
    1,
    0,
    0,
    0,
    101,
    356,
    1,
    0,
    0,
    0,
    103,
    375,
    1,
    0,
    0,
    0,
    105,
    403,
    1,
    0,
    0,
    0,
    107,
    405,
    1,
    0,
    0,
    0,
    109,
    412,
    1,
    0,
    0,
    0,
    111,
    414,
    1,
    0,
    0,
    0,
    113,
    422,
    1,
    0,
    0,
    0,
    115,
    444,
    1,
    0,
    0,
    0,
    117,
    446,
    1,
    0,
    0,
    0,
    119,
    458,
    1,
    0,
    0,
    0,
    121,
    462,
    1,
    0,
    0,
    0,
    123,
    475,
    1,
    0,
    0,
    0,
    125,
    477,
    1,
    0,
    0,
    0,
    127,
    494,
    1,
    0,
    0,
    0,
    129,
    498,
    1,
    0,
    0,
    0,
    131,
    503,
    1,
    0,
    0,
    0,
    133,
    507,
    1,
    0,
    0,
    0,
    135,
    136,
    7,
    0,
    0,
    0,
    136,
    137,
    1,
    0,
    0,
    0,
    137,
    138,
    6,
    0,
    0,
    0,
    138,
    4,
    1,
    0,
    0,
    0,
    139,
    140,
    5,
    99,
    0,
    0,
    140,
    141,
    5,
    111,
    0,
    0,
    141,
    142,
    5,
    110,
    0,
    0,
    142,
    143,
    5,
    115,
    0,
    0,
    143,
    144,
    5,
    116,
    0,
    0,
    144,
    145,
    1,
    0,
    0,
    0,
    145,
    146,
    6,
    1,
    1,
    0,
    146,
    6,
    1,
    0,
    0,
    0,
    147,
    148,
    5,
    114,
    0,
    0,
    148,
    149,
    5,
    101,
    0,
    0,
    149,
    150,
    5,
    97,
    0,
    0,
    150,
    151,
    5,
    100,
    0,
    0,
    151,
    152,
    5,
    111,
    0,
    0,
    152,
    153,
    5,
    110,
    0,
    0,
    153,
    154,
    5,
    108,
    0,
    0,
    154,
    155,
    5,
    121,
    0,
    0,
    155,
    156,
    1,
    0,
    0,
    0,
    156,
    157,
    6,
    2,
    1,
    0,
    157,
    8,
    1,
    0,
    0,
    0,
    158,
    159,
    5,
    115,
    0,
    0,
    159,
    160,
    5,
    116,
    0,
    0,
    160,
    161,
    5,
    97,
    0,
    0,
    161,
    162,
    5,
    116,
    0,
    0,
    162,
    163,
    5,
    105,
    0,
    0,
    163,
    164,
    5,
    99,
    0,
    0,
    164,
    165,
    1,
    0,
    0,
    0,
    165,
    166,
    6,
    3,
    1,
    0,
    166,
    10,
    1,
    0,
    0,
    0,
    167,
    168,
    5,
    97,
    0,
    0,
    168,
    169,
    5,
    119,
    0,
    0,
    169,
    170,
    5,
    97,
    0,
    0,
    170,
    171,
    5,
    105,
    0,
    0,
    171,
    172,
    5,
    116,
    0,
    0,
    172,
    173,
    1,
    0,
    0,
    0,
    173,
    174,
    6,
    4,
    1,
    0,
    174,
    12,
    1,
    0,
    0,
    0,
    175,
    176,
    5,
    116,
    0,
    0,
    176,
    177,
    5,
    105,
    0,
    0,
    177,
    178,
    5,
    116,
    0,
    0,
    178,
    179,
    5,
    108,
    0,
    0,
    179,
    180,
    5,
    101,
    0,
    0,
    180,
    181,
    1,
    0,
    0,
    0,
    181,
    182,
    6,
    5,
    2,
    0,
    182,
    14,
    1,
    0,
    0,
    0,
    183,
    184,
    5,
    58,
    0,
    0,
    184,
    185,
    1,
    0,
    0,
    0,
    185,
    186,
    6,
    6,
    3,
    0,
    186,
    16,
    1,
    0,
    0,
    0,
    187,
    188,
    5,
    60,
    0,
    0,
    188,
    189,
    5,
    60,
    0,
    0,
    189,
    18,
    1,
    0,
    0,
    0,
    190,
    191,
    5,
    62,
    0,
    0,
    191,
    192,
    5,
    62,
    0,
    0,
    192,
    20,
    1,
    0,
    0,
    0,
    193,
    194,
    5,
    45,
    0,
    0,
    194,
    195,
    5,
    62,
    0,
    0,
    195,
    22,
    1,
    0,
    0,
    0,
    196,
    197,
    7,
    1,
    0,
    0,
    197,
    24,
    1,
    0,
    0,
    0,
    198,
    200,
    5,
    35,
    0,
    0,
    199,
    201,
    3,
    23,
    10,
    0,
    200,
    199,
    1,
    0,
    0,
    0,
    201,
    202,
    1,
    0,
    0,
    0,
    202,
    200,
    1,
    0,
    0,
    0,
    202,
    203,
    1,
    0,
    0,
    0,
    203,
    26,
    1,
    0,
    0,
    0,
    204,
    205,
    5,
    124,
    0,
    0,
    205,
    206,
    5,
    124,
    0,
    0,
    206,
    28,
    1,
    0,
    0,
    0,
    207,
    208,
    5,
    38,
    0,
    0,
    208,
    209,
    5,
    38,
    0,
    0,
    209,
    30,
    1,
    0,
    0,
    0,
    210,
    211,
    5,
    61,
    0,
    0,
    211,
    212,
    5,
    61,
    0,
    0,
    212,
    32,
    1,
    0,
    0,
    0,
    213,
    214,
    5,
    33,
    0,
    0,
    214,
    215,
    5,
    61,
    0,
    0,
    215,
    34,
    1,
    0,
    0,
    0,
    216,
    217,
    5,
    62,
    0,
    0,
    217,
    36,
    1,
    0,
    0,
    0,
    218,
    219,
    5,
    60,
    0,
    0,
    219,
    38,
    1,
    0,
    0,
    0,
    220,
    221,
    5,
    62,
    0,
    0,
    221,
    222,
    5,
    61,
    0,
    0,
    222,
    40,
    1,
    0,
    0,
    0,
    223,
    224,
    5,
    60,
    0,
    0,
    224,
    225,
    5,
    61,
    0,
    0,
    225,
    42,
    1,
    0,
    0,
    0,
    226,
    227,
    5,
    43,
    0,
    0,
    227,
    44,
    1,
    0,
    0,
    0,
    228,
    229,
    5,
    45,
    0,
    0,
    229,
    46,
    1,
    0,
    0,
    0,
    230,
    231,
    5,
    42,
    0,
    0,
    231,
    48,
    1,
    0,
    0,
    0,
    232,
    233,
    5,
    47,
    0,
    0,
    233,
    50,
    1,
    0,
    0,
    0,
    234,
    235,
    5,
    37,
    0,
    0,
    235,
    52,
    1,
    0,
    0,
    0,
    236,
    237,
    5,
    94,
    0,
    0,
    237,
    54,
    1,
    0,
    0,
    0,
    238,
    239,
    5,
    33,
    0,
    0,
    239,
    56,
    1,
    0,
    0,
    0,
    240,
    241,
    5,
    59,
    0,
    0,
    241,
    58,
    1,
    0,
    0,
    0,
    242,
    243,
    5,
    44,
    0,
    0,
    243,
    60,
    1,
    0,
    0,
    0,
    244,
    245,
    5,
    61,
    0,
    0,
    245,
    62,
    1,
    0,
    0,
    0,
    246,
    247,
    5,
    40,
    0,
    0,
    247,
    64,
    1,
    0,
    0,
    0,
    248,
    249,
    5,
    41,
    0,
    0,
    249,
    66,
    1,
    0,
    0,
    0,
    250,
    251,
    5,
    123,
    0,
    0,
    251,
    68,
    1,
    0,
    0,
    0,
    252,
    253,
    5,
    125,
    0,
    0,
    253,
    70,
    1,
    0,
    0,
    0,
    254,
    255,
    5,
    116,
    0,
    0,
    255,
    256,
    5,
    114,
    0,
    0,
    256,
    257,
    5,
    117,
    0,
    0,
    257,
    258,
    5,
    101,
    0,
    0,
    258,
    72,
    1,
    0,
    0,
    0,
    259,
    260,
    5,
    102,
    0,
    0,
    260,
    261,
    5,
    97,
    0,
    0,
    261,
    262,
    5,
    108,
    0,
    0,
    262,
    263,
    5,
    115,
    0,
    0,
    263,
    264,
    5,
    101,
    0,
    0,
    264,
    74,
    1,
    0,
    0,
    0,
    265,
    266,
    5,
    110,
    0,
    0,
    266,
    267,
    5,
    105,
    0,
    0,
    267,
    273,
    5,
    108,
    0,
    0,
    268,
    269,
    5,
    110,
    0,
    0,
    269,
    270,
    5,
    117,
    0,
    0,
    270,
    271,
    5,
    108,
    0,
    0,
    271,
    273,
    5,
    108,
    0,
    0,
    272,
    265,
    1,
    0,
    0,
    0,
    272,
    268,
    1,
    0,
    0,
    0,
    273,
    76,
    1,
    0,
    0,
    0,
    274,
    275,
    5,
    105,
    0,
    0,
    275,
    276,
    5,
    102,
    0,
    0,
    276,
    78,
    1,
    0,
    0,
    0,
    277,
    278,
    5,
    101,
    0,
    0,
    278,
    279,
    5,
    108,
    0,
    0,
    279,
    280,
    5,
    115,
    0,
    0,
    280,
    281,
    5,
    101,
    0,
    0,
    281,
    80,
    1,
    0,
    0,
    0,
    282,
    283,
    5,
    119,
    0,
    0,
    283,
    284,
    5,
    104,
    0,
    0,
    284,
    285,
    5,
    105,
    0,
    0,
    285,
    286,
    5,
    108,
    0,
    0,
    286,
    309,
    5,
    101,
    0,
    0,
    287,
    288,
    5,
    102,
    0,
    0,
    288,
    289,
    5,
    111,
    0,
    0,
    289,
    309,
    5,
    114,
    0,
    0,
    290,
    291,
    5,
    102,
    0,
    0,
    291,
    292,
    5,
    111,
    0,
    0,
    292,
    293,
    5,
    114,
    0,
    0,
    293,
    294,
    5,
    101,
    0,
    0,
    294,
    295,
    5,
    97,
    0,
    0,
    295,
    296,
    5,
    99,
    0,
    0,
    296,
    309,
    5,
    104,
    0,
    0,
    297,
    298,
    5,
    102,
    0,
    0,
    298,
    299,
    5,
    111,
    0,
    0,
    299,
    300,
    5,
    114,
    0,
    0,
    300,
    301,
    5,
    69,
    0,
    0,
    301,
    302,
    5,
    97,
    0,
    0,
    302,
    303,
    5,
    99,
    0,
    0,
    303,
    309,
    5,
    104,
    0,
    0,
    304,
    305,
    5,
    108,
    0,
    0,
    305,
    306,
    5,
    111,
    0,
    0,
    306,
    307,
    5,
    111,
    0,
    0,
    307,
    309,
    5,
    112,
    0,
    0,
    308,
    282,
    1,
    0,
    0,
    0,
    308,
    287,
    1,
    0,
    0,
    0,
    308,
    290,
    1,
    0,
    0,
    0,
    308,
    297,
    1,
    0,
    0,
    0,
    308,
    304,
    1,
    0,
    0,
    0,
    309,
    82,
    1,
    0,
    0,
    0,
    310,
    311,
    5,
    114,
    0,
    0,
    311,
    312,
    5,
    101,
    0,
    0,
    312,
    313,
    5,
    116,
    0,
    0,
    313,
    314,
    5,
    117,
    0,
    0,
    314,
    315,
    5,
    114,
    0,
    0,
    315,
    316,
    5,
    110,
    0,
    0,
    316,
    84,
    1,
    0,
    0,
    0,
    317,
    318,
    5,
    110,
    0,
    0,
    318,
    319,
    5,
    101,
    0,
    0,
    319,
    320,
    5,
    119,
    0,
    0,
    320,
    86,
    1,
    0,
    0,
    0,
    321,
    322,
    5,
    112,
    0,
    0,
    322,
    323,
    5,
    97,
    0,
    0,
    323,
    324,
    5,
    114,
    0,
    0,
    324,
    88,
    1,
    0,
    0,
    0,
    325,
    326,
    5,
    103,
    0,
    0,
    326,
    327,
    5,
    114,
    0,
    0,
    327,
    328,
    5,
    111,
    0,
    0,
    328,
    329,
    5,
    117,
    0,
    0,
    329,
    330,
    5,
    112,
    0,
    0,
    330,
    90,
    1,
    0,
    0,
    0,
    331,
    332,
    5,
    111,
    0,
    0,
    332,
    333,
    5,
    112,
    0,
    0,
    333,
    334,
    5,
    116,
    0,
    0,
    334,
    92,
    1,
    0,
    0,
    0,
    335,
    336,
    5,
    97,
    0,
    0,
    336,
    337,
    5,
    115,
    0,
    0,
    337,
    94,
    1,
    0,
    0,
    0,
    338,
    339,
    5,
    116,
    0,
    0,
    339,
    340,
    5,
    114,
    0,
    0,
    340,
    341,
    5,
    121,
    0,
    0,
    341,
    96,
    1,
    0,
    0,
    0,
    342,
    343,
    5,
    99,
    0,
    0,
    343,
    344,
    5,
    97,
    0,
    0,
    344,
    345,
    5,
    116,
    0,
    0,
    345,
    346,
    5,
    99,
    0,
    0,
    346,
    347,
    5,
    104,
    0,
    0,
    347,
    98,
    1,
    0,
    0,
    0,
    348,
    349,
    5,
    102,
    0,
    0,
    349,
    350,
    5,
    105,
    0,
    0,
    350,
    351,
    5,
    110,
    0,
    0,
    351,
    352,
    5,
    97,
    0,
    0,
    352,
    353,
    5,
    108,
    0,
    0,
    353,
    354,
    5,
    108,
    0,
    0,
    354,
    355,
    5,
    121,
    0,
    0,
    355,
    100,
    1,
    0,
    0,
    0,
    356,
    357,
    5,
    105,
    0,
    0,
    357,
    358,
    5,
    110,
    0,
    0,
    358,
    102,
    1,
    0,
    0,
    0,
    359,
    360,
    5,
    64,
    0,
    0,
    360,
    361,
    5,
    83,
    0,
    0,
    361,
    362,
    5,
    116,
    0,
    0,
    362,
    363,
    5,
    97,
    0,
    0,
    363,
    364,
    5,
    114,
    0,
    0,
    364,
    365,
    5,
    116,
    0,
    0,
    365,
    366,
    5,
    101,
    0,
    0,
    366,
    376,
    5,
    114,
    0,
    0,
    367,
    368,
    5,
    64,
    0,
    0,
    368,
    369,
    5,
    115,
    0,
    0,
    369,
    370,
    5,
    116,
    0,
    0,
    370,
    371,
    5,
    97,
    0,
    0,
    371,
    372,
    5,
    114,
    0,
    0,
    372,
    373,
    5,
    116,
    0,
    0,
    373,
    374,
    5,
    101,
    0,
    0,
    374,
    376,
    5,
    114,
    0,
    0,
    375,
    359,
    1,
    0,
    0,
    0,
    375,
    367,
    1,
    0,
    0,
    0,
    376,
    104,
    1,
    0,
    0,
    0,
    377,
    378,
    5,
    64,
    0,
    0,
    378,
    379,
    5,
    82,
    0,
    0,
    379,
    380,
    5,
    101,
    0,
    0,
    380,
    381,
    5,
    116,
    0,
    0,
    381,
    382,
    5,
    117,
    0,
    0,
    382,
    383,
    5,
    114,
    0,
    0,
    383,
    404,
    5,
    110,
    0,
    0,
    384,
    385,
    5,
    64,
    0,
    0,
    385,
    386,
    5,
    114,
    0,
    0,
    386,
    387,
    5,
    101,
    0,
    0,
    387,
    388,
    5,
    116,
    0,
    0,
    388,
    389,
    5,
    117,
    0,
    0,
    389,
    390,
    5,
    114,
    0,
    0,
    390,
    404,
    5,
    110,
    0,
    0,
    391,
    392,
    5,
    64,
    0,
    0,
    392,
    393,
    5,
    82,
    0,
    0,
    393,
    394,
    5,
    101,
    0,
    0,
    394,
    395,
    5,
    112,
    0,
    0,
    395,
    396,
    5,
    108,
    0,
    0,
    396,
    404,
    5,
    121,
    0,
    0,
    397,
    398,
    5,
    64,
    0,
    0,
    398,
    399,
    5,
    114,
    0,
    0,
    399,
    400,
    5,
    101,
    0,
    0,
    400,
    401,
    5,
    112,
    0,
    0,
    401,
    402,
    5,
    108,
    0,
    0,
    402,
    404,
    5,
    121,
    0,
    0,
    403,
    377,
    1,
    0,
    0,
    0,
    403,
    384,
    1,
    0,
    0,
    0,
    403,
    391,
    1,
    0,
    0,
    0,
    403,
    397,
    1,
    0,
    0,
    0,
    404,
    106,
    1,
    0,
    0,
    0,
    405,
    409,
    5,
    64,
    0,
    0,
    406,
    408,
    7,
    2,
    0,
    0,
    407,
    406,
    1,
    0,
    0,
    0,
    408,
    411,
    1,
    0,
    0,
    0,
    409,
    407,
    1,
    0,
    0,
    0,
    409,
    410,
    1,
    0,
    0,
    0,
    410,
    108,
    1,
    0,
    0,
    0,
    411,
    409,
    1,
    0,
    0,
    0,
    412,
    413,
    5,
    46,
    0,
    0,
    413,
    110,
    1,
    0,
    0,
    0,
    414,
    418,
    7,
    3,
    0,
    0,
    415,
    417,
    7,
    2,
    0,
    0,
    416,
    415,
    1,
    0,
    0,
    0,
    417,
    420,
    1,
    0,
    0,
    0,
    418,
    416,
    1,
    0,
    0,
    0,
    418,
    419,
    1,
    0,
    0,
    0,
    419,
    112,
    1,
    0,
    0,
    0,
    420,
    418,
    1,
    0,
    0,
    0,
    421,
    423,
    7,
    4,
    0,
    0,
    422,
    421,
    1,
    0,
    0,
    0,
    423,
    424,
    1,
    0,
    0,
    0,
    424,
    422,
    1,
    0,
    0,
    0,
    424,
    425,
    1,
    0,
    0,
    0,
    425,
    114,
    1,
    0,
    0,
    0,
    426,
    428,
    7,
    4,
    0,
    0,
    427,
    426,
    1,
    0,
    0,
    0,
    428,
    429,
    1,
    0,
    0,
    0,
    429,
    427,
    1,
    0,
    0,
    0,
    429,
    430,
    1,
    0,
    0,
    0,
    430,
    431,
    1,
    0,
    0,
    0,
    431,
    435,
    5,
    46,
    0,
    0,
    432,
    434,
    7,
    4,
    0,
    0,
    433,
    432,
    1,
    0,
    0,
    0,
    434,
    437,
    1,
    0,
    0,
    0,
    435,
    433,
    1,
    0,
    0,
    0,
    435,
    436,
    1,
    0,
    0,
    0,
    436,
    445,
    1,
    0,
    0,
    0,
    437,
    435,
    1,
    0,
    0,
    0,
    438,
    440,
    5,
    46,
    0,
    0,
    439,
    441,
    7,
    4,
    0,
    0,
    440,
    439,
    1,
    0,
    0,
    0,
    441,
    442,
    1,
    0,
    0,
    0,
    442,
    440,
    1,
    0,
    0,
    0,
    442,
    443,
    1,
    0,
    0,
    0,
    443,
    445,
    1,
    0,
    0,
    0,
    444,
    427,
    1,
    0,
    0,
    0,
    444,
    438,
    1,
    0,
    0,
    0,
    445,
    116,
    1,
    0,
    0,
    0,
    446,
    452,
    5,
    34,
    0,
    0,
    447,
    451,
    8,
    5,
    0,
    0,
    448,
    449,
    5,
    34,
    0,
    0,
    449,
    451,
    5,
    34,
    0,
    0,
    450,
    447,
    1,
    0,
    0,
    0,
    450,
    448,
    1,
    0,
    0,
    0,
    451,
    454,
    1,
    0,
    0,
    0,
    452,
    450,
    1,
    0,
    0,
    0,
    452,
    453,
    1,
    0,
    0,
    0,
    453,
    456,
    1,
    0,
    0,
    0,
    454,
    452,
    1,
    0,
    0,
    0,
    455,
    457,
    7,
    5,
    0,
    0,
    456,
    455,
    1,
    0,
    0,
    0,
    456,
    457,
    1,
    0,
    0,
    0,
    457,
    118,
    1,
    0,
    0,
    0,
    458,
    459,
    7,
    6,
    0,
    0,
    459,
    460,
    1,
    0,
    0,
    0,
    460,
    461,
    6,
    58,
    0,
    0,
    461,
    120,
    1,
    0,
    0,
    0,
    462,
    463,
    5,
    47,
    0,
    0,
    463,
    464,
    5,
    47,
    0,
    0,
    464,
    468,
    1,
    0,
    0,
    0,
    465,
    467,
    9,
    0,
    0,
    0,
    466,
    465,
    1,
    0,
    0,
    0,
    467,
    470,
    1,
    0,
    0,
    0,
    468,
    469,
    1,
    0,
    0,
    0,
    468,
    466,
    1,
    0,
    0,
    0,
    469,
    471,
    1,
    0,
    0,
    0,
    470,
    468,
    1,
    0,
    0,
    0,
    471,
    472,
    5,
    10,
    0,
    0,
    472,
    473,
    1,
    0,
    0,
    0,
    473,
    474,
    6,
    59,
    4,
    0,
    474,
    122,
    1,
    0,
    0,
    0,
    475,
    476,
    9,
    0,
    0,
    0,
    476,
    124,
    1,
    0,
    0,
    0,
    477,
    481,
    4,
    61,
    0,
    0,
    478,
    480,
    3,
    3,
    0,
    0,
    479,
    478,
    1,
    0,
    0,
    0,
    480,
    483,
    1,
    0,
    0,
    0,
    481,
    479,
    1,
    0,
    0,
    0,
    481,
    482,
    1,
    0,
    0,
    0,
    482,
    484,
    1,
    0,
    0,
    0,
    483,
    481,
    1,
    0,
    0,
    0,
    484,
    485,
    5,
    61,
    0,
    0,
    485,
    486,
    5,
    61,
    0,
    0,
    486,
    490,
    1,
    0,
    0,
    0,
    487,
    489,
    8,
    6,
    0,
    0,
    488,
    487,
    1,
    0,
    0,
    0,
    489,
    492,
    1,
    0,
    0,
    0,
    490,
    488,
    1,
    0,
    0,
    0,
    490,
    491,
    1,
    0,
    0,
    0,
    491,
    126,
    1,
    0,
    0,
    0,
    492,
    490,
    1,
    0,
    0,
    0,
    493,
    495,
    8,
    6,
    0,
    0,
    494,
    493,
    1,
    0,
    0,
    0,
    495,
    496,
    1,
    0,
    0,
    0,
    496,
    494,
    1,
    0,
    0,
    0,
    496,
    497,
    1,
    0,
    0,
    0,
    497,
    128,
    1,
    0,
    0,
    0,
    498,
    499,
    7,
    6,
    0,
    0,
    499,
    500,
    1,
    0,
    0,
    0,
    500,
    501,
    6,
    63,
    5,
    0,
    501,
    130,
    1,
    0,
    0,
    0,
    502,
    504,
    8,
    6,
    0,
    0,
    503,
    502,
    1,
    0,
    0,
    0,
    504,
    505,
    1,
    0,
    0,
    0,
    505,
    503,
    1,
    0,
    0,
    0,
    505,
    506,
    1,
    0,
    0,
    0,
    506,
    132,
    1,
    0,
    0,
    0,
    507,
    508,
    7,
    6,
    0,
    0,
    508,
    509,
    1,
    0,
    0,
    0,
    509,
    510,
    6,
    65,
    5,
    0,
    510,
    134,
    1,
    0,
    0,
    0,
    23,
    0,
    1,
    2,
    202,
    272,
    308,
    375,
    403,
    409,
    418,
    424,
    429,
    435,
    442,
    444,
    450,
    452,
    456,
    468,
    481,
    490,
    496,
    505,
    6,
    0,
    1,
    0,
    0,
    3,
    0,
    5,
    2,
    0,
    5,
    1,
    0,
    0,
    2,
    0,
    4,
    0,
    0
  ], Xo = new b.atn.ATNDeserializer().deserialize(N7), P7 = Xo.decisionToState.map((t10, e10) => new b.dfa.DFA(t10, e10));
  let Z$1 = class Z extends b.Lexer {
    constructor(e10) {
      super(e10), this._interp = new b.atn.LexerATNSimulator(this, Xo, P7, new b.PredictionContextCache());
    }
    get atn() {
      return Xo;
    }
  };
  W$1(Z$1, "grammarFileName", "sequenceLexer.g4"), W$1(Z$1, "channelNames", [
    "DEFAULT_TOKEN_CHANNEL",
    "HIDDEN",
    "COMMENT_CHANNEL",
    "MODIFIER_CHANNEL"
  ]), W$1(Z$1, "modeNames", ["DEFAULT_MODE", "EVENT", "TITLE_MODE"]), W$1(Z$1, "literalNames", [
    null,
    null,
    "'const'",
    "'readonly'",
    "'static'",
    "'await'",
    "'title'",
    "':'",
    "'<<'",
    "'>>'",
    "'->'",
    null,
    "'||'",
    "'&&'",
    "'=='",
    "'!='",
    "'>'",
    "'<'",
    "'>='",
    "'<='",
    "'+'",
    "'-'",
    "'*'",
    "'/'",
    "'%'",
    "'^'",
    "'!'",
    "';'",
    "','",
    "'='",
    "'('",
    "')'",
    "'{'",
    "'}'",
    "'true'",
    "'false'",
    null,
    "'if'",
    "'else'",
    null,
    "'return'",
    "'new'",
    "'par'",
    "'group'",
    "'opt'",
    "'as'",
    "'try'",
    "'catch'",
    "'finally'",
    "'in'",
    null,
    null,
    null,
    "'.'"
  ]), W$1(Z$1, "symbolicNames", [
    null,
    "WS",
    "CONSTANT",
    "READONLY",
    "STATIC",
    "AWAIT",
    "TITLE",
    "COL",
    "SOPEN",
    "SCLOSE",
    "ARROW",
    "COLOR",
    "OR",
    "AND",
    "EQ",
    "NEQ",
    "GT",
    "LT",
    "GTEQ",
    "LTEQ",
    "PLUS",
    "MINUS",
    "MULT",
    "DIV",
    "MOD",
    "POW",
    "NOT",
    "SCOL",
    "COMMA",
    "ASSIGN",
    "OPAR",
    "CPAR",
    "OBRACE",
    "CBRACE",
    "TRUE",
    "FALSE",
    "NIL",
    "IF",
    "ELSE",
    "WHILE",
    "RETURN",
    "NEW",
    "PAR",
    "GROUP",
    "OPT",
    "AS",
    "TRY",
    "CATCH",
    "FINALLY",
    "IN",
    "STARTER_LXR",
    "ANNOTATION_RET",
    "ANNOTATION",
    "DOT",
    "ID",
    "INT",
    "FLOAT",
    "STRING",
    "CR",
    "COMMENT",
    "OTHER",
    "DIVIDER",
    "EVENT_PAYLOAD_LXR",
    "EVENT_END",
    "TITLE_CONTENT",
    "TITLE_END"
  ]), W$1(Z$1, "ruleNames", [
    "WS",
    "CONSTANT",
    "READONLY",
    "STATIC",
    "AWAIT",
    "TITLE",
    "COL",
    "SOPEN",
    "SCLOSE",
    "ARROW",
    "HEX",
    "COLOR",
    "OR",
    "AND",
    "EQ",
    "NEQ",
    "GT",
    "LT",
    "GTEQ",
    "LTEQ",
    "PLUS",
    "MINUS",
    "MULT",
    "DIV",
    "MOD",
    "POW",
    "NOT",
    "SCOL",
    "COMMA",
    "ASSIGN",
    "OPAR",
    "CPAR",
    "OBRACE",
    "CBRACE",
    "TRUE",
    "FALSE",
    "NIL",
    "IF",
    "ELSE",
    "WHILE",
    "RETURN",
    "NEW",
    "PAR",
    "GROUP",
    "OPT",
    "AS",
    "TRY",
    "CATCH",
    "FINALLY",
    "IN",
    "STARTER_LXR",
    "ANNOTATION_RET",
    "ANNOTATION",
    "DOT",
    "ID",
    "INT",
    "FLOAT",
    "STRING",
    "CR",
    "COMMENT",
    "OTHER",
    "DIVIDER",
    "EVENT_PAYLOAD_LXR",
    "EVENT_END",
    "TITLE_CONTENT",
    "TITLE_END"
  ]);
  Z$1.EOF = b.Token.EOF;
  Z$1.WS = 1;
  Z$1.CONSTANT = 2;
  Z$1.READONLY = 3;
  Z$1.STATIC = 4;
  Z$1.AWAIT = 5;
  Z$1.TITLE = 6;
  Z$1.COL = 7;
  Z$1.SOPEN = 8;
  Z$1.SCLOSE = 9;
  Z$1.ARROW = 10;
  Z$1.COLOR = 11;
  Z$1.OR = 12;
  Z$1.AND = 13;
  Z$1.EQ = 14;
  Z$1.NEQ = 15;
  Z$1.GT = 16;
  Z$1.LT = 17;
  Z$1.GTEQ = 18;
  Z$1.LTEQ = 19;
  Z$1.PLUS = 20;
  Z$1.MINUS = 21;
  Z$1.MULT = 22;
  Z$1.DIV = 23;
  Z$1.MOD = 24;
  Z$1.POW = 25;
  Z$1.NOT = 26;
  Z$1.SCOL = 27;
  Z$1.COMMA = 28;
  Z$1.ASSIGN = 29;
  Z$1.OPAR = 30;
  Z$1.CPAR = 31;
  Z$1.OBRACE = 32;
  Z$1.CBRACE = 33;
  Z$1.TRUE = 34;
  Z$1.FALSE = 35;
  Z$1.NIL = 36;
  Z$1.IF = 37;
  Z$1.ELSE = 38;
  Z$1.WHILE = 39;
  Z$1.RETURN = 40;
  Z$1.NEW = 41;
  Z$1.PAR = 42;
  Z$1.GROUP = 43;
  Z$1.OPT = 44;
  Z$1.AS = 45;
  Z$1.TRY = 46;
  Z$1.CATCH = 47;
  Z$1.FINALLY = 48;
  Z$1.IN = 49;
  Z$1.STARTER_LXR = 50;
  Z$1.ANNOTATION_RET = 51;
  Z$1.ANNOTATION = 52;
  Z$1.DOT = 53;
  Z$1.ID = 54;
  Z$1.INT = 55;
  Z$1.FLOAT = 56;
  Z$1.STRING = 57;
  Z$1.CR = 58;
  Z$1.COMMENT = 59;
  Z$1.OTHER = 60;
  Z$1.DIVIDER = 61;
  Z$1.EVENT_PAYLOAD_LXR = 62;
  Z$1.EVENT_END = 63;
  Z$1.TITLE_CONTENT = 64;
  Z$1.TITLE_END = 65;
  Z$1.COMMENT_CHANNEL = 2;
  Z$1.MODIFIER_CHANNEL = 3;
  Z$1.EVENT = 1;
  Z$1.TITLE_MODE = 2;
  Z$1.prototype.sempred = function(t10, e10, n10) {
    switch (e10) {
      case 61:
        return this.DIVIDER_sempred(t10, n10);
      default:
        throw "No registered predicate for:" + e10;
    }
  };
  Z$1.prototype.DIVIDER_sempred = function(t10, e10) {
    switch (e10) {
      case 0:
        return this.column === 0;
      default:
        throw "No predicate with index:" + e10;
    }
  };
  class w extends b.tree.ParseTreeListener {
    enterProg(e10) {
    }
    exitProg(e10) {
    }
    enterTitle(e10) {
    }
    exitTitle(e10) {
    }
    enterHead(e10) {
    }
    exitHead(e10) {
    }
    enterGroup(e10) {
    }
    exitGroup(e10) {
    }
    enterStarterExp(e10) {
    }
    exitStarterExp(e10) {
    }
    enterStarter(e10) {
    }
    exitStarter(e10) {
    }
    enterParticipant(e10) {
    }
    exitParticipant(e10) {
    }
    enterStereotype(e10) {
    }
    exitStereotype(e10) {
    }
    enterLabel(e10) {
    }
    exitLabel(e10) {
    }
    enterParticipantType(e10) {
    }
    exitParticipantType(e10) {
    }
    enterName(e10) {
    }
    exitName(e10) {
    }
    enterWidth(e10) {
    }
    exitWidth(e10) {
    }
    enterBlock(e10) {
    }
    exitBlock(e10) {
    }
    enterRet(e10) {
    }
    exitRet(e10) {
    }
    enterDivider(e10) {
    }
    exitDivider(e10) {
    }
    enterDividerNote(e10) {
    }
    exitDividerNote(e10) {
    }
    enterStat(e10) {
    }
    exitStat(e10) {
    }
    enterPar(e10) {
    }
    exitPar(e10) {
    }
    enterOpt(e10) {
    }
    exitOpt(e10) {
    }
    enterCreation(e10) {
    }
    exitCreation(e10) {
    }
    enterCreationBody(e10) {
    }
    exitCreationBody(e10) {
    }
    enterMessage(e10) {
    }
    exitMessage(e10) {
    }
    enterMessageBody(e10) {
    }
    exitMessageBody(e10) {
    }
    enterFunc(e10) {
    }
    exitFunc(e10) {
    }
    enterFrom(e10) {
    }
    exitFrom(e10) {
    }
    enterTo(e10) {
    }
    exitTo(e10) {
    }
    enterSignature(e10) {
    }
    exitSignature(e10) {
    }
    enterInvocation(e10) {
    }
    exitInvocation(e10) {
    }
    enterAssignment(e10) {
    }
    exitAssignment(e10) {
    }
    enterAsyncMessage(e10) {
    }
    exitAsyncMessage(e10) {
    }
    enterContent(e10) {
    }
    exitContent(e10) {
    }
    enterConstruct(e10) {
    }
    exitConstruct(e10) {
    }
    enterType(e10) {
    }
    exitType(e10) {
    }
    enterAssignee(e10) {
    }
    exitAssignee(e10) {
    }
    enterMethodName(e10) {
    }
    exitMethodName(e10) {
    }
    enterParameters(e10) {
    }
    exitParameters(e10) {
    }
    enterParameter(e10) {
    }
    exitParameter(e10) {
    }
    enterDeclaration(e10) {
    }
    exitDeclaration(e10) {
    }
    enterTcf(e10) {
    }
    exitTcf(e10) {
    }
    enterTryBlock(e10) {
    }
    exitTryBlock(e10) {
    }
    enterCatchBlock(e10) {
    }
    exitCatchBlock(e10) {
    }
    enterFinallyBlock(e10) {
    }
    exitFinallyBlock(e10) {
    }
    enterAlt(e10) {
    }
    exitAlt(e10) {
    }
    enterIfBlock(e10) {
    }
    exitIfBlock(e10) {
    }
    enterElseIfBlock(e10) {
    }
    exitElseIfBlock(e10) {
    }
    enterElseBlock(e10) {
    }
    exitElseBlock(e10) {
    }
    enterBraceBlock(e10) {
    }
    exitBraceBlock(e10) {
    }
    enterLoop(e10) {
    }
    exitLoop(e10) {
    }
    enterAssignmentExpr(e10) {
    }
    exitAssignmentExpr(e10) {
    }
    enterFuncExpr(e10) {
    }
    exitFuncExpr(e10) {
    }
    enterAtomExpr(e10) {
    }
    exitAtomExpr(e10) {
    }
    enterOrExpr(e10) {
    }
    exitOrExpr(e10) {
    }
    enterAdditiveExpr(e10) {
    }
    exitAdditiveExpr(e10) {
    }
    enterRelationalExpr(e10) {
    }
    exitRelationalExpr(e10) {
    }
    enterPlusExpr(e10) {
    }
    exitPlusExpr(e10) {
    }
    enterNotExpr(e10) {
    }
    exitNotExpr(e10) {
    }
    enterUnaryMinusExpr(e10) {
    }
    exitUnaryMinusExpr(e10) {
    }
    enterCreationExpr(e10) {
    }
    exitCreationExpr(e10) {
    }
    enterParenthesizedExpr(e10) {
    }
    exitParenthesizedExpr(e10) {
    }
    enterMultiplicationExpr(e10) {
    }
    exitMultiplicationExpr(e10) {
    }
    enterEqualityExpr(e10) {
    }
    exitEqualityExpr(e10) {
    }
    enterAndExpr(e10) {
    }
    exitAndExpr(e10) {
    }
    enterNumberAtom(e10) {
    }
    exitNumberAtom(e10) {
    }
    enterBooleanAtom(e10) {
    }
    exitBooleanAtom(e10) {
    }
    enterIdAtom(e10) {
    }
    exitIdAtom(e10) {
    }
    enterStringAtom(e10) {
    }
    exitStringAtom(e10) {
    }
    enterNilAtom(e10) {
    }
    exitNilAtom(e10) {
    }
    enterParExpr(e10) {
    }
    exitParExpr(e10) {
    }
    enterCondition(e10) {
    }
    exitCondition(e10) {
    }
    enterInExpr(e10) {
    }
    exitInExpr(e10) {
    }
  }
  const F7 = [
    4,
    1,
    65,
    552,
    2,
    0,
    7,
    0,
    2,
    1,
    7,
    1,
    2,
    2,
    7,
    2,
    2,
    3,
    7,
    3,
    2,
    4,
    7,
    4,
    2,
    5,
    7,
    5,
    2,
    6,
    7,
    6,
    2,
    7,
    7,
    7,
    2,
    8,
    7,
    8,
    2,
    9,
    7,
    9,
    2,
    10,
    7,
    10,
    2,
    11,
    7,
    11,
    2,
    12,
    7,
    12,
    2,
    13,
    7,
    13,
    2,
    14,
    7,
    14,
    2,
    15,
    7,
    15,
    2,
    16,
    7,
    16,
    2,
    17,
    7,
    17,
    2,
    18,
    7,
    18,
    2,
    19,
    7,
    19,
    2,
    20,
    7,
    20,
    2,
    21,
    7,
    21,
    2,
    22,
    7,
    22,
    2,
    23,
    7,
    23,
    2,
    24,
    7,
    24,
    2,
    25,
    7,
    25,
    2,
    26,
    7,
    26,
    2,
    27,
    7,
    27,
    2,
    28,
    7,
    28,
    2,
    29,
    7,
    29,
    2,
    30,
    7,
    30,
    2,
    31,
    7,
    31,
    2,
    32,
    7,
    32,
    2,
    33,
    7,
    33,
    2,
    34,
    7,
    34,
    2,
    35,
    7,
    35,
    2,
    36,
    7,
    36,
    2,
    37,
    7,
    37,
    2,
    38,
    7,
    38,
    2,
    39,
    7,
    39,
    2,
    40,
    7,
    40,
    2,
    41,
    7,
    41,
    2,
    42,
    7,
    42,
    2,
    43,
    7,
    43,
    2,
    44,
    7,
    44,
    2,
    45,
    7,
    45,
    2,
    46,
    7,
    46,
    2,
    47,
    7,
    47,
    2,
    48,
    7,
    48,
    2,
    49,
    7,
    49,
    2,
    50,
    7,
    50,
    2,
    51,
    7,
    51,
    2,
    52,
    7,
    52,
    1,
    0,
    3,
    0,
    108,
    8,
    0,
    1,
    0,
    1,
    0,
    3,
    0,
    112,
    8,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    3,
    0,
    118,
    8,
    0,
    1,
    0,
    3,
    0,
    121,
    8,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    3,
    0,
    126,
    8,
    0,
    1,
    1,
    1,
    1,
    3,
    1,
    130,
    8,
    1,
    1,
    1,
    3,
    1,
    133,
    8,
    1,
    1,
    2,
    1,
    2,
    4,
    2,
    137,
    8,
    2,
    11,
    2,
    12,
    2,
    138,
    1,
    2,
    1,
    2,
    5,
    2,
    143,
    8,
    2,
    10,
    2,
    12,
    2,
    146,
    9,
    2,
    1,
    2,
    3,
    2,
    149,
    8,
    2,
    1,
    3,
    1,
    3,
    3,
    3,
    153,
    8,
    3,
    1,
    3,
    1,
    3,
    5,
    3,
    157,
    8,
    3,
    10,
    3,
    12,
    3,
    160,
    9,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    3,
    3,
    165,
    8,
    3,
    1,
    3,
    1,
    3,
    1,
    3,
    3,
    3,
    170,
    8,
    3,
    3,
    3,
    172,
    8,
    3,
    1,
    4,
    1,
    4,
    1,
    4,
    3,
    4,
    177,
    8,
    4,
    1,
    4,
    3,
    4,
    180,
    8,
    4,
    1,
    4,
    3,
    4,
    183,
    8,
    4,
    1,
    5,
    1,
    5,
    1,
    6,
    3,
    6,
    188,
    8,
    6,
    1,
    6,
    3,
    6,
    191,
    8,
    6,
    1,
    6,
    1,
    6,
    3,
    6,
    195,
    8,
    6,
    1,
    6,
    3,
    6,
    198,
    8,
    6,
    1,
    6,
    3,
    6,
    201,
    8,
    6,
    1,
    6,
    1,
    6,
    3,
    6,
    205,
    8,
    6,
    1,
    7,
    1,
    7,
    1,
    7,
    1,
    7,
    1,
    7,
    1,
    7,
    1,
    7,
    3,
    7,
    214,
    8,
    7,
    1,
    7,
    1,
    7,
    3,
    7,
    218,
    8,
    7,
    3,
    7,
    220,
    8,
    7,
    1,
    8,
    1,
    8,
    1,
    8,
    3,
    8,
    225,
    8,
    8,
    1,
    9,
    1,
    9,
    1,
    10,
    1,
    10,
    1,
    11,
    1,
    11,
    1,
    12,
    4,
    12,
    234,
    8,
    12,
    11,
    12,
    12,
    12,
    235,
    1,
    13,
    1,
    13,
    3,
    13,
    240,
    8,
    13,
    1,
    13,
    3,
    13,
    243,
    8,
    13,
    1,
    13,
    1,
    13,
    1,
    13,
    3,
    13,
    248,
    8,
    13,
    3,
    13,
    250,
    8,
    13,
    1,
    14,
    1,
    14,
    1,
    15,
    1,
    15,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    3,
    16,
    264,
    8,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    1,
    16,
    3,
    16,
    271,
    8,
    16,
    1,
    17,
    1,
    17,
    1,
    17,
    3,
    17,
    276,
    8,
    17,
    1,
    18,
    1,
    18,
    1,
    18,
    3,
    18,
    281,
    8,
    18,
    1,
    19,
    1,
    19,
    1,
    19,
    3,
    19,
    286,
    8,
    19,
    1,
    20,
    3,
    20,
    289,
    8,
    20,
    1,
    20,
    1,
    20,
    1,
    20,
    1,
    20,
    3,
    20,
    295,
    8,
    20,
    1,
    20,
    3,
    20,
    298,
    8,
    20,
    1,
    20,
    3,
    20,
    301,
    8,
    20,
    1,
    20,
    3,
    20,
    304,
    8,
    20,
    1,
    21,
    1,
    21,
    1,
    21,
    3,
    21,
    309,
    8,
    21,
    1,
    22,
    3,
    22,
    312,
    8,
    22,
    1,
    22,
    1,
    22,
    1,
    22,
    3,
    22,
    317,
    8,
    22,
    1,
    22,
    1,
    22,
    1,
    22,
    3,
    22,
    322,
    8,
    22,
    1,
    22,
    1,
    22,
    1,
    22,
    1,
    22,
    1,
    22,
    3,
    22,
    329,
    8,
    22,
    1,
    22,
    1,
    22,
    1,
    22,
    3,
    22,
    334,
    8,
    22,
    1,
    23,
    1,
    23,
    1,
    23,
    5,
    23,
    339,
    8,
    23,
    10,
    23,
    12,
    23,
    342,
    9,
    23,
    1,
    24,
    1,
    24,
    1,
    25,
    1,
    25,
    1,
    26,
    1,
    26,
    3,
    26,
    350,
    8,
    26,
    1,
    27,
    1,
    27,
    3,
    27,
    354,
    8,
    27,
    1,
    27,
    1,
    27,
    1,
    28,
    3,
    28,
    359,
    8,
    28,
    1,
    28,
    1,
    28,
    1,
    28,
    1,
    29,
    1,
    29,
    1,
    29,
    3,
    29,
    367,
    8,
    29,
    1,
    29,
    1,
    29,
    1,
    29,
    1,
    29,
    1,
    29,
    1,
    29,
    1,
    29,
    3,
    29,
    376,
    8,
    29,
    3,
    29,
    378,
    8,
    29,
    1,
    30,
    1,
    30,
    1,
    31,
    1,
    31,
    1,
    32,
    1,
    32,
    1,
    33,
    1,
    33,
    1,
    33,
    1,
    33,
    5,
    33,
    390,
    8,
    33,
    10,
    33,
    12,
    33,
    393,
    9,
    33,
    1,
    33,
    3,
    33,
    396,
    8,
    33,
    1,
    34,
    1,
    34,
    1,
    35,
    1,
    35,
    1,
    35,
    5,
    35,
    403,
    8,
    35,
    10,
    35,
    12,
    35,
    406,
    9,
    35,
    1,
    35,
    3,
    35,
    409,
    8,
    35,
    1,
    36,
    1,
    36,
    3,
    36,
    413,
    8,
    36,
    1,
    37,
    1,
    37,
    1,
    37,
    1,
    38,
    1,
    38,
    5,
    38,
    420,
    8,
    38,
    10,
    38,
    12,
    38,
    423,
    9,
    38,
    1,
    38,
    3,
    38,
    426,
    8,
    38,
    1,
    39,
    1,
    39,
    1,
    39,
    1,
    40,
    1,
    40,
    3,
    40,
    433,
    8,
    40,
    1,
    40,
    1,
    40,
    1,
    41,
    1,
    41,
    1,
    41,
    1,
    42,
    1,
    42,
    5,
    42,
    442,
    8,
    42,
    10,
    42,
    12,
    42,
    445,
    9,
    42,
    1,
    42,
    3,
    42,
    448,
    8,
    42,
    1,
    43,
    1,
    43,
    1,
    43,
    1,
    43,
    1,
    44,
    1,
    44,
    1,
    44,
    1,
    44,
    1,
    44,
    1,
    45,
    1,
    45,
    1,
    45,
    1,
    46,
    1,
    46,
    3,
    46,
    464,
    8,
    46,
    1,
    46,
    1,
    46,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    1,
    47,
    3,
    47,
    475,
    8,
    47,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    3,
    48,
    486,
    8,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    3,
    48,
    497,
    8,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    1,
    48,
    5,
    48,
    520,
    8,
    48,
    10,
    48,
    12,
    48,
    523,
    9,
    48,
    1,
    49,
    1,
    49,
    1,
    49,
    1,
    49,
    1,
    49,
    3,
    49,
    530,
    8,
    49,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    1,
    50,
    3,
    50,
    541,
    8,
    50,
    1,
    51,
    1,
    51,
    1,
    51,
    3,
    51,
    546,
    8,
    51,
    1,
    52,
    1,
    52,
    1,
    52,
    1,
    52,
    1,
    52,
    0,
    1,
    96,
    53,
    0,
    2,
    4,
    6,
    8,
    10,
    12,
    14,
    16,
    18,
    20,
    22,
    24,
    26,
    28,
    30,
    32,
    34,
    36,
    38,
    40,
    42,
    44,
    46,
    48,
    50,
    52,
    54,
    56,
    58,
    60,
    62,
    64,
    66,
    68,
    70,
    72,
    74,
    76,
    78,
    80,
    82,
    84,
    86,
    88,
    90,
    92,
    94,
    96,
    98,
    100,
    102,
    104,
    0,
    10,
    2,
    0,
    54,
    54,
    57,
    57,
    2,
    0,
    8,
    8,
    17,
    17,
    2,
    0,
    9,
    9,
    16,
    16,
    2,
    0,
    10,
    10,
    21,
    21,
    1,
    0,
    22,
    24,
    1,
    0,
    20,
    21,
    1,
    0,
    16,
    19,
    1,
    0,
    14,
    15,
    1,
    0,
    55,
    56,
    1,
    0,
    34,
    35,
    609,
    0,
    125,
    1,
    0,
    0,
    0,
    2,
    127,
    1,
    0,
    0,
    0,
    4,
    148,
    1,
    0,
    0,
    0,
    6,
    171,
    1,
    0,
    0,
    0,
    8,
    182,
    1,
    0,
    0,
    0,
    10,
    184,
    1,
    0,
    0,
    0,
    12,
    204,
    1,
    0,
    0,
    0,
    14,
    219,
    1,
    0,
    0,
    0,
    16,
    224,
    1,
    0,
    0,
    0,
    18,
    226,
    1,
    0,
    0,
    0,
    20,
    228,
    1,
    0,
    0,
    0,
    22,
    230,
    1,
    0,
    0,
    0,
    24,
    233,
    1,
    0,
    0,
    0,
    26,
    249,
    1,
    0,
    0,
    0,
    28,
    251,
    1,
    0,
    0,
    0,
    30,
    253,
    1,
    0,
    0,
    0,
    32,
    270,
    1,
    0,
    0,
    0,
    34,
    275,
    1,
    0,
    0,
    0,
    36,
    280,
    1,
    0,
    0,
    0,
    38,
    282,
    1,
    0,
    0,
    0,
    40,
    303,
    1,
    0,
    0,
    0,
    42,
    305,
    1,
    0,
    0,
    0,
    44,
    333,
    1,
    0,
    0,
    0,
    46,
    335,
    1,
    0,
    0,
    0,
    48,
    343,
    1,
    0,
    0,
    0,
    50,
    345,
    1,
    0,
    0,
    0,
    52,
    347,
    1,
    0,
    0,
    0,
    54,
    351,
    1,
    0,
    0,
    0,
    56,
    358,
    1,
    0,
    0,
    0,
    58,
    377,
    1,
    0,
    0,
    0,
    60,
    379,
    1,
    0,
    0,
    0,
    62,
    381,
    1,
    0,
    0,
    0,
    64,
    383,
    1,
    0,
    0,
    0,
    66,
    395,
    1,
    0,
    0,
    0,
    68,
    397,
    1,
    0,
    0,
    0,
    70,
    399,
    1,
    0,
    0,
    0,
    72,
    412,
    1,
    0,
    0,
    0,
    74,
    414,
    1,
    0,
    0,
    0,
    76,
    417,
    1,
    0,
    0,
    0,
    78,
    427,
    1,
    0,
    0,
    0,
    80,
    430,
    1,
    0,
    0,
    0,
    82,
    436,
    1,
    0,
    0,
    0,
    84,
    439,
    1,
    0,
    0,
    0,
    86,
    449,
    1,
    0,
    0,
    0,
    88,
    453,
    1,
    0,
    0,
    0,
    90,
    458,
    1,
    0,
    0,
    0,
    92,
    461,
    1,
    0,
    0,
    0,
    94,
    474,
    1,
    0,
    0,
    0,
    96,
    496,
    1,
    0,
    0,
    0,
    98,
    529,
    1,
    0,
    0,
    0,
    100,
    540,
    1,
    0,
    0,
    0,
    102,
    545,
    1,
    0,
    0,
    0,
    104,
    547,
    1,
    0,
    0,
    0,
    106,
    108,
    3,
    2,
    1,
    0,
    107,
    106,
    1,
    0,
    0,
    0,
    107,
    108,
    1,
    0,
    0,
    0,
    108,
    109,
    1,
    0,
    0,
    0,
    109,
    126,
    5,
    0,
    0,
    1,
    110,
    112,
    3,
    2,
    1,
    0,
    111,
    110,
    1,
    0,
    0,
    0,
    111,
    112,
    1,
    0,
    0,
    0,
    112,
    113,
    1,
    0,
    0,
    0,
    113,
    114,
    3,
    4,
    2,
    0,
    114,
    115,
    5,
    0,
    0,
    1,
    115,
    126,
    1,
    0,
    0,
    0,
    116,
    118,
    3,
    2,
    1,
    0,
    117,
    116,
    1,
    0,
    0,
    0,
    117,
    118,
    1,
    0,
    0,
    0,
    118,
    120,
    1,
    0,
    0,
    0,
    119,
    121,
    3,
    4,
    2,
    0,
    120,
    119,
    1,
    0,
    0,
    0,
    120,
    121,
    1,
    0,
    0,
    0,
    121,
    122,
    1,
    0,
    0,
    0,
    122,
    123,
    3,
    24,
    12,
    0,
    123,
    124,
    5,
    0,
    0,
    1,
    124,
    126,
    1,
    0,
    0,
    0,
    125,
    107,
    1,
    0,
    0,
    0,
    125,
    111,
    1,
    0,
    0,
    0,
    125,
    117,
    1,
    0,
    0,
    0,
    126,
    1,
    1,
    0,
    0,
    0,
    127,
    129,
    5,
    6,
    0,
    0,
    128,
    130,
    5,
    64,
    0,
    0,
    129,
    128,
    1,
    0,
    0,
    0,
    129,
    130,
    1,
    0,
    0,
    0,
    130,
    132,
    1,
    0,
    0,
    0,
    131,
    133,
    5,
    65,
    0,
    0,
    132,
    131,
    1,
    0,
    0,
    0,
    132,
    133,
    1,
    0,
    0,
    0,
    133,
    3,
    1,
    0,
    0,
    0,
    134,
    137,
    3,
    6,
    3,
    0,
    135,
    137,
    3,
    12,
    6,
    0,
    136,
    134,
    1,
    0,
    0,
    0,
    136,
    135,
    1,
    0,
    0,
    0,
    137,
    138,
    1,
    0,
    0,
    0,
    138,
    136,
    1,
    0,
    0,
    0,
    138,
    139,
    1,
    0,
    0,
    0,
    139,
    149,
    1,
    0,
    0,
    0,
    140,
    143,
    3,
    6,
    3,
    0,
    141,
    143,
    3,
    12,
    6,
    0,
    142,
    140,
    1,
    0,
    0,
    0,
    142,
    141,
    1,
    0,
    0,
    0,
    143,
    146,
    1,
    0,
    0,
    0,
    144,
    142,
    1,
    0,
    0,
    0,
    144,
    145,
    1,
    0,
    0,
    0,
    145,
    147,
    1,
    0,
    0,
    0,
    146,
    144,
    1,
    0,
    0,
    0,
    147,
    149,
    3,
    8,
    4,
    0,
    148,
    136,
    1,
    0,
    0,
    0,
    148,
    144,
    1,
    0,
    0,
    0,
    149,
    5,
    1,
    0,
    0,
    0,
    150,
    152,
    5,
    43,
    0,
    0,
    151,
    153,
    3,
    20,
    10,
    0,
    152,
    151,
    1,
    0,
    0,
    0,
    152,
    153,
    1,
    0,
    0,
    0,
    153,
    154,
    1,
    0,
    0,
    0,
    154,
    158,
    5,
    32,
    0,
    0,
    155,
    157,
    3,
    12,
    6,
    0,
    156,
    155,
    1,
    0,
    0,
    0,
    157,
    160,
    1,
    0,
    0,
    0,
    158,
    156,
    1,
    0,
    0,
    0,
    158,
    159,
    1,
    0,
    0,
    0,
    159,
    161,
    1,
    0,
    0,
    0,
    160,
    158,
    1,
    0,
    0,
    0,
    161,
    172,
    5,
    33,
    0,
    0,
    162,
    164,
    5,
    43,
    0,
    0,
    163,
    165,
    3,
    20,
    10,
    0,
    164,
    163,
    1,
    0,
    0,
    0,
    164,
    165,
    1,
    0,
    0,
    0,
    165,
    166,
    1,
    0,
    0,
    0,
    166,
    172,
    5,
    32,
    0,
    0,
    167,
    169,
    5,
    43,
    0,
    0,
    168,
    170,
    3,
    20,
    10,
    0,
    169,
    168,
    1,
    0,
    0,
    0,
    169,
    170,
    1,
    0,
    0,
    0,
    170,
    172,
    1,
    0,
    0,
    0,
    171,
    150,
    1,
    0,
    0,
    0,
    171,
    162,
    1,
    0,
    0,
    0,
    171,
    167,
    1,
    0,
    0,
    0,
    172,
    7,
    1,
    0,
    0,
    0,
    173,
    179,
    5,
    50,
    0,
    0,
    174,
    176,
    5,
    30,
    0,
    0,
    175,
    177,
    3,
    10,
    5,
    0,
    176,
    175,
    1,
    0,
    0,
    0,
    176,
    177,
    1,
    0,
    0,
    0,
    177,
    178,
    1,
    0,
    0,
    0,
    178,
    180,
    5,
    31,
    0,
    0,
    179,
    174,
    1,
    0,
    0,
    0,
    179,
    180,
    1,
    0,
    0,
    0,
    180,
    183,
    1,
    0,
    0,
    0,
    181,
    183,
    5,
    52,
    0,
    0,
    182,
    173,
    1,
    0,
    0,
    0,
    182,
    181,
    1,
    0,
    0,
    0,
    183,
    9,
    1,
    0,
    0,
    0,
    184,
    185,
    7,
    0,
    0,
    0,
    185,
    11,
    1,
    0,
    0,
    0,
    186,
    188,
    3,
    18,
    9,
    0,
    187,
    186,
    1,
    0,
    0,
    0,
    187,
    188,
    1,
    0,
    0,
    0,
    188,
    190,
    1,
    0,
    0,
    0,
    189,
    191,
    3,
    14,
    7,
    0,
    190,
    189,
    1,
    0,
    0,
    0,
    190,
    191,
    1,
    0,
    0,
    0,
    191,
    192,
    1,
    0,
    0,
    0,
    192,
    194,
    3,
    20,
    10,
    0,
    193,
    195,
    3,
    22,
    11,
    0,
    194,
    193,
    1,
    0,
    0,
    0,
    194,
    195,
    1,
    0,
    0,
    0,
    195,
    197,
    1,
    0,
    0,
    0,
    196,
    198,
    3,
    16,
    8,
    0,
    197,
    196,
    1,
    0,
    0,
    0,
    197,
    198,
    1,
    0,
    0,
    0,
    198,
    200,
    1,
    0,
    0,
    0,
    199,
    201,
    5,
    11,
    0,
    0,
    200,
    199,
    1,
    0,
    0,
    0,
    200,
    201,
    1,
    0,
    0,
    0,
    201,
    205,
    1,
    0,
    0,
    0,
    202,
    205,
    3,
    14,
    7,
    0,
    203,
    205,
    3,
    18,
    9,
    0,
    204,
    187,
    1,
    0,
    0,
    0,
    204,
    202,
    1,
    0,
    0,
    0,
    204,
    203,
    1,
    0,
    0,
    0,
    205,
    13,
    1,
    0,
    0,
    0,
    206,
    207,
    5,
    8,
    0,
    0,
    207,
    208,
    3,
    20,
    10,
    0,
    208,
    209,
    5,
    9,
    0,
    0,
    209,
    220,
    1,
    0,
    0,
    0,
    210,
    211,
    5,
    8,
    0,
    0,
    211,
    213,
    3,
    20,
    10,
    0,
    212,
    214,
    5,
    16,
    0,
    0,
    213,
    212,
    1,
    0,
    0,
    0,
    213,
    214,
    1,
    0,
    0,
    0,
    214,
    220,
    1,
    0,
    0,
    0,
    215,
    217,
    7,
    1,
    0,
    0,
    216,
    218,
    7,
    2,
    0,
    0,
    217,
    216,
    1,
    0,
    0,
    0,
    217,
    218,
    1,
    0,
    0,
    0,
    218,
    220,
    1,
    0,
    0,
    0,
    219,
    206,
    1,
    0,
    0,
    0,
    219,
    210,
    1,
    0,
    0,
    0,
    219,
    215,
    1,
    0,
    0,
    0,
    220,
    15,
    1,
    0,
    0,
    0,
    221,
    222,
    5,
    45,
    0,
    0,
    222,
    225,
    3,
    20,
    10,
    0,
    223,
    225,
    5,
    45,
    0,
    0,
    224,
    221,
    1,
    0,
    0,
    0,
    224,
    223,
    1,
    0,
    0,
    0,
    225,
    17,
    1,
    0,
    0,
    0,
    226,
    227,
    5,
    52,
    0,
    0,
    227,
    19,
    1,
    0,
    0,
    0,
    228,
    229,
    7,
    0,
    0,
    0,
    229,
    21,
    1,
    0,
    0,
    0,
    230,
    231,
    5,
    55,
    0,
    0,
    231,
    23,
    1,
    0,
    0,
    0,
    232,
    234,
    3,
    32,
    16,
    0,
    233,
    232,
    1,
    0,
    0,
    0,
    234,
    235,
    1,
    0,
    0,
    0,
    235,
    233,
    1,
    0,
    0,
    0,
    235,
    236,
    1,
    0,
    0,
    0,
    236,
    25,
    1,
    0,
    0,
    0,
    237,
    239,
    5,
    40,
    0,
    0,
    238,
    240,
    3,
    96,
    48,
    0,
    239,
    238,
    1,
    0,
    0,
    0,
    239,
    240,
    1,
    0,
    0,
    0,
    240,
    242,
    1,
    0,
    0,
    0,
    241,
    243,
    5,
    27,
    0,
    0,
    242,
    241,
    1,
    0,
    0,
    0,
    242,
    243,
    1,
    0,
    0,
    0,
    243,
    250,
    1,
    0,
    0,
    0,
    244,
    245,
    5,
    51,
    0,
    0,
    245,
    247,
    3,
    58,
    29,
    0,
    246,
    248,
    5,
    63,
    0,
    0,
    247,
    246,
    1,
    0,
    0,
    0,
    247,
    248,
    1,
    0,
    0,
    0,
    248,
    250,
    1,
    0,
    0,
    0,
    249,
    237,
    1,
    0,
    0,
    0,
    249,
    244,
    1,
    0,
    0,
    0,
    250,
    27,
    1,
    0,
    0,
    0,
    251,
    252,
    3,
    30,
    15,
    0,
    252,
    29,
    1,
    0,
    0,
    0,
    253,
    254,
    5,
    61,
    0,
    0,
    254,
    31,
    1,
    0,
    0,
    0,
    255,
    271,
    3,
    84,
    42,
    0,
    256,
    271,
    3,
    34,
    17,
    0,
    257,
    271,
    3,
    36,
    18,
    0,
    258,
    271,
    3,
    94,
    47,
    0,
    259,
    271,
    3,
    38,
    19,
    0,
    260,
    271,
    3,
    42,
    21,
    0,
    261,
    263,
    3,
    58,
    29,
    0,
    262,
    264,
    5,
    63,
    0,
    0,
    263,
    262,
    1,
    0,
    0,
    0,
    263,
    264,
    1,
    0,
    0,
    0,
    264,
    271,
    1,
    0,
    0,
    0,
    265,
    271,
    3,
    26,
    13,
    0,
    266,
    271,
    3,
    28,
    14,
    0,
    267,
    271,
    3,
    76,
    38,
    0,
    268,
    269,
    5,
    60,
    0,
    0,
    269,
    271,
    6,
    16,
    -1,
    0,
    270,
    255,
    1,
    0,
    0,
    0,
    270,
    256,
    1,
    0,
    0,
    0,
    270,
    257,
    1,
    0,
    0,
    0,
    270,
    258,
    1,
    0,
    0,
    0,
    270,
    259,
    1,
    0,
    0,
    0,
    270,
    260,
    1,
    0,
    0,
    0,
    270,
    261,
    1,
    0,
    0,
    0,
    270,
    265,
    1,
    0,
    0,
    0,
    270,
    266,
    1,
    0,
    0,
    0,
    270,
    267,
    1,
    0,
    0,
    0,
    270,
    268,
    1,
    0,
    0,
    0,
    271,
    33,
    1,
    0,
    0,
    0,
    272,
    273,
    5,
    42,
    0,
    0,
    273,
    276,
    3,
    92,
    46,
    0,
    274,
    276,
    5,
    42,
    0,
    0,
    275,
    272,
    1,
    0,
    0,
    0,
    275,
    274,
    1,
    0,
    0,
    0,
    276,
    35,
    1,
    0,
    0,
    0,
    277,
    278,
    5,
    44,
    0,
    0,
    278,
    281,
    3,
    92,
    46,
    0,
    279,
    281,
    5,
    44,
    0,
    0,
    280,
    277,
    1,
    0,
    0,
    0,
    280,
    279,
    1,
    0,
    0,
    0,
    281,
    37,
    1,
    0,
    0,
    0,
    282,
    285,
    3,
    40,
    20,
    0,
    283,
    286,
    5,
    27,
    0,
    0,
    284,
    286,
    3,
    92,
    46,
    0,
    285,
    283,
    1,
    0,
    0,
    0,
    285,
    284,
    1,
    0,
    0,
    0,
    285,
    286,
    1,
    0,
    0,
    0,
    286,
    39,
    1,
    0,
    0,
    0,
    287,
    289,
    3,
    56,
    28,
    0,
    288,
    287,
    1,
    0,
    0,
    0,
    288,
    289,
    1,
    0,
    0,
    0,
    289,
    290,
    1,
    0,
    0,
    0,
    290,
    291,
    5,
    41,
    0,
    0,
    291,
    297,
    3,
    62,
    31,
    0,
    292,
    294,
    5,
    30,
    0,
    0,
    293,
    295,
    3,
    70,
    35,
    0,
    294,
    293,
    1,
    0,
    0,
    0,
    294,
    295,
    1,
    0,
    0,
    0,
    295,
    296,
    1,
    0,
    0,
    0,
    296,
    298,
    5,
    31,
    0,
    0,
    297,
    292,
    1,
    0,
    0,
    0,
    297,
    298,
    1,
    0,
    0,
    0,
    298,
    304,
    1,
    0,
    0,
    0,
    299,
    301,
    3,
    56,
    28,
    0,
    300,
    299,
    1,
    0,
    0,
    0,
    300,
    301,
    1,
    0,
    0,
    0,
    301,
    302,
    1,
    0,
    0,
    0,
    302,
    304,
    5,
    41,
    0,
    0,
    303,
    288,
    1,
    0,
    0,
    0,
    303,
    300,
    1,
    0,
    0,
    0,
    304,
    41,
    1,
    0,
    0,
    0,
    305,
    308,
    3,
    44,
    22,
    0,
    306,
    309,
    5,
    27,
    0,
    0,
    307,
    309,
    3,
    92,
    46,
    0,
    308,
    306,
    1,
    0,
    0,
    0,
    308,
    307,
    1,
    0,
    0,
    0,
    308,
    309,
    1,
    0,
    0,
    0,
    309,
    43,
    1,
    0,
    0,
    0,
    310,
    312,
    3,
    56,
    28,
    0,
    311,
    310,
    1,
    0,
    0,
    0,
    311,
    312,
    1,
    0,
    0,
    0,
    312,
    321,
    1,
    0,
    0,
    0,
    313,
    314,
    3,
    48,
    24,
    0,
    314,
    315,
    5,
    10,
    0,
    0,
    315,
    317,
    1,
    0,
    0,
    0,
    316,
    313,
    1,
    0,
    0,
    0,
    316,
    317,
    1,
    0,
    0,
    0,
    317,
    318,
    1,
    0,
    0,
    0,
    318,
    319,
    3,
    50,
    25,
    0,
    319,
    320,
    5,
    53,
    0,
    0,
    320,
    322,
    1,
    0,
    0,
    0,
    321,
    316,
    1,
    0,
    0,
    0,
    321,
    322,
    1,
    0,
    0,
    0,
    322,
    323,
    1,
    0,
    0,
    0,
    323,
    334,
    3,
    46,
    23,
    0,
    324,
    334,
    3,
    56,
    28,
    0,
    325,
    326,
    3,
    48,
    24,
    0,
    326,
    327,
    5,
    10,
    0,
    0,
    327,
    329,
    1,
    0,
    0,
    0,
    328,
    325,
    1,
    0,
    0,
    0,
    328,
    329,
    1,
    0,
    0,
    0,
    329,
    330,
    1,
    0,
    0,
    0,
    330,
    331,
    3,
    50,
    25,
    0,
    331,
    332,
    5,
    53,
    0,
    0,
    332,
    334,
    1,
    0,
    0,
    0,
    333,
    311,
    1,
    0,
    0,
    0,
    333,
    324,
    1,
    0,
    0,
    0,
    333,
    328,
    1,
    0,
    0,
    0,
    334,
    45,
    1,
    0,
    0,
    0,
    335,
    340,
    3,
    52,
    26,
    0,
    336,
    337,
    5,
    53,
    0,
    0,
    337,
    339,
    3,
    52,
    26,
    0,
    338,
    336,
    1,
    0,
    0,
    0,
    339,
    342,
    1,
    0,
    0,
    0,
    340,
    338,
    1,
    0,
    0,
    0,
    340,
    341,
    1,
    0,
    0,
    0,
    341,
    47,
    1,
    0,
    0,
    0,
    342,
    340,
    1,
    0,
    0,
    0,
    343,
    344,
    7,
    0,
    0,
    0,
    344,
    49,
    1,
    0,
    0,
    0,
    345,
    346,
    7,
    0,
    0,
    0,
    346,
    51,
    1,
    0,
    0,
    0,
    347,
    349,
    3,
    68,
    34,
    0,
    348,
    350,
    3,
    54,
    27,
    0,
    349,
    348,
    1,
    0,
    0,
    0,
    349,
    350,
    1,
    0,
    0,
    0,
    350,
    53,
    1,
    0,
    0,
    0,
    351,
    353,
    5,
    30,
    0,
    0,
    352,
    354,
    3,
    70,
    35,
    0,
    353,
    352,
    1,
    0,
    0,
    0,
    353,
    354,
    1,
    0,
    0,
    0,
    354,
    355,
    1,
    0,
    0,
    0,
    355,
    356,
    5,
    31,
    0,
    0,
    356,
    55,
    1,
    0,
    0,
    0,
    357,
    359,
    3,
    64,
    32,
    0,
    358,
    357,
    1,
    0,
    0,
    0,
    358,
    359,
    1,
    0,
    0,
    0,
    359,
    360,
    1,
    0,
    0,
    0,
    360,
    361,
    3,
    66,
    33,
    0,
    361,
    362,
    5,
    29,
    0,
    0,
    362,
    57,
    1,
    0,
    0,
    0,
    363,
    364,
    3,
    48,
    24,
    0,
    364,
    365,
    5,
    10,
    0,
    0,
    365,
    367,
    1,
    0,
    0,
    0,
    366,
    363,
    1,
    0,
    0,
    0,
    366,
    367,
    1,
    0,
    0,
    0,
    367,
    368,
    1,
    0,
    0,
    0,
    368,
    369,
    3,
    50,
    25,
    0,
    369,
    370,
    5,
    7,
    0,
    0,
    370,
    371,
    3,
    60,
    30,
    0,
    371,
    378,
    1,
    0,
    0,
    0,
    372,
    373,
    3,
    48,
    24,
    0,
    373,
    375,
    7,
    3,
    0,
    0,
    374,
    376,
    3,
    50,
    25,
    0,
    375,
    374,
    1,
    0,
    0,
    0,
    375,
    376,
    1,
    0,
    0,
    0,
    376,
    378,
    1,
    0,
    0,
    0,
    377,
    366,
    1,
    0,
    0,
    0,
    377,
    372,
    1,
    0,
    0,
    0,
    378,
    59,
    1,
    0,
    0,
    0,
    379,
    380,
    5,
    62,
    0,
    0,
    380,
    61,
    1,
    0,
    0,
    0,
    381,
    382,
    7,
    0,
    0,
    0,
    382,
    63,
    1,
    0,
    0,
    0,
    383,
    384,
    7,
    0,
    0,
    0,
    384,
    65,
    1,
    0,
    0,
    0,
    385,
    396,
    3,
    98,
    49,
    0,
    386,
    391,
    5,
    54,
    0,
    0,
    387,
    388,
    5,
    28,
    0,
    0,
    388,
    390,
    5,
    54,
    0,
    0,
    389,
    387,
    1,
    0,
    0,
    0,
    390,
    393,
    1,
    0,
    0,
    0,
    391,
    389,
    1,
    0,
    0,
    0,
    391,
    392,
    1,
    0,
    0,
    0,
    392,
    396,
    1,
    0,
    0,
    0,
    393,
    391,
    1,
    0,
    0,
    0,
    394,
    396,
    5,
    57,
    0,
    0,
    395,
    385,
    1,
    0,
    0,
    0,
    395,
    386,
    1,
    0,
    0,
    0,
    395,
    394,
    1,
    0,
    0,
    0,
    396,
    67,
    1,
    0,
    0,
    0,
    397,
    398,
    7,
    0,
    0,
    0,
    398,
    69,
    1,
    0,
    0,
    0,
    399,
    404,
    3,
    72,
    36,
    0,
    400,
    401,
    5,
    28,
    0,
    0,
    401,
    403,
    3,
    72,
    36,
    0,
    402,
    400,
    1,
    0,
    0,
    0,
    403,
    406,
    1,
    0,
    0,
    0,
    404,
    402,
    1,
    0,
    0,
    0,
    404,
    405,
    1,
    0,
    0,
    0,
    405,
    408,
    1,
    0,
    0,
    0,
    406,
    404,
    1,
    0,
    0,
    0,
    407,
    409,
    5,
    28,
    0,
    0,
    408,
    407,
    1,
    0,
    0,
    0,
    408,
    409,
    1,
    0,
    0,
    0,
    409,
    71,
    1,
    0,
    0,
    0,
    410,
    413,
    3,
    74,
    37,
    0,
    411,
    413,
    3,
    96,
    48,
    0,
    412,
    410,
    1,
    0,
    0,
    0,
    412,
    411,
    1,
    0,
    0,
    0,
    413,
    73,
    1,
    0,
    0,
    0,
    414,
    415,
    3,
    64,
    32,
    0,
    415,
    416,
    5,
    54,
    0,
    0,
    416,
    75,
    1,
    0,
    0,
    0,
    417,
    421,
    3,
    78,
    39,
    0,
    418,
    420,
    3,
    80,
    40,
    0,
    419,
    418,
    1,
    0,
    0,
    0,
    420,
    423,
    1,
    0,
    0,
    0,
    421,
    419,
    1,
    0,
    0,
    0,
    421,
    422,
    1,
    0,
    0,
    0,
    422,
    425,
    1,
    0,
    0,
    0,
    423,
    421,
    1,
    0,
    0,
    0,
    424,
    426,
    3,
    82,
    41,
    0,
    425,
    424,
    1,
    0,
    0,
    0,
    425,
    426,
    1,
    0,
    0,
    0,
    426,
    77,
    1,
    0,
    0,
    0,
    427,
    428,
    5,
    46,
    0,
    0,
    428,
    429,
    3,
    92,
    46,
    0,
    429,
    79,
    1,
    0,
    0,
    0,
    430,
    432,
    5,
    47,
    0,
    0,
    431,
    433,
    3,
    54,
    27,
    0,
    432,
    431,
    1,
    0,
    0,
    0,
    432,
    433,
    1,
    0,
    0,
    0,
    433,
    434,
    1,
    0,
    0,
    0,
    434,
    435,
    3,
    92,
    46,
    0,
    435,
    81,
    1,
    0,
    0,
    0,
    436,
    437,
    5,
    48,
    0,
    0,
    437,
    438,
    3,
    92,
    46,
    0,
    438,
    83,
    1,
    0,
    0,
    0,
    439,
    443,
    3,
    86,
    43,
    0,
    440,
    442,
    3,
    88,
    44,
    0,
    441,
    440,
    1,
    0,
    0,
    0,
    442,
    445,
    1,
    0,
    0,
    0,
    443,
    441,
    1,
    0,
    0,
    0,
    443,
    444,
    1,
    0,
    0,
    0,
    444,
    447,
    1,
    0,
    0,
    0,
    445,
    443,
    1,
    0,
    0,
    0,
    446,
    448,
    3,
    90,
    45,
    0,
    447,
    446,
    1,
    0,
    0,
    0,
    447,
    448,
    1,
    0,
    0,
    0,
    448,
    85,
    1,
    0,
    0,
    0,
    449,
    450,
    5,
    37,
    0,
    0,
    450,
    451,
    3,
    100,
    50,
    0,
    451,
    452,
    3,
    92,
    46,
    0,
    452,
    87,
    1,
    0,
    0,
    0,
    453,
    454,
    5,
    38,
    0,
    0,
    454,
    455,
    5,
    37,
    0,
    0,
    455,
    456,
    3,
    100,
    50,
    0,
    456,
    457,
    3,
    92,
    46,
    0,
    457,
    89,
    1,
    0,
    0,
    0,
    458,
    459,
    5,
    38,
    0,
    0,
    459,
    460,
    3,
    92,
    46,
    0,
    460,
    91,
    1,
    0,
    0,
    0,
    461,
    463,
    5,
    32,
    0,
    0,
    462,
    464,
    3,
    24,
    12,
    0,
    463,
    462,
    1,
    0,
    0,
    0,
    463,
    464,
    1,
    0,
    0,
    0,
    464,
    465,
    1,
    0,
    0,
    0,
    465,
    466,
    5,
    33,
    0,
    0,
    466,
    93,
    1,
    0,
    0,
    0,
    467,
    468,
    5,
    39,
    0,
    0,
    468,
    469,
    3,
    100,
    50,
    0,
    469,
    470,
    3,
    92,
    46,
    0,
    470,
    475,
    1,
    0,
    0,
    0,
    471,
    472,
    5,
    39,
    0,
    0,
    472,
    475,
    3,
    100,
    50,
    0,
    473,
    475,
    5,
    39,
    0,
    0,
    474,
    467,
    1,
    0,
    0,
    0,
    474,
    471,
    1,
    0,
    0,
    0,
    474,
    473,
    1,
    0,
    0,
    0,
    475,
    95,
    1,
    0,
    0,
    0,
    476,
    477,
    6,
    48,
    -1,
    0,
    477,
    497,
    3,
    98,
    49,
    0,
    478,
    479,
    5,
    21,
    0,
    0,
    479,
    497,
    3,
    96,
    48,
    13,
    480,
    481,
    5,
    26,
    0,
    0,
    481,
    497,
    3,
    96,
    48,
    12,
    482,
    483,
    3,
    50,
    25,
    0,
    483,
    484,
    5,
    53,
    0,
    0,
    484,
    486,
    1,
    0,
    0,
    0,
    485,
    482,
    1,
    0,
    0,
    0,
    485,
    486,
    1,
    0,
    0,
    0,
    486,
    487,
    1,
    0,
    0,
    0,
    487,
    497,
    3,
    46,
    23,
    0,
    488,
    497,
    3,
    38,
    19,
    0,
    489,
    490,
    5,
    30,
    0,
    0,
    490,
    491,
    3,
    96,
    48,
    0,
    491,
    492,
    5,
    31,
    0,
    0,
    492,
    497,
    1,
    0,
    0,
    0,
    493,
    494,
    3,
    56,
    28,
    0,
    494,
    495,
    3,
    96,
    48,
    1,
    495,
    497,
    1,
    0,
    0,
    0,
    496,
    476,
    1,
    0,
    0,
    0,
    496,
    478,
    1,
    0,
    0,
    0,
    496,
    480,
    1,
    0,
    0,
    0,
    496,
    485,
    1,
    0,
    0,
    0,
    496,
    488,
    1,
    0,
    0,
    0,
    496,
    489,
    1,
    0,
    0,
    0,
    496,
    493,
    1,
    0,
    0,
    0,
    497,
    521,
    1,
    0,
    0,
    0,
    498,
    499,
    10,
    11,
    0,
    0,
    499,
    500,
    7,
    4,
    0,
    0,
    500,
    520,
    3,
    96,
    48,
    12,
    501,
    502,
    10,
    10,
    0,
    0,
    502,
    503,
    7,
    5,
    0,
    0,
    503,
    520,
    3,
    96,
    48,
    11,
    504,
    505,
    10,
    9,
    0,
    0,
    505,
    506,
    7,
    6,
    0,
    0,
    506,
    520,
    3,
    96,
    48,
    10,
    507,
    508,
    10,
    8,
    0,
    0,
    508,
    509,
    7,
    7,
    0,
    0,
    509,
    520,
    3,
    96,
    48,
    9,
    510,
    511,
    10,
    7,
    0,
    0,
    511,
    512,
    5,
    13,
    0,
    0,
    512,
    520,
    3,
    96,
    48,
    8,
    513,
    514,
    10,
    6,
    0,
    0,
    514,
    515,
    5,
    12,
    0,
    0,
    515,
    520,
    3,
    96,
    48,
    7,
    516,
    517,
    10,
    5,
    0,
    0,
    517,
    518,
    5,
    20,
    0,
    0,
    518,
    520,
    3,
    96,
    48,
    6,
    519,
    498,
    1,
    0,
    0,
    0,
    519,
    501,
    1,
    0,
    0,
    0,
    519,
    504,
    1,
    0,
    0,
    0,
    519,
    507,
    1,
    0,
    0,
    0,
    519,
    510,
    1,
    0,
    0,
    0,
    519,
    513,
    1,
    0,
    0,
    0,
    519,
    516,
    1,
    0,
    0,
    0,
    520,
    523,
    1,
    0,
    0,
    0,
    521,
    519,
    1,
    0,
    0,
    0,
    521,
    522,
    1,
    0,
    0,
    0,
    522,
    97,
    1,
    0,
    0,
    0,
    523,
    521,
    1,
    0,
    0,
    0,
    524,
    530,
    7,
    8,
    0,
    0,
    525,
    530,
    7,
    9,
    0,
    0,
    526,
    530,
    5,
    54,
    0,
    0,
    527,
    530,
    5,
    57,
    0,
    0,
    528,
    530,
    5,
    36,
    0,
    0,
    529,
    524,
    1,
    0,
    0,
    0,
    529,
    525,
    1,
    0,
    0,
    0,
    529,
    526,
    1,
    0,
    0,
    0,
    529,
    527,
    1,
    0,
    0,
    0,
    529,
    528,
    1,
    0,
    0,
    0,
    530,
    99,
    1,
    0,
    0,
    0,
    531,
    532,
    5,
    30,
    0,
    0,
    532,
    533,
    3,
    102,
    51,
    0,
    533,
    534,
    5,
    31,
    0,
    0,
    534,
    541,
    1,
    0,
    0,
    0,
    535,
    536,
    5,
    30,
    0,
    0,
    536,
    541,
    3,
    102,
    51,
    0,
    537,
    538,
    5,
    30,
    0,
    0,
    538,
    541,
    5,
    31,
    0,
    0,
    539,
    541,
    5,
    30,
    0,
    0,
    540,
    531,
    1,
    0,
    0,
    0,
    540,
    535,
    1,
    0,
    0,
    0,
    540,
    537,
    1,
    0,
    0,
    0,
    540,
    539,
    1,
    0,
    0,
    0,
    541,
    101,
    1,
    0,
    0,
    0,
    542,
    546,
    3,
    98,
    49,
    0,
    543,
    546,
    3,
    96,
    48,
    0,
    544,
    546,
    3,
    104,
    52,
    0,
    545,
    542,
    1,
    0,
    0,
    0,
    545,
    543,
    1,
    0,
    0,
    0,
    545,
    544,
    1,
    0,
    0,
    0,
    546,
    103,
    1,
    0,
    0,
    0,
    547,
    548,
    5,
    54,
    0,
    0,
    548,
    549,
    5,
    49,
    0,
    0,
    549,
    550,
    5,
    54,
    0,
    0,
    550,
    105,
    1,
    0,
    0,
    0,
    77,
    107,
    111,
    117,
    120,
    125,
    129,
    132,
    136,
    138,
    142,
    144,
    148,
    152,
    158,
    164,
    169,
    171,
    176,
    179,
    182,
    187,
    190,
    194,
    197,
    200,
    204,
    213,
    217,
    219,
    224,
    235,
    239,
    242,
    247,
    249,
    263,
    270,
    275,
    280,
    285,
    288,
    294,
    297,
    300,
    303,
    308,
    311,
    316,
    321,
    328,
    333,
    340,
    349,
    353,
    358,
    366,
    375,
    377,
    391,
    395,
    404,
    408,
    412,
    421,
    425,
    432,
    443,
    447,
    463,
    474,
    485,
    496,
    519,
    521,
    529,
    540,
    545
  ], Qo = new b.atn.ATNDeserializer().deserialize(F7), D7 = Qo.decisionToState.map((t10, e10) => new b.dfa.DFA(t10, e10)), B7 = new b.PredictionContextCache(), v$1 = class v extends b.Parser {
    constructor(e10) {
      super(e10), this._interp = new b.atn.ParserATNSimulator(this, Qo, D7, B7), this.ruleNames = v$1.ruleNames, this.literalNames = v$1.literalNames, this.symbolicNames = v$1.symbolicNames;
    }
    get atn() {
      return Qo;
    }
    sempred(e10, n10, r10) {
      switch (n10) {
        case 48:
          return this.expr_sempred(e10, r10);
        default:
          throw "No predicate with index:" + n10;
      }
    }
    expr_sempred(e10, n10) {
      switch (n10) {
        case 0:
          return this.precpred(this._ctx, 11);
        case 1:
          return this.precpred(this._ctx, 10);
        case 2:
          return this.precpred(this._ctx, 9);
        case 3:
          return this.precpred(this._ctx, 8);
        case 4:
          return this.precpred(this._ctx, 7);
        case 5:
          return this.precpred(this._ctx, 6);
        case 6:
          return this.precpred(this._ctx, 5);
        default:
          throw "No predicate with index:" + n10;
      }
    }
    prog() {
      let e10 = new o4(this, this._ctx, this.state);
      this.enterRule(e10, 0, v$1.RULE_prog);
      var n10 = 0;
      try {
        this.state = 125, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 4, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 107, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 6 && (this.state = 106, this.title()), this.state = 109, this.match(v$1.EOF);
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 111, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 6 && (this.state = 110, this.title()), this.state = 113, this.head(), this.state = 114, this.match(v$1.EOF);
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 117, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 6 && (this.state = 116, this.title()), this.state = 120, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 3, this._ctx);
            r10 === 1 && (this.state = 119, this.head()), this.state = 122, this.block(), this.state = 123, this.match(v$1.EOF);
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    title() {
      let e10 = new La(this, this._ctx, this.state);
      this.enterRule(e10, 2, v$1.RULE_title);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 127, this.match(v$1.TITLE), this.state = 129, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 64 && (this.state = 128, this.match(v$1.TITLE_CONTENT)), this.state = 132, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 65 && (this.state = 131, this.match(v$1.TITLE_END));
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    head() {
      let e10 = new _a(this, this._ctx, this.state);
      this.enterRule(e10, 4, v$1.RULE_head);
      try {
        this.state = 148, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 11, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 136, this._errHandler.sync(this);
            var r10 = 1;
            do {
              switch (r10) {
                case 1:
                  switch (this.state = 136, this._errHandler.sync(this), this._input.LA(1)) {
                    case 43:
                      this.state = 134, this.group();
                      break;
                    case 8:
                    case 17:
                    case 52:
                    case 54:
                    case 57:
                      this.state = 135, this.participant();
                      break;
                    default:
                      throw new b.error.NoViableAltException(this);
                  }
                  break;
                default:
                  throw new b.error.NoViableAltException(this);
              }
              this.state = 138, this._errHandler.sync(this), r10 = this._interp.adaptivePredict(this._input, 8, this._ctx);
            } while (r10 != 2 && r10 != b.atn.ATN.INVALID_ALT_NUMBER);
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 144, this._errHandler.sync(this);
            for (var r10 = this._interp.adaptivePredict(this._input, 10, this._ctx); r10 != 2 && r10 != b.atn.ATN.INVALID_ALT_NUMBER; ) {
              if (r10 === 1)
                switch (this.state = 142, this._errHandler.sync(this), this._input.LA(1)) {
                  case 43:
                    this.state = 140, this.group();
                    break;
                  case 8:
                  case 17:
                  case 52:
                  case 54:
                  case 57:
                    this.state = 141, this.participant();
                    break;
                  default:
                    throw new b.error.NoViableAltException(this);
                }
              this.state = 146, this._errHandler.sync(this), r10 = this._interp.adaptivePredict(this._input, 10, this._ctx);
            }
            this.state = 147, this.starterExp();
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    group() {
      let e10 = new Pi(this, this._ctx, this.state);
      this.enterRule(e10, 6, v$1.RULE_group);
      var n10 = 0;
      try {
        this.state = 171, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 16, this._ctx);
        switch (r10) {
          case 1:
            for (this.enterOuterAlt(e10, 1), this.state = 150, this.match(v$1.GROUP), this.state = 152, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 === 54 || n10 === 57) && (this.state = 151, this.name()), this.state = 154, this.match(v$1.OBRACE), this.state = 158, this._errHandler.sync(this), n10 = this._input.LA(1); n10 === 8 || n10 === 17 || (n10 - 52 & -32) == 0 && (1 << n10 - 52 & 37) !== 0; )
              this.state = 155, this.participant(), this.state = 160, this._errHandler.sync(this), n10 = this._input.LA(1);
            this.state = 161, this.match(v$1.CBRACE);
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 162, this.match(v$1.GROUP), this.state = 164, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 === 54 || n10 === 57) && (this.state = 163, this.name()), this.state = 166, this.match(v$1.OBRACE);
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 167, this.match(v$1.GROUP), this.state = 169, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 15, this._ctx);
            r10 === 1 && (this.state = 168, this.name());
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    starterExp() {
      let e10 = new ya(this, this._ctx, this.state);
      this.enterRule(e10, 8, v$1.RULE_starterExp);
      var n10 = 0;
      try {
        switch (this.state = 182, this._errHandler.sync(this), this._input.LA(1)) {
          case 50:
            this.enterOuterAlt(e10, 1), this.state = 173, this.match(v$1.STARTER_LXR), this.state = 179, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 30 && (this.state = 174, this.match(v$1.OPAR), this.state = 176, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 === 54 || n10 === 57) && (this.state = 175, this.starter()), this.state = 178, this.match(v$1.CPAR));
            break;
          case 52:
            this.enterOuterAlt(e10, 2), this.state = 181, this.match(v$1.ANNOTATION);
            break;
          default:
            throw new b.error.NoViableAltException(this);
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    starter() {
      let e10 = new Ca(this, this._ctx, this.state);
      this.enterRule(e10, 10, v$1.RULE_starter);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 184, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    participant() {
      let e10 = new bs(this, this._ctx, this.state);
      this.enterRule(e10, 12, v$1.RULE_participant);
      var n10 = 0;
      try {
        this.state = 204, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 25, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 187, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 52 && (this.state = 186, this.participantType()), this.state = 190, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 === 8 || n10 === 17) && (this.state = 189, this.stereotype()), this.state = 192, this.name(), this.state = 194, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 22, this._ctx);
            r10 === 1 && (this.state = 193, this.width()), this.state = 197, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 45 && (this.state = 196, this.label()), this.state = 200, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 11 && (this.state = 199, this.match(v$1.COLOR));
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 202, this.stereotype();
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 203, this.participantType();
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    stereotype() {
      let e10 = new va(this, this._ctx, this.state);
      this.enterRule(e10, 14, v$1.RULE_stereotype);
      var n10 = 0;
      try {
        this.state = 219, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 28, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 206, this.match(v$1.SOPEN), this.state = 207, this.name(), this.state = 208, this.match(v$1.SCLOSE);
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 210, this.match(v$1.SOPEN), this.state = 211, this.name(), this.state = 213, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 16 && (this.state = 212, this.match(v$1.GT));
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 215, n10 = this._input.LA(1), n10 === 8 || n10 === 17 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this), this.state = 217, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 === 9 || n10 === 16) && (this.state = 216, n10 = this._input.LA(1), n10 === 9 || n10 === 16 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this));
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    label() {
      let e10 = new ba(this, this._ctx, this.state);
      this.enterRule(e10, 16, v$1.RULE_label);
      try {
        this.state = 224, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 29, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 221, this.match(v$1.AS), this.state = 222, this.name();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 223, this.match(v$1.AS);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    participantType() {
      let e10 = new wa(this, this._ctx, this.state);
      this.enterRule(e10, 18, v$1.RULE_participantType);
      try {
        this.enterOuterAlt(e10, 1), this.state = 226, this.match(v$1.ANNOTATION);
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    name() {
      let e10 = new Is(this, this._ctx, this.state);
      this.enterRule(e10, 20, v$1.RULE_name);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 228, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    width() {
      let e10 = new Ea(this, this._ctx, this.state);
      this.enterRule(e10, 22, v$1.RULE_width);
      try {
        this.enterOuterAlt(e10, 1), this.state = 230, this.match(v$1.INT);
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    block() {
      let e10 = new v1(this, this._ctx, this.state);
      this.enterRule(e10, 24, v$1.RULE_block);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 233, this._errHandler.sync(this), n10 = this._input.LA(1);
        do
          this.state = 232, this.stat(), this.state = 235, this._errHandler.sync(this), n10 = this._input.LA(1);
        while ((n10 - 34 & -32) == 0 && (1 << n10 - 34 & 217191919) !== 0);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    ret() {
      let e10 = new Ta(this, this._ctx, this.state);
      this.enterRule(e10, 26, v$1.RULE_ret);
      var n10 = 0;
      try {
        switch (this.state = 249, this._errHandler.sync(this), this._input.LA(1)) {
          case 40:
            this.enterOuterAlt(e10, 1), this.state = 237, this.match(v$1.RETURN), this.state = 239, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 31, this._ctx);
            r10 === 1 && (this.state = 238, this.expr(0)), this.state = 242, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 27 && (this.state = 241, this.match(v$1.SCOL));
            break;
          case 51:
            this.enterOuterAlt(e10, 2), this.state = 244, this.match(v$1.ANNOTATION_RET), this.state = 245, this.asyncMessage(), this.state = 247, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 63 && (this.state = 246, this.match(v$1.EVENT_END));
            break;
          default:
            throw new b.error.NoViableAltException(this);
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    divider() {
      let e10 = new Sa(this, this._ctx, this.state);
      this.enterRule(e10, 28, v$1.RULE_divider);
      try {
        this.enterOuterAlt(e10, 1), this.state = 251, this.dividerNote();
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    dividerNote() {
      let e10 = new Aa(this, this._ctx, this.state);
      this.enterRule(e10, 30, v$1.RULE_dividerNote);
      try {
        this.enterOuterAlt(e10, 1), this.state = 253, this.match(v$1.DIVIDER);
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    stat() {
      let e10 = new Fi(this, this._ctx, this.state);
      this.enterRule(e10, 32, v$1.RULE_stat);
      var n10 = 0;
      try {
        this.state = 270, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 36, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 255, this.alt();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 256, this.par();
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 257, this.opt();
            break;
          case 4:
            this.enterOuterAlt(e10, 4), this.state = 258, this.loop();
            break;
          case 5:
            this.enterOuterAlt(e10, 5), this.state = 259, this.creation();
            break;
          case 6:
            this.enterOuterAlt(e10, 6), this.state = 260, this.message();
            break;
          case 7:
            this.enterOuterAlt(e10, 7), this.state = 261, this.asyncMessage(), this.state = 263, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 63 && (this.state = 262, this.match(v$1.EVENT_END));
            break;
          case 8:
            this.enterOuterAlt(e10, 8), this.state = 265, this.ret();
            break;
          case 9:
            this.enterOuterAlt(e10, 9), this.state = 266, this.divider();
            break;
          case 10:
            this.enterOuterAlt(e10, 10), this.state = 267, this.tcf();
            break;
          case 11:
            this.enterOuterAlt(e10, 11), this.state = 268, e10._OTHER = this.match(v$1.OTHER), console.log("unknown char: " + (e10._OTHER === null ? null : e10._OTHER.text));
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    par() {
      let e10 = new ka(this, this._ctx, this.state);
      this.enterRule(e10, 34, v$1.RULE_par);
      try {
        this.state = 275, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 37, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 272, this.match(v$1.PAR), this.state = 273, this.braceBlock();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 274, this.match(v$1.PAR);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    opt() {
      let e10 = new Ra(this, this._ctx, this.state);
      this.enterRule(e10, 36, v$1.RULE_opt);
      try {
        this.state = 280, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 38, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 277, this.match(v$1.OPT), this.state = 278, this.braceBlock();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 279, this.match(v$1.OPT);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    creation() {
      let e10 = new b1(this, this._ctx, this.state);
      this.enterRule(e10, 38, v$1.RULE_creation);
      try {
        this.enterOuterAlt(e10, 1), this.state = 282, this.creationBody(), this.state = 285, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 39, this._ctx);
        n10 === 1 ? (this.state = 283, this.match(v$1.SCOL)) : n10 === 2 && (this.state = 284, this.braceBlock());
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    creationBody() {
      let e10 = new Oa(this, this._ctx, this.state);
      this.enterRule(e10, 40, v$1.RULE_creationBody);
      var n10 = 0;
      try {
        this.state = 303, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 44, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 288, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 - 34 & -32) == 0 && (1 << n10 - 34 & 15728647) !== 0 && (this.state = 287, this.assignment()), this.state = 290, this.match(v$1.NEW), this.state = 291, this.construct(), this.state = 297, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 42, this._ctx);
            r10 === 1 && (this.state = 292, this.match(v$1.OPAR), this.state = 294, this._errHandler.sync(this), n10 = this._input.LA(1), ((n10 & -32) == 0 && (1 << n10 & 1142947840) !== 0 || (n10 - 34 & -32) == 0 && (1 << n10 - 34 & 15728775) !== 0) && (this.state = 293, this.parameters()), this.state = 296, this.match(v$1.CPAR));
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 300, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 - 34 & -32) == 0 && (1 << n10 - 34 & 15728647) !== 0 && (this.state = 299, this.assignment()), this.state = 302, this.match(v$1.NEW);
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    message() {
      let e10 = new Ia(this, this._ctx, this.state);
      this.enterRule(e10, 42, v$1.RULE_message);
      try {
        switch (this.enterOuterAlt(e10, 1), this.state = 305, this.messageBody(), this.state = 308, this._errHandler.sync(this), this._input.LA(1)) {
          case 27:
            this.state = 306, this.match(v$1.SCOL);
            break;
          case 32:
            this.state = 307, this.braceBlock();
            break;
          case -1:
          case 33:
          case 34:
          case 35:
          case 36:
          case 37:
          case 39:
          case 40:
          case 41:
          case 42:
          case 44:
          case 46:
          case 51:
          case 54:
          case 55:
          case 56:
          case 57:
          case 60:
          case 61:
            break;
          default:
            break;
        }
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    messageBody() {
      let e10 = new Ma(this, this._ctx, this.state);
      this.enterRule(e10, 44, v$1.RULE_messageBody);
      try {
        this.state = 333, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 50, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 311, this._errHandler.sync(this);
            var n10 = this._interp.adaptivePredict(this._input, 46, this._ctx);
            n10 === 1 && (this.state = 310, this.assignment()), this.state = 321, this._errHandler.sync(this);
            var n10 = this._interp.adaptivePredict(this._input, 48, this._ctx);
            if (n10 === 1) {
              this.state = 316, this._errHandler.sync(this);
              var n10 = this._interp.adaptivePredict(this._input, 47, this._ctx);
              n10 === 1 && (this.state = 313, this.from(), this.state = 314, this.match(v$1.ARROW)), this.state = 318, this.to(), this.state = 319, this.match(v$1.DOT);
            }
            this.state = 323, this.func();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 324, this.assignment();
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 328, this._errHandler.sync(this);
            var n10 = this._interp.adaptivePredict(this._input, 49, this._ctx);
            n10 === 1 && (this.state = 325, this.from(), this.state = 326, this.match(v$1.ARROW)), this.state = 330, this.to(), this.state = 331, this.match(v$1.DOT);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    func() {
      let e10 = new w1(this, this._ctx, this.state);
      this.enterRule(e10, 46, v$1.RULE_func);
      try {
        this.enterOuterAlt(e10, 1), this.state = 335, this.signature(), this.state = 340, this._errHandler.sync(this);
        for (var n10 = this._interp.adaptivePredict(this._input, 51, this._ctx); n10 != 2 && n10 != b.atn.ATN.INVALID_ALT_NUMBER; )
          n10 === 1 && (this.state = 336, this.match(v$1.DOT), this.state = 337, this.signature()), this.state = 342, this._errHandler.sync(this), n10 = this._interp.adaptivePredict(this._input, 51, this._ctx);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    from() {
      let e10 = new E1(this, this._ctx, this.state);
      this.enterRule(e10, 48, v$1.RULE_from);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 343, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    to() {
      let e10 = new D0(this, this._ctx, this.state);
      this.enterRule(e10, 50, v$1.RULE_to);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 345, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    signature() {
      let e10 = new Di(this, this._ctx, this.state);
      this.enterRule(e10, 52, v$1.RULE_signature);
      try {
        this.enterOuterAlt(e10, 1), this.state = 347, this.methodName(), this.state = 349, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 52, this._ctx);
        n10 === 1 && (this.state = 348, this.invocation());
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    invocation() {
      let e10 = new T1(this, this._ctx, this.state);
      this.enterRule(e10, 54, v$1.RULE_invocation);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 351, this.match(v$1.OPAR), this.state = 353, this._errHandler.sync(this), n10 = this._input.LA(1), ((n10 & -32) == 0 && (1 << n10 & 1142947840) !== 0 || (n10 - 34 & -32) == 0 && (1 << n10 - 34 & 15728775) !== 0) && (this.state = 352, this.parameters()), this.state = 355, this.match(v$1.CPAR);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    assignment() {
      let e10 = new B0(this, this._ctx, this.state);
      this.enterRule(e10, 56, v$1.RULE_assignment);
      try {
        this.enterOuterAlt(e10, 1), this.state = 358, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 54, this._ctx);
        n10 === 1 && (this.state = 357, this.type()), this.state = 360, this.assignee(), this.state = 361, this.match(v$1.ASSIGN);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    asyncMessage() {
      let e10 = new S1(this, this._ctx, this.state);
      this.enterRule(e10, 58, v$1.RULE_asyncMessage);
      var n10 = 0;
      try {
        this.state = 377, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 57, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 366, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 55, this._ctx);
            r10 === 1 && (this.state = 363, this.from(), this.state = 364, this.match(v$1.ARROW)), this.state = 368, this.to(), this.state = 369, this.match(v$1.COL), this.state = 370, this.content();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 372, this.from(), this.state = 373, n10 = this._input.LA(1), n10 === 10 || n10 === 21 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this), this.state = 375, this._errHandler.sync(this);
            var r10 = this._interp.adaptivePredict(this._input, 56, this._ctx);
            r10 === 1 && (this.state = 374, this.to());
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    content() {
      let e10 = new Na(this, this._ctx, this.state);
      this.enterRule(e10, 60, v$1.RULE_content);
      try {
        this.enterOuterAlt(e10, 1), this.state = 379, this.match(v$1.EVENT_PAYLOAD_LXR);
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    construct() {
      let e10 = new Pa(this, this._ctx, this.state);
      this.enterRule(e10, 62, v$1.RULE_construct);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 381, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    type() {
      let e10 = new A1(this, this._ctx, this.state);
      this.enterRule(e10, 64, v$1.RULE_type);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 383, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    assignee() {
      let e10 = new Fa(this, this._ctx, this.state);
      this.enterRule(e10, 66, v$1.RULE_assignee);
      var n10 = 0;
      try {
        this.state = 395, this._errHandler.sync(this);
        var r10 = this._interp.adaptivePredict(this._input, 59, this._ctx);
        switch (r10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 385, this.atom();
            break;
          case 2:
            for (this.enterOuterAlt(e10, 2), this.state = 386, this.match(v$1.ID), this.state = 391, this._errHandler.sync(this), n10 = this._input.LA(1); n10 === 28; )
              this.state = 387, this.match(v$1.COMMA), this.state = 388, this.match(v$1.ID), this.state = 393, this._errHandler.sync(this), n10 = this._input.LA(1);
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 394, this.match(v$1.STRING);
            break;
        }
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    methodName() {
      let e10 = new Da(this, this._ctx, this.state);
      this.enterRule(e10, 68, v$1.RULE_methodName);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 397, n10 = this._input.LA(1), n10 === 54 || n10 === 57 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    parameters() {
      let e10 = new k1(this, this._ctx, this.state);
      this.enterRule(e10, 70, v$1.RULE_parameters);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 399, this.parameter(), this.state = 404, this._errHandler.sync(this);
        for (var r10 = this._interp.adaptivePredict(this._input, 60, this._ctx); r10 != 2 && r10 != b.atn.ATN.INVALID_ALT_NUMBER; )
          r10 === 1 && (this.state = 400, this.match(v$1.COMMA), this.state = 401, this.parameter()), this.state = 406, this._errHandler.sync(this), r10 = this._interp.adaptivePredict(this._input, 60, this._ctx);
        this.state = 408, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 28 && (this.state = 407, this.match(v$1.COMMA));
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    parameter() {
      let e10 = new Bi(this, this._ctx, this.state);
      this.enterRule(e10, 72, v$1.RULE_parameter);
      try {
        this.state = 412, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 62, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 410, this.declaration();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 411, this.expr(0);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    declaration() {
      let e10 = new Ba(this, this._ctx, this.state);
      this.enterRule(e10, 74, v$1.RULE_declaration);
      try {
        this.enterOuterAlt(e10, 1), this.state = 414, this.type(), this.state = 415, this.match(v$1.ID);
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    tcf() {
      let e10 = new $a(this, this._ctx, this.state);
      this.enterRule(e10, 76, v$1.RULE_tcf);
      var n10 = 0;
      try {
        for (this.enterOuterAlt(e10, 1), this.state = 417, this.tryBlock(), this.state = 421, this._errHandler.sync(this), n10 = this._input.LA(1); n10 === 47; )
          this.state = 418, this.catchBlock(), this.state = 423, this._errHandler.sync(this), n10 = this._input.LA(1);
        this.state = 425, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 48 && (this.state = 424, this.finallyBlock());
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    tryBlock() {
      let e10 = new Ha(this, this._ctx, this.state);
      this.enterRule(e10, 78, v$1.RULE_tryBlock);
      try {
        this.enterOuterAlt(e10, 1), this.state = 427, this.match(v$1.TRY), this.state = 428, this.braceBlock();
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    catchBlock() {
      let e10 = new $i(this, this._ctx, this.state);
      this.enterRule(e10, 80, v$1.RULE_catchBlock);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 430, this.match(v$1.CATCH), this.state = 432, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 30 && (this.state = 431, this.invocation()), this.state = 434, this.braceBlock();
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    finallyBlock() {
      let e10 = new Ua(this, this._ctx, this.state);
      this.enterRule(e10, 82, v$1.RULE_finallyBlock);
      try {
        this.enterOuterAlt(e10, 1), this.state = 436, this.match(v$1.FINALLY), this.state = 437, this.braceBlock();
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    alt() {
      let e10 = new Va(this, this._ctx, this.state);
      this.enterRule(e10, 84, v$1.RULE_alt);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 439, this.ifBlock(), this.state = 443, this._errHandler.sync(this);
        for (var r10 = this._interp.adaptivePredict(this._input, 66, this._ctx); r10 != 2 && r10 != b.atn.ATN.INVALID_ALT_NUMBER; )
          r10 === 1 && (this.state = 440, this.elseIfBlock()), this.state = 445, this._errHandler.sync(this), r10 = this._interp.adaptivePredict(this._input, 66, this._ctx);
        this.state = 447, this._errHandler.sync(this), n10 = this._input.LA(1), n10 === 38 && (this.state = 446, this.elseBlock());
      } catch (s10) {
        if (s10 instanceof b.error.RecognitionException)
          e10.exception = s10, this._errHandler.reportError(this, s10), this._errHandler.recover(this, s10);
        else
          throw s10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    ifBlock() {
      let e10 = new za(this, this._ctx, this.state);
      this.enterRule(e10, 86, v$1.RULE_ifBlock);
      try {
        this.enterOuterAlt(e10, 1), this.state = 449, this.match(v$1.IF), this.state = 450, this.parExpr(), this.state = 451, this.braceBlock();
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    elseIfBlock() {
      let e10 = new Hi(this, this._ctx, this.state);
      this.enterRule(e10, 88, v$1.RULE_elseIfBlock);
      try {
        this.enterOuterAlt(e10, 1), this.state = 453, this.match(v$1.ELSE), this.state = 454, this.match(v$1.IF), this.state = 455, this.parExpr(), this.state = 456, this.braceBlock();
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    elseBlock() {
      let e10 = new Ga(this, this._ctx, this.state);
      this.enterRule(e10, 90, v$1.RULE_elseBlock);
      try {
        this.enterOuterAlt(e10, 1), this.state = 458, this.match(v$1.ELSE), this.state = 459, this.braceBlock();
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    braceBlock() {
      let e10 = new tn$1(this, this._ctx, this.state);
      this.enterRule(e10, 92, v$1.RULE_braceBlock);
      var n10 = 0;
      try {
        this.enterOuterAlt(e10, 1), this.state = 461, this.match(v$1.OBRACE), this.state = 463, this._errHandler.sync(this), n10 = this._input.LA(1), (n10 - 34 & -32) == 0 && (1 << n10 - 34 & 217191919) !== 0 && (this.state = 462, this.block()), this.state = 465, this.match(v$1.CBRACE);
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    loop() {
      let e10 = new ja(this, this._ctx, this.state);
      this.enterRule(e10, 94, v$1.RULE_loop);
      try {
        this.state = 474, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 69, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 467, this.match(v$1.WHILE), this.state = 468, this.parExpr(), this.state = 469, this.braceBlock();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 471, this.match(v$1.WHILE), this.state = 472, this.parExpr();
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 473, this.match(v$1.WHILE);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    expr(e10) {
      e10 === void 0 && (e10 = 0);
      const n10 = this._ctx, r10 = this.state;
      let s10 = new ye$1(this, this._ctx, r10), i10 = s10;
      const o10 = 96;
      this.enterRecursionRule(s10, 96, v$1.RULE_expr, e10);
      var l10 = 0;
      try {
        this.enterOuterAlt(s10, 1), this.state = 496, this._errHandler.sync(this);
        var a10 = this._interp.adaptivePredict(this._input, 71, this._ctx);
        switch (a10) {
          case 1:
            s10 = new c4(this, s10), this._ctx = s10, i10 = s10, this.state = 477, this.atom();
            break;
          case 2:
            s10 = new g4(this, s10), this._ctx = s10, i10 = s10, this.state = 478, this.match(v$1.MINUS), this.state = 479, this.expr(13);
            break;
          case 3:
            s10 = new p4(this, s10), this._ctx = s10, i10 = s10, this.state = 480, this.match(v$1.NOT), this.state = 481, this.expr(12);
            break;
          case 4:
            s10 = new a4(this, s10), this._ctx = s10, i10 = s10, this.state = 485, this._errHandler.sync(this);
            var a10 = this._interp.adaptivePredict(this._input, 70, this._ctx);
            a10 === 1 && (this.state = 482, this.to(), this.state = 483, this.match(v$1.DOT)), this.state = 487, this.func();
            break;
          case 5:
            s10 = new m4(this, s10), this._ctx = s10, i10 = s10, this.state = 488, this.creation();
            break;
          case 6:
            s10 = new x4(this, s10), this._ctx = s10, i10 = s10, this.state = 489, this.match(v$1.OPAR), this.state = 490, this.expr(0), this.state = 491, this.match(v$1.CPAR);
            break;
          case 7:
            s10 = new l4(this, s10), this._ctx = s10, i10 = s10, this.state = 493, this.assignment(), this.state = 494, this.expr(1);
            break;
        }
        this._ctx.stop = this._input.LT(-1), this.state = 521, this._errHandler.sync(this);
        for (var c10 = this._interp.adaptivePredict(this._input, 73, this._ctx); c10 != 2 && c10 != b.atn.ATN.INVALID_ALT_NUMBER; ) {
          if (c10 === 1) {
            this._parseListeners !== null && this.triggerExitRuleEvent(), i10 = s10, this.state = 519, this._errHandler.sync(this);
            var a10 = this._interp.adaptivePredict(this._input, 72, this._ctx);
            switch (a10) {
              case 1:
                if (s10 = new L4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 498, !this.precpred(this._ctx, 11))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 11)");
                this.state = 499, s10.op = this._input.LT(1), l10 = this._input.LA(1), (l10 & -32) == 0 && (1 << l10 & 29360128) !== 0 ? (this._errHandler.reportMatch(this), this.consume()) : s10.op = this._errHandler.recoverInline(this), this.state = 500, this.expr(12);
                break;
              case 2:
                if (s10 = new h4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 501, !this.precpred(this._ctx, 10))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 10)");
                this.state = 502, s10.op = this._input.LT(1), l10 = this._input.LA(1), l10 === 20 || l10 === 21 ? (this._errHandler.reportMatch(this), this.consume()) : s10.op = this._errHandler.recoverInline(this), this.state = 503, this.expr(11);
                break;
              case 3:
                if (s10 = new d4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 504, !this.precpred(this._ctx, 9))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 9)");
                this.state = 505, s10.op = this._input.LT(1), l10 = this._input.LA(1), (l10 & -32) == 0 && (1 << l10 & 983040) !== 0 ? (this._errHandler.reportMatch(this), this.consume()) : s10.op = this._errHandler.recoverInline(this), this.state = 506, this.expr(10);
                break;
              case 4:
                if (s10 = new _4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 507, !this.precpred(this._ctx, 8))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 8)");
                this.state = 508, s10.op = this._input.LT(1), l10 = this._input.LA(1), l10 === 14 || l10 === 15 ? (this._errHandler.reportMatch(this), this.consume()) : s10.op = this._errHandler.recoverInline(this), this.state = 509, this.expr(9);
                break;
              case 5:
                if (s10 = new y4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 510, !this.precpred(this._ctx, 7))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 7)");
                this.state = 511, this.match(v$1.AND), this.state = 512, this.expr(8);
                break;
              case 6:
                if (s10 = new u4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 513, !this.precpred(this._ctx, 6))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 6)");
                this.state = 514, this.match(v$1.OR), this.state = 515, this.expr(7);
                break;
              case 7:
                if (s10 = new f4(this, new ye$1(this, n10, r10)), this.pushNewRecursionContext(s10, o10, v$1.RULE_expr), this.state = 516, !this.precpred(this._ctx, 5))
                  throw new b.error.FailedPredicateException(this, "this.precpred(this._ctx, 5)");
                this.state = 517, this.match(v$1.PLUS), this.state = 518, this.expr(6);
                break;
            }
          }
          this.state = 523, this._errHandler.sync(this), c10 = this._interp.adaptivePredict(this._input, 73, this._ctx);
        }
      } catch (u10) {
        if (u10 instanceof b.error.RecognitionException)
          s10.exception = u10, this._errHandler.reportError(this, u10), this._errHandler.recover(this, u10);
        else
          throw u10;
      } finally {
        this.unrollRecursionContexts(n10);
      }
      return s10;
    }
    atom() {
      let e10 = new Dn(this, this._ctx, this.state);
      this.enterRule(e10, 98, v$1.RULE_atom);
      var n10 = 0;
      try {
        switch (this.state = 529, this._errHandler.sync(this), this._input.LA(1)) {
          case 55:
          case 56:
            e10 = new E4(this, e10), this.enterOuterAlt(e10, 1), this.state = 524, n10 = this._input.LA(1), n10 === 55 || n10 === 56 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
            break;
          case 34:
          case 35:
            e10 = new C4(this, e10), this.enterOuterAlt(e10, 2), this.state = 525, n10 = this._input.LA(1), n10 === 34 || n10 === 35 ? (this._errHandler.reportMatch(this), this.consume()) : this._errHandler.recoverInline(this);
            break;
          case 54:
            e10 = new v4(this, e10), this.enterOuterAlt(e10, 3), this.state = 526, this.match(v$1.ID);
            break;
          case 57:
            e10 = new b4(this, e10), this.enterOuterAlt(e10, 4), this.state = 527, this.match(v$1.STRING);
            break;
          case 36:
            e10 = new w4(this, e10), this.enterOuterAlt(e10, 5), this.state = 528, this.match(v$1.NIL);
            break;
          default:
            throw new b.error.NoViableAltException(this);
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    parExpr() {
      let e10 = new $0(this, this._ctx, this.state);
      this.enterRule(e10, 100, v$1.RULE_parExpr);
      try {
        this.state = 540, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 75, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 531, this.match(v$1.OPAR), this.state = 532, this.condition(), this.state = 533, this.match(v$1.CPAR);
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 535, this.match(v$1.OPAR), this.state = 536, this.condition();
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 537, this.match(v$1.OPAR), this.state = 538, this.match(v$1.CPAR);
            break;
          case 4:
            this.enterOuterAlt(e10, 4), this.state = 539, this.match(v$1.OPAR);
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    condition() {
      let e10 = new Za(this, this._ctx, this.state);
      this.enterRule(e10, 102, v$1.RULE_condition);
      try {
        this.state = 545, this._errHandler.sync(this);
        var n10 = this._interp.adaptivePredict(this._input, 76, this._ctx);
        switch (n10) {
          case 1:
            this.enterOuterAlt(e10, 1), this.state = 542, this.atom();
            break;
          case 2:
            this.enterOuterAlt(e10, 2), this.state = 543, this.expr(0);
            break;
          case 3:
            this.enterOuterAlt(e10, 3), this.state = 544, this.inExpr();
            break;
        }
      } catch (r10) {
        if (r10 instanceof b.error.RecognitionException)
          e10.exception = r10, this._errHandler.reportError(this, r10), this._errHandler.recover(this, r10);
        else
          throw r10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
    inExpr() {
      let e10 = new Wa(this, this._ctx, this.state);
      this.enterRule(e10, 104, v$1.RULE_inExpr);
      try {
        this.enterOuterAlt(e10, 1), this.state = 547, this.match(v$1.ID), this.state = 548, this.match(v$1.IN), this.state = 549, this.match(v$1.ID);
      } catch (n10) {
        if (n10 instanceof b.error.RecognitionException)
          e10.exception = n10, this._errHandler.reportError(this, n10), this._errHandler.recover(this, n10);
        else
          throw n10;
      } finally {
        this.exitRule();
      }
      return e10;
    }
  };
  let f$1 = v$1;
  W$1(f$1, "grammarFileName", "java-escape"), W$1(f$1, "literalNames", [
    null,
    null,
    "'const'",
    "'readonly'",
    "'static'",
    "'await'",
    "'title'",
    "':'",
    "'<<'",
    "'>>'",
    "'->'",
    null,
    "'||'",
    "'&&'",
    "'=='",
    "'!='",
    "'>'",
    "'<'",
    "'>='",
    "'<='",
    "'+'",
    "'-'",
    "'*'",
    "'/'",
    "'%'",
    "'^'",
    "'!'",
    "';'",
    "','",
    "'='",
    "'('",
    "')'",
    "'{'",
    "'}'",
    "'true'",
    "'false'",
    null,
    "'if'",
    "'else'",
    null,
    "'return'",
    "'new'",
    "'par'",
    "'group'",
    "'opt'",
    "'as'",
    "'try'",
    "'catch'",
    "'finally'",
    "'in'",
    null,
    null,
    null,
    "'.'"
  ]), W$1(f$1, "symbolicNames", [
    null,
    "WS",
    "CONSTANT",
    "READONLY",
    "STATIC",
    "AWAIT",
    "TITLE",
    "COL",
    "SOPEN",
    "SCLOSE",
    "ARROW",
    "COLOR",
    "OR",
    "AND",
    "EQ",
    "NEQ",
    "GT",
    "LT",
    "GTEQ",
    "LTEQ",
    "PLUS",
    "MINUS",
    "MULT",
    "DIV",
    "MOD",
    "POW",
    "NOT",
    "SCOL",
    "COMMA",
    "ASSIGN",
    "OPAR",
    "CPAR",
    "OBRACE",
    "CBRACE",
    "TRUE",
    "FALSE",
    "NIL",
    "IF",
    "ELSE",
    "WHILE",
    "RETURN",
    "NEW",
    "PAR",
    "GROUP",
    "OPT",
    "AS",
    "TRY",
    "CATCH",
    "FINALLY",
    "IN",
    "STARTER_LXR",
    "ANNOTATION_RET",
    "ANNOTATION",
    "DOT",
    "ID",
    "INT",
    "FLOAT",
    "STRING",
    "CR",
    "COMMENT",
    "OTHER",
    "DIVIDER",
    "EVENT_PAYLOAD_LXR",
    "EVENT_END",
    "TITLE_CONTENT",
    "TITLE_END"
  ]), W$1(f$1, "ruleNames", [
    "prog",
    "title",
    "head",
    "group",
    "starterExp",
    "starter",
    "participant",
    "stereotype",
    "label",
    "participantType",
    "name",
    "width",
    "block",
    "ret",
    "divider",
    "dividerNote",
    "stat",
    "par",
    "opt",
    "creation",
    "creationBody",
    "message",
    "messageBody",
    "func",
    "from",
    "to",
    "signature",
    "invocation",
    "assignment",
    "asyncMessage",
    "content",
    "construct",
    "type",
    "assignee",
    "methodName",
    "parameters",
    "parameter",
    "declaration",
    "tcf",
    "tryBlock",
    "catchBlock",
    "finallyBlock",
    "alt",
    "ifBlock",
    "elseIfBlock",
    "elseBlock",
    "braceBlock",
    "loop",
    "expr",
    "atom",
    "parExpr",
    "condition",
    "inExpr"
  ]);
  f$1.EOF = b.Token.EOF;
  f$1.WS = 1;
  f$1.CONSTANT = 2;
  f$1.READONLY = 3;
  f$1.STATIC = 4;
  f$1.AWAIT = 5;
  f$1.TITLE = 6;
  f$1.COL = 7;
  f$1.SOPEN = 8;
  f$1.SCLOSE = 9;
  f$1.ARROW = 10;
  f$1.COLOR = 11;
  f$1.OR = 12;
  f$1.AND = 13;
  f$1.EQ = 14;
  f$1.NEQ = 15;
  f$1.GT = 16;
  f$1.LT = 17;
  f$1.GTEQ = 18;
  f$1.LTEQ = 19;
  f$1.PLUS = 20;
  f$1.MINUS = 21;
  f$1.MULT = 22;
  f$1.DIV = 23;
  f$1.MOD = 24;
  f$1.POW = 25;
  f$1.NOT = 26;
  f$1.SCOL = 27;
  f$1.COMMA = 28;
  f$1.ASSIGN = 29;
  f$1.OPAR = 30;
  f$1.CPAR = 31;
  f$1.OBRACE = 32;
  f$1.CBRACE = 33;
  f$1.TRUE = 34;
  f$1.FALSE = 35;
  f$1.NIL = 36;
  f$1.IF = 37;
  f$1.ELSE = 38;
  f$1.WHILE = 39;
  f$1.RETURN = 40;
  f$1.NEW = 41;
  f$1.PAR = 42;
  f$1.GROUP = 43;
  f$1.OPT = 44;
  f$1.AS = 45;
  f$1.TRY = 46;
  f$1.CATCH = 47;
  f$1.FINALLY = 48;
  f$1.IN = 49;
  f$1.STARTER_LXR = 50;
  f$1.ANNOTATION_RET = 51;
  f$1.ANNOTATION = 52;
  f$1.DOT = 53;
  f$1.ID = 54;
  f$1.INT = 55;
  f$1.FLOAT = 56;
  f$1.STRING = 57;
  f$1.CR = 58;
  f$1.COMMENT = 59;
  f$1.OTHER = 60;
  f$1.DIVIDER = 61;
  f$1.EVENT_PAYLOAD_LXR = 62;
  f$1.EVENT_END = 63;
  f$1.TITLE_CONTENT = 64;
  f$1.TITLE_END = 65;
  f$1.RULE_prog = 0;
  f$1.RULE_title = 1;
  f$1.RULE_head = 2;
  f$1.RULE_group = 3;
  f$1.RULE_starterExp = 4;
  f$1.RULE_starter = 5;
  f$1.RULE_participant = 6;
  f$1.RULE_stereotype = 7;
  f$1.RULE_label = 8;
  f$1.RULE_participantType = 9;
  f$1.RULE_name = 10;
  f$1.RULE_width = 11;
  f$1.RULE_block = 12;
  f$1.RULE_ret = 13;
  f$1.RULE_divider = 14;
  f$1.RULE_dividerNote = 15;
  f$1.RULE_stat = 16;
  f$1.RULE_par = 17;
  f$1.RULE_opt = 18;
  f$1.RULE_creation = 19;
  f$1.RULE_creationBody = 20;
  f$1.RULE_message = 21;
  f$1.RULE_messageBody = 22;
  f$1.RULE_func = 23;
  f$1.RULE_from = 24;
  f$1.RULE_to = 25;
  f$1.RULE_signature = 26;
  f$1.RULE_invocation = 27;
  f$1.RULE_assignment = 28;
  f$1.RULE_asyncMessage = 29;
  f$1.RULE_content = 30;
  f$1.RULE_construct = 31;
  f$1.RULE_type = 32;
  f$1.RULE_assignee = 33;
  f$1.RULE_methodName = 34;
  f$1.RULE_parameters = 35;
  f$1.RULE_parameter = 36;
  f$1.RULE_declaration = 37;
  f$1.RULE_tcf = 38;
  f$1.RULE_tryBlock = 39;
  f$1.RULE_catchBlock = 40;
  f$1.RULE_finallyBlock = 41;
  f$1.RULE_alt = 42;
  f$1.RULE_ifBlock = 43;
  f$1.RULE_elseIfBlock = 44;
  f$1.RULE_elseBlock = 45;
  f$1.RULE_braceBlock = 46;
  f$1.RULE_loop = 47;
  f$1.RULE_expr = 48;
  f$1.RULE_atom = 49;
  f$1.RULE_parExpr = 50;
  f$1.RULE_condition = 51;
  f$1.RULE_inExpr = 52;
  class o4 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_prog;
    }
    EOF() {
      return this.getToken(f$1.EOF, 0);
    }
    title() {
      return this.getTypedRuleContext(La, 0);
    }
    head() {
      return this.getTypedRuleContext(_a, 0);
    }
    block() {
      return this.getTypedRuleContext(v1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterProg(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitProg(this);
    }
  }
  class La extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_title;
    }
    TITLE() {
      return this.getToken(f$1.TITLE, 0);
    }
    TITLE_CONTENT() {
      return this.getToken(f$1.TITLE_CONTENT, 0);
    }
    TITLE_END() {
      return this.getToken(f$1.TITLE_END, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterTitle(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitTitle(this);
    }
  }
  class _a extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "group", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(Pi) : this.getTypedRuleContext(Pi, n11);
      });
      W$1(this, "participant", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(bs) : this.getTypedRuleContext(bs, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_head;
    }
    starterExp() {
      return this.getTypedRuleContext(ya, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterHead(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitHead(this);
    }
  }
  class Pi extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "participant", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(bs) : this.getTypedRuleContext(bs, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_group;
    }
    GROUP() {
      return this.getToken(f$1.GROUP, 0);
    }
    OBRACE() {
      return this.getToken(f$1.OBRACE, 0);
    }
    CBRACE() {
      return this.getToken(f$1.CBRACE, 0);
    }
    name() {
      return this.getTypedRuleContext(Is, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterGroup(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitGroup(this);
    }
  }
  class ya extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_starterExp;
    }
    STARTER_LXR() {
      return this.getToken(f$1.STARTER_LXR, 0);
    }
    OPAR() {
      return this.getToken(f$1.OPAR, 0);
    }
    CPAR() {
      return this.getToken(f$1.CPAR, 0);
    }
    starter() {
      return this.getTypedRuleContext(Ca, 0);
    }
    ANNOTATION() {
      return this.getToken(f$1.ANNOTATION, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterStarterExp(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitStarterExp(this);
    }
  }
  class Ca extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_starter;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterStarter(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitStarter(this);
    }
  }
  class bs extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_participant;
    }
    name() {
      return this.getTypedRuleContext(Is, 0);
    }
    participantType() {
      return this.getTypedRuleContext(wa, 0);
    }
    stereotype() {
      return this.getTypedRuleContext(va, 0);
    }
    width() {
      return this.getTypedRuleContext(Ea, 0);
    }
    label() {
      return this.getTypedRuleContext(ba, 0);
    }
    COLOR() {
      return this.getToken(f$1.COLOR, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterParticipant(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitParticipant(this);
    }
  }
  class va extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_stereotype;
    }
    SOPEN() {
      return this.getToken(f$1.SOPEN, 0);
    }
    name() {
      return this.getTypedRuleContext(Is, 0);
    }
    SCLOSE() {
      return this.getToken(f$1.SCLOSE, 0);
    }
    GT() {
      return this.getToken(f$1.GT, 0);
    }
    LT() {
      return this.getToken(f$1.LT, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterStereotype(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitStereotype(this);
    }
  }
  class ba extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_label;
    }
    AS() {
      return this.getToken(f$1.AS, 0);
    }
    name() {
      return this.getTypedRuleContext(Is, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterLabel(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitLabel(this);
    }
  }
  class wa extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_participantType;
    }
    ANNOTATION() {
      return this.getToken(f$1.ANNOTATION, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterParticipantType(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitParticipantType(this);
    }
  }
  class Is extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_name;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterName(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitName(this);
    }
  }
  class Ea extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_width;
    }
    INT() {
      return this.getToken(f$1.INT, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterWidth(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitWidth(this);
    }
  }
  class v1 extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "stat", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(Fi) : this.getTypedRuleContext(Fi, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_block;
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterBlock(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitBlock(this);
    }
  }
  class Ta extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_ret;
    }
    RETURN() {
      return this.getToken(f$1.RETURN, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    SCOL() {
      return this.getToken(f$1.SCOL, 0);
    }
    ANNOTATION_RET() {
      return this.getToken(f$1.ANNOTATION_RET, 0);
    }
    asyncMessage() {
      return this.getTypedRuleContext(S1, 0);
    }
    EVENT_END() {
      return this.getToken(f$1.EVENT_END, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterRet(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitRet(this);
    }
  }
  class Sa extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_divider;
    }
    dividerNote() {
      return this.getTypedRuleContext(Aa, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterDivider(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitDivider(this);
    }
  }
  class Aa extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_dividerNote;
    }
    DIVIDER() {
      return this.getToken(f$1.DIVIDER, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterDividerNote(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitDividerNote(this);
    }
  }
  class Fi extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_stat, this._OTHER = null;
    }
    alt() {
      return this.getTypedRuleContext(Va, 0);
    }
    par() {
      return this.getTypedRuleContext(ka, 0);
    }
    opt() {
      return this.getTypedRuleContext(Ra, 0);
    }
    loop() {
      return this.getTypedRuleContext(ja, 0);
    }
    creation() {
      return this.getTypedRuleContext(b1, 0);
    }
    message() {
      return this.getTypedRuleContext(Ia, 0);
    }
    asyncMessage() {
      return this.getTypedRuleContext(S1, 0);
    }
    EVENT_END() {
      return this.getToken(f$1.EVENT_END, 0);
    }
    ret() {
      return this.getTypedRuleContext(Ta, 0);
    }
    divider() {
      return this.getTypedRuleContext(Sa, 0);
    }
    tcf() {
      return this.getTypedRuleContext($a, 0);
    }
    OTHER() {
      return this.getToken(f$1.OTHER, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterStat(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitStat(this);
    }
  }
  class ka extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_par;
    }
    PAR() {
      return this.getToken(f$1.PAR, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterPar(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitPar(this);
    }
  }
  class Ra extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_opt;
    }
    OPT() {
      return this.getToken(f$1.OPT, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterOpt(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitOpt(this);
    }
  }
  class b1 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_creation;
    }
    creationBody() {
      return this.getTypedRuleContext(Oa, 0);
    }
    SCOL() {
      return this.getToken(f$1.SCOL, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterCreation(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitCreation(this);
    }
  }
  class Oa extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_creationBody;
    }
    NEW() {
      return this.getToken(f$1.NEW, 0);
    }
    construct() {
      return this.getTypedRuleContext(Pa, 0);
    }
    assignment() {
      return this.getTypedRuleContext(B0, 0);
    }
    OPAR() {
      return this.getToken(f$1.OPAR, 0);
    }
    CPAR() {
      return this.getToken(f$1.CPAR, 0);
    }
    parameters() {
      return this.getTypedRuleContext(k1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterCreationBody(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitCreationBody(this);
    }
  }
  class Ia extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_message;
    }
    messageBody() {
      return this.getTypedRuleContext(Ma, 0);
    }
    SCOL() {
      return this.getToken(f$1.SCOL, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterMessage(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitMessage(this);
    }
  }
  class Ma extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_messageBody;
    }
    func() {
      return this.getTypedRuleContext(w1, 0);
    }
    assignment() {
      return this.getTypedRuleContext(B0, 0);
    }
    to() {
      return this.getTypedRuleContext(D0, 0);
    }
    DOT() {
      return this.getToken(f$1.DOT, 0);
    }
    from() {
      return this.getTypedRuleContext(E1, 0);
    }
    ARROW() {
      return this.getToken(f$1.ARROW, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterMessageBody(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitMessageBody(this);
    }
  }
  class w1 extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "signature", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(Di) : this.getTypedRuleContext(Di, n11);
      });
      W$1(this, "DOT", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTokens(f$1.DOT) : this.getToken(f$1.DOT, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_func;
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterFunc(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitFunc(this);
    }
  }
  class E1 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_from;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterFrom(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitFrom(this);
    }
  }
  class D0 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_to;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterTo(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitTo(this);
    }
  }
  class Di extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_signature;
    }
    methodName() {
      return this.getTypedRuleContext(Da, 0);
    }
    invocation() {
      return this.getTypedRuleContext(T1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterSignature(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitSignature(this);
    }
  }
  class T1 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_invocation;
    }
    OPAR() {
      return this.getToken(f$1.OPAR, 0);
    }
    CPAR() {
      return this.getToken(f$1.CPAR, 0);
    }
    parameters() {
      return this.getTypedRuleContext(k1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterInvocation(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitInvocation(this);
    }
  }
  class B0 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_assignment;
    }
    assignee() {
      return this.getTypedRuleContext(Fa, 0);
    }
    ASSIGN() {
      return this.getToken(f$1.ASSIGN, 0);
    }
    type() {
      return this.getTypedRuleContext(A1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterAssignment(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitAssignment(this);
    }
  }
  class S1 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_asyncMessage;
    }
    to() {
      return this.getTypedRuleContext(D0, 0);
    }
    COL() {
      return this.getToken(f$1.COL, 0);
    }
    content() {
      return this.getTypedRuleContext(Na, 0);
    }
    from() {
      return this.getTypedRuleContext(E1, 0);
    }
    ARROW() {
      return this.getToken(f$1.ARROW, 0);
    }
    MINUS() {
      return this.getToken(f$1.MINUS, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterAsyncMessage(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitAsyncMessage(this);
    }
  }
  class Na extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_content;
    }
    EVENT_PAYLOAD_LXR() {
      return this.getToken(f$1.EVENT_PAYLOAD_LXR, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterContent(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitContent(this);
    }
  }
  class Pa extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_construct;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterConstruct(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitConstruct(this);
    }
  }
  class A1 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_type;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterType(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitType(this);
    }
  }
  class Fa extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "ID", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTokens(f$1.ID) : this.getToken(f$1.ID, n11);
      });
      W$1(this, "COMMA", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTokens(f$1.COMMA) : this.getToken(f$1.COMMA, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_assignee;
    }
    atom() {
      return this.getTypedRuleContext(Dn, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterAssignee(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitAssignee(this);
    }
  }
  class Da extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_methodName;
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterMethodName(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitMethodName(this);
    }
  }
  class k1 extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "parameter", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(Bi) : this.getTypedRuleContext(Bi, n11);
      });
      W$1(this, "COMMA", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTokens(f$1.COMMA) : this.getToken(f$1.COMMA, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_parameters;
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterParameters(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitParameters(this);
    }
  }
  class Bi extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_parameter;
    }
    declaration() {
      return this.getTypedRuleContext(Ba, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterParameter(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitParameter(this);
    }
  }
  class Ba extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_declaration;
    }
    type() {
      return this.getTypedRuleContext(A1, 0);
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterDeclaration(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitDeclaration(this);
    }
  }
  class $a extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "catchBlock", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts($i) : this.getTypedRuleContext($i, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_tcf;
    }
    tryBlock() {
      return this.getTypedRuleContext(Ha, 0);
    }
    finallyBlock() {
      return this.getTypedRuleContext(Ua, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterTcf(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitTcf(this);
    }
  }
  class Ha extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_tryBlock;
    }
    TRY() {
      return this.getToken(f$1.TRY, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterTryBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitTryBlock(this);
    }
  }
  class $i extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_catchBlock;
    }
    CATCH() {
      return this.getToken(f$1.CATCH, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    invocation() {
      return this.getTypedRuleContext(T1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterCatchBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitCatchBlock(this);
    }
  }
  class Ua extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_finallyBlock;
    }
    FINALLY() {
      return this.getToken(f$1.FINALLY, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterFinallyBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitFinallyBlock(this);
    }
  }
  class Va extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "elseIfBlock", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(Hi) : this.getTypedRuleContext(Hi, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_alt;
    }
    ifBlock() {
      return this.getTypedRuleContext(za, 0);
    }
    elseBlock() {
      return this.getTypedRuleContext(Ga, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterAlt(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitAlt(this);
    }
  }
  class za extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_ifBlock;
    }
    IF() {
      return this.getToken(f$1.IF, 0);
    }
    parExpr() {
      return this.getTypedRuleContext($0, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterIfBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitIfBlock(this);
    }
  }
  class Hi extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_elseIfBlock;
    }
    ELSE() {
      return this.getToken(f$1.ELSE, 0);
    }
    IF() {
      return this.getToken(f$1.IF, 0);
    }
    parExpr() {
      return this.getTypedRuleContext($0, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterElseIfBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitElseIfBlock(this);
    }
  }
  class Ga extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_elseBlock;
    }
    ELSE() {
      return this.getToken(f$1.ELSE, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterElseBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitElseBlock(this);
    }
  }
  let tn$1 = class tn extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_braceBlock;
    }
    OBRACE() {
      return this.getToken(f$1.OBRACE, 0);
    }
    CBRACE() {
      return this.getToken(f$1.CBRACE, 0);
    }
    block() {
      return this.getTypedRuleContext(v1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterBraceBlock(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitBraceBlock(this);
    }
  };
  class ja extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_loop;
    }
    WHILE() {
      return this.getToken(f$1.WHILE, 0);
    }
    parExpr() {
      return this.getTypedRuleContext($0, 0);
    }
    braceBlock() {
      return this.getTypedRuleContext(tn$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterLoop(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitLoop(this);
    }
  }
  let ye$1 = class ye extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_expr;
    }
    copyFrom(e10) {
      super.copyFrom(e10);
    }
  };
  class l4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    assignment() {
      return this.getTypedRuleContext(B0, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterAssignmentExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitAssignmentExpr(this);
    }
  }
  f$1.AssignmentExprContext = l4;
  class a4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    func() {
      return this.getTypedRuleContext(w1, 0);
    }
    to() {
      return this.getTypedRuleContext(D0, 0);
    }
    DOT() {
      return this.getToken(f$1.DOT, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterFuncExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitFuncExpr(this);
    }
  }
  f$1.FuncExprContext = a4;
  class c4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    atom() {
      return this.getTypedRuleContext(Dn, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterAtomExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitAtomExpr(this);
    }
  }
  f$1.AtomExprContext = c4;
  class u4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      super.copyFrom(r10);
    }
    OR() {
      return this.getToken(f$1.OR, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterOrExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitOrExpr(this);
    }
  }
  f$1.OrExprContext = u4;
  class h4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      this.op = null, super.copyFrom(r10);
    }
    PLUS() {
      return this.getToken(f$1.PLUS, 0);
    }
    MINUS() {
      return this.getToken(f$1.MINUS, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterAdditiveExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitAdditiveExpr(this);
    }
  }
  f$1.AdditiveExprContext = h4;
  class d4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      this.op = null, super.copyFrom(r10);
    }
    LTEQ() {
      return this.getToken(f$1.LTEQ, 0);
    }
    GTEQ() {
      return this.getToken(f$1.GTEQ, 0);
    }
    LT() {
      return this.getToken(f$1.LT, 0);
    }
    GT() {
      return this.getToken(f$1.GT, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterRelationalExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitRelationalExpr(this);
    }
  }
  f$1.RelationalExprContext = d4;
  class f4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      super.copyFrom(r10);
    }
    PLUS() {
      return this.getToken(f$1.PLUS, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterPlusExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitPlusExpr(this);
    }
  }
  f$1.PlusExprContext = f4;
  class p4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    NOT() {
      return this.getToken(f$1.NOT, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterNotExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitNotExpr(this);
    }
  }
  f$1.NotExprContext = p4;
  class g4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    MINUS() {
      return this.getToken(f$1.MINUS, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterUnaryMinusExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitUnaryMinusExpr(this);
    }
  }
  f$1.UnaryMinusExprContext = g4;
  class m4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    creation() {
      return this.getTypedRuleContext(b1, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterCreationExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitCreationExpr(this);
    }
  }
  f$1.CreationExprContext = m4;
  class x4 extends ye$1 {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    OPAR() {
      return this.getToken(f$1.OPAR, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    CPAR() {
      return this.getToken(f$1.CPAR, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterParenthesizedExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitParenthesizedExpr(this);
    }
  }
  f$1.ParenthesizedExprContext = x4;
  class L4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      this.op = null, super.copyFrom(r10);
    }
    MULT() {
      return this.getToken(f$1.MULT, 0);
    }
    DIV() {
      return this.getToken(f$1.DIV, 0);
    }
    MOD() {
      return this.getToken(f$1.MOD, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterMultiplicationExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitMultiplicationExpr(this);
    }
  }
  f$1.MultiplicationExprContext = L4;
  class _4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      this.op = null, super.copyFrom(r10);
    }
    EQ() {
      return this.getToken(f$1.EQ, 0);
    }
    NEQ() {
      return this.getToken(f$1.NEQ, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterEqualityExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitEqualityExpr(this);
    }
  }
  f$1.EqualityExprContext = _4;
  class y4 extends ye$1 {
    constructor(n10, r10) {
      super(n10);
      W$1(this, "expr", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTypedRuleContexts(ye$1) : this.getTypedRuleContext(ye$1, n11);
      });
      super.copyFrom(r10);
    }
    AND() {
      return this.getToken(f$1.AND, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterAndExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitAndExpr(this);
    }
  }
  f$1.AndExprContext = y4;
  class Dn extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_atom;
    }
    copyFrom(e10) {
      super.copyFrom(e10);
    }
  }
  class C4 extends Dn {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    TRUE() {
      return this.getToken(f$1.TRUE, 0);
    }
    FALSE() {
      return this.getToken(f$1.FALSE, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterBooleanAtom(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitBooleanAtom(this);
    }
  }
  f$1.BooleanAtomContext = C4;
  class v4 extends Dn {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    ID() {
      return this.getToken(f$1.ID, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterIdAtom(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitIdAtom(this);
    }
  }
  f$1.IdAtomContext = v4;
  class b4 extends Dn {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    STRING() {
      return this.getToken(f$1.STRING, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterStringAtom(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitStringAtom(this);
    }
  }
  f$1.StringAtomContext = b4;
  class w4 extends Dn {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    NIL() {
      return this.getToken(f$1.NIL, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterNilAtom(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitNilAtom(this);
    }
  }
  f$1.NilAtomContext = w4;
  class E4 extends Dn {
    constructor(e10, n10) {
      super(e10), super.copyFrom(n10);
    }
    INT() {
      return this.getToken(f$1.INT, 0);
    }
    FLOAT() {
      return this.getToken(f$1.FLOAT, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterNumberAtom(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitNumberAtom(this);
    }
  }
  f$1.NumberAtomContext = E4;
  class $0 extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_parExpr;
    }
    OPAR() {
      return this.getToken(f$1.OPAR, 0);
    }
    condition() {
      return this.getTypedRuleContext(Za, 0);
    }
    CPAR() {
      return this.getToken(f$1.CPAR, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterParExpr(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitParExpr(this);
    }
  }
  class Za extends b.ParserRuleContext {
    constructor(e10, n10, r10) {
      n10 === void 0 && (n10 = null), r10 == null && (r10 = -1), super(n10, r10), this.parser = e10, this.ruleIndex = f$1.RULE_condition;
    }
    atom() {
      return this.getTypedRuleContext(Dn, 0);
    }
    expr() {
      return this.getTypedRuleContext(ye$1, 0);
    }
    inExpr() {
      return this.getTypedRuleContext(Wa, 0);
    }
    enterRule(e10) {
      e10 instanceof w && e10.enterCondition(this);
    }
    exitRule(e10) {
      e10 instanceof w && e10.exitCondition(this);
    }
  }
  class Wa extends b.ParserRuleContext {
    constructor(n10, r10, s10) {
      r10 === void 0 && (r10 = null), s10 == null && (s10 = -1);
      super(r10, s10);
      W$1(this, "ID", function(n11) {
        return n11 === void 0 && (n11 = null), n11 === null ? this.getTokens(f$1.ID) : this.getToken(f$1.ID, n11);
      });
      this.parser = n10, this.ruleIndex = f$1.RULE_inExpr;
    }
    IN() {
      return this.getToken(f$1.IN, 0);
    }
    enterRule(n10) {
      n10 instanceof w && n10.enterInExpr(this);
    }
    exitRule(n10) {
      n10 instanceof w && n10.exitInExpr(this);
    }
  }
  f$1.ProgContext = o4;
  f$1.TitleContext = La;
  f$1.HeadContext = _a;
  f$1.GroupContext = Pi;
  f$1.StarterExpContext = ya;
  f$1.StarterContext = Ca;
  f$1.ParticipantContext = bs;
  f$1.StereotypeContext = va;
  f$1.LabelContext = ba;
  f$1.ParticipantTypeContext = wa;
  f$1.NameContext = Is;
  f$1.WidthContext = Ea;
  f$1.BlockContext = v1;
  f$1.RetContext = Ta;
  f$1.DividerContext = Sa;
  f$1.DividerNoteContext = Aa;
  f$1.StatContext = Fi;
  f$1.ParContext = ka;
  f$1.OptContext = Ra;
  f$1.CreationContext = b1;
  f$1.CreationBodyContext = Oa;
  f$1.MessageContext = Ia;
  f$1.MessageBodyContext = Ma;
  f$1.FuncContext = w1;
  f$1.FromContext = E1;
  f$1.ToContext = D0;
  f$1.SignatureContext = Di;
  f$1.InvocationContext = T1;
  f$1.AssignmentContext = B0;
  f$1.AsyncMessageContext = S1;
  f$1.ContentContext = Na;
  f$1.ConstructContext = Pa;
  f$1.TypeContext = A1;
  f$1.AssigneeContext = Fa;
  f$1.MethodNameContext = Da;
  f$1.ParametersContext = k1;
  f$1.ParameterContext = Bi;
  f$1.DeclarationContext = Ba;
  f$1.TcfContext = $a;
  f$1.TryBlockContext = Ha;
  f$1.CatchBlockContext = $i;
  f$1.FinallyBlockContext = Ua;
  f$1.AltContext = Va;
  f$1.IfBlockContext = za;
  f$1.ElseIfBlockContext = Hi;
  f$1.ElseBlockContext = Ga;
  f$1.BraceBlockContext = tn$1;
  f$1.LoopContext = ja;
  f$1.ExprContext = ye$1;
  f$1.AtomContext = Dn;
  f$1.ParExprContext = $0;
  f$1.ConditionContext = Za;
  f$1.InExprContext = Wa;
  function $7() {
    this.__data__ = [], this.size = 0;
  }
  var H7 = $7;
  function U7(t10, e10) {
    return t10 === e10 || t10 !== t10 && e10 !== e10;
  }
  var R1 = U7, V7 = R1;
  function z7(t10, e10) {
    for (var n10 = t10.length; n10--; )
      if (V7(t10[n10][0], e10))
        return n10;
    return -1;
  }
  var O1 = z7, G7 = O1, j7 = Array.prototype, Z7 = j7.splice;
  function W7(t10) {
    var e10 = this.__data__, n10 = G7(e10, t10);
    if (n10 < 0)
      return false;
    var r10 = e10.length - 1;
    return n10 == r10 ? e10.pop() : Z7.call(e10, n10, 1), --this.size, true;
  }
  var q7 = W7, K7 = O1;
  function Y7(t10) {
    var e10 = this.__data__, n10 = K7(e10, t10);
    return n10 < 0 ? void 0 : e10[n10][1];
  }
  var X7 = Y7, Q7 = O1;
  function J7(t10) {
    return Q7(this.__data__, t10) > -1;
  }
  var ep = J7, tp = O1;
  function np(t10, e10) {
    var n10 = this.__data__, r10 = tp(n10, t10);
    return r10 < 0 ? (++this.size, n10.push([t10, e10])) : n10[r10][1] = e10, this;
  }
  var rp = np, sp = H7, ip = q7, op = X7, lp = ep, ap = rp;
  function Ms(t10) {
    var e10 = -1, n10 = t10 == null ? 0 : t10.length;
    for (this.clear(); ++e10 < n10; ) {
      var r10 = t10[e10];
      this.set(r10[0], r10[1]);
    }
  }
  Ms.prototype.clear = sp;
  Ms.prototype.delete = ip;
  Ms.prototype.get = op;
  Ms.prototype.has = lp;
  Ms.prototype.set = ap;
  var I1 = Ms, cp = I1;
  function up() {
    this.__data__ = new cp(), this.size = 0;
  }
  var hp = up;
  function dp(t10) {
    var e10 = this.__data__, n10 = e10.delete(t10);
    return this.size = e10.size, n10;
  }
  var fp = dp;
  function pp(t10) {
    return this.__data__.get(t10);
  }
  var gp = pp;
  function mp(t10) {
    return this.__data__.has(t10);
  }
  var xp = mp, Lp = Wr, _p = Lp.Symbol, T4 = _p, R2 = T4, S4 = Object.prototype, yp = S4.hasOwnProperty, Cp = S4.toString, Gs = R2 ? R2.toStringTag : void 0;
  function vp(t10) {
    var e10 = yp.call(t10, Gs), n10 = t10[Gs];
    try {
      t10[Gs] = void 0;
      var r10 = true;
    } catch {
    }
    var s10 = Cp.call(t10);
    return r10 && (e10 ? t10[Gs] = n10 : delete t10[Gs]), s10;
  }
  var bp = vp, wp = Object.prototype, Ep = wp.toString;
  function Tp(t10) {
    return Ep.call(t10);
  }
  var Sp = Tp, O2 = T4, Ap = bp, kp = Sp, Rp = "[object Null]", Op = "[object Undefined]", I2 = O2 ? O2.toStringTag : void 0;
  function Ip(t10) {
    return t10 == null ? t10 === void 0 ? Op : Rp : I2 && I2 in Object(t10) ? Ap(t10) : kp(t10);
  }
  var M1 = Ip;
  function Mp(t10) {
    var e10 = typeof t10;
    return t10 != null && (e10 == "object" || e10 == "function");
  }
  var qr = Mp, Np = M1, Pp = qr, Fp = "[object AsyncFunction]", Dp = "[object Function]", Bp = "[object GeneratorFunction]", $p = "[object Proxy]";
  function Hp(t10) {
    if (!Pp(t10))
      return false;
    var e10 = Np(t10);
    return e10 == Dp || e10 == Bp || e10 == Fp || e10 == $p;
  }
  var qa = Hp, Up = Wr, Vp = Up["__core-js_shared__"], zp = Vp, lo = zp, M2 = function() {
    var t10 = /[^.]+$/.exec(lo && lo.keys && lo.keys.IE_PROTO || "");
    return t10 ? "Symbol(src)_1." + t10 : "";
  }();
  function Gp(t10) {
    return !!M2 && M2 in t10;
  }
  var jp = Gp, Zp = Function.prototype, Wp = Zp.toString;
  function qp(t10) {
    if (t10 != null) {
      try {
        return Wp.call(t10);
      } catch {
      }
      try {
        return t10 + "";
      } catch {
      }
    }
    return "";
  }
  var Kp = qp, Yp = qa, Xp = jp, Qp = qr, Jp = Kp, eg = /[\\^$.*+?()[\]{}|]/g, tg = /^\[object .+?Constructor\]$/, ng = Function.prototype, rg = Object.prototype, sg = ng.toString, ig = rg.hasOwnProperty, og = RegExp(
    "^" + sg.call(ig).replace(eg, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function lg(t10) {
    if (!Qp(t10) || Xp(t10))
      return false;
    var e10 = Yp(t10) ? og : tg;
    return e10.test(Jp(t10));
  }
  var ag = lg;
  function cg(t10, e10) {
    return t10 == null ? void 0 : t10[e10];
  }
  var ug = cg, hg = ag, dg = ug;
  function fg(t10, e10) {
    var n10 = dg(t10, e10);
    return hg(n10) ? n10 : void 0;
  }
  var Ka = fg, pg = Ka, gg = Wr, mg = pg(gg, "Map"), A4 = mg, xg = Ka, Lg = xg(Object, "create"), N1 = Lg, N2 = N1;
  function _g() {
    this.__data__ = N2 ? N2(null) : {}, this.size = 0;
  }
  var yg = _g;
  function Cg(t10) {
    var e10 = this.has(t10) && delete this.__data__[t10];
    return this.size -= e10 ? 1 : 0, e10;
  }
  var vg = Cg, bg = N1, wg = "__lodash_hash_undefined__", Eg = Object.prototype, Tg = Eg.hasOwnProperty;
  function Sg(t10) {
    var e10 = this.__data__;
    if (bg) {
      var n10 = e10[t10];
      return n10 === wg ? void 0 : n10;
    }
    return Tg.call(e10, t10) ? e10[t10] : void 0;
  }
  var Ag = Sg, kg = N1, Rg = Object.prototype, Og = Rg.hasOwnProperty;
  function Ig(t10) {
    var e10 = this.__data__;
    return kg ? e10[t10] !== void 0 : Og.call(e10, t10);
  }
  var Mg = Ig, Ng = N1, Pg = "__lodash_hash_undefined__";
  function Fg(t10, e10) {
    var n10 = this.__data__;
    return this.size += this.has(t10) ? 0 : 1, n10[t10] = Ng && e10 === void 0 ? Pg : e10, this;
  }
  var Dg = Fg, Bg = yg, $g = vg, Hg = Ag, Ug = Mg, Vg = Dg;
  function Ns(t10) {
    var e10 = -1, n10 = t10 == null ? 0 : t10.length;
    for (this.clear(); ++e10 < n10; ) {
      var r10 = t10[e10];
      this.set(r10[0], r10[1]);
    }
  }
  Ns.prototype.clear = Bg;
  Ns.prototype.delete = $g;
  Ns.prototype.get = Hg;
  Ns.prototype.has = Ug;
  Ns.prototype.set = Vg;
  var zg = Ns, P2 = zg, Gg = I1, jg = A4;
  function Zg() {
    this.size = 0, this.__data__ = {
      hash: new P2(),
      map: new (jg || Gg)(),
      string: new P2()
    };
  }
  var Wg = Zg;
  function qg(t10) {
    var e10 = typeof t10;
    return e10 == "string" || e10 == "number" || e10 == "symbol" || e10 == "boolean" ? t10 !== "__proto__" : t10 === null;
  }
  var Kg = qg, Yg = Kg;
  function Xg(t10, e10) {
    var n10 = t10.__data__;
    return Yg(e10) ? n10[typeof e10 == "string" ? "string" : "hash"] : n10.map;
  }
  var P1 = Xg, Qg = P1;
  function Jg(t10) {
    var e10 = Qg(this, t10).delete(t10);
    return this.size -= e10 ? 1 : 0, e10;
  }
  var em = Jg, tm = P1;
  function nm(t10) {
    return tm(this, t10).get(t10);
  }
  var rm = nm, sm = P1;
  function im(t10) {
    return sm(this, t10).has(t10);
  }
  var om = im, lm = P1;
  function am(t10, e10) {
    var n10 = lm(this, t10), r10 = n10.size;
    return n10.set(t10, e10), this.size += n10.size == r10 ? 0 : 1, this;
  }
  var cm = am, um = Wg, hm = em, dm = rm, fm = om, pm = cm;
  function Ps(t10) {
    var e10 = -1, n10 = t10 == null ? 0 : t10.length;
    for (this.clear(); ++e10 < n10; ) {
      var r10 = t10[e10];
      this.set(r10[0], r10[1]);
    }
  }
  Ps.prototype.clear = um;
  Ps.prototype.delete = hm;
  Ps.prototype.get = dm;
  Ps.prototype.has = fm;
  Ps.prototype.set = pm;
  var gm = Ps, mm = I1, xm = A4, Lm = gm, _m = 200;
  function ym(t10, e10) {
    var n10 = this.__data__;
    if (n10 instanceof mm) {
      var r10 = n10.__data__;
      if (!xm || r10.length < _m - 1)
        return r10.push([t10, e10]), this.size = ++n10.size, this;
      n10 = this.__data__ = new Lm(r10);
    }
    return n10.set(t10, e10), this.size = n10.size, this;
  }
  var Cm = ym, vm = I1, bm = hp, wm = fp, Em = gp, Tm = xp, Sm = Cm;
  function Fs(t10) {
    var e10 = this.__data__ = new vm(t10);
    this.size = e10.size;
  }
  Fs.prototype.clear = bm;
  Fs.prototype.delete = wm;
  Fs.prototype.get = Em;
  Fs.prototype.has = Tm;
  Fs.prototype.set = Sm;
  var Am = Fs, km = Ka, Rm = function() {
    try {
      var t10 = km(Object, "defineProperty");
      return t10({}, "", {}), t10;
    } catch {
    }
  }(), k4 = Rm, F2 = k4;
  function Om(t10, e10, n10) {
    e10 == "__proto__" && F2 ? F2(t10, e10, {
      configurable: true,
      enumerable: true,
      value: n10,
      writable: true
    }) : t10[e10] = n10;
  }
  var Ya = Om, Im = Ya, Mm = R1;
  function Nm(t10, e10, n10) {
    (n10 !== void 0 && !Mm(t10[e10], n10) || n10 === void 0 && !(e10 in t10)) && Im(t10, e10, n10);
  }
  var R4 = Nm;
  function Pm(t10) {
    return function(e10, n10, r10) {
      for (var s10 = -1, i10 = Object(e10), o10 = r10(e10), l10 = o10.length; l10--; ) {
        var a10 = o10[t10 ? l10 : ++s10];
        if (n10(i10[a10], a10, i10) === false)
          break;
      }
      return e10;
    };
  }
  var Fm = Pm, Dm = Fm, Bm = Dm(), $m = Bm, Jo = { exports: {} };
  (function(t10, e10) {
    var n10 = Wr, r10 = e10 && !e10.nodeType && e10, s10 = r10 && true && t10 && !t10.nodeType && t10, i10 = s10 && s10.exports === r10, o10 = i10 ? n10.Buffer : void 0, l10 = o10 ? o10.allocUnsafe : void 0;
    function a10(c10, u10) {
      if (u10)
        return c10.slice();
      var h10 = c10.length, d10 = l10 ? l10(h10) : new c10.constructor(h10);
      return c10.copy(d10), d10;
    }
    t10.exports = a10;
  })(Jo, Jo.exports);
  var Hm = Wr, Um = Hm.Uint8Array, Vm = Um, D2 = Vm;
  function zm(t10) {
    var e10 = new t10.constructor(t10.byteLength);
    return new D2(e10).set(new D2(t10)), e10;
  }
  var Gm = zm, jm = Gm;
  function Zm(t10, e10) {
    var n10 = e10 ? jm(t10.buffer) : t10.buffer;
    return new t10.constructor(n10, t10.byteOffset, t10.length);
  }
  var Wm = Zm;
  function qm(t10, e10) {
    var n10 = -1, r10 = t10.length;
    for (e10 || (e10 = Array(r10)); ++n10 < r10; )
      e10[n10] = t10[n10];
    return e10;
  }
  var Km = qm, Ym = qr, B2 = Object.create, Xm = function() {
    function t10() {
    }
    return function(e10) {
      if (!Ym(e10))
        return {};
      if (B2)
        return B2(e10);
      t10.prototype = e10;
      var n10 = new t10();
      return t10.prototype = void 0, n10;
    };
  }(), Qm = Xm;
  function Jm(t10, e10) {
    return function(n10) {
      return t10(e10(n10));
    };
  }
  var ex = Jm, tx = ex, nx = tx(Object.getPrototypeOf, Object), O4 = nx, rx = Object.prototype;
  function sx(t10) {
    var e10 = t10 && t10.constructor, n10 = typeof e10 == "function" && e10.prototype || rx;
    return t10 === n10;
  }
  var I4 = sx, ix = Qm, ox = O4, lx = I4;
  function ax(t10) {
    return typeof t10.constructor == "function" && !lx(t10) ? ix(ox(t10)) : {};
  }
  var cx = ax;
  function ux(t10) {
    return t10 != null && typeof t10 == "object";
  }
  var H0 = ux, hx = M1, dx = H0, fx = "[object Arguments]";
  function px(t10) {
    return dx(t10) && hx(t10) == fx;
  }
  var gx = px, $2 = gx, mx = H0, M4 = Object.prototype, xx = M4.hasOwnProperty, Lx = M4.propertyIsEnumerable, _x = $2(function() {
    return arguments;
  }()) ? $2 : function(t10) {
    return mx(t10) && xx.call(t10, "callee") && !Lx.call(t10, "callee");
  }, N4 = _x, yx = Array.isArray, P4 = yx, Cx = 9007199254740991;
  function vx(t10) {
    return typeof t10 == "number" && t10 > -1 && t10 % 1 == 0 && t10 <= Cx;
  }
  var F4 = vx, bx = qa, wx = F4;
  function Ex(t10) {
    return t10 != null && wx(t10.length) && !bx(t10);
  }
  var Xa = Ex, Tx = Xa, Sx = H0;
  function Ax(t10) {
    return Sx(t10) && Tx(t10);
  }
  var kx = Ax, Ui = { exports: {} };
  function Rx() {
    return false;
  }
  var Ox = Rx;
  (function(t10, e10) {
    var n10 = Wr, r10 = Ox, s10 = e10 && !e10.nodeType && e10, i10 = s10 && true && t10 && !t10.nodeType && t10, o10 = i10 && i10.exports === s10, l10 = o10 ? n10.Buffer : void 0, a10 = l10 ? l10.isBuffer : void 0, c10 = a10 || r10;
    t10.exports = c10;
  })(Ui, Ui.exports);
  var Ix = M1, Mx = O4, Nx = H0, Px = "[object Object]", Fx = Function.prototype, Dx = Object.prototype, D4 = Fx.toString, Bx = Dx.hasOwnProperty, $x = D4.call(Object);
  function Hx(t10) {
    if (!Nx(t10) || Ix(t10) != Px)
      return false;
    var e10 = Mx(t10);
    if (e10 === null)
      return true;
    var n10 = Bx.call(e10, "constructor") && e10.constructor;
    return typeof n10 == "function" && n10 instanceof n10 && D4.call(n10) == $x;
  }
  var Ux = Hx, Vx = M1, zx = F4, Gx = H0, jx = "[object Arguments]", Zx = "[object Array]", Wx = "[object Boolean]", qx = "[object Date]", Kx = "[object Error]", Yx = "[object Function]", Xx = "[object Map]", Qx = "[object Number]", Jx = "[object Object]", eL = "[object RegExp]", tL = "[object Set]", nL = "[object String]", rL = "[object WeakMap]", sL = "[object ArrayBuffer]", iL = "[object DataView]", oL = "[object Float32Array]", lL = "[object Float64Array]", aL = "[object Int8Array]", cL = "[object Int16Array]", uL = "[object Int32Array]", hL = "[object Uint8Array]", dL = "[object Uint8ClampedArray]", fL = "[object Uint16Array]", pL = "[object Uint32Array]", qe$1 = {};
  qe$1[oL] = qe$1[lL] = qe$1[aL] = qe$1[cL] = qe$1[uL] = qe$1[hL] = qe$1[dL] = qe$1[fL] = qe$1[pL] = true;
  qe$1[jx] = qe$1[Zx] = qe$1[sL] = qe$1[Wx] = qe$1[iL] = qe$1[qx] = qe$1[Kx] = qe$1[Yx] = qe$1[Xx] = qe$1[Qx] = qe$1[Jx] = qe$1[eL] = qe$1[tL] = qe$1[nL] = qe$1[rL] = false;
  function gL(t10) {
    return Gx(t10) && zx(t10.length) && !!qe$1[Vx(t10)];
  }
  var mL = gL;
  function xL(t10) {
    return function(e10) {
      return t10(e10);
    };
  }
  var LL = xL, el = { exports: {} };
  (function(t10, e10) {
    var n10 = z5, r10 = e10 && !e10.nodeType && e10, s10 = r10 && true && t10 && !t10.nodeType && t10, i10 = s10 && s10.exports === r10, o10 = i10 && n10.process, l10 = function() {
      try {
        var a10 = s10 && s10.require && s10.require("util").types;
        return a10 || o10 && o10.binding && o10.binding("util");
      } catch {
      }
    }();
    t10.exports = l10;
  })(el, el.exports);
  var _L = mL, yL = LL, H2 = el.exports, U2 = H2 && H2.isTypedArray, CL = U2 ? yL(U2) : _L, B4 = CL;
  function vL(t10, e10) {
    if (!(e10 === "constructor" && typeof t10[e10] == "function") && e10 != "__proto__")
      return t10[e10];
  }
  var $4 = vL, bL = Ya, wL = R1, EL = Object.prototype, TL = EL.hasOwnProperty;
  function SL(t10, e10, n10) {
    var r10 = t10[e10];
    (!(TL.call(t10, e10) && wL(r10, n10)) || n10 === void 0 && !(e10 in t10)) && bL(t10, e10, n10);
  }
  var AL = SL, kL = AL, RL = Ya;
  function OL(t10, e10, n10, r10) {
    var s10 = !n10;
    n10 || (n10 = {});
    for (var i10 = -1, o10 = e10.length; ++i10 < o10; ) {
      var l10 = e10[i10], a10 = r10 ? r10(n10[l10], t10[l10], l10, n10, t10) : void 0;
      a10 === void 0 && (a10 = t10[l10]), s10 ? RL(n10, l10, a10) : kL(n10, l10, a10);
    }
    return n10;
  }
  var IL = OL;
  function ML(t10, e10) {
    for (var n10 = -1, r10 = Array(t10); ++n10 < t10; )
      r10[n10] = e10(n10);
    return r10;
  }
  var NL = ML, PL = 9007199254740991, FL = /^(?:0|[1-9]\d*)$/;
  function DL(t10, e10) {
    var n10 = typeof t10;
    return e10 = e10 == null ? PL : e10, !!e10 && (n10 == "number" || n10 != "symbol" && FL.test(t10)) && t10 > -1 && t10 % 1 == 0 && t10 < e10;
  }
  var H4 = DL, BL = NL, $L = N4, HL = P4, UL = Ui.exports, VL = H4, zL = B4, GL = Object.prototype, jL = GL.hasOwnProperty;
  function ZL(t10, e10) {
    var n10 = HL(t10), r10 = !n10 && $L(t10), s10 = !n10 && !r10 && UL(t10), i10 = !n10 && !r10 && !s10 && zL(t10), o10 = n10 || r10 || s10 || i10, l10 = o10 ? BL(t10.length, String) : [], a10 = l10.length;
    for (var c10 in t10)
      (e10 || jL.call(t10, c10)) && !(o10 && (c10 == "length" || s10 && (c10 == "offset" || c10 == "parent") || i10 && (c10 == "buffer" || c10 == "byteLength" || c10 == "byteOffset") || VL(c10, a10))) && l10.push(c10);
    return l10;
  }
  var WL = ZL;
  function qL(t10) {
    var e10 = [];
    if (t10 != null)
      for (var n10 in Object(t10))
        e10.push(n10);
    return e10;
  }
  var KL = qL, YL = qr, XL = I4, QL = KL, JL = Object.prototype, e_ = JL.hasOwnProperty;
  function t_(t10) {
    if (!YL(t10))
      return QL(t10);
    var e10 = XL(t10), n10 = [];
    for (var r10 in t10)
      r10 == "constructor" && (e10 || !e_.call(t10, r10)) || n10.push(r10);
    return n10;
  }
  var n_ = t_, r_ = WL, s_ = n_, i_ = Xa;
  function o_(t10) {
    return i_(t10) ? r_(t10, true) : s_(t10);
  }
  var U4 = o_, l_ = IL, a_ = U4;
  function c_(t10) {
    return l_(t10, a_(t10));
  }
  var u_ = c_, V2 = R4, h_ = Jo.exports, d_ = Wm, f_ = Km, p_ = cx, z2 = N4, G2 = P4, g_ = kx, m_ = Ui.exports, x_ = qa, L_ = qr, __ = Ux, y_ = B4, j2 = $4, C_ = u_;
  function v_(t10, e10, n10, r10, s10, i10, o10) {
    var l10 = j2(t10, n10), a10 = j2(e10, n10), c10 = o10.get(a10);
    if (c10) {
      V2(t10, n10, c10);
      return;
    }
    var u10 = i10 ? i10(l10, a10, n10 + "", t10, e10, o10) : void 0, h10 = u10 === void 0;
    if (h10) {
      var d10 = G2(a10), p10 = !d10 && m_(a10), g = !d10 && !p10 && y_(a10);
      u10 = a10, d10 || p10 || g ? G2(l10) ? u10 = l10 : g_(l10) ? u10 = f_(l10) : p10 ? (h10 = false, u10 = h_(a10, true)) : g ? (h10 = false, u10 = d_(a10, true)) : u10 = [] : __(a10) || z2(a10) ? (u10 = l10, z2(l10) ? u10 = C_(l10) : (!L_(l10) || x_(l10)) && (u10 = p_(a10))) : h10 = false;
    }
    h10 && (o10.set(a10, u10), s10(u10, a10, r10, i10, o10), o10.delete(a10)), V2(t10, n10, u10);
  }
  var b_ = v_, w_ = Am, E_ = R4, T_ = $m, S_ = b_, A_ = qr, k_ = U4, R_ = $4;
  function V4(t10, e10, n10, r10, s10) {
    t10 !== e10 && T_(e10, function(i10, o10) {
      if (s10 || (s10 = new w_()), A_(i10))
        S_(t10, e10, o10, n10, V4, r10, s10);
      else {
        var l10 = r10 ? r10(R_(t10, o10), i10, o10 + "", t10, e10, s10) : void 0;
        l10 === void 0 && (l10 = i10), E_(t10, o10, l10);
      }
    }, k_);
  }
  var O_ = V4;
  function I_(t10) {
    return t10;
  }
  var z4 = I_;
  function M_(t10, e10, n10) {
    switch (n10.length) {
      case 0:
        return t10.call(e10);
      case 1:
        return t10.call(e10, n10[0]);
      case 2:
        return t10.call(e10, n10[0], n10[1]);
      case 3:
        return t10.call(e10, n10[0], n10[1], n10[2]);
    }
    return t10.apply(e10, n10);
  }
  var N_ = M_, P_ = N_, Z2 = Math.max;
  function F_(t10, e10, n10) {
    return e10 = Z2(e10 === void 0 ? t10.length - 1 : e10, 0), function() {
      for (var r10 = arguments, s10 = -1, i10 = Z2(r10.length - e10, 0), o10 = Array(i10); ++s10 < i10; )
        o10[s10] = r10[e10 + s10];
      s10 = -1;
      for (var l10 = Array(e10 + 1); ++s10 < e10; )
        l10[s10] = r10[s10];
      return l10[e10] = n10(o10), P_(t10, this, l10);
    };
  }
  var D_ = F_;
  function B_(t10) {
    return function() {
      return t10;
    };
  }
  var $_ = B_, H_ = $_, W2 = k4, U_ = z4, V_ = W2 ? function(t10, e10) {
    return W2(t10, "toString", {
      configurable: true,
      enumerable: false,
      value: H_(e10),
      writable: true
    });
  } : U_, z_ = V_, G_ = 800, j_ = 16, Z_ = Date.now;
  function W_(t10) {
    var e10 = 0, n10 = 0;
    return function() {
      var r10 = Z_(), s10 = j_ - (r10 - n10);
      if (n10 = r10, s10 > 0) {
        if (++e10 >= G_)
          return arguments[0];
      } else
        e10 = 0;
      return t10.apply(void 0, arguments);
    };
  }
  var q_ = W_, K_ = z_, Y_ = q_, X_ = Y_(K_), Q_ = X_, J_ = z4, ey = D_, ty = Q_;
  function ny(t10, e10) {
    return ty(ey(t10, e10, J_), t10 + "");
  }
  var ry = ny, sy = R1, iy = Xa, oy = H4, ly = qr;
  function ay(t10, e10, n10) {
    if (!ly(n10))
      return false;
    var r10 = typeof e10;
    return (r10 == "number" ? iy(n10) && oy(e10, n10.length) : r10 == "string" && e10 in n10) ? sy(n10[e10], t10) : false;
  }
  var cy = ay, uy = ry, hy = cy;
  function dy(t10) {
    return uy(function(e10, n10) {
      var r10 = -1, s10 = n10.length, i10 = s10 > 1 ? n10[s10 - 1] : void 0, o10 = s10 > 2 ? n10[2] : void 0;
      for (i10 = t10.length > 3 && typeof i10 == "function" ? (s10--, i10) : void 0, o10 && hy(n10[0], n10[1], o10) && (i10 = s10 < 3 ? void 0 : i10, s10 = 1), e10 = Object(e10); ++r10 < s10; ) {
        var l10 = n10[r10];
        l10 && t10(e10, l10, r10, i10);
      }
      return e10;
    });
  }
  var fy = dy, py = O_, gy = fy, my = gy(function(t10, e10, n10, r10) {
    py(t10, e10, n10, r10);
  }), xy = my;
  class Ly {
    constructor(e10, n10, r10, s10, i10, o10, l10, a10, c10, u10) {
      W$1(this, "name");
      W$1(this, "stereotype");
      W$1(this, "width");
      W$1(this, "groupId");
      W$1(this, "explicit");
      W$1(this, "isStarter");
      W$1(this, "label");
      W$1(this, "type");
      W$1(this, "color");
      W$1(this, "comment");
      this.name = e10, this.stereotype = r10, this.width = s10, this.groupId = i10, this.explicit = l10, this.isStarter = n10, this.label = o10, this.type = a10, this.color = c10, this.comment = u10;
    }
    Type() {
      var e10;
      switch ((e10 = this.type) == null ? void 0 : e10.toLowerCase()) {
        case "@actor":
          return 1;
        case "@boundary":
          return 2;
        case "@collection":
          return 3;
        case "@control":
          return 4;
        case "@database":
          return 5;
        case "@entity":
          return 6;
        case "@queue":
          return 7;
        case "@ec2":
          return 8;
        case "@ecs":
          return 9;
        case "@iam":
          return 10;
        case "@lambda":
          return 11;
        case "@rds":
          return 12;
        case "@s3":
          return 13;
      }
      return 14;
    }
  }
  class _y {
    constructor() {
      W$1(this, "participants", /* @__PURE__ */ new Map());
    }
    Add(e10, n10, r10, s10, i10, o10, l10, a10, c10, u10) {
      const h10 = new Ly(
        e10,
        n10,
        r10,
        s10,
        i10,
        o10,
        l10,
        a10,
        c10,
        u10
      );
      this.participants.set(
        e10,
        xy({}, this.Get(e10), h10, (d10, p10) => d10 || p10)
      );
    }
    ImplicitArray() {
      return this.Array().filter((e10) => !e10.explicit && !e10.isStarter);
    }
    Array() {
      return Array.from(this.participants.entries()).map((e10) => e10[1]);
    }
    Names() {
      return Array.from(this.participants.keys());
    }
    First() {
      return this.participants.values().next().value;
    }
    Get(e10) {
      return this.participants.get(e10);
    }
    Size() {
      return this.participants.size;
    }
    Starter() {
      const e10 = this.First();
      return e10.isStarter ? e10 : void 0;
    }
  }
  const yy = f$1, Cy = yy.ProgContext;
  let zn, Kr = false, Qa;
  const zt$1 = new w();
  let vy = function(t10) {
    var c10, u10, h10, d10, p10, g, L;
    if (Kr)
      return;
    const e10 = (c10 = t10 == null ? void 0 : t10.participantType()) == null ? void 0 : c10.getFormattedText().replace("@", ""), n10 = ((u10 = t10 == null ? void 0 : t10.name()) == null ? void 0 : u10.getFormattedText()) || "Missing `Participant`", r10 = (d10 = (h10 = t10.stereotype()) == null ? void 0 : h10.name()) == null ? void 0 : d10.getFormattedText(), s10 = t10.width && t10.width() && Number.parseInt(t10.width().getText()) || void 0, i10 = t10.label && ((g = (p10 = t10.label()) == null ? void 0 : p10.name()) == null ? void 0 : g.getFormattedText()), o10 = true, l10 = (L = t10.COLOR()) == null ? void 0 : L.getText(), a10 = t10.getComment();
    zn.Add(
      n10,
      false,
      r10,
      s10,
      Qa,
      i10,
      o10,
      e10,
      l10,
      a10
    );
  };
  zt$1.enterParticipant = vy;
  let G4 = function(t10) {
    if (Kr)
      return;
    let e10 = t10.getFormattedText();
    zn.Add(e10);
  };
  zt$1.enterFrom = G4;
  zt$1.enterTo = G4;
  zt$1.enterStarter = function(t10) {
    let e10 = t10.getFormattedText();
    zn.Add(e10, true);
  };
  zt$1.enterCreation = function(t10) {
    if (Kr)
      return;
    const e10 = t10.Owner();
    zn.Add(e10);
  };
  zt$1.enterParameters = function() {
    Kr = true;
  };
  zt$1.exitParameters = function() {
    Kr = false;
  };
  zt$1.enterCondition = function() {
    Kr = true;
  };
  zt$1.exitCondition = function() {
    Kr = false;
  };
  zt$1.enterGroup = function(t10) {
    var e10;
    Qa = (e10 = t10.name()) == null ? void 0 : e10.getFormattedText();
  };
  zt$1.exitGroup = function() {
    Qa = void 0;
  };
  zt$1.enterRet = function(t10) {
    t10.asyncMessage() || (zn.Add(t10.From()), zn.Add(t10.ReturnTo()));
  };
  const by = b.tree.ParseTreeWalker.DEFAULT;
  zt$1.getParticipants = function(t10, e10) {
    return zn = new _y(), e10 && t10 instanceof Cy && zn.Add(t10.Starter(), true), by.walk(this, t10), zn;
  };
  const wy = b.tree.ParseTreeWalker.DEFAULT;
  var gn$1 = new w(), bt = 0, un$1 = 0;
  gn$1.enterTcf = function() {
    bt++;
  };
  gn$1.enterOpt = function() {
    bt++;
  };
  gn$1.enterPar = function() {
    bt++;
  };
  gn$1.enterAlt = function() {
    bt++;
  };
  gn$1.enterLoop = function() {
    bt++;
  };
  gn$1.exitTcf = function() {
    un$1 = Math.max(un$1, bt), bt--;
  };
  gn$1.exitOpt = function() {
    un$1 = Math.max(un$1, bt), bt--;
  };
  gn$1.exitPar = function() {
    un$1 = Math.max(un$1, bt), bt--;
  };
  gn$1.exitAlt = function() {
    un$1 = Math.max(un$1, bt), bt--;
  };
  gn$1.exitLoop = function() {
    un$1 = Math.max(un$1, bt), bt--;
  };
  gn$1.depth = function(t10) {
    return function(e10) {
      return bt = 0, un$1 = 0, e10.children.map(function(n10) {
        wy.walk(t10, n10);
      }), un$1;
    };
  };
  const Ey = f$1, Ty = Ey.TitleContext;
  Ty.prototype.content = function() {
    return this.children.length < 2 ? "" : this.children[1].getText().trim();
  };
  const j4 = f$1, tl = j4.CreationContext;
  tl.prototype.Body = tl.prototype.creationBody;
  tl.prototype.isCurrent = function(t10) {
    return Z4.bind(this)(t10);
  };
  const nl = j4.MessageContext;
  nl.prototype.Body = nl.prototype.messageBody;
  nl.prototype.isCurrent = function(t10) {
    return Z4.bind(this)(t10);
  };
  function Z4(t10) {
    try {
      if (t10 == null)
        return false;
      const e10 = this.start.start, n10 = this.Body().stop.stop + 1;
      return t10 >= e10 && t10 <= n10;
    } catch {
      return false;
    }
  }
  const Ja = f$1, F1 = Ja.CreationContext, ec = Ja.MessageContext, W4 = Ja.AsyncMessageContext;
  F1.prototype.Assignee = function() {
    var t10, e10, n10;
    return (n10 = (e10 = (t10 = this.creationBody()) == null ? void 0 : t10.assignment()) == null ? void 0 : e10.assignee()) == null ? void 0 : n10.getFormattedText();
  };
  F1.prototype.Constructor = function() {
    var t10, e10;
    return (e10 = (t10 = this.creationBody()) == null ? void 0 : t10.construct()) == null ? void 0 : e10.getFormattedText();
  };
  F1.prototype.Owner = function() {
    if (!this.Constructor())
      return "Missing Constructor";
    const t10 = this.Assignee(), e10 = this.Constructor();
    return t10 ? `${t10}:${e10}` : e10;
  };
  ec.prototype.To = function() {
    var t10, e10;
    return (e10 = (t10 = this.messageBody()) == null ? void 0 : t10.to()) == null ? void 0 : e10.getFormattedText();
  };
  ec.prototype.Owner = function() {
    return this.To() || q4(this.parentCtx);
  };
  function q4(t10) {
    for (; t10; ) {
      if (t10 instanceof F1 || t10 instanceof ec)
        return t10.Owner();
      t10 = t10.parentCtx;
    }
  }
  W4.prototype.To = function() {
    var t10;
    return (t10 = this.to()) == null ? void 0 : t10.getFormattedText();
  };
  W4.prototype.Owner = function() {
    return this.To() || q4(this.parentCtx);
  };
  const Sy = f$1.ProgContext;
  Sy.prototype.Starter = function() {
    var i10, o10, l10, a10, c10, u10, h10, d10, p10, g, L, T;
    const t10 = (l10 = (o10 = (i10 = this.head()) == null ? void 0 : i10.starterExp()) == null ? void 0 : o10.starter()) == null ? void 0 : l10.getFormattedText();
    let e10, n10, r10;
    const s10 = (a10 = this.block()) == null ? void 0 : a10.stat();
    if (s10 && s10[0]) {
      const _10 = (h10 = (u10 = (c10 = s10[0].message()) == null ? void 0 : c10.messageBody()) == null ? void 0 : u10.from()) == null ? void 0 : h10.getFormattedText(), x = (p10 = (d10 = s10[0].asyncMessage()) == null ? void 0 : d10.from()) == null ? void 0 : p10.getFormattedText();
      e10 = _10 || x;
    } else {
      const _10 = (g = this.head()) == null ? void 0 : g.children;
      if (_10 && _10[0]) {
        const x = _10[0];
        if (x instanceof f$1.ParticipantContext && (n10 = (L = x.name()) == null ? void 0 : L.getFormattedText()), x instanceof f$1.GroupContext) {
          const C = x.participant();
          C && C[0] && (r10 = (T = C[0].name()) == null ? void 0 : T.getFormattedText());
        }
      }
    }
    return t10 || e10 || n10 || r10 || "_STARTER_";
  };
  const D1 = f$1, Ay = D1.RetContext, q2 = D1.ProgContext, K2 = D1.MessageContext, ky = D1.CreationContext;
  Ay.prototype.ReturnTo = function() {
    var r10, s10;
    const n10 = this.parentCtx.parentCtx.parentCtx;
    if (n10 instanceof q2)
      return n10.Starter();
    {
      let i10 = n10;
      for (; i10 && !(i10 instanceof K2) && !(i10 instanceof ky); ) {
        if (i10 instanceof q2)
          return i10.Starter();
        i10 = i10.parentCtx;
      }
      return i10 instanceof K2 && ((s10 = (r10 = i10.messageBody()) == null ? void 0 : r10.from()) == null ? void 0 : s10.getFormattedText()) || i10.ClosestAncestorStat().Origin();
    }
  };
  const Ry = b.ParserRuleContext, K4 = f$1.StatContext, tc = f$1.ProgContext, Oy = f$1.MessageContext, Iy = f$1.CreationContext;
  Ry.prototype.Origin = function() {
    let t10 = this.parentCtx;
    for (; t10 && !(t10 instanceof K4 || t10 instanceof tc); )
      t10 = this.parentCtx;
    return t10.Origin();
  };
  K4.prototype.Origin = function() {
    let t10 = this.parentCtx;
    for (; t10; ) {
      if (t10 instanceof tc)
        return t10.Starter();
      if (t10 instanceof Oy || t10 instanceof Iy) {
        const e10 = t10.Owner();
        if (e10)
          return e10;
      }
      t10 = t10.parentCtx;
    }
  };
  tc.prototype.Origin = function() {
    return this.Starter();
  };
  const My = f$1, Ny = My.DividerContext;
  Ny.prototype.Note = function() {
    var e10;
    const t10 = (e10 = this.dividerNote()) == null ? void 0 : e10.getFormattedText().trim();
    if (!t10.startsWith("=="))
      throw new Error("Divider note must start with ==");
    return t10 == null ? void 0 : t10.replace(/^=+|=+$/g, "");
  };
  const nc = f$1, Py = nc.MessageContext, Fy = nc.AsyncMessageContext, Dy = nc.CreationContext;
  Py.prototype.SignatureText = function() {
    var t10, e10, n10;
    return (n10 = (e10 = (t10 = this.messageBody()) == null ? void 0 : t10.func()) == null ? void 0 : e10.signature()) == null ? void 0 : n10.map((r10) => r10 == null ? void 0 : r10.getFormattedText()).join(".");
  };
  Fy.prototype.SignatureText = function() {
    var t10;
    return (t10 = this.content()) == null ? void 0 : t10.getFormattedText();
  };
  Dy.prototype.SignatureText = function() {
    var n10;
    const t10 = this.creationBody().parameters();
    return "«" + (((n10 = t10 == null ? void 0 : t10.parameter()) == null ? void 0 : n10.length) > 0 ? t10.getFormattedText() : "create") + "»";
  };
  const By = f$1, $y = By.MessageContext;
  class Hy {
    constructor(e10, n10) {
      W$1(this, "assignee");
      W$1(this, "type");
      if (n10 && !e10)
        throw new Error("assignee must be defined if type is defined");
      this.assignee = e10 || "", this.type = n10 || "";
    }
    getText() {
      return [this.assignee, this.type].filter(Boolean).join(":");
    }
  }
  $y.prototype.Assignment = function() {
    var r10, s10;
    const t10 = this.messageBody().assignment(), e10 = (r10 = t10 == null ? void 0 : t10.assignee()) == null ? void 0 : r10.getFormattedText(), n10 = (s10 = t10 == null ? void 0 : t10.type()) == null ? void 0 : s10.getFormattedText();
    if (e10)
      return new Hy(e10, n10);
  };
  const U0 = f$1, Uy = U0.CreationContext, Vy = U0.StatContext, Y4 = U0.MessageContext, zy = U0.AsyncMessageContext, Gy = U0.RetContext;
  Uy.prototype.From = function() {
    if (this.parentCtx instanceof Vy)
      return this.ClosestAncestorStat().Origin();
  };
  Y4.prototype.ProvidedFrom = function() {
    var t10, e10;
    return (e10 = (t10 = this.messageBody()) == null ? void 0 : t10.from()) == null ? void 0 : e10.getFormattedText();
  };
  Y4.prototype.From = function() {
    return this.ProvidedFrom() || this.ClosestAncestorStat().Origin();
  };
  zy.prototype.From = function() {
    return this.from() ? this.from().getFormattedText() : this.ClosestAncestorStat().Origin();
  };
  Gy.prototype.From = function() {
    return this.ClosestAncestorStat().Origin();
  };
  b.ParserRuleContext.prototype.Key = function() {
    return `${this.start.start}:${this.stop.stop}`;
  };
  const rc = f$1, rl = rc.CreationContext;
  rl.prototype.Body = rl.prototype.creationBody;
  rl.prototype.isInitedFromOccurrence = function(t10) {
    return X4.bind(this)(t10);
  };
  const sl = rc.MessageContext;
  sl.prototype.Body = sl.prototype.messageBody;
  sl.prototype.isInitedFromOccurrence = function(t10) {
    return X4.bind(this)(t10);
  };
  function X4(t10) {
    let e10 = this;
    for (; e10 != null; ) {
      if (e10 instanceof rc.StatContext) {
        let n10;
        if (e10.message && e10.message() ? n10 = e10.message().Owner() : e10.creation && e10.creation() ? n10 = e10.creation().Owner() : e10.asyncMessage && e10.asyncMessage() && (n10 = e10.asyncMessage().to().getFormattedText()), n10 === t10)
          return true;
      }
      e10 = e10.parentCtx;
    }
    return false;
  }
  const Q4 = f$1, Y2 = Q4.StatContext;
  b.ParserRuleContext.prototype.ClosestAncestorStat = function() {
    let t10 = this;
    for (; !(t10 instanceof Y2); )
      t10 = t10.parentCtx;
    if (t10 instanceof Y2)
      return t10;
  };
  b.ParserRuleContext.prototype.ClosestAncestorBlock = function() {
    var e10;
    const t10 = (e10 = this.ClosestAncestorStat()) == null ? void 0 : e10.parentCtx;
    if (t10 instanceof Q4.BlockContext)
      return t10;
    console.warn("Cannot find closest ancestor block for context:", this);
  };
  function jy(t10, e10) {
    switch (t10) {
      case 0:
        return function() {
          return e10.apply(this, arguments);
        };
      case 1:
        return function(n10) {
          return e10.apply(this, arguments);
        };
      case 2:
        return function(n10, r10) {
          return e10.apply(this, arguments);
        };
      case 3:
        return function(n10, r10, s10) {
          return e10.apply(this, arguments);
        };
      case 4:
        return function(n10, r10, s10, i10) {
          return e10.apply(this, arguments);
        };
      case 5:
        return function(n10, r10, s10, i10, o10) {
          return e10.apply(this, arguments);
        };
      case 6:
        return function(n10, r10, s10, i10, o10, l10) {
          return e10.apply(this, arguments);
        };
      case 7:
        return function(n10, r10, s10, i10, o10, l10, a10) {
          return e10.apply(this, arguments);
        };
      case 8:
        return function(n10, r10, s10, i10, o10, l10, a10, c10) {
          return e10.apply(this, arguments);
        };
      case 9:
        return function(n10, r10, s10, i10, o10, l10, a10, c10, u10) {
          return e10.apply(this, arguments);
        };
      case 10:
        return function(n10, r10, s10, i10, o10, l10, a10, c10, u10, h10) {
          return e10.apply(this, arguments);
        };
      default:
        throw new Error("First argument to _arity must be a non-negative integer no greater than ten");
    }
  }
  var J4 = jy;
  function Zy(t10, e10) {
    return function() {
      return e10.call(this, t10.apply(this, arguments));
    };
  }
  var Wy = Zy;
  function qy(t10) {
    return t10 != null && typeof t10 == "object" && t10["@@functional/placeholder"] === true;
  }
  var sc = qy, Ky = sc;
  function Yy(t10) {
    return function e10(n10) {
      return arguments.length === 0 || Ky(n10) ? e10 : t10.apply(this, arguments);
    };
  }
  var B1 = Yy, ao = B1, js = sc;
  function Xy(t10) {
    return function e10(n10, r10) {
      switch (arguments.length) {
        case 0:
          return e10;
        case 1:
          return js(n10) ? e10 : ao(function(s10) {
            return t10(n10, s10);
          });
        default:
          return js(n10) && js(r10) ? e10 : js(n10) ? ao(function(s10) {
            return t10(s10, r10);
          }) : js(r10) ? ao(function(s10) {
            return t10(n10, s10);
          }) : t10(n10, r10);
      }
    };
  }
  var eh = Xy, fi = B1, ts = eh, Lt$1 = sc;
  function Qy(t10) {
    return function e10(n10, r10, s10) {
      switch (arguments.length) {
        case 0:
          return e10;
        case 1:
          return Lt$1(n10) ? e10 : ts(function(i10, o10) {
            return t10(n10, i10, o10);
          });
        case 2:
          return Lt$1(n10) && Lt$1(r10) ? e10 : Lt$1(n10) ? ts(function(i10, o10) {
            return t10(i10, r10, o10);
          }) : Lt$1(r10) ? ts(function(i10, o10) {
            return t10(n10, i10, o10);
          }) : fi(function(i10) {
            return t10(n10, r10, i10);
          });
        default:
          return Lt$1(n10) && Lt$1(r10) && Lt$1(s10) ? e10 : Lt$1(n10) && Lt$1(r10) ? ts(function(i10, o10) {
            return t10(i10, o10, s10);
          }) : Lt$1(n10) && Lt$1(s10) ? ts(function(i10, o10) {
            return t10(i10, r10, o10);
          }) : Lt$1(r10) && Lt$1(s10) ? ts(function(i10, o10) {
            return t10(n10, i10, o10);
          }) : Lt$1(n10) ? fi(function(i10) {
            return t10(i10, r10, s10);
          }) : Lt$1(r10) ? fi(function(i10) {
            return t10(n10, i10, s10);
          }) : Lt$1(s10) ? fi(function(i10) {
            return t10(n10, r10, i10);
          }) : t10(n10, r10, s10);
      }
    };
  }
  var ic = Qy, th = Array.isArray || function(e10) {
    return e10 != null && e10.length >= 0 && Object.prototype.toString.call(e10) === "[object Array]";
  };
  function Jy(t10) {
    return Object.prototype.toString.call(t10) === "[object String]";
  }
  var eC = Jy, tC = B1, nC = th, rC = eC, sC = /* @__PURE__ */ tC(function(e10) {
    return nC(e10) ? true : !e10 || typeof e10 != "object" || rC(e10) ? false : e10.length === 0 ? true : e10.length > 0 ? e10.hasOwnProperty(0) && e10.hasOwnProperty(e10.length - 1) : false;
  }), iC = sC, oC = /* @__PURE__ */ function() {
    function t10(e10) {
      this.f = e10;
    }
    return t10.prototype["@@transducer/init"] = function() {
      throw new Error("init not implemented on XWrap");
    }, t10.prototype["@@transducer/result"] = function(e10) {
      return e10;
    }, t10.prototype["@@transducer/step"] = function(e10, n10) {
      return this.f(e10, n10);
    }, t10;
  }();
  function lC(t10) {
    return new oC(t10);
  }
  var aC = lC, cC = J4, uC = eh, hC = /* @__PURE__ */ uC(function(e10, n10) {
    return cC(e10.length, function() {
      return e10.apply(n10, arguments);
    });
  }), dC = hC, fC = iC, pC = aC, gC = dC;
  function mC(t10, e10, n10) {
    for (var r10 = 0, s10 = n10.length; r10 < s10; ) {
      if (e10 = t10["@@transducer/step"](e10, n10[r10]), e10 && e10["@@transducer/reduced"]) {
        e10 = e10["@@transducer/value"];
        break;
      }
      r10 += 1;
    }
    return t10["@@transducer/result"](e10);
  }
  function X2(t10, e10, n10) {
    for (var r10 = n10.next(); !r10.done; ) {
      if (e10 = t10["@@transducer/step"](e10, r10.value), e10 && e10["@@transducer/reduced"]) {
        e10 = e10["@@transducer/value"];
        break;
      }
      r10 = n10.next();
    }
    return t10["@@transducer/result"](e10);
  }
  function Q2(t10, e10, n10, r10) {
    return t10["@@transducer/result"](n10[r10](gC(t10["@@transducer/step"], t10), e10));
  }
  var J2 = typeof Symbol < "u" ? Symbol.iterator : "@@iterator";
  function xC(t10, e10, n10) {
    if (typeof t10 == "function" && (t10 = pC(t10)), fC(n10))
      return mC(t10, e10, n10);
    if (typeof n10["fantasy-land/reduce"] == "function")
      return Q2(t10, e10, n10, "fantasy-land/reduce");
    if (n10[J2] != null)
      return X2(t10, e10, n10[J2]());
    if (typeof n10.next == "function")
      return X2(t10, e10, n10);
    if (typeof n10.reduce == "function")
      return Q2(t10, e10, n10, "reduce");
    throw new TypeError("reduce: list must be array or iterable");
  }
  var LC = xC, _C = ic, yC = LC, CC = /* @__PURE__ */ _C(yC), vC = CC, bC = th;
  function wC(t10, e10) {
    return function() {
      var n10 = arguments.length;
      if (n10 === 0)
        return e10();
      var r10 = arguments[n10 - 1];
      return bC(r10) || typeof r10[t10] != "function" ? e10.apply(this, arguments) : r10[t10].apply(r10, Array.prototype.slice.call(arguments, 0, n10 - 1));
    };
  }
  var nh = wC, EC = nh, TC = ic, SC = /* @__PURE__ */ TC(
    /* @__PURE__ */ EC("slice", function(e10, n10, r10) {
      return Array.prototype.slice.call(r10, e10, n10);
    })
  ), AC = SC, kC = nh, RC = B1, OC = AC, IC = /* @__PURE__ */ RC(
    /* @__PURE__ */ kC(
      "tail",
      /* @__PURE__ */ OC(1, 1 / 0)
    )
  ), MC = IC, NC = J4, PC = Wy, FC = vC, DC = MC;
  function BC() {
    if (arguments.length === 0)
      throw new Error("pipe requires at least one argument");
    return NC(arguments[0].length, FC(PC, arguments[0], DC(arguments)));
  }
  var $C = BC;
  const HC = $C;
  var UC = ic, VC = /* @__PURE__ */ UC(function(e10, n10, r10) {
    return r10.replace(e10, n10);
  }), zC = VC;
  const V0 = zC, GC = V0(/[\n\r]/g, " "), jC = V0(/\s+/g, " "), ZC = V0(/\s*([,;.()])\s*/g, "$1"), WC = V0(/\s+$/g, ""), qC = V0(/^"(.*)"$/, "$1"), KC = HC(
    GC,
    jC,
    ZC,
    WC,
    qC
  ), rh = (t10, e10) => {
    let n10 = e10;
    for (t10[n10] === `
` && n10--; n10 >= 0; ) {
      if (t10[n10] === `
`)
        return n10 + 1;
      n10--;
    }
    return 0;
  }, YC = (t10, e10) => {
    const n10 = rh(t10, e10);
    if (n10 === 0)
      return 0;
    let r10 = n10 - 2;
    for (; r10 >= 0; ) {
      if (t10[r10] === `
`)
        return r10 + 1;
      r10--;
    }
    return 0;
  }, KO = (t10, e10) => {
    const n10 = rh(t10, e10);
    if (n10 === 0)
      return "";
    const r10 = YC(t10, e10);
    return t10.slice(r10, n10);
  };
  class XC extends b.error.ErrorListener {
    syntaxError(e10, n10, r10, s10, i10) {
    }
  }
  function QC(t10) {
    const e10 = new b.InputStream(t10), n10 = new Z$1(e10), r10 = new b.CommonTokenStream(n10), s10 = new f$1(r10);
    return s10.addErrorListener(new XC()), s10._syntaxErrors ? null : s10.prog();
  }
  b.ParserRuleContext.prototype.getFormattedText = function() {
    const t10 = this.parser.getTokenStream().getText(this.getSourceInterval());
    return KC(t10);
  };
  b.ParserRuleContext.prototype.getComment = function() {
    let t10 = this.start.tokenIndex, e10 = Z$1.channelNames.indexOf("COMMENT_CHANNEL");
    this.constructor.name === "BraceBlockContext" && (t10 = this.stop.tokenIndex);
    let n10 = this.parser.getTokenStream().getHiddenTokensToLeft(t10, e10);
    return n10 && n10.map((r10) => r10.text.substring(2)).join("");
  };
  b.ParserRuleContext.prototype.returnedValue = function() {
    return this.braceBlock().block().ret().value();
  };
  const JC = f$1.ProgContext, ev = QC, sh = f$1.GroupContext, ih = f$1.ParticipantContext, Ds = function(t10, e10) {
    return zt$1.getParticipants(t10, e10);
  };
  var Lr = /* @__PURE__ */ ((t10) => (t10[t10.MessageContent = 0] = "MessageContent", t10[t10.ParticipantName = 1] = "ParticipantName", t10))(Lr || {});
  let oc = {};
  const oh = {}, lh = (t10) => {
    var e10;
    if (t10 != null) {
      const n10 = (e10 = oc[t10]) != null ? e10 : oh[t10];
      return n10 !== void 0 ? n10 : null;
    }
    return null;
  }, ah = (t10, e10, n10 = false) => {
    oc[t10] = e10, n10 && (oh[t10] = e10);
  }, tv = () => {
    oc = {};
  };
  function _0(t10, e10) {
    const n10 = `WidthProviderOnBrowser_${t10}_${e10}`, r10 = lh(n10);
    if (r10 != null)
      return r10;
    let s10 = document.querySelector(
      ".textarea-hidden-div"
    );
    if (!s10) {
      const o10 = document.createElement("div");
      o10.className = "textarea-hidden-div ", o10.style.fontSize = e10 === Lr.MessageContent ? "0.875rem" : "1rem", o10.style.fontFamily = "Helvetica, Verdana, serif", o10.style.display = "inline", o10.style.whiteSpace = "nowrap", o10.style.visibility = "hidden", o10.style.position = "absolute", o10.style.top = "0", o10.style.left = "0", o10.style.overflow = "hidden", o10.style.width = "0px", o10.style.paddingLeft = "0px", o10.style.paddingRight = "0px", o10.style.margin = "0px", o10.style.border = "0px", document.body.appendChild(o10), s10 = o10;
    }
    s10.textContent = t10;
    const i10 = s10.scrollWidth;
    return ah(n10, i10, true), i10;
  }
  const nv = 110, il = 20, rv = 10, sv = 14, iv = 100, ov = 70, lv = f$1;
  class lc extends w {
    constructor() {
      super(...arguments);
      W$1(this, "explicitParticipants", []);
      W$1(this, "starter", "");
      W$1(this, "implicitParticipants", []);
      W$1(this, "isBlind", false);
    }
    enterCondition() {
      this.isBlind = true;
    }
    exitCondition() {
      this.isBlind = false;
    }
    enterParameters() {
      this.isBlind = true;
    }
    exitParameters() {
      this.isBlind = false;
    }
    enterStarter(n10) {
      this.starter = n10.getFormattedText();
    }
    enterParticipant(n10) {
      var o10, l10, a10;
      const r10 = ((o10 = n10 == null ? void 0 : n10.name()) == null ? void 0 : o10.getFormattedText()) || "Missing `Participant` name", s10 = (a10 = (l10 = n10.label()) == null ? void 0 : l10.name()) == null ? void 0 : a10.getFormattedText(), i10 = { name: r10, label: s10, left: "" };
      this.explicitParticipants.push(i10);
    }
    enterFrom(n10) {
      if (this.isBlind)
        return;
      const r10 = n10 == null ? void 0 : n10.getFormattedText();
      if (n10.ClosestAncestorBlock().parentCtx instanceof lv.ProgContext && n10.ClosestAncestorStat() === n10.ClosestAncestorBlock().children[0]) {
        this.starter = r10;
        return;
      }
      this.enterTo(n10);
    }
    enterTo(n10) {
      if (this.isBlind)
        return;
      const r10 = n10 == null ? void 0 : n10.getFormattedText();
      if (r10 === this.starter || this.explicitParticipants.some((i10) => i10.name === r10))
        return;
      const s10 = { name: r10, left: "" };
      this.implicitParticipants.push(s10);
    }
    enterCreation(n10) {
      if (this.isBlind)
        return;
      const r10 = n10 == null ? void 0 : n10.Owner();
      if (r10 === this.starter || this.explicitParticipants.some((i10) => i10.name === r10))
        return;
      const s10 = { name: r10, left: "" };
      this.implicitParticipants.push(s10);
    }
    result() {
      let n10 = [...this.explicitParticipants, ...this.implicitParticipants];
      return this._isStarterExplicitlyPositioned() || n10.unshift(this._getStarter()), n10 = this._dedup(n10), lc._assignLeft(n10), n10;
    }
    _isStarterExplicitlyPositioned() {
      return this.starter && this.explicitParticipants.find((n10) => n10.name === this.starter);
    }
    _getStarter() {
      return { name: this.starter || "_STARTER_", left: "" };
    }
    _dedup(n10) {
      return n10.filter((r10, s10) => n10.findIndex((i10) => i10.name === r10.name) === s10);
    }
    static _assignLeft(n10) {
      n10.reduce(
        (r10, s10) => (s10.left = r10.name || "", s10),
        { name: "", left: "" }
      );
    }
  }
  function av(t10) {
    const e10 = new lc();
    return b.tree.ParseTreeWalker.DEFAULT.walk(e10, t10), e10.result();
  }
  function $1(t10, e10) {
    return { position: t10, velocity: e10 };
  }
  function eu(t10, e10) {
    return $1(t10.position + e10.position, t10.velocity + e10.velocity);
  }
  const tu = Math.sqrt(Number.EPSILON);
  function cv(t10, e10) {
    const n10 = t10.position - e10.position;
    return n10 < -tu || Math.abs(n10) <= tu && t10.velocity < e10.velocity;
  }
  function uv() {
    return {
      delta: 1 / 0,
      dualLessThan: function(t10, e10) {
        const n10 = cv(t10, e10);
        return n10 && ([t10, e10] = [e10, t10]), t10.velocity < e10.velocity && (this.delta = Math.min(
          this.delta,
          (t10.position - e10.position) / (e10.velocity - t10.velocity)
        )), n10;
      }
    };
  }
  function hv(t10, e10) {
    const n10 = Array();
    for (let r10 = 0; r10 < t10; r10++) {
      n10.push([]);
      for (let s10 = 0; s10 < r10; s10++)
        e10[s10][r10] > 0 && n10[r10].push({ i: s10, length: $1(e10[s10][r10], 0) });
    }
    return n10;
  }
  function dv(t10, e10) {
    const n10 = uv();
    let r10 = $1(0, 0);
    const s10 = [];
    for (let i10 = 0; i10 < t10.length; i10++) {
      let o10 = null;
      i10 > 0 && (r10 = eu(r10, e10[i10 - 1]));
      for (const l10 of t10[i10]) {
        const a10 = eu(s10[l10.i].maximum, l10.length);
        n10.dualLessThan(r10, a10) && (o10 = l10.i, r10 = a10);
      }
      s10.push({ argument: o10, maximum: r10 });
    }
    return [n10.delta, s10];
  }
  function fv(t10, e10, n10) {
    let r10 = t10.length - 1;
    for (; r10 > 0; ) {
      const s10 = t10[r10].argument;
      s10 !== null ? r10 = s10 : (r10--, n10[r10].velocity = 0);
    }
  }
  function pv(t10, e10) {
    for (let n10 = 0; n10 < t10.length; n10++)
      t10[n10].position += t10[n10].velocity * e10;
  }
  function gv(t10) {
    const e10 = [];
    for (const n10 of t10)
      e10.push(n10.maximum.position);
    return e10;
  }
  function mv(t10) {
    const e10 = t10.length, n10 = hv(e10, t10), r10 = [];
    for (let s10 = 1; s10 < e10; s10++)
      r10.push($1(0, 1));
    for (; ; ) {
      const [s10, i10] = dv(n10, r10);
      if (s10 == 1 / 0)
        return gv(i10);
      i10[e10 - 1].maximum.velocity > 0 ? fv(i10, n10, r10) : pv(r10, s10);
    }
  }
  var i0 = /* @__PURE__ */ ((t10) => (t10[t10.SyncMessage = 0] = "SyncMessage", t10[t10.AsyncMessage = 1] = "AsyncMessage", t10[t10.CreationMessage = 2] = "CreationMessage", t10))(i0 || {});
  class xv extends w {
    constructor() {
      super(...arguments);
      W$1(this, "isBlind", false);
      W$1(this, "ownableMessages", []);
      W$1(this, "enterMessage", (n10) => this._addOwnedMessage(i0.SyncMessage)(n10));
      W$1(this, "enterAsyncMessage", (n10) => this._addOwnedMessage(i0.AsyncMessage)(n10));
      W$1(this, "enterCreation", (n10) => this._addOwnedMessage(i0.CreationMessage)(n10));
      W$1(this, "_addOwnedMessage", (n10) => (r10) => {
        if (this.isBlind)
          return;
        const s10 = r10.From(), i10 = r10 == null ? void 0 : r10.Owner(), o10 = r10 == null ? void 0 : r10.SignatureText();
        this.ownableMessages.push({
          from: s10,
          signature: o10,
          type: n10,
          to: i10
        });
      });
    }
    enterParameters() {
      this.isBlind = true;
    }
    exitParameters() {
      this.isBlind = false;
    }
    result() {
      return this.ownableMessages;
    }
  }
  function ch(t10) {
    const e10 = b.tree.ParseTreeWalker.DEFAULT, n10 = new xv();
    return e10.walk(n10, t10), n10.result();
  }
  class Lv {
    constructor(e10, n10) {
      W$1(this, "m", []);
      W$1(this, "widthProvider");
      W$1(this, "participantModels");
      W$1(this, "ownableMessages");
      this.participantModels = av(e10), this.ownableMessages = ch(e10), this.widthProvider = n10, this.walkThrough();
    }
    orderedParticipantNames() {
      return this.participantModels.map((e10) => e10.name);
    }
    getPosition(e10) {
      const n10 = this.participantModels.findIndex(
        (l10) => l10.name === e10
      );
      if (n10 === -1)
        throw Error(`Participant ${e10} not found`);
      const r10 = `getPosition_${e10}`, s10 = lh(r10);
      if (s10 != null)
        return s10;
      const o10 = this.getParticipantGap(this.participantModels[0]) + mv(this.m)[n10];
      return ah(r10, o10), console.debug(`Position of ${e10} is ${o10}`), o10;
    }
    walkThrough() {
      this.withParticipantGaps(this.participantModels), this.withMessageGaps(this.ownableMessages, this.participantModels);
    }
    half(e10) {
      if (e10 === "_STARTER_")
        return il / 2;
      const n10 = this.halfWithMargin(
        this.labelOrName(e10)
      );
      return Math.max(n10, nv / 2);
    }
    getWidth() {
      const e10 = this.participantModels[this.participantModels.length - 1].name, n10 = this.getPosition(e10) + this.half(e10);
      return Math.max(n10, 200);
    }
    distance(e10, n10) {
      return this.getPosition(n10) - this.getPosition(e10);
    }
    withMessageGaps(e10, n10) {
      e10.forEach((r10) => {
        const s10 = n10.findIndex(
          (a10) => a10.name === r10.from
        ), i10 = n10.findIndex((a10) => a10.name === r10.to);
        if (s10 === -1 || i10 === -1) {
          console.warn(`Participant ${r10.from} or ${r10.to} not found`);
          return;
        }
        const o10 = Math.min(s10, i10), l10 = Math.max(s10, i10);
        try {
          const a10 = this.getMessageWidth(r10);
          this.m[o10][l10] = Math.max(
            a10 + rv + sv,
            this.m[o10][l10]
          );
        } catch {
          console.warn(
            `Could not set message gap between ${r10.from} and ${r10.to}`
          );
        }
      });
    }
    getMessageWidth(e10) {
      const n10 = this.half(e10.to);
      let r10 = this.widthProvider(
        e10.signature,
        Lr.MessageContent
      );
      return e10.type === i0.CreationMessage && (r10 += n10), r10;
    }
    withParticipantGaps(e10) {
      this.m = e10.map((n10, r10) => e10.map((s10, i10) => i10 - r10 === 1 ? this.getParticipantGap(s10) : 0));
    }
    getParticipantGap(e10) {
      const n10 = this.half(e10.left), r10 = this.half(e10.name), s10 = e10.left && e10.left !== "_STARTER_", i10 = e10.name && e10.name !== "_STARTER_";
      return (s10 && n10 || 0) + (i10 && r10 || 0);
    }
    labelOrName(e10) {
      const n10 = this.participantModels.findIndex((r10) => r10.name === e10);
      return n10 === -1 ? "" : this.participantModels[n10].label || this.participantModels[n10].name;
    }
    halfWithMargin(e10) {
      return this._getParticipantWidth(e10) / 2 + il / 2;
    }
    _getParticipantWidth(e10) {
      return Math.max(
        this.widthProvider(e10 || "", Lr.ParticipantName),
        iv
      );
    }
  }
  let uh = 0;
  setTimeout(function() {
    uh || console.warn(
      "[@zenuml/core] Store is a function and is not initiated in 1 second."
    );
  }, 1e3);
  var Gn = /* @__PURE__ */ ((t10) => (t10.Static = "static", t10.Dynamic = "dynamic", t10))(Gn || {});
  const hh = () => (uh = X9(), {
    state: {
      warning: void 0,
      code: "",
      theme: localStorage.getItem(`${location.hostname}-zenuml-theme`) || "theme-default",
      enableMultiTheme: true,
      scale: 1,
      selected: [],
      cursor: null,
      showTips: false,
      mode: "dynamic",
      numbering: Boolean(
        localStorage.getItem(`${location.hostname}-zenuml-numbering`)
      ),
      stickyOffset: 0,
      diagramElement: null,
      onElementClick: (t10) => {
        console.log("Element clicked", t10);
      },
      onMessageClick: () => {
      },
      onContentChange: () => {
      }
    },
    getters: {
      code: (t10) => t10.code,
      rootContext: (t10) => ev(t10.code),
      title: (t10, e10) => {
        var n10, r10;
        return (r10 = (n10 = e10.rootContext) == null ? void 0 : n10.title()) == null ? void 0 : r10.content();
      },
      participants: (t10, e10) => Ds(e10.rootContext, true),
      coordinates: (t10, e10) => new Lv(e10.rootContext, _0),
      centerOf: (t10, e10) => (n10) => {
        if (!n10)
          return console.error("[@zenuml/core] centerOf: entity is undefined"), 0;
        try {
          return e10.coordinates.getPosition(n10) || 0;
        } catch (r10) {
          return console.error(r10), 0;
        }
      },
      GroupContext: () => sh,
      ParticipantContext: () => ih,
      cursor: (t10) => t10.cursor,
      distance: (t10, e10) => (n10, r10) => e10.centerOf(n10) - e10.centerOf(r10),
      distance2: (t10, e10) => (n10, r10) => !n10 || !r10 ? 0 : e10.centerOf(r10) - e10.centerOf(n10),
      onElementClick: (t10) => t10.onElementClick,
      onMessageClick: (t10) => t10.onMessageClick,
      diagramElement: (t10) => t10.diagramElement,
      onContentChange: (t10) => t10.onContentChange
    },
    mutations: {
      code: function(t10, e10) {
        t10.code = e10;
      },
      setScale: function(t10, e10) {
        t10.scale = e10;
      },
      onSelect: function(t10, e10) {
        t10.selected.includes(e10) ? t10.selected = t10.selected.filter((n10) => n10 !== e10) : t10.selected.push(e10);
      },
      cursor: function(t10, e10) {
        t10.cursor = e10;
      },
      toggleNumbering(t10, e10) {
        e10 ? localStorage.setItem(`${location.hostname}-zenuml-numbering`, "1") : localStorage.setItem(`${location.hostname}-zenuml-numbering`, ""), t10.numbering = e10;
      },
      setTheme: function(t10, e10) {
        e10 ? localStorage.setItem(`${location.hostname}-zenuml-theme`, e10) : localStorage.setItem(
          `${location.hostname}-zenuml-theme`,
          "theme-default"
        ), t10.theme = e10;
      },
      onMessageClick: function(t10, e10) {
        t10.onMessageClick = e10;
      },
      onContentChange: function(t10, e10) {
        t10.onContentChange = e10;
      },
      diagramElement: function(t10, e10) {
        t10.diagramElement = e10;
      }
    },
    actions: {
      updateCode: function({ commit: t10 }, e10) {
        if (typeof e10 == "string")
          throw Error(
            "You are using a old version of vue-sequence. New version requires {code, cursor}."
          );
        e10.code !== this.state.code && t10("code", e10.code);
      }
    },
    strict: false
  }), _v = (t10, e10) => {
    const n10 = t10[e10];
    return n10 ? typeof n10 == "function" ? n10() : Promise.resolve(n10) : new Promise((r10, s10) => {
      (typeof queueMicrotask == "function" ? queueMicrotask : setTimeout)(s10.bind(null, new Error("Unknown variable dynamic import: " + e10)));
    });
  }, dr = {
    __name: "Icon",
    props: {
      name: {
        type: String,
        required: true
      },
      iconClass: {
        type: String,
        required: false
      }
    },
    setup(t10) {
      const e10 = t10, n10 = hs(() => _v(/* @__PURE__ */ Object.assign({ "./icons/close.svg": () => Promise.resolve().then(() => close_228685c1), "./icons/collapse-expanded.svg": () => Promise.resolve().then(() => collapseExpanded_785ba28f), "./icons/collapse-unexpanded.svg": () => Promise.resolve().then(() => collapseUnexpanded_5a4f78b6), "./icons/debug.svg": () => Promise.resolve().then(() => debug_bf1f3ab1), "./icons/message-arrow.svg": () => Promise.resolve().then(() => messageArrow_c237839b), "./icons/non-selected-cycle.svg": () => Promise.resolve().then(() => nonSelectedCycle_dbd3f5f9), "./icons/numbering.svg": () => Promise.resolve().then(() => numbering_c6175f47), "./icons/privacy.svg": () => Promise.resolve().then(() => privacy_4d7335e3), "./icons/selected-cycle.svg": () => Promise.resolve().then(() => selectedCycle_51f4ca8a), "./icons/theme.svg": () => Promise.resolve().then(() => theme_0da1d53e), "./icons/tip.svg": () => Promise.resolve().then(() => tip_8e3fa4b8), "./icons/zoom-in.svg": () => Promise.resolve().then(() => zoomIn_950b1b73), "./icons/zoom-out.svg": () => Promise.resolve().then(() => zoomOut_f0af522e) }), `./icons/${e10.name}.svg`));
      return (r10, s10) => (k$1(), q$1("span", {
        class: ve$1(["flex items-center justify-center", t10.iconClass]),
        onClick: s10[0] || (s10[0] = (i10) => r10.$emit("icon-click"))
      }, [
        (k$1(), Re$1(ks(_e(n10)), { class: "w-full h-full" }))
      ], 2));
    }
  };
  const ze$1 = (t10, e10) => {
    const n10 = t10.__vccOpts || t10;
    for (const [r10, s10] of e10)
      n10[r10] = s10;
    return n10;
  }, yv = {
    name: "Privacy",
    components: { Icon: dr }
  }, Cv = {
    class: "privacy tooltip bottom whitespace-normal flex items-center",
    "data-tooltip": "We (the vendor) do not have access to your data. The diagram is generated in this browser."
  };
  function vv(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("Icon");
    return k$1(), q$1("div", null, [
      A("div", Cv, [
        V$1(o10, {
          name: "privacy",
          "icon-class": "fill-current h-6 w-6 m-auto"
        })
      ])
    ]);
  }
  const bv = /* @__PURE__ */ ze$1(yv, [["render", vv], ["__scopeId", "data-v-3e7c8bd7"]]), wv = {
    name: "DiagramTitle",
    props: ["context"],
    computed: {
      title: function() {
        var t10;
        return (t10 = this.context) == null ? void 0 : t10.content();
      }
    }
  }, Ev = { class: "title text-skin-title text-base font-semibold" };
  function Tv(t10, e10, n10, r10, s10, i10) {
    return k$1(), q$1("div", Ev, Ve$1(i10.title), 1);
  }
  const Sv = /* @__PURE__ */ ze$1(wv, [["render", Tv]]), ac = new A5();
  var cc = { exports: {} }, Av = {
    aliceblue: [240, 248, 255],
    antiquewhite: [250, 235, 215],
    aqua: [0, 255, 255],
    aquamarine: [127, 255, 212],
    azure: [240, 255, 255],
    beige: [245, 245, 220],
    bisque: [255, 228, 196],
    black: [0, 0, 0],
    blanchedalmond: [255, 235, 205],
    blue: [0, 0, 255],
    blueviolet: [138, 43, 226],
    brown: [165, 42, 42],
    burlywood: [222, 184, 135],
    cadetblue: [95, 158, 160],
    chartreuse: [127, 255, 0],
    chocolate: [210, 105, 30],
    coral: [255, 127, 80],
    cornflowerblue: [100, 149, 237],
    cornsilk: [255, 248, 220],
    crimson: [220, 20, 60],
    cyan: [0, 255, 255],
    darkblue: [0, 0, 139],
    darkcyan: [0, 139, 139],
    darkgoldenrod: [184, 134, 11],
    darkgray: [169, 169, 169],
    darkgreen: [0, 100, 0],
    darkgrey: [169, 169, 169],
    darkkhaki: [189, 183, 107],
    darkmagenta: [139, 0, 139],
    darkolivegreen: [85, 107, 47],
    darkorange: [255, 140, 0],
    darkorchid: [153, 50, 204],
    darkred: [139, 0, 0],
    darksalmon: [233, 150, 122],
    darkseagreen: [143, 188, 143],
    darkslateblue: [72, 61, 139],
    darkslategray: [47, 79, 79],
    darkslategrey: [47, 79, 79],
    darkturquoise: [0, 206, 209],
    darkviolet: [148, 0, 211],
    deeppink: [255, 20, 147],
    deepskyblue: [0, 191, 255],
    dimgray: [105, 105, 105],
    dimgrey: [105, 105, 105],
    dodgerblue: [30, 144, 255],
    firebrick: [178, 34, 34],
    floralwhite: [255, 250, 240],
    forestgreen: [34, 139, 34],
    fuchsia: [255, 0, 255],
    gainsboro: [220, 220, 220],
    ghostwhite: [248, 248, 255],
    gold: [255, 215, 0],
    goldenrod: [218, 165, 32],
    gray: [128, 128, 128],
    green: [0, 128, 0],
    greenyellow: [173, 255, 47],
    grey: [128, 128, 128],
    honeydew: [240, 255, 240],
    hotpink: [255, 105, 180],
    indianred: [205, 92, 92],
    indigo: [75, 0, 130],
    ivory: [255, 255, 240],
    khaki: [240, 230, 140],
    lavender: [230, 230, 250],
    lavenderblush: [255, 240, 245],
    lawngreen: [124, 252, 0],
    lemonchiffon: [255, 250, 205],
    lightblue: [173, 216, 230],
    lightcoral: [240, 128, 128],
    lightcyan: [224, 255, 255],
    lightgoldenrodyellow: [250, 250, 210],
    lightgray: [211, 211, 211],
    lightgreen: [144, 238, 144],
    lightgrey: [211, 211, 211],
    lightpink: [255, 182, 193],
    lightsalmon: [255, 160, 122],
    lightseagreen: [32, 178, 170],
    lightskyblue: [135, 206, 250],
    lightslategray: [119, 136, 153],
    lightslategrey: [119, 136, 153],
    lightsteelblue: [176, 196, 222],
    lightyellow: [255, 255, 224],
    lime: [0, 255, 0],
    limegreen: [50, 205, 50],
    linen: [250, 240, 230],
    magenta: [255, 0, 255],
    maroon: [128, 0, 0],
    mediumaquamarine: [102, 205, 170],
    mediumblue: [0, 0, 205],
    mediumorchid: [186, 85, 211],
    mediumpurple: [147, 112, 219],
    mediumseagreen: [60, 179, 113],
    mediumslateblue: [123, 104, 238],
    mediumspringgreen: [0, 250, 154],
    mediumturquoise: [72, 209, 204],
    mediumvioletred: [199, 21, 133],
    midnightblue: [25, 25, 112],
    mintcream: [245, 255, 250],
    mistyrose: [255, 228, 225],
    moccasin: [255, 228, 181],
    navajowhite: [255, 222, 173],
    navy: [0, 0, 128],
    oldlace: [253, 245, 230],
    olive: [128, 128, 0],
    olivedrab: [107, 142, 35],
    orange: [255, 165, 0],
    orangered: [255, 69, 0],
    orchid: [218, 112, 214],
    palegoldenrod: [238, 232, 170],
    palegreen: [152, 251, 152],
    paleturquoise: [175, 238, 238],
    palevioletred: [219, 112, 147],
    papayawhip: [255, 239, 213],
    peachpuff: [255, 218, 185],
    peru: [205, 133, 63],
    pink: [255, 192, 203],
    plum: [221, 160, 221],
    powderblue: [176, 224, 230],
    purple: [128, 0, 128],
    rebeccapurple: [102, 51, 153],
    red: [255, 0, 0],
    rosybrown: [188, 143, 143],
    royalblue: [65, 105, 225],
    saddlebrown: [139, 69, 19],
    salmon: [250, 128, 114],
    sandybrown: [244, 164, 96],
    seagreen: [46, 139, 87],
    seashell: [255, 245, 238],
    sienna: [160, 82, 45],
    silver: [192, 192, 192],
    skyblue: [135, 206, 235],
    slateblue: [106, 90, 205],
    slategray: [112, 128, 144],
    slategrey: [112, 128, 144],
    snow: [255, 250, 250],
    springgreen: [0, 255, 127],
    steelblue: [70, 130, 180],
    tan: [210, 180, 140],
    teal: [0, 128, 128],
    thistle: [216, 191, 216],
    tomato: [255, 99, 71],
    turquoise: [64, 224, 208],
    violet: [238, 130, 238],
    wheat: [245, 222, 179],
    white: [255, 255, 255],
    whitesmoke: [245, 245, 245],
    yellow: [255, 255, 0],
    yellowgreen: [154, 205, 50]
  }, dh = { exports: {} }, kv = function(e10) {
    return !e10 || typeof e10 == "string" ? false : e10 instanceof Array || Array.isArray(e10) || e10.length >= 0 && (e10.splice instanceof Function || Object.getOwnPropertyDescriptor(e10, e10.length - 1) && e10.constructor.name !== "String");
  }, Rv = kv, Ov = Array.prototype.concat, Iv = Array.prototype.slice, nu = dh.exports = function(e10) {
    for (var n10 = [], r10 = 0, s10 = e10.length; r10 < s10; r10++) {
      var i10 = e10[r10];
      Rv(i10) ? n10 = Ov.call(n10, Iv.call(i10)) : n10.push(i10);
    }
    return n10;
  };
  nu.wrap = function(t10) {
    return function() {
      return t10(nu(arguments));
    };
  };
  var bi = Av, z0 = dh.exports, fh = {};
  for (var co in bi)
    bi.hasOwnProperty(co) && (fh[bi[co]] = co);
  var Kt$1 = cc.exports = {
    to: {},
    get: {}
  };
  Kt$1.get = function(t10) {
    var e10 = t10.substring(0, 3).toLowerCase(), n10, r10;
    switch (e10) {
      case "hsl":
        n10 = Kt$1.get.hsl(t10), r10 = "hsl";
        break;
      case "hwb":
        n10 = Kt$1.get.hwb(t10), r10 = "hwb";
        break;
      default:
        n10 = Kt$1.get.rgb(t10), r10 = "rgb";
        break;
    }
    return n10 ? { model: r10, value: n10 } : null;
  };
  Kt$1.get.rgb = function(t10) {
    if (!t10)
      return null;
    var e10 = /^#([a-f0-9]{3,4})$/i, n10 = /^#([a-f0-9]{6})([a-f0-9]{2})?$/i, r10 = /^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/, s10 = /^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/, i10 = /(\D+)/, o10 = [0, 0, 0, 1], l10, a10, c10;
    if (l10 = t10.match(n10)) {
      for (c10 = l10[2], l10 = l10[1], a10 = 0; a10 < 3; a10++) {
        var u10 = a10 * 2;
        o10[a10] = parseInt(l10.slice(u10, u10 + 2), 16);
      }
      c10 && (o10[3] = parseInt(c10, 16) / 255);
    } else if (l10 = t10.match(e10)) {
      for (l10 = l10[1], c10 = l10[3], a10 = 0; a10 < 3; a10++)
        o10[a10] = parseInt(l10[a10] + l10[a10], 16);
      c10 && (o10[3] = parseInt(c10 + c10, 16) / 255);
    } else if (l10 = t10.match(r10)) {
      for (a10 = 0; a10 < 3; a10++)
        o10[a10] = parseInt(l10[a10 + 1], 0);
      l10[4] && (o10[3] = parseFloat(l10[4]));
    } else if (l10 = t10.match(s10)) {
      for (a10 = 0; a10 < 3; a10++)
        o10[a10] = Math.round(parseFloat(l10[a10 + 1]) * 2.55);
      l10[4] && (o10[3] = parseFloat(l10[4]));
    } else
      return (l10 = t10.match(i10)) ? l10[1] === "transparent" ? [0, 0, 0, 0] : (o10 = bi[l10[1]], o10 ? (o10[3] = 1, o10) : null) : null;
    for (a10 = 0; a10 < 3; a10++)
      o10[a10] = fr(o10[a10], 0, 255);
    return o10[3] = fr(o10[3], 0, 1), o10;
  };
  Kt$1.get.hsl = function(t10) {
    if (!t10)
      return null;
    var e10 = /^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/, n10 = t10.match(e10);
    if (n10) {
      var r10 = parseFloat(n10[4]), s10 = (parseFloat(n10[1]) + 360) % 360, i10 = fr(parseFloat(n10[2]), 0, 100), o10 = fr(parseFloat(n10[3]), 0, 100), l10 = fr(isNaN(r10) ? 1 : r10, 0, 1);
      return [s10, i10, o10, l10];
    }
    return null;
  };
  Kt$1.get.hwb = function(t10) {
    if (!t10)
      return null;
    var e10 = /^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/, n10 = t10.match(e10);
    if (n10) {
      var r10 = parseFloat(n10[4]), s10 = (parseFloat(n10[1]) % 360 + 360) % 360, i10 = fr(parseFloat(n10[2]), 0, 100), o10 = fr(parseFloat(n10[3]), 0, 100), l10 = fr(isNaN(r10) ? 1 : r10, 0, 1);
      return [s10, i10, o10, l10];
    }
    return null;
  };
  Kt$1.to.hex = function() {
    var t10 = z0(arguments);
    return "#" + pi(t10[0]) + pi(t10[1]) + pi(t10[2]) + (t10[3] < 1 ? pi(Math.round(t10[3] * 255)) : "");
  };
  Kt$1.to.rgb = function() {
    var t10 = z0(arguments);
    return t10.length < 4 || t10[3] === 1 ? "rgb(" + Math.round(t10[0]) + ", " + Math.round(t10[1]) + ", " + Math.round(t10[2]) + ")" : "rgba(" + Math.round(t10[0]) + ", " + Math.round(t10[1]) + ", " + Math.round(t10[2]) + ", " + t10[3] + ")";
  };
  Kt$1.to.rgb.percent = function() {
    var t10 = z0(arguments), e10 = Math.round(t10[0] / 255 * 100), n10 = Math.round(t10[1] / 255 * 100), r10 = Math.round(t10[2] / 255 * 100);
    return t10.length < 4 || t10[3] === 1 ? "rgb(" + e10 + "%, " + n10 + "%, " + r10 + "%)" : "rgba(" + e10 + "%, " + n10 + "%, " + r10 + "%, " + t10[3] + ")";
  };
  Kt$1.to.hsl = function() {
    var t10 = z0(arguments);
    return t10.length < 4 || t10[3] === 1 ? "hsl(" + t10[0] + ", " + t10[1] + "%, " + t10[2] + "%)" : "hsla(" + t10[0] + ", " + t10[1] + "%, " + t10[2] + "%, " + t10[3] + ")";
  };
  Kt$1.to.hwb = function() {
    var t10 = z0(arguments), e10 = "";
    return t10.length >= 4 && t10[3] !== 1 && (e10 = ", " + t10[3]), "hwb(" + t10[0] + ", " + t10[1] + "%, " + t10[2] + "%" + e10 + ")";
  };
  Kt$1.to.keyword = function(t10) {
    return fh[t10.slice(0, 3)];
  };
  function fr(t10, e10, n10) {
    return Math.min(Math.max(e10, t10), n10);
  }
  function pi(t10) {
    var e10 = t10.toString(16).toUpperCase();
    return e10.length < 2 ? "0" + e10 : e10;
  }
  function Mv(t10) {
    const e10 = cc.exports.get.rgb(t10), [n10, r10, s10] = e10;
    return (n10 * 299 + r10 * 587 + s10 * 114) / 1e3;
  }
  function Nv(t10) {
    const e10 = cc.exports.get.rgb(t10), [n10, r10, s10] = e10;
    return `rgb(${n10}, ${r10}, ${s10})`;
  }
  const Pv = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
  <g clip-path="url(#clip0_544_54)">
    <path d="M15.5489 4.19771C15.5489 5.18773 15.1485 6.13721 14.4358 6.83726C13.7231 7.53731 12.7565 7.93058 11.7486 7.93058C10.7407 7.93058 9.77403 7.53731 9.06133 6.83726C8.34863 6.13721 7.94824 5.18773 7.94824 4.19771C7.94824 3.20768 8.34863 2.25822 9.06133 1.55818C9.77403 0.858126 10.7407 0.464844 11.7486 0.464844C12.7565 0.464844 13.7231 0.858126 14.4358 1.55818C15.1485 2.25822 15.5489 3.20768 15.5489 4.19771Z" stroke="black"/>
    <path d="M6.54883 11.2152L17.2025 11.2073M11.7471 8.06641V19.5806V8.06641ZM11.7471 19.4385L6.79789 23.5738L11.7471 19.4385ZM11.7551 19.4385L17.1864 23.3055L11.7551 19.4385Z" stroke="black"/>
  </g>
  <defs>
    <clipPath id="clip0_544_54">
      <rect width="24" height="24" fill="white"/>
    </clipPath>
  </defs>
</svg>
`, Fv = `<svg width="101" height="78" viewBox="0 0 101 78" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M96.3563 39.4479C96.3563 48.4904 92.6755 57.1625 86.1237 63.5566C79.5718 69.9506 70.6856 73.5427 61.4199 73.5427C52.1541 73.5427 43.2679 69.9506 36.7161 63.5566C30.1642 57.1625 26.4834 48.4904 26.4834 39.4479C26.4834 30.147 30.1642 21.2271 36.7161 14.6504C43.2679 8.07366 52.1541 4.37891 61.4199 4.37891C70.6856 4.37891 79.5718 8.07366 86.1237 14.6504C92.6755 21.2271 96.3563 30.147 96.3563 39.4479V39.4479Z" stroke="black" stroke-width="7.56826"/>
	<path d="M27.3611 39.4482H3.93945" stroke="black" stroke-width="8"/>
	<path d="M4.91504 4.37891V74.5168" stroke="black" stroke-width="8"/>
</svg>
`, Dv = `<svg width="77" height="86" viewBox="0 0 77 86" fill="none" xmlns="http://www.w3.org/2000/svg">
	<g clip-path="url(#clip0_544_57)">
		<path d="M74.0149 46.8888C74.0149 51.5755 73.0918 56.2163 71.2983 60.5463C69.5048 64.8762 66.876 68.8105 63.562 72.1245C60.248 75.4385 56.3137 78.0673 51.9838 79.8608C47.6538 81.6543 43.013 82.5774 38.3263 82.5774C33.6396 82.5774 28.9988 81.6543 24.6689 79.8608C20.3389 78.0673 16.4046 75.4385 13.0907 72.1245C9.77666 68.8105 7.14785 64.8762 5.35433 60.5463C3.56081 56.2163 2.6377 51.5755 2.6377 46.8888C2.6377 42.2021 3.56081 37.5613 5.35433 33.2314C7.14785 28.9014 9.77666 24.9671 13.0907 21.6532C16.4046 18.3392 20.3389 15.7104 24.6689 13.9168C28.9988 12.1233 33.6396 11.2002 38.3263 11.2002C43.013 11.2002 47.6538 12.1233 51.9838 13.9168C56.3137 15.7104 60.248 18.3392 63.562 21.6532C66.876 24.9671 69.5048 28.9014 71.2983 33.2314C73.0918 37.5613 74.0149 42.2021 74.0149 46.8888V46.8888Z" stroke="black" stroke-width="4.98203"/>
		<path d="M47.5352 2.30371L37.5352 11.5001L47.5352 20.6966" stroke="black" stroke-width="6"/>
	</g>
	<defs>
		<clipPath id="clip0_544_57">
			<rect width="77" height="86" fill="white"/>
		</clipPath>
	</defs>
</svg>
`, Bv = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
  <path fill-rule="evenodd" clip-rule="evenodd" d="M12.258 0.001L12.514 0.005L12.769 0.01L13.022 0.018L13.273 0.028L13.522 0.04L13.769 0.055L14.015 0.071L14.257 0.09L14.498 0.11L14.737 0.133L14.973 0.157L15.206 0.184L15.437 0.212L15.666 0.243L15.891 0.275L16.114 0.309L16.334 0.345L16.551 0.383L16.765 0.423L16.976 0.464L17.184 0.507L17.389 0.552L17.59 0.598L17.788 0.646L17.982 0.696L18.173 0.747L18.36 0.8L18.543 0.854L18.723 0.91L18.898 0.967L19.07 1.026L19.238 1.086L19.401 1.147L19.561 1.21L19.716 1.274L19.866 1.34L19.94 1.373L20.013 1.406L20.084 1.44L20.154 1.474L20.223 1.509L20.291 1.544L20.358 1.579L20.424 1.614L20.488 1.65L20.552 1.686L20.614 1.722L20.674 1.758L20.734 1.795L20.792 1.832L20.85 1.869L20.905 1.907L20.96 1.945L21.013 1.983L21.065 2.021L21.116 2.06L21.166 2.099L21.214 2.138L21.261 2.177L21.306 2.217L21.35 2.257L21.393 2.297L21.434 2.337L21.474 2.378L21.513 2.419L21.55 2.46L21.586 2.501L21.62 2.542L21.653 2.584L21.685 2.626L21.715 2.668L21.744 2.71L21.771 2.752L21.797 2.795L21.821 2.838L21.844 2.881L21.865 2.924L21.885 2.967L21.903 3.011L21.92 3.054L21.935 3.098L21.948 3.142L21.96 3.186L21.971 3.231L21.98 3.275L21.987 3.32L21.993 3.365L21.997 3.41L21.999 3.455L22 3.5V20.5L21.999 20.545L21.997 20.59L21.993 20.635L21.987 20.68L21.98 20.725L21.971 20.769L21.96 20.814L21.948 20.858L21.935 20.902L21.92 20.946L21.903 20.989L21.885 21.033L21.865 21.076L21.844 21.119L21.821 21.162L21.797 21.205L21.771 21.248L21.744 21.29L21.715 21.332L21.685 21.374L21.653 21.416L21.62 21.458L21.586 21.499L21.55 21.54L21.513 21.581L21.474 21.622L21.434 21.663L21.393 21.703L21.35 21.743L21.306 21.783L21.261 21.823L21.214 21.862L21.166 21.901L21.116 21.94L21.065 21.979L21.013 22.017L20.96 22.055L20.905 22.093L20.85 22.131L20.792 22.168L20.734 22.205L20.674 22.242L20.614 22.278L20.552 22.314L20.488 22.35L20.424 22.386L20.358 22.421L20.291 22.456L20.223 22.491L20.154 22.526L20.084 22.56L20.013 22.594L19.94 22.627L19.866 22.66L19.716 22.726L19.561 22.79L19.401 22.853L19.238 22.914L19.07 22.974L18.898 23.033L18.723 23.09L18.543 23.146L18.36 23.2L18.173 23.253L17.982 23.304L17.788 23.354L17.59 23.402L17.389 23.448L17.184 23.493L16.976 23.536L16.765 23.577L16.551 23.617L16.334 23.655L16.114 23.691L15.891 23.725L15.666 23.757L15.437 23.788L15.206 23.816L14.973 23.843L14.737 23.867L14.498 23.89L14.257 23.91L14.015 23.929L13.769 23.945L13.522 23.96L13.273 23.972L13.022 23.982L12.769 23.99L12.514 23.995L12.258 23.999L12 24L11.742 23.999L11.486 23.995L11.231 23.99L10.978 23.982L10.727 23.972L10.478 23.96L10.231 23.945L9.986 23.929L9.743 23.91L9.502 23.89L9.264 23.867L9.028 23.843L8.794 23.816L8.563 23.788L8.335 23.757L8.109 23.725L7.886 23.691L7.666 23.655L7.449 23.617L7.235 23.577L7.024 23.536L6.816 23.493L6.612 23.448L6.411 23.402L6.213 23.354L6.018 23.304L5.828 23.253L5.641 23.2L5.457 23.146L5.278 23.09L5.102 23.033L4.93 22.974L4.763 22.914L4.599 22.853L4.44 22.79L4.285 22.726L4.134 22.66L4.06 22.627L3.988 22.594L3.916 22.56L3.846 22.526L3.777 22.491L3.709 22.456L3.642 22.421L3.576 22.386L3.512 22.35L3.449 22.314L3.387 22.278L3.326 22.242L3.266 22.205L3.208 22.168L3.151 22.131L3.095 22.093L3.04 22.055L2.987 22.017L2.935 21.979L2.884 21.94L2.835 21.901L2.786 21.862L2.74 21.823L2.694 21.783L2.65 21.743L2.607 21.703L2.566 21.663L2.526 21.622L2.487 21.581L2.45 21.54L2.414 21.499L2.38 21.458L2.347 21.416L2.315 21.374L2.285 21.332L2.256 21.29L2.229 21.248L2.203 21.205L2.179 21.162L2.156 21.119L2.135 21.076L2.115 21.033L2.097 20.989L2.08 20.946L2.065 20.902L2.052 20.858L2.04 20.814L2.029 20.769L2.02 20.725L2.013 20.68L2.007 20.635L2.003 20.59L2.001 20.545L2 20.5V3.5L2.001 3.455L2.003 3.41L2.007 3.365L2.013 3.32L2.02 3.275L2.029 3.231L2.04 3.186L2.052 3.142L2.065 3.098L2.08 3.054L2.097 3.011L2.115 2.967L2.135 2.924L2.156 2.881L2.179 2.838L2.203 2.795L2.229 2.752L2.256 2.71L2.285 2.668L2.315 2.626L2.347 2.584L2.38 2.542L2.414 2.501L2.45 2.46L2.487 2.419L2.526 2.378L2.566 2.337L2.607 2.297L2.65 2.257L2.694 2.217L2.74 2.177L2.786 2.138L2.835 2.099L2.884 2.06L2.935 2.021L2.987 1.983L3.04 1.945L3.095 1.907L3.151 1.869L3.208 1.832L3.266 1.795L3.326 1.758L3.387 1.722L3.449 1.686L3.512 1.65L3.576 1.614L3.642 1.579L3.709 1.544L3.777 1.509L3.846 1.474L3.916 1.44L3.988 1.406L4.06 1.373L4.134 1.34L4.285 1.274L4.44 1.21L4.599 1.147L4.763 1.086L4.93 1.026L5.102 0.967L5.278 0.91L5.457 0.854L5.641 0.8L5.828 0.747L6.018 0.696L6.213 0.646L6.411 0.598L6.612 0.552L6.816 0.507L7.024 0.464L7.235 0.423L7.449 0.383L7.666 0.345L7.886 0.309L8.109 0.275L8.335 0.243L8.563 0.212L8.794 0.184L9.028 0.157L9.264 0.133L9.502 0.11L9.743 0.09L9.986 0.071L10.231 0.055L10.478 0.04L10.727 0.028L10.978 0.018L11.231 0.01L11.486 0.005L11.742 0.001L12 0L12.258 0.001V0.001ZM3 20.5V20.51L3.001 20.531L3.004 20.552L3.008 20.574L3.013 20.595L3.019 20.617L3.026 20.639L3.035 20.662L3.045 20.684L3.056 20.707L3.068 20.73L3.081 20.753L3.096 20.776L3.112 20.8L3.129 20.823L3.147 20.847L3.166 20.871L3.187 20.895L3.209 20.92L3.232 20.944L3.256 20.969L3.308 21.018L3.364 21.068L3.425 21.119L3.491 21.17L3.561 21.221L3.636 21.272L3.715 21.324L3.799 21.376L3.887 21.428L3.979 21.48L4.076 21.532L4.178 21.583L4.283 21.635L4.393 21.687L4.507 21.738L4.626 21.789L4.749 21.84L4.876 21.89L5.007 21.94L5.142 21.99L5.281 22.038L5.425 22.087L5.572 22.134L5.724 22.181L5.879 22.228L6.039 22.273L6.202 22.318L6.369 22.361L6.54 22.404L6.716 22.445L6.894 22.486L7.077 22.525L7.264 22.564L7.454 22.601L7.648 22.636L7.845 22.671L8.047 22.704L8.251 22.735L8.46 22.765L8.672 22.794L8.888 22.821L9.107 22.846L9.329 22.87L9.555 22.891L9.785 22.911L10.018 22.929L10.254 22.945L10.494 22.96L10.737 22.972L10.983 22.982L11.232 22.99L11.485 22.995L11.741 22.999L12 23L12.26 22.999L12.517 22.995L12.771 22.99L13.021 22.982L13.268 22.971L13.512 22.959L13.753 22.945L13.99 22.929L14.223 22.911L14.454 22.89L14.68 22.869L14.904 22.845L15.124 22.819L15.34 22.792L15.552 22.764L15.762 22.733L15.967 22.702L16.169 22.668L16.367 22.634L16.561 22.598L16.752 22.561L16.939 22.522L17.122 22.482L17.301 22.442L17.476 22.4L17.648 22.357L17.816 22.313L17.979 22.268L18.139 22.222L18.294 22.176L18.446 22.129L18.594 22.081L18.737 22.032L18.876 21.983L19.012 21.933L19.143 21.883L19.269 21.833L19.392 21.782L19.51 21.73L19.624 21.679L19.734 21.627L19.84 21.575L19.941 21.523L20.037 21.471L20.129 21.419L20.217 21.366L20.3 21.315L20.379 21.263L20.453 21.211L20.523 21.16L20.588 21.109L20.648 21.058L20.704 21.008L20.755 20.958L20.778 20.934L20.801 20.909L20.822 20.885L20.842 20.861L20.861 20.837L20.879 20.813L20.896 20.789L20.911 20.766L20.925 20.742L20.938 20.719L20.95 20.696L20.96 20.673L20.97 20.651L20.978 20.629L20.984 20.607L20.99 20.585L20.994 20.563L20.998 20.542L20.999 20.521L21 20.5V16.373L20.923 16.428L20.843 16.481L20.76 16.535L20.675 16.588L20.588 16.64L20.498 16.692L20.405 16.743L20.31 16.793L20.213 16.843L20.113 16.892L20.011 16.941L19.906 16.989L19.8 17.036L19.691 17.083L19.58 17.129L19.466 17.174L19.351 17.219L19.233 17.263L19.113 17.306L18.991 17.348L18.867 17.39L18.741 17.431L18.613 17.471L18.483 17.511L18.351 17.549L18.217 17.587L18.082 17.624L17.944 17.661L17.805 17.696L17.663 17.731L17.52 17.765L17.376 17.798L17.229 17.83L17.081 17.861L16.931 17.891L16.78 17.921L16.627 17.95L16.473 17.977L16.317 18.004L16.159 18.03L16 18.055L15.839 18.079L15.677 18.102L15.514 18.124L15.349 18.145L15.183 18.165L15.016 18.184L14.847 18.202L14.678 18.219L14.507 18.235L14.334 18.25L14.161 18.264L13.986 18.277L13.811 18.289L13.634 18.3L13.456 18.31L13.277 18.318L13.098 18.326L12.917 18.332L12.735 18.337L12.553 18.341L12.369 18.344L12.185 18.346H11.815L11.631 18.344L11.447 18.341L11.265 18.337L11.083 18.332L10.902 18.326L10.723 18.318L10.544 18.31L10.366 18.3L10.19 18.289L10.014 18.277L9.839 18.264L9.666 18.25L9.494 18.235L9.323 18.219L9.153 18.202L8.984 18.184L8.817 18.165L8.651 18.145L8.486 18.124L8.323 18.102L8.161 18.079L8 18.055L7.841 18.03L7.684 18.004L7.528 17.977L7.373 17.95L7.22 17.921L7.069 17.891L6.919 17.861L6.771 17.83L6.625 17.798L6.48 17.765L6.337 17.731L6.196 17.696L6.056 17.661L5.919 17.624L5.783 17.587L5.649 17.549L5.517 17.511L5.387 17.471L5.259 17.431L5.133 17.39L5.009 17.348L4.887 17.306L4.767 17.262L4.65 17.219L4.534 17.174L4.421 17.129L4.309 17.083L4.2 17.036L4.094 16.989L3.989 16.941L3.887 16.892L3.787 16.843L3.69 16.793L3.595 16.743L3.502 16.691L3.412 16.64L3.325 16.588L3.24 16.535L3.157 16.481L3.077 16.427L3 16.373V20.5V20.5ZM3 14.846V14.857L3.001 14.878L3.004 14.899L3.008 14.92L3.013 14.942L3.019 14.964L3.026 14.986L3.035 15.008L3.045 15.03L3.056 15.053L3.068 15.076L3.081 15.099L3.096 15.123L3.112 15.146L3.129 15.17L3.147 15.194L3.166 15.218L3.187 15.242L3.209 15.266L3.232 15.291L3.256 15.315L3.308 15.365L3.364 15.415L3.425 15.465L3.491 15.516L3.561 15.567L3.636 15.619L3.715 15.67L3.799 15.722L3.887 15.774L3.979 15.826L4.076 15.878L4.178 15.93L4.283 15.982L4.393 16.033L4.507 16.084L4.626 16.136L4.749 16.186L4.876 16.237L5.007 16.287L5.142 16.336L5.281 16.385L5.425 16.433L5.572 16.481L5.724 16.528L5.879 16.574L6.039 16.619L6.202 16.664L6.369 16.708L6.54 16.75L6.716 16.792L6.894 16.832L7.077 16.872L7.264 16.91L7.454 16.947L7.648 16.983L7.845 17.017L8.047 17.05L8.251 17.082L8.46 17.112L8.672 17.14L8.888 17.167L9.107 17.192L9.329 17.216L9.555 17.238L9.785 17.258L10.018 17.276L10.254 17.292L10.494 17.306L10.737 17.318L10.983 17.328L11.232 17.336L11.485 17.342L11.741 17.345L12 17.346L12.26 17.345L12.517 17.342L12.771 17.336L13.021 17.328L13.268 17.318L13.512 17.306L13.753 17.291L13.99 17.275L14.223 17.257L14.454 17.237L14.68 17.215L14.904 17.191L15.124 17.166L15.34 17.139L15.552 17.11L15.762 17.08L15.967 17.048L16.169 17.015L16.367 16.98L16.561 16.944L16.752 16.907L16.939 16.868L17.122 16.829L17.301 16.788L17.476 16.746L17.648 16.703L17.816 16.659L17.979 16.614L18.139 16.569L18.294 16.522L18.446 16.475L18.594 16.427L18.737 16.379L18.876 16.329L19.012 16.28L19.143 16.23L19.269 16.179L19.392 16.128L19.51 16.077L19.624 16.025L19.734 15.973L19.84 15.921L19.941 15.869L20.037 15.817L20.129 15.765L20.217 15.713L20.3 15.661L20.379 15.609L20.453 15.558L20.523 15.506L20.588 15.455L20.648 15.405L20.704 15.354L20.755 15.305L20.778 15.28L20.801 15.256L20.822 15.231L20.842 15.207L20.861 15.183L20.879 15.159L20.896 15.135L20.911 15.112L20.925 15.089L20.938 15.065L20.95 15.043L20.96 15.02L20.97 14.997L20.978 14.975L20.984 14.953L20.99 14.931L20.994 14.91L20.998 14.888L20.999 14.867L21 14.846V10.707L20.923 10.761L20.843 10.815L20.76 10.869L20.675 10.921L20.588 10.974L20.498 11.025L20.405 11.076L20.31 11.127L20.213 11.177L20.113 11.226L20.011 11.275L19.906 11.323L19.8 11.37L19.691 11.417L19.58 11.463L19.466 11.508L19.351 11.552L19.233 11.596L19.113 11.64L18.991 11.682L18.867 11.724L18.741 11.765L18.613 11.805L18.483 11.844L18.351 11.883L18.217 11.921L18.082 11.958L17.944 11.994L17.805 12.03L17.663 12.065L17.52 12.098L17.376 12.131L17.229 12.164L17.081 12.195L16.931 12.225L16.78 12.255L16.627 12.283L16.473 12.311L16.317 12.338L16.159 12.364L16 12.389L15.839 12.413L15.677 12.436L15.514 12.458L15.349 12.479L15.183 12.499L15.016 12.518L14.847 12.536L14.678 12.553L14.507 12.569L14.334 12.584L14.161 12.598L13.986 12.611L13.811 12.623L13.634 12.634L13.456 12.643L13.277 12.652L13.098 12.659L12.917 12.666L12.735 12.671L12.553 12.675L12.369 12.678L12.185 12.68H11.815L11.631 12.678L11.447 12.675L11.265 12.671L11.083 12.666L10.902 12.659L10.723 12.652L10.544 12.643L10.366 12.634L10.19 12.623L10.014 12.611L9.839 12.598L9.666 12.584L9.494 12.569L9.323 12.553L9.153 12.536L8.984 12.518L8.817 12.499L8.651 12.479L8.486 12.458L8.323 12.436L8.161 12.413L8 12.389L7.841 12.364L7.684 12.338L7.528 12.311L7.373 12.283L7.22 12.255L7.069 12.225L6.919 12.195L6.771 12.164L6.625 12.131L6.48 12.098L6.337 12.065L6.196 12.03L6.056 11.994L5.919 11.958L5.783 11.921L5.649 11.883L5.517 11.844L5.387 11.805L5.259 11.765L5.133 11.724L5.009 11.682L4.887 11.639L4.767 11.596L4.65 11.552L4.534 11.508L4.421 11.462L4.309 11.416L4.2 11.37L4.094 11.323L3.989 11.275L3.887 11.226L3.787 11.177L3.69 11.127L3.595 11.076L3.502 11.025L3.412 10.974L3.325 10.921L3.24 10.869L3.157 10.815L3.077 10.761L3 10.707V14.846V14.846ZM3 9.18V9.191L3.001 9.211L3.004 9.233L3.008 9.254L3.013 9.276L3.019 9.297L3.026 9.319L3.035 9.342L3.045 9.364L3.056 9.387L3.068 9.41L3.081 9.433L3.096 9.456L3.112 9.48L3.129 9.504L3.147 9.527L3.166 9.551L3.187 9.576L3.209 9.6L3.232 9.624L3.256 9.649L3.308 9.699L3.364 9.749L3.425 9.799L3.491 9.85L3.561 9.901L3.636 9.953L3.715 10.004L3.799 10.056L3.887 10.108L3.979 10.16L4.076 10.212L4.178 10.264L4.283 10.315L4.393 10.367L4.507 10.418L4.626 10.469L4.749 10.52L4.876 10.57L5.007 10.62L5.142 10.67L5.281 10.719L5.425 10.767L5.572 10.815L5.724 10.862L5.879 10.908L6.039 10.953L6.202 10.998L6.369 11.041L6.54 11.084L6.716 11.126L6.894 11.166L7.077 11.206L7.264 11.244L7.454 11.281L7.648 11.317L7.845 11.351L8.047 11.384L8.251 11.416L8.46 11.446L8.672 11.474L8.888 11.501L9.107 11.526L9.329 11.55L9.555 11.571L9.785 11.591L10.018 11.609L10.254 11.626L10.494 11.64L10.737 11.652L10.983 11.662L11.232 11.67L11.485 11.676L11.741 11.679L12 11.68L12.26 11.679L12.517 11.676L12.771 11.67L13.021 11.662L13.268 11.652L13.512 11.639L13.753 11.625L13.99 11.609L14.223 11.591L14.454 11.571L14.68 11.549L14.904 11.525L15.124 11.5L15.34 11.473L15.552 11.444L15.762 11.414L15.967 11.382L16.169 11.349L16.367 11.314L16.561 11.278L16.752 11.241L16.939 11.202L17.122 11.163L17.301 11.122L17.476 11.08L17.648 11.037L17.816 10.993L17.979 10.948L18.139 10.903L18.294 10.856L18.446 10.809L18.594 10.761L18.737 10.712L18.876 10.663L19.012 10.614L19.143 10.563L19.269 10.513L19.392 10.462L19.51 10.41L19.624 10.359L19.734 10.307L19.84 10.255L19.941 10.203L20.037 10.151L20.129 10.099L20.217 10.047L20.3 9.995L20.379 9.943L20.453 9.891L20.523 9.84L20.588 9.789L20.648 9.738L20.704 9.688L20.755 9.639L20.778 9.614L20.801 9.589L20.822 9.565L20.842 9.541L20.861 9.517L20.879 9.493L20.896 9.469L20.911 9.446L20.925 9.422L20.938 9.399L20.95 9.376L20.96 9.354L20.97 9.331L20.978 9.309L20.984 9.287L20.99 9.265L20.994 9.243L20.998 9.222L20.999 9.201L21 9.18V5.027L20.923 5.081L20.843 5.135L20.76 5.188L20.675 5.241L20.588 5.294L20.498 5.345L20.405 5.396L20.31 5.447L20.213 5.497L20.113 5.546L20.011 5.594L19.906 5.642L19.8 5.69L19.691 5.736L19.58 5.782L19.466 5.828L19.351 5.872L19.233 5.916L19.113 5.959L18.991 6.002L18.867 6.044L18.741 6.085L18.613 6.125L18.483 6.164L18.351 6.203L18.217 6.241L18.082 6.278L17.944 6.314L17.805 6.35L17.663 6.384L17.52 6.418L17.376 6.451L17.229 6.483L17.081 6.515L16.931 6.545L16.78 6.575L16.627 6.603L16.473 6.631L16.317 6.658L16.159 6.684L16 6.708L15.839 6.732L15.677 6.755L15.514 6.778L15.349 6.799L15.183 6.819L15.016 6.838L14.847 6.856L14.678 6.873L14.507 6.889L14.334 6.904L14.161 6.918L13.986 6.931L13.811 6.943L13.634 6.953L13.456 6.963L13.277 6.972L13.098 6.979L12.917 6.985L12.735 6.991L12.553 6.995L12.369 6.998L12.185 6.999L12 7L11.815 6.999L11.631 6.998L11.447 6.995L11.265 6.991L11.083 6.985L10.902 6.979L10.723 6.972L10.544 6.963L10.366 6.953L10.19 6.943L10.014 6.931L9.839 6.918L9.666 6.904L9.494 6.889L9.323 6.873L9.153 6.856L8.984 6.838L8.817 6.819L8.651 6.799L8.486 6.778L8.323 6.755L8.161 6.732L8 6.708L7.841 6.684L7.684 6.658L7.528 6.631L7.373 6.603L7.22 6.575L7.069 6.545L6.919 6.515L6.771 6.483L6.625 6.451L6.48 6.418L6.337 6.384L6.196 6.35L6.056 6.314L5.919 6.278L5.783 6.241L5.649 6.203L5.517 6.164L5.387 6.125L5.259 6.084L5.133 6.043L5.009 6.002L4.887 5.959L4.767 5.916L4.65 5.872L4.534 5.828L4.421 5.782L4.309 5.736L4.2 5.69L4.094 5.642L3.989 5.594L3.887 5.546L3.787 5.496L3.69 5.447L3.595 5.396L3.502 5.345L3.412 5.293L3.325 5.241L3.24 5.188L3.157 5.135L3.077 5.081L3 5.027V9.18V9.18ZM11.74 1.001L11.483 1.005L11.229 1.01L10.979 1.018L10.732 1.029L10.488 1.041L10.247 1.055L10.01 1.071L9.777 1.089L9.546 1.11L9.32 1.132L9.096 1.155L8.876 1.181L8.66 1.208L8.448 1.236L8.238 1.267L8.033 1.299L7.831 1.332L7.633 1.366L7.439 1.402L7.248 1.44L7.061 1.478L6.878 1.518L6.699 1.559L6.524 1.601L6.352 1.644L6.184 1.687L6.021 1.732L5.861 1.778L5.706 1.824L5.554 1.872L5.406 1.92L5.263 1.968L5.124 2.017L4.988 2.067L4.857 2.117L4.731 2.168L4.608 2.219L4.49 2.27L4.376 2.322L4.266 2.374L4.16 2.426L4.059 2.478L3.963 2.53L3.871 2.582L3.783 2.634L3.7 2.686L3.621 2.738L3.547 2.789L3.477 2.841L3.412 2.892L3.352 2.942L3.296 2.992L3.245 3.042L3.222 3.067L3.199 3.091L3.178 3.115L3.158 3.14L3.139 3.164L3.121 3.188L3.104 3.211L3.089 3.235L3.075 3.258L3.062 3.281L3.05 3.304L3.04 3.327L3.03 3.349L3.022 3.371L3.016 3.394L3.01 3.415L3.006 3.437L3.002 3.458L3.001 3.479L3 3.5L3.001 3.521L3.002 3.542L3.006 3.563L3.01 3.585L3.016 3.606L3.022 3.629L3.03 3.651L3.04 3.673L3.05 3.696L3.062 3.719L3.075 3.742L3.089 3.765L3.104 3.789L3.121 3.812L3.139 3.836L3.158 3.86L3.178 3.885L3.199 3.909L3.222 3.933L3.245 3.958L3.296 4.008L3.352 4.058L3.412 4.108L3.477 4.159L3.547 4.211L3.621 4.262L3.7 4.314L3.783 4.366L3.871 4.418L3.963 4.47L4.059 4.522L4.16 4.574L4.266 4.626L4.376 4.678L4.49 4.73L4.608 4.781L4.731 4.832L4.857 4.883L4.988 4.933L5.124 4.983L5.263 5.032L5.406 5.08L5.554 5.128L5.706 5.176L5.861 5.222L6.021 5.268L6.184 5.313L6.352 5.356L6.524 5.399L6.699 5.441L6.878 5.482L7.061 5.522L7.248 5.56L7.439 5.598L7.633 5.634L7.831 5.668L8.033 5.701L8.238 5.733L8.448 5.764L8.66 5.792L8.876 5.819L9.096 5.845L9.32 5.868L9.546 5.89L9.777 5.911L10.01 5.929L10.247 5.945L10.488 5.959L10.732 5.971L10.979 5.982L11.229 5.99L11.483 5.995L11.74 5.999L12 6L12.26 5.999L12.517 5.995L12.771 5.99L13.021 5.982L13.268 5.971L13.512 5.959L13.753 5.945L13.99 5.929L14.223 5.911L14.454 5.89L14.68 5.868L14.904 5.845L15.124 5.819L15.34 5.792L15.552 5.764L15.762 5.733L15.967 5.701L16.169 5.668L16.367 5.634L16.561 5.598L16.752 5.56L16.939 5.522L17.122 5.482L17.301 5.441L17.476 5.399L17.648 5.356L17.816 5.313L17.979 5.268L18.139 5.222L18.294 5.176L18.446 5.128L18.594 5.08L18.737 5.032L18.876 4.983L19.012 4.933L19.143 4.883L19.269 4.832L19.392 4.781L19.51 4.73L19.624 4.678L19.734 4.626L19.84 4.574L19.941 4.522L20.037 4.47L20.129 4.418L20.217 4.366L20.3 4.314L20.379 4.262L20.453 4.211L20.523 4.159L20.588 4.108L20.648 4.058L20.704 4.008L20.755 3.958L20.778 3.933L20.801 3.909L20.822 3.885L20.842 3.86L20.861 3.836L20.879 3.812L20.896 3.789L20.911 3.765L20.925 3.742L20.938 3.719L20.95 3.696L20.96 3.673L20.97 3.651L20.978 3.629L20.984 3.606L20.99 3.585L20.994 3.563L20.998 3.542L20.999 3.521L21 3.5L20.999 3.479L20.998 3.458L20.994 3.437L20.99 3.415L20.984 3.394L20.978 3.371L20.97 3.349L20.96 3.327L20.95 3.304L20.938 3.281L20.925 3.258L20.911 3.235L20.896 3.211L20.879 3.188L20.861 3.164L20.842 3.14L20.822 3.115L20.801 3.091L20.778 3.067L20.755 3.042L20.704 2.992L20.648 2.942L20.588 2.892L20.523 2.841L20.453 2.789L20.379 2.738L20.3 2.686L20.217 2.634L20.129 2.582L20.037 2.53L19.941 2.478L19.84 2.426L19.734 2.374L19.624 2.322L19.51 2.27L19.392 2.219L19.269 2.168L19.143 2.117L19.012 2.067L18.876 2.017L18.737 1.968L18.594 1.92L18.446 1.872L18.294 1.824L18.139 1.778L17.979 1.732L17.816 1.687L17.648 1.644L17.476 1.601L17.301 1.559L17.122 1.518L16.939 1.478L16.752 1.44L16.561 1.402L16.367 1.366L16.169 1.332L15.967 1.299L15.762 1.267L15.552 1.236L15.34 1.208L15.124 1.181L14.904 1.155L14.68 1.132L14.454 1.11L14.223 1.089L13.99 1.071L13.753 1.055L13.512 1.041L13.268 1.029L13.021 1.018L12.771 1.01L12.517 1.005L12.26 1.001L12 1L11.74 1.001V1.001Z" fill="black"/>
</svg>
`, $v = `<svg width="77" height="80" viewBox="0 0 77 80" fill="none" xmlns="http://www.w3.org/2000/svg">
	<g clip-path="url(#clip0_544_61)">
		<path d="M74.0149 38.8888C74.0149 43.5755 73.0918 48.2163 71.2983 52.5463C69.5048 56.8762 66.876 60.8105 63.562 64.1245C60.248 67.4385 56.3137 70.0673 51.9838 71.8608C47.6538 73.6543 43.013 74.5774 38.3263 74.5774C33.6396 74.5774 28.9988 73.6543 24.6689 71.8608C20.3389 70.0673 16.4046 67.4385 13.0907 64.1245C9.77666 60.8105 7.14785 56.8762 5.35433 52.5463C3.56081 48.2163 2.6377 43.5755 2.6377 38.8888C2.6377 34.2021 3.56081 29.5613 5.35433 25.2314C7.14785 20.9014 9.77666 16.9671 13.0907 13.6532C16.4046 10.3392 20.3389 7.71035 24.6689 5.91683C28.9988 4.12331 33.6396 3.2002 38.3263 3.2002C43.013 3.2002 47.6538 4.12331 51.9838 5.91683C56.3137 7.71035 60.248 10.3392 63.562 13.6532C66.876 16.9671 69.5048 20.9014 71.2983 25.2314C73.0918 29.5613 74.0149 34.2021 74.0149 38.8888V38.8888Z" stroke="black" stroke-width="4.98203"/>
		<path d="M2.69922 75.4727L75.6992 75.5154" stroke="black" stroke-width="8"/>
	</g>
	<defs>
		<clipPath id="clip0_544_61">
			<rect width="77" height="80" fill="white"/>
		</clipPath>
	</defs>
</svg>
`, Hv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-CloudWatch_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#B0084D" offset="0%"></stop>
            <stop stop-color="#FF4F8B" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-CloudWatch_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Management-Governance" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M18.9074368,18.522369 L16.9527886,16.7879726 C16.8210145,16.9276688 16.6782593,17.0526083 16.5285161,17.1726289 L18.5220975,18.9453925 C18.6388972,19.048689 18.8235806,19.0408188 18.9303974,18.9227657 C19.0352176,18.8086477 19.0252348,18.627633 18.9074368,18.522369 M14.0248095,17.0831053 C15.6769763,17.0831053 17.0196739,15.7589433 17.0196739,14.1317785 C17.0196739,12.5046136 15.6769763,11.1804516 14.0248095,11.1804516 C12.3736409,11.1804516 11.0299451,12.5046136 11.0299451,14.1317785 C11.0299451,15.7589433 12.3736409,17.0831053 14.0248095,17.0831053 M19.6721255,19.5818954 C19.417562,19.8593201 19.0651663,20 18.7137689,20 C18.4062961,20 18.0988234,19.8937522 17.8542428,19.6763378 L15.6510209,17.7186243 C15.1528751,17.9380063 14.6048149,18.0668809 14.0248095,18.0668809 C11.8225858,18.0668809 10.0316569,16.3019875 10.0316569,14.1317785 C10.0316569,11.9625532 11.8225858,10.196676 14.0248095,10.196676 C16.2270331,10.196676 18.017962,11.9625532 18.017962,14.1317785 C18.017962,14.8017297 17.8312821,15.4234758 17.5307974,15.9763577 L19.5762898,17.7924075 C20.1013894,18.2606847 20.1443158,19.0634456 19.6721255,19.5818954 M6.53764845,14.1317785 L9.03336879,14.1317785 L9.03336879,15.1155541 L6.53764845,15.1155541 C5.3127489,15.1155541 4,13.9596177 4,12.2389942 C4,10.8459679 4.75171097,9.77660381 6.03251465,9.30832662 C6.03151636,9.27389447 6.03151636,9.23847855 6.03151636,9.2040464 C6.03151636,7.60934613 7.12963331,5.95463555 8.58713399,5.3555162 C10.2832255,4.65506796 12.0871322,5.00234075 13.4008794,6.28518415 C13.7492819,6.62458674 14.0437769,7.02498342 14.2813695,7.4814553 C14.6028183,7.28273263 14.9731832,7.17451731 15.3585224,7.17451731 C16.2619732,7.17451731 17.2722408,7.81593901 17.5048419,9.21388416 C18.7596901,9.54246521 19.9726102,10.4829547 19.9726102,12.2606372 C19.9726102,12.6334882 19.9206992,12.9876474 19.815879,13.3113096 L18.8645104,13.0142094 C18.9373854,12.7859734 18.9743221,12.5331431 18.9743221,12.2606372 C18.9743221,10.6147806 17.5637409,10.2035624 16.95778,10.1032173 C16.8250077,10.0805905 16.7072097,10.0077911 16.6313398,9.89859199 C16.5544716,9.79037667 16.524523,9.65559941 16.5504785,9.52574103 C16.4736103,8.54196541 15.8596631,8.15829292 15.3585224,8.15829292 C15.0270908,8.15829292 14.7146266,8.31963213 14.5009929,8.60099195 C14.3911812,8.74560697 14.2154825,8.81545504 14.0268061,8.7928282 C13.8461159,8.76626625 13.6933778,8.6432943 13.6314839,8.47310112 C13.4128588,7.87594932 13.0993964,7.37422376 12.6990828,6.98366484 C12.2099216,6.50751744 10.8652275,5.4804557 8.97247321,6.26354109 C7.88234257,6.71115899 7.0298045,8.00285638 7.0298045,9.2040464 C7.0298045,9.33882366 7.03679251,9.47163337 7.05376341,9.60050798 C7.07273089,9.74118789 7.02880621,9.8818678 6.93396884,9.98811557 C6.86009551,10.0707527 6.7602667,10.1258442 6.65245158,10.1465034 C6.02353005,10.3088264 4.99828814,10.7957953 4.99828814,12.2389942 C4.99828814,13.3545957 5.80989639,14.1317785 6.53764845,14.1317785" id="Amazon-CloudWatch_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Uv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-CloudFront_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#4D27A8" offset="0%"></stop>
            <stop stop-color="#A166FF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-CloudFront_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Networking-Content-Delivery" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M16,15.4980737 C16,15.2219556 15.775,14.9978597 15.5,14.9978597 C15.225,14.9978597 15,15.2219556 15,15.4980737 C15,15.7741919 15.225,15.9982877 15.5,15.9982877 C15.775,15.9982877 16,15.7741919 16,15.4980737 M17,15.4980737 C17,16.3254277 16.327,16.9987158 15.5,16.9987158 C14.673,16.9987158 14,16.3254277 14,15.4980737 C14,14.6707197 14.673,13.9974316 15.5,13.9974316 C16.327,13.9974316 17,14.6707197 17,15.4980737 M9,11.4963614 C9,11.2202433 8.775,10.9961474 8.5,10.9961474 C8.225,10.9961474 8,11.2202433 8,11.4963614 C8,11.7724796 8.225,11.9965755 8.5,11.9965755 C8.775,11.9965755 9,11.7724796 9,11.4963614 M10,11.4963614 C10,12.3237155 9.327,12.9970035 8.5,12.9970035 C7.673,12.9970035 7,12.3237155 7,11.4963614 C7,10.6690074 7.673,9.99571934 8.5,9.99571934 C9.327,9.99571934 10,10.6690074 10,11.4963614 M12,7.49464918 C12,7.77076733 12.225,7.99486321 12.5,7.99486321 C12.775,7.99486321 13,7.77076733 13,7.49464918 C13,7.21853103 12.775,6.99443515 12.5,6.99443515 C12.225,6.99443515 12,7.21853103 12,7.49464918 M11,7.49464918 C11,6.66729517 11.673,5.99400708 12.5,5.99400708 C13.327,5.99400708 14,6.66729517 14,7.49464918 C14,8.32200319 13.327,8.99529128 12.5,8.99529128 C11.673,8.99529128 11,8.32200319 11,7.49464918 M19,11.9965755 C19,9.73960976 17.903,7.63971125 16.101,6.33215177 C15.917,6.27312651 15.407,6.42319072 14.566,6.78434525 C14.415,6.84837265 14.287,6.90239576 14.197,6.93540989 L13.857,5.99400708 C13.935,5.96699552 14.044,5.91897498 14.173,5.86395143 C14.394,5.76991119 14.611,5.67987267 14.823,5.59983842 C13.939,5.20867105 12.979,4.99357901 12,4.99357901 C11.313,4.99357901 10.642,5.09162097 10.002,5.28470358 C9.956,5.29770915 9.915,5.32071899 9.87,5.33472499 C10.22,5.46578106 10.637,5.6348534 11.132,5.85694844 L10.724,6.76933883 C9.518,6.22810725 8.828,6.02702121 8.507,5.9519891 C6.692,7.00443943 5.429,8.82721936 5.104,10.9291187 C5.426,10.8871007 5.751,10.86209 6.097,10.8530862 L6.122,11.8535143 C5.725,11.8635185 5.363,11.9055365 5.001,11.9645618 C5.001,11.9745661 5,11.9855708 5,11.9965755 C5,14.29756 6.125,16.4174671 7.976,17.7180236 C7.775,17.0167235 7.604,16.1773644 7.604,15.3310022 C7.604,15.1749354 7.599,15.0098648 7.594,14.8427933 C7.578,14.3655891 7.562,13.8723781 7.65,13.4231859 L8.631,13.6162685 C8.564,13.9534128 8.579,14.388599 8.593,14.8097792 C8.599,14.9888558 8.604,15.1639307 8.604,15.3310022 C8.604,16.2293866 8.853,17.3548682 9.277,18.4433339 C10.504,18.9595548 11.859,19.1086186 13.154,18.8935266 C13.266,18.6874384 13.402,18.4783489 13.546,18.2662582 C13.76,17.9501229 13.981,17.6239833 14.067,17.3278566 L15.028,17.6069761 C14.938,17.9191096 14.774,18.2012303 14.601,18.4743472 C15.199,18.2352449 15.768,17.934116 16.279,17.5369461 C18.009,16.1983734 19,14.1785091 19,11.9965755 M20,11.9965755 C20,14.4906426 18.867,16.7986302 16.892,18.3272843 C16.193,18.8695163 15.416,19.2876952 14.582,19.5688155 C13.76,19.8539375 12.89,20 12,20 C10.686,20 9.381,19.6718596 8.225,19.0525946 C5.619,17.6569975 4,14.9538408 4,11.9965755 C4,11.8315048 4.004,11.6674346 4.018,11.5063657 C4.212,8.17393984 6.502,5.28270273 9.715,4.32629349 C11.729,3.71903366 14.052,3.96513896 15.91,5.01658886 C18.433,6.43019372 20,9.10433794 20,11.9965755 M11.075,8.93526559 L10.419,8.18194326 C9.903,8.63013503 9.765,8.86023349 9.534,9.24039615 C9.467,9.35144367 9.389,9.48149932 9.285,9.64056738 L10.123,10.1858007 C10.233,10.0157279 10.317,9.87766883 10.39,9.75861789 C10.594,9.42147363 10.678,9.28241413 11.075,8.93526559 M10.649,11.3663058 L10.325,12.3117103 C11.438,12.6948743 12.411,13.3071362 13.387,14.2375343 L14.076,13.5132244 C12.993,12.4797822 11.904,11.7974903 10.649,11.3663058 M13.285,9.07432509 L14.121,8.52509009 C15.083,9.99271806 15.624,11.6044077 15.73,13.3161401 L14.732,13.3781666 C14.638,11.8425096 14.15,10.3938897 13.285,9.07432509" id="Amazon-CloudFront_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Vv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Cognito_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#BD0816" offset="0%"></stop>
            <stop stop-color="#FF5252" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Cognito_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Security-Identity-Compliance" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M15.188,16.891 L13.938,15.891 L14.563,15.11 L15.387,15.769 L17.084,13.223 L17.917,13.778 L15.917,16.778 C15.838,16.894 15.715,16.973 15.578,16.995 C15.551,16.998 15.526,17 15.5,17 C15.388,17 15.278,16.962 15.188,16.891 L15.188,16.891 Z M6,12 L8,12 L8,11 L6,11 L6,12 Z M6.001,10 L9.001,10 L9.001,9 L6.001,9 L6.001,10 Z M18.001,7 L18.001,6.5 C18.001,6.224 17.777,6 17.501,6 L10.501,6 C10.224,6 10.001,6.224 10.001,6.5 L10.001,7 L5,7 L5,5.6 C5,5.281 5.198,5 5.422,5 L18.578,5 C18.803,5 19.001,5.281 19.001,5.6 L19.001,7 L18.001,7 Z M15.625,12 C17.487,12 19.001,13.571 19.001,15.5 C19.001,17.43 17.487,19 15.625,19 C13.764,19 12.25,17.43 12.25,15.5 C12.25,13.571 13.764,12 15.625,12 L15.625,12 Z M20,12 L20,5.6 C20,4.718 19.362,4 18.578,4 L5.422,4 C4.638,4 4,4.718 4,5.6 L4,14.4 C4,15.283 4.638,16 5.422,16 L11.299,16 C11.545,18.244 13.379,20 15.625,20 C18.038,20 20,17.982 20,15.5 C20,13.019 18.038,11 15.625,11 C13.379,11 11.545,12.757 11.299,15 L5.422,15 C5.198,15 5,14.72 5,14.4 L5,8 L10.001,8 L10.001,12 L11.001,12 L11.001,8 L11.001,7 L17,7 L17,8 L17,10 L18.001,10 L18.001,8 L19.001,8 L19.001,12 L20,12 Z" id="Amazon-Cognito_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, zv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-DynamoDB_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#2E27AD" offset="0%"></stop>
            <stop stop-color="#527FFF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-DynamoDB_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Database" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M14.3871979,13.0634319 L15.4218955,9.61738691 C15.468467,9.46474602 15.4391067,9.29896386 15.3439388,9.17058378 C15.2487709,9.04220369 15.0979197,8.96739955 14.9379567,8.96739955 L14.2383715,8.96739955 L15.2507958,6.94566591 L17.7798316,6.94566591 L16.9881159,9.313116 C16.9374946,9.46676775 16.9628052,9.63659338 17.0589856,9.76800607 C17.153141,9.90042962 17.3060171,9.97826636 17.4690174,9.97826636 L18.095708,9.97826636 L14.3871979,13.0634319 Z M19.9697053,9.29997473 C19.8968108,9.10083397 19.7074875,8.96739955 19.4938659,8.96739955 L18.1706274,8.96739955 L18.9623432,6.59994946 C19.0129644,6.4462977 18.9876538,6.27647207 18.8914735,6.14404852 C18.7963056,6.01263584 18.644442,5.93479909 18.4814417,5.93479909 L14.9379567,5.93479909 C14.7455961,5.93479909 14.5714591,6.04296184 14.485403,6.21379833 L12.9667666,9.24639879 C12.88881,9.40308314 12.8958969,9.58908264 12.9880275,9.73768006 C13.0811706,9.88728835 13.2441709,9.97826636 13.4193203,9.97826636 L14.2576076,9.97826636 L12.9343691,14.3816022 C12.8705863,14.595906 12.9536051,14.8253728 13.1409036,14.9486985 C13.2259472,15.0042962 13.3221275,15.0326005 13.4193203,15.0326005 C13.5347366,15.0326005 13.6491406,14.9931766 13.743296,14.9153399 L19.8178417,9.86100581 C19.980842,9.72453879 20.0425999,9.50113723 19.9697053,9.29997473 L19.9697053,9.29997473 Z M14.8346894,17.6285064 C14.8346894,18.0904726 13.2775809,18.9891332 10.4235568,18.9891332 C7.56953281,18.9891332 6.01242428,18.0904726 6.01242428,17.6285064 L6.01242428,16.562042 C7.04914673,17.1786707 8.74293255,17.495072 10.4235568,17.495072 C12.1041811,17.495072 13.797967,17.1786707 14.8346894,16.562042 L14.8346894,17.6285064 Z M14.8346894,15.1235785 C14.8346894,15.5855446 13.2775809,16.4842052 10.4235568,16.4842052 C7.56953281,16.4842052 6.01242428,15.5855446 6.01242428,15.1235785 C6.01242428,15.0275461 6.08633125,14.9133182 6.21187186,14.7950468 C7.21214704,15.316654 8.74698225,15.6239575 10.4235568,15.6239575 C10.4438053,15.6239575 11.9948393,15.5916098 11.9948393,15.5916098 L11.9948393,14.580743 C11.9745908,14.580743 10.4235568,14.6130907 10.4235568,14.6130907 C8.77128043,14.6130907 7.24656947,14.2886025 6.44574187,13.7680061 C6.17542458,13.5900935 6.0134367,13.3980288 6.01242428,13.252464 L6.01242428,12.1859995 C7.04914673,12.8026283 8.74293255,13.1200404 10.4235568,13.1200404 C10.6898244,13.1200404 11.8348763,13.0391711 12.1922621,13.0138994 L12.213523,12.5054334 L12.1203799,12.0050543 C11.7761557,12.0293151 10.6786878,12.1091736 10.4235568,12.1091736 C7.56953281,12.1091736 6.01242428,11.2095021 6.01242428,10.747536 C6.01242428,10.6474602 6.09139337,10.5281779 6.22503337,10.405863 C7.01877401,10.7566338 8.57183285,11.1508719 12.3178027,11.1963609 L12.3299518,10.1854941 C9.27951741,10.1491029 7.3437622,9.88223402 6.44574187,9.39095274 C6.17542458,9.21304018 6.0134367,9.02097549 6.01242428,8.87541066 L6.01242428,7.80995704 C7.04914673,8.4265858 8.74293255,8.74298711 10.4235568,8.74298711 C10.5015135,8.74298711 12.480803,8.70659591 12.5587596,8.70356331 L12.5152254,7.69370735 C12.4079084,7.69775082 10.5187247,7.73212029 10.4235568,7.73212029 C7.56953281,7.73212029 6.01242428,6.83345969 6.01242428,6.37149356 C6.01242428,5.90952742 7.56953281,5.01086682 10.4235568,5.01086682 C11.7447705,5.01086682 13.0001766,5.21809452 13.8668118,5.5809957 L14.25862,4.64796563 C13.2573324,4.23047763 11.8956217,4 10.4235568,4 C7.72949585,4 5.00101242,4.81374779 5,6.36947182 L5,8.88147587 C5,8.88147587 5.09213061,9.46070255 5.40092001,9.80742987 C5.08808091,10.1551681 5,10.4938084 5,10.7465251 L5,13.2625727 C5.00101242,13.510235 5.09213061,13.8438211 5.39788274,14.1875158 C5.08808091,14.5342431 5,14.8718726 5,15.1235785 L5,17.6335608 C5.00506212,19.1872631 7.7315207,20 10.4235568,20 C13.1186303,20 15.8471137,19.1862522 15.8471137,17.6305282 L15.8471137,15.1235785 L14.8346894,15.1235785 Z" id="Amazon-DynamoDB_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Gv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Elastic-Block-Store_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#1B660F" offset="0%"></stop>
            <stop stop-color="#6CAE3E" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Elastic-Block-Store_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Storage" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M19,16.5 L20,16.5 L20,20 L16.5,20 L16.5,19 L18.293,19 L16.646,17.354 L17.354,16.646 L19,18.293 L19,16.5 Z M6.707,19 L8.5,19 L8.5,20 L5,20 L5,16.5 L6,16.5 L6,18.293 L7.646,16.646 L8.354,17.354 L6.707,19 Z M20,4 L20,7.5 L19,7.5 L19,5.707 L17.354,7.354 L16.646,6.646 L18.293,5 L16.5,5 L16.5,4 L20,4 Z M5,4 L8.5,4 L8.5,5 L6.707,5 L8.354,6.646 L7.646,7.354 L6,5.707 L6,7.5 L5,7.5 L5,4 Z M12.561,15.5 C11.004,15.5 10.17,15.156 10.092,14.996 L10.082,10.053 C10.875,10.342 11.952,10.391 12.561,10.391 C13.161,10.391 14.216,10.337 15.002,10.051 L15.011,14.946 C14.896,15.14 13.955,15.5 12.561,15.5 L12.561,15.5 Z M14.943,8.994 C14.708,9.151 13.956,9.391 12.561,9.391 C11.031,9.391 10.271,9.108 10.119,9.009 C10.322,8.809 11.216,8.5 12.561,8.5 C13.78,8.5 14.684,8.796 14.943,8.994 L14.943,8.994 Z M12.561,7.5 C11.272,7.5 9.092,7.814 9.092,8.992 L9.092,14.996 C9.092,16.392 11.747,16.5 12.561,16.5 C13.838,16.5 16,16.183 16,14.996 L16,8.992 C16,7.812 13.75,7.5 12.561,7.5 L12.561,7.5 Z" id="Amazon-Elastic-Block-Store_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, jv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-EC2_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#C8511B" offset="0%"></stop>
            <stop stop-color="#FF9900" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-EC2_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Compute" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M15,9 L14,9 L13,9 L12,9 L11,9 L10,9 L10,10 L10,11 L10,12 L10,13 L10,14 L11,14 L12,14 L13,14 L14,14 L15,14 L15,13 L15,12 L15,11 L15,10 L15,9 Z M16,9 L17,9 L17,10 L16,10 L16,11 L17,11 L17,12 L16,12 L16,13 L17,13 L17,14 L16,14 L16,14.308 C16,14.689 15.689,15 15.308,15 L15,15 L15,16 L14,16 L14,15 L13,15 L13,16 L12,16 L12,15 L11,15 L11,16 L10,16 L10,15 L9.692,15 C9.311,15 9,14.689 9,14.308 L9,14 L8,14 L8,13 L9,13 L9,12 L8,12 L8,11 L9,11 L9,10 L8,10 L8,9 L9,9 L9,8.692 C9,8.311 9.311,8 9.692,8 L10,8 L10,7 L11,7 L11,8 L12,8 L12,7 L13,7 L13,8 L14,8 L14,7 L15,7 L15,8 L15.308,8 C15.689,8 16,8.311 16,8.692 L16,9 Z M12,19 L5,19 L5,13 L7,13 L7,12 L4.8,12 C4.358,12 4,12.342 4,12.762 L4,19.219 C4,19.65 4.351,20 4.781,20 L12.2,20 C12.642,20 13,19.658 13,19.238 L13,17 L12,17 L12,19 Z M20,4.781 L20,12.219 C20,12.65 19.649,13 19.219,13 L18,13 L18,12 L19,12 L19,5 L12,5 L12,6 L11,6 L11,4.781 C11,4.35 11.351,4 11.781,4 L19.219,4 C19.649,4 20,4.35 20,4.781 L20,4.781 Z" id="Amazon-EC2_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Zv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Elastic-Container-Service_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#C8511B" offset="0%"></stop>
            <stop stop-color="#FF9900" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Elastic-Container-Service_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Compute" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <g id="Icon-Service/16/Amazon-Elastic-Container-Service" transform="translate(4.000000, 4.000000)" fill="#FFFFFF">
            <path d="M14.9951095,10.0569914 L13.036578,8.5362249 L13.036578,5.70726144 C13.036578,5.5354178 12.9471428,5.37549395 12.7994239,5.28510221 L9.99577946,3.56765916 L9.99577946,1.38435098 L14.9951095,4.31065939 L14.9951095,10.0569914 Z M15.7538018,3.60043858 L9.7495813,0.0850938804 C9.59482816,-0.00529785955 9.4008843,-0.0072844912 9.24412139,0.0811206171 C9.08836337,0.169525725 8.99088899,0.333422836 8.99088899,0.512219684 L8.99088899,3.84380096 C8.99088899,4.01564459 9.08132914,4.17556844 9.22804314,4.26596018 L12.0316875,5.98340324 L12.0316875,8.77760065 C12.0316875,8.92957797 12.1030348,9.07360876 12.2246265,9.16797377 L15.1870436,11.4704798 C15.2774838,11.5410053 15.3860119,11.5767646 15.4975548,11.5767646 C15.5719167,11.5767646 15.6472834,11.5598783 15.7166209,11.5261055 C15.889462,11.4436603 16,11.26983 16,11.0801067 L16,4.02756438 C16,3.85174748 15.9065452,3.68884369 15.7538018,3.60043858 L15.7538018,3.60043858 Z M8.53466872,14.959005 L2.00489047,11.6701363 L2.00489047,4.30966608 L6.9871374,1.37143787 L6.9871374,3.55573937 L4.24780599,5.27020248 C4.10310176,5.36158753 4.0146714,5.51952475 4.0146714,5.69037507 L4.0146714,10.2566479 C4.0146714,10.4453779 4.12219468,10.6172216 4.29403095,10.7016534 L8.25631406,12.6425925 C8.39699873,12.7121246 8.56481544,12.710138 8.70650499,12.6396126 L11.816641,11.0751401 L13.9058083,12.8154295 L8.53466872,14.959005 Z M12.2085483,10.1036773 C12.0558049,9.97553953 11.8357339,9.95169995 11.6568634,10.0410984 L8.47538018,11.6413302 L5.01956187,9.94872 L5.01956187,5.96254361 L7.75788839,4.2480805 C7.90359751,4.15669544 7.99202787,3.99875822 7.99202787,3.8279079 L7.99202787,0.497319947 C7.99202787,0.318523099 7.89455349,0.153632672 7.73779058,0.0652275639 C7.57901789,-0.0241708602 7.38507403,-0.0211909127 7.23233068,0.0711874588 L1.24519327,3.60043858 C1.09345481,3.689837 1,3.85174748 1,4.02756438 L1,11.974091 C1,12.1608343 1.1055135,12.3316847 1.2743351,12.4161165 L8.28244121,15.9463609 C8.35278355,15.9821203 8.431165,16 8.51055135,16 C8.57385945,16 8.63716755,15.9880802 8.69846587,15.9642406 L15.0564079,13.4283053 C15.2192001,13.3627465 15.3367723,13.2177224 15.3649092,13.0448854 C15.3920413,12.8730418 15.3267234,12.6992115 15.1920681,12.5869668 L12.2085483,10.1036773 Z" id="Amazon-Elastic-Container-Service_Icon_16_Squid"></path>
        </g>
    </g>
</svg>`, ru = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Elastic-File-System_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#1B660F" offset="0%"></stop>
            <stop stop-color="#6CAE3E" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Elastic-File-System_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Storage" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M19,18.293 L17.354,16.647 L16.646,17.354 L18.293,19 L17,19 L17,20 L19.5,20 C19.776,20 20,19.776 20,19.5 L20,17 L19,17 L19,18.293 Z M6.646,16.647 L5,18.293 L5,17 L4,17 L4,19.5 C4,19.776 4.224,20 4.5,20 L7,20 L7,19 L5.707,19 L7.354,17.354 L6.646,16.647 Z M19.5,4 L17,4 L17,5 L18.293,5 L16.646,6.647 L17.354,7.354 L19,5.707 L19,7 L20,7 L20,4.5 C20,4.224 19.776,4 19.5,4 L19.5,4 Z M5,5.707 L6.646,7.354 L7.354,6.647 L5.707,5 L7,5 L7,4 L4.5,4 C4.224,4 4,4.224 4,4.5 L4,7 L5,7 L5,5.707 Z M15,12.117 C15,12.088 14.976,12.062 14.962,12.048 C14.923,12.012 14.872,11.989 14.854,11.999 L11.487,12 C11.211,12 10.987,11.776 10.987,11.5 L10.987,11.493 L10.451,11.498 C10.449,11.506 10.448,11.513 10.447,11.52 C10.447,11.795 10.225,12 9.948,12 L9.25,12 C9.103,11.989 9.002,12.031 8.979,12.054 L8.998,16 L15,16 L15,12.117 Z M15.644,11.317 C15.874,11.532 16,11.815 16,12.117 L16,16.5 C16,16.776 15.776,17 15.5,17 L8.5,17 C8.224,17 8,16.776 8,16.5 L8,12 C8,11.742 8.105,11.501 8.297,11.323 C8.584,11.055 8.992,10.981 9.284,11.001 L9.555,11.001 C9.649,10.751 9.827,10.5 10.156,10.5 L11.323,10.5 C11.637,10.557 11.803,10.779 11.89,11 L14.82,11 C15.096,10.974 15.41,11.099 15.644,11.317 L15.644,11.317 Z M16.131,10.972 C15.91,10.926 15.747,10.737 15.734,10.512 C15.687,9.71 15.266,9.425 14.918,9.425 C14.691,9.425 14.477,9.539 14.328,9.737 C14.218,9.884 14.035,9.959 13.854,9.932 C13.671,9.904 13.519,9.779 13.457,9.606 C13.292,9.144 13.055,8.757 12.752,8.458 C12.384,8.091 11.368,7.305 9.944,7.903 C9.141,8.241 8.486,9.251 8.486,10.155 C8.486,10.259 8.495,10.363 8.507,10.463 C8.538,10.713 8.377,10.948 8.131,11.009 C7.567,11.149 6.896,11.535 6.896,12.581 C6.896,12.582 6.9,12.709 6.9,12.709 C6.921,13.076 7.082,13.432 7.354,13.704 L6.646,14.411 C6.201,13.965 5.937,13.378 5.901,12.758 L5.896,12.581 C5.896,11.444 6.482,10.567 7.486,10.168 L7.486,10.155 C7.486,8.841 8.377,7.477 9.559,6.981 C10.936,6.404 12.393,6.692 13.456,7.748 C13.712,8.001 13.932,8.296 14.113,8.629 C14.996,8.154 16.402,8.511 16.688,10.083 C17.951,10.46 18.641,11.342 18.641,12.595 C18.641,13.72 18.123,14.543 17.184,14.914 L16.816,13.983 C17.379,13.762 17.641,13.32 17.641,12.595 C17.641,12.272 17.641,11.29 16.131,10.972 L16.131,10.972 Z" id="Amazon-Elastic-File-System_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Wv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-ElastiCache_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#2E27AD" offset="0%"></stop>
            <stop stop-color="#527FFF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-ElastiCache_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Database" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M10,13 L15,13 L15,11 L10,11 L10,13 Z M10,16 L15,16 L15,14 L10,14 L10,16 Z M10,19 L15,19 L15,17 L10,17 L10,19 Z M16,10.5 L16,19.5 C16,19.777 15.776,20 15.5,20 L9.5,20 C9.224,20 9,19.777 9,19.5 L9,10.5 C9,10.224 9.224,10 9.5,10 L15.5,10 C15.776,10 16,10.224 16,10.5 L16,10.5 Z M17,12 L18,12 L18,6.5 C18,6.224 17.776,6 17.5,6 L15.5,6 C15.224,6 15,6.224 15,6.5 L15,9 L16,9 L16,7 L17,7 L17,12 Z M14,9 L14,6.5 C14,6.224 13.776,6 13.5,6 L11.5,6 C11.224,6 11,6.224 11,6.5 L11,9 L12,9 L12,7 L13,7 L13,9 L14,9 Z M9,9 L10,9 L10,6.5 C10,6.224 9.776,6 9.5,6 L7.5,6 C7.224,6 7,6.224 7,6.5 L7,12 L8,12 L8,7 L9,7 L9,9 Z M20,4.5 L20,14.5 C20,14.777 19.776,15 19.5,15 L17,15 L17,14 L19,14 L19,5 L6,5 L6,14 L8,14 L8,15 L5.5,15 C5.224,15 5,14.777 5,14.5 L5,4.5 C5,4.224 5.224,4 5.5,4 L19.5,4 C19.776,4 20,4.224 20,4.5 L20,4.5 Z" id="Amazon-ElastiCache_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, qv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_AWS-Elastic-Beanstalk_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#C8511B" offset="0%"></stop>
            <stop stop-color="#FF9900" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_AWS-Elastic-Beanstalk_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Compute" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M14.9985007,13.6428238 C14.9985007,13.373991 14.7736132,13.1558078 14.4987506,13.1558078 C14.2238881,13.1558078 13.9990005,13.373991 13.9990005,13.6428238 C13.9990005,13.9116567 14.2238881,14.1298398 14.4987506,14.1298398 C14.7736132,14.1298398 14.9985007,13.9116567 14.9985007,13.6428238 M11.0004998,9.7466957 C11.0004998,10.0155285 11.2253873,10.2337117 11.5002499,10.2337117 C11.7751124,10.2337117 12,10.0155285 12,9.7466957 C12,9.47786286 11.7751124,9.25967968 11.5002499,9.25967968 C11.2253873,9.25967968 11.0004998,9.47786286 11.0004998,9.7466957 M8.001999,12.6687918 C8.001999,12.9376246 8.22688656,13.1558078 8.50174913,13.1558078 C8.77661169,13.1558078 9.00149925,12.9376246 9.00149925,12.6687918 C9.00149925,12.399959 8.77661169,12.1817758 8.50174913,12.1817758 C8.22688656,12.1817758 8.001999,12.399959 8.001999,12.6687918 M15.998001,13.6428238 C15.998001,14.2769187 15.5792104,14.8126363 14.9985007,15.0142609 L14.9985007,16.5649199 C14.9985007,16.8337528 14.7746127,17.0519359 14.4987506,17.0519359 L12,17.0519359 L12,19 L11.0004998,19 L11.0004998,16.0779039 L8.50174913,16.0779039 C8.22588706,16.0779039 8.001999,15.8597207 8.001999,15.5908879 L8.001999,14.0402289 C7.42128936,13.8386043 7.00249875,13.3028866 7.00249875,12.6687918 C7.00249875,11.8632673 7.67516242,11.2077437 8.50174913,11.2077437 C9.32833583,11.2077437 10.0009995,11.8632673 10.0009995,12.6687918 C10.0009995,13.3028866 9.5822089,13.8386043 9.00149925,14.0402289 L9.00149925,15.1038719 L11.0004998,15.1038719 L11.0004998,11.1181328 C10.4197901,10.9165082 10.0009995,10.3807906 10.0009995,9.7466957 C10.0009995,8.94117121 10.6736632,8.28564765 11.5002499,8.28564765 C12.3268366,8.28564765 12.9995002,8.94117121 12.9995002,9.7466957 C12.9995002,10.3807906 12.5807096,10.9165082 12,11.1181328 L12,16.0779039 L13.9990005,16.0779039 L13.9990005,15.0142609 C13.4182909,14.8126363 12.9995002,14.2769187 12.9995002,13.6428238 C12.9995002,12.8372993 13.6721639,12.1817758 14.4987506,12.1817758 C15.3253373,12.1817758 15.998001,12.8372993 15.998001,13.6428238 M20,12.0590477 C20,13.8054872 18.8965517,14.9392605 17.0504748,15.0892614 L16.9665167,14.1191255 C17.894053,14.043151 19.0004998,13.6243172 19.0004998,12.0590477 C19.0004998,10.9369628 18.3148426,10.2337117 16.9635182,9.96974904 C16.7406297,9.92591759 16.5767116,9.74182554 16.5627186,9.52072027 C16.4987506,8.45805132 15.888056,8.08207496 15.3843078,8.08207496 C15.0474763,8.08207496 14.7306347,8.23889412 14.5167416,8.51357115 C14.4067966,8.65480579 14.2218891,8.7249361 14.0449775,8.7005853 C13.864068,8.6733124 13.7131434,8.55350646 13.6501749,8.38694698 C13.4312844,7.80739793 13.1174413,7.32232997 12.7186407,6.94635361 C12.2278861,6.48174033 10.8795602,5.48530556 8.97751124,6.24505055 C7.88805597,6.67752077 7.03448276,7.9281779 7.03448276,9.09312021 C7.03448276,9.22169244 7.04247876,9.3512387 7.05847076,9.47786286 C7.08945527,9.7223449 6.92853573,9.9502684 6.68265867,10.0106584 C6.05397301,10.1616333 4.99950025,10.6272207 4.99950025,12.037619 L5.00449775,12.1652172 C5.06246877,13.1850288 5.93203398,14.011982 7.02848576,14.1181515 L6.93053473,15.0873133 C5.34732634,14.9353643 4.09095452,13.7139282 4.007996,12.2470359 L4,12.037619 C4,10.6827405 4.75262369,9.64150024 6.03598201,9.18467922 C6.03498251,9.15448423 6.03498251,9.1233152 6.03498251,9.09312021 C6.03498251,7.53466896 7.13743128,5.92361998 8.59970015,5.34309689 C10.2988506,4.66614462 12.0989505,5.00315971 13.4132934,6.24602458 C13.7631184,6.57524741 14.0589705,6.96583425 14.2978511,7.40999286 C14.6216892,7.21323839 14.9945027,7.10804293 15.3843078,7.10804293 C16.2858571,7.10804293 17.2903548,7.73337149 17.5192404,9.09701634 C19.1224388,9.52072027 20,10.5619605 20,12.0590477" id="AWS-Elastic-Beanstalk_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Kv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Glacier_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#1B660F" offset="0%"></stop>
            <stop stop-color="#6CAE3E" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Glacier_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Storage" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <polygon id="Amazon-Glacier_Icon_16_Squid" fill="#FFFFFF" points="18.3212076 12 20 13.6022806 19.2789148 14.2914755 17.3889984 12.4867195 13.3827429 12.4867195 15.3858707 15.7973856 17.9683144 16.4573773 17.7051744 17.3977194 15.4103488 16.8107356 14.7963555 19 13.8100904 18.7488527 14.5026178 16.2831317 12.50051 12.973439 10.4984021 16.2831317 11.1909295 18.7488527 10.2046644 19 9.58965119 16.8107356 7.29482559 17.3977194 7.03270551 16.4573773 9.61514925 15.7973856 11.618277 12.4867195 7.61202149 12.4867195 5.7210852 14.2914755 5 13.6022806 6.67981233 12 5 10.3977194 5.7210852 9.70852454 7.61202149 11.5132805 11.618277 11.5132805 9.61514925 8.20261438 7.03270551 7.54262272 7.29482559 6.60228063 9.58965119 7.18926436 10.2046644 5 11.1909295 5.25114727 10.4984021 7.71686831 12.50051 11.026561 14.5026178 7.71686831 13.8100904 5.25114727 14.7963555 5 15.4103488 7.18926436 17.7051744 6.60228063 17.9683144 7.54262272 15.3858707 8.20261438 13.3827429 11.5132805 17.3889984 11.5132805 19.2789148 9.70852454 20 10.3977194"></polygon>
    </g>
</svg>`, Yv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_AWS-Identity-and-Access-Management_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#BD0816" offset="0%"></stop>
            <stop stop-color="#FF5252" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_AWS-Identity-and-Access-Management_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Security-Identity-Compliance" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M5,18 L19,18 L19,7 L5,7 L5,18 Z M20,6.5 L20,18.5 C20,18.776 19.776,19 19.5,19 L4.5,19 C4.224,19 4,18.776 4,18.5 L4,6.5 C4,6.224 4.224,6 4.5,6 L19.5,6 C19.776,6 20,6.224 20,6.5 L20,6.5 Z M7,14.998 L10.998,15 L11,12.002 L7.002,12 L7,14.998 Z M8,11 L10,11.001 L10,9.854 C10,9.264 9.645,8.939 9,8.939 L8.999,8.939 C8.67,8.939 8.407,9.027 8.239,9.193 C8.042,9.388 8.001,9.659 8.001,9.852 L8,11 Z M6.146,15.852 C6.053,15.758 6,15.63 6,15.498 L6.002,11.5 C6.002,11.224 6.226,11 6.502,11 L7,11 L7.001,9.852 C7.001,9.301 7.187,8.827 7.537,8.481 C7.896,8.127 8.401,7.939 8.999,7.939 L9,7.939 C10.196,7.939 11,8.708 11,9.854 L11,11.002 L11.5,11.002 C11.633,11.002 11.76,11.055 11.854,11.148 C11.947,11.242 12,11.37 12,11.502 L11.998,15.5 C11.998,15.776 11.774,16 11.498,16 L6.5,15.998 C6.367,15.998 6.24,15.945 6.146,15.852 L6.146,15.852 Z M14,14 L16,14 L16,13 L14,13 L14,14 Z M14,11 L18,11 L18,10 L14,10 L14,11 Z" id="AWS-Identity-and-Access-Management_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Xv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Kinesis_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#4D27A8" offset="0%"></stop>
            <stop stop-color="#A166FF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Kinesis_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Analytics" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M6.7337492,17.8414023 L7.72616432,17.8414023 C7.72616432,16.9338898 7.72616432,14.8073456 19,14.8073456 L19,13.8056761 C8.21939463,13.8056761 6.7337492,15.7449082 6.7337492,17.8414023 M8.03778266,20 L9.03019777,20 C9.03019777,18.9632721 9.03019777,16.5342237 19,16.5342237 L19,15.5325543 C9.3408237,15.5325543 8.03778266,17.7903172 8.03778266,20 M5.99241511,9.38931553 L5,9.38931553 C5,10.8287145 5.99340753,11.9105175 9.81718296,12.4994992 C5.99340753,13.0894825 5,14.1712855 5,15.6096828 L5.99241511,15.6096828 C5.99241511,14.3956594 7.47111363,13.0003339 19,13.0003339 L19,11.9986644 C7.47111363,11.9986644 5.99241511,10.6043406 5.99241511,9.38931553 M7.72616432,7.15859766 L6.7337492,7.15859766 C6.7337492,9.25409015 8.21939463,11.1943239 19,11.1943239 L19,10.1926544 C7.72616432,10.1926544 7.72616432,8.06611018 7.72616432,7.15859766 M19,8.46577629 L19,9.46744574 C9.3408237,9.46744574 8.03778266,7.20868114 8.03778266,5 L9.03019777,5 C9.03019777,6.03672788 9.03019777,8.46577629 19,8.46577629" id="Amazon-Kinesis_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Qv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_AWS-Lambda_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#C8511B" offset="0%"></stop>
            <stop stop-color="#FF9900" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_AWS-Lambda_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Compute" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M8.35471698,19 L5.33377354,19 L8.87677893,11.806 L10.3893141,14.832 L8.35471698,19 Z M9.3369363,10.435 C9.25026989,10.262 9.06971487,10.153 8.87265196,10.153 L8.87058847,10.153 C8.67352556,10.153 8.49297054,10.264 8.40733588,10.437 L4.05028527,19.285 C3.97393629,19.439 3.98528546,19.622 4.07917407,19.767 C4.17409443,19.912 4.33814156,20 4.51560135,20 L8.68074777,20 C8.8809059,20 9.06249267,19.889 9.14812734,19.714 L11.4282793,15.043 C11.4943109,14.907 11.4932791,14.748 11.4262158,14.611 L9.3369363,10.435 Z M18.968257,19 L15.7987426,19 L10.1747116,7.289 C10.0901087,7.113 9.90749017,7 9.70733203,7 L7.61598901,7 L7.6180525,5 L11.7883576,5 L17.386595,16.71 C17.471198,16.887 17.6548482,17 17.8550063,17 L18.968257,17 L18.968257,19 Z M19.4841285,16 L18.1841324,16 L12.5869267,4.29 C12.5023238,4.113 12.3186735,4 12.1174836,4 L7.10321275,4 C6.81845169,4 6.58734126,4.224 6.58734126,4.5 L6.58424603,7.5 C6.58424603,7.632 6.63892841,7.759 6.73591225,7.854 C6.83186434,7.947 6.9628957,8 7.10011752,8 L9.37820602,8 L15.002237,19.711 C15.0868399,19.887 15.2694584,20 15.4696166,20 L19.4841285,20 C19.7688896,20 20,19.776 20,19.5 L20,16.5 C20,16.224 19.7688896,16 19.4841285,16 L19.4841285,16 Z" id="AWS-Lambda_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, Jv = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Lightsail_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#C8511B" offset="0%"></stop>
            <stop stop-color="#FF9900" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Lightsail_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Compute" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M20,12.5 C20,16.636 16.636,20 12.5,20 C9.458,20 6.738,18.185 5.571,15.376 L6.495,14.992 C7.506,17.427 9.863,19 12.5,19 C16.084,19 19,16.084 19,12.5 C19,8.916 16.084,6 12.5,6 C9.826,6 7.386,7.677 6.429,10.173 L5.495,9.815 C6.6,6.935 9.415,5 12.5,5 C16.636,5 20,8.364 20,12.5 L20,12.5 Z M7,13 L10,13 L10,12 L7,12 L7,13 Z M4,13 L6,13 L6,12 L4,12 L4,13 Z M14.193,9.163 C14.792,10.014 15.392,11.192 15.392,12.501 C15.392,13.794 14.737,15.02 14.188,15.82 C13.856,14.343 13.213,13.192 12.331,12.501 C13.217,11.807 13.862,10.65 14.193,9.163 L14.193,9.163 Z M13.382,17.081 C13.402,17.277 13.537,17.443 13.725,17.504 C13.775,17.521 13.827,17.528 13.879,17.528 C14.018,17.528 14.153,17.47 14.25,17.363 C14.753,16.806 16.392,14.81 16.392,12.501 C16.392,10.33 15.051,8.521 14.251,7.636 C14.118,7.49 13.913,7.434 13.725,7.496 C13.537,7.557 13.403,7.723 13.383,7.919 C13.163,10 12.334,11.541 11.165,12.042 C10.981,12.12 10.862,12.301 10.862,12.501 C10.862,12.701 10.981,12.882 11.165,12.96 C12.334,13.462 13.162,15.002 13.382,17.081 L13.382,17.081 Z" id="Amazon-Lightsail-Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, eb = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-RDS_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#2E27AD" offset="0%"></stop>
            <stop stop-color="#527FFF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-RDS_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Database" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M5.707,5 L7.853,7.146 L7.146,7.854 L5,5.707 L5,7.5 L4,7.5 L4,4.5 C4,4.224 4.224,4 4.5,4 L7.5,4 L7.5,5 L5.707,5 Z M7.853,16.854 L5.707,19 L7.5,19 L7.5,20 L4.5,20 C4.224,20 4,19.776 4,19.5 L4,16.5 L5,16.5 L5,18.293 L7.146,16.146 L7.853,16.854 Z M5,12 C5,12.75 5.966,13.542 7.519,14.069 L7.199,15.016 C5.166,14.328 4,13.228 4,12 C4,10.772 5.166,9.672 7.199,8.984 L7.519,9.931 C5.966,10.458 5,11.25 5,12 L5,12 Z M19,16.5 L20,16.5 L20,19.5 C20,19.776 19.776,20 19.5,20 L16.5,20 L16.5,19 L18.293,19 L16.146,16.854 L16.853,16.146 L19,18.293 L19,16.5 Z M20,4.5 L20,7.5 L19,7.5 L19,5.707 L16.853,7.854 L16.146,7.146 L18.293,5 L16.5,5 L16.5,4 L19.5,4 C19.776,4 20,4.224 20,4.5 L20,4.5 Z M20,12 C20,13.228 18.834,14.328 16.801,15.016 L16.48,14.069 C18.034,13.542 19,12.75 19,12 C19,11.25 18.034,10.458 16.48,9.931 L16.801,8.984 C18.834,9.672 20,10.772 20,12 L20,12 Z M12,15.402 C10.81,15.402 10.087,15.104 10,15.032 L10,10.651 C10.564,10.886 11.294,11 12,11 C12.708,11 13.439,10.886 14.004,10.65 L14.02,14.952 C13.913,15.104 13.19,15.402 12,15.402 L12,15.402 Z M12,9 C13.174,9 13.858,9.336 13.987,9.5 C13.858,9.664 13.174,10 12,10 C10.771,10 10.08,9.632 10,9.531 L10,9.521 C10.08,9.368 10.771,9 12,9 L12,9 Z M12,8 C10.555,8 9,8.469 9,9.5 L9,15.032 C9,15.979 10.507,16.402 12,16.402 C13.493,16.402 15,15.979 15,15.032 L15,9.5 C15,8.469 13.445,8 12,8 L12,8 Z" id="Amazon-RDS_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, tb = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Redshift_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#4D27A8" offset="0%"></stop>
            <stop stop-color="#A166FF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Redshift_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Analytics" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M14.4737051,10.7348035 C14.4737051,10.6013584 14.5788847,10.4925493 14.7078785,10.4925493 C14.8368724,10.4925493 14.9430443,10.6013584 14.9430443,10.7348035 C14.9430443,11.0016937 14.4737051,11.0016937 14.4737051,10.7348035 M13.2562016,13.756822 C13.2562016,13.6233768 13.3623735,13.5145678 13.4913673,13.5145678 C13.6203612,13.5145678 13.7245485,13.6233768 13.7245485,13.756822 C13.7245485,14.0247387 13.2562016,14.0247387 13.2562016,13.756822 M10.3349871,13.25281 C10.3349871,13.1193649 10.441159,13.0105559 10.5691605,13.0105559 C10.6981544,13.0105559 10.8043263,13.1193649 10.8043263,13.25281 C10.8043263,13.5207268 10.3349871,13.5207268 10.3349871,13.25281 M9.11847589,16.0233358 C9.11847589,15.8898907 9.22365549,15.7810816 9.35264934,15.7810816 C9.48164318,15.7810816 9.58583052,15.8898907 9.58583052,16.0233358 C9.58583052,16.290226 9.11847589,16.290226 9.11847589,16.0233358 M14.7078785,9.46604849 C14.0321492,9.46604849 13.4814447,10.0347299 13.4814447,10.7348035 C13.4814447,11.0899728 13.6253225,11.4092146 13.8525501,11.6401772 L13.5270887,12.4952524 C13.5141893,12.4952524 13.5032745,12.4880669 13.4913673,12.4880669 C13.0359198,12.4880669 12.6529073,12.7580366 12.4405636,13.1409215 L11.7420123,12.9766813 C11.6159952,12.4131324 11.1506251,11.984055 10.5691605,11.984055 C9.89343124,11.984055 9.34272673,12.5527365 9.34272673,13.25281 C9.34272673,13.5145678 9.43897599,13.7455304 9.57094662,13.9477511 L9.22762453,14.7802433 C8.6124231,14.8490188 8.12621552,15.3694548 8.12621552,16.0233358 C8.12621552,16.7234094 8.67592776,17.2920908 9.35264934,17.2920908 C10.0293709,17.2920908 10.5780909,16.7234094 10.5780909,16.0233358 C10.5780909,15.654822 10.4203215,15.3294212 10.1762254,15.097432 L10.4262751,14.4917965 C10.4748958,14.4989821 10.5185553,14.5215651 10.5691605,14.5215651 C10.9779718,14.5215651 11.3222862,14.3008674 11.5455448,13.9836786 L12.3453066,14.1715283 C12.5129986,14.6663017 12.9575313,15.025577 13.4913673,15.025577 C14.1670966,15.025577 14.7168089,14.455869 14.7168089,13.756822 C14.7168089,13.4478452 14.5967454,13.1737695 14.4181385,12.9530718 L14.7862671,11.9871345 C15.4242905,11.942995 15.9353046,11.4061351 15.9353046,10.7348035 C15.9353046,10.0347299 15.3846001,9.46604849 14.7078785,9.46604849 M12,18.9734992 C9.35562612,18.9734992 7.99226037,18.1461395 7.99226037,17.7930232 L7.99226037,8.59044328 C8.95276841,9.14885973 10.4808494,9.43730646 12,9.43730646 C13.5191506,9.43730646 15.0472316,9.14885973 16.0077396,8.59044328 L16.0077396,17.7930232 C16.0077396,18.1461395 14.6443739,18.9734992 12,18.9734992 M12,5.99236968 C14.4866045,5.99236968 16.0077396,6.77558981 16.0077396,7.20261416 C16.0077396,7.628612 14.4866045,8.41080563 12,8.41080563 C9.51339551,8.41080563 7.99226037,7.628612 7.99226037,7.20261416 C7.99226037,6.77558981 9.51339551,5.99236968 12,5.99236968 M17,7.20261416 C17,4.26579528 7,4.26579528 7,7.20261416 C7,7.20466716 7.00099226,7.20672016 7.00099226,7.20877316 L7,7.20877316 L7,17.7930232 C7,19.2424424 9.51538004,20 12,20 C14.48462,20 17,19.2424424 17,17.7930232 L17,7.20877316 L16.9990077,7.20877316 C16.9990077,7.20672016 17,7.20466716 17,7.20261416" id="Amazon-Redshift_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, nb = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>Icon-Architecture/16/Arch_Amazon-Simple-Storage-Service_16</title>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#1B660F" offset="0%"></stop>
            <stop stop-color="#6CAE3E" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Simple-Storage-Service_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Rectangle" fill="url(#linearGradient-1)">
            <rect x="0" y="0" width="24" height="24"></rect>
        </g>
        <g id="Icon-Service/16/Amazon-Simple-Storage-Service_16" transform="translate(4.000000, 4.000000)" fill="#FFFFFF">
            <path d="M13.9082,9.0508 L13.9492,8.8068 C14.2152,8.9598 14.4192,9.0888 14.5642,9.1918 C14.3942,9.1638 14.1662,9.1138 13.9082,9.0508 L13.9082,9.0508 Z M12.0492,14.0928 C11.9992,14.3958 10.9792,14.9998 7.4782,14.9998 C4.0442,14.9998 3.0432,14.3968 2.9932,14.0898 L1.2592,3.9648 C2.6962,4.6678 5.1522,4.9998 7.5002,4.9998 C9.8502,4.9998 12.3112,4.6658 13.7482,3.9618 L12.9402,8.7748 C11.3852,8.2668 9.5682,7.3978 8.6442,6.9548 L8.4742,6.8728 C8.4092,6.3838 8.0072,5.9998 7.5002,5.9998 C6.9482,5.9998 6.5002,6.4488 6.5002,6.9998 C6.5002,7.5508 6.9482,7.9998 7.5002,7.9998 C7.7212,7.9998 7.9142,7.9138 8.0792,7.7928 L8.2132,7.8568 C9.1842,8.3228 11.1192,9.2468 12.7732,9.7698 L12.0492,14.0928 Z M7.5002,0.9998 C11.7612,0.9998 13.9712,2.0368 14.0002,2.4898 L14.0002,2.5188 C13.9462,2.9768 11.7352,3.9998 7.5002,3.9998 C3.2702,3.9998 1.0592,2.9798 1.0002,2.5208 L1.0002,2.4888 C1.0302,2.0348 3.2422,0.9998 7.5002,0.9998 L7.5002,0.9998 Z M15.0002,2.4998 C15.0002,0.7818 11.1122,-0.0002 7.5002,-0.0002 C3.8872,-0.0002 0.0002,0.7818 0.0002,2.4998 L0.0472,2.8158 L2.0072,14.2548 C2.1972,15.4248 3.9362,15.9998 7.4782,15.9998 C12.2072,15.9998 12.9142,14.9908 13.0352,14.2568 L13.7422,10.0428 C14.3202,10.1828 14.7312,10.2388 15.0232,10.2388 C15.4852,10.2388 15.6612,10.1038 15.7832,9.9598 C15.9292,9.7858 15.9852,9.5668 15.9422,9.3428 C15.8492,8.8678 15.3302,8.4158 14.1252,7.7598 L14.9542,2.8138 L15.0002,2.4998 Z" id="Amazon-Simple-Storage-Service-Icon_16_Squid"></path>
        </g>
    </g>
</svg>`, rb = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_AWS-Simple-Notification-Service_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#B0084D" offset="0%"></stop>
            <stop stop-color="#FF4F8B" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_AWS-Simple-Notification-Service_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Application-Integration" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M6.4951189,11.5607705 C6.4951189,11.9743992 6.15969962,12.3097195 5.74818523,12.3097195 C5.33667084,12.3097195 5.00125156,11.9743992 5.00125156,11.5607705 C5.00125156,11.1471419 5.33667084,10.8118215 5.74818523,10.8118215 C6.15969962,10.8118215 6.4951189,11.1471419 6.4951189,11.5607705 L6.4951189,11.5607705 Z M12.4395494,18.9960469 C9.28861076,18.9960469 6.52015019,16.6006149 5.7261577,13.3116647 C5.73316646,13.3116647 5.74017522,13.3136726 5.74818523,13.3136726 C6.71239049,13.3136726 7.49637046,12.5275773 7.49637046,11.5607705 C7.49637046,10.6441614 6.78948686,9.89822426 5.89436796,9.82292778 C6.84155194,6.99579595 9.47083855,5.00395307 12.4395494,5.00395307 C13.7481852,5.00395307 14.8715895,5.23486227 15.7787234,5.68965301 L16.2272841,4.79111502 C15.1789737,4.26604756 13.9043805,4 12.4395494,4 C8.82202753,4 5.62302879,6.56610403 4.74593242,10.1291335 C4.29637046,10.4463826 4,10.9684382 4,11.5607705 C4,12.0958775 4.24530663,12.5697434 4.62377972,12.8910083 C5.29461827,16.9570183 8.61677096,20 12.4395494,20 C13.58398,20 14.9296621,19.6395808 16.2282854,18.9850035 L15.7777222,18.0874694 C14.6162703,18.673778 13.4307885,18.9960469 12.4395494,18.9960469 L12.4395494,18.9960469 Z M8.75994994,9.96046935 L12.2392991,9.96046935 L11.0217772,12.8056723 C10.9947434,12.8689214 10.9807259,12.9361862 10.9807259,13.0034511 L10.9807259,14.7061555 L10.0455569,15.1910648 L10.0455569,13.0034511 C10.0455569,12.9341783 10.0305382,12.8659095 10.0035044,12.8016565 L8.75994994,9.96046935 Z M9.28460576,16.4450022 C9.36370463,16.4931919 9.45481852,16.5172868 9.54493116,16.5172868 C9.62403004,16.5172868 9.70212766,16.4992157 9.77421777,16.4620694 L11.7116395,15.4581163 C11.8778473,15.3717764 11.9819775,15.2001004 11.9819775,15.0123612 L11.9819775,13.1068583 L13.4588235,9.65727552 C13.5249061,9.5016628 13.5098874,9.32295915 13.4177722,9.18240572 C13.3246558,9.04185229 13.1674593,8.95651628 12.9992491,8.95651628 L7.99299124,8.95651628 C7.82377972,8.95651628 7.66658323,9.04285625 7.57346683,9.18441363 C7.48135169,9.32597101 7.46733417,9.50567861 7.53441802,9.66028738 L9.04430538,13.1088662 L9.04430538,16.0153103 C9.04430538,16.1910021 9.13541927,16.3536425 9.28460576,16.4450022 L9.28460576,16.4450022 Z M18.2518148,14.823618 C18.6633292,14.823618 18.9987484,15.1589383 18.9987484,15.572567 C18.9987484,15.9861956 18.6633292,16.3225199 18.2518148,16.3225199 C17.8403004,16.3225199 17.5048811,15.9861956 17.5048811,15.572567 C17.5048811,15.1589383 17.8403004,14.823618 18.2518148,14.823618 L18.2518148,14.823618 Z M18.2518148,6.75384326 C18.6633292,6.75384326 18.9987484,7.09016753 18.9987484,7.50279224 C18.9987484,7.91642091 18.6633292,8.25274518 18.2518148,8.25274518 C17.8403004,8.25274518 17.5048811,7.91642091 17.5048811,7.50279224 C17.5048811,7.09016753 17.8403004,6.75384326 18.2518148,6.75384326 L18.2518148,6.75384326 Z M18.2518148,10.8118215 C18.6633292,10.8118215 18.9987484,11.1471419 18.9987484,11.5607705 C18.9987484,11.9743992 18.6633292,12.3097195 18.2518148,12.3097195 C17.8403004,12.3097195 17.5048811,11.9743992 17.5048811,11.5607705 C17.5048811,11.1471419 17.8403004,10.8118215 18.2518148,10.8118215 L18.2518148,10.8118215 Z M16.0030038,12.0627471 L16.5857322,12.0627471 C16.8030038,12.7835854 17.4628285,13.3136726 18.2518148,13.3136726 C19.21602,13.3136726 20,12.5275773 20,11.5607705 C20,10.5939637 19.21602,9.80786848 18.2518148,9.80786848 C17.4628285,9.80786848 16.8030038,10.3379557 16.5857322,11.058794 L16.0030038,11.058794 L16.0030038,8.00476878 L16.5857322,8.00476878 C16.8030038,8.72661103 17.4628285,9.25669825 18.2518148,9.25669825 C19.21602,9.25669825 20,8.46959905 20,7.50279224 C20,6.5369894 19.21602,5.74989019 18.2518148,5.74989019 C17.4628285,5.74989019 16.8030038,6.27997741 16.5857322,7.00081571 L15.502378,7.00081571 C15.2260325,7.00081571 15.0017522,7.2257012 15.0017522,7.50279224 L15.0017522,11.058794 L14.0005006,11.058794 L14.0005006,12.0627471 L15.0017522,12.0627471 L15.0017522,15.572567 C15.0017522,15.849658 15.2260325,16.0745435 15.502378,16.0745435 L16.5857322,16.0745435 C16.8030038,16.7953818 17.4628285,17.326473 18.2518148,17.326473 C19.21602,17.326473 20,16.5393738 20,15.572567 C20,14.6057602 19.21602,13.8196649 18.2518148,13.8196649 C17.4628285,13.8196649 16.8030038,14.3497521 16.5857322,15.0705904 L16.0030038,15.0705904 L16.0030038,12.0627471 Z" id="AWS-Simple-Notification-Service_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, sb = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_AWS-Simple-Queue-Service_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#B0084D" offset="0%"></stop>
            <stop stop-color="#FF4F8B" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_AWS-Simple-Queue-Service_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Application-Integration" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M8.00538392,12.9850432 L9.00704291,12.9850432 L9.00704291,11.9942745 L8.00538392,11.9942745 L8.00538392,12.9850432 Z M15.0169969,12.986034 L16.0186559,12.986034 L16.0186559,11.9952653 L15.0169969,11.9952653 L15.0169969,12.986034 Z M12.7903089,11.2234565 C12.2824678,11.3522564 11.741572,11.3522564 11.2337309,11.2234565 C11.4350643,12.005173 11.4350643,12.8780402 11.2337309,13.6597567 C11.4881523,13.5953567 11.7485836,13.5626614 12.0120199,13.5626614 C12.2754562,13.5626614 12.5358876,13.5953567 12.7903089,13.6597567 C12.5889755,12.8780402 12.5889755,12.005173 12.7903089,11.2234565 L12.7903089,11.2234565 Z M14.3699252,10.3149216 C13.4053276,11.2690318 13.4053276,13.6141813 14.3699252,14.5682916 C14.4670861,14.6653869 14.5161674,14.7922053 14.5161674,14.9190237 C14.5161674,15.0458421 14.4670861,15.1726605 14.3699252,15.2687651 C14.2717626,15.3658604 14.1435503,15.4144081 14.0153379,15.4144081 C13.8871256,15.4144081 13.7589132,15.3658604 13.6617523,15.2687651 C12.7282061,14.3463594 11.2958337,14.3463594 10.3632892,15.2687651 C10.166964,15.4629557 9.85043979,15.4629557 9.65511629,15.2687651 C9.5569537,15.1726605 9.50787241,15.0458421 9.50787241,14.9190237 C9.50787241,14.7922053 9.5569537,14.6653869 9.65511629,14.5682916 C10.6187122,13.6141813 10.6187122,11.2690318 9.65511629,10.3149216 C9.5569537,10.218817 9.50787241,10.0919986 9.50787241,9.96518021 C9.50787241,9.83836181 9.5569537,9.71154342 9.65511629,9.61444809 C9.85043979,9.42124819 10.166964,9.42124819 10.3632892,9.61444809 C11.2958337,10.5378445 12.7282061,10.5378445 13.6617523,9.61444809 C13.8570758,9.42124819 14.1736,9.42124819 14.3699252,9.61444809 C14.4670861,9.71154342 14.5161674,9.83836181 14.5161674,9.96518021 C14.5161674,10.0919986 14.4670861,10.218817 14.3699252,10.3149216 L14.3699252,10.3149216 Z M18.8162895,12.0794806 C18.6980937,11.9635607 18.5418349,11.8991607 18.3755595,11.8991607 C18.2082825,11.8991607 18.051022,11.9635607 17.9328262,12.0794806 C17.6894231,12.3212282 17.6894231,12.7125818 17.9328262,12.9533386 C18.1692178,13.1851785 18.5788963,13.18716 18.8162895,12.9533386 C19.0596926,12.7125818 19.0596926,12.3212282 18.8162895,12.0794806 L18.8162895,12.0794806 Z M19.5244624,13.6538121 C19.2169531,13.9569873 18.8092779,14.1244272 18.3755595,14.1244272 C17.9398379,14.1244272 17.5321626,13.9569873 17.2246533,13.6538121 C16.5906032,13.0266555 16.5906032,12.0061637 17.2246533,11.3790071 C17.8376686,10.7726567 18.9094438,10.7716659 19.5244624,11.3790071 C20.1585125,12.0061637 20.1585125,13.0266555 19.5244624,13.6538121 L19.5244624,13.6538121 Z M6.0661721,12.0854252 C5.94797634,11.9695053 5.79171753,11.9051053 5.62544214,11.9051053 C5.45816509,11.9051053 5.30190628,11.9695053 5.18371052,12.0854252 C4.93930573,12.326182 4.93930573,12.7185264 5.18371052,12.9592832 C5.42010204,13.1911231 5.82978057,13.1931046 6.0661721,12.9592832 C6.31057689,12.7185264 6.31057689,12.326182 6.0661721,12.0854252 L6.0661721,12.0854252 Z M6.77534667,13.6597567 C6.46783736,13.9629319 6.06016214,14.1303718 5.62544214,14.1303718 C5.18972047,14.1303718 4.78204526,13.9629319 4.47553761,13.6597567 C3.84148746,13.0326001 3.84148746,12.0121083 4.47553761,11.3849518 C5.08955457,10.7776105 6.15932638,10.7776105 6.77534667,11.3849518 C7.40839515,12.0121083 7.40839515,13.0326001 6.77534667,13.6597567 L6.77534667,13.6597567 Z M15.8844336,16.4081491 C13.7248568,18.5432556 10.2130403,18.5422649 8.05546687,16.4081491 C7.47650797,15.8354848 7.10889911,15.3371281 6.86148934,14.7922053 L5.94797634,15.196439 C6.24647072,15.8562909 6.67818575,16.4467891 7.34729396,17.1086225 C8.6214042,18.3698711 10.2951764,19 11.9699502,19 C13.6437224,19 15.3184963,18.3698711 16.5926065,17.1086225 C17.1044543,16.6033305 17.6753999,15.9821185 18.0400038,15.2013928 L17.1294957,14.7862607 C16.8330047,15.423325 16.356215,15.9424878 15.8844336,16.4081491 L15.8844336,16.4081491 Z M6.8795192,10.1722509 L5.97001283,9.75711878 C6.26750556,9.12104527 6.70523054,8.52856559 7.34929727,7.89051055 C9.8965161,5.36999497 14.0433844,5.36999497 16.5906032,7.88951978 C17.0563746,8.35121799 17.6393402,8.97936535 18.0139606,9.7501834 L17.1124675,10.1791862 C16.8670611,9.67587575 16.4994522,9.20129754 15.8824303,8.58999325 C13.7238551,6.45686824 10.214042,6.45884977 8.05747018,8.58999325 C7.49153285,9.15076834 7.12893229,9.63822654 6.8795192,10.1722509 L6.8795192,10.1722509 Z" id="AWS-Simple-Queue-Service_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, ib = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_AWS-SageMaker_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#055F4E" offset="0%"></stop>
            <stop stop-color="#56C0A7" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_AWS-SageMaker_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Machine-Learning" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M19.000533,13.6672874 L17.3104344,12.3579393 L16.6857676,13.1152694 L18.5747601,14.5766646 L17.2604611,15.2080958 C17.0895522,15.2894458 16.9816098,15.4579566 16.9816098,15.6419626 L16.9816098,17.2989853 L14.0161914,18.9482603 L12.96875,18.2858386 L12.96875,15.6574578 L14.9986674,15.6574578 L14.9986674,14.6890051 L12.96875,14.6890051 L12.96875,12.7366043 L11.969283,12.7366043 L11.969283,18.2906809 L10.9788113,18.9453549 L9.91038113,18.350725 L11.3546109,16.9532476 L10.6479877,16.2685515 L9.01285981,17.8519718 L8.01839019,17.2989853 L8.01839019,15.6419626 C8.01839019,15.4579566 7.91044776,15.2894458 7.73953891,15.2080958 L5.99946695,14.3732895 L5.99946695,11.0941084 L7.43370203,10.3726111 L9.00186567,11.1047614 L9.00186567,12.477059 L7.72554638,13.3021807 L8.27925107,14.1079334 L9.77845149,13.1394807 C9.9173774,13.0494146 10.0013326,12.8983359 10.0013326,12.7366043 L10.0013326,11.0592442 L11.2776519,10.2341224 L10.7239472,9.42836971 L9.46162047,10.2438069 L7.9244403,9.52715189 L7.9244403,7.24644565 L9.00186567,6.80386274 L9.00186567,8.827929 L10.0013326,8.827929 L10.0013326,6.39323877 L10.958822,6.00004695 L11.969283,6.31188874 L11.969283,9.83124606 C11.969283,9.97941933 12.0392457,10.1188765 12.1591818,10.2108795 L14.6898321,12.147785 L15.3085021,11.3885181 L12.96875,9.59688049 L12.96875,6.30704647 L13.9132463,6.0010154 L16.9976013,7.24838255 L16.9976013,7.95535307 L14.9986674,7.95535307 L14.9986674,8.92380582 L16.9976013,8.92380582 L16.9976013,9.83124606 C16.9976013,10.0152521 17.1055437,10.1827944 17.2734542,10.2641444 L19.000533,11.0989507 L19.000533,13.6672874 Z M19.7241471,10.3668004 L17.9970682,9.53199415 L17.9970682,6.92588779 C17.9970682,6.73026033 17.8761327,6.55400193 17.6892324,6.47943106 L14.1251333,5.03740491 C14.013193,4.99188763 13.8892591,4.98898227 13.7743204,5.02578348 L12.4660181,5.44899733 L11.0857543,5.02287812 C10.9728145,4.98801382 10.8498801,4.99285608 10.7389392,5.03837336 L7.22981077,6.48039952 C7.04490938,6.55593883 6.92497335,6.73122878 6.92497335,6.92588779 L6.92497335,9.53683642 L5.26985608,10.3697058 C5.10394456,10.4529927 5,10.6195666 5,10.7996988 L5,14.6735098 C5,14.8575159 5.10794243,15.0260266 5.27885128,15.1073767 L7.01892324,15.9431514 L7.01892324,17.5788681 C7.01892324,17.7522212 7.1138726,17.9129843 7.26978945,17.9991766 L10.7519323,19.9360821 C10.8288913,19.978694 10.9148454,20 11.0007996,20 C11.0997468,20 11.1966951,19.9719149 11.2816498,19.9157446 L12.4750133,19.129361 L13.7263459,19.9215553 C13.8093017,19.9738518 13.9032516,20 13.9992004,20 C14.0851546,20 14.1711087,19.978694 14.2480677,19.9360821 L17.7302106,17.9991766 C17.8861274,17.9129843 17.9810768,17.7522212 17.9810768,17.5788681 L17.9810768,15.9431514 L19.7221482,15.1073767 C19.893057,15.0260266 20,14.8575159 20,14.6735098 L20,10.7996988 C20,10.6166612 19.893057,10.4481505 19.7241471,10.3668004 L19.7241471,10.3668004 Z" id="AWS-SageMaker_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, ob = `<?xml version="1.0" encoding="UTF-8"?>
<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 64 (93537) - https://sketch.com -->
    <title>Icon-Architecture/16/Arch_Amazon-Virtual-Private-Cloud_16</title>
    <desc>Created with Sketch.</desc>
    <defs>
        <linearGradient x1="0%" y1="100%" x2="100%" y2="0%" id="linearGradient-1">
            <stop stop-color="#4D27A8" offset="0%"></stop>
            <stop stop-color="#A166FF" offset="100%"></stop>
        </linearGradient>
    </defs>
    <g id="Icon-Architecture/16/Arch_Amazon-Virtual-Private-Cloud_16" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Icon-Architecture-BG/16/Networking-Content-Delivery" fill="url(#linearGradient-1)">
            <rect id="Rectangle" x="0" y="0" width="24" height="24"></rect>
        </g>
        <path d="M16.997,11.8210743 L15.074,10.8030743 L15.074,18.4610743 C16.958,18.0830743 16.996,15.6320743 16.997,15.5190743 L16.997,11.8210743 Z M12.851,17.8750743 C13.178,18.2020743 13.581,18.4000743 14.074,18.4770743 L14.074,10.7820743 L11.981,11.8290743 L11.981,15.5200743 C11.981,15.5370743 11.988,17.0100743 12.851,17.8750743 L12.851,17.8750743 Z M17.997,11.5200743 L17.997,15.5200743 C17.997,16.9020743 17.28,19.5140743 14.567,19.5140743 C13.573,19.5140743 12.756,19.1990743 12.138,18.5760743 C10.980946,17.4110743 10.98,15.5930743 10.980946,15.5160743 L10.980946,11.5200743 C10.980946,11.3300743 11.089,11.1570743 11.258,11.0720743 L14.351,9.52607432 C14.495,9.45307432 14.667,9.45607432 14.808,9.53107432 L17.73,11.0780743 C17.894,11.1640743 17.997,11.3350743 17.997,11.5200743 L17.997,11.5200743 Z M19.69,9.73507432 L18.753,10.0810743 C18.547,9.52407432 18.199,9.29607432 17.555,9.29607432 C17.29,9.29607432 17.071,9.09007432 17.056,8.82607432 C16.986,7.66307432 16.389,7.10607432 15.862,7.07907432 C15.189,7.04807432 14.968,7.33607432 14.894,7.43107432 C14.783,7.57707432 14.6,7.64907432 14.422,7.62407432 C14.241,7.59607432 14.089,7.47307432 14.026,7.30107432 C13.811,6.71307432 13.509,6.24207432 13.076,5.82007432 C12.144,4.91807432 10.407,4.73107432 8.851,5.36907432 C7.789,5.80407432 7.102,6.92707432 7.102,8.23007432 C7.102,8.37407432 7.121,8.59807432 7.138,8.73707432 C7.168,8.98707432 7.007,9.22007432 6.762,9.28107432 C5.576,9.57507432 5,10.2550743 5,11.3570743 C5,11.4070743 4.999,11.4580743 5.004,11.5080743 C5.061,12.5170743 5.613,13.5770743 6.995,13.5770743 L8.997,13.5770743 L8.997,14.5770743 L6.995,14.5770743 C5.309,14.5770743 4.107,13.3730743 4.007,11.5810743 C4.001,11.5170743 4,11.4370743 4,11.3570743 C4,9.93307432 4.745,8.90807432 6.109,8.43307432 C6.105,8.36007432 6.102,8.28907432 6.102,8.23007432 C6.102,6.51907432 7.033,5.03307432 8.473,4.44307432 C10.386,3.66207432 12.564,3.93307432 13.772,5.10207432 C14.145,5.46607432 14.447,5.86907432 14.686,6.32307432 C14.986,6.16107432 15.382,6.05107432 15.913,6.08007432 C16.968,6.13407432 17.786,7.03507432 18.004,8.32807432 C18.824,8.44907432 19.39,8.92107432 19.69,9.73507432 L19.69,9.73507432 Z" id="Amazon-Virtual-Private-Cloud_Icon_16_Squid" fill="#FFFFFF"></path>
    </g>
</svg>`, lb = '<svg id="bdb56329-4717-4410-aa13-4505ecaa4e46" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="ba2610c3-a45a-4e7e-a0c0-285cfd7e005d" x1="13.25" y1="13.02" x2="8.62" y2="4.25" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#1988d9" /><stop offset="0.9" stop-color="#54aef0" /></linearGradient><linearGradient id="bd8f618b-4f2f-4cb7-aff0-2fd2d211326d" x1="11.26" y1="10.47" x2="14.46" y2="15.99" gradientUnits="userSpaceOnUse"><stop offset="0.1" stop-color="#54aef0" /><stop offset="0.29" stop-color="#4fabee" /><stop offset="0.51" stop-color="#41a2e9" /><stop offset="0.74" stop-color="#2a93e0" /><stop offset="0.88" stop-color="#1988d9" /></linearGradient></defs><title>Icon-identity-221</title><polygon points="1.01 10.19 8.93 15.33 16.99 10.17 18 11.35 8.93 17.19 0 11.35 1.01 10.19" fill="#50e6ff" /><polygon points="1.61 9.53 8.93 0.81 16.4 9.54 8.93 14.26 1.61 9.53" fill="#fff" /><polygon points="8.93 0.81 8.93 14.26 1.61 9.53 8.93 0.81" fill="#50e6ff" /><polygon points="8.93 0.81 8.93 14.26 16.4 9.54 8.93 0.81" fill="url(#ba2610c3-a45a-4e7e-a0c0-285cfd7e005d)" /><polygon points="8.93 7.76 16.4 9.54 8.93 14.26 8.93 7.76" fill="#53b1e0" /><polygon points="8.93 14.26 1.61 9.53 8.93 7.76 8.93 14.26" fill="#9cebff" /><polygon points="8.93 17.19 18 11.35 16.99 10.17 8.93 15.33 8.93 17.19" fill="url(#bd8f618b-4f2f-4cb7-aff0-2fd2d211326d)" /></svg>', ab = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="fdd5d44a-d038-42da-afe7-cecaad9f8ff9" x1="6.49" y1="17.38" x2="6.49" y2="0.44" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#949494" /><stop offset="0.53" stop-color="#a2a2a2" /><stop offset="1" stop-color="#b3b3b3" /></linearGradient><linearGradient id="bf4a560d-147b-4f76-9d70-f90bc5f8ddd6" x1="10.06" y1="13.89" x2="16.48" y2="13.89" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#005ba1" /><stop offset="0.07" stop-color="#0060a9" /><stop offset="0.36" stop-color="#0071c8" /><stop offset="0.52" stop-color="#0078d4" /><stop offset="0.64" stop-color="#0074cd" /><stop offset="0.82" stop-color="#006abb" /><stop offset="1" stop-color="#005ba1" /></linearGradient></defs><g id="a55981fb-ccb2-4f5b-acf6-743ff717cb3a"><g><path d="M11,9.57a6.72,6.72,0,0,0-2.23.32,6.64,6.64,0,0,0,2.23.33,6.56,6.56,0,0,0,2.23-.33A6.63,6.63,0,0,0,11,9.57Z" fill="#198ab3" /><g><path d="M11.47,16.81a.57.57,0,0,1-.58.57H2.09a.56.56,0,0,1-.57-.57V1A.57.57,0,0,1,2.09.44h8.8a.58.58,0,0,1,.58.57Z" fill="url(#fdd5d44a-d038-42da-afe7-cecaad9f8ff9)" /><path d="M3,6.38A1.08,1.08,0,0,1,4.06,5.3H9a1.08,1.08,0,0,1,1.08,1.08h0A1.08,1.08,0,0,1,9,7.47H4.06A1.08,1.08,0,0,1,3,6.38Z" fill="#003067" /><path d="M3,3.17A1.08,1.08,0,0,1,4.06,2.09H9a1.08,1.08,0,0,1,1.08,1.08h0A1.08,1.08,0,0,1,9,4.25H4.06A1.08,1.08,0,0,1,3,3.17Z" fill="#003067" /><circle cx="4.11" cy="3.17" r="0.73" fill="#50e6ff" /><circle cx="4.11" cy="6.38" r="0.73" fill="#50e6ff" /></g><path d="M13.27,11.38c-1.77,0-3.21-.53-3.21-1.17V16.4c0,.63,1.42,1.15,3.17,1.16h0c1.78,0,3.21-.52,3.21-1.16V10.21C16.48,10.85,15.05,11.38,13.27,11.38Z" fill="url(#bf4a560d-147b-4f76-9d70-f90bc5f8ddd6)" /><path d="M16.48,10.21c0,.64-1.43,1.17-3.21,1.17s-3.21-.53-3.21-1.17,1.44-1.16,3.21-1.16,3.21.52,3.21,1.16" fill="#e6e6e6" /><path d="M15.73,10.12c0,.41-1.1.74-2.46.74s-2.46-.33-2.46-.74,1.1-.74,2.46-.74,2.46.33,2.46.74" fill="#50e6ff" /><path d="M13.68,8.66l2.13-2.13a.11.11,0,0,0-.08-.19H14.49c0-2.57-1.37-5.13-3.84-5.13a6.68,6.68,0,0,1,2,5.13H11.47a.11.11,0,0,0-.08.19l2.13,2.13A.12.12,0,0,0,13.68,8.66Z" fill="#50e6ff" /></g></g></svg>', cb = '<svg id="b300f0d1-2ad8-4418-a1c5-23d0b9d21841" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="b8cad6fd-ec7f-45e9-be2a-125e8b87bd03" x1="10.79" y1="2.17" x2="10.79" y2="16.56" gradientUnits="userSpaceOnUse"><stop offset="0.18" stop-color="#5ea0ef" /><stop offset="1" stop-color="#0078d4" /></linearGradient></defs><title>Icon-web-43</title><rect x="3.7" y="5.49" width="1.18" height="5.26" rx="0.52" transform="translate(-3.83 12.41) rotate(-90)" fill="#b3b3b3" /><rect x="2.04" y="7.88" width="1.18" height="5.26" rx="0.52" transform="translate(-7.88 13.14) rotate(-90)" fill="#a3a3a3" /><rect x="3.7" y="10.26" width="1.18" height="5.26" rx="0.52" transform="translate(-8.6 17.19) rotate(-90)" fill="#7a7a7a" /><path d="M18,11a3.28,3.28,0,0,0-2.81-3.18,4.13,4.13,0,0,0-4.21-4,4.23,4.23,0,0,0-4,2.8,3.89,3.89,0,0,0-3.38,3.8,4,4,0,0,0,4.06,3.86l.36,0h6.58l.17,0A3.32,3.32,0,0,0,18,11Z" fill="url(#b8cad6fd-ec7f-45e9-be2a-125e8b87bd03)" /></svg>', ub = '<svg id="f9ed9690-6753-43a7-8b32-d66ac7b8a99a" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="f710a364-083f-494c-9d96-89b92ee2d5a8" x1="0.5" y1="9.77" x2="9" y2="9.77" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#005ba1" /><stop offset="0.07" stop-color="#0060a9" /><stop offset="0.36" stop-color="#0071c8" /><stop offset="0.52" stop-color="#0078d4" /><stop offset="0.64" stop-color="#0074cd" /><stop offset="0.81" stop-color="#006abb" /><stop offset="0.99" stop-color="#005ba1" /></linearGradient></defs><title>Icon-databases-126</title><g><path d="M13.25,10.48V6.57a.14.14,0,0,0-.24-.1l-4,4L4.85,14.63V17.5H16.93a.56.56,0,0,0,.57-.57V6.57a.14.14,0,0,0-.24-.1Z" fill="#005ba1" /><path d="M4.75,3.58C2.4,3.58.5,2.89.5,2V7.67h0v9.26a.56.56,0,0,0,.57.57H9V2C9,2.89,7.1,3.58,4.75,3.58Z" fill="url(#f710a364-083f-494c-9d96-89b92ee2d5a8)" /><rect x="12.91" y="12.97" width="2.27" height="2.27" rx="0.28" fill="#fff" /><rect x="8.97" y="12.97" width="2.27" height="2.27" rx="0.28" fill="#fff" /><rect x="5.03" y="12.97" width="2.27" height="2.27" rx="0.28" fill="#fff" /><path d="M9,2c0,.85-1.9,1.54-4.25,1.54S.5,2.89.5,2,2.4.5,4.75.5,9,1.19,9,2" fill="#eaeaea" /><path d="M8,1.91c0,.55-1.46,1-3.26,1s-3.26-.43-3.26-1S3,.94,4.75.94,8,1.37,8,1.91" fill="#50e6ff" /><path d="M4.75,2.14a8.07,8.07,0,0,0-2.58.37,7.64,7.64,0,0,0,2.58.38,7.64,7.64,0,0,0,2.58-.38A8.07,8.07,0,0,0,4.75,2.14Z" fill="#198ab3" /></g></svg>', hb = '<svg id="f4337506-5d95-4e80-b7ca-68498c6e008e" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="ba420277-700e-42cc-9de9-5388a5c16e54" x1="9" y1="16.97" x2="9" y2="1.03" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#0078d4" /><stop offset="0.16" stop-color="#1380da" /><stop offset="0.53" stop-color="#3c91e5" /><stop offset="0.82" stop-color="#559cec" /><stop offset="1" stop-color="#5ea0ef" /></linearGradient></defs><title>Icon-devops-261</title><path id="a91f0ca4-8fb7-4019-9c09-0a52e2c05754" d="M17,4v9.74l-4,3.28-6.2-2.26V17L3.29,12.41l10.23.8V4.44Zm-3.41.49L7.85,1V3.29L2.58,4.84,1,6.87v4.61l2.26,1V6.57Z" fill="url(#ba420277-700e-42cc-9de9-5388a5c16e54)" /></svg>', db = '<svg id="a2c88306-fa03-4e5b-b192-401f0b77808b" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="b403aca7-f387-4434-96b4-ae157edc835f" x1="-175.993" y1="-343.723" x2="-175.993" y2="-359.232" gradientTransform="translate(212.573 370.548) scale(1.156 1.029)" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#fea11b" /><stop offset="0.284" stop-color="#fea51a" /><stop offset="0.547" stop-color="#feb018" /><stop offset="0.8" stop-color="#ffc314" /><stop offset="1" stop-color="#ffd70f" /></linearGradient></defs><title>Icon-compute-29</title><g><path d="M2.37,7.475H3.2a.267.267,0,0,1,.267.267v6.148a.533.533,0,0,1-.533.533H2.1a0,0,0,0,1,0,0V7.741a.267.267,0,0,1,.267-.267Z" transform="translate(12.507 16.705) rotate(134.919)" fill="#50e6ff" /><path d="M2.325,3.6h.833a.267.267,0,0,1,.267.267v6.583a0,0,0,0,1,0,0H2.591a.533.533,0,0,1-.533-.533V3.865A.267.267,0,0,1,2.325,3.6Z" transform="translate(5.759 0.114) rotate(44.919)" fill="#1490df" /></g><g><path d="M14.53,7.475h.833a.533.533,0,0,1,.533.533v6.148a.267.267,0,0,1-.267.267H14.8a.267.267,0,0,1-.267-.267V7.475a0,0,0,0,1,0,0Z" transform="translate(12.223 -7.555) rotate(45.081)" fill="#50e6ff" /><path d="M15.108,3.6h.833a0,0,0,0,1,0,0v6.583a.267.267,0,0,1-.267.267h-.833a.267.267,0,0,1-.267-.267V4.131a.533.533,0,0,1,.533-.533Z" transform="translate(31.022 1.222) rotate(135.081)" fill="#1490df" /></g><path d="M8.459,9.9H4.87a.193.193,0,0,1-.2-.181.166.166,0,0,1,.018-.075L8.991,1.13a.206.206,0,0,1,.186-.106h4.245a.193.193,0,0,1,.2.181.165.165,0,0,1-.035.1L8.534,7.966h4.928a.193.193,0,0,1,.2.181.176.176,0,0,1-.052.122L5.421,16.788c-.077.046-.624.5-.356-.189h0Z" fill="url(#b403aca7-f387-4434-96b4-ae157edc835f)" /></svg>', fb = `<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="f67d1585-6164-4ad0-b2dd-f9cc59b2969f" x1="9.908" y1="15.943" x2="7.516" y2="2.383" gradientUnits="userSpaceOnUse"><stop offset="0.15" stop-color="#0078d4" /><stop offset="0.8" stop-color="#5ea0ef" /><stop offset="1" stop-color="#83b9f9" /></linearGradient></defs><g id="a4fd1868-54fe-4ca6-8ff6-3b01866dc27b"><path d="M14.49,7.15A5.147,5.147,0,0,0,9.24,2.164,5.272,5.272,0,0,0,4.216,5.653,4.869,4.869,0,0,0,0,10.4a4.946,4.946,0,0,0,5.068,4.814H13.82A4.292,4.292,0,0,0,18,11.127,4.105,4.105,0,0,0,14.49,7.15Z" fill="url(#f67d1585-6164-4ad0-b2dd-f9cc59b2969f)" /><path d="M12.9,11.4V8H12v4.13h2.46V11.4ZM5.76,9.73a1.825,1.825,0,0,1-.51-.31.441.441,0,0,1-.12-.32.342.342,0,0,1,.15-.3.683.683,0,0,1,.42-.12,1.62,1.62,0,0,1,1,.29V8.11a2.58,2.58,0,0,0-1-.16,1.641,1.641,0,0,0-1.09.34,1.08,1.08,0,0,0-.42.89c0,.51.32.91,1,1.21a2.907,2.907,0,0,1,.62.36.419.419,0,0,1,.15.32.381.381,0,0,1-.16.31.806.806,0,0,1-.45.11,1.66,1.66,0,0,1-1.09-.42V12a2.173,2.173,0,0,0,1.07.24,1.877,1.877,0,0,0,1.18-.33A1.08,1.08,0,0,0,6.84,11a1.048,1.048,0,0,0-.25-.7A2.425,2.425,0,0,0,5.76,9.73ZM11,11.32A2.191,2.191,0,0,0,11,9a1.808,1.808,0,0,0-.7-.75,2,2,0,0,0-1-.26,2.112,2.112,0,0,0-1.08.27A1.856,1.856,0,0,0,7.49,9a2.465,2.465,0,0,0-.26,1.14,2.256,2.256,0,0,0,.24,1,1.766,1.766,0,0,0,.69.74,2.056,2.056,0,0,0,1,.3l.86,1h1.21L10,12.08A1.79,1.79,0,0,0,11,11.32Zm-1-.25a.941.941,0,0,1-.76.35.916.916,0,0,1-.76-.36,1.523,1.523,0,0,1-.29-1,1.529,1.529,0,0,1,.29-1,1,1,0,0,1,.78-.37.869.869,0,0,1,.75.37,1.619,1.619,0,0,1,.27,1A1.459,1.459,0,0,1,10,11.07Z" fill="#f2f2f2" /></g>​
</svg>`, pb = '<svg id="b089cfca-0de1-451c-a1ca-6680ea50cb4f" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><radialGradient id="b25d0836-964a-4c84-8c20-855f66e8345e" cx="-105.006" cy="-10.409" r="5.954" gradientTransform="translate(117.739 19.644) scale(1.036 1.027)" gradientUnits="userSpaceOnUse"><stop offset="0.183" stop-color="#5ea0ef" /><stop offset="1" stop-color="#0078d4" /></radialGradient><clipPath id="b36c7f5d-2ef1-4760-8a25-eeb9661f4e47"><path d="M14.969,7.53A6.137,6.137,0,1,1,7.574,2.987,6.137,6.137,0,0,1,14.969,7.53Z" fill="none" /></clipPath></defs><title>Icon-databases-121</title><path d="M2.954,5.266a.175.175,0,0,1-.176-.176h0A2.012,2.012,0,0,0,.769,3.081a.176.176,0,0,1-.176-.175h0a.176.176,0,0,1,.176-.176A2.012,2.012,0,0,0,2.778.72.175.175,0,0,1,2.954.544h0A.175.175,0,0,1,3.13.72h0A2.012,2.012,0,0,0,5.139,2.729a.175.175,0,0,1,.176.176h0a.175.175,0,0,1-.176.176h0A2.011,2.011,0,0,0,3.13,5.09.177.177,0,0,1,2.954,5.266Z" fill="#50e6ff" /><path d="M15.611,17.456a.141.141,0,0,1-.141-.141h0a1.609,1.609,0,0,0-1.607-1.607.141.141,0,0,1-.141-.14h0a.141.141,0,0,1,.141-.141h0a1.608,1.608,0,0,0,1.607-1.607.141.141,0,0,1,.141-.141h0a.141.141,0,0,1,.141.141h0a1.608,1.608,0,0,0,1.607,1.607.141.141,0,1,1,0,.282h0a1.609,1.609,0,0,0-1.607,1.607A.141.141,0,0,1,15.611,17.456Z" fill="#50e6ff" /><g><path d="M14.969,7.53A6.137,6.137,0,1,1,7.574,2.987,6.137,6.137,0,0,1,14.969,7.53Z" fill="url(#b25d0836-964a-4c84-8c20-855f66e8345e)" /><g clip-path="url(#b36c7f5d-2ef1-4760-8a25-eeb9661f4e47)"><path d="M5.709,13.115A1.638,1.638,0,1,0,5.714,9.84,1.307,1.307,0,0,0,5.721,9.7,1.651,1.651,0,0,0,4.06,8.064H2.832a6.251,6.251,0,0,0,1.595,5.051Z" fill="#f2f2f2" /><path d="M15.045,7.815c0-.015,0-.03-.007-.044a5.978,5.978,0,0,0-1.406-2.88,1.825,1.825,0,0,0-.289-.09,1.806,1.806,0,0,0-2.3,1.663,2,2,0,0,0-.2-.013,1.737,1.737,0,0,0-.581,3.374,1.451,1.451,0,0,0,.541.1h2.03A13.453,13.453,0,0,0,15.045,7.815Z" fill="#f2f2f2" /></g></g><path d="M17.191,3.832c-.629-1.047-2.1-1.455-4.155-1.149a14.606,14.606,0,0,0-2.082.452,6.456,6.456,0,0,1,1.528.767c.241-.053.483-.116.715-.151A7.49,7.49,0,0,1,14.3,3.662a2.188,2.188,0,0,1,1.959.725h0c.383.638.06,1.729-.886,3a16.723,16.723,0,0,1-4.749,4.051A16.758,16.758,0,0,1,4.8,13.7c-1.564.234-2.682,0-3.065-.636s-.06-1.73.886-2.995c.117-.157.146-.234.279-.392a6.252,6.252,0,0,1,.026-1.63A11.552,11.552,0,0,0,1.756,9.419C.517,11.076.181,12.566.809,13.613a3.165,3.165,0,0,0,2.9,1.249,8.434,8.434,0,0,0,1.251-.1,17.855,17.855,0,0,0,6.219-2.4,17.808,17.808,0,0,0,5.061-4.332C17.483,6.369,17.819,4.88,17.191,3.832Z" fill="#50e6ff" /></svg>', gb = '<svg id="b5b638e5-1de7-4378-8f50-7c3738e5874c" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="e20ae4ca-8128-4625-bcc6-863bc1bc51d9" x1="5.05" y1="10.55" x2="5.05" y2="13.48" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#76bc2d" /><stop offset="1" stop-color="#5e9624" /></linearGradient><linearGradient id="b6fa89de-29eb-462e-97de-5bdbdaeb090e" x1="12.84" y1="10.57" x2="12.84" y2="13.5" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#76bc2d" /><stop offset="1" stop-color="#5e9624" /></linearGradient></defs><title>Icon-integration-204</title><g><path d="M3.19,15.6a2.49,2.49,0,0,1-1.53-.38,1.7,1.7,0,0,1-.45-1.36V10.33c0-.58-.23-.89-.71-.89V8.56c.48,0,.71-.31.71-.92V4.17a1.79,1.79,0,0,1,.45-1.39A2.29,2.29,0,0,1,3.19,2.4v.89c-.51,0-.79.27-.79.85v3.4c0,.78-.23,1.26-.74,1.46a1.42,1.42,0,0,1,.74,1.46v3.37a1.25,1.25,0,0,0,.17.68.74.74,0,0,0,.58.2l0,.89Z" fill="#949494" /><path d="M14.81,2.4a2.49,2.49,0,0,1,1.53.38,1.7,1.7,0,0,1,.45,1.36V7.67c0,.58.23.89.71.89v.88c-.48,0-.71.31-.71.92v3.43a1.8,1.8,0,0,1-.45,1.4,2.28,2.28,0,0,1-1.53.41v-.89c.51,0,.79-.27.79-.85v-3.4c0-.78.23-1.26.74-1.46a1.42,1.42,0,0,1-.74-1.46V4.17a1.25,1.25,0,0,0-.17-.68.74.74,0,0,0-.58-.2Z" fill="#949494" /><path d="M9.41,8.35V7.08h-.9V8.35a.18.18,0,0,1-.18.18H5a.36.36,0,0,0-.36.36v1.65h.9V9.63a.18.18,0,0,1,.17-.18h6.54a.18.18,0,0,1,.18.18v.93h.89V8.89a.36.36,0,0,0-.35-.36H9.59A.18.18,0,0,1,9.41,8.35Z" fill="#005ba1" /><path d="M10.61,3.21H7.25a.38.38,0,0,0-.38.37V6.94a.37.37,0,0,0,.38.37h3.36A.37.37,0,0,0,11,6.94V3.58A.38.38,0,0,0,10.61,3.21Zm-.32,3.17a.25.25,0,0,1-.25.24H7.81a.25.25,0,0,1-.25-.24V4.15a.25.25,0,0,1,.25-.25H10a.25.25,0,0,1,.25.25Z" fill="#0078d4" /><rect x="3.58" y="10.55" width="2.94" height="2.94" rx="0.27" fill="url(#e20ae4ca-8128-4625-bcc6-863bc1bc51d9)" /><rect x="11.38" y="10.57" width="2.94" height="2.94" rx="0.27" fill="url(#b6fa89de-29eb-462e-97de-5bdbdaeb090e)" /></g></svg>', mb = '<svg id="fd454f1c-5506-44b8-874e-8814b8b2f70b" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><defs><linearGradient id="f34d9569-2bd0-4002-8f16-3d01d8106cb5" x1="8.88" y1="12.21" x2="8.88" y2="0.21" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#0078d4" /><stop offset="0.82" stop-color="#5ea0ef" /></linearGradient><linearGradient id="bdb45a0b-eb58-4970-a60a-fb2ce314f866" x1="8.88" y1="16.84" x2="8.88" y2="12.21" gradientUnits="userSpaceOnUse"><stop offset="0.15" stop-color="#ccc" /><stop offset="1" stop-color="#707070" /></linearGradient></defs><title>Icon-compute-21</title><rect x="-0.12" y="0.21" width="18" height="12" rx="0.6" fill="url(#f34d9569-2bd0-4002-8f16-3d01d8106cb5)" /><polygon points="11.88 4.46 11.88 7.95 8.88 9.71 8.88 6.21 11.88 4.46" fill="#50e6ff" /><polygon points="11.88 4.46 8.88 6.22 5.88 4.46 8.88 2.71 11.88 4.46" fill="#c3f1ff" /><polygon points="8.88 6.22 8.88 9.71 5.88 7.95 5.88 4.46 8.88 6.22" fill="#9cebff" /><polygon points="5.88 7.95 8.88 6.21 8.88 9.71 5.88 7.95" fill="#c3f1ff" /><polygon points="11.88 7.95 8.88 6.21 8.88 9.71 11.88 7.95" fill="#9cebff" /><path d="M12.49,15.84c-1.78-.28-1.85-1.56-1.85-3.63H7.11c0,2.07-.06,3.35-1.84,3.63a1,1,0,0,0-.89,1h9A1,1,0,0,0,12.49,15.84Z" fill="url(#bdb45a0b-eb58-4970-a60a-fb2ce314f866)" /></svg>', xb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#669df6;}.cls-1,.cls-2,.cls-3{fill-rule:evenodd;}.cls-2{fill:#aecbfa;}.cls-3{fill:#4285f4;}</style></defs><title>Icon_24px_BigTable_Color</title><g data-name="Product Icons"><g ><path class="cls-1" d="M16.22,6.45,12,3.94a2.86,2.86,0,0,1-1.25-1.71s.16-.32.38-.2,3.5,2.06,5.25,3.1c.63.37.24,2,.24,2A.77.77,0,0,0,16.22,6.45Z"/><path class="cls-2" d="M17.49,12.69a.35.35,0,0,1-.16.33l-1,.68V5.75c0-.27.17-.56-.06-.7l.92.68a.73.73,0,0,1,.35.65Z"/><path class="cls-1" d="M12,13.6a.36.36,0,0,1-.2-.06L8.34,11.48v.9L12,14.56l.29-.57s-.22-.39-.29-.39Z"/><path class="cls-1" d="M12.2,15.4a.36.36,0,0,1-.4,0L8.34,13.34V14a.42.42,0,0,0,.19.35l3.28,2a.37.37,0,0,0,.38,0,2,2,0,0,0,.2-.52l-.19-.39Z"/><path class="cls-2" d="M12,12.73l3.66-2.18v-.43a.39.39,0,0,0-.19-.34l-3.28-2a.37.37,0,0,0-.38,0l-3.28,2a.41.41,0,0,0-.19.34v.43L12,12.73Z"/><path class="cls-1" d="M12,11.83,8.53,9.78a.41.41,0,0,0-.19.34v.43L12,12.73l.28-.56L12,11.83Z"/><path class="cls-3" d="M12,13.6v1l3.66-2.18v-.9L12.2,13.54a.65.65,0,0,1-.2.06Z"/><path class="cls-3" d="M12.2,15.4a.36.36,0,0,1-.2.06c0,.28,0,.9,0,.9a.5.5,0,0,0,.21-.05l3.28-2a.39.39,0,0,0,.19-.35v-.66L12.2,15.4Z"/><path class="cls-3" d="M15.47,9.78,12,11.83v.9l3.66-2.18v-.43a.39.39,0,0,0-.19-.34Z"/><path class="cls-1" d="M7.78,17.53,11.93,20a2.72,2.72,0,0,1,1.28,1.8.18.18,0,0,1-.28.18L7.48,18.75c-.53-.32-.07-1.88-.07-1.88A.77.77,0,0,0,7.78,17.53Z"/><path class="cls-2" d="M6.51,17.73V11.17a.41.41,0,0,1,.19-.33l1-.59v7.91c0,.27,0,.69.21.83l-1.06-.66A.75.75,0,0,1,6.51,17.73Z"/><path class="cls-1" d="M10.16,5.46a.75.75,0,0,0-.74,0L5.22,8a2.63,2.63,0,0,1-2.08.26.23.23,0,0,1,0-.4c.18-.09,6.32-3.74,6.32-3.74.23-.14.74,1.39.74,1.39Z"/><path class="cls-2" d="M10.15,4.08l5.32,3.15a.37.37,0,0,1,.2.31V8.72L9,4.76a.75.75,0,0,0-.74,0l1.18-.69a.71.71,0,0,1,.73,0Z"/><path class="cls-1" d="M13.82,18.49a.73.73,0,0,0,.74,0L18.76,16a2.63,2.63,0,0,1,2.1-.25.21.21,0,0,1,0,.38l-6.33,3.75c-.22.14-.74-1.4-.74-1.4Z"/><path class="cls-2" d="M8.51,16.75a.56.56,0,0,1-.17-.33V15.26L15,19.19a.69.69,0,0,0,.73,0l-1.18.7a.7.7,0,0,1-.74,0Z"/><path class="cls-1" d="M6.26,9.81a.76.76,0,0,0-.37.65v5a2.75,2.75,0,0,1-.87,2,.18.18,0,0,1-.3-.13V9.77c0-.28,1.54,0,1.54,0Z"/><path class="cls-2" d="M9.77,6.52a.34.34,0,0,1,.36,0l1,.59L5.05,10.67a.77.77,0,0,0-.37.66V9.94a.72.72,0,0,1,.38-.64Z"/><path class="cls-1" d="M18.17,13.44v-5a2.81,2.81,0,0,1,.84-2s.33-.11.31.21,0,7.37,0,7.37c-.31.37-1.61,0-1.61,0A.81.81,0,0,0,18.17,13.44Z"/><path class="cls-2" d="M19,14.61l-4.74,2.85a.35.35,0,0,1-.37,0l-1-.57L19,13.22a.77.77,0,0,0,.37-.66V14C19.35,14.23,19,14.61,19,14.61Z"/></g></g></svg>', Lb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#aecbfa;}.cls-1,.cls-2,.cls-3{fill-rule:evenodd;}.cls-2{fill:#669df6;}.cls-3{fill:#4285f4;}</style></defs><title>Icon_24px_BigQuery_Color</title><g data-name="Product Icons"><g ><path class="cls-1" d="M6.73,10.83v2.63A4.91,4.91,0,0,0,8.44,15.2V10.83Z"/><path class="cls-2" d="M9.89,8.41v7.53A7.62,7.62,0,0,0,11,16,8,8,0,0,0,12,16V8.41Z"/><path class="cls-1" d="M13.64,11.86v3.29a5,5,0,0,0,1.7-1.82V11.86Z"/><path class="cls-3" d="M17.74,16.32l-1.42,1.42a.42.42,0,0,0,0,.6l3.54,3.54a.42.42,0,0,0,.59,0l1.43-1.43a.42.42,0,0,0,0-.59l-3.54-3.54a.42.42,0,0,0-.6,0"/><path class="cls-2" d="M11,2a9,9,0,1,0,9,9,9,9,0,0,0-9-9m0,15.69A6.68,6.68,0,1,1,17.69,11,6.68,6.68,0,0,1,11,17.69"/></g></g></svg>', _b = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:none;}.cls-2{fill:#669df6;}.cls-2,.cls-3,.cls-4{fill-rule:evenodd;}.cls-3{fill:#aecbfa;}.cls-4{fill:#4285f4;}</style></defs><title>Icon_24px_CDN_Color</title><g data-name="Product Icons"><rect class="cls-1" x="2" y="2" width="20" height="20"/><g ><polygon id="Fill-1" class="cls-2" points="12 2 12 4.41 15.13 7.63 15.13 5.21 12 2"/><polygon id="Fill-1-Copy-2" class="cls-2" points="19.5 12 16.38 15.13 18.88 15.13 22 12 19.5 12"/><polygon id="Fill-1-Copy-3" class="cls-2" points="4.5 12 7.63 15.13 5.13 15.13 2 12 4.5 12"/><polygon id="Fill-1-Copy" class="cls-2" points="12 22 12 19.59 15.13 16.38 15.13 18.79 12 22"/><polygon id="Fill-2" class="cls-3" points="12 2 8.88 5.21 8.88 7.63 12 4.41 12 2"/><polygon id="Fill-2-Copy-2" class="cls-3" points="18.88 8.88 16.38 8.88 19.5 12 22 12 18.88 8.88"/><polygon id="Fill-2-Copy-3" class="cls-3" points="5.13 8.88 7.63 8.88 4.5 12 2 12 5.13 8.88"/><polygon id="Fill-2-Copy" class="cls-3" points="12 22 8.88 18.79 8.88 16.38 12 19.59 12 22"/><polygon id="Fill-9" class="cls-3" points="15.13 15.13 8.88 15.13 8.88 8.88 15.13 8.88 15.13 15.13"/><polygon id="Fill-10" class="cls-2" points="15.13 8.88 15.13 15.13 8.88 15.13 15.13 8.88"/><polygon class="cls-4" points="15.13 8.88 15.13 15.13 12 12 15.13 8.88"/></g></g></svg>', yb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#4285f4;}.cls-2{fill:#669df6;}.cls-3{fill:#aecbfa;}.cls-4{fill:#fff;}</style></defs><title>Icon_24px_DNS_Color</title><g data-name="Product Icons"><g data-name="colored-32/dns"><g ><polygon id="Fill-1" class="cls-1" points="13 18 11 18 11 8 13 8 13 18"/><polygon id="Fill-2" class="cls-2" points="2 21 22 21 22 19 2 19 2 21"/><polygon id="Fill-3" class="cls-3" points="10 22 14 22 14 18 10 18 10 22"/></g></g><rect class="cls-3" x="2" y="2" width="20" height="6"/><rect class="cls-2" x="12" y="2" width="10" height="6"/><rect class="cls-4" x="4" y="4" width="2" height="2"/><rect class="cls-3" x="2" y="10" width="20" height="6"/><rect class="cls-2" x="12" y="10" width="10" height="6"/><rect class="cls-4" x="4" y="12" width="2" height="2"/></g></svg>', Cb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#4285f4;}.cls-1,.cls-2,.cls-3{fill-rule:evenodd;}.cls-2{fill:#aecbfa;}.cls-3{fill:#669df6;}</style></defs><title>Icon_24px_Interconnect_Color</title><g data-name="Product Icons"><g ><polygon id="Fill-3" class="cls-1" points="2 13 6 13 6 11 2 11 2 13"/><polygon id="Fill-6" class="cls-2" points="15 17 5 17 5 7 15 7 15 17"/><polygon id="Fill-1" class="cls-1" points="17.33 13 22 13 22 11 17.33 11 17.33 13"/><polygon class="cls-3" points="8 3 8 5 17 5 17 19 8 19 8 21 19 21 19 19 19 5 19 3 8 3"/><polygon id="Fill-7" class="cls-3" points="15 17 10 17 10 7 15 7 15 17"/></g></g></svg>', vb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:none;}.cls-2{fill:#669df6;}.cls-3{fill:#4285f4;}.cls-4{fill:#aecbfa;}</style></defs><title>Icon_24px_LoadBalancing_Color</title><g data-name="Product Icons"><g data-name="colored-32/load-balancing"><rect class="cls-1" width="24" height="24"/><g ><rect class="cls-2" x="18" y="12" width="2" height="4"/><rect class="cls-2" x="11" y="12" width="2" height="4"/><rect class="cls-2" x="4" y="12" width="2" height="4"/><polygon id="Fill-2" class="cls-3" points="13 11 11 11 11 7 13 7 13 11"/><rect class="cls-2" x="4" y="11" width="16" height="2"/><rect class="cls-4" x="6" y="2" width="12" height="5"/><rect class="cls-2" x="12" y="2" width="6" height="5"/><rect class="cls-4" x="16" y="16" width="6" height="6"/><rect class="cls-4" x="2" y="16" width="6" height="6"/><rect class="cls-2" x="5" y="16" width="3" height="6"/><rect class="cls-4" x="9" y="16" width="6" height="6"/><rect class="cls-2" x="12" y="16" width="3" height="6"/><rect class="cls-2" x="19" y="16" width="3" height="6"/></g></g></g></svg>', bb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#aecbfa;}.cls-1,.cls-2,.cls-3{fill-rule:evenodd;}.cls-2{fill:#669df6;}.cls-3{fill:#4285f4;}</style></defs><title>Icon_24px_SQL_Color</title><g data-name="Product Icons"><g ><polygon class="cls-1" points="4.67 10.44 4.67 13.45 12 17.35 12 14.34 4.67 10.44"/><polygon class="cls-1" points="4.67 15.09 4.67 18.1 12 22 12 18.99 4.67 15.09"/><polygon class="cls-2" points="12 17.35 19.33 13.45 19.33 10.44 12 14.34 12 17.35"/><polygon class="cls-2" points="12 22 19.33 18.1 19.33 15.09 12 18.99 12 22"/><polygon class="cls-3" points="19.33 8.91 19.33 5.9 12 2 12 5.01 19.33 8.91"/><polygon class="cls-2" points="12 2 4.67 5.9 4.67 8.91 12 5.01 12 2"/><polygon class="cls-1" points="4.67 5.87 4.67 8.89 12 12.79 12 9.77 4.67 5.87"/><polygon class="cls-2" points="12 12.79 19.33 8.89 19.33 5.87 12 9.77 12 12.79"/></g></g></svg>', wb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#aecbfa;}.cls-2{fill:#669df6;}.cls-3{fill:#4285f4;}.cls-4{fill:#fff;}</style></defs><title>Icon_24px_CloudStorage_Color</title><g data-name="Product Icons"><rect class="cls-1" x="2" y="4" width="20" height="7"/><rect class="cls-2" x="20" y="4" width="2" height="7"/><polygon class="cls-3" points="22 4 20 4 20 11 22 4"/><rect class="cls-2" x="2" y="4" width="2" height="7"/><rect class="cls-4" x="6" y="7" width="6" height="1"/><rect class="cls-4" x="15" y="6" width="3" height="3" rx="1.5"/><rect class="cls-1" x="2" y="13" width="20" height="7"/><rect class="cls-2" x="20" y="13" width="2" height="7"/><polygon class="cls-3" points="22 13 20 13 20 20 22 13"/><rect class="cls-2" x="2" y="13" width="2" height="7"/><rect class="cls-4" x="6" y="16" width="6" height="1"/><rect class="cls-4" x="15" y="15" width="3" height="3" rx="1.5"/></g></svg>', Eb = `<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M14.7110701,8.84507935 C14.7717439,8.84507935 14.8231931,8.88719721 14.8413458,8.94564457 L14.8483412,8.99213893 L14.8483412,9.80096662 C14.8483412,9.86590813 14.8090267,9.92106136 14.7544697,9.94052499 L14.7110701,9.9480262 L14.1619856,9.9480262 L14.1619856,11.3971513 C14.1619856,11.4393574 14.1689102,11.4810733 14.1822916,11.5204472 L14.2071478,11.5775199 L17.9097614,18.3983638 C18.0128912,18.5897093 18.0276241,18.8190863 17.9539599,19.0212979 L17.9097614,19.1198381 L16.5667009,21.6392628 C16.4635711,21.8306084 16.2854576,21.9589644 16.0851783,21.9917325 L15.983436,22 L8.01656405,22 C7.8103044,22 7.61750853,21.8989791 7.49086453,21.7295356 L7.43329911,21.6392628 L6.09023859,19.1198381 C5.98710877,18.9284926 5.97237594,18.6991157 6.0460401,18.496904 L6.09023859,18.3983638 L9.78310593,11.5775199 C9.80278146,11.5409511 9.8205962,11.5011143 9.83028652,11.4598613 L9.83794574,11.3971513 L9.83794574,9.9480262 L9.28886131,9.9480262 C9.22824239,9.9480262 9.17676023,9.90586128 9.15859212,9.84743274 L9.1515902,9.80096662 L9.1515902,8.99213893 C9.1515902,8.9271386 9.19094857,8.87202066 9.24548803,8.85257351 L9.28886131,8.84507935 L14.7110701,8.84507935 Z M13.1324523,9.9480262 L10.867479,9.9480262 L10.867479,11.6220054 C10.867479,11.7170243 10.8499898,11.810761 10.8163145,11.8979731 L10.7772919,11.9828161 L7.23720733,18.5909383 C7.18910754,18.6801741 7.17948758,18.7860688 7.2083826,18.8820057 L7.23727597,18.9516755 L8.15266835,20.6500666 C8.20076815,20.7393612 8.28154945,20.8012203 8.37354086,20.8223922 L8.44430082,20.8304352 L9.572,20.83 L8.57527805,18.9792271 C8.52717825,18.8899325 8.51755829,18.7840732 8.54641817,18.6881527 L8.57527805,18.6184899 L9.44379234,17.006864 L15.913,17.006 L15.399,16.047 L13.0053393,16.0472267 L12.6160384,15.3248701 L15.012,15.324 L14.292,13.979 L11.8745205,13.9792234 L11.4852196,13.2568668 L13.904,13.256 L13.2227081,11.9828161 C13.1783867,11.9005363 13.1497785,11.8099843 13.1382445,11.7164027 L13.1324523,11.6220054 L13.1324523,9.9480262 Z M16.347,17.815 L13.9560996,17.8156917 L14.3454004,18.5509896 L16.741,18.55 L16.347,17.815 Z M10.630604,5.77278412 C11.0025401,5.77278412 11.3040561,6.09587402 11.3040561,6.49433196 C11.3040561,6.89278989 11.0025401,7.21580626 10.630604,7.21580626 C10.258668,7.21580626 9.95715197,6.89278989 9.95715197,6.49433196 C9.95715197,6.09587402 10.258668,5.77278412 10.630604,5.77278412 Z M13.1716089,4.22465851 C13.7295473,4.22465851 14.1818556,4.7091463 14.1818556,5.30686996 C14.1818556,5.9045201 13.7295473,6.38908141 13.1716089,6.38908141 C12.6136705,6.38908141 12.1614308,5.9045201 12.1614308,5.30686996 C12.1614308,4.7091463 12.6136705,4.22465851 13.1716089,4.22465851 Z M11.6407615,2 C12.0126976,2 12.3142822,2.3230899 12.3142822,2.72154783 C12.3142822,3.12000576 12.0126976,3.44302213 11.6407615,3.44302213 C11.2688941,3.44302213 10.9673095,3.12000576 10.9673095,2.72154783 C10.9673095,2.3230899 11.2688941,2 11.6407615,2 Z" fill="#4285F4"></path>
    </g>
</svg>`, Tb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:none;}.cls-2{fill:#aecbfa;}.cls-2,.cls-3,.cls-4{fill-rule:evenodd;}.cls-3{fill:#4285f4;}.cls-4{fill:#669df6;}</style></defs><title>Icon_24px_DataProc_Color</title><g data-name="Product Icons"><rect class="cls-1" x="2" y="2" width="20" height="20"/><g ><polygon class="cls-2" points="17.85 14.2 7.67 20.08 6.69 18.4 16.88 12.51 17.85 14.2"/><polygon class="cls-2" points="7.63 18.16 7.63 6.4 9.5 6.4 9.5 16.75 7.63 18.16"/><polygon class="cls-2" points="9.56 9.69 9.3 7.33 19.49 13.2 18.52 14.88 9.56 9.69"/><path class="cls-3" d="M14.39,10.26,9.3,7.33l.26,2.36,1.51.86a4,4,0,0,0,3.32-.29Z"/><path class="cls-2" d="M8.13,8.29h0a3.78,3.78,0,1,1,3.27,1.89A3.8,3.8,0,0,1,8.13,8.29ZM13,5.49a1.84,1.84,0,0,0-1.59-.92A1.83,1.83,0,0,0,9.57,6.4a1.84,1.84,0,1,0,3.67,0A1.8,1.8,0,0,0,13,5.49Z"/><path class="cls-3" d="M7.63,12.94v5.22L9.5,16.75V15.12a3.29,3.29,0,0,0-1.87-2.18Z"/><path class="cls-3" d="M13.33,16.81l4.52-2.61-2.21-1L14.39,14a4.23,4.23,0,0,0-1.06,2.86Z"/><path class="cls-2" d="M2.51,18.7h0a3.77,3.77,0,0,1,1.38-5.16,3.72,3.72,0,0,1,2.86-.38A3.78,3.78,0,1,1,2.51,18.7Zm4.85-2.81A1.79,1.79,0,0,0,6.25,15a1.83,1.83,0,0,0-2.06,2.69h0a1.83,1.83,0,1,0,3.17-1.84Z"/><path class="cls-2" d="M14.33,18.36h0a3.79,3.79,0,0,1,0-3.77,3.79,3.79,0,0,1,5.16-1.39,3.78,3.78,0,0,1,1.38,5.16,3.78,3.78,0,0,1-6.54,0Zm4.86-2.81a2,2,0,0,0-.67-.67,1.85,1.85,0,0,0-2.51.68,1.86,1.86,0,0,0,0,1.83,1.83,1.83,0,0,0,2.07.85,1.82,1.82,0,0,0,1.11-.85,1.88,1.88,0,0,0,0-1.84Z"/><path class="cls-4" d="M9.49,16.15s-2.34,2-2.8,2.25l2.86-1.65a4.07,4.07,0,0,0-.06-.6Z"/><path class="cls-4" d="M10.15,10S9.56,6.72,9.56,6.4V9.69a3.47,3.47,0,0,0,.59.27Z"/><path class="cls-4" d="M15.3,13.47s2.76,1.15,3.22,1.41l-2.86-1.64a1.69,1.69,0,0,0-.36.23Z"/></g></g></svg>', Sb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#669df6;}.cls-1,.cls-2{fill-rule:evenodd;}.cls-2{fill:#4285f4;}</style></defs><title>Icon_24px_IAM_Color</title><g data-name="Product Icons"><g ><path class="cls-1" d="M12,2,3.79,5.42v5.63c0,5.06,3.5,9.8,8.21,11,4.71-1.15,8.21-5.89,8.21-10.95V5.42Zm0,3.79a2.63,2.63,0,1,1-1.86.77A2.63,2.63,0,0,1,12,5.79Zm4.11,11.15A8.64,8.64,0,0,1,12,19.87a8.64,8.64,0,0,1-4.11-2.93V14.69c0-1.67,2.74-2.52,4.11-2.52s4.11.85,4.11,2.52v2.25Z"/><path class="cls-2" d="M12,2V5.79a2.63,2.63,0,1,1,0,5.26v1.12c1.37,0,4.11.85,4.11,2.52v2.25A8.64,8.64,0,0,1,12,19.87V22c4.71-1.15,8.21-5.89,8.21-10.95V5.42Z"/></g></g></svg>', Ab = `<svg version="1.1" baseProfile="tiny" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
	 x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" overflow="visible" xml:space="preserve">
<g >
	<g transform="translate(4.000000, 1.000000)">
		<path fill="#85A4E6" d="M8,0l-9,4v6c0,5.6,3.8,10.7,9,12c5.2-1.3,9-6.4,9-12V4L8,0z M8,11h7c-0.5,4.1-3.3,7.8-7,8.9V11l-7,0V5.3
			l7-3.1V11z"/>
		<path fill="#5C85DE" d="M8,0v22c5.2-1.3,9-6.4,9-12V4L8,0z M15,11c-0.5,4.1-3.3,7.8-7,8.9V11L15,11z"/>
		<path fill-rule="evenodd" fill="#3367D6" d="M17,11h-2c0,0,0,0.3-0.1,0.6L17,11z"/>
		<polygon fill-rule="evenodd" fill="#3367D6" points="-1,11 1,11 1,10.4 		"/>
	</g>
</g>
</svg>
`, kb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:#aecbfa;}.cls-2{fill:#669df6;}.cls-3{fill:#4285f4;}</style></defs><title>Icon_24px_VirtualPrivateCloud_Color</title><g data-name="Product Icons"><rect class="cls-1" x="16" y="2" width="6" height="6"/><rect class="cls-2" x="19" y="2" width="3" height="6"/><rect class="cls-1" x="16" y="16" width="6" height="6"/><rect class="cls-2" x="19" y="16" width="3" height="6"/><rect class="cls-1" x="2" y="2" width="6" height="6"/><rect class="cls-2" x="5" y="2" width="3" height="6"/><rect class="cls-1" x="2" y="16" width="6" height="6"/><rect class="cls-2" x="5" y="16" width="3" height="6"/><rect class="cls-2" x="8" y="4" width="8" height="2"/><rect class="cls-2" x="8" y="18" width="8" height="2"/><rect class="cls-2" x="18" y="8" width="2" height="8"/><rect class="cls-2" x="4" y="8" width="2" height="8"/><rect class="cls-3" x="4" y="8" width="2" height="2"/><rect class="cls-3" x="18" y="8" width="2" height="2"/><rect class="cls-3" x="8" y="4" width="2" height="2"/><rect class="cls-3" x="8" y="18" width="2" height="2"/></g></svg>', Rb = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{filter:url(#luminosity-noclip);}.cls-2{fill:#669df6;}.cls-3{mask:url(#mask);}.cls-4{fill:#4285f4;}.cls-5{fill:#aecbfa;}</style><filter id="luminosity-noclip" x="4.64" y="4.19" width="14.73" height="12.76" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-color="#fff" result="bg"/><feBlend in="SourceGraphic" in2="bg"/></filter><mask id="mask" x="4.64" y="4.19" width="14.73" height="12.76" maskUnits="userSpaceOnUse"><circle class="cls-1" cx="12" cy="12.23" r="3.58"/></mask></defs><title>Icon_24px_Pub-Sub_Color</title><g data-name="Product Icons"><circle class="cls-2" cx="18.97" cy="8.21" r="1.72"/><circle class="cls-2" cx="5.03" cy="8.21" r="1.72"/><circle class="cls-2" cx="12" cy="20.28" r="1.72"/><g class="cls-3"><rect class="cls-4" x="14.69" y="10.22" width="1.59" height="8.04" transform="matrix(0.5, -0.87, 0.87, 0.5, -4.59, 20.53)"/><rect class="cls-4" x="4.49" y="13.45" width="8.04" height="1.59" transform="translate(-5.98 6.17) rotate(-30)"/><rect class="cls-4" x="11.2" y="4.19" width="1.59" height="8.04"/></g><circle class="cls-5" cx="12" cy="12.23" r="2.78"/><circle class="cls-5" cx="5.03" cy="16.25" r="2.19"/><circle class="cls-5" cx="18.97" cy="16.25" r="2.19"/><circle class="cls-5" cx="12" cy="4.19" r="2.19"/></g></svg>', Ob = '<svg id="Artwork" xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><circle cx="11.45" cy="11.51" r="2.89" style="fill:#669df6"/><path d="M18.05,6.81a8.12,8.12,0,0,0-4.94-3.23l-.27,1.3A6.79,6.79,0,1,1,6.65,6.74l-1-.94a8.1,8.1,0,1,0,13,2.12A1.31,1.31,0,0,1,18.05,6.81Z" style="fill:#aecbfa"/><path d="M14.46,20.42a2,2,0,1,1,0-3.93" style="fill:#669df6"/><path d="M14.46,16.49a2,2,0,1,1,0,3.93" style="fill:#4285f4"/><path d="M19.38,8.1a1.34,1.34,0,0,1,0-2.67v-1h0a2.38,2.38,0,0,0,0,4.75Z" style="fill:#669df6"/><path d="M19.38,5.43a1.34,1.34,0,0,1,0,2.67v1h0a2.38,2.38,0,0,0,0-4.75Z" style="fill:#4285f4"/><path d="M4.22,12.78a2,2,0,1,1,0-3.93" style="fill:#669df6"/><path d="M4.22,8.85a2,2,0,0,1,0,3.93" style="fill:#4285f4"/></svg>', Ib = '<svg id="Artwork" xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><polygon points="11.19 11.35 15.75 3.51 6.75 3.51 2.25 11.35 11.19 11.35" style="fill:#aecbfa"/><polygon points="2.25 12.65 6.74 20.49 15.73 20.49 11.25 12.65 2.25 12.65" style="fill:#4285f4"/><path d="M21.75,12l-4.5-7.87L12.74,12l4.51,7.87Z" style="fill:#669df6"/></svg>', Mb = '<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"><defs><style>.cls-1{fill:none;}.cls-2{fill:#669df6;}.cls-3{fill:#aecbfa;}.cls-4{fill:#4285f4;}</style></defs><title>Icon_24px_VisionAPI_Color</title><g data-name="Product Icons"><g data-name="colored-32/vision"><rect class="cls-1" width="24" height="24"/><g ><polygon class="cls-2" points="6 12 12 16.99 12 20 2 12 6 12"/><polygon id="Shape-2" data-name="Shape" class="cls-2" points="12 16.99 18 12 22 12 12 20 12 16.99"/><polygon id="Shape-3" data-name="Shape" class="cls-3" points="2 12 12 4 12 7.01 6 12 2 12"/><polygon id="Shape-4" data-name="Shape" class="cls-3" points="12 7.01 18 12 22 12 12 4 12 7.01"/><circle id="Oval" class="cls-4" cx="12" cy="12" r="2"/></g></g></g></svg>', Nb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.78799 2H16.212C17.0305 1.99999 17.7061 1.99998 18.2561 2.04565C18.8274 2.0931 19.3523 2.19496 19.8439 2.45035C20.5745 2.82985 21.1702 3.42553 21.5497 4.1561C21.805 4.64774 21.9069 5.17258 21.9543 5.74393C22 6.29394 22 6.96949 22 7.78802V11.212C22 12.0305 22 12.7061 21.9543 13.2561C21.9069 13.8274 21.805 14.3523 21.5497 14.8439C21.1702 15.5745 20.5745 16.1702 19.8439 16.5497C19.3523 16.805 18.8274 16.9069 18.2561 16.9544C17.7061 17 17.0305 17 16.212 17H13V19H17C17.5523 19 18 19.4477 18 20C18 20.5523 17.5523 21 17 21H7C6.44772 21 6 20.5523 6 20C6 19.4477 6.44772 19 7 19H11V17H7.78798C6.96946 17 6.29393 17 5.74393 16.9544C5.17258 16.9069 4.64774 16.805 4.1561 16.5497C3.42553 16.1702 2.82985 15.5745 2.45035 14.8439C2.19496 14.3523 2.0931 13.8274 2.04565 13.2561C1.99998 12.7061 1.99999 12.0305 2 11.212V7.78799C1.99999 6.96947 1.99998 6.29393 2.04565 5.74393C2.0931 5.17258 2.19496 4.64774 2.45035 4.1561C2.82985 3.42553 3.42553 2.82985 4.1561 2.45035C4.64774 2.19496 5.17258 2.0931 5.74393 2.04565C6.29393 1.99998 6.96947 1.99999 7.78799 2ZM16.17 15C17.041 15 17.6331 14.9992 18.0905 14.9612C18.536 14.9242 18.7634 14.8572 18.9219 14.7748C19.2872 14.5851 19.5851 14.2872 19.7748 13.9219C19.8572 13.7634 19.9242 13.536 19.9612 13.0905C19.9992 12.6331 20 12.041 20 11.17V7.83C20 6.95898 19.9992 6.36686 19.9612 5.90945C19.9242 5.46401 19.8572 5.23663 19.7748 5.07805C19.5851 4.71277 19.2872 4.41493 18.9219 4.22517C18.7634 4.1428 18.536 4.07578 18.0905 4.03879C17.6331 4.0008 17.041 4 16.17 4H7.83C6.95898 4 6.36686 4.0008 5.90945 4.03879C5.46401 4.07578 5.23663 4.1428 5.07805 4.22517C4.71277 4.41493 4.41493 4.71277 4.22517 5.07805C4.1428 5.23663 4.07578 5.46401 4.03879 5.90945C4.0008 6.36686 4 6.95898 4 7.83V11.17C4 12.041 4.0008 12.6331 4.03879 13.0905C4.07578 13.536 4.1428 13.7634 4.22517 13.9219C4.41493 14.2872 4.71277 14.5851 5.07805 14.7748C5.23663 14.8572 5.46401 14.9242 5.90945 14.9612C6.36686 14.9992 6.95898 15 7.83 15H16.17Z" fill="#0F1729"/>
</svg>`, Pb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\r
<path d="M2 18C2 17.0681 2 16.6022 2.15224 16.2346C2.35523 15.7446 2.74458 15.3552 3.23463 15.1522C3.60218 15 4.06812 15 5 15H19C19.9319 15 20.3978 15 20.7654 15.1522C21.2554 15.3552 21.6448 15.7446 21.8478 16.2346C22 16.6022 22 17.0681 22 18C22 18.9319 22 19.3978 21.8478 19.7654C21.6448 20.2554 21.2554 20.6448 20.7654 20.8478C20.3978 21 19.9319 21 19 21H5C4.06812 21 3.60218 21 3.23463 20.8478C2.74458 20.6448 2.35523 20.2554 2.15224 19.7654C2 19.3978 2 18.9319 2 18Z" stroke="#1C274C" stroke-width="1.5"/>\r
<path d="M2 12C2 11.0681 2 10.6022 2.15224 10.2346C2.35523 9.74458 2.74458 9.35523 3.23463 9.15224C3.60218 9 4.06812 9 5 9H19C19.9319 9 20.3978 9 20.7654 9.15224C21.2554 9.35523 21.6448 9.74458 21.8478 10.2346C22 10.6022 22 11.0681 22 12C22 12.9319 22 13.3978 21.8478 13.7654C21.6448 14.2554 21.2554 14.6448 20.7654 14.8478C20.3978 15 19.9319 15 19 15H5C4.06812 15 3.60218 15 3.23463 14.8478C2.74458 14.6448 2.35523 14.2554 2.15224 13.7654C2 13.3978 2 12.9319 2 12Z" stroke="#1C274C" stroke-width="1.5"/>\r
<path d="M2 6C2 5.06812 2 4.60218 2.15224 4.23463C2.35523 3.74458 2.74458 3.35523 3.23463 3.15224C3.60218 3 4.06812 3 5 3H19C19.9319 3 20.3978 3 20.7654 3.15224C21.2554 3.35523 21.6448 3.74458 21.8478 4.23463C22 4.60218 22 5.06812 22 6C22 6.93188 22 7.39782 21.8478 7.76537C21.6448 8.25542 21.2554 8.64477 20.7654 8.84776C20.3978 9 19.9319 9 19 9H5C4.06812 9 3.60218 9 3.23463 8.84776C2.74458 8.64477 2.35523 8.25542 2.15224 7.76537C2 7.39782 2 6.93188 2 6Z" stroke="#1C274C" stroke-width="1.5"/>\r
<circle cx="5" cy="12" r="1" fill="#1C274C"/>\r
<circle cx="5" cy="6" r="1" fill="#1C274C"/>\r
<circle cx="5" cy="18" r="1" fill="#1C274C"/>\r
</svg>`, Fb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 0 192 192" xmlns="http://www.w3.org/2000/svg" fill="none"><circle cx="96" cy="96" r="74" stroke="#000000" stroke-width="12"/><ellipse cx="96" cy="96" stroke="#000000" stroke-width="12" rx="30" ry="74"/><path stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="12" d="M28 72h136M28 120h136"/></svg>`, Db = `<?xml version="1.0" encoding="UTF-8"?>\r
\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 0 48 48" id="b" xmlns="http://www.w3.org/2000/svg">\r
\r
<defs>\r
\r
<style>.c{fill:none;stroke:#000000;stroke-linecap:round;stroke-linejoin:round;}</style>\r
\r
</defs>\r
\r
<g>\r
\r
<path class="c" d="m7.1972,25.8996c.2982.3882.6722.5328,1.1924.5328h.72c.67,0,1.2132-.5432,1.2132-1.2132v-.0052c0-.67-.5431-1.2132-1.2132-1.2132h-.7942c-.6707,0-1.2145-.5437-1.2145-1.2145h0c0-.6722.5449-1.2171,1.2171-1.2171h.716c.5202,0,.8942.1446,1.1924.5328"/>\r
\r
<g>\r
\r
<g>\r
\r
<line class="c" x1="13.1777" y1="24.0005" x2="14.7631" y2="24.0005"/>\r
\r
<polyline class="c" points="15.1861 26.4319 12.7546 26.4319 12.7546 21.5687 15.1861 21.5687"/>\r
\r
<path class="c" d="m17.6177,26.4321v-4.8632h1.5921c.9001,0,1.6298.7312,1.6298,1.6333s-.7297,1.6333-1.6298,1.6333h-1.5921"/>\r
\r
<line class="c" x1="19.2104" y1="24.8357" x2="20.8019" y2="26.4309"/>\r
\r
<polyline class="c" points="26.4926 21.569 24.8817 26.4322 23.2707 21.569"/>\r
\r
<path class="c" d="m28.9246,21.5689v4.8634"/>\r
\r
</g>\r
\r
<path class="c" d="m34.5781,24.8216c0,.8897-.7212,1.6109-1.6109,1.6109s-1.6109-.7212-1.6109-1.6109v-1.6413c0-.8897.7212-1.6109,1.6109-1.6109h0c.8897,0,1.6109.7212,1.6109,1.6109"/>\r
\r
<line class="c" x1="37.0096" y1="24.0005" x2="38.595" y2="24.0005"/>\r
\r
<polyline class="c" points="39.4412 26.4319 37.0096 26.4319 37.0096 21.5687 39.4412 21.5687"/>\r
\r
</g>\r
\r
</g>\r
\r
<g>\r
\r
<path class="c" d="m28.8737,42.5l-4.4403-13.6619m-3.1416-9.6665l-4.4434-13.6716"/>\r
\r
<path class="c" d="m28.8737,42.5l4.4304-13.6315m3.1743-9.767l4.4206-13.6011"/>\r
\r
<path class="c" d="m16.8483,5.5002h24.0508"/>\r
\r
</g>\r
\r
</svg>`, Bb = `<?xml version="1.0" ?>
\r<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
\r<title/>
\r<g data-name="Joy Stick" id="Joy_Stick">
\r<path d="M20,18.5H12a1,1,0,0,1-1-1v-2a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1v2A1,1,0,0,1,20,18.5Zm-7-2h0Z"/>
\r<path d="M52,18.5H44a1,1,0,0,1-1-1v-2a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1v2A1,1,0,0,1,52,18.5Zm-7-2h0Z"/>
\r<path d="M55.7,49.5H49.58a7,7,0,0,1-6.5-4.13A11.4,11.4,0,0,0,32.62,38.5H31.38a11.4,11.4,0,0,0-10.46,6.87,7,7,0,0,1-6.5,4.13H8.3a4.33,4.33,0,0,1-4.2-5.41L11,17.25a1,1,0,0,1,1-.75H52a1,1,0,0,1,1,.75L59.9,44.09a4.33,4.33,0,0,1-4.2,5.41Zm-24.32-13h1.24a13.38,13.38,0,0,1,12.29,8.08,5,5,0,0,0,4.67,2.92H55.7A2.33,2.33,0,0,0,58,44.59L51.23,18.5H12.77L6,44.59A2.33,2.33,0,0,0,8.3,47.5h6.12a5,5,0,0,0,4.67-2.92A13.38,13.38,0,0,1,31.38,36.5Z"/>
\r<path d="M21,34.5H17a1,1,0,0,1-1-1v-2H14a1,1,0,0,1-1-1v-4a1,1,0,0,1,1-1h2v-2a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1v2h2a1,1,0,0,1,1,1v4a1,1,0,0,1-1,1H22v2A1,1,0,0,1,21,34.5Zm-3-2h2v-2a1,1,0,0,1,1-1h2v-2H21a1,1,0,0,1-1-1v-2H18v2a1,1,0,0,1-1,1H15v2h2a1,1,0,0,1,1,1Z"/>
\r<path d="M46,26.5a2,2,0,1,1,2-2A2,2,0,0,1,46,26.5Zm0-2Z"/>
\r<path d="M46,34.5a2,2,0,1,1,2-2A2,2,0,0,1,46,34.5Zm0-2Z"/>
\r<path d="M50,30.5a2,2,0,1,1,2-2A2,2,0,0,1,50,30.5Zm0-2Z"/>
\r<path d="M42,30.5a2,2,0,1,1,2-2A2,2,0,0,1,42,30.5Zm0-2Z"/>
\r</g>
\r</svg>`, $b = `<?xml version="1.0" encoding="iso-8859-1"?>\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\r
<svg fill="#000000" height="800px" width="800px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" \r
	 viewBox="0 0 380 380" xml:space="preserve">\r
<g>\r
	<path d="M91.425,157.435c-1.065-2.297-3.366-3.767-5.897-3.767c-0.005,0-0.01,0-0.015,0c-2.537,0.006-4.839,1.487-5.895,3.794\r
		L47.402,227.83c-1.494,3.264-0.06,7.122,3.204,8.616c0.877,0.401,1.797,0.591,2.702,0.591c2.464,0,4.821-1.409,5.914-3.796\r
		l8.08-17.649h36.75l8.193,17.677c1.51,3.257,5.373,4.674,8.631,3.164c3.257-1.51,4.673-5.374,3.164-8.631L91.425,157.435z\r
		 M73.254,202.592l12.311-26.888l12.462,26.888H73.254z"/>\r
	<path d="M166.496,152.865H135.07c-3.59,0-6.5,2.91-6.5,6.5v71.17c0,3.59,2.91,6.5,6.5,6.5c3.59,0,6.5-2.91,6.5-6.5V203.5h24.926\r
		c13.96,0,25.316-11.357,25.316-25.316C191.813,164.223,180.456,152.865,166.496,152.865z M166.496,190.5H141.57v-24.635h24.926\r
		c6.792,0,12.316,5.526,12.316,12.318C178.813,184.975,173.288,190.5,166.496,190.5z"/>\r
	<path d="M203.313,152.865c-3.59,0-6.5,2.91-6.5,6.5v71.17c0,3.59,2.91,6.5,6.5,6.5s6.5-2.91,6.5-6.5v-71.17\r
		C209.813,155.775,206.902,152.865,203.313,152.865z"/>\r
	<path d="M368.317,46.487H11.684C5.241,46.487,0,51.73,0,58.173v263.656c0,6.442,5.241,11.684,11.684,11.684h356.634\r
		c6.442,0,11.683-5.242,11.683-11.684V58.173C380,51.73,374.76,46.487,368.317,46.487z M280.949,259.268\r
		c5.162-12.192,17.053-20.07,30.295-20.07c4.411,0,8.721,0.878,12.813,2.61c16.696,7.072,24.529,26.408,17.461,43.105\r
		c-5.167,12.191-17.058,20.068-30.294,20.068c0,0,0,0-0.001,0c-4.411,0-8.721-0.878-12.81-2.611\r
		c-8.089-3.424-14.361-9.793-17.659-17.935C277.455,276.294,277.524,267.356,280.949,259.268z M320.868,79.771\r
		c6.844,0,12.387,5.547,12.387,12.387c0,6.842-5.543,12.387-12.387,12.387c-6.839,0-12.385-5.545-12.385-12.387\r
		C308.483,85.318,314.029,79.771,320.868,79.771z M283.715,79.771c6.839,0,12.386,5.547,12.386,12.387\r
		c0,6.842-5.547,12.387-12.386,12.387c-6.839,0-12.387-5.545-12.387-12.387C271.328,85.318,276.876,79.771,283.715,79.771z\r
		 M246.561,79.771c6.839,0,12.381,5.547,12.381,12.387c0,6.842-5.542,12.387-12.381,12.387c-6.844,0-12.387-5.545-12.387-12.387\r
		C234.175,85.318,239.718,79.771,246.561,79.771z M21.27,314.01V141.424H358.73v67.274c-1.537-2.202-3.677-4.02-6.327-5.143\r
		l-20.614-8.726c-1.835-0.778-3.771-1.172-5.754-1.172c-5.956,0-11.303,3.54-13.623,9.02l-1.253,2.959\r
		c-9.227,0.129-18.381,2.255-26.728,6.193l-2.426-2.107c-1.174-1.018-2.499-1.841-3.932-2.447c-1.841-0.779-3.782-1.174-5.771-1.174\r
		c-4.276,0-8.341,1.858-11.154,5.099l-14.671,16.915c-2.583,2.986-3.855,6.794-3.581,10.735c0.285,3.941,2.084,7.535,5.064,10.115\r
		l2.417,2.098c-2.755,8.849-3.563,18.179-2.365,27.344l-2.749,1.654c-6.981,4.2-9.242,13.302-5.039,20.293L249.044,315H22.26\r
		C21.714,315,21.27,314.556,21.27,314.01z"/>\r
</g>\r
</svg>`, Hb = `<?xml version="1.0" encoding="iso-8859-1"?>\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg fill="#000000" height="800px" width="800px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" \r
	 viewBox="0 0 56 56" xml:space="preserve">\r
<g>\r
	<g>\r
		<path d="M47,5c-3.7,0-6.882,2.245-8.264,5.444L26.117,3.561c-1.749-0.954-4.483-0.956-6.228-0.004L3.153,12.686\r
			C1.385,13.65,0,15.987,0,18.007v19.984c0,2.02,1.385,4.356,3.153,5.321l16.737,9.129c0.872,0.476,1.992,0.714,3.111,0.714\r
			s2.238-0.238,3.11-0.714l16.736-9.129C44.615,42.349,46,40.014,46,37.998V22.941C46.329,22.977,46.662,23,47,23\r
			c4.962,0,9-4.037,9-9S51.962,5,47,5z M44,22.597v15.4c0,1.283-0.986,2.946-2.111,3.56l-16.736,9.129\r
			c-1.147,0.625-3.16,0.625-4.306,0L4.111,41.557C2.986,40.944,2,39.278,2,37.992V18.007c0-1.286,0.986-2.952,2.111-3.565\r
			l16.736-9.129c1.146-0.627,3.162-0.624,4.312,0.004l12.991,7.085C38.057,12.922,38,13.454,38,14c0,3.918,2.521,7.25,6.023,8.483\r
			C44.018,22.522,44,22.557,44,22.597z M47,21c-3.86,0-7-3.141-7-7s3.14-7,7-7s7,3.141,7,7S50.86,21,47,21z"/>\r
		<path d="M47,9c-1.654,0-3,1.346-3,3c0,0.771,0.3,1.468,0.78,2c-0.48,0.532-0.78,1.229-0.78,2c0,1.654,1.346,3,3,3s3-1.346,3-3\r
			c0-0.771-0.3-1.468-0.78-2c0.48-0.532,0.78-1.229,0.78-2C50,10.345,48.654,9,47,9z M47,11c0.551,0,1,0.448,1,1s-0.449,1-1,1\r
			s-1-0.448-1-1S46.449,11,47,11z M47,17c-0.551,0-1-0.448-1-1s0.449-1,1-1s1,0.448,1,1S47.551,17,47,17z"/>\r
		<path d="M23,30.374c0,1.665-1.636,3.126-3.5,3.126S16,32.039,16,30.374V21h-5v9.374c0,4.48,3.813,8.126,8.5,8.126\r
			s8.5-3.646,8.5-8.126V21h-5V30.374z M25,30.374V23h1v7.374c0,3.378-2.916,6.126-6.5,6.126S13,33.752,13,30.374V23h1v7.374\r
			c0,2.778,2.519,5.126,5.5,5.126S25,33.152,25,30.374z"/>\r
		<path d="M30,38h5V21h-5V38z M32,23h1v13h-1V23z"/>\r
	</g>\r
</g>\r
</svg>`, Ub = `<?xml version="1.0" encoding="utf-8"?>\r
\r
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg height="800px" width="800px" version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" \r
	 viewBox="0 0 512 512"  xml:space="preserve">\r
<style type="text/css">\r
	.st0{fill:#000000;}\r
</style>\r
<g>\r
	<path class="st0" d="M341.601,0H170.399c-29.292,0-53.121,23.828-53.121,53.121v405.756c0,29.292,23.83,53.123,53.121,53.123\r
		h171.202c29.292,0,53.121-23.83,53.121-53.119V53.121C394.722,23.828,370.893,0,341.601,0z M234.91,453.434\r
		c0-0.536,0.452-0.988,0.988-0.988H276.1c0.536,0,0.988,0.452,0.988,0.988v13.684c0,0.536-0.452,0.988-0.988,0.988h-40.202\r
		c-0.536,0-0.988-0.452-0.988-0.988V453.434z M277.088,429.684c0,0.536-0.452,0.988-0.988,0.988h-40.202\r
		c-0.536,0-0.988-0.452-0.988-0.988V416c0-0.534,0.452-0.984,0.988-0.984H276.1c0.536,0,0.988,0.45,0.988,0.984V429.684z\r
		 M277.088,392.25c0,0.545-0.443,0.988-0.988,0.988h-40.202c-0.546,0-0.988-0.442-0.988-0.988v-13.68\r
		c0-0.536,0.452-0.988,0.988-0.988H276.1c0.536,0,0.988,0.452,0.988,0.988V392.25z M255.999,351.476\r
		c-13.461,0-24.414-10.951-24.414-24.412c0-13.462,10.953-24.416,24.414-24.416c13.463,0,24.416,10.953,24.416,24.416\r
		C280.415,340.524,269.462,351.476,255.999,351.476z M170.397,36.304h171.202c10.004,0,18.142,8.137,18.142,18.144v225.136H152.257\r
		V54.449C152.257,44.441,160.395,36.304,170.397,36.304z M211.35,315.983v22.162h-43.742l-13.906-22.162H211.35z M203.025,429.684\r
		c0,0.536-0.452,0.988-0.986,0.988h-40.204c-0.534,0-0.986-0.452-0.986-0.988V416c0-0.542,0.443-0.984,0.986-0.984h40.204\r
		c0.544,0,0.986,0.443,0.986,0.984V429.684z M203.025,392.25c0,0.545-0.442,0.988-0.986,0.988h-40.204\r
		c-0.543,0-0.986-0.442-0.986-0.988v-13.68c0-0.536,0.452-0.988,0.986-0.988h40.204c0.534,0,0.986,0.452,0.986,0.988V392.25z\r
		 M160.849,467.118v-13.684c0-0.536,0.452-0.988,0.986-0.988h40.204c0.534,0,0.986,0.452,0.986,0.988v13.684\r
		c0,0.536-0.452,0.988-0.986,0.988h-40.204C161.302,468.106,160.849,467.654,160.849,467.118z M358.295,315.983l-13.905,22.162\r
		h-43.742v-22.162H358.295z M351.151,429.684c0,0.536-0.452,0.988-0.988,0.988h-40.202c-0.536,0-0.988-0.452-0.988-0.988V416\r
		c0-0.542,0.443-0.984,0.988-0.984h40.202c0.546,0,0.988,0.443,0.988,0.984V429.684z M351.151,392.25\r
		c0,0.545-0.442,0.988-0.988,0.988h-40.202c-0.545,0-0.988-0.442-0.988-0.988v-13.68c0-0.536,0.452-0.988,0.988-0.988h40.202\r
		c0.536,0,0.988,0.452,0.988,0.988V392.25z M308.973,467.118v-13.684c0-0.536,0.452-0.988,0.988-0.988h40.202\r
		c0.536,0,0.988,0.452,0.988,0.988v13.684c0,0.536-0.452,0.988-0.988,0.988h-40.202\r
		C309.425,468.106,308.973,467.654,308.973,467.118z"/>\r
</g>\r
</svg>`, Vb = `<?xml version="1.0" encoding="utf-8"?><!--\r
 // 16pxls (c) by Paul mackenzie <paul@whatspauldoing.com>\r
 //\r
 // 16pxls is licensed under a\r
 // Creative Commons Attribution-ShareAlike 4.0 International License.\r
 //\r
 // You should have received a copy of the license along with this\r
 // work. If not, see <http://creativecommons.org/licenses/by-sa/4.0/>.\r
-->\r
\r
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">\r
    <path d="M14 3.5L8.5 9 7 7.5 12.5 2H10V0h6v6h-2V3.5zM6 0v2H2v12h12v-4h2v6H0V0h6z" fill-rule="evenodd"/>\r
</svg>`, zb = `<?xml version="1.0" ?>
\r<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 512 512" version="1.1" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
\r<g id="_x32_1_x2C__Application_x2C__bookmark_x2C__browser_x2C__favourite_x2C__page">
\r<g id="XMLID_858_">
\r<g id="XMLID_55_">
\r<path d="M241,276H96c-2.761,0-5-2.238-5-5v-70c0-2.761,2.239-5,5-5h145c2.761,0,5,2.239,5,5v70     C246,273.762,243.761,276,241,276z M101,266h135v-60H101V266z" id="XMLID_421_"/>
\r</g>
\r<g id="XMLID_868_">
\r<g id="XMLID_869_">
\r<g id="XMLID_54_">
\r<path d="M406,391H96c-2.761,0-5-2.238-5-5V146c0-2.761,2.239-5,5-5h310c2.762,0,5,2.239,5,5v240       C411,388.762,408.762,391,406,391z M101,381h300V151H101V381z" id="XMLID_414_"/>
\r</g>
\r<g id="XMLID_870_">
\r<g id="XMLID_871_">
\r<g id="XMLID_872_">
\r<g id="XMLID_873_">
\r<g id="XMLID_874_">
\r<g id="XMLID_875_">
\r<g id="XMLID_876_">
\r<g id="XMLID_53_">
\r<path d="M456,151H56c-2.761,0-5-2.239-5-5s2.239-5,5-5h400c2.762,0,5,2.239,5,5S458.762,151,456,151z" id="XMLID_418_"/>
\r</g>
\r<g id="XMLID_52_">
\r<path d="M426.499,446H85.501C66.477,446,51,430.523,51,411.499V101              c0-19.024,15.477-34.501,34.501-34.501H426.5c19.023,0,34.5,15.477,34.5,34.5v310.5              C461,430.523,445.522,446,426.499,446z M85.501,76.499C71.991,76.499,61,87.49,61,101v310.499              C61,425.009,71.991,436,85.501,436h340.998c13.51,0,24.501-10.991,24.501-24.501v-310.5c0-13.509-10.99-24.5-24.5-24.5              H85.501z" id="XMLID_415_"/>
\r</g>
\r<g id="XMLID_51_">
\r<path d="M411,131c-11.028,0-20-8.972-20-20s8.972-20,20-20s20,8.972,20,20S422.028,131,411,131z               M411,101c-5.514,0-10,4.486-10,10s4.486,10,10,10s10-4.486,10-10S416.514,101,411,101z" id="XMLID_411_"/>
\r</g>
\r<g id="XMLID_50_">
\r<path d="M361,131c-11.028,0-20-8.972-20-20s8.972-20,20-20s20,8.972,20,20S372.028,131,361,131z               M361,101c-5.514,0-10,4.486-10,10s4.486,10,10,10s10-4.486,10-10S366.514,101,361,101z" id="XMLID_408_"/>
\r</g>
\r<g id="XMLID_49_">
\r<path d="M311,131c-11.028,0-20-8.972-20-20s8.972-20,20-20s20,8.972,20,20S322.028,131,311,131z               M311,101c-5.514,0-10,4.486-10,10s4.486,10,10,10s10-4.486,10-10S316.514,101,311,101z" id="XMLID_405_"/>
\r</g>
\r<g id="XMLID_48_">
\r<path d="M141,151c-2.761,0-5-2.239-5-5V71c0-2.761,2.239-5,5-5s5,2.239,5,5v75              C146,148.761,143.761,151,141,151z" id="XMLID_404_"/>
\r</g>
\r</g>
\r</g>
\r</g>
\r</g>
\r</g>
\r</g>
\r</g>
\r</g>
\r</g>
\r<g id="XMLID_859_">
\r<g id="XMLID_47_">
\r<path d="M336,391c-41.355,0-75-33.645-75-75s33.645-75,75-75s75,33.645,75,75S377.355,391,336,391z M336,251      c-35.841,0-65,29.159-65,65s29.159,65,65,65s65-29.159,65-65S371.841,251,336,251z" id="XMLID_401_"/>
\r</g>
\r<g id="XMLID_46_">
\r<path d="M363.726,359.161c-1.031,0-2.063-0.318-2.938-0.955L336,340.198l-24.787,18.008      c-1.752,1.273-4.125,1.273-5.877,0c-1.753-1.273-2.486-3.53-1.816-5.59l9.467-29.139L288.2,305.469      c-1.753-1.273-2.486-3.53-1.816-5.59c0.669-2.061,2.589-3.455,4.755-3.455h30.639l9.468-29.139      c0.669-2.061,2.589-3.455,4.755-3.455s4.086,1.395,4.755,3.455l9.468,29.139h30.639c2.166,0,4.086,1.395,4.755,3.455      c0.67,2.06-0.063,4.316-1.816,5.59l-24.786,18.009l9.467,29.139c0.67,2.06-0.063,4.316-1.816,5.59      C365.788,358.843,364.757,359.161,363.726,359.161z M336,329.018c1.031,0,2.063,0.318,2.938,0.955l15.277,11.099l-5.835-17.959      c-0.67-2.06,0.063-4.316,1.816-5.59l15.275-11.099H346.59c-2.166,0-4.086-1.395-4.755-3.455L336,285.011l-5.835,17.958      c-0.669,2.061-2.589,3.455-4.755,3.455h-18.883l15.275,11.099c1.753,1.273,2.486,3.53,1.816,5.59l-5.835,17.959l15.277-11.099      C333.938,329.336,334.969,329.018,336,329.018z" id="XMLID_395_"/>
\r</g>
\r</g>
\r</g>
\r</g>
\r<g id="Layer_1"/>
\r</svg>`, Gb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 32 32" id="icon" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <style>
      .cls-1 {
        fill: none;
      }
    </style>
  </defs>
  <path d="M8,30H2V24H8ZM4,28H6V26H4Z" transform="translate(0 0)"/>
  <path d="M19,30H13V24h6Zm-4-2h2V26H15Z" transform="translate(0 0)"/>
  <path d="M30,30H24V24h6Zm-4-2h2V26H26Z" transform="translate(0 0)"/>
  <path d="M16,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,10Zm0-6a2,2,0,1,0,2,2A2.002,2.002,0,0,0,16,4Z" transform="translate(0 0)"/>
  <path d="M26,16H21a4.0045,4.0045,0,0,1-4-4H15a4.0045,4.0045,0,0,1-4,4H6a2.0023,2.0023,0,0,0-2,2v4H6V18h5A5.9694,5.9694,0,0,0,15,16.46V22h2V16.46A5.9694,5.9694,0,0,0,21,18h5v4h2V18A2.0023,2.0023,0,0,0,26,16Z" transform="translate(0 0)"/>
  <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" class="cls-1" width="32" height="32"/>
</svg>`, jb = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 -1 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\r
    \r
    <title>network_3 [#1116]</title>\r
    <desc>Created with Sketch.</desc>\r
    <defs>\r
\r
</defs>\r
    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\r
        <g id="Dribbble-Light-Preview" transform="translate(-140.000000, -3280.000000)" fill="#000000">\r
            <g id="icons" transform="translate(56.000000, 160.000000)">\r
                <path d="M92,3124 L96,3124 L96,3120 L92,3120 L92,3124 Z M92,3138 L96,3138 L96,3134 L92,3134 L92,3138 Z M100,3138 L104,3138 L104,3134 L100,3134 L100,3138 Z M84,3138 L88,3138 L88,3134 L84,3134 L84,3138 Z M87,3132 L85,3132 L85,3128 L93,3128 L93,3126 L95,3126 L95,3128 L103,3128 L103,3132 L101,3132 L101,3130 L95,3130 L95,3132 L93,3132 L93,3130 L87,3130 L87,3132 Z" id="network_3-[#1116]">\r
\r
</path>\r
            </g>\r
        </g>\r
    </g>\r
</svg>`, Zb = `<?xml version="1.0" ?>
\r<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg width="800px" height="800px" viewBox="0 0 1000 1000" id="Layer_2" version="1.1" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
\r<g>
\r<path d="M152.09,182.23v58.88h695.82v-58.88c0-16.5-13.5-30-30-30H182.09   C165.59,152.23,152.09,165.73,152.09,182.23z M767,196.67c0-6.88,5.62-12.5,12.5-12.5h28.37c3.43,0,6.56,1.4,8.83,3.67   c2.26,2.27,3.67,5.39,3.67,8.83c0,6.87-5.63,12.5-12.5,12.5H779.5c-3.44,0-6.56-1.41-8.83-3.67C768.4,203.23,767,200.11,767,196.67   z M690.33,196.67c0-6.88,5.63-12.5,12.5-12.5h28.37c3.44,0,6.56,1.4,8.83,3.67c2.27,2.27,3.67,5.39,3.67,8.83   c0,6.87-5.62,12.5-12.5,12.5h-28.37c-3.43,0-6.56-1.41-8.83-3.67C691.74,203.23,690.33,200.11,690.33,196.67z M613.67,196.67   c0-6.88,5.62-12.5,12.5-12.5h28.37c3.44,0,6.56,1.4,8.83,3.67c2.26,2.27,3.67,5.39,3.67,8.83c0,6.87-5.63,12.5-12.5,12.5h-28.37   c-3.44,0-6.57-1.41-8.83-3.67C615.08,203.23,613.67,200.11,613.67,196.67z" style="fill:#231F20;"/>
\r<path d="M495.51,575.63c-84.49,0-152.99,18.06-152.99,40.33c0,0.39,0.03,0.77,0.07,1.16h-0.07v73.49   c0,22.28,68.5,40.34,152.99,40.34c84.5,0,153-18.06,153-40.34v-73.49h-0.07c0.04-0.39,0.07-0.77,0.07-1.16   C648.51,593.69,580.01,575.63,495.51,575.63z M382.25,678.29c-6.9,0-12.5-5.6-12.5-12.5c0-6.91,5.6-12.5,12.5-12.5   s12.5,5.59,12.5,12.5C394.75,672.69,389.15,678.29,382.25,678.29z" style="fill:#231F20;"/>
\r<path d="M647.74,728.72c-9.62,5.63-22.28,10.53-37.67,14.59c-30.92,8.15-71.6,12.64-114.56,12.64   c-42.95,0-83.63-4.49-114.55-12.64c-15.4-4.06-28.06-8.96-37.67-14.59c-0.51,1.34-0.77,2.69-0.77,4.07c0,0.38,0.03,0.77,0.07,1.15   h-0.07v73.5c0,22.27,68.5,40.33,152.99,40.33c84.5,0,153-18.06,153-40.33v-73.5h-0.07c0.04-0.38,0.07-0.77,0.07-1.15   C648.51,731.41,648.25,730.06,647.74,728.72z M382.25,800.74c-6.9,0-12.5-5.6-12.5-12.5c0-6.9,5.6-12.5,12.5-12.5   s12.5,5.6,12.5,12.5C394.75,795.14,389.15,800.74,382.25,800.74z" style="fill:#231F20;"/>
\r<path d="M495.51,345.96c-43.65,0-79.16,35.51-79.16,79.16c0,43.66,35.51,79.17,79.16,79.17   c43.6,0,79.07-35.42,79.17-78.99c0-0.06-0.01-0.12-0.01-0.18s0.01-0.12,0.01-0.18C574.58,381.37,539.11,345.96,495.51,345.96z    M540.19,456.08c-2.42,3.5-6.32,5.38-10.28,5.38c-2.46,0-4.94-0.72-7.11-2.22l-34.41-23.84c-3.37-2.34-5.38-6.18-5.38-10.28v-44.33   c0-6.9,5.6-12.5,12.5-12.5c6.91,0,12.5,5.6,12.5,12.5v37.79l29.03,20.11C542.71,442.62,544.13,450.41,540.19,456.08z" style="fill:#231F20;"/>
\r<path d="M152.09,630.6c0,16.5,13.5,30,30,30h135.43v-43.48c0-0.18,0-0.36,0.01-0.54   c-0.01-0.2-0.01-0.41-0.01-0.62c0-10.07,4.13-24.65,23.8-36.91c9.83-6.13,23.17-11.44,39.64-15.78   c27.9-7.36,63.76-11.73,102.05-12.51v-22.22c-47.46-5.71-85.21-43.45-90.91-90.92h-13.92c-6.9,0-12.5-5.59-12.5-12.5   c0-6.9,5.6-12.5,12.5-12.5h13.92c5.7-47.46,43.45-85.21,90.91-90.91v-13.92c0-6.9,5.6-12.5,12.5-12.5c6.91,0,12.5,5.6,12.5,12.5   v13.92c47.47,5.7,85.22,43.45,90.92,90.91h13.9c6.91,0,12.5,5.6,12.5,12.5c0,6.91-5.59,12.5-12.5,12.5h-13.9   c-5.7,47.47-43.45,85.21-90.92,90.92v22.22c38.3,0.78,74.16,5.15,102.06,12.51c16.47,4.34,29.81,9.65,39.64,15.78   c19.67,12.26,23.8,26.84,23.8,36.91c0,0.2,0,0.41-0.01,0.62c0.01,0.18,0.01,0.36,0.01,0.54v43.48h144.4c16.5,0,30-13.5,30-30   V266.11H152.09V630.6z M737.73,571.96c-2.27,2.26-5.39,3.67-8.83,3.67h-36.95c-6.88,0-12.5-5.63-12.5-12.5   c0-3.44,1.41-6.56,3.67-8.83c2.26-2.27,5.39-3.67,8.83-3.67h36.95c6.87,0,12.5,5.62,12.5,12.5   C741.4,566.57,739.99,569.69,737.73,571.96z M737.73,368.29c-2.27,2.26-5.39,3.67-8.83,3.67h-36.95c-6.88,0-12.5-5.63-12.5-12.5   c0-3.44,1.41-6.57,3.67-8.83c2.26-2.26,5.39-3.67,8.83-3.67h36.95c6.87,0,12.5,5.62,12.5,12.5   C741.4,362.89,739.99,366.02,737.73,368.29z M762,301.03c2.26-2.26,5.39-3.67,8.83-3.67h32.74c6.87,0,12.5,5.63,12.5,12.5   c0,3.44-1.41,6.57-3.67,8.83c-2.27,2.26-5.4,3.67-8.83,3.67h-32.74c-6.88,0-12.5-5.62-12.5-12.5   C758.33,306.43,759.74,303.3,762,301.03z M762,350.63c2.26-2.26,5.39-3.67,8.83-3.67h32.74c6.87,0,12.5,5.62,12.5,12.5   c0,3.43-1.41,6.56-3.67,8.83c-2.27,2.26-5.4,3.67-8.83,3.67h-32.74c-6.88,0-12.5-5.63-12.5-12.5   C758.33,356.02,759.74,352.89,762,350.63z M762,554.3c2.26-2.27,5.39-3.67,8.83-3.67h32.74c6.87,0,12.5,5.62,12.5,12.5   c0,3.44-1.41,6.56-3.67,8.83c-2.27,2.26-5.4,3.67-8.83,3.67h-32.74c-6.88,0-12.5-5.63-12.5-12.5   C758.33,559.69,759.74,556.57,762,554.3z M621.17,301.03c2.27-2.26,5.39-3.67,8.83-3.67h98.9c6.87,0,12.5,5.63,12.5,12.5   c0,3.44-1.41,6.57-3.67,8.83c-2.27,2.26-5.39,3.67-8.83,3.67H630c-6.88,0-12.5-5.62-12.5-12.5   C617.5,306.43,618.9,303.3,621.17,301.03z M253.29,301.03c2.27-2.26,5.39-3.67,8.83-3.67h98.9c6.88,0,12.5,5.63,12.5,12.5   c0,3.44-1.4,6.57-3.67,8.83s-5.39,3.67-8.83,3.67h-98.9c-6.87,0-12.5-5.62-12.5-12.5C249.62,306.43,251.03,303.3,253.29,301.03z    M253.29,350.63c2.27-2.26,5.39-3.67,8.83-3.67h36.95c6.88,0,12.5,5.62,12.5,12.5c0,3.43-1.41,6.56-3.67,8.83   c-2.26,2.26-5.39,3.67-8.83,3.67h-36.95c-6.87,0-12.5-5.63-12.5-12.5C249.62,356.02,251.03,352.89,253.29,350.63z M253.29,554.3   c2.27-2.27,5.39-3.67,8.83-3.67h36.95c6.88,0,12.5,5.62,12.5,12.5c0,3.44-1.41,6.56-3.67,8.83c-2.26,2.26-5.39,3.67-8.83,3.67   h-36.95c-6.87,0-12.5-5.63-12.5-12.5C249.62,559.69,251.03,556.57,253.29,554.3z M178.63,301.03c2.27-2.26,5.39-3.67,8.83-3.67   h32.73c6.88,0,12.5,5.63,12.5,12.5c0,3.44-1.41,6.57-3.67,8.83c-2.26,2.26-5.39,3.67-8.83,3.67h-32.73c-6.88,0-12.5-5.62-12.5-12.5   C174.96,306.43,176.36,303.3,178.63,301.03z M178.63,350.63c2.27-2.26,5.39-3.67,8.83-3.67h32.73c6.88,0,12.5,5.62,12.5,12.5   c0,3.43-1.41,6.56-3.67,8.83c-2.26,2.26-5.39,3.67-8.83,3.67h-32.73c-6.88,0-12.5-5.63-12.5-12.5   C174.96,356.02,176.36,352.89,178.63,350.63z M178.63,554.3c2.27-2.27,5.39-3.67,8.83-3.67h32.73c6.88,0,12.5,5.62,12.5,12.5   c0,3.44-1.41,6.56-3.67,8.83c-2.26,2.26-5.39,3.67-8.83,3.67h-32.73c-6.88,0-12.5-5.63-12.5-12.5   C174.96,559.69,176.36,556.57,178.63,554.3z" style="fill:#231F20;"/>
\r</g>
\r</svg>`, Wb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" height="800px" width="800px" id="Layer_1" data-name="Layer 1"\r
    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">\r
    <path class="cls-1" d="M8,2a6,6,0,1,0,6,6A6,6,0,0,0,8,2Zm4.08905,2.52631h-1.868A5.59977,5.59977,0,0,0,9.36719,2.814,5.3637,5.3637,0,0,1,12.08905,4.52631ZM9.36719,13.186a5.5999,5.5999,0,0,0,.85388-1.71228h1.868A5.36312,5.36312,0,0,1,9.36719,13.186Zm3.18127-2.34387H10.402a10.65713,10.65713,0,0,0,.20782-1.1867l-.68676.3435c-.05.29419-.10639.57959-.17566.8432H8.23712l-1.26275.63159H9.55743C9.14484,12.6474,8.55414,13.36841,8,13.36841c-.51727,0-1.06445-.63373-1.47089-1.67206l-.56005.28015A5.01956,5.01956,0,0,0,6.63281,13.186,5.363,5.363,0,0,1,3.911,11.47369h.31671a.96008.96008,0,0,1-.01715-.17022V10.8421h-.759a5.32985,5.32985,0,0,1-.80408-2.5263h1.563V7.6842h-1.563A5.32943,5.32943,0,0,1,3.4516,5.1579h.759V4.69043a.95019.95019,0,0,1,.0166-.16412H3.911A5.36353,5.36353,0,0,1,6.63281,2.814,5.01929,5.01929,0,0,0,5.97,4.02106L6.53,4.30145c.40631-1.037.95312-1.66986,1.47-1.66986.55414,0,1.14484.72095,1.55743,1.89472H6.97913l1.26141.63159h1.5069c.06921.2633.12555.5484.17553.84234l.68683.34394A10.64628,10.64628,0,0,0,10.402,5.1579h2.14642a5.33,5.33,0,0,1,.804,2.5263h-.67127a.91929.91929,0,0,1-.00055.6316h.67182A5.33045,5.33045,0,0,1,12.54846,10.8421ZM11.929,7.71088,5.3338,4.40881a.32738.32738,0,0,0-.49164.28156v6.6131a.32677.32677,0,0,0,.32685.32794l.14831-.03516L11.915,8.29639a.32563.32563,0,0,0,.014-.58551ZM5.84229,10.21576V5.78021l4.43164,2.21973Z"/>\r
</svg>`, qb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 32 32" id="icon" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <style>
      .cls-1 {
        fill: none;
      }
    </style>
  </defs>
  <path d="M28,28H4a2.0021,2.0021,0,0,1-2-2V21H4v5H28V21h2v5A2.0021,2.0021,0,0,1,28,28Z" transform="translate(0 0)"/>
  <rect x="7" y="21" width="18" height="2"/>
  <rect x="7" y="16" width="18" height="2"/>
  <rect x="7" y="11" width="18" height="2"/>
  <rect x="7" y="6" width="18" height="2"/>
  <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" class="cls-1" width="32" height="32"/>
</svg>`, Kb = `<?xml version="1.0" encoding="utf-8"?>\r
\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" height="800px" width="800px" version="1.1" id="Icons" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" \r
	 viewBox="0 0 32 32" xml:space="preserve">\r
<path d="M13,23c0-1.4,0.3-2.8,0.9-4c-0.2,0-0.4-0.1-0.5-0.2l-1.6-1.4l-5.1,4.4C6.5,21.9,6.2,22,6,22c-0.3,0-0.6-0.1-0.8-0.3\r
	c-0.4-0.4-0.3-1,0.1-1.4l4.9-4.2l-4.9-4.2c-0.4-0.4-0.5-1-0.1-1.4c0.4-0.4,1-0.5,1.4-0.1l7.3,6.4l7.3-6.4c0.4-0.4,1-0.3,1.4,0.1\r
	c0.4,0.4,0.3,1-0.1,1.4L21,13.2c0.6-0.1,1.3-0.2,2-0.2c1.4,0,2.8,0.3,4,0.8V9c0-1.7-1.3-3-3-3H4C2.3,6,1,7.3,1,9v14c0,1.7,1.3,3,3,3\r
	h9.5C13.2,25.1,13,24,13,23z"/>\r
<path d="M28.7,17.3c-3.1-3.1-8.2-3.1-11.3,0s-3.1,8.2,0,11.3s8.2,3.1,11.3,0S31.8,20.5,28.7,17.3z M26,24h-3c-0.6,0-1-0.4-1-1v-4\r
	c0-0.6,0.4-1,1-1s1,0.4,1,1v3h2c0.6,0,1,0.4,1,1S26.6,24,26,24z"/>\r
</svg>`, Yb = `<?xml version="1.0" encoding="iso-8859-1"?>\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\r
<svg fill="#000000" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" \r
	 width="800px" height="800px" viewBox="0 0 493.862 493.862"\r
	 xml:space="preserve">\r
<g>\r
	<path d="M491.618,241.409h-4.588v-13.946h4.588c0.006,0.001,0.012,0.001,0.016,0c1.229,0,2.229-0.998,2.229-2.229\r
		c0-0.479-0.15-0.923-0.408-1.287l-6.702-12.064c-0.394-0.707-1.14-1.146-1.948-1.146H328.899v-34.123\r
		c0-0.025-0.007-0.047-0.008-0.072c1.609-1.525,2.62-3.676,2.62-6.063c0-2.387-1.011-4.538-2.62-6.063\r
		c0.001-0.024,0.008-0.047,0.008-0.072v-36.352c0-7.556-5.594-18.429-13.632-20.337V98.91c0-1.23-0.998-2.229-2.229-2.229\r
		c-1.231,0-2.229,0.998-2.229,2.229v8.641c-8.415,1.565-13.873,12.813-13.873,20.442c0,0.357,0.092,0.689,0.241,0.988v21.774\r
		h-47.906V104.25c0-1.231-0.997-2.229-2.228-2.229s-2.229,0.998-2.229,2.229v46.505h-48.146v-22.763\r
		c0-7.554-5.354-18.659-13.632-20.393v-8.69c0-1.23-0.998-2.229-2.229-2.229s-2.229,0.998-2.229,2.229v8.69\r
		c-8.278,1.734-13.632,12.838-13.632,20.393v36.352c0,0.025,0.006,0.047,0.007,0.071c-1.61,1.525-2.621,3.676-2.621,6.063\r
		c0,2.387,1.011,4.539,2.621,6.063c-0.001,0.024-0.007,0.046-0.007,0.071v34.123H9.044c-0.81,0-1.555,0.439-1.948,1.146\r
		l-6.816,12.271c-0.383,0.691-0.373,1.532,0.027,2.213s1.131,1.098,1.921,1.098h4.587v13.946H2.229c-0.79,0-1.521,0.417-1.921,1.098\r
		c-0.4,0.681-0.411,1.523-0.027,2.213l6.535,11.765v138.47c0,1.229,0.998,2.229,2.229,2.229h65.774c1.231,0,2.229-0.998,2.229-2.229\r
		v-44.306c0-2.388,0.761-4.669,2.202-6.599c0.505-0.679,0.584-1.583,0.204-2.337c-0.692-1.373-1.043-2.838-1.043-4.355\r
		c0-3.576,5.496-9.168,9.7-12.525c4.203,3.357,9.699,8.949,9.699,12.525c0,1.518-0.351,2.982-1.043,4.355\r
		c-0.38,0.754-0.301,1.658,0.204,2.337c1.441,1.93,2.203,4.211,2.203,6.599v44.306c0,1.229,0.998,2.229,2.229,2.229h65.774h27.265\r
		h28.719c1.231,0,2.229-0.998,2.229-2.229v-70.115c0-11.941,9.715-21.656,21.656-21.656c11.939,0,21.654,9.715,21.654,21.656v70.115\r
		c0,1.229,0.998,2.229,2.229,2.229h28.479h27.264h65.773c1.231,0,2.229-0.998,2.229-2.229v-44.306c0-2.388,0.763-4.669,2.203-6.599\r
		c0.506-0.679,0.584-1.583,0.204-2.337c-0.692-1.373-1.044-2.838-1.044-4.355c0-3.576,5.497-9.168,9.699-12.525\r
		c4.203,3.357,9.699,8.949,9.699,12.525c0,1.518-0.352,2.982-1.044,4.355c-0.381,0.754-0.302,1.658,0.204,2.337\r
		c1.44,1.93,2.202,4.211,2.202,6.599v44.306c0,1.229,0.998,2.229,2.229,2.229h65.774c1.231,0,2.229-0.998,2.229-2.229v-138.47\r
		l6.534-11.765c0.384-0.69,0.374-1.532-0.025-2.213C493.141,241.826,492.407,241.409,491.618,241.409z M482.573,241.409H329.14\r
		v-13.946h153.434V241.409z M280.846,241.409v-26.215h6.107v26.215H280.846z M270.281,241.409v-26.215h6.107v26.215H270.281z\r
		 M259.717,241.409v-26.215h6.105v26.215H259.717z M249.151,241.409v-26.215h6.107v26.215H249.151z M238.588,241.409v-26.215h6.107\r
		v26.215H238.588z M228.022,241.409v-26.215h6.108v26.215H228.022z M217.458,241.409v-26.215h6.107v26.215H217.458z\r
		 M206.893,241.409v-26.215H213v26.215H206.893z M196.997,241.409c-0.614-4.735-3.073-10.206-6.737-13.946h0.659\r
		c4.612,0,8.363-3.751,8.363-8.363c0-1.41-0.354-2.739-0.974-3.905h4.127v26.215L196.997,241.409L196.997,241.409z M166.792,170.479\r
		c0-2.154,1.752-3.906,3.906-3.906h20.221c2.154,0,3.906,1.752,3.906,3.906c0,2.154-1.752,3.906-3.906,3.906h-20.221\r
		C168.543,174.385,166.792,172.633,166.792,170.479z M196.669,178.843h100.509v31.895H196.669V178.843z M327.054,170.479\r
		c0,2.154-1.752,3.906-3.905,3.906h-20.221c-2.154,0-3.906-1.752-3.906-3.906c0-2.154,1.752-3.906,3.906-3.906h20.221\r
		C325.302,166.574,327.054,168.326,327.054,170.479z M302.928,215.193h20.221c2.153,0,3.905,1.752,3.905,3.905\r
		c0,2.154-1.752,3.906-3.905,3.906h-20.221c-2.154,0-3.906-1.752-3.906-3.906C299.021,216.947,300.773,215.193,302.928,215.193z\r
		 M323.148,227.463h1.293v2.633c-0.671-0.942-1.403-1.827-2.192-2.633H323.148z M312.797,227.463\r
		c5.298,0,10.489,7.198,11.645,13.639v0.307h-1.293h-20.221h-1.362C302.537,234.8,307.526,227.463,312.797,227.463z\r
		 M192.504,241.409h-1.586h-20.221h-1.121c0.97-6.609,5.96-13.946,11.231-13.946C186.19,227.463,191.462,234.892,192.504,241.409z\r
		 M170.698,223.006c-2.154,0-3.906-1.752-3.906-3.906c0-2.153,1.752-3.905,3.906-3.905h20.221c2.154,0,3.906,1.752,3.906,3.905\r
		c0,2.154-1.752,3.906-3.906,3.906H170.698z M170.698,227.463h0.815c-0.762,0.806-1.465,1.691-2.107,2.632v-2.632H170.698z\r
		 M166.792,249.771c0-2.152,1.752-3.906,3.906-3.906h20.221c2.154,0,3.906,1.751,3.906,3.906s-1.752,3.905-3.906,3.905h-20.221\r
		C168.543,253.677,166.792,251.925,166.792,249.771z M291.411,215.193h4.128c-0.62,1.167-0.975,2.495-0.975,3.905\r
		c0,4.612,3.751,8.363,8.363,8.363h0.573c-3.549,3.751-5.847,9.24-6.42,13.946h-5.672v-26.214H291.411z M299.021,249.771\r
		c0-2.152,1.752-3.906,3.906-3.906h20.221c2.153,0,3.905,1.751,3.905,3.906s-1.752,3.905-3.905,3.905h-20.221\r
		C300.773,253.677,299.021,251.925,299.021,249.771z M487.831,223.006h-3.028H330.539c0.618-1.167,0.974-2.495,0.974-3.906\r
		c0-1.41-0.354-2.739-0.974-3.905H483.49L487.831,223.006z M324.441,178.843v31.895h-1.293h-20.221h-1.293v-31.895h1.293h20.221\r
		H324.441z M302.928,162.116h-1.293v-31.894h22.807v31.895h-1.293L302.928,162.116L302.928,162.116z M312.797,111.817\r
		c5.271,0,10.438,7.429,11.46,13.946h-22.691C302.537,119.155,307.526,111.817,312.797,111.817z M296.937,155.213v9.443\r
		c-1.466,1.507-2.372,3.56-2.372,5.823c0,1.41,0.354,2.739,0.975,3.906h-97.23c0.62-1.167,0.974-2.496,0.974-3.906\r
		c0-2.384-1.007-4.532-2.612-6.056v-0.079v-9.131H296.937z M180.808,111.817c5.271,0,10.261,7.337,11.231,13.946h-22.462\r
		C170.547,119.155,175.538,111.817,180.808,111.817z M169.405,162.116v-31.894h22.807v22.763v9.132h-1.293h-20.221L169.405,162.116\r
		L169.405,162.116z M190.918,178.843h1.293v31.895h-1.293h-18.971h-1.25h-1.292v-31.895h1.292H190.918z M10.355,215.193h152.952\r
		c-0.619,1.167-0.974,2.495-0.974,3.905c0,1.411,0.354,2.74,0.974,3.906H9.044H6.017L10.355,215.193z M11.273,227.463h153.674\r
		v13.946H11.273V227.463z M9.044,245.866h154.263c-0.619,1.167-0.974,2.496-0.974,3.906c0,1.411,0.354,2.739,0.974,3.905H10.355\r
		l-4.339-7.811H9.044z M101.298,342.488c0.644-1.639,0.969-3.358,0.969-5.131c0-7.5-11.524-16.169-12.839-17.133\r
		c-0.784-0.576-1.851-0.576-2.635,0c-1.314,0.964-12.839,9.633-12.839,17.133c0,1.771,0.325,3.492,0.969,5.131\r
		c-1.53,2.456-2.333,5.251-2.333,8.16v42.076H11.273v-134.59h153.674v134.59h-61.317v-42.076\r
		C103.63,347.739,102.828,344.944,101.298,342.488z M169.405,392.725v-134.59h1.292h20.221h1.293v134.59H169.405z M247.043,298.725\r
		c-14.398,0-26.113,11.714-26.113,26.113v67.887h-24.262V255.906c0-0.023-0.006-0.048-0.007-0.07c1.609-1.525,2.62-3.676,2.62-6.063\r
		c0-1.409-0.354-2.737-0.974-3.906h97.23c-0.62,1.167-0.975,2.497-0.975,3.906c0,2.388,1.011,4.539,2.62,6.063\r
		c-0.001,0.023-0.007,0.047-0.007,0.07v136.818h-24.021v-67.887C273.156,310.438,261.441,298.725,247.043,298.725z M301.635,258.135\r
		h1.293h20.221h1.293v134.59h-22.807V258.135z M482.573,392.725h-61.316v-42.076c0-2.909-0.803-5.704-2.333-8.16\r
		c0.644-1.639,0.97-3.358,0.97-5.131c0-7.5-11.523-16.169-12.838-17.133c-0.785-0.576-1.852-0.576-2.637,0\r
		c-1.313,0.964-12.839,9.633-12.839,17.133c0,1.771,0.325,3.492,0.97,5.131c-1.53,2.456-2.333,5.251-2.333,8.16v42.076H328.9\r
		v-134.59h153.674L482.573,392.725L482.573,392.725z M483.49,253.677H330.539c0.618-1.166,0.974-2.494,0.974-3.905\r
		c0-1.41-0.354-2.738-0.974-3.906h154.264h3.028L483.49,253.677z"/>\r
</g>\r
</svg>`, Xb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\r
<path fill-rule="evenodd" clip-rule="evenodd" d="M10 5C8.34315 5 7 6.34315 7 8C7 9.65685 8.34315 11 10 11C11.6569 11 13 9.65685 13 8C13 6.34315 11.6569 5 10 5ZM13.5058 11.565C14.4281 10.6579 15 9.39576 15 8C15 5.23858 12.7614 3 10 3C7.23858 3 5 5.23858 5 8C5 9.39827 5.57396 10.6625 6.49914 11.5699C3.74942 12.5366 2 14.6259 2 17C2 17.5523 2.44772 18 3 18C3.55228 18 4 17.5523 4 17C4 15.2701 5.93073 13 10 13C12.6152 13 14.4051 13.9719 15.2988 15.1157C15.6389 15.5509 16.2673 15.628 16.7025 15.288C17.1377 14.9479 17.2148 14.3195 16.8748 13.8843C16.0904 12.8804 14.9401 12.0686 13.5058 11.565ZM22.6139 15.2106C23.0499 15.5497 23.1284 16.178 22.7894 16.6139L18.1227 22.6139C17.9485 22.8379 17.6875 22.9773 17.4045 22.9975C17.1216 23.0177 16.8434 22.9167 16.6392 22.7198L14.3059 20.4698C13.9083 20.0865 13.8968 19.4534 14.2802 19.0559C14.6635 18.6583 15.2966 18.6468 15.6941 19.0302L17.2268 20.5081L21.2106 15.3861C21.5497 14.9501 22.178 14.8716 22.6139 15.2106Z" fill="#000000"/>\r
</svg>`, Qb = `<?xml version="1.0" encoding="utf-8"?>\r
\r
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" \r
	 width="800px" height="800px" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve">\r
<path d="M256,0C114.609,0,0,114.609,0,256s114.609,256,256,256s256-114.609,256-256S397.391,0,256,0z M256,472\r
	c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"/>\r
<path d="M256,176H128v160h128h128V176H256z M256,192h89.719L256,255.75L166.281,192H256z M144,196.531l54.5,36.859L144,292.812\r
	V196.531z M256,320h-92.406l45.562-79.422L256,272.25l46.844-31.672L348.406,320H256z M368,292.812l-54.5-59.422l54.5-36.859\r
	V292.812z"/>\r
</svg>`, Jb = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">\r
  <title>github</title>\r
  <rect width="24" height="24" fill="none"/>\r
  <path d="M12,2A10,10,0,0,0,8.84,21.5c.5.08.66-.23.66-.5V19.31C6.73,19.91,6.14,18,6.14,18A2.69,2.69,0,0,0,5,16.5c-.91-.62.07-.6.07-.6a2.1,2.1,0,0,1,1.53,1,2.15,2.15,0,0,0,2.91.83,2.16,2.16,0,0,1,.63-1.34C8,16.17,5.62,15.31,5.62,11.5a3.87,3.87,0,0,1,1-2.71,3.58,3.58,0,0,1,.1-2.64s.84-.27,2.75,1a9.63,9.63,0,0,1,5,0c1.91-1.29,2.75-1,2.75-1a3.58,3.58,0,0,1,.1,2.64,3.87,3.87,0,0,1,1,2.71c0,3.82-2.34,4.66-4.57,4.91a2.39,2.39,0,0,1,.69,1.85V21c0,.27.16.59.67.5A10,10,0,0,0,12,2Z"/>\r
</svg>`, ew = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg width="800px" height="800px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="none"><path fill="#000000" d="M12.342 4.536l.15-.227.262.159.116.083c.28.216.869.768.996 1.684.223-.04.448-.06.673-.06.534 0 .893.124 1.097.227l.105.057.068.045.191.156-.066.2a2.044 2.044 0 01-.47.73c-.29.299-.8.652-1.609.698l-.178.005h-.148c-.37.977-.867 2.078-1.702 3.066a7.081 7.081 0 01-1.74 1.488 7.941 7.941 0 01-2.549.968c-.644.125-1.298.187-1.953.185-1.45 0-2.73-.288-3.517-.792-.703-.449-1.243-1.182-1.606-2.177a8.25 8.25 0 01-.461-2.83.516.516 0 01.432-.516l.068-.005h10.54l.092-.007.149-.016c.256-.034.646-.11.92-.27-.328-.543-.421-1.178-.268-1.854a3.3 3.3 0 01.3-.81l.108-.187zM2.89 5.784l.04.007a.127.127 0 01.077.082l.006.04v1.315l-.006.041a.127.127 0 01-.078.082l-.039.006H1.478a.124.124 0 01-.117-.088l-.007-.04V5.912l.007-.04a.127.127 0 01.078-.083l.039-.006H2.89zm1.947 0l.039.007a.127.127 0 01.078.082l.006.04v1.315l-.007.041a.127.127 0 01-.078.082l-.039.006H3.424a.125.125 0 01-.117-.088L3.3 7.23V5.913a.13.13 0 01.085-.123l.039-.007h1.413zm1.976 0l.039.007a.127.127 0 01.077.082l.007.04v1.315l-.007.041a.127.127 0 01-.078.082l-.039.006H5.4a.124.124 0 01-.117-.088l-.006-.04V5.912l.006-.04a.127.127 0 01.078-.083l.039-.006h1.413zm1.952 0l.039.007a.127.127 0 01.078.082l.007.04v1.315a.13.13 0 01-.085.123l-.04.006H7.353a.124.124 0 01-.117-.088l-.006-.04V5.912l.006-.04a.127.127 0 01.078-.083l.04-.006h1.412zm1.97 0l.039.007a.127.127 0 01.078.082l.006.04v1.315a.13.13 0 01-.085.123l-.039.006H9.322a.124.124 0 01-.117-.088l-.006-.04V5.912l.006-.04a.127.127 0 01.078-.083l.04-.006h1.411zM4.835 3.892l.04.007a.127.127 0 01.077.081l.007.041v1.315a.13.13 0 01-.085.123l-.039.007H3.424a.125.125 0 01-.117-.09l-.007-.04V4.021a.13.13 0 01.085-.122l.039-.007h1.412zm1.976 0l.04.007a.127.127 0 01.077.081l.007.041v1.315a.13.13 0 01-.085.123l-.039.007H5.4a.125.125 0 01-.117-.09l-.006-.04V4.021l.006-.04a.127.127 0 01.078-.082l.039-.007h1.412zm1.953 0c.054 0 .1.037.117.088l.007.041v1.315a.13.13 0 01-.085.123l-.04.007H7.353a.125.125 0 01-.117-.09l-.006-.04V4.021l.006-.04a.127.127 0 01.078-.082l.04-.007h1.412zm0-1.892c.054 0 .1.037.117.088l.007.04v1.316a.13.13 0 01-.085.123l-.04.006H7.353a.124.124 0 01-.117-.088l-.006-.04V2.128l.006-.04a.127.127 0 01.078-.082L7.353 2h1.412z"/></svg>`, tw = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->\r
<svg width="800px" height="800px" viewBox="0 0 48 48" id="Layer_2" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg"><defs><style>.cls-1{fill:none;stroke:#000000;stroke-linecap:round;stroke-linejoin:round;}</style></defs><path id="path50" class="cls-1" d="M24,42h0l7.18-22.1H16.82L24,42Z"/><path id="path66" class="cls-1" d="M6.76,19.86h0L4.57,26.57a1.5,1.5,0,0,0,.54,1.67L24,42,6.76,19.86Z"/><path id="path74" class="cls-1" d="M6.76,19.86H16.82L12.49,6.55a.74.74,0,0,0-1.41,0L6.76,19.86Z"/><path id="path82" class="cls-1" d="M41.25,19.86h0l2.18,6.71a1.5,1.5,0,0,1-.54,1.67L24,42l17.25-22.1Z"/><path id="path86" class="cls-1" d="M41.25,19.86H31.18L35.51,6.55a.74.74,0,0,1,1.41,0l4.33,13.31Z"/><polygon class="cls-1" points="24 41.96 31.18 19.86 41.25 19.86 24 41.96"/><polygon class="cls-1" points="24 41.96 6.76 19.86 16.82 19.86 24 41.96"/></svg>`, nw = `<?xml version="1.0" encoding="utf-8"?>

<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg width="800px" height="800px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
<path fill="#444444" d="M16.392 2.991c-0.627 0.053-1.097 0.14-1.539 0.283-0.27 0.088-0.859 0.311-1.073 0.406-0.173 0.076-0.928 0.491-1.406 0.77-0.834 0.488-1.265 0.952-1.466 1.582-0.040 0.123-0.057 0.153-0.097 0.175-0.198 0.108-0.386 0.276-0.513 0.459-0.195 0.285-0.335 0.726-0.379 1.198-0.010 0.11-0.023 0.238-0.027 0.286l-0.008 0.086-0.195 0.171c-0.536 0.473-1.11 1.118-1.534 1.727-0.879 1.261-1.469 2.767-1.679 4.277-0.075 0.544-0.092 0.8-0.092 1.423s0.017 0.878 0.092 1.423c0.136 0.985 0.453 2.018 0.897 2.94 0.521 1.080 1.288 2.118 2.147 2.909l0.245 0.225 0.020 0.313c0.012 0.171 0.028 0.517 0.035 0.769 0.018 0.582 0.042 0.682 0.186 0.805 0.083 0.071 0.216 0.136 0.488 0.238 0.11 0.042 0.458 0.201 0.774 0.354 0.802 0.391 1.062 0.496 1.461 0.592 0.28 0.068 0.344 0.076 0.709 0.088l0.349 0.010 0.113 0.391c0.205 0.699 0.376 1.266 0.471 1.556 0.118 0.358 0.273 0.777 0.298 0.8 0.025 0.027 0.271 0.1 0.529 0.158 0.93 0.21 2.38 0.238 3.766 0.072 0.469-0.057 0.792-0.233 0.907-0.494 0.030-0.067 0.032-0.090 0.017-0.19-0.008-0.062-0.022-0.208-0.027-0.323l-0.012-0.21 0.148-0.028c0.484-0.093 0.726-0.22 0.832-0.436 0.035-0.073 0.045-0.121 0.052-0.261 0.012-0.215-0.008-0.353-0.113-0.819-0.142-0.614-0.17-0.847-0.133-1.068l0.021-0.12 0.105-0.035c0.225-0.075 0.325-0.186 0.325-0.364v-0.086l0.105-0.048c0.25-0.113 0.524-0.165 0.927-0.178l0.291-0.008 0.047 0.082c0.027 0.043 0.075 0.113 0.11 0.153 0.062 0.072 0.065 0.073 0.236 0.103 0.523 0.090 1.060 0.091 1.469 0.005 0.318-0.067 0.424-0.12 0.586-0.293 0.301-0.325 0.509-0.949 0.508-1.536 0-0.26-0.015-0.351-0.12-0.716-0.146-0.507-0.336-1.023-0.478-1.298-0.088-0.171-0.225-0.321-0.373-0.409-0.053-0.030-0.096-0.062-0.096-0.070 0-0.007 0.038-0.080 0.085-0.163 0.133-0.236 0.399-0.797 0.513-1.075 0.389-0.97 0.612-1.932 0.702-3.034 0.025-0.309 0.025-1.135 0-1.448-0.088-1.093-0.311-2.060-0.702-3.033-0.13-0.323-0.454-0.983-0.631-1.285-0.403-0.684-0.894-1.328-1.448-1.897l-0.259-0.266-0.030-0.329c-0.101-1.155-0.373-2.098-0.782-2.724-0.298-0.456-0.913-1.115-1.466-1.569-0.657-0.541-1.453-0.845-2.571-0.985-0.198-0.025-1.13-0.047-1.315-0.032zM17.649 3.619c0.637 0.103 1.268 0.301 1.835 0.579 0.399 0.196 0.601 0.344 0.927 0.681 0.228 0.236 0.812 0.963 0.845 1.053 0.012 0.028 0.005 0.030-0.067 0.020-0.304-0.040-0.454-0.028-0.629 0.055-0.215 0.1-0.336 0.27-0.345 0.481-0.002 0.038 0.002 0.075 0.007 0.080s0.037-0.010 0.072-0.033c0.131-0.090 0.233-0.117 0.449-0.117 0.181 0 0.215 0.005 0.358 0.055 0.228 0.077 0.398 0.183 0.574 0.359 0.321 0.319 0.431 0.699 0.491 1.706 0.030 0.486 0.040 1.459 0.018 1.764-0.095 1.343-0.451 2.588-1.008 3.534-0.123 0.21-0.552 0.852-0.656 0.982-0.138 0.171-0.318 0.333-0.518 0.463-0.601 0.391-1.233 0.646-1.824 0.739-0.241 0.037-0.691 0.037-0.905 0-0.228-0.040-0.567-0.16-0.874-0.309-0.8-0.391-1.338-0.909-2.201-2.122l-0.106-0.15 0.010 0.083c0.051 0.373 0.268 0.755 0.707 1.256 0.507 0.576 0.879 0.915 1.2 1.095 0.060 0.033 0.12 0.072 0.133 0.085 0.022 0.020 0.013 0.022-0.058 0.012-0.047-0.005-0.176-0.015-0.291-0.020-0.338-0.017-0.562 0.053-0.674 0.208l-0.050 0.070-0.175-0.010c-0.97-0.055-1.557-0.235-1.907-0.586-0.381-0.381-0.927-1.646-1.047-2.428-0.040-0.253-0.030-0.278 0.16-0.484 0.21-0.226 0.246-0.309 0.196-0.454-0.018-0.052-0.022-0.053-0.093-0.043-0.097 0.013-0.151 0.042-0.329 0.178-0.082 0.062-0.171 0.122-0.2 0.131-0.155 0.060-0.409 0.050-0.589-0.023-0.448-0.181-0.852-0.767-0.973-1.408-0.035-0.181-0.035-0.506 0-0.647 0.080-0.325 0.293-0.617 0.566-0.777 0.198-0.117 0.471-0.17 0.706-0.142 0.376 0.048 0.584 0.3 0.737 0.895l0.055 0.213 0.18-0.003c0.298-0.003 0.539-0.083 0.631-0.208 0.033-0.043 0.033-0.048 0.005-0.233-0.017-0.103-0.061-0.316-0.101-0.471-0.19-0.751-0.188-0.87 0.032-1.922 0.102-0.486 0.128-0.686 0.13-0.94 0.002-0.238-0.028-0.426-0.095-0.624-0.023-0.067-0.042-0.141-0.042-0.165 0-0.055 0.111-0.258 0.25-0.454 0.138-0.198 0.576-0.639 0.832-0.835 0.243-0.188 0.691-0.484 0.982-0.649 0.869-0.493 1.176-0.581 1.988-0.567 0.344 0.005 0.461 0.013 0.682 0.048zM14.321 4.080c0.088 0.070 0.020 0.193-0.135 0.243-0.060 0.018-0.113 0.053-0.178 0.115-0.052 0.048-0.17 0.146-0.265 0.216-0.261 0.196-0.348 0.295-0.544 0.621-0.213 0.353-0.316 0.489-0.413 0.551-0.098 0.063-0.188 0.075-0.378 0.052-0.2-0.027-0.303-0.010-0.662 0.108-0.313 0.101-0.429 0.125-0.429 0.088 0-0.013 0.037-0.087 0.083-0.161 0.321-0.541 0.924-1.047 1.722-1.448 0.288-0.145 0.461-0.218 0.782-0.33 0.28-0.098 0.348-0.106 0.416-0.055zM12.617 6.27c0.065 0.171 0.087 0.304 0.095 0.576 0.008 0.316-0.007 0.496-0.088 1.018-0.090 0.586-0.098 0.667-0.098 0.965 0 0.315 0.012 0.393 0.108 0.721 0.075 0.256 0.098 0.454 0.065 0.536-0.023 0.056-0.077 0.091-0.168 0.108l-0.060 0.012-0.012-0.113c-0.030-0.298-0.18-0.566-0.423-0.759-0.24-0.19-0.504-0.283-0.81-0.283-0.213 0-0.363 0.033-0.572 0.13-0.075 0.033-0.138 0.058-0.143 0.053-0.022-0.022-0.047-0.471-0.048-0.845 0-0.341 0.005-0.458 0.030-0.589 0.082-0.444 0.225-0.699 0.547-0.97 0.338-0.283 0.712-0.464 1.138-0.553 0.211-0.043 0.23-0.047 0.335-0.050 0.080-0.002 0.088 0.002 0.105 0.043zM9.948 8.998c0.017 0.015 0.027 0.058 0.028 0.115 0 0.050 0.007 0.091 0.015 0.091 0.007 0 0.012 0.037 0.012 0.083 0 0.045-0.007 0.083-0.015 0.083-0.007 0-0.010 0.018-0.007 0.038 0.005 0.023-0.003 0.052-0.018 0.067-0.015 0.013-0.027 0.033-0.027 0.043s-0.007 0.018-0.017 0.018c-0.008 0-0.017 0.010-0.017 0.023s-0.012 0.027-0.025 0.033c-0.013 0.005-0.025 0.020-0.025 0.033s-0.010 0.032-0.023 0.038c-0.022 0.013-0.143 0.361-0.143 0.413 0 0.013-0.005 0.025-0.012 0.025-0.008 0-0.013 0.025-0.015 0.053 0 0.030-0.010 0.145-0.022 0.255-0.052 0.486 0.083 1.158 0.334 1.664 0.288 0.578 0.782 0.983 1.336 1.097l0.1 0.022 0.005 0.065c0.025 0.354 0.175 0.795 0.378 1.113 0.208 0.326 0.273 0.519 0.225 0.666-0.035 0.108-0.13 0.178-0.591 0.441-0.975 0.557-1.657 0.968-1.98 1.196-0.091 0.065-0.301 0.188-0.464 0.271-0.426 0.22-0.557 0.353-0.586 0.596-0.020 0.171 0.065 0.512 0.253 1.023 0.060 0.165 0.153 0.424 0.206 0.576 0.053 0.153 0.168 0.459 0.255 0.682 0.226 0.582 0.285 0.779 0.393 1.301 0.073 0.348 0.201 1.201 0.201 1.329 0 0.095-0.473-0.418-0.87-0.944-0.85-1.125-1.434-2.43-1.707-3.814-0.070-0.354-0.123-0.717-0.112-0.764 0.007-0.025 0.003-0.040-0.008-0.040-0.013 0-0.017-0.025-0.010-0.083 0.007-0.055 0.003-0.083-0.008-0.083s-0.015-0.035-0.007-0.108c0.008-0.076 0.005-0.108-0.008-0.108s-0.015-0.043-0.007-0.158c0.008-0.11 0.007-0.158-0.007-0.158s-0.018-0.11-0.018-0.358c0-0.248 0.005-0.358 0.018-0.358s0.015-0.048 0.007-0.158c-0.008-0.115-0.007-0.158 0.007-0.158s0.017-0.032 0.008-0.108c-0.008-0.073-0.005-0.108 0.007-0.108s0.015-0.028 0.008-0.083c-0.007-0.052-0.003-0.083 0.007-0.083 0.012 0 0.015-0.030 0.008-0.075-0.003-0.042 0-0.075 0.008-0.075s0.012-0.027 0.008-0.058c-0.003-0.032 0-0.058 0.008-0.058s0.012-0.027 0.008-0.058c-0.003-0.032 0-0.058 0.008-0.058s0.013-0.023 0.008-0.050c-0.003-0.028 0-0.050 0.007-0.050 0.008 0 0.017-0.043 0.018-0.095 0.002-0.053 0.010-0.098 0.018-0.101 0.008-0.002 0.012-0.023 0.007-0.045-0.003-0.023 0-0.042 0.007-0.042 0.008 0 0.017-0.035 0.017-0.078 0.002-0.043 0.010-0.082 0.020-0.085s0.015-0.015 0.010-0.027c-0.023-0.058 0.285-1.138 0.328-1.155 0.008-0.003 0.015-0.022 0.015-0.040 0-0.048 0.068-0.23 0.085-0.23 0.008 0 0.015-0.018 0.015-0.042s0.008-0.042 0.017-0.042c0.010 0 0.017-0.018 0.017-0.042s0.008-0.042 0.017-0.042c0.010 0 0.017-0.018 0.017-0.040 0-0.023 0.012-0.052 0.025-0.067 0.013-0.013 0.025-0.033 0.025-0.045 0-0.035 0.040-0.131 0.053-0.131 0.007 0 0.013-0.012 0.013-0.025 0-0.032 0.087-0.213 0.108-0.228 0.010-0.007 0.035-0.052 0.057-0.1 0.1-0.23 0.125-0.278 0.147-0.286 0.012-0.005 0.022-0.025 0.022-0.043s0.015-0.047 0.033-0.062c0.018-0.017 0.033-0.042 0.033-0.058 0-0.015 0.013-0.042 0.032-0.058 0.017-0.017 0.035-0.050 0.042-0.076 0.005-0.025 0.018-0.045 0.027-0.045 0.010 0 0.017-0.012 0.017-0.025s0.007-0.025 0.015-0.025c0.008 0 0.020-0.018 0.025-0.042 0.007-0.023 0.018-0.042 0.027-0.042 0.010 0 0.017-0.012 0.017-0.025s0.007-0.025 0.015-0.025c0.008 0 0.020-0.018 0.025-0.042 0.007-0.023 0.018-0.042 0.027-0.042 0.010 0 0.017-0.012 0.017-0.025s0.008-0.025 0.017-0.025c0.010 0 0.017-0.012 0.017-0.025s0.008-0.025 0.017-0.025c0.010 0 0.017-0.012 0.017-0.025s0.008-0.025 0.017-0.025c0.010 0 0.017-0.012 0.017-0.025 0-0.015 0.012-0.030 0.025-0.035 0.013-0.007 0.025-0.020 0.025-0.033s0.008-0.023 0.017-0.023c0.010 0 0.017-0.010 0.017-0.023s0.012-0.027 0.025-0.033c0.013-0.005 0.025-0.020 0.025-0.035 0-0.013 0.008-0.025 0.017-0.025 0.010 0 0.017-0.010 0.017-0.023s0.012-0.027 0.025-0.033c0.013-0.005 0.025-0.020 0.025-0.033 0-0.012 0.012-0.027 0.025-0.033 0.013-0.005 0.025-0.020 0.025-0.033 0-0.012 0.012-0.027 0.025-0.033 0.013-0.005 0.025-0.020 0.025-0.033 0-0.015 0.015-0.033 0.033-0.043s0.033-0.027 0.033-0.038 0.015-0.030 0.033-0.042c0.018-0.012 0.033-0.030 0.033-0.042s0.015-0.030 0.033-0.042c0.018-0.012 0.033-0.030 0.033-0.042s0.023-0.038 0.050-0.058c0.028-0.022 0.050-0.046 0.050-0.058s0.027-0.042 0.058-0.067c0.032-0.025 0.058-0.055 0.058-0.065s0.045-0.060 0.1-0.108c0.055-0.050 0.1-0.098 0.1-0.107 0-0.023 0.321-0.348 0.343-0.348 0.012 0 0.023-0.015 0.028-0.033 0.010-0.040 0.038-0.043 0.073-0.007zM22.807 9.715c1.236 1.444 1.979 3.175 2.198 5.13 0.035 0.326 0.050 1.285 0.025 1.657-0.083 1.198-0.383 2.336-0.895 3.418-0.098 0.205-0.323 0.624-0.409 0.759l-0.043 0.068-0.161 0.022c-0.416 0.052-1.018 0.255-1.554 0.524-0.161 0.081-0.183 0.087-0.183 0.050 0-0.013 0.055-0.176 0.123-0.361 0.255-0.699 0.504-1.451 0.777-2.343 0.083-0.27 0.218-0.704 0.3-0.965 0.181-0.577 0.22-0.749 0.211-0.965-0.010-0.323-0.11-0.434-1.243-1.408-0.314-0.27-0.564-0.518-0.609-0.607-0.065-0.125-0.005-0.311 0.226-0.702 0.175-0.294 0.268-0.499 0.379-0.837 0.25-0.749 0.429-1.569 0.524-2.395 0.037-0.305 0.076-0.839 0.076-1.007 0-0.175 0.015-0.266 0.041-0.266 0.010 0 0.108 0.103 0.216 0.228zM21.043 15.262c0.055 0.047 0.291 0.271 0.524 0.499s0.508 0.478 0.607 0.556c0.268 0.21 0.398 0.341 0.459 0.468 0.053 0.106 0.053 0.108 0.043 0.294-0.012 0.193-0.070 0.488-0.203 1.040-0.171 0.701-0.449 1.529-0.86 2.558-0.268 0.669-0.328 0.76-0.534 0.82-0.17 0.048-0.206 0.053-0.652 0.070-0.411 0.017-0.549 0.037-0.674 0.1-0.078 0.040-0.1 0.042-0.1 0.007s0.118-0.236 0.749-1.271c0.492-0.807 0.854-1.413 0.92-1.543 0.025-0.045 0.023-0.053-0.005-0.098-0.017-0.027-0.078-0.103-0.138-0.17-0.108-0.122-0.162-0.208-0.162-0.261 0-0.015 0.027-0.105 0.057-0.196 0.235-0.691 0.115-1.819-0.233-2.207-0.076-0.085-0.21-0.168-0.27-0.168-0.045 0-0.17-0.087-0.17-0.118 0-0.017 0.073-0.085 0.171-0.161 0.093-0.072 0.203-0.17 0.245-0.216 0.042-0.045 0.087-0.083 0.1-0.085 0.013 0 0.070 0.037 0.125 0.083zM12.377 15.763c0.041 0.040 0.175 0.183 0.293 0.321 0.118 0.137 0.258 0.298 0.309 0.356 0.17 0.195 0.552 0.424 1.401 0.84l0.524 0.258 0.022 0.135c0.052 0.334 0.356 1.391 0.476 1.642 0.158 0.336 0.348 0.434 0.637 0.329 0.063-0.023 0.125-0.042 0.135-0.042 0.058 0-0.013 0.16-0.156 0.349-0.188 0.25-0.228 0.409-0.138 0.546 0.048 0.073 0.198 0.178 0.404 0.283 0.506 0.26 1.118 0.552 1.419 0.677 0.193 0.080 0.353 0.156 0.353 0.166 0 0.015-0.073 0.023-0.261 0.032-1.396 0.058-2.22 0.123-3.523 0.278-0.368 0.043-0.591 0.063-0.606 0.053-0.038-0.023-0.083-0.16-0.103-0.308-0.028-0.23-0.020-0.958 0.017-1.428 0.018-0.233 0.033-0.489 0.033-0.567 0-0.419-0.201-0.416-0.278 0.005-0.027 0.155-0.023 0.276 0.028 0.835 0.037 0.378 0.043 0.835 0.017 1.008-0.010 0.060-0.032 0.158-0.052 0.22-0.030 0.105-0.037 0.113-0.078 0.113-0.068-0.002-0.173-0.055-0.354-0.183-0.215-0.151-0.298-0.193-0.316-0.163-0.040 0.062-0.002 0.166 0.107 0.293 0.105 0.12 0.121 0.225 0.046 0.308-0.038 0.047-0.070 0.058-0.205 0.087-0.218 0.047-0.313 0.116-0.313 0.233 0 0.040 0.003 0.042 0.105 0.042 0.057 0 0.246-0.008 0.423-0.020 0.319-0.018 0.477-0.010 0.639 0.037l0.060 0.017 0.012 0.138c0.037 0.434 0.173 1.564 0.311 2.544 0.053 0.391 0.098 0.719 0.098 0.727 0 0.040-0.418 0-0.765-0.073-0.559-0.118-1.015-0.305-1.955-0.799-0.301-0.158-0.607-0.316-0.677-0.351l-0.13-0.063v-0.151c0-0.346-0.067-1.27-0.135-1.889-0.191-1.741-0.584-3.33-1.132-4.579-0.063-0.143-0.115-0.271-0.115-0.283 0-0.013 0.155-0.14 0.344-0.281 1.102-0.827 1.845-1.291 2.643-1.649 0.138-0.062 0.275-0.111 0.305-0.113 0.042 0 0.073 0.017 0.132 0.070zM20.531 16.283c0.17 0.087 0.29 0.476 0.341 1.101 0.027 0.341-0.022 0.674-0.116 0.802l-0.030 0.038-0.273-0.018c-0.441-0.028-1-0.111-1.263-0.188l-0.073-0.020 0.002-0.258c0.002-0.141 0.003-0.263 0.003-0.27 0-0.017 0.115-0.073 0.175-0.087 0.065-0.013 0.253-0.032 0.313-0.030 0.025 0.002 0.045-0.005 0.045-0.012 0-0.017-0.181-0.070-0.275-0.078-0.037-0.005-0.076-0.012-0.088-0.015-0.010-0.003-0.055 0-0.098 0.007-0.103 0.020-0.128 0.003-0.155-0.093-0.012-0.043-0.037-0.108-0.053-0.145-0.027-0.053-0.028-0.067-0.010-0.078 0.012-0.008 0.028-0.015 0.037-0.015 0.007 0 0.145-0.086 0.308-0.195 0.488-0.321 0.697-0.436 0.854-0.462 0.030-0.007 0.055-0.012 0.057-0.013 0.017-0.017 0.26 0.007 0.301 0.028zM19.271 16.284c0 0.013-0.015 0.032-0.032 0.042-0.018 0.008-0.17 0.125-0.336 0.258l-0.305 0.241-0.093 0.003c-0.356 0.012-0.627-0.032-0.837-0.133-0.161-0.080-0.328-0.195-0.328-0.228s0.075-0.048 0.13-0.027c0.083 0.033 0.276 0.068 0.393 0.068 0.161 0 0.423-0.042 0.75-0.12 0.273-0.065 0.567-0.125 0.629-0.128 0.015-0.002 0.028 0.010 0.028 0.023zM13.785 16.366c0.121 0.040 0.334 0.072 0.681 0.101 0.473 0.038 0.463 0.037 0.463 0.095 0 0.027-0.015 0.107-0.032 0.176-0.018 0.072-0.038 0.168-0.045 0.215-0.010 0.082-0.015 0.088-0.055 0.088-0.076 0-0.373-0.080-0.559-0.148-0.451-0.17-0.721-0.379-0.682-0.531 0.020-0.078 0.038-0.088 0.097-0.053 0.030 0.017 0.090 0.042 0.133 0.057zM15.822 16.424c0.018 0.008 0.037 0.013 0.042 0.010 0.023-0.023 0.677 0.193 0.904 0.299 0.349 0.165 0.441 0.213 0.626 0.335 0.105 0.070 0.283 0.138 0.381 0.148 0.023 0.002 0.050 0.005 0.060 0.005 0.010 0.002 0.018 0.033 0.020 0.068 0.003 0.062-0.002 0.068-0.073 0.108s-0.228 0.095-0.253 0.090c-0.012-0.002-0.060 0.010-0.25 0.063-0.088 0.025-0.108 0.067-0.023 0.050 0.097-0.020 0.582 0.117 0.632 0.178 0.010 0.012 0.013 0.085 0.008 0.186l-0.010 0.168-0.068 0.048c-0.037 0.028-0.195 0.155-0.351 0.285-0.155 0.128-0.343 0.278-0.416 0.329-0.309 0.223-0.968 0.476-1.241 0.476-0.080 0-0.098-0.007-0.138-0.048-0.027-0.028-0.050-0.067-0.053-0.088-0.005-0.035-0.107-0.326-0.141-0.404-0.072-0.162-0.191-0.524-0.208-0.629-0.005-0.030-0.012-0.072-0.017-0.095-0.038-0.191-0.057-0.686-0.033-0.948 0.005-0.068 0.010-0.136 0.012-0.15 0.010-0.123 0.105-0.353 0.173-0.416 0.070-0.065 0.153-0.093 0.275-0.090 0.062 0.002 0.126 0.012 0.145 0.022zM18.569 17.141c0.091 0.040 0.111 0.062 0.161 0.17 0.062 0.132 0.058 0.309-0.007 0.431-0.067 0.13-0.163 0.18-0.338 0.181-0.203 0-0.198 0.003-0.251-0.24-0.027-0.115-0.042-0.218-0.037-0.226 0.005-0.010 0.002-0.017-0.007-0.017-0.012 0-0.018-0.042-0.018-0.105 0-0.097 0.003-0.105 0.047-0.127 0.21-0.105 0.324-0.121 0.449-0.068zM18.932 18.188c0.038 0.018 0.13 0.073 0.203 0.125 0.165 0.115 0.291 0.175 0.401 0.188l0.085 0.010v0.1c0 0.056-0.007 0.185-0.017 0.285-0.008 0.102-0.023 0.368-0.033 0.592-0.025 0.567-0.053 0.845-0.135 1.348-0.035 0.223-0.088 0.408-0.116 0.413-0.032 0.005-0.225-0.388-0.506-1.037-0.354-0.817-0.552-1.193-0.8-1.527-0.060-0.082-0.106-0.158-0.103-0.17 0.003-0.013 0.043-0.068 0.088-0.125l0.083-0.102 0.075 0.012c0.123 0.018 0.173 0.010 0.353-0.068 0.196-0.085 0.306-0.096 0.423-0.043zM20.478 18.481c0.125 0.033 0.271 0.111 0.369 0.198 0.1 0.088 0.205 0.221 0.205 0.26 0 0.033-0.496 0.895-0.79 1.374-0.281 0.458-0.666 1.008-0.717 1.028-0.033 0.013-0.030-0.010 0.027-0.228 0.12-0.468 0.216-1.157 0.275-1.959 0.013-0.188 0.025-0.403 0.025-0.479 0-0.135 0.002-0.138 0.047-0.155 0.176-0.068 0.393-0.083 0.561-0.040zM17.71 18.9c0.359 0.508 0.581 0.935 1.038 2.022 0.095 0.228 0.173 0.424 0.173 0.438 0 0.040-0.048 0.030-0.336-0.068-0.516-0.178-0.995-0.381-1.563-0.664-0.398-0.198-0.78-0.406-0.78-0.422 0-0.007 0.015-0.062 0.035-0.12 0.090-0.278 0.283-0.547 0.554-0.776 0.16-0.135 0.734-0.536 0.769-0.537 0.010 0 0.060 0.058 0.11 0.128zM23.987 21.283c0.171 0.083 0.344 0.255 0.426 0.424 0.105 0.216 0.216 0.592 0.378 1.258 0.067 0.276 0.075 0.334 0.083 0.566 0.007 0.225 0.003 0.276-0.027 0.404-0.087 0.366-0.296 0.647-0.579 0.78-0.278 0.131-0.979 0.185-1.338 0.103-0.092-0.020-0.115-0.032-0.115-0.057 0-0.053 0.213-0.12 0.612-0.193 0.321-0.058 0.468-0.092 0.478-0.108 0.008-0.013-0.023-0.023-0.2-0.067-0.105-0.027-0.636-0.027-0.94-0.002-0.123 0.012-0.346 0.025-0.494 0.030l-0.268 0.012-0.010-0.090c-0.005-0.050-0.033-0.323-0.062-0.606-0.072-0.732-0.146-1.208-0.241-1.539l-0.027-0.091 0.072-0.062c0.138-0.118 0.456-0.26 1.027-0.453 0.323-0.11 0.531-0.195 0.661-0.271 0.153-0.090 0.203-0.105 0.333-0.1 0.090 0.005 0.143 0.018 0.231 0.060zM21.218 22.142c0.063 0.038 0.22 0.463 0.291 0.782 0.081 0.366 0.15 1.057 0.138 1.403l-0.005 0.171-0.216 0.073c-0.118 0.040-0.263 0.078-0.319 0.083l-0.102 0.012-0.010-0.072c-0.005-0.040-0.022-0.19-0.035-0.331-0.015-0.141-0.072-0.546-0.127-0.899-0.1-0.647-0.165-1.117-0.165-1.19 0-0.038 0.007-0.040 0.13-0.047 0.171-0.010 0.394-0.002 0.419 0.013zM17.865 22.15c0.381 0.023 1.067 0.102 1.102 0.125 0.008 0.005 0.053 0.378 0.070 0.574 0.023 0.273 0.032 0.426 0.060 1.123 0.025 0.562 0.032 0.656 0.083 1.198 0.032 0.333 0.055 0.769 0.075 1.423 0.030 0.982 0.067 1.464 0.143 1.92 0.022 0.136 0.038 0.25 0.037 0.251-0.017 0.010-0.285 0.078-0.446 0.115-0.478 0.105-0.945 0.15-1.523 0.15-0.671-0.002-1.181-0.052-1.789-0.173-0.275-0.055-0.724-0.168-0.74-0.186-0.003-0.003-0.053-0.163-0.113-0.356-0.428-1.38-0.727-2.737-0.959-4.341-0.093-0.637-0.188-1.459-0.173-1.473 0.018-0.017 0.88-0.156 1.27-0.208 0.537-0.068 1.142-0.121 1.672-0.146 0.263-0.013 0.994-0.010 1.231 0.005zM20.123 22.258c0.090 0.334 0.15 0.819 0.23 1.864 0.028 0.356 0.057 0.709 0.065 0.782 0.010 0.087 0.010 0.136-0.002 0.143-0.017 0.010-0.479 0.095-0.79 0.145-0.125 0.020-0.188 0.023-0.188 0.013s-0.012-0.165-0.025-0.343c-0.055-0.73-0.076-1.208-0.087-1.877-0.005-0.386-0.005-0.702 0-0.702s0.057-0.012 0.113-0.027c0.125-0.032 0.353-0.053 0.537-0.050 0.133 0.002 0.133 0.002 0.146 0.052zM20.080 25.588c0.030 0.008 0.038 0.027 0.047 0.111 0.007 0.056 0.053 0.298 0.103 0.536 0.125 0.596 0.158 0.809 0.168 1.098l0.010 0.25-0.19 0.062c-0.105 0.033-0.226 0.068-0.273 0.078-0.091 0.018-0.374 0.043-0.374 0.033 0-0.003-0.015-0.25-0.035-0.547-0.018-0.298-0.038-0.764-0.043-1.037l-0.010-0.494h0.053c0.030 0 0.127-0.018 0.215-0.040 0.088-0.023 0.185-0.045 0.211-0.048 0.028-0.003 0.058-0.008 0.066-0.008 0.010-0.002 0.033 0.002 0.052 0.007zM15.91 6.154c-0.14 0.023-0.336 0.111-0.524 0.236-0.158 0.103-0.414 0.363-0.521 0.526-0.143 0.218-0.236 0.509-0.211 0.659 0.012 0.067 0.088 0.165 0.128 0.165 0.012 0 0.052-0.062 0.088-0.138 0.142-0.29 0.358-0.569 0.556-0.716 0.115-0.085 0.295-0.166 0.446-0.203 0.095-0.023 0.167-0.027 0.358-0.020 0.13 0.005 0.255 0.013 0.276 0.020 0.032 0.010 0.040 0.003 0.062-0.048 0.040-0.093 0.032-0.163-0.028-0.253-0.117-0.173-0.381-0.27-0.629-0.228zM21.285 7.951c0 0.226 0.055 0.449 0.203 0.819 0.045 0.113 0.080 0.221 0.076 0.241-0.008 0.053-0.158 0.090-0.451 0.11-0.258 0.018-0.283 0.022-0.406 0.053-0.065 0.017-0.072 0.023-0.072 0.068 0 0.16 0.115 0.306 0.276 0.354 0.261 0.075 0.709-0.062 0.945-0.286 0.145-0.14 0.143-0.13 0.025-0.326-0.096-0.158-0.289-0.544-0.491-0.982-0.045-0.1-0.087-0.18-0.093-0.18-0.008 0-0.013 0.058-0.013 0.128zM17.033 7.921c-0.040 0.235 0.108 0.689 0.374 1.145 0.060 0.101 0.1 0.188 0.097 0.21-0.012 0.086-0.268 0.158-0.486 0.136-0.065-0.007-0.22-0.030-0.343-0.052-0.3-0.053-0.34-0.053-0.364 0.005-0.047 0.113-0.050 0.156-0.023 0.223 0.073 0.186 0.369 0.298 0.79 0.298 0.348 0 0.483-0.045 0.679-0.226 0.082-0.077 0.105-0.11 0.126-0.186 0.030-0.103 0.023-0.206-0.020-0.29-0.015-0.030-0.112-0.14-0.213-0.246-0.21-0.22-0.255-0.293-0.419-0.679-0.062-0.145-0.128-0.295-0.148-0.336l-0.038-0.073-0.012 0.072zM19.185 8.224c-0.025 0.013-0.030 0.040-0.030 0.138 0 0.456 0.265 1.055 0.729 1.657 0.12 0.153 0.523 0.637 0.687 0.824 0.166 0.19 0.223 0.351 0.181 0.527-0.027 0.113-0.093 0.245-0.13 0.258-0.015 0.005-0.185 0.083-0.378 0.173-0.446 0.206-0.596 0.268-0.782 0.321-0.221 0.062-0.388 0.083-0.567 0.072-0.29-0.017-0.349-0.073-0.438-0.418-0.028-0.108-0.052-0.201-0.052-0.203 0-0.003-0.006-0.007-0.017-0.007-0.028 0-0.098 0.16-0.117 0.273-0.035 0.196 0.035 0.443 0.171 0.601l0.058 0.067 0.251 0.005c0.679 0.017 1.306-0.186 2.072-0.667l0.248-0.156 0.028-0.115c0.015-0.063 0.047-0.168 0.070-0.231 0.023-0.065 0.052-0.16 0.062-0.211 0.033-0.16 0.020-0.185-0.261-0.461-0.724-0.709-1.513-1.805-1.607-2.236-0.018-0.081-0.043-0.146-0.072-0.178-0.043-0.053-0.063-0.058-0.108-0.032zM10.973 10.034c-0.16 0.055-0.28 0.185-0.343 0.374-0.040 0.117-0.037 0.123 0.035 0.058 0.1-0.097 0.136-0.115 0.231-0.115 0.047 0 0.092 0.007 0.097 0.017 0.005 0.008-0.010 0.078-0.035 0.153-0.037 0.115-0.046 0.176-0.053 0.364-0.008 0.261 0.018 0.429 0.095 0.589 0.098 0.205 0.096 0.208 0.105-0.226 0.008-0.339 0.013-0.403 0.045-0.501 0.058-0.181 0.171-0.258 0.309-0.213 0.083 0.028 0.148 0.112 0.261 0.343 0.057 0.115 0.126 0.235 0.156 0.27l0.053 0.062 0.012-0.115c0.052-0.478-0.22-0.93-0.637-1.058-0.131-0.040-0.218-0.042-0.331-0.002zM21.193 12.342c-0.634 0.336-0.855 0.423-1.213 0.481-0.081 0.013-0.155 0.033-0.163 0.045-0.015 0.025-0.018 0.426-0.003 0.516 0.010 0.062 0.013 0.063 0.080 0.063 0.113 0 0.363-0.060 0.516-0.121 0.384-0.156 0.762-0.534 1.033-1.032 0.033-0.062 0.058-0.111 0.055-0.111-0.002 0-0.14 0.072-0.305 0.16zM17.068 12.667c0.115 0.213 0.419 0.446 0.764 0.579 0.414 0.163 1.065 0.264 1.572 0.248l0.158-0.005-0.003-0.225c-0.002-0.123-0.010-0.258-0.017-0.3l-0.015-0.075-0.572-0.010c-0.942-0.017-1.426-0.091-1.904-0.29-0.027-0.012-0.025-0.002 0.017 0.077zM16.714 13.166c-0.085 0.025-0.096 0.067-0.040 0.141 0.027 0.037 0.087 0.102 0.135 0.148 0.047 0.045 0.153 0.178 0.236 0.294s0.196 0.266 0.253 0.333c0.294 0.344 0.619 0.463 1.266 0.463 0.531 0 1.018-0.098 1.185-0.24 0.052-0.043 0.171-0.21 0.171-0.238 0-0.008-0.271-0.012-0.604-0.008-0.995 0.012-1.409-0.045-1.817-0.245-0.276-0.136-0.469-0.321-0.579-0.554-0.048-0.103-0.058-0.113-0.103-0.111-0.027 0-0.075 0.008-0.103 0.017zM18.845 18.77c-0.1 0.060-0.113 0.206-0.028 0.291 0.123 0.123 0.321 0.033 0.321-0.146 0-0.050-0.012-0.075-0.057-0.12-0.067-0.067-0.153-0.076-0.236-0.025zM19.097 19.651c-0.090 0.030-0.141 0.1-0.141 0.191 0 0.052 0.012 0.076 0.057 0.122 0.048 0.048 0.068 0.057 0.133 0.057 0.060 0 0.087-0.010 0.13-0.048 0.048-0.043 0.055-0.058 0.055-0.133 0-0.072-0.006-0.092-0.050-0.133-0.052-0.050-0.126-0.073-0.183-0.055zM23.232 22.017c-0.409 0.073-0.742 0.24-0.932 0.466l-0.070 0.083h0.078c0.175 0 0.358-0.076 0.757-0.316 0.241-0.145 0.384-0.22 0.483-0.25 0.083-0.027-0.138-0.015-0.316 0.017zM22.887 22.715c-0.116 0.022-0.253 0.076-0.313 0.125-0.042 0.035-0.047 0.045-0.025 0.060 0.037 0.025 0.587 0.005 0.973-0.035 0.175-0.018 0.331-0.033 0.349-0.035 0.055-0.003-0.14-0.060-0.308-0.088-0.19-0.033-0.558-0.048-0.677-0.027zM22.737 23.406c-0.093 0.025-0.213 0.081-0.228 0.105s0.235 0.037 0.913 0.047c0.567 0.006 0.627 0.005 0.579-0.017-0.078-0.037-0.371-0.106-0.563-0.135-0.21-0.032-0.586-0.032-0.702 0z"></path>
</svg>`, rw = `<?xml version="1.0" encoding="utf-8"?>\r
<!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg">\r
<title>postgresql</title>\r
<path d="M24.295 9.929c-0.010 0.155-0.082 0.292-0.191 0.387l-0.001 0.001c-0.131 0.143-0.306 0.243-0.504 0.278l-0.005 0.001c-0.028 0.004-0.061 0.007-0.094 0.007h-0c-0.001 0-0.003 0-0.004 0-0.312 0-0.58-0.189-0.694-0.46l-0.002-0.005c-0.030-0.221 0.33-0.388 0.701-0.44s0.764 0.011 0.794 0.231zM14.385 10.443c-0.121 0.311-0.418 0.528-0.766 0.528-0.004 0-0.007-0-0.011-0h0.001c-0 0-0 0-0 0-0.036 0-0.070-0.003-0.105-0.007l0.004 0c-0.261-0.047-0.483-0.191-0.63-0.392l-0.002-0.003c-0.082-0.094-0.132-0.219-0.132-0.354 0-0 0-0.001 0-0.001v0c0.012-0.077 0.055-0.143 0.115-0.185l0.001-0.001c0.152-0.084 0.334-0.133 0.528-0.133 0.083 0 0.164 0.009 0.242 0.026l-0.007-0.001c0.395 0.055 0.803 0.242 0.764 0.523zM25.403 18.086l-0.107-0.134-0.044-0.055c0.457-0.846 0.725-1.853 0.725-2.921 0-0.488-0.056-0.962-0.162-1.418l0.008 0.042c-0.070-0.453-0.111-0.976-0.111-1.508 0-0.007 0-0.014 0-0.021v0.001c0.023-0.501 0.076-0.97 0.158-1.429l-0.010 0.066c0.089-0.464 0.14-0.998 0.14-1.544 0-0.051-0-0.101-0.001-0.151l0 0.008c0.012-0.049 0.019-0.104 0.019-0.162 0-0.027-0.002-0.053-0.004-0.079l0 0.003c-0.4-1.58-1.151-2.949-2.168-4.073l0.007 0.008c-0.911-1.068-2.031-1.929-3.3-2.523l-0.060-0.025c0.696-0.149 1.496-0.234 2.316-0.234 0.075 0 0.15 0.001 0.225 0.002l-0.011-0c0.045-0.001 0.097-0.002 0.15-0.002 2.378 0 4.496 1.109 5.866 2.838l0.012 0.016c0.028 0.036 0.056 0.077 0.080 0.12l0.003 0.005c0.904 1.694-0.345 7.842-3.732 13.172zM25.117 9.322c-0.016 0.455-0.064 0.886-0.14 1.307l0.008-0.055c-0.078 0.425-0.134 0.931-0.157 1.445l-0.001 0.025c-0 0.017-0 0.036-0 0.056 0 0.567 0.042 1.124 0.124 1.668l-0.008-0.061c0.085 0.377 0.134 0.809 0.134 1.254 0 0.763-0.144 1.493-0.407 2.162l0.014-0.040c-0.076-0.131-0.155-0.289-0.224-0.453l-0.011-0.029c-0.066-0.159-0.209-0.416-0.406-0.77-0.769-1.38-2.571-4.611-1.649-5.929 0.474-0.678 1.676-0.707 2.722-0.579zM24.406 20.907c-0.051-1.039 0.336-1.148 0.746-1.263q0.085-0.023 0.169-0.051c0.050 0.044 0.105 0.087 0.162 0.125l0.005 0.003c0.62 0.273 1.342 0.431 2.102 0.431 0.592 0 1.161-0.096 1.693-0.274l-0.038 0.011c-0.344 0.293-0.736 0.544-1.16 0.738l-0.031 0.013c-0.644 0.264-1.391 0.429-2.173 0.454l-0.010 0c-0.119 0.018-0.256 0.029-0.395 0.029-0.386 0-0.754-0.080-1.087-0.224l0.018 0.007zM23.293 22.933c-0.021 0.221-0.045 0.47-0.077 0.745l-0.182 0.548c-0.014 0.040-0.022 0.086-0.023 0.134v0c0.001 0.027 0.001 0.058 0.001 0.089 0 0.355-0.053 0.699-0.151 1.022l0.006-0.025c-0.116 0.389-0.196 0.84-0.223 1.305l-0.001 0.016c-0.052 1.684-1.355 3.047-3.008 3.194l-0.013 0.001c-1.894 0.406-2.23-0.621-2.526-1.527q-0.045-0.142-0.096-0.283c-0.16-0.652-0.252-1.401-0.252-2.171 0-0.36 0.020-0.715 0.059-1.065l-0.004 0.043c0.006-0.128 0.009-0.279 0.009-0.43 0-1.026-0.154-2.016-0.441-2.948l0.019 0.071q0.008-0.55 0.024-1.114c0-0.003 0-0.008 0-0.012 0-0.046-0.007-0.090-0.020-0.132l0.001 0.003c-0.014-0.1-0.033-0.188-0.058-0.273l0.003 0.013c-0.141-0.521-0.496-0.941-0.964-1.164l-0.011-0.005c-0.176-0.088-0.384-0.14-0.605-0.14-0.104 0-0.205 0.011-0.302 0.033l0.009-0.002c0.128-0.47 0.26-0.854 0.412-1.228l-0.026 0.073 0.066-0.177c0.074-0.2 0.167-0.407 0.266-0.626 0.546-1.124 0.865-2.445 0.865-3.841 0-0.938-0.144-1.842-0.411-2.692l0.017 0.063c-0.183-1.108-1.135-1.943-2.281-1.943-0.18 0-0.356 0.021-0.524 0.060l0.016-0.003c-0.796 0.104-1.516 0.338-2.171 0.682l0.035-0.017q-0.124 0.063-0.245 0.13c0.091-2.147 0.896-4.090 2.181-5.615l-0.012 0.014c0.118-0.119 0.242-0.232 0.37-0.338l0.009-0.007c0.069-0.014 0.13-0.042 0.182-0.081l-0.001 0.001c0.893-0.654 2.014-1.047 3.227-1.047 0.097 0 0.193 0.002 0.288 0.007l-0.013-0.001c0.526 0.008 1.034 0.044 1.534 0.108l-0.067-0.007c2.043 0.393 3.787 1.463 5.032 2.963l0.011 0.014c0.748 0.869 1.354 1.887 1.766 2.998l0.022 0.069c-0.257-0.069-0.552-0.109-0.856-0.109-0.983 0-1.868 0.416-2.49 1.081l-0.002 0.002c-1.24 1.773 0.679 5.215 1.601 6.869 0.169 0.303 0.315 0.565 0.361 0.676 0.26 0.601 0.587 1.118 0.98 1.577l-0.007-0.008c0.087 0.109 0.171 0.214 0.236 0.306-0.501 0.144-1.401 0.478-1.319 2.146-0.015 0.195-0.053 0.558-0.104 1.018-0.054 0.269-0.098 0.597-0.123 0.93l-0.002 0.028zM14.091 17.219l-0.066 0.176c-0.137 0.328-0.279 0.745-0.397 1.172l-0.019 0.081c-0.893-0.013-1.695-0.395-2.261-1.001l-0.002-0.002c-0.632-0.667-1.020-1.57-1.020-2.564 0-0.198 0.015-0.392 0.045-0.582l-0.003 0.021c0.097-0.72 0.153-1.551 0.153-2.396 0-0.502-0.020-0.999-0.058-1.491l0.004 0.065c-0.006-0.107-0.012-0.201-0.015-0.275 0.805-0.611 1.824-0.98 2.929-0.98 0.132 0 0.262 0.005 0.391 0.015l-0.017-0.001c0.554 0.129 0.971 0.588 1.037 1.153l0.001 0.006c0.238 0.728 0.375 1.566 0.375 2.435 0 1.266-0.291 2.464-0.809 3.532l0.021-0.048c-0.105 0.233-0.204 0.453-0.289 0.682zM11.474 22.203c-0.205-0.052-0.385-0.128-0.549-0.227l0.009 0.005c0.172-0.073 0.375-0.134 0.585-0.173l0.019-0.003c1.604-0.33 1.851-0.563 2.392-1.25 0.124-0.157 0.264-0.336 0.459-0.553 0.040-0.045 0.072-0.099 0.091-0.159l0.001-0.003c0.213-0.189 0.34-0.137 0.546-0.052 0.227 0.125 0.395 0.336 0.46 0.587l0.001 0.007c0.023 0.065 0.037 0.139 0.037 0.217 0 0.125-0.035 0.242-0.095 0.341l0.002-0.003c-0.645 0.882-1.676 1.449-2.839 1.449-0.4 0-0.785-0.067-1.144-0.191l0.025 0.007zM3.967 15.846c-0.651-1.985-1.181-4.34-1.494-6.764l-0.021-0.199c-0.061-0.322-0.095-0.693-0.095-1.071 0-1.806 0.789-3.427 2.041-4.537l0.006-0.005c2.295-1.623 6.048-0.676 7.633-0.163l-0.012 0.012c-1.535 1.872-2.466 4.292-2.466 6.928 0 0.090 0.001 0.18 0.003 0.27l-0-0.013c-0 0.103 0.008 0.249 0.020 0.449 0.033 0.41 0.052 0.888 0.052 1.371 0 0.802-0.052 1.592-0.154 2.367l0.010-0.091c-0.033 0.206-0.051 0.444-0.051 0.686 0 1.231 0.482 2.35 1.269 3.177l-0.002-0.002q0.151 0.158 0.315 0.297c-0.433 0.464-1.375 1.49-2.377 2.696-0.709 0.853-1.199 0.689-1.36 0.636-0.685-0.368-1.222-0.939-1.538-1.631l-0.009-0.022c-0.684-1.252-1.286-2.708-1.73-4.232l-0.039-0.157zM30.445 19.403c-0.019-0.057-0.043-0.106-0.072-0.151l0.002 0.003c-0.174-0.329-0.596-0.427-1.259-0.29-2.066 0.426-2.866 0.164-3.156-0.024 1.617-2.452 2.918-5.292 3.751-8.326l0.049-0.209c0.339-1.313 0.997-4.403 0.153-5.913-0.059-0.112-0.122-0.208-0.192-0.298l0.003 0.004c-1.563-1.955-3.948-3.196-6.623-3.196-0.076 0-0.152 0.001-0.227 0.003l0.011-0c-0.042-0.001-0.091-0.001-0.141-0.001-1.342 0-2.633 0.22-3.838 0.625l0.085-0.025q-0.321-0.060-0.645-0.102c-0.488-0.093-1.053-0.151-1.631-0.16l-0.008-0c-0.083-0.004-0.18-0.006-0.278-0.006-1.315 0-2.538 0.394-3.557 1.071l0.024-0.015c-1.071-0.401-5.984-2.056-9.025 0.098-1.489 1.27-2.426 3.147-2.426 5.244 0 0.405 0.035 0.802 0.102 1.188l-0.006-0.041c0.335 2.698 0.879 5.126 1.632 7.461l-0.079-0.284c0.493 1.716 1.103 3.201 1.852 4.6l-0.061-0.124c0.433 0.984 1.182 1.764 2.116 2.225l0.026 0.012c0.168 0.049 0.361 0.078 0.561 0.078 0.742 0 1.392-0.391 1.756-0.979l0.005-0.009c1.001-1.204 1.987-2.282 2.43-2.758 0.502 0.279 1.097 0.451 1.731 0.471l0.006 0 0.001 0.005q-0.158 0.188-0.309 0.382c-0.424 0.538-0.512 0.649-1.875 0.93-0.388 0.080-1.418 0.292-1.433 1.014-0 0.004-0 0.008-0 0.013 0 0.147 0.043 0.284 0.117 0.399l-0.002-0.003c0.312 0.395 0.751 0.678 1.254 0.788l0.015 0.003c0.399 0.13 0.859 0.205 1.335 0.205 1.1 0 2.106-0.398 2.884-1.058l-0.006 0.005c-0.024 0.418-0.037 0.908-0.037 1.401 0 1.753 0.171 3.467 0.496 5.125l-0.027-0.167c0.382 1.373 1.616 2.367 3.084 2.38h0.002c0.369-0.003 0.726-0.046 1.070-0.124l-0.033 0.006c1.919-0.171 3.431-1.705 3.567-3.619l0.001-0.012c0.188-1.088 0.502-3.593 0.673-5.125 0.008-0.065 0.034-0.123 0.072-0.171l-0.001 0.001c0.001-0.001 0.087-0.059 0.534 0.038l0.055 0.009 0.317 0.028 0.019 0.001c0.095 0.004 0.207 0.007 0.319 0.007 1.024 0 2.002-0.2 2.895-0.564l-0.051 0.018c0.805-0.373 2.256-1.29 1.993-2.087z"></path>\r
</svg>`, sw = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 14 14" role="img" focusable="false" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"><path d="m 9.6693761,6.3223595 c -0.02637,-0.304584 -0.08225,-0.608381 -0.160162,-0.903915 -0.24595,-0.932249 -0.655605,-1.824752 -1.233292,-2.598413 -0.157408,-0.210927 -0.327409,-0.412409 -0.509215,-0.602873 -0.187315,-0.196366 -0.395094,-0.376598 -0.525743,-0.620974 -0.08264,-0.154654 -0.161343,-0.311274 -0.241621,-0.467108 -0.0012,0.0488 -0.0043,0.09759 -0.0043,0.145996 0,-0.0488 0.0035,-0.09759 0.0043,-0.14639 -0.01495,-0.03738 -0.02991,-0.07516 -0.05116,-0.128681 -0.0087,0.02951 -0.01417,0.03975 -0.01417,0.05076 -0.0067,0.253821 -0.150718,0.426182 -0.32977,0.587132 -0.201482,0.181019 -0.389191,0.377386 -0.582803,0.567062 0.0067,0.0087 0.01417,0.01731 0.02164,0.02597 -0.0075,-0.0087 -0.01495,-0.01692 -0.02164,-0.02597 -0.57572,0.757133 -1.0829674,1.566604 -1.3816491,2.475241 -0.086968,0.264446 -0.1554404,0.534794 -0.2034499,0.809078 -0.1019216,0.582803 -0.1491441,1.149078 -0.1164819,1.739358 0.018102,0.326228 0.075162,0.647341 0.1601627,0.963337 0.3089132,1.147898 0.9361842,2.0998235 1.7936642,2.9089005 0.159376,0.150325 0.331344,0.286875 0.497803,0.430118 3.93e-4,-0.0016 7.87e-4,-0.0028 0.0012,-0.0043 -3.94e-4,0.0016 -7.88e-4,0.0028 -0.0012,0.0043 0.0244,0.08421 0.04919,0.168426 0.07359,0.25264 0.02282,0.130648 0.04565,0.261297 0.06847,0.391946 0.01102,0.136157 0.02164,0.272709 0.03266,0.408867 -3.94e-4,0.08303 -0.0039,0.166459 0.0012,0.249098 0.0012,0.02125 0.02912,0.04093 0.04447,0.06139 3.94e-4,-7.87e-4 7.87e-4,-0.0016 0.0016,-0.0024 -3.93e-4,7.87e-4 -7.87e-4,0.0016 -0.0016,0.0024 0.04644,0.01613 0.09248,0.03266 0.138913,0.0488 0.04171,0.01613 0.08343,0.03266 0.144422,0.05627 -0.0091,-0.136158 -0.01692,-0.249886 -0.02479,-0.363614 -3.94e-4,-0.119236 -7.87e-4,-0.238865 -0.0012,-0.358102 -0.0024,0.0028 -0.0055,0.0055 -0.0083,0.0083 0.0028,-0.0028 0.0055,-0.0055 0.0083,-0.0083 0.01653,-0.181806 0.03345,-0.363612 0.04998,-0.54542 0.0122,-0.03974 0.024,-0.0791 0.0362,-0.118843 0.03463,-0.06139 0.06887,-0.122384 0.103496,-0.183773 0.127894,-0.103103 0.265232,-0.196367 0.382108,-0.310881 0.210927,-0.207385 0.42146,-0.417131 0.609956,-0.644193 0.244769,-0.294353 0.455696,-0.6158575 0.62491,-0.9605815 0.481275,-0.980258 0.704007,-2.073457 0.615465,-3.163508 -7.87e-4,-0.0094 -0.0016,-0.01928 -0.0024,-0.02912 z"/></svg>`, iw = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg width="800px" height="800px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="none"><path fill="#000000" fill-rule="evenodd" d="M5.374 15c-.335 0-.66-.153-.874-.431l-3.254-4.172a1.15 1.15 0 01-.214-.978l1.165-5.207c.074-.345.298-.623.605-.776l4.715-2.32c.15-.078.317-.116.485-.116.168 0 .335.038.485.115L13.2 3.426c.308.153.532.432.606.777l1.165 5.207c.074.345 0 .7-.214.978L11.5 14.566c-.214.268-.54.434-.875.434h-5.25zm7.718-5.835l.031.008a.308.308 0 01.26.371.306.306 0 01-.396.223h-.004l-.003-.001-.003-.001-.03-.007-.05-.01a2.548 2.548 0 01-.274-.106 2.87 2.87 0 00-.533-.156.242.242 0 00-.171.063 4.76 4.76 0 00-.131-.023 3.972 3.972 0 01-1.764 2.212c.015.042.032.083.051.123a.239.239 0 00-.023.18c.074.17.165.332.271.484.06.078.114.16.164.244l.028.057.012.025a.306.306 0 01-.381.44.307.307 0 01-.172-.18 2.608 2.608 0 00-.01-.02l-.028-.058a2.545 2.545 0 01-.089-.28 2.835 2.835 0 00-.21-.512.242.242 0 00-.156-.095 5.926 5.926 0 01-.03-.053l-.035-.064a3.97 3.97 0 01-2.824-.007l-.069.125a.249.249 0 00-.132.064c-.104.17-.184.355-.237.548a2.525 2.525 0 01-.088.28l-.025.05-.013.027v.001a.307.307 0 11-.553-.261l.014-.03.026-.052c.05-.085.104-.166.164-.244.108-.156.2-.322.277-.496a.302.302 0 00-.028-.173l.056-.133A3.972 3.972 0 014.22 9.532l-.134.023a.34.34 0 00-.176-.062 2.872 2.872 0 00-.533.156c-.09.04-.181.075-.274.105l-.05.011-.03.007H3.02l-.002.002h-.005a.308.308 0 01-.397-.349.306.306 0 01.261-.245l.004-.001h.003l.006-.002c.024-.006.054-.014.076-.018.097-.013.195-.021.293-.023.186-.013.37-.043.549-.09a.422.422 0 00.131-.133l.128-.037a3.938 3.938 0 01.624-2.752l-.097-.087a.338.338 0 00-.062-.176 2.854 2.854 0 00-.455-.319 2.557 2.557 0 01-.254-.148 1.129 1.129 0 01-.063-.05l-.004-.004a.323.323 0 01-.076-.45.295.295 0 01.244-.107.365.365 0 01.213.08l.022.017c.016.013.034.026.046.037.071.067.139.139.202.213.125.137.263.262.412.372.056.03.121.036.182.018l.11.078a3.938 3.938 0 012.552-1.224l.007-.129a.332.332 0 00.1-.157 2.844 2.844 0 00-.034-.554 2.555 2.555 0 01-.042-.29v-.053-.025-.004-.004A.306.306 0 018 2.82a.308.308 0 01.306.337v.087a2.53 2.53 0 01-.041.29 2.85 2.85 0 00-.035.553.242.242 0 00.1.153v.007l.007.13c.967.087 1.87.522 2.54 1.223l.116-.083a.34.34 0 00.186-.02c.149-.11.287-.235.412-.373a2.53 2.53 0 01.202-.213l.051-.04.017-.014a.308.308 0 01.472.388.307.307 0 01-.09.09c-.008.005-.017.012-.025.02l-.043.033a2.549 2.549 0 01-.254.148 2.865 2.865 0 00-.455.32.24.24 0 00-.058.172 4.458 4.458 0 01-.05.044l-.058.053c.542.806.769 1.783.637 2.745l.123.036c.031.056.077.101.132.132.18.048.364.078.55.09.097.003.195.01.292.024l.058.013zm-2.875-3.1l-1.308.925-.004-.002a.27.27 0 01-.43-.205v-.001l-.091-1.598a3.183 3.183 0 011.833.882zM7.754 7.818h.492l.306.381-.11.476L8 8.886l-.443-.213-.11-.475.307-.381zM7.29 5.24c.107-.024.216-.043.326-.056l-.09 1.6-.008.004a.268.268 0 01-.293.256.27.27 0 01-.135-.05l-.002.001-1.316-.93c.419-.41.945-.696 1.518-.825zM5.296 6.663l1.201 1.071-.001.007a.269.269 0 01-.106.462l-.001.005-1.54.443a3.134 3.134 0 01.447-1.988zm1.608 2.846l-.612 1.474a3.16 3.16 0 01-1.27-1.586L6.6 9.13l.003.003a.265.265 0 01.18.029.27.27 0 01.117.341l.004.006zm1.806 1.896c-.572.13-1.17.1-1.726-.088l.777-1.4h.001a.27.27 0 01.475-.001h.006l.779 1.402a3.286 3.286 0 01-.312.087zm1.004-.416L9.096 9.5l.001-.003a.269.269 0 01.296-.37l.003-.004 1.593.269a3.147 3.147 0 01-1.275 1.597zm1.442-2.343L9.61 8.201l-.002-.006a.27.27 0 01-.185-.343.27.27 0 01.08-.12L9.5 7.73l1.195-1.067c.366.594.527 1.29.46 1.983z" clip-rule="evenodd"/></svg>`, ow = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 24 24" role="img" xmlns="http://www.w3.org/2000/svg"><path d="M9.71 2.136a1.43 1.43 0 0 0-2.047 0h-.007a1.48 1.48 0 0 0-.421 1.042c0 .41.161.777.422 1.039l.007.007c.257.264.616.426 1.019.426.404 0 .766-.162 1.027-.426l.003-.007c.261-.262.421-.629.421-1.039 0-.408-.159-.777-.421-1.042H9.71zM8.683 22.295c.404 0 .766-.167 1.027-.429l.003-.008c.261-.261.421-.631.421-1.036 0-.41-.159-.778-.421-1.044H9.71a1.42 1.42 0 0 0-1.027-.432 1.4 1.4 0 0 0-1.02.432h-.007c-.26.266-.422.634-.422 1.044 0 .406.161.775.422 1.036l.007.008c.258.262.617.429 1.02.429zm7.89-4.462c.359-.096.683-.33.882-.684l.027-.052a1.47 1.47 0 0 0 .114-1.067 1.454 1.454 0 0 0-.675-.896l-.021-.014a1.425 1.425 0 0 0-1.078-.132c-.36.091-.684.335-.881.686-.2.349-.241.75-.146 1.119.099.363.33.691.675.896h.002c.346.203.737.239 1.101.144zm-6.405-7.342a2.083 2.083 0 0 0-1.485-.627c-.58 0-1.103.242-1.482.627-.378.385-.612.916-.612 1.507s.233 1.124.612 1.514a2.08 2.08 0 0 0 2.967 0c.379-.39.612-.923.612-1.514s-.233-1.122-.612-1.507zm-.835-2.51c.843.141 1.6.552 2.178 1.144h.004c.092.093.182.196.265.299l1.446-.851a3.176 3.176 0 0 1-.047-1.808 3.149 3.149 0 0 1 1.456-1.926l.025-.016a3.062 3.062 0 0 1 2.345-.306c.77.21 1.465.721 1.898 1.482v.002c.431.757.518 1.626.313 2.408a3.145 3.145 0 0 1-1.456 1.928l-.198.118h-.02a3.095 3.095 0 0 1-2.154.201 3.127 3.127 0 0 1-1.514-.944l-1.444.848a4.162 4.162 0 0 1 0 2.879l1.444.846c.413-.47.939-.789 1.514-.944a3.041 3.041 0 0 1 2.371.319l.048.023v.002a3.17 3.17 0 0 1 1.408 1.906 3.215 3.215 0 0 1-.313 2.405l-.026.053-.003-.005a3.147 3.147 0 0 1-1.867 1.436 3.096 3.096 0 0 1-2.371-.318v-.006a3.156 3.156 0 0 1-1.456-1.927 3.175 3.175 0 0 1 .047-1.805l-1.446-.848a3.905 3.905 0 0 1-.265.294l-.004.005a3.938 3.938 0 0 1-2.178 1.138v1.699a3.09 3.09 0 0 1 1.56.862l.002.004c.565.572.914 1.368.914 2.243 0 .873-.35 1.664-.914 2.239l-.002.009a3.1 3.1 0 0 1-2.21.931 3.1 3.1 0 0 1-2.206-.93h-.002v-.009a3.186 3.186 0 0 1-.916-2.239c0-.875.35-1.672.916-2.243v-.004h.002a3.1 3.1 0 0 1 1.558-.862v-1.699a3.926 3.926 0 0 1-2.176-1.138l-.006-.005a4.098 4.098 0 0 1-1.173-2.874c0-1.122.452-2.136 1.173-2.872h.006a3.947 3.947 0 0 1 2.176-1.144V6.289a3.137 3.137 0 0 1-1.558-.864h-.002v-.004a3.192 3.192 0 0 1-.916-2.243c0-.871.35-1.669.916-2.243l.002-.002A3.084 3.084 0 0 1 8.683 0c.861 0 1.641.355 2.21.932v.002h.002c.565.574.914 1.372.914 2.243 0 .876-.35 1.667-.914 2.243l-.002.005a3.142 3.142 0 0 1-1.56.864v1.692zm8.121-1.129-.012-.019a1.452 1.452 0 0 0-.87-.668 1.43 1.43 0 0 0-1.103.146h.002c-.347.2-.58.529-.677.896-.095.365-.054.768.146 1.119l.007.009c.2.347.519.579.874.673.357.103.755.059 1.098-.144l.019-.009a1.47 1.47 0 0 0 .657-.885 1.493 1.493 0 0 0-.141-1.118"/></svg>`, lw = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
  <path d="M15.027 20.771h-12.881c-0.484-1.541-0.724-3.151-0.719-4.771 0-1.667 0.24-3.265 0.719-4.771h21.147c2.64-0.011 4.781 2.131 4.776 4.771 0.015 2.625-2.109 4.765-4.735 4.771zM14.427 22.375h-11.692c1.229 2.823 3.265 5.224 5.853 6.907 2.589 1.719 5.636 2.636 8.745 2.625 5.531 0 10.375-2.828 13.24-7.068-1.521-1.573-3.609-2.469-5.803-2.479zM24.771 9.64c2.271 0 4.333-0.957 5.803-2.468-3.24-4.828-8.855-7.511-14.652-7-5.791 0.516-10.848 4.14-13.187 9.468z"/>
</svg>`, aw = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg width="800px" height="800px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fill="none"><path fill="#000000" d="M12.549 1h-4.55l1.407 4.38h4.548l-3.68 2.61 1.406 4.405c2.37-1.725 3.143-4.336 2.274-7.016L12.55 1zM2.045 5.38h4.55L8 1H3.45L2.045 5.38c-.868 2.68-.094 5.29 2.275 7.015L5.725 7.99l-3.68-2.612zm2.275 7.015L8 15l3.68-2.605L8 9.745l-3.68 2.65z"/></svg>`, cw = `<?xml version="1.0" encoding="utf-8"?><!-- Uploaded to: SVG Repo, www.svgrepo.com, Generator: SVG Repo Mixer Tools -->
<svg fill="#000000" width="800px" height="800px" viewBox="0 -2 28 28" xmlns="http://www.w3.org/2000/svg"><path d="m27.994 14.729c-.012.267-.365.566-1.091.945-1.495.778-9.236 3.967-10.883 4.821-.589.419-1.324.67-2.116.67-.641 0-1.243-.164-1.768-.452l.019.01c-1.304-.622-9.539-3.95-11.023-4.659-.741-.35-1.119-.653-1.132-.933v2.83c0 .282.39.583 1.132.933 1.484.709 9.722 4.037 11.023 4.659.504.277 1.105.44 1.744.44.795 0 1.531-.252 2.132-.681l-.011.008c1.647-.859 9.388-4.041 10.883-4.821.76-.396 1.096-.7 1.096-.982s0-2.791 0-2.791z"/><path d="m27.992 10.115c-.013.267-.365.565-1.09.944-1.495.778-9.236 3.967-10.883 4.821-.59.421-1.326.672-2.121.672-.639 0-1.24-.163-1.763-.449l.019.01c-1.304-.627-9.539-3.955-11.023-4.664-.741-.35-1.119-.653-1.132-.933v2.83c0 .282.39.583 1.132.933 1.484.709 9.721 4.037 11.023 4.659.506.278 1.108.442 1.749.442.793 0 1.527-.251 2.128-.677l-.011.008c1.647-.859 9.388-4.043 10.883-4.821.76-.397 1.096-.7 1.096-.984s0-2.791 0-2.791z"/><path d="m27.992 5.329c.014-.285-.358-.534-1.107-.81-1.451-.533-9.152-3.596-10.624-4.136-.528-.242-1.144-.383-1.794-.383-.734 0-1.426.18-2.035.498l.024-.012c-1.731.622-9.924 3.835-11.381 4.405-.729.287-1.086.552-1.073.834v2.83c0 .282.39.583 1.132.933 1.484.709 9.721 4.038 11.023 4.66.504.277 1.105.439 1.744.439.795 0 1.531-.252 2.133-.68l-.011.008c1.647-.859 9.388-4.043 10.883-4.821.76-.397 1.096-.7 1.096-.984s0-2.791 0-2.791h-.009zm-17.967 2.684 6.488-.996-1.96 2.874zm14.351-2.588-4.253 1.68-3.835-1.523 4.246-1.679 3.838 1.517zm-11.265-2.785-.628-1.157 1.958.765 1.846-.604-.499 1.196 1.881.7-2.426.252-.543 1.311-.879-1.457-2.8-.252 2.091-.754zm-4.827 1.632c1.916 0 3.467.602 3.467 1.344s-1.559 1.344-3.467 1.344-3.474-.603-3.474-1.344 1.553-1.344 3.474-1.344z"/></svg>`, ph = {
    actor: Pv,
    boundary: Fv,
    control: Dv,
    database: Bv,
    entity: $v,
    cloudwatch: Hv,
    cloudfront: Uv,
    cognito: Vv,
    dynamodb: zv,
    ebs: Gv,
    ec2: jv,
    ecs: Zv,
    efs: ru,
    elasticache: Wv,
    elasticbeantalk: qv,
    elasticfilesystem: ru,
    glacier: Kv,
    iam: Yv,
    kinesis: Xv,
    lambda: Qv,
    lightsail: Jv,
    rds: eb,
    redshift: tb,
    s3: nb,
    sns: rb,
    sqs: sb,
    sagemaker: ib,
    vpc: ob,
    azureactivedirectory: lb,
    azurebackup: ab,
    azurecdn: cb,
    azuredatafactory: ub,
    azuredevops: hb,
    azurefunction: db,
    azuresql: fb,
    cosmosdb: pb,
    logicapps: gb,
    virtualmachine: mb,
    bigtable: xb,
    bigquery: Lb,
    cloudcdn: _b,
    clouddns: yb,
    cloudinterconnect: Cb,
    cloudloadbalancing: vb,
    cloudsql: bb,
    cloudstorage: wb,
    datalab: Eb,
    dataproc: Tb,
    googleiam: Sb,
    googlesecurity: Ab,
    googlevpc: kb,
    pubsub: Rb,
    securityscanner: Ob,
    stackdriver: Ib,
    visionapi: Mb,
    client: Nb,
    server: Pb,
    browser: Fb,
    service: Db,
    controller: Bb,
    api: $b,
    ui: Hb,
    mobile: Ub,
    externalsystem: Vb,
    application: zb,
    loadbalancer: Gb,
    network: jb,
    cache: Zb,
    webserver: Wb,
    messagequeue: qb,
    scheduler: Kb,
    gateway: Yb,
    authenticationservice: Xb,
    mailserver: Qb,
    github: Jb,
    docker: ew,
    gitlab: tw,
    jenkins: nw,
    postgresql: rw,
    mongodb: sw,
    kubernetes: iw,
    apachekafka: ow,
    elasticsearch: lw,
    auth0: aw,
    redis: cw
  };
  function gh() {
    const t10 = ge(0), e10 = ge(0), n10 = () => {
      t10.value = document.documentElement.scrollTop, e10.value = document.documentElement.scrollLeft;
    };
    return We$1(() => {
      n10(), document.addEventListener("scroll", n10);
    }), ht(() => {
      document.removeEventListener("scroll", n10);
    }), [t10, e10];
  }
  const ol = 10, uw = 1;
  function hw() {
    let t10 = document.getElementById(
      "zenuml-intersection-detector-container"
    ), e10 = Array.from(
      document.getElementsByClassName("zenuml-intersection-detector")
    );
    return t10 && e10.length === ol ? { detectorContainer: t10, detectors: e10 } : (t10 = document.createElement("div"), t10.id = "zenuml-intersection-detector-container", Object.assign(t10.style, {
      position: "absolute",
      top: "0",
      left: "0",
      opacity: "0",
      pointerEvents: "none"
    }), e10 = new Array(ol).fill(0).map(() => {
      const n10 = document.createElement("div");
      return n10.className = "zenuml-intersection-detector", Object.assign(n10.style, {
        position: "absolute",
        top: "0",
        left: "0",
        width: "100%"
      }), t10.appendChild(n10), n10;
    }), document.body.appendChild(t10), { detectorContainer: t10, detectors: e10 });
  }
  function mh() {
    const t10 = ge(0);
    let e10;
    return We$1(() => {
      const { detectorContainer: n10, detectors: r10 } = hw(), s10 = document.documentElement.scrollHeight, i10 = document.documentElement.scrollWidth;
      n10.style.height = s10 + "px", n10.style.width = i10 + "px";
      const o10 = Math.ceil(
        document.documentElement.scrollHeight / ol
      ), l10 = [...Array(o10 + 1).keys()].map(
        (a10) => a10 / o10
      );
      r10.forEach((a10, c10) => {
        a10.style.top = c10 * o10 + "px", a10.style.height = o10 + "px";
      }), e10 = new IntersectionObserver(
        ([a10]) => {
          (a10.intersectionRect.top - a10.boundingClientRect.top > uw || a10.target === r10[0]) && (t10.value = a10.intersectionRect.top);
        },
        {
          threshold: l10
        }
      ), r10.forEach((a10) => {
        e10.observe(a10);
      });
    }), ht(() => {
      e10.disconnect();
    }), t10;
  }
  function xh(t10) {
    let e10 = 0, n10 = t10;
    for (; n10; )
      e10 += n10.offsetTop, n10 = n10.offsetParent;
    return e10;
  }
  const dw = 10, fw = {
    name: "Participant",
    setup(t10) {
      const e10 = Fn(), n10 = ge(null);
      if (e10.state.mode === Gn.Static)
        return { translate: 0, participant: n10 };
      const r10 = mh(), [s10] = gh();
      return { translate: G$1(() => {
        var u10;
        const o10 = t10.offsetTop || 0;
        let l10 = r10.value + s10.value;
        r10.value > dw && (e10 == null ? void 0 : e10.state.stickyOffset) && (l10 += e10 == null ? void 0 : e10.state.stickyOffset);
        const a10 = ((u10 = e10 == null ? void 0 : e10.state.diagramElement) == null ? void 0 : u10.clientHeight) || 0, c10 = e10 != null && e10.state.diagramElement ? xh(e10 == null ? void 0 : e10.state.diagramElement) : 0;
        return l10 < o10 + c10 ? 0 : Math.min(l10 - c10, a10 - ov) - o10;
      }), participant: n10 };
    },
    props: {
      entity: {
        type: Object,
        required: true
      },
      offsetTop: {
        type: Number,
        default: 0
      }
    },
    data() {
      return {
        color: void 0
      };
    },
    mounted() {
      this.updateFontColor();
    },
    updated() {
      this.updateFontColor();
    },
    computed: {
      selected() {
        return this.$store.state.selected.includes(this.entity.name);
      },
      stereotype() {
        return this.entity.stereotype;
      },
      comment() {
        return this.entity.comment;
      },
      icon() {
        var t10;
        return ph[(t10 = this.entity.type) == null ? void 0 : t10.toLowerCase()];
      },
      backgroundColor() {
        try {
          return this.entity.color ? this.entity.color && Nv(this.entity.color) : void 0;
        } catch {
          return;
        }
      }
    },
    methods: {
      onSelect() {
        this.$store.commit("onSelect", this.entity.name);
      },
      updateFontColor() {
        if (!this.backgroundColor)
          return;
        let t10 = window.getComputedStyle(this.$refs.participant).getPropertyValue("background-color");
        if (!t10)
          return;
        let e10 = Mv(t10);
        this.color = e10 > 128 ? "#000" : "#fff";
      }
    }
  }, pw = ["innerHTML", "alt"], gw = { class: "h-5 group flex flex-col justify-center" }, mw = {
    key: 0,
    class: "absolute hidden rounded-lg transform -translate-y-8 bg-gray-400 px-2 py-1 text-center text-sm text-white group-hover:flex"
  }, xw = {
    key: 1,
    class: "interface leading-4"
  }, Lw = { class: "name leading-4" };
  function _w(t10, e10, n10, r10, s10, i10) {
    return k$1(), q$1("div", {
      class: ve$1(["participant bg-skin-participant shadow-participant border-skin-participant text-skin-participant rounded text-base leading-4 flex flex-col justify-center z-10 h-10 top-8", { selected: i10.selected }]),
      ref: "participant",
      style: Ce$1({
        backgroundColor: i10.backgroundColor,
        color: s10.color,
        transform: `translateY(${r10.translate}px)`
      }),
      onClick: e10[0] || (e10[0] = (...o10) => i10.onSelect && i10.onSelect(...o10))
    }, [
      i10.icon ? (k$1(), q$1("div", {
        key: 0,
        innerHTML: i10.icon,
        class: "absolute left-1/2 transform -translate-x-1/2 -translate-y-full h-8 [&>svg]:w-full [&>svg]:h-full",
        alt: `icon for ${n10.entity.name}`
      }, null, 8, pw)) : xe$1("", true),
      A("div", gw, [
        i10.comment ? (k$1(), q$1("span", mw, Ve$1(i10.comment), 1)) : xe$1("", true),
        i10.stereotype ? (k$1(), q$1("label", xw, "«" + Ve$1(i10.stereotype) + "»", 1)) : xe$1("", true),
        A("label", Lw, Ve$1(n10.entity.label || n10.entity.name), 1)
      ])
    ], 6);
  }
  const Lh = /* @__PURE__ */ ze$1(fw, [["render", _w]]);
  const Zs = b0.child({ name: "LifeLine" }), yw = {
    name: "life-line",
    components: { Participant: Lh },
    props: [
      "entity",
      "context",
      "groupLeft",
      "inGroup",
      "renderParticipants",
      "renderLifeLine"
    ],
    data: () => ({
      translateX: 0,
      top: 0
    }),
    computed: {
      ...pn$1(["centerOf"]),
      ...yr(["scale"]),
      debug() {
        return !!localStorage.zenumlDebug;
      },
      left() {
        return this.centerOf(this.entity.name) - 8 - (this.groupLeft || 0);
      }
    },
    mounted() {
      Zs.debug(`LifeLine mounted for ${this.entity.name}`), this.$nextTick(() => {
        this.setTop(), Zs.debug(`nextTick after updated for ${this.entity.name}`);
      }), ac.$on(
        "participant_set_top",
        () => this.$nextTick(() => this.setTop())
      );
    },
    updated() {
      Zs.debug(`updated for ${this.entity.name}`), this.$nextTick(() => {
        this.setTop(), Zs.debug(`nextTick after updated for ${this.entity.name}`);
      });
    },
    methods: {
      onSelect() {
        this.$store.commit("onSelect", this.entity.name);
      },
      setTop() {
        const t10 = this.entity.name.replace(
          /([ #;&,.+*~\':"!^$[\]()=>|\/@])/g,
          "\\$1"
        ), e10 = this.$store.getters.diagramElement, n10 = e10 == null ? void 0 : e10.querySelector(`[data-to="${t10}"]`), r10 = (n10 == null ? void 0 : n10.offsetParent) != null;
        if (n10 && n10.attributes["data-type"].value === "creation" && r10) {
          Zs.debug(`First message to ${this.entity.name} is creation`);
          const s10 = this.$el.getBoundingClientRect().y, i10 = n10.getBoundingClientRect().y;
          this.top = (i10 - s10) / this.scale;
        } else
          this.top = 0;
      }
    }
  }, Cw = ["id", "entity-type"], vw = {
    key: 1,
    class: "line w0 mx-auto flex-grow w-px"
  };
  function bw(t10, e10, n10, r10, s10, i10) {
    var l10;
    const o10 = me$1("participant");
    return k$1(), q$1("div", {
      id: n10.entity.name,
      "entity-type": (l10 = n10.entity.type) == null ? void 0 : l10.toLowerCase(),
      class: "lifeline absolute flex flex-col mx-2 transform -translate-x-1/2 h-full",
      style: Ce$1({ paddingTop: t10.top + "px", left: i10.left + "px" })
    }, [
      a1(A("div", null, Ve$1(t10.centerOf(n10.entity.name)), 513), [
        [N0, i10.debug]
      ]),
      n10.renderParticipants ? (k$1(), Re$1(o10, {
        key: 0,
        entity: n10.entity,
        offsetTop: t10.top
      }, null, 8, ["entity", "offsetTop"])) : xe$1("", true),
      n10.renderLifeLine ? (k$1(), q$1("div", vw)) : xe$1("", true)
    ], 12, Cw);
  }
  const _h = /* @__PURE__ */ ze$1(yw, [["render", bw], ["__scopeId", "data-v-19661715"]]), ww = {
    name: "lifeline-group",
    props: ["context", "renderParticipants"],
    computed: {
      ...pn$1(["centerOf"]),
      name() {
        var t10, e10;
        return (e10 = (t10 = this.context) == null ? void 0 : t10.name()) == null ? void 0 : e10.getFormattedText();
      },
      offset() {
        return 0;
      },
      left() {
        const t10 = this.entities[0].name, e10 = Math.max(
          _0(t10, Lr.ParticipantName),
          "100"
        );
        return this.centerOf(t10) - e10 / 2 - 8;
      },
      right() {
        const t10 = Math.max(
          _0(
            this.entities.slice(-1).name,
            Lr.ParticipantName
          ),
          "100"
        ), e10 = this.entities.slice(0).pop().name;
        return this.centerOf(e10) + t10 / 2 + 20;
      },
      entities() {
        return Ds(this.context).Array();
      }
    },
    components: {
      LifeLine: _h
    }
  }, Ew = { class: "lifeline-group relative flex-grow" };
  function Tw(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("life-line");
    return i10.entities.length > 0 ? (k$1(), q$1("div", {
      key: 0,
      class: "container absolute flex flex-col h-full",
      style: Ce$1({ left: `${i10.left}px`, width: `${i10.right - i10.left}px` })
    }, [
      A("div", {
        class: ve$1(["flex flex-col flex-grow", {
          shadow: !n10.renderParticipants,
          "shadow-slate-500/50": !n10.renderParticipants
        }])
      }, [
        A("div", Ew, [
          (k$1(true), q$1(Fe$1, null, On$1(i10.entities, (l10) => (k$1(), Re$1(o10, {
            inGroup: "true",
            key: l10.name,
            ref_for: true,
            ref: l10.name,
            entity: l10,
            "group-left": i10.left,
            renderParticipants: n10.renderParticipants
          }, null, 8, ["entity", "group-left", "renderParticipants"]))), 128))
        ])
      ], 2)
    ], 4)) : xe$1("", true);
  }
  const Sw = /* @__PURE__ */ ze$1(ww, [["render", Tw]]), su = b0.child({ name: "LifeLineLayer" }), Aw = 70, kw = 10, Rw = {
    name: "life-line-layer",
    props: ["context", "renderParticipants", "renderLifeLine", "leftGap"],
    setup() {
      const e10 = Fn(), n10 = G$1(() => e10.state.mode);
      if (n10.value === Gn.static)
        return { translate: 0, RenderMode: Gn, mode: n10 };
      const r10 = mh(), [s10] = gh();
      return { translate: G$1(() => {
        var c10;
        let o10 = r10.value + s10.value;
        r10.value > kw && (e10 == null ? void 0 : e10.state.stickyOffset) && (o10 += e10 == null ? void 0 : e10.state.stickyOffset);
        const l10 = ((c10 = e10 == null ? void 0 : e10.state.diagramElement) == null ? void 0 : c10.clientHeight) || 0, a10 = e10 != null && e10.state.diagramElement ? xh(e10 == null ? void 0 : e10.state.diagramElement) : 0;
        return o10 <= 0 + a10 ? 0 : Math.min(o10 - a10, l10 - Aw) - 0;
      }), RenderMode: Gn, mode: n10 };
    },
    computed: {
      ...pn$1([
        "participants",
        "GroupContext",
        "ParticipantContext",
        "centerOf"
      ]),
      debug() {
        return !!localStorage.zenumlDebug;
      },
      invisibleStarter() {
        return this.starterParticipant.name === "_STARTER_";
      },
      starterParticipant() {
        return this.participants.Starter();
      },
      starterOnTheLeft() {
        return !this.starterParticipant.explicit;
      },
      implicitParticipants() {
        return this.participants.ImplicitArray();
      },
      explicitGroupAndParticipants() {
        var t10;
        return (t10 = this.context) == null ? void 0 : t10.children.filter((e10) => {
          const n10 = e10 instanceof sh, r10 = e10 instanceof ih;
          return n10 || r10;
        });
      }
    },
    methods: {
      ...V5(["increaseGeneration"]),
      getParticipantEntity(t10) {
        return Ds(t10).First();
      }
    },
    updated() {
      su.debug("LifeLineLayer updated");
    },
    mounted() {
      su.debug("LifeLineLayer mounted");
    },
    components: {
      LifeLine: _h,
      LifeLineGroup: Sw
    }
  }, Ow = { class: "container relative grow" };
  function Iw(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("life-line"), l10 = me$1("life-line-group");
    return k$1(), q$1("div", {
      class: "life-line-layer lifeline-layer z-30 absolute h-full flex flex-col top-0",
      style: Ce$1({
        "min-width": r10.mode === r10.RenderMode.Dynamic ? "200px" : "auto",
        width: `calc(100% - ${n10.leftGap}px)`,
        pointerEvents: n10.renderParticipants ? "none" : "all"
      })
    }, [
      A("div", {
        style: Ce$1({
          transform: `translateY(${r10.translate > 0 ? r10.translate - 1 : r10.translate}px)`
        }),
        class: "pt-8 after:bg-gradient-to-b after:from-skin-frame after:via-skin-frame after:to-skin-frame/0 after:block after:absolute after:top-0 after:w-full after:h-[72px]"
      }, null, 4),
      A("div", Ow, [
        i10.starterOnTheLeft ? (k$1(), Re$1(o10, {
          key: 0,
          entity: i10.starterParticipant,
          class: ve$1(["starter", { invisible: i10.invisibleStarter && !i10.debug }]),
          renderParticipants: n10.renderParticipants,
          renderLifeLine: n10.renderLifeLine
        }, null, 8, ["entity", "class", "renderParticipants", "renderLifeLine"])) : xe$1("", true),
        (k$1(true), q$1(Fe$1, null, On$1(i10.explicitGroupAndParticipants, (a10, c10) => (k$1(), q$1(Fe$1, null, [
          a10 instanceof t10.GroupContext ? (k$1(), Re$1(l10, {
            key: c10,
            context: a10,
            renderParticipants: n10.renderParticipants
          }, null, 8, ["context", "renderParticipants"])) : xe$1("", true),
          a10 instanceof t10.ParticipantContext ? (k$1(), Re$1(o10, {
            key: c10,
            entity: i10.getParticipantEntity(a10),
            renderParticipants: n10.renderParticipants,
            renderLifeLine: n10.renderLifeLine
          }, null, 8, ["entity", "renderParticipants", "renderLifeLine"])) : xe$1("", true)
        ], 64))), 256)),
        (k$1(true), q$1(Fe$1, null, On$1(i10.implicitParticipants, (a10) => (k$1(), Re$1(o10, {
          key: a10.name,
          entity: a10,
          renderParticipants: n10.renderParticipants,
          renderLifeLine: n10.renderLifeLine
        }, null, 8, ["entity", "renderParticipants", "renderLifeLine"]))), 128))
      ])
    ], 4);
  }
  const uo = /* @__PURE__ */ ze$1(Rw, [["render", Iw]]), Mw = { class: "message-layer relative z-30 pt-24 pb-10" }, iu = /* @__PURE__ */ Ye$1({
    __name: "MessageLayer",
    props: {
      context: null
    },
    setup(t10) {
      const e10 = t10, n10 = hs(() => Promise.resolve().then(() => StylePanel_5269dca2)), r10 = b0.child({ name: "MessageLayer" }), s10 = Fn(), i10 = G$1(() => s10.getters.participants), o10 = G$1(() => s10.getters.centerOf), l10 = G$1(() => {
        var g, L;
        const c10 = (g = e10.context) == null ? void 0 : g.stat()[0].message();
        if (!c10)
          return false;
        const u10 = c10 == null ? void 0 : c10.Owner(), h10 = c10 == null ? void 0 : c10.ProvidedFrom(), d10 = (L = e10.context) == null ? void 0 : L.Origin();
        return !u10 || u10 === (h10 || d10);
      }), a10 = G$1(() => {
        if (i10.value.Array().length >= 1) {
          const c10 = i10.value.Array().slice(0)[0].name;
          return o10.value(c10) + (l10.value ? 1 : 0);
        }
        return 0;
      });
      return We$1(() => {
        r10.debug("MessageLayer mounted");
      }), R0(() => {
        r10.debug("MessageLayer updated");
      }), (c10, u10) => {
        const h10 = me$1("block");
        return k$1(), q$1("div", Mw, [
          V$1(h10, {
            context: t10.context,
            style: Ce$1({ "padding-left": _e(a10) + "px" })
          }, null, 8, ["context", "style"]),
          V$1(_e(n10))
        ]);
      };
    }
  });
  const Nw = b.tree.ParseTreeWalker.DEFAULT;
  class uc extends w {
    constructor(n10) {
      super();
      W$1(this, "_orderedParticipants");
      W$1(this, "frameRoot", null);
      W$1(this, "parents", []);
      this._orderedParticipants = n10;
    }
    getLocalParticipants(n10) {
      return [
        n10.Origin(),
        ...Ds(n10).ImplicitArray().map((r10) => r10.name)
      ];
    }
    getLeft(n10) {
      const r10 = this.getLocalParticipants(n10);
      return this._orderedParticipants.find((s10) => r10.includes(s10)) || "";
    }
    getRight(n10) {
      return this._orderedParticipants.slice().reverse().find((r10) => this.getLocalParticipants(n10).includes(r10)) || "";
    }
    enterFragment(n10) {
      var s10;
      const r10 = {
        left: this.getLeft(n10),
        right: this.getRight(n10),
        children: []
      };
      this.frameRoot || (this.frameRoot = r10), this.parents.length > 0 && ((s10 = this.parents[this.parents.length - 1].children) == null || s10.push(r10)), this.parents.push(r10);
    }
    exitFragment() {
      this.parents.pop();
    }
    enterTcf(n10) {
      this.enterFragment(n10);
    }
    enterOpt(n10) {
      this.enterFragment(n10);
    }
    enterPar(n10) {
      this.enterFragment(n10);
    }
    enterAlt(n10) {
      this.enterFragment(n10);
    }
    enterLoop(n10) {
      this.enterFragment(n10);
    }
    exitTcf() {
      this.exitFragment();
    }
    exitOpt() {
      this.exitFragment();
    }
    exitPar() {
      this.exitFragment();
    }
    exitAlt() {
      this.exitFragment();
    }
    exitLoop() {
      this.exitFragment();
    }
    getFrame(n10) {
      return n10.children.map((r10) => {
        Nw.walk(this, r10);
      }), this.frameRoot;
    }
  }
  function ll(t10, e10) {
    if (!t10.children || t10.children.length === 0)
      return 1;
    let n10 = 0;
    for (const r10 of t10.children)
      e10 === "LEFT" && r10.left !== t10.left || e10 === "RIGHT" && r10.right !== t10.right || (n10 = Math.max(n10, ll(r10, e10)));
    return n10 + 1;
  }
  function hc(t10) {
    return t10 ? {
      left: 10 * ll(t10, "LEFT"),
      right: 10 * ll(t10, "RIGHT")
    } : { left: 0, right: 0 };
  }
  function yh(t10, e10) {
    const n10 = e10.orderedParticipantNames(), r10 = [t10.Origin(), ...Ds(t10).Names()], s10 = n10.find((u10) => r10.includes(u10)) || "", i10 = n10.slice().reverse().find((u10) => r10.includes(u10)) || "", l10 = new uc(n10).getFrame(t10), a10 = hc(l10), c10 = Pw(
      t10,
      i10,
      e10
    );
    return e10.distance(s10, i10) + a10.left + a10.right + e10.half(s10) + e10.half(i10) + c10;
  }
  function Pw(t10, e10, n10) {
    const s10 = ch(t10).filter((i10) => i10.from === i10.to).map(
      (i10) => _0(i10.signature, Lr.MessageContent) + 37 - n10.distance(i10.from, e10) - n10.half(e10)
    );
    return Math.max.apply(null, [0, ...s10]);
  }
  const dc = /* @__PURE__ */ Ye$1({
    __name: "SeqDiagram",
    setup(t10) {
      const e10 = Fn(), n10 = G$1(() => e10.state.mode), r10 = G$1(() => e10.getters.rootContext), s10 = G$1(() => e10.getters.coordinates), i10 = G$1(() => yh(r10.value, s10.value)), o10 = G$1(() => {
        const a10 = s10.value.orderedParticipantNames(), u10 = new uc(a10).getFrame(r10.value);
        return u10 ? hc(u10).left + il + 20 : 0;
      }), l10 = ge(null);
      return e10.commit("diagramElement", l10), (a10, c10) => (k$1(), q$1("div", {
        class: "zenuml sequence-diagram relative box-border text-left overflow-visible",
        ref_key: "diagramRef",
        ref: l10
      }, [
        A("div", {
          style: Ce$1({ paddingLeft: `${_e(o10)}px` }),
          class: "relative"
        }, [
          _e(n10) === _e(Gn).Dynamic ? (k$1(), q$1(Fe$1, { key: 0 }, [
            V$1(uo, {
              leftGap: _e(o10),
              context: _e(r10).head(),
              renderParticipants: false,
              renderLifeLine: true
            }, null, 8, ["leftGap", "context"]),
            V$1(iu, {
              context: _e(r10).block(),
              style: Ce$1({ width: `${_e(i10)}px` })
            }, null, 8, ["context", "style"]),
            V$1(uo, {
              leftGap: _e(o10),
              context: _e(r10).head(),
              renderParticipants: true,
              renderLifeLine: false
            }, null, 8, ["leftGap", "context"])
          ], 64)) : xe$1("", true),
          _e(n10) === _e(Gn).Static ? (k$1(), q$1(Fe$1, { key: 1 }, [
            V$1(uo, {
              leftGap: _e(o10),
              context: _e(r10).head(),
              renderParticipants: true,
              renderLifeLine: true
            }, null, 8, ["leftGap", "context"]),
            V$1(iu, {
              context: _e(r10).block(),
              style: Ce$1({ width: `${_e(i10)}px` })
            }, null, 8, ["context", "style"])
          ], 64)) : xe$1("", true)
        ], 4)
      ], 512));
    }
  });
  const Fw = {
    name: "IconList",
    props: ["types"],
    computed: {},
    methods: {
      icon(t10) {
        return ph[t10 == null ? void 0 : t10.toLowerCase()];
      }
    }
  }, Dw = {
    role: "list",
    class: "mt-3 grid grid-cols-4 gap-5 sm:gap-6 sm:grid-cols-6 lg:grid-cols-8"
  }, Bw = { class: "h-12 flex items-center justify-center bg-gray-50 text-white text-sm font-medium rounded-t-md" }, $w = ["innerHTML", "alt"], Hw = { class: "flex items-center justify-center border-t border-r border-b border-gray-200 bg-white rounded-b-md" }, Uw = { class: "px-2 py-2 text-xs" }, Vw = { class: "text-gray-900 font-medium hover:text-gray-600" };
  function zw(t10, e10, n10, r10, s10, i10) {
    return k$1(), q$1("ul", Dw, [
      (k$1(true), q$1(Fe$1, null, On$1(n10.types, (o10) => (k$1(), q$1("li", {
        key: o10,
        class: "col-span-1 flex flex-col shadow-sm rounded-md"
      }, [
        A("div", Bw, [
          i10.icon ? (k$1(), q$1("i", {
            key: 0,
            innerHTML: i10.icon(o10),
            class: "object-contain h-8 w-8 m-auto [&>svg]:w-full [&>svg]:h-full",
            alt: `icon for ${o10}`
          }, null, 8, $w)) : xe$1("", true)
        ]),
        A("div", Hw, [
          A("div", Uw, [
            A("span", Vw, "@" + Ve$1(o10), 1)
          ])
        ])
      ]))), 128))
    ]);
  }
  const Gw = /* @__PURE__ */ ze$1(Fw, [["render", zw]]), jw = {
    name: "TipsDialog",
    components: { Icon: dr, IconList: Gw },
    computed: {
      standardTypes() {
        return ["Actor", "Boundary", "Control", "Database", "Entity"];
      },
      awsServices() {
        return [
          "CloudWatch",
          "CloudFront",
          "Cognito",
          "DynamoDB",
          "EBS",
          "EC2",
          "ECS",
          "EFS",
          "ElastiCache",
          "ElasticBeantalk",
          "ElasticFileSystem",
          "Glacier",
          "IAM",
          "Kinesis",
          "Lambda",
          "LightSail",
          "RDS",
          "Redshift",
          "S3",
          "SNS",
          "SQS",
          "Sagemaker",
          "VPC"
        ];
      },
      azureServices() {
        return [
          "AzureActiveDirectory",
          "AzureBackup",
          "AzureCDN",
          "AzureDataFactory",
          "AzureDevOps",
          "AzureFunction",
          "AzureSQL",
          "CosmosDB",
          "LogicApps",
          "VirtualMachine"
        ];
      },
      googleServices() {
        return [
          "BigTable",
          "BigQuery",
          "CloudCDN",
          "CloudDNS",
          "CloudInterconnect",
          "CloudLoadBalancing",
          "CloudSQL",
          "CloudStorage",
          "DataLab",
          "DataProc",
          "GoogleIAM",
          "GoogleSecurity",
          "GoogleVPC",
          "PubSub",
          "SecurityScanner",
          "StackDriver",
          "VisionAPI"
        ];
      }
    },
    methods: {
      closeTipsDialog() {
        var t10;
        this.$store.state.showTips = false;
        try {
          (t10 = this.$gtag) == null || t10.event("close", {
            event_category: "help",
            event_label: "tips dialog"
          });
        } catch (e10) {
          console.error(e10);
        }
      }
    }
  }, Zw = { class: "flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block" }, Ww = /* @__PURE__ */ A("div", {
    class: "fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity",
    "aria-hidden": "true"
  }, null, -1), qw = /* @__PURE__ */ A("span", {
    class: "hidden sm:inline-block sm:align-middle sm:h-screen",
    "aria-hidden": "true"
  }, "​", -1), Kw = { class: "z-40 inline-block align-bottom bg-white rounded-lg px-4 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:p-2" }, Yw = {
    class: "bg-white px-4 py-5 border-b border-gray-200 sm:px-6",
    slot: "header"
  }, Xw = /* @__PURE__ */ A("h3", { class: "text-xl leading-6 font-medium text-gray-900 inline-block" }, " ZenUML Tips ", -1), Qw = /* @__PURE__ */ A("span", { class: "sr-only" }, "Close menu", -1), Jw = { slot: "body" }, eE = { class: "relative bg-white pb-32 mt-4 overflow-hidden" }, tE = { class: "relative" }, nE = { class: "lg:mx-auto lg:max-w-11/12 lg:px-8" }, rE = /* @__PURE__ */ h1(`<div class="grid lg:grid-cols-3 sm:grid-cols-2 grid-cols-1"><div><div class="px-4 max-w-full mx-auto sm:px-6 lg:max-w-none lg:mx-0"><h2 class="mt-4 mb-4 text-lg leading-6 font-medium text-gray-900"> Declare Participants </h2><pre class="text-xs w-full bg-gray-50 text-gray-600 p-2 rounded-lg"><code>// Define a Starter (optional)
@Starter(A)

// Show icons
@EC2 A

// Use &#39;group&#39; keyword
group GroupName {  B  C }

// Use stereotype
&lt;&lt;servlet&gt;&gt; ServiceX</code></pre></div><div class="px-4 max-w-7xl mx-auto sm:px-6 lg:max-w-none lg:mx-0"><h2 class="mt-4 mb-4 text-lg leading-6 font-medium text-gray-900"> Divider </h2><pre class="text-xs w-full bg-gray-50 text-gray-600 p-2 rounded-lg"><code>A.method()
==divider name==
B.method()
</code></pre></div></div><div class="px-4 w-full mx-auto lg:max-w-none lg:mx-0"><h2 class="mt-4 mb-4 text-lg leading-6 font-medium text-gray-900"> Fragments </h2><pre class="text-xs w-full bg-gray-50 text-gray-600 p-2 rounded-lg"><code>// Alt (AKA if/else)
if(condition1) {}
else if (condition2) {}
else {}

// \`loop\`, \`for\`, \`forEach\`, \`while\`
// are treated the same
forEach(records) {}

// Opt
opt {}

// Par
par {}

// Try Catch Finally
try {} catch() {} finally {}
</code></pre></div><div class="px-4 w-full mx-auto lg:max-w-none lg:mx-0"><h2 class="mt-4 mb-4 text-lg leading-6 font-medium text-gray-900"> Messages </h2><pre class="text-xs w-full bg-gray-50 text-gray-600 p-2 rounded-lg"><code>//Creation
new ParticipantName()

//Sync Message
A.method
A-&gt;B.method

//Async Message
A-&gt;B: async message

//Reply Message, three styles
x = A.method
A.method() {
  return x
}
A.method() {
  @return A-&gt;B: message
}</code></pre></div></div>`, 1), sE = { class: "px-4 max-w-7xl mx-auto sm:px-6 lg:max-w-none lg:mx-0" }, iE = /* @__PURE__ */ A("h2", { class: "mt-8 mb-4 text-lg leading-6 font-medium text-gray-900" }, " Builtin Icons ", -1), oE = /* @__PURE__ */ A("p", { class: "text-sm text-gray-500" }, [
    /* @__PURE__ */ dn$1(" Use "),
    /* @__PURE__ */ A("span", { class: "rounded inline-block bg-gray-50 text-gray-600" }, [
      /* @__PURE__ */ A("code", { class: "text-xs" }, "@Actor TheParticipant")
    ]),
    /* @__PURE__ */ dn$1(" to define the type of the participant. ")
  ], -1), lE = /* @__PURE__ */ A("hr", { class: "mt-4" }, null, -1), aE = /* @__PURE__ */ A("hr", { class: "mt-4" }, null, -1), cE = /* @__PURE__ */ A("hr", { class: "mt-4" }, null, -1);
  function uE(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("Icon"), l10 = me$1("IconList");
    return k$1(), q$1("div", Zw, [
      Ww,
      qw,
      A("div", Kw, [
        A("div", null, [
          A("div", Yw, [
            Xw,
            A("button", {
              type: "button",
              onClick: e10[0] || (e10[0] = (a10) => i10.closeTipsDialog()),
              class: "float-right bg-white rounded-md inline-flex items-center justify-center text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500"
            }, [
              Qw,
              V$1(o10, {
                name: "close",
                "icon-class": "h-6 w-6"
              })
            ])
          ]),
          A("div", Jw, [
            A("div", eE, [
              A("div", tE, [
                A("div", nE, [
                  rE,
                  A("div", sE, [
                    iE,
                    oE,
                    V$1(l10, { types: i10.standardTypes }, null, 8, ["types"]),
                    lE,
                    V$1(l10, { types: i10.awsServices }, null, 8, ["types"]),
                    aE,
                    V$1(l10, { types: i10.azureServices }, null, 8, ["types"]),
                    cE,
                    V$1(l10, { types: i10.googleServices }, null, 8, ["types"])
                  ])
                ])
              ])
            ])
          ])
        ])
      ])
    ]);
  }
  const hE = /* @__PURE__ */ ze$1(jw, [["render", uE]]);
  const dE = {
    name: "point",
    props: ["fill", "rtl"]
  }, Ch = (t10) => (Ss("data-v-de6521b0"), t10 = t10(), As(), t10), fE = {
    key: 0,
    class: "arrow stroke-2",
    height: "10",
    width: "10"
  }, pE = /* @__PURE__ */ Ch(() => /* @__PURE__ */ A("polyline", {
    class: "right head fill-current stroke-current",
    points: "0,0 10,5 0,10"
  }, null, -1)), gE = [
    pE
  ], mE = {
    key: 1,
    class: "arrow stroke-2",
    height: "10",
    width: "10"
  }, xE = /* @__PURE__ */ Ch(() => /* @__PURE__ */ A("polyline", {
    class: "left head fill-current stroke-current",
    points: "10,0 0,5 10,10"
  }, null, -1)), LE = [
    xE
  ];
  function _E(t10, e10, n10, r10, s10, i10) {
    return k$1(), q$1("div", {
      class: ve$1(["point text-skin-message-arrow", { fill: n10.fill, "no-fill": !n10.fill, "right-to-left": n10.rtl }])
    }, [
      n10.rtl ? xe$1("", true) : (k$1(), q$1("svg", fE, gE)),
      n10.rtl ? (k$1(), q$1("svg", mE, LE)) : xe$1("", true)
    ], 2);
  }
  const yE = /* @__PURE__ */ ze$1(dE, [["render", _E], ["__scopeId", "data-v-de6521b0"]]), CE = { class: "name group flex-grow text-sm hover:whitespace-normal hover:text-skin-message-hover hover:bg-skin-message-hover" }, vE = { class: "inline-block relative min-h-[1em]" }, bE = {
    key: 0,
    class: "absolute right-[100%] top-0 pr-1 group-hover:hidden text-gray-500"
  }, G0 = /* @__PURE__ */ Ye$1({
    __name: "Message",
    props: {
      context: null,
      content: null,
      rtl: { type: [String, Boolean] },
      type: null,
      textStyle: null,
      classNames: null,
      number: null
    },
    setup(t10) {
      const e10 = t10, { context: n10, content: r10, rtl: s10, type: i10, textStyle: o10, classNames: l10, number: a10 } = Rl(e10), c10 = Fn(), u10 = ge(), h10 = G$1(() => c10.state.numbering), d10 = G$1(() => (i10 == null ? void 0 : i10.value) === "async"), p10 = G$1(() => {
        switch (i10 == null ? void 0 : i10.value) {
          case "sync":
          case "async":
            return "solid";
          case "creation":
          case "return":
            return "dashed";
        }
        return "";
      }), g = G$1(() => {
        switch (i10 == null ? void 0 : i10.value) {
          case "sync":
          case "async":
            return true;
          case "creation":
          case "return":
            return false;
        }
        return false;
      }), L = () => {
        c10.getters.onMessageClick(n10, u10.value);
      };
      return (T, _10) => (k$1(), q$1("div", {
        class: ve$1(["message border-skin-message-arrow border-b-2 flex items-end", {
          "flex-row-reverse": _e(s10),
          return: _e(i10) === "return",
          "right-to-left": _e(s10),
          "text-left": _e(d10),
          "text-center": !_e(d10)
        }]),
        style: Ce$1({ "border-bottom-style": _e(p10) || void 0 }),
        onClick: L,
        ref_key: "messageRef",
        ref: u10
      }, [
        A("div", CE, [
          A("div", vE, [
            A("div", {
              style: Ce$1(_e(o10)),
              class: ve$1(_e(l10))
            }, Ve$1(_e(r10)), 7),
            _e(h10) ? (k$1(), q$1("div", bE, Ve$1(_e(a10)), 1)) : xe$1("", true)
          ])
        ]),
        V$1(yE, {
          class: "flex-shrink-0 transform translate-y-1/2 -my-px",
          fill: _e(g),
          rtl: _e(s10)
        }, null, 8, ["fill", "rtl"])
      ], 6));
    }
  }), wE = {
    name: "WidthProvider",
    components: { Message: G0 },
    data: function() {
      return {
        text: "abcd"
      };
    },
    methods: {
      width: function(t10, e10) {
        return console.log(t10, e10), this.text = t10, this.$el.clientWidth;
      }
    },
    mounted() {
      this.$store.state.widthProvider = this;
    }
  }, EE = { class: "hidden" };
  function TE(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("message");
    return k$1(), q$1("div", EE, [
      V$1(o10, {
        content: t10.text,
        rtl: "false",
        type: "sync"
      }, null, 8, ["content"])
    ]);
  }
  const SE = /* @__PURE__ */ ze$1(wE, [["render", TE]]);
  function AE(t10, e10) {
    if (t10.match(/^[a-z]+:\/\//i))
      return t10;
    if (t10.match(/^\/\//))
      return window.location.protocol + t10;
    if (t10.match(/^[a-z]+:/i))
      return t10;
    const n10 = document.implementation.createHTMLDocument(), r10 = n10.createElement("base"), s10 = n10.createElement("a");
    return n10.head.appendChild(r10), n10.body.appendChild(s10), e10 && (r10.href = e10), s10.href = t10, s10.href;
  }
  const kE = (() => {
    let t10 = 0;
    const e10 = () => `0000${(Math.random() * 36 ** 4 << 0).toString(36)}`.slice(-4);
    return () => (t10 += 1, `u${e10()}${t10}`);
  })();
  function _r(t10) {
    const e10 = [];
    for (let n10 = 0, r10 = t10.length; n10 < r10; n10++)
      e10.push(t10[n10]);
    return e10;
  }
  function Vi(t10, e10) {
    const r10 = (t10.ownerDocument.defaultView || window).getComputedStyle(t10).getPropertyValue(e10);
    return r10 ? parseFloat(r10.replace("px", "")) : 0;
  }
  function RE(t10) {
    const e10 = Vi(t10, "border-left-width"), n10 = Vi(t10, "border-right-width");
    return t10.clientWidth + e10 + n10;
  }
  function OE(t10) {
    const e10 = Vi(t10, "border-top-width"), n10 = Vi(t10, "border-bottom-width");
    return t10.clientHeight + e10 + n10;
  }
  function vh(t10, e10 = {}) {
    const n10 = e10.width || RE(t10), r10 = e10.height || OE(t10);
    return { width: n10, height: r10 };
  }
  function IE() {
    let t10, e10;
    try {
      e10 = process;
    } catch {
    }
    const n10 = e10 && e10.env ? e10.env.devicePixelRatio : null;
    return n10 && (t10 = parseInt(n10, 10), Number.isNaN(t10) && (t10 = 1)), t10 || window.devicePixelRatio || 1;
  }
  const Gt$1 = 16384;
  function ME(t10) {
    (t10.width > Gt$1 || t10.height > Gt$1) && (t10.width > Gt$1 && t10.height > Gt$1 ? t10.width > t10.height ? (t10.height *= Gt$1 / t10.width, t10.width = Gt$1) : (t10.width *= Gt$1 / t10.height, t10.height = Gt$1) : t10.width > Gt$1 ? (t10.height *= Gt$1 / t10.width, t10.width = Gt$1) : (t10.width *= Gt$1 / t10.height, t10.height = Gt$1));
  }
  function NE(t10, e10 = {}) {
    return t10.toBlob ? new Promise((n10) => {
      t10.toBlob(n10, e10.type ? e10.type : "image/png", e10.quality ? e10.quality : 1);
    }) : new Promise((n10) => {
      const r10 = window.atob(t10.toDataURL(e10.type ? e10.type : void 0, e10.quality ? e10.quality : void 0).split(",")[1]), s10 = r10.length, i10 = new Uint8Array(s10);
      for (let o10 = 0; o10 < s10; o10 += 1)
        i10[o10] = r10.charCodeAt(o10);
      n10(new Blob([i10], {
        type: e10.type ? e10.type : "image/png"
      }));
    });
  }
  function zi(t10) {
    return new Promise((e10, n10) => {
      const r10 = new Image();
      r10.decode = () => e10(r10), r10.onload = () => e10(r10), r10.onerror = n10, r10.crossOrigin = "anonymous", r10.decoding = "async", r10.src = t10;
    });
  }
  async function PE(t10) {
    return Promise.resolve().then(() => new XMLSerializer().serializeToString(t10)).then(encodeURIComponent).then((e10) => `data:image/svg+xml;charset=utf-8,${e10}`);
  }
  async function FE(t10, e10, n10) {
    const r10 = "http://www.w3.org/2000/svg", s10 = document.createElementNS(r10, "svg"), i10 = document.createElementNS(r10, "foreignObject");
    return s10.setAttribute("width", `${e10}`), s10.setAttribute("height", `${n10}`), s10.setAttribute("viewBox", `0 0 ${e10} ${n10}`), i10.setAttribute("width", "100%"), i10.setAttribute("height", "100%"), i10.setAttribute("x", "0"), i10.setAttribute("y", "0"), i10.setAttribute("externalResourcesRequired", "true"), s10.appendChild(i10), i10.appendChild(t10), PE(s10);
  }
  function DE(t10) {
    const e10 = t10.getPropertyValue("content");
    return `${t10.cssText} content: '${e10.replace(/'|"/g, "")}';`;
  }
  function BE(t10) {
    return _r(t10).map((e10) => {
      const n10 = t10.getPropertyValue(e10), r10 = t10.getPropertyPriority(e10);
      return `${e10}: ${n10}${r10 ? " !important" : ""};`;
    }).join(" ");
  }
  function $E(t10, e10, n10) {
    const r10 = `.${t10}:${e10}`, s10 = n10.cssText ? DE(n10) : BE(n10);
    return document.createTextNode(`${r10}{${s10}}`);
  }
  function ou(t10, e10, n10) {
    const r10 = window.getComputedStyle(t10, n10), s10 = r10.getPropertyValue("content");
    if (s10 === "" || s10 === "none")
      return;
    const i10 = kE();
    try {
      e10.className = `${e10.className} ${i10}`;
    } catch {
      return;
    }
    const o10 = document.createElement("style");
    o10.appendChild($E(i10, n10, r10)), e10.appendChild(o10);
  }
  function HE(t10, e10) {
    ou(t10, e10, ":before"), ou(t10, e10, ":after");
  }
  const lu = "application/font-woff", au = "image/jpeg", UE = {
    woff: lu,
    woff2: lu,
    ttf: "application/font-truetype",
    eot: "application/vnd.ms-fontobject",
    png: "image/png",
    jpg: au,
    jpeg: au,
    gif: "image/gif",
    tiff: "image/tiff",
    svg: "image/svg+xml",
    webp: "image/webp"
  };
  function VE(t10) {
    const e10 = /\.([^./]*?)$/g.exec(t10);
    return e10 ? e10[1] : "";
  }
  function fc(t10) {
    const e10 = VE(t10).toLowerCase();
    return UE[e10] || "";
  }
  function zE(t10) {
    return t10.split(/,/)[1];
  }
  function al(t10) {
    return t10.search(/^(data:)/) !== -1;
  }
  function bh(t10, e10) {
    return `data:${e10};base64,${t10}`;
  }
  async function wh(t10, e10, n10) {
    const r10 = await fetch(t10, e10);
    if (r10.status === 404)
      throw new Error(`Resource "${r10.url}" not found`);
    const s10 = await r10.blob();
    return new Promise((i10, o10) => {
      const l10 = new FileReader();
      l10.onerror = o10, l10.onloadend = () => {
        try {
          i10(n10({ res: r10, result: l10.result }));
        } catch (a10) {
          o10(a10);
        }
      }, l10.readAsDataURL(s10);
    });
  }
  const ho = {};
  function GE(t10, e10, n10) {
    let r10 = t10.replace(/\?.*/, "");
    return n10 && (r10 = t10), /ttf|otf|eot|woff2?/i.test(r10) && (r10 = r10.replace(/.*\//, "")), e10 ? `[${e10}]${r10}` : r10;
  }
  async function pc(t10, e10, n10) {
    const r10 = GE(t10, e10, n10.includeQueryParams);
    if (ho[r10] != null)
      return ho[r10];
    n10.cacheBust && (t10 += (/\?/.test(t10) ? "&" : "?") + (/* @__PURE__ */ new Date()).getTime());
    let s10;
    try {
      const i10 = await wh(t10, n10.fetchRequestInit, ({ res: o10, result: l10 }) => (e10 || (e10 = o10.headers.get("Content-Type") || ""), zE(l10)));
      s10 = bh(i10, e10);
    } catch (i10) {
      s10 = n10.imagePlaceholder || "";
      let o10 = `Failed to fetch resource: ${t10}`;
      i10 && (o10 = typeof i10 == "string" ? i10 : i10.message), o10 && console.warn(o10);
    }
    return ho[r10] = s10, s10;
  }
  async function jE(t10) {
    const e10 = t10.toDataURL();
    return e10 === "data:," ? t10.cloneNode(false) : zi(e10);
  }
  async function ZE(t10, e10) {
    if (t10.currentSrc) {
      const i10 = document.createElement("canvas"), o10 = i10.getContext("2d");
      i10.width = t10.clientWidth, i10.height = t10.clientHeight, o10 == null || o10.drawImage(t10, 0, 0, i10.width, i10.height);
      const l10 = i10.toDataURL();
      return zi(l10);
    }
    const n10 = t10.poster, r10 = fc(n10), s10 = await pc(n10, r10, e10);
    return zi(s10);
  }
  async function WE(t10) {
    var e10;
    try {
      if (!((e10 = t10 == null ? void 0 : t10.contentDocument) === null || e10 === void 0) && e10.body)
        return await H1(t10.contentDocument.body, {}, true);
    } catch {
    }
    return t10.cloneNode(false);
  }
  async function qE(t10, e10) {
    return t10 instanceof HTMLCanvasElement ? jE(t10) : t10 instanceof HTMLVideoElement ? ZE(t10, e10) : t10 instanceof HTMLIFrameElement ? WE(t10) : t10.cloneNode(false);
  }
  const KE = (t10) => t10.tagName != null && t10.tagName.toUpperCase() === "SLOT";
  async function YE(t10, e10, n10) {
    var r10;
    const s10 = KE(t10) && t10.assignedNodes ? _r(t10.assignedNodes()) : _r(((r10 = t10.shadowRoot) !== null && r10 !== void 0 ? r10 : t10).childNodes);
    return s10.length === 0 || t10 instanceof HTMLVideoElement || await s10.reduce((i10, o10) => i10.then(() => H1(o10, n10)).then((l10) => {
      l10 && e10.appendChild(l10);
    }), Promise.resolve()), e10;
  }
  function XE(t10, e10) {
    const n10 = e10.style;
    if (!n10)
      return;
    const r10 = window.getComputedStyle(t10);
    r10.cssText ? (n10.cssText = r10.cssText, n10.transformOrigin = r10.transformOrigin) : _r(r10).forEach((s10) => {
      let i10 = r10.getPropertyValue(s10);
      s10 === "font-size" && i10.endsWith("px") && (i10 = `${Math.floor(parseFloat(i10.substring(0, i10.length - 2))) - 0.1}px`), n10.setProperty(s10, i10, r10.getPropertyPriority(s10));
    });
  }
  function QE(t10, e10) {
    t10 instanceof HTMLTextAreaElement && (e10.innerHTML = t10.value), t10 instanceof HTMLInputElement && e10.setAttribute("value", t10.value);
  }
  function JE(t10, e10) {
    if (t10 instanceof HTMLSelectElement) {
      const n10 = e10, r10 = Array.from(n10.children).find((s10) => t10.value === s10.getAttribute("value"));
      r10 && r10.setAttribute("selected", "");
    }
  }
  function eT(t10, e10) {
    return e10 instanceof Element && (XE(t10, e10), HE(t10, e10), QE(t10, e10), JE(t10, e10)), e10;
  }
  async function tT(t10, e10) {
    const n10 = t10.querySelectorAll ? t10.querySelectorAll("use") : [];
    if (n10.length === 0)
      return t10;
    const r10 = {};
    for (let i10 = 0; i10 < n10.length; i10++) {
      const l10 = n10[i10].getAttribute("xlink:href");
      if (l10) {
        const a10 = t10.querySelector(l10), c10 = document.querySelector(l10);
        !a10 && c10 && !r10[l10] && (r10[l10] = await H1(c10, e10, true));
      }
    }
    const s10 = Object.values(r10);
    if (s10.length) {
      const i10 = "http://www.w3.org/1999/xhtml", o10 = document.createElementNS(i10, "svg");
      o10.setAttribute("xmlns", i10), o10.style.position = "absolute", o10.style.width = "0", o10.style.height = "0", o10.style.overflow = "hidden", o10.style.display = "none";
      const l10 = document.createElementNS(i10, "defs");
      o10.appendChild(l10);
      for (let a10 = 0; a10 < s10.length; a10++)
        l10.appendChild(s10[a10]);
      t10.appendChild(o10);
    }
    return t10;
  }
  async function H1(t10, e10, n10) {
    return !n10 && e10.filter && !e10.filter(t10) ? null : Promise.resolve(t10).then((r10) => qE(r10, e10)).then((r10) => YE(t10, r10, e10)).then((r10) => eT(t10, r10)).then((r10) => tT(r10, e10));
  }
  const Eh = /url\((['"]?)([^'"]+?)\1\)/g, nT = /url\([^)]+\)\s*format\((["']?)([^"']+)\1\)/g, rT = /src:\s*(?:url\([^)]+\)\s*format\([^)]+\)[,;]\s*)+/g;
  function sT(t10) {
    const e10 = t10.replace(/([.*+?^${}()|\[\]\/\\])/g, "\\$1");
    return new RegExp(`(url\\(['"]?)(${e10})(['"]?\\))`, "g");
  }
  function iT(t10) {
    const e10 = [];
    return t10.replace(Eh, (n10, r10, s10) => (e10.push(s10), n10)), e10.filter((n10) => !al(n10));
  }
  async function oT(t10, e10, n10, r10, s10) {
    try {
      const i10 = n10 ? AE(e10, n10) : e10, o10 = fc(e10);
      let l10;
      if (s10) {
        const a10 = await s10(i10);
        l10 = bh(a10, o10);
      } else
        l10 = await pc(i10, o10, r10);
      return t10.replace(sT(e10), `$1${l10}$3`);
    } catch {
    }
    return t10;
  }
  function lT(t10, { preferredFontFormat: e10 }) {
    return e10 ? t10.replace(rT, (n10) => {
      for (; ; ) {
        const [r10, , s10] = nT.exec(n10) || [];
        if (!s10)
          return "";
        if (s10 === e10)
          return `src: ${r10};`;
      }
    }) : t10;
  }
  function Th(t10) {
    return t10.search(Eh) !== -1;
  }
  async function Sh(t10, e10, n10) {
    if (!Th(t10))
      return t10;
    const r10 = lT(t10, n10);
    return iT(r10).reduce((i10, o10) => i10.then((l10) => oT(l10, o10, e10, n10)), Promise.resolve(r10));
  }
  async function aT(t10, e10) {
    var n10;
    const r10 = (n10 = t10.style) === null || n10 === void 0 ? void 0 : n10.getPropertyValue("background");
    if (r10) {
      const s10 = await Sh(r10, null, e10);
      t10.style.setProperty("background", s10, t10.style.getPropertyPriority("background"));
    }
  }
  async function cT(t10, e10) {
    if (!(t10 instanceof HTMLImageElement && !al(t10.src)) && !(t10 instanceof SVGImageElement && !al(t10.href.baseVal)))
      return;
    const n10 = t10 instanceof HTMLImageElement ? t10.src : t10.href.baseVal, r10 = await pc(n10, fc(n10), e10);
    await new Promise((s10, i10) => {
      t10.onload = s10, t10.onerror = i10;
      const o10 = t10;
      o10.decode && (o10.decode = s10), t10 instanceof HTMLImageElement ? (t10.srcset = "", t10.src = r10) : t10.href.baseVal = r10;
    });
  }
  async function uT(t10, e10) {
    const r10 = _r(t10.childNodes).map((s10) => Ah(s10, e10));
    await Promise.all(r10).then(() => t10);
  }
  async function Ah(t10, e10) {
    t10 instanceof Element && (await aT(t10, e10), await cT(t10, e10), await uT(t10, e10));
  }
  function hT(t10, e10) {
    const { style: n10 } = t10;
    e10.backgroundColor && (n10.backgroundColor = e10.backgroundColor), e10.width && (n10.width = `${e10.width}px`), e10.height && (n10.height = `${e10.height}px`);
    const r10 = e10.style;
    return r10 != null && Object.keys(r10).forEach((s10) => {
      n10[s10] = r10[s10];
    }), t10;
  }
  const cu = {};
  async function uu(t10) {
    let e10 = cu[t10];
    if (e10 != null)
      return e10;
    const r10 = await (await fetch(t10)).text();
    return e10 = { url: t10, cssText: r10 }, cu[t10] = e10, e10;
  }
  async function hu(t10, e10) {
    let n10 = t10.cssText;
    const r10 = /url\(["']?([^"')]+)["']?\)/g, i10 = (n10.match(/url\([^)]+\)/g) || []).map(async (o10) => {
      let l10 = o10.replace(r10, "$1");
      return l10.startsWith("https://") || (l10 = new URL(l10, t10.url).href), wh(l10, e10.fetchRequestInit, ({ result: a10 }) => (n10 = n10.replace(o10, `url(${a10})`), [o10, a10]));
    });
    return Promise.all(i10).then(() => n10);
  }
  function du(t10) {
    if (t10 == null)
      return [];
    const e10 = [], n10 = /(\/\*[\s\S]*?\*\/)/gi;
    let r10 = t10.replace(n10, "");
    const s10 = new RegExp("((@.*?keyframes [\\s\\S]*?){([\\s\\S]*?}\\s*?)})", "gi");
    for (; ; ) {
      const a10 = s10.exec(r10);
      if (a10 === null)
        break;
      e10.push(a10[0]);
    }
    r10 = r10.replace(s10, "");
    const i10 = /@import[\s\S]*?url\([^)]*\)[\s\S]*?;/gi, o10 = "((\\s*?(?:\\/\\*[\\s\\S]*?\\*\\/)?\\s*?@media[\\s\\S]*?){([\\s\\S]*?)}\\s*?})|(([\\s\\S]*?){([\\s\\S]*?)})", l10 = new RegExp(o10, "gi");
    for (; ; ) {
      let a10 = i10.exec(r10);
      if (a10 === null) {
        if (a10 = l10.exec(r10), a10 === null)
          break;
        i10.lastIndex = l10.lastIndex;
      } else
        l10.lastIndex = i10.lastIndex;
      e10.push(a10[0]);
    }
    return e10;
  }
  async function dT(t10, e10) {
    const n10 = [], r10 = [];
    return t10.forEach((s10) => {
      if ("cssRules" in s10)
        try {
          _r(s10.cssRules || []).forEach((i10, o10) => {
            if (i10.type === CSSRule.IMPORT_RULE) {
              let l10 = o10 + 1;
              const a10 = i10.href, c10 = uu(a10).then((u10) => hu(u10, e10)).then((u10) => du(u10).forEach((h10) => {
                try {
                  s10.insertRule(h10, h10.startsWith("@import") ? l10 += 1 : s10.cssRules.length);
                } catch (d10) {
                  console.error("Error inserting rule from remote css", {
                    rule: h10,
                    error: d10
                  });
                }
              })).catch((u10) => {
                console.error("Error loading remote css", u10.toString());
              });
              r10.push(c10);
            }
          });
        } catch (i10) {
          const o10 = t10.find((l10) => l10.href == null) || document.styleSheets[0];
          s10.href != null && r10.push(uu(s10.href).then((l10) => hu(l10, e10)).then((l10) => du(l10).forEach((a10) => {
            o10.insertRule(a10, s10.cssRules.length);
          })).catch((l10) => {
            console.error("Error loading remote stylesheet", l10.toString());
          })), console.error("Error inlining remote css file", i10.toString());
        }
    }), Promise.all(r10).then(() => (t10.forEach((s10) => {
      if ("cssRules" in s10)
        try {
          _r(s10.cssRules || []).forEach((i10) => {
            n10.push(i10);
          });
        } catch (i10) {
          console.error(`Error while reading CSS rules from ${s10.href}`, i10.toString());
        }
    }), n10));
  }
  function fT(t10) {
    return t10.filter((e10) => e10.type === CSSRule.FONT_FACE_RULE).filter((e10) => Th(e10.style.getPropertyValue("src")));
  }
  async function pT(t10, e10) {
    if (t10.ownerDocument == null)
      throw new Error("Provided element is not within a Document");
    const n10 = _r(t10.ownerDocument.styleSheets), r10 = await dT(n10, e10);
    return fT(r10);
  }
  async function gT(t10, e10) {
    const n10 = await pT(t10, e10);
    return (await Promise.all(n10.map((s10) => {
      const i10 = s10.parentStyleSheet ? s10.parentStyleSheet.href : null;
      return Sh(s10.cssText, i10, e10);
    }))).join(`
`);
  }
  async function mT(t10, e10) {
    const n10 = e10.fontEmbedCSS != null ? e10.fontEmbedCSS : e10.skipFonts ? null : await gT(t10, e10);
    if (n10) {
      const r10 = document.createElement("style"), s10 = document.createTextNode(n10);
      r10.appendChild(s10), t10.firstChild ? t10.insertBefore(r10, t10.firstChild) : t10.appendChild(r10);
    }
  }
  async function kh(t10, e10 = {}) {
    const { width: n10, height: r10 } = vh(t10, e10), s10 = await H1(t10, e10, true);
    return await mT(s10, e10), await Ah(s10, e10), hT(s10, e10), await FE(s10, n10, r10);
  }
  async function gc(t10, e10 = {}) {
    const { width: n10, height: r10 } = vh(t10, e10), s10 = await kh(t10, e10), i10 = await zi(s10), o10 = document.createElement("canvas"), l10 = o10.getContext("2d"), a10 = e10.pixelRatio || IE(), c10 = e10.canvasWidth || n10, u10 = e10.canvasHeight || r10;
    return o10.width = c10 * a10, o10.height = u10 * a10, e10.skipAutoScale || ME(o10), o10.style.width = `${c10}`, o10.style.height = `${u10}`, e10.backgroundColor && (l10.fillStyle = e10.backgroundColor, l10.fillRect(0, 0, o10.width, o10.height)), l10.drawImage(i10, 0, 0, o10.width, o10.height), o10;
  }
  async function xT(t10, e10 = {}) {
    return (await gc(t10, e10)).toDataURL();
  }
  async function LT(t10, e10 = {}) {
    return (await gc(t10, e10)).toDataURL("image/jpeg", e10.quality || 1);
  }
  async function _T(t10, e10 = {}) {
    const n10 = await gc(t10, e10);
    return await NE(n10);
  }
  const yT = {}.VITE_APP_GIT_HASH, CT = {}.VITE_APP_GIT_BRANCH, vT = {
    name: "Debug",
    components: { Icon: dr },
    data() {
      return {
        commitHash: yT,
        gitBranch: CT
      };
    },
    computed: {
      debug() {
        return !!localStorage.zenumlDebug;
      }
    }
  }, bT = { class: "flex flex-nowrap m-2 text-sm" }, wT = { class: "ml-4 text-xs inline-flex items-center font-bold leading-sm px-3 py-1 bg-green-200 text-green-700 rounded-sm" }, ET = { class: "inline-block px-2" };
  function TT(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("Icon");
    return a1((k$1(), q$1("div", null, [
      A("div", bT, [
        A("div", wT, [
          V$1(o10, {
            name: "debug",
            "icon-class": "h-4 w-4"
          }),
          A("span", ET, Ve$1(s10.gitBranch) + ":" + Ve$1(s10.commitHash), 1)
        ])
      ])
    ], 512)), [
      [N0, i10.debug]
    ]);
  }
  const ST = /* @__PURE__ */ ze$1(vT, [["render", TT]]);
  function Nn(t10, e10, ...n10) {
    if (t10 in e10) {
      let s10 = e10[t10];
      return typeof s10 == "function" ? s10(...n10) : s10;
    }
    let r10 = new Error(`Tried to handle "${t10}" but there is no handler defined. Only defined handlers are: ${Object.keys(e10).map((s10) => `"${s10}"`).join(", ")}.`);
    throw Error.captureStackTrace && Error.captureStackTrace(r10, Nn), r10;
  }
  var Gi = ((t10) => (t10[t10.None = 0] = "None", t10[t10.RenderStrategy = 1] = "RenderStrategy", t10[t10.Static = 2] = "Static", t10))(Gi || {}), lr = ((t10) => (t10[t10.Unmount = 0] = "Unmount", t10[t10.Hidden = 1] = "Hidden", t10))(lr || {});
  function wt({ visible: t10 = true, features: e10 = 0, ourProps: n10, theirProps: r10, ...s10 }) {
    var i10;
    let o10 = Oh(r10, n10), l10 = Object.assign(s10, { props: o10 });
    if (t10 || e10 & 2 && o10.static)
      return fo(l10);
    if (e10 & 1) {
      let a10 = (i10 = o10.unmount) == null || i10 ? 0 : 1;
      return Nn(a10, { [0]() {
        return null;
      }, [1]() {
        return fo({ ...s10, props: { ...o10, hidden: true, style: { display: "none" } } });
      } });
    }
    return fo(l10);
  }
  function fo({ props: t10, attrs: e10, slots: n10, slot: r10, name: s10 }) {
    var i10, o10;
    let { as: l10, ...a10 } = mc(t10, ["unmount", "static"]), c10 = (i10 = n10.default) == null ? void 0 : i10.call(n10, r10), u10 = {};
    if (r10) {
      let h10 = false, d10 = [];
      for (let [p10, g] of Object.entries(r10))
        typeof g == "boolean" && (h10 = true), g === true && d10.push(p10);
      h10 && (u10["data-headlessui-state"] = d10.join(" "));
    }
    if (l10 === "template") {
      if (c10 = Rh(c10 != null ? c10 : []), Object.keys(a10).length > 0 || Object.keys(e10).length > 0) {
        let [h10, ...d10] = c10 != null ? c10 : [];
        if (!kT(h10) || d10.length > 0)
          throw new Error(['Passing props on "template"!', "", `The current component <${s10} /> is rendering a "template".`, "However we need to passthrough the following props:", Object.keys(a10).concat(Object.keys(e10)).map((L) => L.trim()).filter((L, T, _10) => _10.indexOf(L) === T).sort((L, T) => L.localeCompare(T)).map((L) => `  - ${L}`).join(`
`), "", "You can apply a few solutions:", ['Add an `as="..."` prop, to ensure that we render an actual element instead of a "template".', "Render a single element as the child so that we can forward the props onto that element."].map((L) => `  - ${L}`).join(`
`)].join(`
`));
        let p10 = Oh((o10 = h10.props) != null ? o10 : {}, a10), g = an$1(h10, p10);
        for (let L in p10)
          L.startsWith("on") && (g.props || (g.props = {}), g.props[L] = p10[L]);
        return g;
      }
      return Array.isArray(c10) && c10.length === 1 ? c10[0] : c10;
    }
    return ct(l10, Object.assign({}, a10, u10), { default: () => c10 });
  }
  function Rh(t10) {
    return t10.flatMap((e10) => e10.type === Fe$1 ? Rh(e10.children) : [e10]);
  }
  function Oh(...t10) {
    if (t10.length === 0)
      return {};
    if (t10.length === 1)
      return t10[0];
    let e10 = {}, n10 = {};
    for (let r10 of t10)
      for (let s10 in r10)
        s10.startsWith("on") && typeof r10[s10] == "function" ? (n10[s10] != null || (n10[s10] = []), n10[s10].push(r10[s10])) : e10[s10] = r10[s10];
    if (e10.disabled || e10["aria-disabled"])
      return Object.assign(e10, Object.fromEntries(Object.keys(n10).map((r10) => [r10, void 0])));
    for (let r10 in n10)
      Object.assign(e10, { [r10](s10, ...i10) {
        let o10 = n10[r10];
        for (let l10 of o10) {
          if (s10 instanceof Event && s10.defaultPrevented)
            return;
          l10(s10, ...i10);
        }
      } });
    return e10;
  }
  function AT(t10) {
    let e10 = Object.assign({}, t10);
    for (let n10 in e10)
      e10[n10] === void 0 && delete e10[n10];
    return e10;
  }
  function mc(t10, e10 = []) {
    let n10 = Object.assign({}, t10);
    for (let r10 of e10)
      r10 in n10 && delete n10[r10];
    return n10;
  }
  function kT(t10) {
    return t10 == null ? false : typeof t10.type == "string" || typeof t10.type == "object" || typeof t10.type == "function";
  }
  let RT = 0;
  function OT() {
    return ++RT;
  }
  function Bn() {
    return OT();
  }
  var sr = ((t10) => (t10.Space = " ", t10.Enter = "Enter", t10.Escape = "Escape", t10.Backspace = "Backspace", t10.Delete = "Delete", t10.ArrowLeft = "ArrowLeft", t10.ArrowUp = "ArrowUp", t10.ArrowRight = "ArrowRight", t10.ArrowDown = "ArrowDown", t10.Home = "Home", t10.End = "End", t10.PageUp = "PageUp", t10.PageDown = "PageDown", t10.Tab = "Tab", t10))(sr || {});
  function st(t10) {
    var e10;
    return t10 == null || t10.value == null ? null : (e10 = t10.value.$el) != null ? e10 : t10.value;
  }
  let Ih = Symbol("Context");
  var qt$1 = ((t10) => (t10[t10.Open = 1] = "Open", t10[t10.Closed = 2] = "Closed", t10[t10.Closing = 4] = "Closing", t10[t10.Opening = 8] = "Opening", t10))(qt$1 || {});
  function IT() {
    return xc() !== null;
  }
  function xc() {
    return lt(Ih, null);
  }
  function MT(t10) {
    Ut$1(Ih, t10);
  }
  var NT = Object.defineProperty, PT = (t10, e10, n10) => e10 in t10 ? NT(t10, e10, { enumerable: true, configurable: true, writable: true, value: n10 }) : t10[e10] = n10, fu = (t10, e10, n10) => (PT(t10, typeof e10 != "symbol" ? e10 + "" : e10, n10), n10);
  class FT {
    constructor() {
      fu(this, "current", this.detect()), fu(this, "currentId", 0);
    }
    set(e10) {
      this.current !== e10 && (this.currentId = 0, this.current = e10);
    }
    reset() {
      this.set(this.detect());
    }
    nextId() {
      return ++this.currentId;
    }
    get isServer() {
      return this.current === "server";
    }
    get isClient() {
      return this.current === "client";
    }
    detect() {
      return typeof window > "u" || typeof document > "u" ? "server" : "client";
    }
  }
  let j0 = new FT();
  function Sn$1(t10) {
    if (j0.isServer)
      return null;
    if (t10 instanceof Node)
      return t10.ownerDocument;
    if (t10 != null && t10.hasOwnProperty("value")) {
      let e10 = st(t10);
      if (e10)
        return e10.ownerDocument;
    }
    return document;
  }
  function DT({ container: t10, accept: e10, walk: n10, enabled: r10 }) {
    Qt$1(() => {
      let s10 = t10.value;
      if (!s10 || r10 !== void 0 && !r10.value)
        return;
      let i10 = Sn$1(t10);
      if (!i10)
        return;
      let o10 = Object.assign((a10) => e10(a10), { acceptNode: e10 }), l10 = i10.createTreeWalker(s10, NodeFilter.SHOW_ELEMENT, o10, false);
      for (; l10.nextNode(); )
        n10(l10.currentNode);
    });
  }
  let cl = ["[contentEditable=true]", "[tabindex]", "a[href]", "area[href]", "button:not([disabled])", "iframe", "input:not([disabled])", "select:not([disabled])", "textarea:not([disabled])"].map((t10) => `${t10}:not([tabindex='-1'])`).join(",");
  var ln$1 = ((t10) => (t10[t10.First = 1] = "First", t10[t10.Previous = 2] = "Previous", t10[t10.Next = 4] = "Next", t10[t10.Last = 8] = "Last", t10[t10.WrapAround = 16] = "WrapAround", t10[t10.NoScroll = 32] = "NoScroll", t10))(ln$1 || {}), ji = ((t10) => (t10[t10.Error = 0] = "Error", t10[t10.Overflow = 1] = "Overflow", t10[t10.Success = 2] = "Success", t10[t10.Underflow = 3] = "Underflow", t10))(ji || {}), BT = ((t10) => (t10[t10.Previous = -1] = "Previous", t10[t10.Next = 1] = "Next", t10))(BT || {});
  function $T(t10 = document.body) {
    return t10 == null ? [] : Array.from(t10.querySelectorAll(cl)).sort((e10, n10) => Math.sign((e10.tabIndex || Number.MAX_SAFE_INTEGER) - (n10.tabIndex || Number.MAX_SAFE_INTEGER)));
  }
  var Mh = ((t10) => (t10[t10.Strict = 0] = "Strict", t10[t10.Loose = 1] = "Loose", t10))(Mh || {});
  function HT(t10, e10 = 0) {
    var n10;
    return t10 === ((n10 = Sn$1(t10)) == null ? void 0 : n10.body) ? false : Nn(e10, { [0]() {
      return t10.matches(cl);
    }, [1]() {
      let r10 = t10;
      for (; r10 !== null; ) {
        if (r10.matches(cl))
          return true;
        r10 = r10.parentElement;
      }
      return false;
    } });
  }
  var UT = ((t10) => (t10[t10.Keyboard = 0] = "Keyboard", t10[t10.Mouse = 1] = "Mouse", t10))(UT || {});
  typeof window < "u" && typeof document < "u" && (document.addEventListener("keydown", (t10) => {
    t10.metaKey || t10.altKey || t10.ctrlKey || (document.documentElement.dataset.headlessuiFocusVisible = "");
  }, true), document.addEventListener("click", (t10) => {
    t10.detail === 1 ? delete document.documentElement.dataset.headlessuiFocusVisible : t10.detail === 0 && (document.documentElement.dataset.headlessuiFocusVisible = "");
  }, true));
  function Dr(t10) {
    t10 == null || t10.focus({ preventScroll: true });
  }
  let VT = ["textarea", "input"].join(",");
  function zT(t10) {
    var e10, n10;
    return (n10 = (e10 = t10 == null ? void 0 : t10.matches) == null ? void 0 : e10.call(t10, VT)) != null ? n10 : false;
  }
  function Nh(t10, e10 = (n10) => n10) {
    return t10.slice().sort((n10, r10) => {
      let s10 = e10(n10), i10 = e10(r10);
      if (s10 === null || i10 === null)
        return 0;
      let o10 = s10.compareDocumentPosition(i10);
      return o10 & Node.DOCUMENT_POSITION_FOLLOWING ? -1 : o10 & Node.DOCUMENT_POSITION_PRECEDING ? 1 : 0;
    });
  }
  function ps(t10, e10, { sorted: n10 = true, relativeTo: r10 = null, skipElements: s10 = [] } = {}) {
    var i10;
    let o10 = (i10 = Array.isArray(t10) ? t10.length > 0 ? t10[0].ownerDocument : document : t10 == null ? void 0 : t10.ownerDocument) != null ? i10 : document, l10 = Array.isArray(t10) ? n10 ? Nh(t10) : t10 : $T(t10);
    s10.length > 0 && l10.length > 1 && (l10 = l10.filter((g) => !s10.includes(g))), r10 = r10 != null ? r10 : o10.activeElement;
    let a10 = (() => {
      if (e10 & 5)
        return 1;
      if (e10 & 10)
        return -1;
      throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
    })(), c10 = (() => {
      if (e10 & 1)
        return 0;
      if (e10 & 2)
        return Math.max(0, l10.indexOf(r10)) - 1;
      if (e10 & 4)
        return Math.max(0, l10.indexOf(r10)) + 1;
      if (e10 & 8)
        return l10.length - 1;
      throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
    })(), u10 = e10 & 32 ? { preventScroll: true } : {}, h10 = 0, d10 = l10.length, p10;
    do {
      if (h10 >= d10 || h10 + d10 <= 0)
        return 0;
      let g = c10 + h10;
      if (e10 & 16)
        g = (g + d10) % d10;
      else {
        if (g < 0)
          return 3;
        if (g >= d10)
          return 1;
      }
      p10 = l10[g], p10 == null || p10.focus(u10), h10 += a10;
    } while (p10 !== o10.activeElement);
    return e10 & 6 && zT(p10) && p10.select(), 2;
  }
  function gi(t10, e10, n10) {
    j0.isServer || Qt$1((r10) => {
      document.addEventListener(t10, e10, n10), r10(() => document.removeEventListener(t10, e10, n10));
    });
  }
  function Ph(t10, e10, n10) {
    j0.isServer || Qt$1((r10) => {
      window.addEventListener(t10, e10, n10), r10(() => window.removeEventListener(t10, e10, n10));
    });
  }
  function GT(t10, e10, n10 = G$1(() => true)) {
    function r10(i10, o10) {
      if (!n10.value || i10.defaultPrevented)
        return;
      let l10 = o10(i10);
      if (l10 === null || !l10.getRootNode().contains(l10))
        return;
      let a10 = function c10(u10) {
        return typeof u10 == "function" ? c10(u10()) : Array.isArray(u10) || u10 instanceof Set ? u10 : [u10];
      }(t10);
      for (let c10 of a10) {
        if (c10 === null)
          continue;
        let u10 = c10 instanceof HTMLElement ? c10 : st(c10);
        if (u10 != null && u10.contains(l10) || i10.composed && i10.composedPath().includes(u10))
          return;
      }
      return !HT(l10, Mh.Loose) && l10.tabIndex !== -1 && i10.preventDefault(), e10(i10, l10);
    }
    let s10 = ge(null);
    gi("pointerdown", (i10) => {
      var o10, l10;
      n10.value && (s10.value = ((l10 = (o10 = i10.composedPath) == null ? void 0 : o10.call(i10)) == null ? void 0 : l10[0]) || i10.target);
    }, true), gi("mousedown", (i10) => {
      var o10, l10;
      n10.value && (s10.value = ((l10 = (o10 = i10.composedPath) == null ? void 0 : o10.call(i10)) == null ? void 0 : l10[0]) || i10.target);
    }, true), gi("click", (i10) => {
      s10.value && (r10(i10, () => s10.value), s10.value = null);
    }, true), gi("touchend", (i10) => r10(i10, () => i10.target instanceof HTMLElement ? i10.target : null), true), Ph("blur", (i10) => r10(i10, () => window.document.activeElement instanceof HTMLIFrameElement ? window.document.activeElement : null), true);
  }
  var y0 = ((t10) => (t10[t10.None = 1] = "None", t10[t10.Focusable = 2] = "Focusable", t10[t10.Hidden = 4] = "Hidden", t10))(y0 || {});
  let Zi = Ye$1({ name: "Hidden", props: { as: { type: [Object, String], default: "div" }, features: { type: Number, default: 1 } }, setup(t10, { slots: e10, attrs: n10 }) {
    return () => {
      let { features: r10, ...s10 } = t10, i10 = { "aria-hidden": (r10 & 2) === 2 ? true : void 0, style: { position: "fixed", top: 1, left: 1, width: 1, height: 0, padding: 0, margin: -1, overflow: "hidden", clip: "rect(0, 0, 0, 0)", whiteSpace: "nowrap", borderWidth: "0", ...(r10 & 4) === 4 && (r10 & 2) !== 2 && { display: "none" } } };
      return wt({ ourProps: i10, theirProps: s10, slot: {}, attrs: n10, slots: e10, name: "Hidden" });
    };
  } });
  function Fh(t10 = {}, e10 = null, n10 = []) {
    for (let [r10, s10] of Object.entries(t10))
      Bh(n10, Dh(e10, r10), s10);
    return n10;
  }
  function Dh(t10, e10) {
    return t10 ? t10 + "[" + e10 + "]" : e10;
  }
  function Bh(t10, e10, n10) {
    if (Array.isArray(n10))
      for (let [r10, s10] of n10.entries())
        Bh(t10, Dh(e10, r10.toString()), s10);
    else
      n10 instanceof Date ? t10.push([e10, n10.toISOString()]) : typeof n10 == "boolean" ? t10.push([e10, n10 ? "1" : "0"]) : typeof n10 == "string" ? t10.push([e10, n10]) : typeof n10 == "number" ? t10.push([e10, `${n10}`]) : n10 == null ? t10.push([e10, ""]) : Fh(n10, e10, t10);
  }
  function jT(t10) {
    var e10, n10;
    let r10 = (e10 = t10 == null ? void 0 : t10.form) != null ? e10 : t10.closest("form");
    if (r10) {
      for (let s10 of r10.elements)
        if (s10 !== t10 && (s10.tagName === "INPUT" && s10.type === "submit" || s10.tagName === "BUTTON" && s10.type === "submit" || s10.nodeName === "INPUT" && s10.type === "image")) {
          s10.click();
          return;
        }
      (n10 = r10.requestSubmit) == null || n10.call(r10);
    }
  }
  function ZT(t10, e10, n10) {
    let r10 = ge(n10 == null ? void 0 : n10.value), s10 = G$1(() => t10.value !== void 0);
    return [G$1(() => s10.value ? t10.value : r10.value), function(i10) {
      return s10.value || (r10.value = i10), e10 == null ? void 0 : e10(i10);
    }];
  }
  function WT() {
    return /iPhone/gi.test(window.navigator.platform) || /Mac/gi.test(window.navigator.platform) && window.navigator.maxTouchPoints > 0;
  }
  function Lc(t10) {
    typeof queueMicrotask == "function" ? queueMicrotask(t10) : Promise.resolve().then(t10).catch((e10) => setTimeout(() => {
      throw e10;
    }));
  }
  function Z0() {
    let t10 = [], e10 = { addEventListener(n10, r10, s10, i10) {
      return n10.addEventListener(r10, s10, i10), e10.add(() => n10.removeEventListener(r10, s10, i10));
    }, requestAnimationFrame(...n10) {
      let r10 = requestAnimationFrame(...n10);
      e10.add(() => cancelAnimationFrame(r10));
    }, nextFrame(...n10) {
      e10.requestAnimationFrame(() => {
        e10.requestAnimationFrame(...n10);
      });
    }, setTimeout(...n10) {
      let r10 = setTimeout(...n10);
      e10.add(() => clearTimeout(r10));
    }, microTask(...n10) {
      let r10 = { current: true };
      return Lc(() => {
        r10.current && n10[0]();
      }), e10.add(() => {
        r10.current = false;
      });
    }, style(n10, r10, s10) {
      let i10 = n10.style.getPropertyValue(r10);
      return Object.assign(n10.style, { [r10]: s10 }), this.add(() => {
        Object.assign(n10.style, { [r10]: i10 });
      });
    }, group(n10) {
      let r10 = Z0();
      return n10(r10), this.add(() => r10.dispose());
    }, add(n10) {
      return t10.push(n10), () => {
        let r10 = t10.indexOf(n10);
        if (r10 >= 0)
          for (let s10 of t10.splice(r10, 1))
            s10();
      };
    }, dispose() {
      for (let n10 of t10.splice(0))
        n10();
    } };
    return e10;
  }
  var Xs = ((t10) => (t10[t10.Forwards = 0] = "Forwards", t10[t10.Backwards = 1] = "Backwards", t10))(Xs || {});
  function qT() {
    let t10 = ge(0);
    return Ph("keydown", (e10) => {
      e10.key === "Tab" && (t10.value = e10.shiftKey ? 1 : 0);
    }), t10;
  }
  function $h(t10, e10, n10, r10) {
    j0.isServer || Qt$1((s10) => {
      t10 = t10 != null ? t10 : window, t10.addEventListener(e10, n10, r10), s10(() => t10.removeEventListener(e10, n10, r10));
    });
  }
  function KT(t10) {
    function e10() {
      document.readyState !== "loading" && (t10(), document.removeEventListener("DOMContentLoaded", e10));
    }
    typeof window < "u" && typeof document < "u" && (document.addEventListener("DOMContentLoaded", e10), e10());
  }
  function Hh(t10) {
    if (!t10)
      return /* @__PURE__ */ new Set();
    if (typeof t10 == "function")
      return new Set(t10());
    let e10 = /* @__PURE__ */ new Set();
    for (let n10 of t10.value) {
      let r10 = st(n10);
      r10 instanceof HTMLElement && e10.add(r10);
    }
    return e10;
  }
  var Uh = ((t10) => (t10[t10.None = 1] = "None", t10[t10.InitialFocus = 2] = "InitialFocus", t10[t10.TabLock = 4] = "TabLock", t10[t10.FocusLock = 8] = "FocusLock", t10[t10.RestoreFocus = 16] = "RestoreFocus", t10[t10.All = 30] = "All", t10))(Uh || {});
  let Ws = Object.assign(Ye$1({ name: "FocusTrap", props: { as: { type: [Object, String], default: "div" }, initialFocus: { type: Object, default: null }, features: { type: Number, default: 30 }, containers: { type: [Object, Function], default: ge(/* @__PURE__ */ new Set()) } }, inheritAttrs: false, setup(t10, { attrs: e10, slots: n10, expose: r10 }) {
    let s10 = ge(null);
    r10({ el: s10, $el: s10 });
    let i10 = G$1(() => Sn$1(s10)), o10 = ge(false);
    We$1(() => o10.value = true), ht(() => o10.value = false), XT({ ownerDocument: i10 }, G$1(() => o10.value && Boolean(t10.features & 16)));
    let l10 = QT({ ownerDocument: i10, container: s10, initialFocus: G$1(() => t10.initialFocus) }, G$1(() => o10.value && Boolean(t10.features & 2)));
    JT({ ownerDocument: i10, container: s10, containers: t10.containers, previousActiveElement: l10 }, G$1(() => o10.value && Boolean(t10.features & 8)));
    let a10 = qT();
    function c10(p10) {
      let g = st(s10);
      !g || ((L) => L())(() => {
        Nn(a10.value, { [Xs.Forwards]: () => {
          ps(g, ln$1.First, { skipElements: [p10.relatedTarget] });
        }, [Xs.Backwards]: () => {
          ps(g, ln$1.Last, { skipElements: [p10.relatedTarget] });
        } });
      });
    }
    let u10 = ge(false);
    function h10(p10) {
      p10.key === "Tab" && (u10.value = true, requestAnimationFrame(() => {
        u10.value = false;
      }));
    }
    function d10(p10) {
      if (!o10.value)
        return;
      let g = Hh(t10.containers);
      st(s10) instanceof HTMLElement && g.add(st(s10));
      let L = p10.relatedTarget;
      L instanceof HTMLElement && L.dataset.headlessuiFocusGuard !== "true" && (Vh(g, L) || (u10.value ? ps(st(s10), Nn(a10.value, { [Xs.Forwards]: () => ln$1.Next, [Xs.Backwards]: () => ln$1.Previous }) | ln$1.WrapAround, { relativeTo: p10.target }) : p10.target instanceof HTMLElement && Dr(p10.target)));
    }
    return () => {
      let p10 = {}, g = { ref: s10, onKeydown: h10, onFocusout: d10 }, { features: L, initialFocus: T, containers: _10, ...x } = t10;
      return ct(Fe$1, [Boolean(L & 4) && ct(Zi, { as: "button", type: "button", "data-headlessui-focus-guard": true, onFocus: c10, features: y0.Focusable }), wt({ ourProps: g, theirProps: { ...e10, ...x }, slot: p10, attrs: e10, slots: n10, name: "FocusTrap" }), Boolean(L & 4) && ct(Zi, { as: "button", type: "button", "data-headlessui-focus-guard": true, onFocus: c10, features: y0.Focusable })]);
    };
  } }), { features: Uh }), Rr = [];
  KT(() => {
    function t10(e10) {
      e10.target instanceof HTMLElement && e10.target !== document.body && Rr[0] !== e10.target && (Rr.unshift(e10.target), Rr = Rr.filter((n10) => n10 != null && n10.isConnected), Rr.splice(10));
    }
    window.addEventListener("click", t10, { capture: true }), window.addEventListener("mousedown", t10, { capture: true }), window.addEventListener("focus", t10, { capture: true }), document.body.addEventListener("click", t10, { capture: true }), document.body.addEventListener("mousedown", t10, { capture: true }), document.body.addEventListener("focus", t10, { capture: true });
  });
  function YT(t10) {
    let e10 = ge(Rr.slice());
    return Yt$1([t10], ([n10], [r10]) => {
      r10 === true && n10 === false ? Lc(() => {
        e10.value.splice(0);
      }) : r10 === false && n10 === true && (e10.value = Rr.slice());
    }, { flush: "post" }), () => {
      var n10;
      return (n10 = e10.value.find((r10) => r10 != null && r10.isConnected)) != null ? n10 : null;
    };
  }
  function XT({ ownerDocument: t10 }, e10) {
    let n10 = YT(e10);
    We$1(() => {
      Qt$1(() => {
        var r10, s10;
        e10.value || ((r10 = t10.value) == null ? void 0 : r10.activeElement) === ((s10 = t10.value) == null ? void 0 : s10.body) && Dr(n10());
      }, { flush: "post" });
    }), ht(() => {
      e10.value && Dr(n10());
    });
  }
  function QT({ ownerDocument: t10, container: e10, initialFocus: n10 }, r10) {
    let s10 = ge(null), i10 = ge(false);
    return We$1(() => i10.value = true), ht(() => i10.value = false), We$1(() => {
      Yt$1([e10, n10, r10], (o10, l10) => {
        if (o10.every((c10, u10) => (l10 == null ? void 0 : l10[u10]) === c10) || !r10.value)
          return;
        let a10 = st(e10);
        a10 && Lc(() => {
          var c10, u10;
          if (!i10.value)
            return;
          let h10 = st(n10), d10 = (c10 = t10.value) == null ? void 0 : c10.activeElement;
          if (h10) {
            if (h10 === d10) {
              s10.value = d10;
              return;
            }
          } else if (a10.contains(d10)) {
            s10.value = d10;
            return;
          }
          h10 ? Dr(h10) : ps(a10, ln$1.First | ln$1.NoScroll) === ji.Error && console.warn("There are no focusable elements inside the <FocusTrap />"), s10.value = (u10 = t10.value) == null ? void 0 : u10.activeElement;
        });
      }, { immediate: true, flush: "post" });
    }), s10;
  }
  function JT({ ownerDocument: t10, container: e10, containers: n10, previousActiveElement: r10 }, s10) {
    var i10;
    $h((i10 = t10.value) == null ? void 0 : i10.defaultView, "focus", (o10) => {
      if (!s10.value)
        return;
      let l10 = Hh(n10);
      st(e10) instanceof HTMLElement && l10.add(st(e10));
      let a10 = r10.value;
      if (!a10)
        return;
      let c10 = o10.target;
      c10 && c10 instanceof HTMLElement ? Vh(l10, c10) ? (r10.value = c10, Dr(c10)) : (o10.preventDefault(), o10.stopPropagation(), Dr(a10)) : Dr(r10.value);
    }, true);
  }
  function Vh(t10, e10) {
    for (let n10 of t10)
      if (n10.contains(e10))
        return true;
    return false;
  }
  let po = /* @__PURE__ */ new Map(), qs = /* @__PURE__ */ new Map();
  function pu(t10, e10 = ge(true)) {
    Qt$1((n10) => {
      var r10;
      if (!e10.value)
        return;
      let s10 = st(t10);
      if (!s10)
        return;
      n10(function() {
        var o10;
        if (!s10)
          return;
        let l10 = (o10 = qs.get(s10)) != null ? o10 : 1;
        if (l10 === 1 ? qs.delete(s10) : qs.set(s10, l10 - 1), l10 !== 1)
          return;
        let a10 = po.get(s10);
        a10 && (a10["aria-hidden"] === null ? s10.removeAttribute("aria-hidden") : s10.setAttribute("aria-hidden", a10["aria-hidden"]), s10.inert = a10.inert, po.delete(s10));
      });
      let i10 = (r10 = qs.get(s10)) != null ? r10 : 0;
      qs.set(s10, i10 + 1), i10 === 0 && (po.set(s10, { "aria-hidden": s10.getAttribute("aria-hidden"), inert: s10.inert }), s10.setAttribute("aria-hidden", "true"), s10.inert = true);
    });
  }
  let zh = Symbol("ForcePortalRootContext");
  function eS() {
    return lt(zh, false);
  }
  let ul = Ye$1({ name: "ForcePortalRoot", props: { as: { type: [Object, String], default: "template" }, force: { type: Boolean, default: false } }, setup(t10, { slots: e10, attrs: n10 }) {
    return Ut$1(zh, t10.force), () => {
      let { force: r10, ...s10 } = t10;
      return wt({ theirProps: s10, ourProps: {}, slot: {}, slots: e10, attrs: n10, name: "ForcePortalRoot" });
    };
  } });
  function tS(t10) {
    let e10 = Sn$1(t10);
    if (!e10) {
      if (t10 === null)
        return null;
      throw new Error(`[Headless UI]: Cannot find ownerDocument for contextElement: ${t10}`);
    }
    let n10 = e10.getElementById("headlessui-portal-root");
    if (n10)
      return n10;
    let r10 = e10.createElement("div");
    return r10.setAttribute("id", "headlessui-portal-root"), e10.body.appendChild(r10);
  }
  let Gh = Ye$1({ name: "Portal", props: { as: { type: [Object, String], default: "div" } }, setup(t10, { slots: e10, attrs: n10 }) {
    let r10 = ge(null), s10 = G$1(() => Sn$1(r10)), i10 = eS(), o10 = lt(jh, null), l10 = ge(i10 === true || o10 == null ? tS(r10.value) : o10.resolveTarget());
    Qt$1(() => {
      i10 || o10 != null && (l10.value = o10.resolveTarget());
    });
    let a10 = lt(hl, null);
    return We$1(() => {
      let c10 = st(r10);
      c10 && a10 && ht(a10.register(c10));
    }), ht(() => {
      var c10, u10;
      let h10 = (c10 = s10.value) == null ? void 0 : c10.getElementById("headlessui-portal-root");
      h10 && l10.value === h10 && l10.value.children.length <= 0 && ((u10 = l10.value.parentElement) == null || u10.removeChild(l10.value));
    }), () => {
      if (l10.value === null)
        return null;
      let c10 = { ref: r10, "data-headlessui-portal": "" };
      return ct(Q3, { to: l10.value }, wt({ ourProps: c10, theirProps: t10, slot: {}, attrs: n10, slots: e10, name: "Portal" }));
    };
  } }), hl = Symbol("PortalParentContext");
  function nS() {
    let t10 = lt(hl, null), e10 = ge([]);
    function n10(i10) {
      return e10.value.push(i10), t10 && t10.register(i10), () => r10(i10);
    }
    function r10(i10) {
      let o10 = e10.value.indexOf(i10);
      o10 !== -1 && e10.value.splice(o10, 1), t10 && t10.unregister(i10);
    }
    let s10 = { register: n10, unregister: r10, portals: e10 };
    return [e10, Ye$1({ name: "PortalWrapper", setup(i10, { slots: o10 }) {
      return Ut$1(hl, s10), () => {
        var l10;
        return (l10 = o10.default) == null ? void 0 : l10.call(o10);
      };
    } })];
  }
  let jh = Symbol("PortalGroupContext"), rS = Ye$1({ name: "PortalGroup", props: { as: { type: [Object, String], default: "template" }, target: { type: Object, default: null } }, setup(t10, { attrs: e10, slots: n10 }) {
    let r10 = Rn$1({ resolveTarget() {
      return t10.target;
    } });
    return Ut$1(jh, r10), () => {
      let { target: s10, ...i10 } = t10;
      return wt({ theirProps: i10, ourProps: {}, slot: {}, attrs: e10, slots: n10, name: "PortalGroup" });
    };
  } }), Zh = Symbol("StackContext");
  var dl = ((t10) => (t10[t10.Add = 0] = "Add", t10[t10.Remove = 1] = "Remove", t10))(dl || {});
  function sS() {
    return lt(Zh, () => {
    });
  }
  function iS({ type: t10, enabled: e10, element: n10, onUpdate: r10 }) {
    let s10 = sS();
    function i10(...o10) {
      r10 == null || r10(...o10), s10(...o10);
    }
    We$1(() => {
      Yt$1(e10, (o10, l10) => {
        o10 ? i10(0, t10, n10) : l10 === true && i10(1, t10, n10);
      }, { immediate: true, flush: "sync" });
    }), ht(() => {
      e10.value && i10(1, t10, n10);
    }), Ut$1(Zh, i10);
  }
  let Wh = Symbol("DescriptionContext");
  function oS() {
    let t10 = lt(Wh, null);
    if (t10 === null)
      throw new Error("Missing parent");
    return t10;
  }
  function _c({ slot: t10 = ge({}), name: e10 = "Description", props: n10 = {} } = {}) {
    let r10 = ge([]);
    function s10(i10) {
      return r10.value.push(i10), () => {
        let o10 = r10.value.indexOf(i10);
        o10 !== -1 && r10.value.splice(o10, 1);
      };
    }
    return Ut$1(Wh, { register: s10, slot: t10, name: e10, props: n10 }), G$1(() => r10.value.length > 0 ? r10.value.join(" ") : void 0);
  }
  Ye$1({ name: "Description", props: { as: { type: [Object, String], default: "p" }, id: { type: String, default: () => `headlessui-description-${Bn()}` } }, setup(t10, { attrs: e10, slots: n10 }) {
    let r10 = oS();
    return We$1(() => ht(r10.register(t10.id))), () => {
      let { name: s10 = "Description", slot: i10 = ge({}), props: o10 = {} } = r10, { id: l10, ...a10 } = t10, c10 = { ...Object.entries(o10).reduce((u10, [h10, d10]) => Object.assign(u10, { [h10]: _e(d10) }), {}), id: l10 };
      return wt({ ourProps: c10, theirProps: a10, slot: i10.value, attrs: e10, slots: n10, name: s10 });
    };
  } });
  function lS(t10) {
    let e10 = e3(t10.getSnapshot());
    return ht(t10.subscribe(() => {
      e10.value = t10.getSnapshot();
    })), e10;
  }
  function aS(t10, e10) {
    let n10 = t10(), r10 = /* @__PURE__ */ new Set();
    return { getSnapshot() {
      return n10;
    }, subscribe(s10) {
      return r10.add(s10), () => r10.delete(s10);
    }, dispatch(s10, ...i10) {
      let o10 = e10[s10].call(n10, ...i10);
      o10 && (n10 = o10, r10.forEach((l10) => l10()));
    } };
  }
  function cS() {
    let t10;
    return { before({ doc: e10 }) {
      var n10;
      let r10 = e10.documentElement;
      t10 = ((n10 = e10.defaultView) != null ? n10 : window).innerWidth - r10.clientWidth;
    }, after({ doc: e10, d: n10 }) {
      let r10 = e10.documentElement, s10 = r10.clientWidth - r10.offsetWidth, i10 = t10 - s10;
      n10.style(r10, "paddingRight", `${i10}px`);
    } };
  }
  function uS() {
    if (!WT())
      return {};
    let t10;
    return { before() {
      t10 = window.pageYOffset;
    }, after({ doc: e10, d: n10, meta: r10 }) {
      function s10(o10) {
        return r10.containers.flatMap((l10) => l10()).some((l10) => l10.contains(o10));
      }
      if (window.getComputedStyle(e10.documentElement).scrollBehavior !== "auto") {
        let o10 = Z0();
        o10.style(e10.documentElement, "scroll-behavior", "auto"), n10.add(() => n10.microTask(() => o10.dispose()));
      }
      n10.style(e10.body, "marginTop", `-${t10}px`), window.scrollTo(0, 0);
      let i10 = null;
      n10.addEventListener(e10, "click", (o10) => {
        if (o10.target instanceof HTMLElement)
          try {
            let l10 = o10.target.closest("a");
            if (!l10)
              return;
            let { hash: a10 } = new URL(l10.href), c10 = e10.querySelector(a10);
            c10 && !s10(c10) && (i10 = c10);
          } catch {
          }
      }, true), n10.addEventListener(e10, "touchmove", (o10) => {
        o10.target instanceof HTMLElement && !s10(o10.target) && o10.preventDefault();
      }, { passive: false }), n10.add(() => {
        window.scrollTo(0, window.pageYOffset + t10), i10 && i10.isConnected && (i10.scrollIntoView({ block: "nearest" }), i10 = null);
      });
    } };
  }
  function hS() {
    return { before({ doc: t10, d: e10 }) {
      e10.style(t10.documentElement, "overflow", "hidden");
    } };
  }
  function dS(t10) {
    let e10 = {};
    for (let n10 of t10)
      Object.assign(e10, n10(e10));
    return e10;
  }
  let Or = aS(() => /* @__PURE__ */ new Map(), { PUSH(t10, e10) {
    var n10;
    let r10 = (n10 = this.get(t10)) != null ? n10 : { doc: t10, count: 0, d: Z0(), meta: /* @__PURE__ */ new Set() };
    return r10.count++, r10.meta.add(e10), this.set(t10, r10), this;
  }, POP(t10, e10) {
    let n10 = this.get(t10);
    return n10 && (n10.count--, n10.meta.delete(e10)), this;
  }, SCROLL_PREVENT({ doc: t10, d: e10, meta: n10 }) {
    let r10 = { doc: t10, d: e10, meta: dS(n10) }, s10 = [uS(), cS(), hS()];
    s10.forEach(({ before: i10 }) => i10 == null ? void 0 : i10(r10)), s10.forEach(({ after: i10 }) => i10 == null ? void 0 : i10(r10));
  }, SCROLL_ALLOW({ d: t10 }) {
    t10.dispose();
  }, TEARDOWN({ doc: t10 }) {
    this.delete(t10);
  } });
  Or.subscribe(() => {
    let t10 = Or.getSnapshot(), e10 = /* @__PURE__ */ new Map();
    for (let [n10] of t10)
      e10.set(n10, n10.documentElement.style.overflow);
    for (let n10 of t10.values()) {
      let r10 = e10.get(n10.doc) === "hidden", s10 = n10.count !== 0;
      (s10 && !r10 || !s10 && r10) && Or.dispatch(n10.count > 0 ? "SCROLL_PREVENT" : "SCROLL_ALLOW", n10), n10.count === 0 && Or.dispatch("TEARDOWN", n10);
    }
  });
  function fS(t10, e10, n10) {
    let r10 = lS(Or), s10 = G$1(() => {
      let i10 = t10.value ? r10.value.get(t10.value) : void 0;
      return i10 ? i10.count > 0 : false;
    });
    return Yt$1([t10, e10], ([i10, o10], [l10], a10) => {
      if (!i10 || !o10)
        return;
      Or.dispatch("PUSH", i10, n10);
      let c10 = false;
      a10(() => {
        c10 || (Or.dispatch("POP", l10 != null ? l10 : i10, n10), c10 = true);
      });
    }, { immediate: true }), s10;
  }
  function pS({ defaultContainers: t10 = [], portals: e10, mainTreeNodeRef: n10 } = {}) {
    let r10 = ge(null), s10 = Sn$1(r10);
    function i10() {
      var o10;
      let l10 = [];
      for (let a10 of t10)
        a10 !== null && (a10 instanceof HTMLElement ? l10.push(a10) : "value" in a10 && a10.value instanceof HTMLElement && l10.push(a10.value));
      if (e10 != null && e10.value)
        for (let a10 of e10.value)
          l10.push(a10);
      for (let a10 of (o10 = s10 == null ? void 0 : s10.querySelectorAll("html > *, body > *")) != null ? o10 : [])
        a10 !== document.body && a10 !== document.head && a10 instanceof HTMLElement && a10.id !== "headlessui-portal-root" && (a10.contains(st(r10)) || l10.some((c10) => a10.contains(c10)) || l10.push(a10));
      return l10;
    }
    return { resolveContainers: i10, contains(o10) {
      return i10().some((l10) => l10.contains(o10));
    }, mainTreeNodeRef: r10, MainTreeNode() {
      return n10 != null ? null : ct(Zi, { features: y0.Hidden, ref: r10 });
    } };
  }
  var gS = ((t10) => (t10[t10.Open = 0] = "Open", t10[t10.Closed = 1] = "Closed", t10))(gS || {});
  let fl = Symbol("DialogContext");
  function W0(t10) {
    let e10 = lt(fl, null);
    if (e10 === null) {
      let n10 = new Error(`<${t10} /> is missing a parent <Dialog /> component.`);
      throw Error.captureStackTrace && Error.captureStackTrace(n10, W0), n10;
    }
    return e10;
  }
  let mi = "DC8F892D-2EBD-447C-A4C8-A03058436FF4", mS = Ye$1({ name: "Dialog", inheritAttrs: false, props: { as: { type: [Object, String], default: "div" }, static: { type: Boolean, default: false }, unmount: { type: Boolean, default: true }, open: { type: [Boolean, String], default: mi }, initialFocus: { type: Object, default: null }, id: { type: String, default: () => `headlessui-dialog-${Bn()}` } }, emits: { close: (t10) => true }, setup(t10, { emit: e10, attrs: n10, slots: r10, expose: s10 }) {
    var i10;
    let o10 = ge(false);
    We$1(() => {
      o10.value = true;
    });
    let l10 = ge(0), a10 = xc(), c10 = G$1(() => t10.open === mi && a10 !== null ? (a10.value & qt$1.Open) === qt$1.Open : t10.open), u10 = ge(null), h10 = G$1(() => Sn$1(u10));
    if (s10({ el: u10, $el: u10 }), !(t10.open !== mi || a10 !== null))
      throw new Error("You forgot to provide an `open` prop to the `Dialog`.");
    if (typeof c10.value != "boolean")
      throw new Error(`You provided an \`open\` prop to the \`Dialog\`, but the value is not a boolean. Received: ${c10.value === mi ? void 0 : t10.open}`);
    let d10 = G$1(() => o10.value && c10.value ? 0 : 1), p10 = G$1(() => d10.value === 0), g = G$1(() => l10.value > 1), L = lt(fl, null) !== null, [T, _10] = nS(), { resolveContainers: x, mainTreeNodeRef: C, MainTreeNode: E } = pS({ portals: T, defaultContainers: [G$1(() => {
      var X10;
      return (X10 = Le2.panelRef.value) != null ? X10 : u10.value;
    })] }), M10 = G$1(() => g.value ? "parent" : "leaf"), $ = G$1(() => a10 !== null ? (a10.value & qt$1.Closing) === qt$1.Closing : false), j = G$1(() => L || $.value ? false : p10.value), R = G$1(() => {
      var X10, de2, Xe2;
      return (Xe2 = Array.from((de2 = (X10 = h10.value) == null ? void 0 : X10.querySelectorAll("body > *")) != null ? de2 : []).find((Qe2) => Qe2.id === "headlessui-portal-root" ? false : Qe2.contains(st(C)) && Qe2 instanceof HTMLElement)) != null ? Xe2 : null;
    });
    pu(R, j);
    let ae2 = G$1(() => g.value ? true : p10.value), le2 = G$1(() => {
      var X10, de2, Xe2;
      return (Xe2 = Array.from((de2 = (X10 = h10.value) == null ? void 0 : X10.querySelectorAll("[data-headlessui-portal]")) != null ? de2 : []).find((Qe2) => Qe2.contains(st(C)) && Qe2 instanceof HTMLElement)) != null ? Xe2 : null;
    });
    pu(le2, ae2), iS({ type: "Dialog", enabled: G$1(() => d10.value === 0), element: u10, onUpdate: (X10, de2) => {
      if (de2 === "Dialog")
        return Nn(X10, { [dl.Add]: () => l10.value += 1, [dl.Remove]: () => l10.value -= 1 });
    } });
    let he = _c({ name: "DialogDescription", slot: G$1(() => ({ open: c10.value })) }), He2 = ge(null), Le2 = { titleId: He2, panelRef: ge(null), dialogState: d10, setTitleId(X10) {
      He2.value !== X10 && (He2.value = X10);
    }, close() {
      e10("close", false);
    } };
    Ut$1(fl, Le2);
    let re2 = G$1(() => !(!p10.value || g.value));
    GT(x, (X10, de2) => {
      Le2.close(), gr(() => de2 == null ? void 0 : de2.focus());
    }, re2);
    let Ne2 = G$1(() => !(g.value || d10.value !== 0));
    $h((i10 = h10.value) == null ? void 0 : i10.defaultView, "keydown", (X10) => {
      Ne2.value && (X10.defaultPrevented || X10.key === sr.Escape && (X10.preventDefault(), X10.stopPropagation(), Le2.close()));
    });
    let D10 = G$1(() => !($.value || d10.value !== 0 || L));
    return fS(h10, D10, (X10) => {
      var de2;
      return { containers: [...(de2 = X10.containers) != null ? de2 : [], x] };
    }), Qt$1((X10) => {
      if (d10.value !== 0)
        return;
      let de2 = st(u10);
      if (!de2)
        return;
      let Xe2 = new ResizeObserver((Qe2) => {
        for (let Ot of Qe2) {
          let it = Ot.target.getBoundingClientRect();
          it.x === 0 && it.y === 0 && it.width === 0 && it.height === 0 && Le2.close();
        }
      });
      Xe2.observe(de2), X10(() => Xe2.disconnect());
    }), () => {
      let { id: X10, open: de2, initialFocus: Xe2, ...Qe2 } = t10, Ot = { ...n10, ref: u10, id: X10, role: "dialog", "aria-modal": d10.value === 0 ? true : void 0, "aria-labelledby": He2.value, "aria-describedby": he.value }, it = { open: d10.value === 0 };
      return ct(ul, { force: true }, () => [ct(Gh, () => ct(rS, { target: u10.value }, () => ct(ul, { force: false }, () => ct(Ws, { initialFocus: Xe2, containers: x, features: p10.value ? Nn(M10.value, { parent: Ws.features.RestoreFocus, leaf: Ws.features.All & ~Ws.features.FocusLock }) : Ws.features.None }, () => ct(_10, {}, () => wt({ ourProps: Ot, theirProps: { ...Qe2, ...n10 }, slot: it, attrs: n10, slots: r10, visible: d10.value === 0, features: Gi.RenderStrategy | Gi.Static, name: "Dialog" })))))), ct(E)]);
    };
  } });
  Ye$1({ name: "DialogOverlay", props: { as: { type: [Object, String], default: "div" }, id: { type: String, default: () => `headlessui-dialog-overlay-${Bn()}` } }, setup(t10, { attrs: e10, slots: n10 }) {
    let r10 = W0("DialogOverlay");
    function s10(i10) {
      i10.target === i10.currentTarget && (i10.preventDefault(), i10.stopPropagation(), r10.close());
    }
    return () => {
      let { id: i10, ...o10 } = t10;
      return wt({ ourProps: { id: i10, "aria-hidden": true, onClick: s10 }, theirProps: o10, slot: { open: r10.dialogState.value === 0 }, attrs: e10, slots: n10, name: "DialogOverlay" });
    };
  } });
  Ye$1({ name: "DialogBackdrop", props: { as: { type: [Object, String], default: "div" }, id: { type: String, default: () => `headlessui-dialog-backdrop-${Bn()}` } }, inheritAttrs: false, setup(t10, { attrs: e10, slots: n10, expose: r10 }) {
    let s10 = W0("DialogBackdrop"), i10 = ge(null);
    return r10({ el: i10, $el: i10 }), We$1(() => {
      if (s10.panelRef.value === null)
        throw new Error("A <DialogBackdrop /> component is being used, but a <DialogPanel /> component is missing.");
    }), () => {
      let { id: o10, ...l10 } = t10, a10 = { id: o10, ref: i10, "aria-hidden": true };
      return ct(ul, { force: true }, () => ct(Gh, () => wt({ ourProps: a10, theirProps: { ...e10, ...l10 }, slot: { open: s10.dialogState.value === 0 }, attrs: e10, slots: n10, name: "DialogBackdrop" })));
    };
  } });
  let xS = Ye$1({ name: "DialogPanel", props: { as: { type: [Object, String], default: "div" }, id: { type: String, default: () => `headlessui-dialog-panel-${Bn()}` } }, setup(t10, { attrs: e10, slots: n10, expose: r10 }) {
    let s10 = W0("DialogPanel");
    r10({ el: s10.panelRef, $el: s10.panelRef });
    function i10(o10) {
      o10.stopPropagation();
    }
    return () => {
      let { id: o10, ...l10 } = t10, a10 = { id: o10, ref: s10.panelRef, onClick: i10 };
      return wt({ ourProps: a10, theirProps: l10, slot: { open: s10.dialogState.value === 0 }, attrs: e10, slots: n10, name: "DialogPanel" });
    };
  } }), LS = Ye$1({ name: "DialogTitle", props: { as: { type: [Object, String], default: "h2" }, id: { type: String, default: () => `headlessui-dialog-title-${Bn()}` } }, setup(t10, { attrs: e10, slots: n10 }) {
    let r10 = W0("DialogTitle");
    return We$1(() => {
      r10.setTitleId(t10.id), ht(() => r10.setTitleId(null));
    }), () => {
      let { id: s10, ...i10 } = t10;
      return wt({ ourProps: { id: s10 }, theirProps: i10, slot: { open: r10.dialogState.value === 0 }, attrs: e10, slots: n10, name: "DialogTitle" });
    };
  } }), qh = Symbol("LabelContext");
  function Kh() {
    let t10 = lt(qh, null);
    if (t10 === null) {
      let e10 = new Error("You used a <Label /> component, but it is not inside a parent.");
      throw Error.captureStackTrace && Error.captureStackTrace(e10, Kh), e10;
    }
    return t10;
  }
  function Yh({ slot: t10 = {}, name: e10 = "Label", props: n10 = {} } = {}) {
    let r10 = ge([]);
    function s10(i10) {
      return r10.value.push(i10), () => {
        let o10 = r10.value.indexOf(i10);
        o10 !== -1 && r10.value.splice(o10, 1);
      };
    }
    return Ut$1(qh, { register: s10, slot: t10, name: e10, props: n10 }), G$1(() => r10.value.length > 0 ? r10.value.join(" ") : void 0);
  }
  let _S = Ye$1({ name: "Label", props: { as: { type: [Object, String], default: "label" }, passive: { type: [Boolean], default: false }, id: { type: String, default: () => `headlessui-label-${Bn()}` } }, setup(t10, { slots: e10, attrs: n10 }) {
    let r10 = Kh();
    return We$1(() => ht(r10.register(t10.id))), () => {
      let { name: s10 = "Label", slot: i10 = {}, props: o10 = {} } = r10, { id: l10, passive: a10, ...c10 } = t10, u10 = { ...Object.entries(o10).reduce((h10, [d10, p10]) => Object.assign(h10, { [d10]: _e(p10) }), {}), id: l10 };
      return a10 && (delete u10.onClick, delete u10.htmlFor, delete c10.onClick), wt({ ourProps: u10, theirProps: c10, slot: i10, attrs: n10, slots: e10, name: s10 });
    };
  } });
  function yS(t10, e10) {
    return t10 === e10;
  }
  let Xh = Symbol("RadioGroupContext");
  function Qh(t10) {
    let e10 = lt(Xh, null);
    if (e10 === null) {
      let n10 = new Error(`<${t10} /> is missing a parent <RadioGroup /> component.`);
      throw Error.captureStackTrace && Error.captureStackTrace(n10, Qh), n10;
    }
    return e10;
  }
  let CS = Ye$1({ name: "RadioGroup", emits: { "update:modelValue": (t10) => true }, props: { as: { type: [Object, String], default: "div" }, disabled: { type: [Boolean], default: false }, by: { type: [String, Function], default: () => yS }, modelValue: { type: [Object, String, Number, Boolean], default: void 0 }, defaultValue: { type: [Object, String, Number, Boolean], default: void 0 }, form: { type: String, optional: true }, name: { type: String, optional: true }, id: { type: String, default: () => `headlessui-radiogroup-${Bn()}` } }, inheritAttrs: false, setup(t10, { emit: e10, attrs: n10, slots: r10, expose: s10 }) {
    let i10 = ge(null), o10 = ge([]), l10 = Yh({ name: "RadioGroupLabel" }), a10 = _c({ name: "RadioGroupDescription" });
    s10({ el: i10, $el: i10 });
    let [c10, u10] = ZT(G$1(() => t10.modelValue), (g) => e10("update:modelValue", g), G$1(() => t10.defaultValue)), h10 = { options: o10, value: c10, disabled: G$1(() => t10.disabled), firstOption: G$1(() => o10.value.find((g) => !g.propsRef.disabled)), containsCheckedOption: G$1(() => o10.value.some((g) => h10.compare(we$1(g.propsRef.value), we$1(t10.modelValue)))), compare(g, L) {
      if (typeof t10.by == "string") {
        let T = t10.by;
        return (g == null ? void 0 : g[T]) === (L == null ? void 0 : L[T]);
      }
      return t10.by(g, L);
    }, change(g) {
      var L;
      if (t10.disabled || h10.compare(we$1(c10.value), we$1(g)))
        return false;
      let T = (L = o10.value.find((_10) => h10.compare(we$1(_10.propsRef.value), we$1(g)))) == null ? void 0 : L.propsRef;
      return T != null && T.disabled ? false : (u10(g), true);
    }, registerOption(g) {
      o10.value.push(g), o10.value = Nh(o10.value, (L) => L.element);
    }, unregisterOption(g) {
      let L = o10.value.findIndex((T) => T.id === g);
      L !== -1 && o10.value.splice(L, 1);
    } };
    Ut$1(Xh, h10), DT({ container: G$1(() => st(i10)), accept(g) {
      return g.getAttribute("role") === "radio" ? NodeFilter.FILTER_REJECT : g.hasAttribute("role") ? NodeFilter.FILTER_SKIP : NodeFilter.FILTER_ACCEPT;
    }, walk(g) {
      g.setAttribute("role", "none");
    } });
    function d10(g) {
      if (!i10.value || !i10.value.contains(g.target))
        return;
      let L = o10.value.filter((T) => T.propsRef.disabled === false).map((T) => T.element);
      switch (g.key) {
        case sr.Enter:
          jT(g.currentTarget);
          break;
        case sr.ArrowLeft:
        case sr.ArrowUp:
          if (g.preventDefault(), g.stopPropagation(), ps(L, ln$1.Previous | ln$1.WrapAround) === ji.Success) {
            let T = o10.value.find((_10) => {
              var x;
              return _10.element === ((x = Sn$1(i10)) == null ? void 0 : x.activeElement);
            });
            T && h10.change(T.propsRef.value);
          }
          break;
        case sr.ArrowRight:
        case sr.ArrowDown:
          if (g.preventDefault(), g.stopPropagation(), ps(L, ln$1.Next | ln$1.WrapAround) === ji.Success) {
            let T = o10.value.find((_10) => {
              var x;
              return _10.element === ((x = Sn$1(_10.element)) == null ? void 0 : x.activeElement);
            });
            T && h10.change(T.propsRef.value);
          }
          break;
        case sr.Space:
          {
            g.preventDefault(), g.stopPropagation();
            let T = o10.value.find((_10) => {
              var x;
              return _10.element === ((x = Sn$1(_10.element)) == null ? void 0 : x.activeElement);
            });
            T && h10.change(T.propsRef.value);
          }
          break;
      }
    }
    let p10 = G$1(() => {
      var g;
      return (g = st(i10)) == null ? void 0 : g.closest("form");
    });
    return We$1(() => {
      Yt$1([p10], () => {
        if (!p10.value || t10.defaultValue === void 0)
          return;
        function g() {
          h10.change(t10.defaultValue);
        }
        return p10.value.addEventListener("reset", g), () => {
          var L;
          (L = p10.value) == null || L.removeEventListener("reset", g);
        };
      }, { immediate: true });
    }), () => {
      let { disabled: g, name: L, id: T, form: _10, ...x } = t10, C = { ref: i10, id: T, role: "radiogroup", "aria-labelledby": l10.value, "aria-describedby": a10.value, onKeydown: d10 };
      return ct(Fe$1, [...L != null && c10.value != null ? Fh({ [L]: c10.value }).map(([E, M10]) => ct(Zi, AT({ features: y0.Hidden, key: E, as: "input", type: "hidden", hidden: true, readOnly: true, form: _10, name: E, value: M10 }))) : [], wt({ ourProps: C, theirProps: { ...n10, ...mc(x, ["modelValue", "defaultValue", "by"]) }, slot: {}, attrs: n10, slots: r10, name: "RadioGroup" })]);
    };
  } });
  var vS = ((t10) => (t10[t10.Empty = 1] = "Empty", t10[t10.Active = 2] = "Active", t10))(vS || {});
  let bS = Ye$1({ name: "RadioGroupOption", props: { as: { type: [Object, String], default: "div" }, value: { type: [Object, String, Number, Boolean] }, disabled: { type: Boolean, default: false }, id: { type: String, default: () => `headlessui-radiogroup-option-${Bn()}` } }, setup(t10, { attrs: e10, slots: n10, expose: r10 }) {
    let s10 = Qh("RadioGroupOption"), i10 = Yh({ name: "RadioGroupLabel" }), o10 = _c({ name: "RadioGroupDescription" }), l10 = ge(null), a10 = G$1(() => ({ value: t10.value, disabled: t10.disabled })), c10 = ge(1);
    r10({ el: l10, $el: l10 });
    let u10 = G$1(() => st(l10));
    We$1(() => s10.registerOption({ id: t10.id, element: u10, propsRef: a10 })), ht(() => s10.unregisterOption(t10.id));
    let h10 = G$1(() => {
      var x;
      return ((x = s10.firstOption.value) == null ? void 0 : x.id) === t10.id;
    }), d10 = G$1(() => s10.disabled.value || t10.disabled), p10 = G$1(() => s10.compare(we$1(s10.value.value), we$1(t10.value))), g = G$1(() => d10.value ? -1 : p10.value || !s10.containsCheckedOption.value && h10.value ? 0 : -1);
    function L() {
      var x;
      s10.change(t10.value) && (c10.value |= 2, (x = st(l10)) == null || x.focus());
    }
    function T() {
      c10.value |= 2;
    }
    function _10() {
      c10.value &= -3;
    }
    return () => {
      let { id: x, value: C, disabled: E, ...M10 } = t10, $ = { checked: p10.value, disabled: d10.value, active: Boolean(c10.value & 2) }, j = { id: x, ref: l10, role: "radio", "aria-checked": p10.value ? "true" : "false", "aria-labelledby": i10.value, "aria-describedby": o10.value, "aria-disabled": d10.value ? true : void 0, tabIndex: g.value, onClick: d10.value ? void 0 : L, onFocus: d10.value ? void 0 : T, onBlur: d10.value ? void 0 : _10 };
      return wt({ ourProps: j, theirProps: M10, slot: $, attrs: e10, slots: n10, name: "RadioGroupOption" });
    };
  } }), gu = _S;
  function wS(t10) {
    let e10 = { called: false };
    return (...n10) => {
      if (!e10.called)
        return e10.called = true, t10(...n10);
    };
  }
  function go(t10, ...e10) {
    t10 && e10.length > 0 && t10.classList.add(...e10);
  }
  function xi(t10, ...e10) {
    t10 && e10.length > 0 && t10.classList.remove(...e10);
  }
  var pl = ((t10) => (t10.Finished = "finished", t10.Cancelled = "cancelled", t10))(pl || {});
  function ES(t10, e10) {
    let n10 = Z0();
    if (!t10)
      return n10.dispose;
    let { transitionDuration: r10, transitionDelay: s10 } = getComputedStyle(t10), [i10, o10] = [r10, s10].map((l10) => {
      let [a10 = 0] = l10.split(",").filter(Boolean).map((c10) => c10.includes("ms") ? parseFloat(c10) : parseFloat(c10) * 1e3).sort((c10, u10) => u10 - c10);
      return a10;
    });
    return i10 !== 0 ? n10.setTimeout(() => e10("finished"), i10 + o10) : e10("finished"), n10.add(() => e10("cancelled")), n10.dispose;
  }
  function mu(t10, e10, n10, r10, s10, i10) {
    let o10 = Z0(), l10 = i10 !== void 0 ? wS(i10) : () => {
    };
    return xi(t10, ...s10), go(t10, ...e10, ...n10), o10.nextFrame(() => {
      xi(t10, ...n10), go(t10, ...r10), o10.add(ES(t10, (a10) => (xi(t10, ...r10, ...e10), go(t10, ...s10), l10(a10))));
    }), o10.add(() => xi(t10, ...e10, ...n10, ...r10, ...s10)), o10.add(() => l10("cancelled")), o10.dispose;
  }
  function wr(t10 = "") {
    return t10.split(" ").filter((e10) => e10.trim().length > 1);
  }
  let yc = Symbol("TransitionContext");
  var TS = ((t10) => (t10.Visible = "visible", t10.Hidden = "hidden", t10))(TS || {});
  function SS() {
    return lt(yc, null) !== null;
  }
  function AS() {
    let t10 = lt(yc, null);
    if (t10 === null)
      throw new Error("A <TransitionChild /> is used but it is missing a parent <TransitionRoot />.");
    return t10;
  }
  function kS() {
    let t10 = lt(Cc, null);
    if (t10 === null)
      throw new Error("A <TransitionChild /> is used but it is missing a parent <TransitionRoot />.");
    return t10;
  }
  let Cc = Symbol("NestingContext");
  function U1(t10) {
    return "children" in t10 ? U1(t10.children) : t10.value.filter(({ state: e10 }) => e10 === "visible").length > 0;
  }
  function Jh(t10) {
    let e10 = ge([]), n10 = ge(false);
    We$1(() => n10.value = true), ht(() => n10.value = false);
    function r10(i10, o10 = lr.Hidden) {
      let l10 = e10.value.findIndex(({ id: a10 }) => a10 === i10);
      l10 !== -1 && (Nn(o10, { [lr.Unmount]() {
        e10.value.splice(l10, 1);
      }, [lr.Hidden]() {
        e10.value[l10].state = "hidden";
      } }), !U1(e10) && n10.value && (t10 == null || t10()));
    }
    function s10(i10) {
      let o10 = e10.value.find(({ id: l10 }) => l10 === i10);
      return o10 ? o10.state !== "visible" && (o10.state = "visible") : e10.value.push({ id: i10, state: "visible" }), () => r10(i10, lr.Unmount);
    }
    return { children: e10, register: s10, unregister: r10 };
  }
  let e6 = Gi.RenderStrategy, gl = Ye$1({ props: { as: { type: [Object, String], default: "div" }, show: { type: [Boolean], default: null }, unmount: { type: [Boolean], default: true }, appear: { type: [Boolean], default: false }, enter: { type: [String], default: "" }, enterFrom: { type: [String], default: "" }, enterTo: { type: [String], default: "" }, entered: { type: [String], default: "" }, leave: { type: [String], default: "" }, leaveFrom: { type: [String], default: "" }, leaveTo: { type: [String], default: "" } }, emits: { beforeEnter: () => true, afterEnter: () => true, beforeLeave: () => true, afterLeave: () => true }, setup(t10, { emit: e10, attrs: n10, slots: r10, expose: s10 }) {
    let i10 = ge(0);
    function o10() {
      i10.value |= qt$1.Opening, e10("beforeEnter");
    }
    function l10() {
      i10.value &= ~qt$1.Opening, e10("afterEnter");
    }
    function a10() {
      i10.value |= qt$1.Closing, e10("beforeLeave");
    }
    function c10() {
      i10.value &= ~qt$1.Closing, e10("afterLeave");
    }
    if (!SS() && IT())
      return () => ct(t6, { ...t10, onBeforeEnter: o10, onAfterEnter: l10, onBeforeLeave: a10, onAfterLeave: c10 }, r10);
    let u10 = ge(null), h10 = G$1(() => t10.unmount ? lr.Unmount : lr.Hidden);
    s10({ el: u10, $el: u10 });
    let { show: d10, appear: p10 } = AS(), { register: g, unregister: L } = kS(), T = ge(d10.value ? "visible" : "hidden"), _10 = { value: true }, x = Bn(), C = { value: false }, E = Jh(() => {
      !C.value && T.value !== "hidden" && (T.value = "hidden", L(x), c10());
    });
    We$1(() => {
      let Le2 = g(x);
      ht(Le2);
    }), Qt$1(() => {
      if (h10.value === lr.Hidden && x) {
        if (d10.value && T.value !== "visible") {
          T.value = "visible";
          return;
        }
        Nn(T.value, { hidden: () => L(x), visible: () => g(x) });
      }
    });
    let M10 = wr(t10.enter), $ = wr(t10.enterFrom), j = wr(t10.enterTo), R = wr(t10.entered), ae2 = wr(t10.leave), le2 = wr(t10.leaveFrom), he = wr(t10.leaveTo);
    We$1(() => {
      Qt$1(() => {
        if (T.value === "visible") {
          let Le2 = st(u10);
          if (Le2 instanceof Comment && Le2.data === "")
            throw new Error("Did you forget to passthrough the `ref` to the actual DOM node?");
        }
      });
    });
    function He2(Le2) {
      let re2 = _10.value && !p10.value, Ne2 = st(u10);
      !Ne2 || !(Ne2 instanceof HTMLElement) || re2 || (C.value = true, d10.value && o10(), d10.value || a10(), Le2(d10.value ? mu(Ne2, M10, $, j, R, (D10) => {
        C.value = false, D10 === pl.Finished && l10();
      }) : mu(Ne2, ae2, le2, he, R, (D10) => {
        C.value = false, D10 === pl.Finished && (U1(E) || (T.value = "hidden", L(x), c10()));
      })));
    }
    return We$1(() => {
      Yt$1([d10], (Le2, re2, Ne2) => {
        He2(Ne2), _10.value = false;
      }, { immediate: true });
    }), Ut$1(Cc, E), MT(G$1(() => Nn(T.value, { visible: qt$1.Open, hidden: qt$1.Closed }) | i10.value)), () => {
      let { appear: Le2, show: re2, enter: Ne2, enterFrom: D10, enterTo: X10, entered: de2, leave: Xe2, leaveFrom: Qe2, leaveTo: Ot, ...it } = t10, N = { ref: u10 }, se2 = { ...it, ...p10.value && d10.value && j0.isServer ? { class: ve$1([n10.class, it.class, ...M10, ...$]) } : {} };
      return wt({ theirProps: se2, ourProps: N, slot: {}, slots: r10, attrs: n10, features: e6, visible: T.value === "visible", name: "TransitionChild" });
    };
  } }), RS = gl, t6 = Ye$1({ inheritAttrs: false, props: { as: { type: [Object, String], default: "div" }, show: { type: [Boolean], default: null }, unmount: { type: [Boolean], default: true }, appear: { type: [Boolean], default: false }, enter: { type: [String], default: "" }, enterFrom: { type: [String], default: "" }, enterTo: { type: [String], default: "" }, entered: { type: [String], default: "" }, leave: { type: [String], default: "" }, leaveFrom: { type: [String], default: "" }, leaveTo: { type: [String], default: "" } }, emits: { beforeEnter: () => true, afterEnter: () => true, beforeLeave: () => true, afterLeave: () => true }, setup(t10, { emit: e10, attrs: n10, slots: r10 }) {
    let s10 = xc(), i10 = G$1(() => t10.show === null && s10 !== null ? (s10.value & qt$1.Open) === qt$1.Open : t10.show);
    Qt$1(() => {
      if (![true, false].includes(i10.value))
        throw new Error('A <Transition /> is used but it is missing a `:show="true | false"` prop.');
    });
    let o10 = ge(i10.value ? "visible" : "hidden"), l10 = Jh(() => {
      o10.value = "hidden";
    }), a10 = ge(true), c10 = { show: i10, appear: G$1(() => t10.appear || !a10.value) };
    return We$1(() => {
      Qt$1(() => {
        a10.value = false, i10.value ? o10.value = "visible" : U1(l10) || (o10.value = "hidden");
      });
    }), Ut$1(Cc, l10), Ut$1(yc, c10), () => {
      let u10 = mc(t10, ["show", "appear", "unmount", "onBeforeEnter", "onBeforeLeave", "onAfterEnter", "onAfterLeave"]), h10 = { unmount: t10.unmount };
      return wt({ ourProps: { ...h10, as: "template" }, theirProps: {}, slot: {}, slots: { ...r10, default: () => [ct(RS, { onBeforeEnter: () => e10("beforeEnter"), onAfterEnter: () => e10("afterEnter"), onBeforeLeave: () => e10("beforeLeave"), onAfterLeave: () => e10("afterLeave"), ...n10, ...h10, ...u10 }, r10.default)] }, attrs: {}, features: e6, visible: o10.value === "visible", name: "Transition" });
    };
  } });
  const OS = `<svg width="100%" height="100%" viewBox="0 0 200 130" fill="none" xmlns="http://www.w3.org/2000/svg">
  <rect width="200" height="130" fill="white"/>
  <rect x="21" y="19" width="40" height="16" stroke="#666666" stroke-width="2"/>
  <rect x="43" y="46" width="65" height="8" transform="rotate(90 43 46)" fill="#D9D9D9" stroke="#666666" stroke-width="2"/>
  <rect x="104" y="46" width="29" height="8" transform="rotate(90 104 46)" fill="#D9D9D9" stroke="#666666" stroke-width="2"/>
  <rect x="163" y="82" width="29" height="8" transform="rotate(90 163 82)" fill="#D9D9D9" stroke="#666666" stroke-width="2"/>
  <rect x="139" y="19" width="40" height="16" stroke="#666666" stroke-width="2"/>
  <rect x="80" y="19" width="40" height="16" stroke="#666666" stroke-width="2"/>
  <line x1="44" y1="59" x2="95" y2="59" stroke="#666666" stroke-width="2"/>
  <line x1="44" y1="96" x2="154" y2="96" stroke="#666666" stroke-width="2"/>
  <rect x="28" y="25" width="26" height="4" fill="#666666"/>
  <rect x="88" y="25" width="26" height="4" fill="#666666"/>
  <rect x="147" y="25" width="26" height="4" fill="#666666"/>
</svg>
`, IS = `<svg width="100%" height="100%" viewBox="0 0 200 130" fill="none" xmlns="http://www.w3.org/2000/svg">
  <rect width="200" height="130" fill="white"/>
  <rect x="21" y="19" width="40" height="16" stroke="#368EFF" stroke-width="2"/>
  <rect x="43" y="46" width="65" height="8" transform="rotate(90 43 46)" fill="#EBF4FF" stroke="#368EFF" stroke-width="2"/>
  <rect x="104" y="46" width="29" height="8" transform="rotate(90 104 46)" fill="#EBF4FF" stroke="#368EFF" stroke-width="2"/>
  <rect x="163" y="82" width="29" height="8" transform="rotate(90 163 82)" fill="#EBF4FF" stroke="#368EFF" stroke-width="2"/>
  <rect x="139" y="19" width="40" height="16" stroke="#368EFF" stroke-width="2"/>
  <rect x="80" y="19" width="40" height="16" stroke="#368EFF" stroke-width="2"/>
  <line x1="44" y1="59" x2="95" y2="59" stroke="#368EFF" stroke-width="2"/>
  <line x1="44" y1="96" x2="154" y2="96" stroke="#368EFF" stroke-width="2"/>
  <rect x="28" y="25" width="26" height="4" fill="#368EFF"/>
  <rect x="88" y="25" width="26" height="4" fill="#368EFF"/>
  <rect x="147" y="25" width="26" height="4" fill="#368EFF"/>
</svg>
`, MS = `<svg width="100%" height="100%" viewBox="0 0 200 130" fill="none" xmlns="http://www.w3.org/2000/svg">
  <rect width="200" height="130" fill="#202126"/>
  <rect x="21" y="19" width="40" height="16" stroke="#368EFF" stroke-width="2"/>
  <rect x="43" y="46" width="65" height="8" transform="rotate(90 43 46)" fill="#222C3C" stroke="#368EFF" stroke-width="2"/>
  <rect x="104" y="46" width="29" height="8" transform="rotate(90 104 46)" fill="#222C3C" stroke="#368EFF" stroke-width="2"/>
  <rect x="163" y="82" width="29" height="8" transform="rotate(90 163 82)" fill="#222C3C" stroke="#368EFF" stroke-width="2"/>
  <rect x="139" y="19" width="40" height="16" stroke="#368EFF" stroke-width="2"/>
  <rect x="80" y="19" width="40" height="16" stroke="#368EFF" stroke-width="2"/>
  <line x1="44" y1="59" x2="95" y2="59" stroke="#368EFF" stroke-width="2"/>
  <line x1="44" y1="96" x2="154" y2="96" stroke="#368EFF" stroke-width="2"/>
  <rect x="28" y="25" width="26" height="4" fill="#368EFF"/>
  <rect x="87" y="25" width="26" height="4" fill="#368EFF"/>
  <rect x="146" y="25" width="26" height="4" fill="#368EFF"/>
</svg>
`, NS = /* @__PURE__ */ A("div", { class: "fixed inset-0 bg-black bg-opacity-25" }, null, -1), PS = { class: "fixed inset-0 overflow-y-auto" }, FS = { class: "flex min-h-full items-center justify-center p-4 text-center" }, DS = /* @__PURE__ */ A("p", { class: "text-gray-500 text-sm" }, "Customize your UI theme", -1), BS = { class: "mt-4" }, $S = { class: "space-y-2" }, HS = { class: "flex w-full items-center justify-between" }, US = { class: "flex items-center text-sm text-gray-900" }, VS = ["innerHTML"], zS = {
    __name: "ThemeSelect",
    setup(t10) {
      const e10 = ge(false), n10 = [
        {
          name: "Legacy",
          id: "theme-default",
          icon: OS
        },
        {
          name: "Clean Light",
          id: "theme-clean-light",
          icon: IS
        },
        {
          name: "Clean Dark",
          id: "theme-clean-dark",
          icon: MS
        }
      ], r10 = Fn(), s10 = ge(r10.state.theme || n10[0].id), i10 = () => {
        e10.value = false;
      }, o10 = () => {
        e10.value = true;
      }, l10 = (a10) => {
        s10.value = a10, r10.commit("setTheme", a10);
      };
      return (a10, c10) => (k$1(), q$1(Fe$1, null, [
        A("button", {
          type: "button",
          class: "flex items-center",
          onClick: o10
        }, [
          V$1(dr, { name: "theme" })
        ]),
        V$1(_e(t6), {
          appear: "",
          show: e10.value,
          as: "template"
        }, {
          default: jt$1(() => [
            V$1(_e(mS), {
              as: "div",
              onClose: i10,
              class: "relative z-10"
            }, {
              default: jt$1(() => [
                V$1(_e(gl), {
                  as: "template",
                  enter: "duration-300 ease-out",
                  "enter-from": "opacity-0",
                  "enter-to": "opacity-100",
                  leave: "duration-200 ease-in",
                  "leave-from": "opacity-100",
                  "leave-to": "opacity-0"
                }, {
                  default: jt$1(() => [
                    NS
                  ], void 0, true),
                  _: 1
                }),
                A("div", PS, [
                  A("div", FS, [
                    V$1(_e(gl), {
                      as: "template",
                      enter: "duration-300 ease-out",
                      "enter-from": "opacity-0 scale-95",
                      "enter-to": "opacity-100 scale-100",
                      leave: "duration-200 ease-in",
                      "leave-from": "opacity-100 scale-100",
                      "leave-to": "opacity-0 scale-95"
                    }, {
                      default: jt$1(() => [
                        V$1(_e(xS), { class: "w-full max-w-md transform overflow-hidden rounded-2xl bg-white p-6 text-left align-middle shadow-xl transition-all" }, {
                          default: jt$1(() => [
                            V$1(_e(LS), {
                              as: "h3",
                              class: "text-lg font-semibold leading-6 text-gray-900"
                            }, {
                              default: jt$1(() => [
                                dn$1(" Theme ")
                              ], void 0, true),
                              _: 1
                            }),
                            DS,
                            A("div", BS, [
                              A("div", null, [
                                V$1(_e(CS), {
                                  "model-value": s10.value,
                                  "onUpdate:modelValue": l10
                                }, {
                                  default: jt$1(() => [
                                    V$1(_e(gu), { class: "sr-only" }, {
                                      default: jt$1(() => [
                                        dn$1("Server size")
                                      ], void 0, true),
                                      _: 1
                                    }),
                                    A("div", $S, [
                                      (k$1(), q$1(Fe$1, null, On$1(n10, (u10) => V$1(_e(bS), {
                                        as: "template",
                                        key: u10.id,
                                        value: u10.id
                                      }, {
                                        default: jt$1(({ checked: h10 }) => [
                                          A("div", {
                                            class: ve$1([[
                                              h10 ? "border-2 text-gray-900 border-primary" : "border-2 border-transparent"
                                            ], "relative flex items-center cursor-pointer rounded-lg px-4 py-3 shadow-md"])
                                          }, [
                                            A("div", HS, [
                                              A("div", US, [
                                                h10 ? (k$1(), Re$1(dr, {
                                                  key: 0,
                                                  name: "selected-cycle",
                                                  "icon-class": "h-5 w-5 fill-none"
                                                })) : (k$1(), Re$1(dr, {
                                                  key: 1,
                                                  name: "non-selected-cycle",
                                                  "icon-class": "h-5 w-5"
                                                })),
                                                V$1(_e(gu), {
                                                  as: "p",
                                                  class: ve$1([
                                                    "text-gray-900",
                                                    "font-medium ml-2"
                                                  ])
                                                }, {
                                                  default: jt$1(() => [
                                                    dn$1(Ve$1(u10.name), 1)
                                                  ], void 0, true),
                                                  _: 2
                                                }, 1032, ["class"])
                                              ])
                                            ]),
                                            A("span", {
                                              class: "inline-block w-20 border rounded-md overflow-hidden",
                                              innerHTML: u10.icon
                                            }, null, 8, VS)
                                          ], 2)
                                        ]),
                                        _: 2
                                      }, 1032, ["value"])), 64))
                                    ])
                                  ], void 0, true),
                                  _: 1
                                }, 8, ["model-value"])
                              ])
                            ])
                          ], void 0, true),
                          _: 1
                        })
                      ], void 0, true),
                      _: 1
                    })
                  ])
                ])
              ], void 0, true),
              _: 1
            })
          ], void 0, true),
          _: 1
        }, 8, ["show"])
      ], 64));
    }
  }, GS = {
    name: "DiagramFrame",
    setup() {
      return {
        RenderMode: Gn
      };
    },
    computed: {
      ...yr([
        "showTips",
        "scale",
        "theme",
        "numbering",
        "enableMultiTheme",
        "mode"
      ]),
      ...pn$1(["rootContext"]),
      title() {
        var t10;
        return this.rootContext || console.error(
          "`rootContext` is empty. Please make sure `store` is properly configured."
        ), (t10 = this.rootContext) == null ? void 0 : t10.title();
      }
    },
    mounted() {
      this.$el.__vue__ = this;
    },
    methods: {
      ...V5(["setScale", "toggleNumbering"]),
      showTipsDialog() {
        var t10;
        this.$store.state.showTips = true;
        try {
          (t10 = this.$gtag) == null || t10.event("view", {
            event_category: "help",
            event_label: "tips dialog"
          });
        } catch (e10) {
          console.error(e10);
        }
      },
      toPng() {
        return xT(this.$refs.export, {
          backgroundColor: "white",
          filter: (t10) => {
            var e10;
            return !((e10 = t10 == null ? void 0 : t10.classList) != null && e10.contains("hide-export"));
          }
        });
      },
      toSvg() {
        return kh(this.$refs.export, {
          backgroundColor: "white",
          filter: (t10) => {
            var e10;
            return !((e10 = t10 == null ? void 0 : t10.classList) != null && e10.contains("hide-export"));
          }
        });
      },
      toBlob() {
        return _T(this.$refs.export, {
          backgroundColor: "white",
          filter: (t10) => {
            var e10;
            return !((e10 = t10 == null ? void 0 : t10.classList) != null && e10.contains("hide-export"));
          }
        });
      },
      toJpeg() {
        return LT(this.$refs.export, {
          backgroundColor: "white",
          filter: (t10) => {
            var e10;
            return !((e10 = t10 == null ? void 0 : t10.classList) != null && e10.contains("hide-export"));
          }
        });
      },
      zoomIn() {
        const t10 = Math.min(1, this.scale + 0.1);
        this.setScale(t10);
      },
      zoomOut() {
        this.setScale(this.scale - 0.1);
      },
      setTheme(t10) {
        this.theme = t10;
      },
      setStyle(t10) {
        const e10 = "zenuml-style";
        let n10 = document.getElementById(e10);
        n10 || (n10 = document.createElement("style"), n10.id = e10, document.head.append(n10)), n10.textContent = t10;
      },
      setRemoteCss(t10) {
        const e10 = new URL(t10).hostname;
        if (e10 === "https://github.com" || e10 === "https://githubusercontent.com") {
          fetch(
            t10.replace("github.com", "raw.githubusercontent.com").replace("blob/", "")
          ).then((s10) => s10.text()).then((s10) => {
            this.setStyle(s10);
          });
          return;
        }
        const n10 = "zenuml-remote-css";
        let r10 = document.getElementById(n10);
        r10 || (r10 = document.createElement("link"), r10.id = n10, r10.rel = "stylesheet", document.head.append(r10)), r10.href = t10;
      }
    },
    components: {
      Icon: dr,
      Debug: ST,
      WidthProvider: SE,
      TipsDialog: hE,
      DiagramTitle: Sv,
      SeqDiagram: dc,
      Privacy: bv,
      ThemeSelect: zS
    }
  }, jS = { class: "frame text-skin-frame bg-skin-frame border-skin-frame relative m-1 origin-top-left whitespace-nowrap border rounded" }, ZS = { ref: "content" }, WS = { class: "header text-skin-title bg-skin-title border-skin-frame border-b p-1 flex justify-between rounded-t" }, qS = { class: "left hide-export" }, KS = { class: "right flex-grow flex justify-between" }, YS = {
    key: 0,
    class: "fixed z-40 inset-0 overflow-y-auto",
    "aria-labelledby": "modal-title",
    role: "dialog",
    "aria-modal": "true"
  }, XS = { class: "footer text-skin-control px-4 py-1 flex justify-between items-center gap-3" }, QS = { class: "flex items-center gap-3 color-base" }, JS = { class: "flex items-center" }, eA = ["checked"], tA = {
    for: "order-display",
    title: "Numbering the diagram",
    class: "select-none"
  }, nA = { class: "zoom-controls bg-skin-base flex hide-export gap-1" }, rA = { class: "w-12 block text-center" }, sA = /* @__PURE__ */ A("a", {
    target: "_blank",
    href: "https://zenuml.com",
    class: "brand text-xs hover:underline"
  }, "ZenUML.com", -1);
  function iA(t10, e10, n10, r10, s10, i10) {
    const o10 = me$1("debug"), l10 = me$1("diagram-title"), a10 = me$1("privacy"), c10 = me$1("TipsDialog"), u10 = me$1("seq-diagram"), h10 = me$1("Icon"), d10 = me$1("ThemeSelect"), p10 = me$1("width-provider");
    return k$1(), q$1("div", {
      ref: "export",
      class: ve$1(["zenuml p-1 bg-skin-canvas", t10.theme]),
      style: { display: "inline-block" }
    }, [
      V$1(o10),
      A("div", jS, [
        A("div", ZS, [
          A("div", WS, [
            A("div", qS, [
              Vl(t10.$slots, "default")
            ]),
            A("div", KS, [
              V$1(l10, { context: i10.title }, null, 8, ["context"]),
              V$1(a10, { class: "hide-export flex items-center" })
            ])
          ]),
          A("div", null, [
            t10.showTips ? (k$1(), q$1("div", YS, [
              V$1(c10)
            ])) : xe$1("", true)
          ]),
          V$1(u10, {
            ref: "diagram",
            style: Ce$1({ transform: `scale(${t10.scale})` }),
            class: "origin-top-left"
          }, null, 8, ["style"])
        ], 512),
        A("div", XS, [
          t10.mode === r10.RenderMode.Dynamic ? (k$1(), q$1(Fe$1, { key: 0 }, [
            A("div", QS, [
              A("button", {
                class: "bottom-1 flex items-center left-1 hide-export",
                onClick: e10[0] || (e10[0] = (g) => i10.showTipsDialog())
              }, [
                V$1(h10, {
                  name: "tip",
                  "icon-class": "filter grayscale w-4 h-4"
                })
              ]),
              t10.enableMultiTheme ? (k$1(), Re$1(d10, { key: 0 })) : xe$1("", true),
              A("div", JS, [
                A("input", {
                  type: "checkbox",
                  id: "order-display",
                  class: "mr-1",
                  checked: t10.numbering,
                  onInput: e10[1] || (e10[1] = (g) => t10.toggleNumbering(!t10.numbering))
                }, null, 40, eA),
                A("label", tA, [
                  V$1(h10, {
                    name: "numbering",
                    "icon-class": "w-6 h-6"
                  })
                ])
              ])
            ]),
            A("div", nA, [
              A("button", {
                class: "zoom-in",
                onClick: e10[2] || (e10[2] = (g) => i10.zoomIn())
              }, [
                V$1(h10, {
                  name: "zoom-in",
                  "icon-class": "w-4 h-4"
                })
              ]),
              A("label", rA, Ve$1(Number(t10.scale * 100).toFixed(0)) + "%", 1),
              A("button", {
                class: "zoom-out",
                onClick: e10[3] || (e10[3] = (g) => i10.zoomOut())
              }, [
                V$1(h10, {
                  name: "zoom-out",
                  "icon-class": "w-4 h-4"
                })
              ])
            ]),
            sA
          ], 64)) : xe$1("", true)
        ]),
        V$1(p10)
      ])
    ], 2);
  }
  const n6 = /* @__PURE__ */ ze$1(GS, [["render", iA]]);
  function r6() {
    return {
      baseUrl: null,
      breaks: false,
      extensions: null,
      gfm: true,
      headerIds: true,
      headerPrefix: "",
      highlight: null,
      langPrefix: "language-",
      mangle: true,
      pedantic: false,
      renderer: null,
      sanitize: false,
      sanitizer: null,
      silent: false,
      smartLists: false,
      smartypants: false,
      tokenizer: null,
      walkTokens: null,
      xhtml: false
    };
  }
  let Bs = r6();
  function oA(t10) {
    Bs = t10;
  }
  const lA = /[&<>"']/, aA = /[&<>"']/g, cA = /[<>"']|&(?!#?\w+;)/, uA = /[<>"']|&(?!#?\w+;)/g, hA = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': "&quot;",
    "'": "&#39;"
  }, xu = (t10) => hA[t10];
  function pt(t10, e10) {
    if (e10) {
      if (lA.test(t10))
        return t10.replace(aA, xu);
    } else if (cA.test(t10))
      return t10.replace(uA, xu);
    return t10;
  }
  const dA = /&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig;
  function s6(t10) {
    return t10.replace(dA, (e10, n10) => (n10 = n10.toLowerCase(), n10 === "colon" ? ":" : n10.charAt(0) === "#" ? n10.charAt(1) === "x" ? String.fromCharCode(parseInt(n10.substring(2), 16)) : String.fromCharCode(+n10.substring(1)) : ""));
  }
  const fA = /(^|[^\[])\^/g;
  function Ze$1(t10, e10) {
    t10 = t10.source || t10, e10 = e10 || "";
    const n10 = {
      replace: (r10, s10) => (s10 = s10.source || s10, s10 = s10.replace(fA, "$1"), t10 = t10.replace(r10, s10), n10),
      getRegex: () => new RegExp(t10, e10)
    };
    return n10;
  }
  const pA = /[^\w:]/g, gA = /^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;
  function Lu(t10, e10, n10) {
    if (t10) {
      let r10;
      try {
        r10 = decodeURIComponent(s6(n10)).replace(pA, "").toLowerCase();
      } catch {
        return null;
      }
      if (r10.indexOf("javascript:") === 0 || r10.indexOf("vbscript:") === 0 || r10.indexOf("data:") === 0)
        return null;
    }
    e10 && !gA.test(n10) && (n10 = _A(e10, n10));
    try {
      n10 = encodeURI(n10).replace(/%25/g, "%");
    } catch {
      return null;
    }
    return n10;
  }
  const Li = {}, mA = /^[^:]+:\/*[^/]*$/, xA = /^([^:]+:)[\s\S]*$/, LA = /^([^:]+:\/*[^/]*)[\s\S]*$/;
  function _A(t10, e10) {
    Li[" " + t10] || (mA.test(t10) ? Li[" " + t10] = t10 + "/" : Li[" " + t10] = wi(t10, "/", true)), t10 = Li[" " + t10];
    const n10 = t10.indexOf(":") === -1;
    return e10.substring(0, 2) === "//" ? n10 ? e10 : t10.replace(xA, "$1") + e10 : e10.charAt(0) === "/" ? n10 ? e10 : t10.replace(LA, "$1") + e10 : t10 + e10;
  }
  const Wi = { exec: function() {
  } };
  function mn$1(t10) {
    let e10 = 1, n10, r10;
    for (; e10 < arguments.length; e10++) {
      n10 = arguments[e10];
      for (r10 in n10)
        Object.prototype.hasOwnProperty.call(n10, r10) && (t10[r10] = n10[r10]);
    }
    return t10;
  }
  function _u(t10, e10) {
    const n10 = t10.replace(/\|/g, (i10, o10, l10) => {
      let a10 = false, c10 = o10;
      for (; --c10 >= 0 && l10[c10] === "\\"; )
        a10 = !a10;
      return a10 ? "|" : " |";
    }), r10 = n10.split(/ \|/);
    let s10 = 0;
    if (r10[0].trim() || r10.shift(), r10[r10.length - 1].trim() || r10.pop(), r10.length > e10)
      r10.splice(e10);
    else
      for (; r10.length < e10; )
        r10.push("");
    for (; s10 < r10.length; s10++)
      r10[s10] = r10[s10].trim().replace(/\\\|/g, "|");
    return r10;
  }
  function wi(t10, e10, n10) {
    const r10 = t10.length;
    if (r10 === 0)
      return "";
    let s10 = 0;
    for (; s10 < r10; ) {
      const i10 = t10.charAt(r10 - s10 - 1);
      if (i10 === e10 && !n10)
        s10++;
      else if (i10 !== e10 && n10)
        s10++;
      else
        break;
    }
    return t10.substr(0, r10 - s10);
  }
  function yA(t10, e10) {
    if (t10.indexOf(e10[1]) === -1)
      return -1;
    const n10 = t10.length;
    let r10 = 0, s10 = 0;
    for (; s10 < n10; s10++)
      if (t10[s10] === "\\")
        s10++;
      else if (t10[s10] === e10[0])
        r10++;
      else if (t10[s10] === e10[1] && (r10--, r10 < 0))
        return s10;
    return -1;
  }
  function i6(t10) {
    t10 && t10.sanitize && !t10.silent && console.warn("marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options");
  }
  function yu(t10, e10) {
    if (e10 < 1)
      return "";
    let n10 = "";
    for (; e10 > 1; )
      e10 & 1 && (n10 += t10), e10 >>= 1, t10 += t10;
    return n10 + t10;
  }
  function Cu(t10, e10, n10, r10) {
    const s10 = e10.href, i10 = e10.title ? pt(e10.title) : null, o10 = t10[1].replace(/\\([\[\]])/g, "$1");
    if (t10[0].charAt(0) !== "!") {
      r10.state.inLink = true;
      const l10 = {
        type: "link",
        raw: n10,
        href: s10,
        title: i10,
        text: o10,
        tokens: r10.inlineTokens(o10, [])
      };
      return r10.state.inLink = false, l10;
    } else
      return {
        type: "image",
        raw: n10,
        href: s10,
        title: i10,
        text: pt(o10)
      };
  }
  function CA(t10, e10) {
    const n10 = t10.match(/^(\s+)(?:```)/);
    if (n10 === null)
      return e10;
    const r10 = n10[1];
    return e10.split(`
`).map((s10) => {
      const i10 = s10.match(/^\s+/);
      if (i10 === null)
        return s10;
      const [o10] = i10;
      return o10.length >= r10.length ? s10.slice(r10.length) : s10;
    }).join(`
`);
  }
  class vc {
    constructor(e10) {
      this.options = e10 || Bs;
    }
    space(e10) {
      const n10 = this.rules.block.newline.exec(e10);
      if (n10 && n10[0].length > 0)
        return {
          type: "space",
          raw: n10[0]
        };
    }
    code(e10) {
      const n10 = this.rules.block.code.exec(e10);
      if (n10) {
        const r10 = n10[0].replace(/^ {1,4}/gm, "");
        return {
          type: "code",
          raw: n10[0],
          codeBlockStyle: "indented",
          text: this.options.pedantic ? r10 : wi(r10, `
`)
        };
      }
    }
    fences(e10) {
      const n10 = this.rules.block.fences.exec(e10);
      if (n10) {
        const r10 = n10[0], s10 = CA(r10, n10[3] || "");
        return {
          type: "code",
          raw: r10,
          lang: n10[2] ? n10[2].trim() : n10[2],
          text: s10
        };
      }
    }
    heading(e10) {
      const n10 = this.rules.block.heading.exec(e10);
      if (n10) {
        let r10 = n10[2].trim();
        if (/#$/.test(r10)) {
          const i10 = wi(r10, "#");
          (this.options.pedantic || !i10 || / $/.test(i10)) && (r10 = i10.trim());
        }
        const s10 = {
          type: "heading",
          raw: n10[0],
          depth: n10[1].length,
          text: r10,
          tokens: []
        };
        return this.lexer.inline(s10.text, s10.tokens), s10;
      }
    }
    hr(e10) {
      const n10 = this.rules.block.hr.exec(e10);
      if (n10)
        return {
          type: "hr",
          raw: n10[0]
        };
    }
    blockquote(e10) {
      const n10 = this.rules.block.blockquote.exec(e10);
      if (n10) {
        const r10 = n10[0].replace(/^ *> ?/gm, "");
        return {
          type: "blockquote",
          raw: n10[0],
          tokens: this.lexer.blockTokens(r10, []),
          text: r10
        };
      }
    }
    list(e10) {
      let n10 = this.rules.block.list.exec(e10);
      if (n10) {
        let r10, s10, i10, o10, l10, a10, c10, u10, h10, d10, p10, g, L = n10[1].trim();
        const T = L.length > 1, _10 = {
          type: "list",
          raw: "",
          ordered: T,
          start: T ? +L.slice(0, -1) : "",
          loose: false,
          items: []
        };
        L = T ? `\\d{1,9}\\${L.slice(-1)}` : `\\${L}`, this.options.pedantic && (L = T ? L : "[*+