/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.LinkedHashMap;
import java.util.Map;

public class AmenityType {
    static Map<String, AmenityType> amenityTypes = new LinkedHashMap<String, AmenityType>();
    public static AmenityType EMERGENCY = AmenityType.reg("emergency", "emergency");
    public static AmenityType HEALTHCARE = AmenityType.reg("healthcare", "amenity");
    public static AmenityType TRANSPORTATION = AmenityType.reg("transportation", "amenity");
    public static AmenityType BARRIER = AmenityType.reg("barrier", "barrier");
    public static AmenityType TOURISM = AmenityType.reg("tourism", "tourism");
    public static AmenityType ENTERTAINMENT = AmenityType.reg("entertainment", "amenity");
    public static AmenityType HISTORIC = AmenityType.reg("historic", "historic");
    public static AmenityType SPORT = AmenityType.reg("sport", "sport");
    public static AmenityType LEISURE = AmenityType.reg("leisure", "leisure");
    public static AmenityType GEOCACHE = AmenityType.reg("geocache", "geocache");
    public static AmenityType OTHER = AmenityType.reg("other", "amenity");
    public static AmenityType FINANCE = AmenityType.reg("finance", "amenity");
    public static AmenityType OFFICE = AmenityType.reg("office", "office");
    public static AmenityType ADMINISTRATIVE = AmenityType.reg("administrative", "administrative");
    public static AmenityType EDUCATION = AmenityType.reg("education", "amenity");
    public static AmenityType MAN_MADE = AmenityType.reg("man_made", "man_made");
    public static AmenityType SEAMARK = AmenityType.reg("seamark", "seamark");
    public static AmenityType SUSTENANCE = AmenityType.reg("sustenance", "amenity");
    public static AmenityType SHOP = AmenityType.reg("shop", "shop");
    public static AmenityType NATURAL = AmenityType.reg("natural", "natural");
    public static AmenityType LANDUSE = AmenityType.reg("landuse", "landuse");
    public static AmenityType MILITARY = AmenityType.reg("military", "military");
    public static AmenityType OSMWIKI = AmenityType.reg("osmwiki", "osmwiki");
    public static AmenityType USER_DEFINED = AmenityType.reg("user_defined", "user_defined");
    private final String defaultTag;
    private final String name;
    private final int ordinal;

    private static AmenityType reg(String name, String defaultTag) {
        if (amenityTypes.containsKey(name = name.toLowerCase())) {
            return amenityTypes.get(name);
        }
        AmenityType t = new AmenityType(name, defaultTag, amenityTypes.size());
        amenityTypes.put(t.name, t);
        return t;
    }

    private AmenityType(String name, String defaultTag, int ordinal) {
        this.name = name;
        this.defaultTag = defaultTag;
        this.ordinal = ordinal;
    }

    public static AmenityType findOrCreateTypeNoReg(String s) {
        AmenityType type = null;
        for (AmenityType t : amenityTypes.values()) {
            if (!t.name.equalsIgnoreCase(s)) continue;
            type = t;
            break;
        }
        if (type == null) {
            type = new AmenityType(s, s, -1);
        }
        return type;
    }

    public static boolean isRegisteredType(AmenityType type) {
        return type.ordinal >= 0;
    }

    public static AmenityType getAndRegisterType(String name) {
        return AmenityType.reg(name, name);
    }

    public String getDefaultTag() {
        return this.defaultTag;
    }

    public String getCategoryName() {
        return this.name;
    }

    public static int getCategoriesSize() {
        return amenityTypes.size();
    }

    public static AmenityType[] getCategories() {
        return amenityTypes.values().toArray(new AmenityType[amenityTypes.size()]);
    }

    public int ordinal() {
        return this.ordinal;
    }

    public static String valueToString(AmenityType a) {
        return a.getCategoryName();
    }

    public String toString() {
        return AmenityType.valueToString(this);
    }
}

