/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;

public class PoiFilter
extends AbstractPoiType {
    private PoiCategory pc;
    private List<PoiType> poiTypes = new ArrayList<PoiType>();
    private Map<String, PoiType> map = new LinkedHashMap<String, PoiType>();

    public PoiFilter(MapPoiTypes registry, PoiCategory pc, String keyName) {
        super(keyName, registry);
        this.pc = pc;
    }

    public PoiCategory getPoiCategory() {
        return this.pc;
    }

    public PoiType getPoiTypeByKeyName(String kn) {
        return this.map.get(kn);
    }

    public void addPoiType(PoiType type) {
        if (!this.map.containsKey(type.getKeyName())) {
            this.poiTypes.add(type);
            this.map.put(type.getKeyName(), type);
        } else {
            PoiType prev = this.map.get(type.getKeyName());
            if (prev.isReference()) {
                this.poiTypes.remove(prev);
                this.poiTypes.add(type);
                this.map.put(type.getKeyName(), type);
            }
        }
    }

    @Override
    public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        if (!acceptedTypes.containsKey(this.pc)) {
            acceptedTypes.put(this.pc, new LinkedHashSet());
        }
        LinkedHashSet<String> set = acceptedTypes.get(this.pc);
        for (PoiType pt : this.poiTypes) {
            set.add(pt.getKeyName());
        }
        this.addReferenceTypes(acceptedTypes);
        return acceptedTypes;
    }

    protected void addReferenceTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        for (PoiType pt : this.getPoiTypes()) {
            LinkedHashSet<String> ls;
            if (!pt.isReference()) continue;
            PoiCategory refCat = pt.getReferenceType().getCategory();
            if (!acceptedTypes.containsKey(refCat)) {
                acceptedTypes.put(refCat, new LinkedHashSet());
            }
            if ((ls = acceptedTypes.get(refCat)) == null) continue;
            ls.add(pt.getKeyName());
        }
    }

    public List<PoiType> getPoiTypes() {
        return this.poiTypes;
    }
}

