/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.output;

import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.openapidiff.core.exception.RendererException;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedApiResponse;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedHeader;
import org.openapitools.openapidiff.core.model.ChangedHeaders;
import org.openapitools.openapidiff.core.model.ChangedList;
import org.openapitools.openapidiff.core.model.ChangedMediaType;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedParameter;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.ChangedResponse;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.Endpoint;
import org.openapitools.openapidiff.core.model.schema.ChangedOneOfSchema;
import org.openapitools.openapidiff.core.output.HttpStatus;
import org.openapitools.openapidiff.core.output.Render;
import org.openapitools.openapidiff.core.utils.ChangedUtils;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownRender
implements Render {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownRender.class);
    private static final String H3 = "### ";
    private static final String H4 = "#### ";
    private static final String H5 = "##### ";
    private static final String H6 = "###### ";
    private static final String BLOCKQUOTE = "> ";
    private static final String CODE = "`";
    private static final String PRE_CODE = "    ";
    private static final String PRE_LI = "    ";
    private static final String LI = "* ";
    private static final String HR = "---\n";
    protected RefPointer<Schema<?>> refPointer = new RefPointer(RefType.SCHEMAS);
    protected ChangedOpenApi diff;
    protected Set<Schema<?>> handledSchemas = new HashSet();
    protected boolean showChangedMetadata;

    @Override
    public void render(ChangedOpenApi diff, OutputStreamWriter outputStreamWriter) {
        this.diff = diff;
        this.handledSchemas.clear();
        this.listEndpoints("What's New", diff.getNewEndpoints(), outputStreamWriter);
        this.listEndpoints("What's Deleted", diff.getMissingEndpoints(), outputStreamWriter);
        this.listEndpoints("What's Deprecated", diff.getDeprecatedEndpoints(), outputStreamWriter);
        this.listEndpoints(diff.getChangedOperations(), outputStreamWriter);
        try {
            outputStreamWriter.close();
        }
        catch (IOException e) {
            throw new RendererException(e);
        }
    }

    protected String sectionTitle(String title) {
        return H4 + title + '\n' + HR + '\n';
    }

    protected void listEndpoints(String title, List<Endpoint> endpoints, OutputStreamWriter outputStreamWriter) {
        if (null == endpoints || endpoints.isEmpty()) {
            return;
        }
        this.safelyAppend(outputStreamWriter, this.sectionTitle(title));
        endpoints.stream().map(e -> this.itemEndpoint(e.getMethod().toString(), e.getPathUrl(), e.getSummary())).forEach(csq -> this.safelyAppend(outputStreamWriter, (String)csq));
    }

    protected String itemEndpoint(String method, String path, String summary) {
        return "##### `" + method + CODE + " " + path + "\n\n" + this.metadata(summary) + "\n";
    }

    protected String itemEndpoint(String method, String path, ChangedMetadata summary) {
        return "##### `" + method + CODE + " " + path + "\n\n" + this.metadata("summary", summary) + "\n";
    }

    protected String titleH5(String title) {
        return H6 + title + '\n';
    }

    protected void listEndpoints(List<ChangedOperation> changedOperations, OutputStreamWriter outputStreamWriter) {
        if (null == changedOperations || changedOperations.isEmpty()) {
            return;
        }
        this.safelyAppend(outputStreamWriter, this.sectionTitle("What's Changed"));
        changedOperations.forEach(operation -> {
            this.safelyAppend(outputStreamWriter, this.itemEndpoint(operation.getHttpMethod().toString(), operation.getPathUrl(), operation.getSummary()));
            if (Changed.result(operation.getParameters()).isDifferent()) {
                this.safelyAppend(outputStreamWriter, this.titleH5("Parameters:"));
                this.safelyAppend(outputStreamWriter, this.parameters(operation.getParameters()));
            }
            if (operation.resultRequestBody().isDifferent()) {
                this.safelyAppend(outputStreamWriter, this.titleH5("Request:"));
                this.safelyAppend(outputStreamWriter, this.metadata("Description", operation.getRequestBody().getDescription()));
                this.safelyAppend(outputStreamWriter, this.bodyContent(operation.getRequestBody().getContent()));
            }
            if (operation.resultApiResponses().isDifferent()) {
                this.safelyAppend(outputStreamWriter, this.titleH5("Return Type:"));
                this.safelyAppend(outputStreamWriter, this.responses(operation.getApiResponses()));
            }
        });
    }

    protected String responses(ChangedApiResponse changedApiResponse) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(this.listResponse("New response", changedApiResponse.getIncreased()));
        sb.append(this.listResponse("Deleted response", changedApiResponse.getMissing()));
        changedApiResponse.getChanged().entrySet().stream().map(e -> this.itemResponse((String)e.getKey(), (ChangedResponse)e.getValue())).forEach(sb::append);
        return sb.toString();
    }

    protected String listResponse(String title, Map<String, ApiResponse> responses) {
        StringBuilder sb = new StringBuilder();
        responses.entrySet().stream().map(e -> this.itemResponse(title, (String)e.getKey(), (ApiResponse)e.getValue())).forEach(sb::append);
        return sb.toString();
    }

    protected String itemResponse(String title, String code, ApiResponse response) {
        return this.itemResponse(title, code, response.getDescription());
    }

    protected String itemResponse(String code, ChangedResponse response) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.itemResponse("Changed response", code, null == response.getNewApiResponse() ? "" : response.getNewApiResponse().getDescription()));
        sb.append(this.headers(response.getHeaders()));
        if (response.getContent() != null) {
            sb.append(this.bodyContent(LI, response.getContent()));
        }
        return sb.toString();
    }

    protected String itemResponse(String title, String code, String description) {
        StringBuilder sb = new StringBuilder();
        String status = "";
        if (!code.equals("default") && !code.matches("[1-5]XX")) {
            status = HttpStatus.getReasonPhrase(Integer.parseInt(code));
        }
        sb.append(String.format("%s : **%s %s**\n", title, code, status));
        sb.append(this.metadata(description));
        return sb.toString();
    }

    protected String headers(ChangedHeaders headers) {
        StringBuilder sb = new StringBuilder();
        if (headers != null) {
            sb.append(this.listHeader("New header", headers.getIncreased())).append(this.listHeader("Deleted header", headers.getMissing()));
            headers.getChanged().entrySet().stream().map(e -> this.itemHeader((String)e.getKey(), (ChangedHeader)e.getValue())).forEach(sb::append);
        }
        return sb.toString();
    }

    protected String listHeader(String title, Map<String, Header> headers) {
        StringBuilder sb = new StringBuilder();
        headers.entrySet().stream().map(e -> this.itemHeader(title, (String)e.getKey(), (Header)e.getValue())).forEach(sb::append);
        return sb.toString();
    }

    protected String itemHeader(String title, String name, Header header) {
        return this.itemHeader(title, name, header.getDescription());
    }

    protected String itemHeader(String code, ChangedHeader header) {
        return this.itemHeader("Changed header", code, null == header.getNewHeader() ? "" : header.getNewHeader().getDescription());
    }

    protected String itemHeader(String title, String mediaType, String description) {
        return String.format("%s : `%s`\n\n", title, mediaType) + this.metadata(description) + '\n';
    }

    protected String bodyContent(String prefix, ChangedContent changedContent) {
        if (changedContent == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("\n");
        sb.append(this.listContent(prefix, "New content type", changedContent.getIncreased()));
        sb.append(this.listContent(prefix, "Deleted content type", changedContent.getMissing()));
        int deepness = StringUtils.isNotBlank(prefix) ? 1 : 0;
        changedContent.getChanged().entrySet().stream().map(e -> this.itemContent(deepness, (String)e.getKey(), (ChangedMediaType)e.getValue())).forEach(e -> sb.append(prefix).append((String)e));
        return sb.toString();
    }

    protected String bodyContent(ChangedContent changedContent) {
        return this.bodyContent("", changedContent);
    }

    protected String listContent(String prefix, String title, Map<String, MediaType> mediaTypes) {
        StringBuilder sb = new StringBuilder();
        mediaTypes.entrySet().stream().map(e -> this.itemContent(title, (String)e.getKey(), (MediaType)e.getValue())).forEach(e -> sb.append(prefix).append((String)e));
        return sb.toString();
    }

    protected String itemContent(String title, String mediaType) {
        return String.format("%s : `%s`\n\n", title, mediaType);
    }

    protected String itemContent(String title, String mediaType, MediaType content) {
        return this.itemContent(title, mediaType);
    }

    protected String itemContent(int deepness, String mediaType, ChangedMediaType content) {
        return this.itemContent("Changed content type", mediaType) + this.schema(deepness, content.getSchema());
    }

    protected String schema(ChangedSchema schema) {
        return this.schema(1, schema);
    }

    protected String oneOfSchema(int deepness, ChangedOneOfSchema schema, String discriminator) {
        StringBuilder sb = new StringBuilder();
        schema.getMissing().keySet().forEach(key -> sb.append(String.format("%sDeleted '%s' %s\n", this.indent(deepness), key, discriminator)));
        schema.getIncreased().forEach((key, sub) -> sb.append(String.format("%sAdded '%s' %s:\n", this.indent(deepness), key, discriminator)).append(this.schema(deepness, (Schema)sub, schema.getContext())));
        schema.getChanged().forEach((key, sub) -> sb.append(String.format("%sUpdated `%s` %s:\n", this.indent(deepness), key, discriminator)).append(this.schema(deepness, (ChangedSchema)sub)));
        return sb.toString();
    }

    protected String required(int deepness, String title, List<String> required) {
        StringBuilder sb = new StringBuilder();
        if (!required.isEmpty()) {
            sb.append(String.format("%s%s:\n", this.indent(deepness), title));
            required.forEach(s2 -> sb.append(String.format("%s- `%s`\n", this.indent(deepness), s2)));
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String schema(int deepness, ChangedSchema schema) {
        StringBuilder sb = new StringBuilder();
        if (schema.isDiscriminatorPropertyChanged()) {
            LOGGER.debug("Discriminator property changed");
        }
        if (schema.getOneOfSchema() != null) {
            String discriminator = schema.getNewSchema().getDiscriminator() != null ? schema.getNewSchema().getDiscriminator().getPropertyName() : "";
            sb.append(this.oneOfSchema(deepness, schema.getOneOfSchema(), discriminator));
        }
        if (schema.getRequired() != null) {
            sb.append(this.required(deepness, "New required properties", schema.getRequired().getIncreased()));
            sb.append(this.required(deepness, "New optional properties", schema.getRequired().getMissing()));
        }
        if (schema.getItems() != null) {
            sb.append(this.items(deepness, schema.getItems()));
        }
        sb.append(this.listDiff(deepness, "enum", schema.getEnumeration()));
        sb.append(this.properties(deepness, "Added property", schema.getIncreasedProperties(), true, schema.getContext()));
        sb.append(this.properties(deepness, "Deleted property", schema.getMissingProperties(), false, schema.getContext()));
        schema.getChangedProperties().forEach((name, property) -> sb.append(this.property(deepness, (String)name, (ChangedSchema)property)));
        return sb.toString();
    }

    protected String schema(int deepness, ComposedSchema schema, DiffContext context) {
        StringBuilder sb = new StringBuilder();
        if (schema.getAllOf() != null) {
            LOGGER.debug("All of schema");
            schema.getAllOf().stream().map(this::resolve).forEach(composedChild -> sb.append(this.schema(deepness, (Schema)composedChild, context)));
        }
        if (schema.getOneOf() != null) {
            LOGGER.debug("One of schema");
            sb.append(String.format("%sOne of:\n\n", this.indent(deepness)));
            schema.getOneOf().stream().map(this::resolve).forEach(composedChild -> sb.append(this.schema(deepness + 1, (Schema)composedChild, context)));
        }
        return sb.toString();
    }

    protected String schema(int deepness, Schema schema, DiffContext context) {
        if (this.handledSchemas.contains(schema)) {
            return "";
        }
        this.handledSchemas.add(schema);
        StringBuilder sb = new StringBuilder();
        sb.append(this.listItem(deepness, "Enum", schema.getEnum()));
        sb.append(this.properties(deepness, "Property", schema.getProperties(), true, context));
        if (schema instanceof ComposedSchema) {
            sb.append(this.schema(deepness, (ComposedSchema)schema, context));
        } else if (schema instanceof ArraySchema) {
            sb.append(this.items(deepness, this.resolve(((ArraySchema)schema).getItems()), context));
        }
        return sb.toString();
    }

    protected String items(int deepness, ChangedSchema schema) {
        StringBuilder sb = new StringBuilder();
        String type = this.type(schema.getNewSchema());
        if (schema.isChangedType()) {
            type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
        }
        sb.append(this.items(deepness, "Changed items", type, schema.getNewSchema().getDescription()));
        sb.append(this.schema(deepness, schema));
        return sb.toString();
    }

    protected String items(int deepness, Schema<?> schema, DiffContext context) {
        return this.items(deepness, "Items", this.type(schema), schema.getDescription()) + this.schema(deepness, schema, context);
    }

    protected String items(int deepness, String title, String type, String description) {
        return String.format("%s%s (%s):\n%s\n", this.indent(deepness), title, type, this.metadata(this.indent(deepness + 1), description));
    }

    protected String properties(int deepness, String title, Map<String, Schema<?>> properties, boolean showContent, DiffContext context) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            properties.forEach((key, value) -> {
                sb.append(this.resolveProperty(deepness, (Schema<?>)value, (String)key, title));
                if (showContent) {
                    sb.append(this.schema(deepness + 1, this.resolve((Schema<?>)value), context));
                }
            });
        }
        return sb.toString();
    }

    private String resolveProperty(int deepness, Schema<?> value, String key, String title) {
        try {
            return this.property(deepness, title, key, this.resolve(value));
        }
        catch (Exception e) {
            return this.property(deepness, title, key, this.type(value), "");
        }
    }

    protected String property(int deepness, String name, ChangedSchema schema) {
        StringBuilder sb = new StringBuilder();
        String type = this.type(schema.getNewSchema());
        if (schema.isChangedType()) {
            type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
        }
        sb.append(this.property(deepness, "Changed property", name, type, schema.getNewSchema().getDescription()));
        sb.append(this.schema(++deepness, schema));
        return sb.toString();
    }

    protected String property(int deepness, String title, String name, Schema<?> schema) {
        return this.property(deepness, title, name, this.type(schema), schema.getDescription());
    }

    protected String property(int deepness, String title, String name, String type, String description) {
        return String.format("%s* %s `%s` (%s)\n%s\n", this.indent(deepness), title, name, type, this.metadata(this.indent(deepness + 1), description));
    }

    protected String listDiff(int deepness, String name, ChangedList<?> listDiff) {
        if (listDiff == null) {
            return "";
        }
        return this.listItem(deepness, "Added " + name, listDiff.getIncreased()) + this.listItem(deepness, "Removed " + name, listDiff.getMissing());
    }

    protected <T> String listItem(int deepness, String name, List<T> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            sb.append(String.format("%s%s value%s:\n\n", this.indent(deepness), name, list.size() > 1 ? "s" : ""));
            list.forEach(p -> sb.append(String.format("%s* `%s`\n", this.indent(deepness), p)));
        }
        return sb.toString();
    }

    protected String parameters(ChangedParameters changedParameters) {
        List<ChangedParameter> changed = changedParameters.getChanged();
        StringBuilder sb = new StringBuilder("\n");
        sb.append(this.listParameter("Added", changedParameters.getIncreased())).append(this.listParameter("Deleted", changedParameters.getMissing()));
        changed.stream().map(this::itemParameter).forEach(sb::append);
        return sb.toString();
    }

    protected String listParameter(String title, List<Parameter> parameters) {
        StringBuilder sb = new StringBuilder();
        parameters.stream().map(p -> this.itemParameter(title, (Parameter)p)).forEach(sb::append);
        return sb.toString();
    }

    protected String itemParameter(String title, Parameter parameter) {
        return this.itemParameter(title, parameter.getName(), parameter.getIn(), parameter.getDescription());
    }

    protected String itemParameter(String title, String name, String in, String description) {
        return String.format("%s: ", title) + this.code(name) + " in " + this.code(in) + '\n' + this.metadata(description) + '\n';
    }

    protected String itemParameter(ChangedParameter param) {
        Parameter rightParam = param.getNewParameter();
        if (param.isDeprecated()) {
            return this.itemParameter("Deprecated", rightParam.getName(), rightParam.getIn(), rightParam.getDescription());
        }
        return this.itemParameter("Changed", rightParam.getName(), rightParam.getIn(), rightParam.getDescription());
    }

    protected String code(String string) {
        return CODE + string + CODE;
    }

    protected String metadata(String name, ChangedMetadata changedMetadata) {
        return this.metadata("", name, changedMetadata);
    }

    protected String metadata(String beginning, String name, ChangedMetadata changedMetadata) {
        if (changedMetadata == null) {
            return "";
        }
        if (!ChangedUtils.isUnchanged(changedMetadata) && this.showChangedMetadata) {
            return String.format("Changed %s:\n%s\nto:\n%s\n\n", name, this.metadata(beginning, changedMetadata.getLeft()), this.metadata(beginning, changedMetadata.getRight()));
        }
        return this.metadata(beginning, name, changedMetadata.getRight());
    }

    protected String metadata(String metadata) {
        return this.metadata("", metadata);
    }

    protected String metadata(String beginning, String name, String metadata) {
        if (StringUtils.isBlank(metadata)) {
            return "";
        }
        return this.blockquote(beginning, metadata);
    }

    protected String metadata(String beginning, String metadata) {
        if (StringUtils.isBlank(metadata)) {
            return "";
        }
        return this.blockquote(beginning, metadata);
    }

    protected String blockquote(String beginning) {
        return beginning + BLOCKQUOTE;
    }

    protected String blockquote(String beginning, String text) {
        String blockquote = this.blockquote(beginning);
        return blockquote + text.trim().replace("\n", "\n" + blockquote) + "\n\n";
    }

    protected String type(Schema<?> schema) {
        String result = "object";
        if (schema instanceof ArraySchema) {
            result = "array";
        } else if (schema.getType() != null) {
            result = schema.getType();
        }
        return result;
    }

    protected String indent(int deepness) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deepness; ++i) {
            sb.append("    ");
        }
        return sb.toString();
    }

    protected Schema<?> resolve(Schema<?> schema) {
        return this.refPointer.resolveRef(this.diff.getNewSpecOpenApi().getComponents(), schema, schema.get$ref());
    }

    public boolean isShowChangedMetadata() {
        return this.showChangedMetadata;
    }

    public void setShowChangedMetadata(boolean showChangedMetadata) {
        this.showChangedMetadata = showChangedMetadata;
    }
}

