/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.fileformats.node;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.index.compositeindex.datacube.DimensionDataType;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNodeType;
import org.opensearch.search.startree.StarTreeNodeCollector;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;

public class FixedLengthStarTreeNode
implements StarTreeNode {
    public static final int NUM_INT_SERIALIZABLE_FIELDS = 6;
    public static final int NUM_LONG_SERIALIZABLE_FIELDS = 1;
    public static final int NUM_BYTE_SERIALIZABLE_FIELDS = 1;
    public static final long SERIALIZABLE_DATA_SIZE_IN_BYTES = 33L;
    static final int DIMENSION_ID_OFFSET = 0;
    static final int DIMENSION_VALUE_OFFSET = 4;
    static final int START_DOC_ID_OFFSET = 12;
    static final int END_DOC_ID_OFFSET = 16;
    static final int AGGREGATE_DOC_ID_OFFSET = 20;
    static final int STAR_NODE_TYPE_OFFSET = 24;
    static final int FIRST_CHILD_ID_OFFSET = 25;
    static final int LAST_CHILD_ID_OFFSET = 29;
    public static final int INVALID_ID = -1;
    private final int nodeId;
    private final int firstChildId;
    RandomAccessInput in;

    public FixedLengthStarTreeNode(RandomAccessInput in, int nodeId) throws IOException {
        this.in = in;
        this.nodeId = nodeId;
        this.firstChildId = this.getInt(25);
    }

    private int getInt(int fieldOffset) throws IOException {
        return this.in.readInt((long)this.nodeId * 33L + (long)fieldOffset);
    }

    private long getLong(int fieldOffset) throws IOException {
        return this.in.readLong((long)this.nodeId * 33L + (long)fieldOffset);
    }

    private byte getByte(int fieldOffset) throws IOException {
        return this.in.readByte((long)this.nodeId * 33L + (long)fieldOffset);
    }

    @Override
    public int getDimensionId() throws IOException {
        return this.getInt(0);
    }

    @Override
    public long getDimensionValue() throws IOException {
        return this.getLong(4);
    }

    @Override
    public int getChildDimensionId() throws IOException {
        if (this.firstChildId == -1) {
            return -1;
        }
        return this.in.readInt((long)this.firstChildId * 33L);
    }

    @Override
    public int getStartDocId() throws IOException {
        return this.getInt(12);
    }

    @Override
    public int getEndDocId() throws IOException {
        return this.getInt(16);
    }

    @Override
    public int getAggregatedDocId() throws IOException {
        return this.getInt(20);
    }

    @Override
    public int getNumChildren() throws IOException {
        if (this.firstChildId == -1) {
            return 0;
        }
        return this.getInt(29) - this.firstChildId + 1;
    }

    @Override
    public boolean isLeaf() {
        return this.firstChildId == -1;
    }

    @Override
    public byte getStarTreeNodeType() throws IOException {
        return this.getByte(24);
    }

    @Override
    public StarTreeNode getChildStarNode() throws IOException {
        return this.handleStarNode();
    }

    @Override
    public StarTreeNode getChildForDimensionValue(Long dimensionValue, StarTreeNode lastMatchedChild, DimensionFilterMapper dimensionFilterMapper) throws IOException {
        if (this.isLeaf()) {
            return null;
        }
        FixedLengthStarTreeNode resultStarTreeNode = null;
        if (null != dimensionValue) {
            resultStarTreeNode = this.binarySearchChild(dimensionValue, lastMatchedChild, dimensionFilterMapper == null ? DimensionDataType.LONG::compare : dimensionFilterMapper.comparator());
        }
        return resultStarTreeNode;
    }

    private FixedLengthStarTreeNode handleStarNode() throws IOException {
        FixedLengthStarTreeNode firstNode = new FixedLengthStarTreeNode(this.in, this.firstChildId);
        return FixedLengthStarTreeNode.matchStarTreeNodeTypeOrNull(firstNode, StarTreeNodeType.STAR);
    }

    private static FixedLengthStarTreeNode matchStarTreeNodeTypeOrNull(FixedLengthStarTreeNode firstNode, StarTreeNodeType starTreeNodeType) throws IOException {
        if (firstNode.getStarTreeNodeType() == starTreeNodeType.getValue()) {
            return firstNode;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FixedLengthStarTreeNode binarySearchChild(long dimensionValue, StarTreeNode lastMatchedNode, Comparator<Long> comparator) throws IOException {
        int low = this.firstChildId;
        int high = this.getInt(29);
        if (FixedLengthStarTreeNode.matchStarTreeNodeTypeOrNull(new FixedLengthStarTreeNode(this.in, high), StarTreeNodeType.NULL) != null) {
            --high;
        }
        if (lastMatchedNode instanceof FixedLengthStarTreeNode) {
            int lastMatchedNodeId = ((FixedLengthStarTreeNode)lastMatchedNode).nodeId();
            if (lastMatchedNodeId + 1 > high) return null;
            low = lastMatchedNodeId + 1;
        } else if (FixedLengthStarTreeNode.matchStarTreeNodeTypeOrNull(new FixedLengthStarTreeNode(this.in, low), StarTreeNodeType.STAR) != null) {
            ++low;
        }
        while (low <= high) {
            int mid = low + (high - low) / 2;
            FixedLengthStarTreeNode midNode = new FixedLengthStarTreeNode(this.in, mid);
            long midDimensionValue = midNode.getDimensionValue();
            int compare = comparator.compare(midDimensionValue, dimensionValue);
            if (compare == 0) {
                return midNode;
            }
            if (compare < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return null;
    }

    @Override
    public void collectChildrenInRange(long low, long high, StarTreeNodeCollector collector, DimensionFilterMapper dimensionFilterMapper) throws IOException {
        FixedLengthStarTreeNode lowStarTreeNode;
        Comparator<Long> comparator = dimensionFilterMapper.comparator();
        if (comparator.compare(low, high) <= 0 && (lowStarTreeNode = this.binarySearchChild(low, true, null, comparator)) != null) {
            FixedLengthStarTreeNode highStarTreeNode = this.binarySearchChild(high, false, lowStarTreeNode, comparator);
            if (highStarTreeNode != null) {
                for (int lowNodeId = lowStarTreeNode.nodeId(); lowNodeId <= highStarTreeNode.nodeId(); ++lowNodeId) {
                    collector.collectStarTreeNode(new FixedLengthStarTreeNode(this.in, lowNodeId));
                }
            } else if (comparator.compare(lowStarTreeNode.getDimensionValue(), high) <= 0) {
                collector.collectStarTreeNode(lowStarTreeNode);
            }
        }
    }

    private FixedLengthStarTreeNode binarySearchChild(long dimensionValue, boolean matchNextHighest, StarTreeNode lastMatchedNode, Comparator<Long> comparator) throws IOException {
        int high;
        int tempHigh;
        int low;
        int tempLow = low = this.firstChildId;
        int nullNodeId = Integer.MIN_VALUE;
        int starNodeId = Integer.MIN_VALUE;
        if (FixedLengthStarTreeNode.matchStarTreeNodeTypeOrNull(new FixedLengthStarTreeNode(this.in, tempLow), StarTreeNodeType.STAR) != null) {
            starNodeId = tempLow++;
        }
        if (FixedLengthStarTreeNode.matchStarTreeNodeTypeOrNull(new FixedLengthStarTreeNode(this.in, tempHigh = (high = this.getInt(29))), StarTreeNodeType.NULL) != null) {
            nullNodeId = tempHigh--;
        }
        if (lastMatchedNode instanceof FixedLengthStarTreeNode) {
            int lastMatchedNodeId = ((FixedLengthStarTreeNode)lastMatchedNode).nodeId();
            if (lastMatchedNodeId + 1 <= tempHigh) {
                tempLow = lastMatchedNodeId + 1;
            } else {
                return null;
            }
        }
        while (tempLow <= tempHigh) {
            int mid = tempLow + (tempHigh - tempLow) / 2;
            FixedLengthStarTreeNode midNode = new FixedLengthStarTreeNode(this.in, mid);
            long midDimensionValue = midNode.getDimensionValue();
            int compare = comparator.compare(midDimensionValue, dimensionValue);
            if (compare == 0) {
                return midNode;
            }
            if (compare < 0) {
                tempLow = mid + 1;
                if (tempLow > high || tempLow == nullNodeId) {
                    return matchNextHighest ? null : midNode;
                }
                FixedLengthStarTreeNode nodeGreaterThanMid = new FixedLengthStarTreeNode(this.in, tempLow);
                if (comparator.compare(nodeGreaterThanMid.getDimensionValue(), dimensionValue) <= 0) continue;
                return matchNextHighest ? nodeGreaterThanMid : midNode;
            }
            tempHigh = mid - 1;
            if (tempHigh < low || tempHigh == starNodeId) {
                return matchNextHighest ? midNode : null;
            }
            FixedLengthStarTreeNode nodeLessThanMid = new FixedLengthStarTreeNode(this.in, tempHigh);
            if (comparator.compare(nodeLessThanMid.getDimensionValue(), dimensionValue) >= 0) continue;
            return matchNextHighest ? midNode : nodeLessThanMid;
        }
        return null;
    }

    public Iterator<FixedLengthStarTreeNode> getChildrenIterator() throws IOException {
        return new Iterator<FixedLengthStarTreeNode>(){
            private int currentChildId;
            private final int lastChildId;
            {
                this.currentChildId = FixedLengthStarTreeNode.this.firstChildId;
                this.lastChildId = FixedLengthStarTreeNode.this.getInt(29);
            }

            @Override
            public boolean hasNext() {
                return this.currentChildId <= this.lastChildId;
            }

            @Override
            public FixedLengthStarTreeNode next() {
                try {
                    return new FixedLengthStarTreeNode(FixedLengthStarTreeNode.this.in, this.currentChildId++);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int nodeId() {
        return this.nodeId;
    }
}

