/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ReleasableLock;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.engine.CompletionStatsCache;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.EngineCreationFailureException;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.engine.FlushFailedEngineException;
import org.opensearch.index.engine.NRTReplicationReaderManager;
import org.opensearch.index.engine.ReplicaFileTracker;
import org.opensearch.index.engine.SafeCommitInfo;
import org.opensearch.index.engine.Segment;
import org.opensearch.index.seqno.LocalCheckpointTracker;
import org.opensearch.index.seqno.SeqNoStats;
import org.opensearch.index.seqno.SequenceNumbers;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogCorruptedException;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogException;
import org.opensearch.index.translog.TranslogManager;
import org.opensearch.index.translog.WriteOnlyTranslogManager;
import org.opensearch.index.translog.listener.TranslogEventListener;
import org.opensearch.search.suggest.completion.CompletionStats;

@PublicApi(since="1.0.0")
public class NRTReplicationEngine
extends Engine {
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final NRTReplicationReaderManager readerManager;
    private final CompletionStatsCache completionStatsCache;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final WriteOnlyTranslogManager translogManager;
    private final Lock flushLock = new ReentrantLock();
    protected final ReplicaFileTracker replicaFileTracker;
    private volatile long lastReceivedPrimaryGen = -1L;
    private static final int SI_COUNTER_INCREMENT = 100000;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NRTReplicationEngine(EngineConfig engineConfig) {
        super(engineConfig);
        this.store.incRef();
        NRTReplicationReaderManager readerManager = null;
        WriteOnlyTranslogManager translogManagerRef = null;
        boolean success = false;
        try {
            this.replicaFileTracker = new ReplicaFileTracker(xva$0 -> this.store.deleteQuiet((String)xva$0));
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            this.replicaFileTracker.incRef(this.lastCommittedSegmentInfos.files(true));
            this.cleanUnreferencedFiles();
            readerManager = this.buildReaderManager();
            SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommittedSegmentInfos.getUserData().entrySet());
            this.localCheckpointTracker = new LocalCheckpointTracker(commitInfo.maxSeqNo, commitInfo.localCheckpoint);
            this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
            this.readerManager = readerManager;
            this.readerManager.addListener(this.completionStatsCache);
            for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                this.readerManager.addListener(listener);
            }
            Map userData = this.lastCommittedSegmentInfos.getUserData();
            String translogUUID = Objects.requireNonNull((String)userData.get("translog_uuid"));
            this.translogManager = translogManagerRef = new WriteOnlyTranslogManager(engineConfig.getTranslogConfig(), engineConfig.getPrimaryTermSupplier(), engineConfig.getGlobalCheckpointSupplier(), this.getTranslogDeletionPolicy(engineConfig), this.shardId, this.readLock, this::getLocalCheckpointTracker, translogUUID, new TranslogEventListener(){

                @Override
                public void onFailure(String reason, Exception ex) {
                    NRTReplicationEngine.this.failEngine(reason, ex);
                }

                @Override
                public void onAfterTranslogSync() {
                    try {
                        NRTReplicationEngine.this.translogManager.trimUnreferencedReaders();
                    }
                    catch (IOException ex) {
                        throw new TranslogException(NRTReplicationEngine.this.shardId, "failed to trim unreferenced translog readers", ex);
                    }
                }
            }, this, engineConfig.getTranslogFactory(), engineConfig.getStartedPrimarySupplier());
            success = true;
            if (success) return;
        }
        catch (IOException | TranslogCorruptedException e) {
            try {
                throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{readerManager, translogManagerRef});
                if (this.isClosed.get()) throw throwable;
                this.store.decRef();
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{readerManager, translogManagerRef});
        if (this.isClosed.get()) return;
        this.store.decRef();
        return;
    }

    public void cleanUnreferencedFiles() throws IOException {
        this.replicaFileTracker.deleteUnreferencedFiles(this.store.directory().listAll());
    }

    private NRTReplicationReaderManager buildReaderManager() throws IOException {
        return new NRTReplicationReaderManager(OpenSearchDirectoryReader.wrap(this.getDirectoryReader(), this.shardId), this.replicaFileTracker::incRef, this.replicaFileTracker::decRef);
    }

    @Override
    public TranslogManager translogManager() {
        return this.translogManager;
    }

    public synchronized void updateSegments(SegmentInfos infos) throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            long maxSeqNo = Long.parseLong((String)infos.userData.get("max_seq_no"));
            long incomingGeneration = infos.getGeneration();
            this.readerManager.updateSegments(infos);
            if (incomingGeneration != this.lastReceivedPrimaryGen) {
                this.flush(false, true);
                this.translogManager.getDeletionPolicy().setLocalCheckpointOfSafeCommit(maxSeqNo);
                this.translogManager.rollTranslogGeneration();
            }
            this.lastReceivedPrimaryGen = incomingGeneration;
            this.localCheckpointTracker.fastForwardProcessedSeqNo(maxSeqNo);
        }
    }

    private void commitSegmentInfos(SegmentInfos infos) throws IOException {
        Collection previousCommitFiles = this.getLastCommittedSegmentInfos().files(true);
        this.store.commitSegmentInfos(infos, this.localCheckpointTracker.getMaxSeqNo(), this.localCheckpointTracker.getProcessedCheckpoint());
        this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
        this.replicaFileTracker.incRef(this.lastCommittedSegmentInfos.files(true));
        this.replicaFileTracker.decRef(previousCommitFiles);
        this.translogManager.syncTranslog();
    }

    private void commitSegmentInfos() throws IOException {
        this.commitSegmentInfos(this.getLatestSegmentInfos());
    }

    @Override
    public String getHistoryUUID() {
        return this.loadHistoryUUID(this.lastCommittedSegmentInfos.userData);
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public Engine.IndexResult index(Engine.Index index) throws IOException {
        this.ensureOpen();
        Engine.IndexResult indexResult = new Engine.IndexResult(index.version(), index.primaryTerm(), index.seqNo(), false);
        Translog.Location location = this.translogManager.add(new Translog.Index(index, indexResult));
        indexResult.setTranslogLocation(location);
        indexResult.setTook(System.nanoTime() - index.startTime());
        indexResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(index.seqNo());
        return indexResult;
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        this.ensureOpen();
        Engine.DeleteResult deleteResult = new Engine.DeleteResult(delete.version(), delete.primaryTerm(), delete.seqNo(), true);
        Translog.Location location = this.translogManager.add(new Translog.Delete(delete, deleteResult));
        deleteResult.setTranslogLocation(location);
        deleteResult.setTook(System.nanoTime() - delete.startTime());
        deleteResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(delete.seqNo());
        return deleteResult;
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) throws IOException {
        this.ensureOpen();
        Engine.NoOpResult noOpResult = new Engine.NoOpResult(noOp.primaryTerm(), noOp.seqNo());
        Translog.Location location = this.translogManager.add(new Translog.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
        noOpResult.setTranslogLocation(location);
        noOpResult.setTook(System.nanoTime() - noOp.startTime());
        noOpResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(noOp.seqNo());
        return noOpResult;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        return this.getFromSearcher(get, searcherFactory, Engine.SearcherScope.EXTERNAL);
    }

    @Override
    protected ReferenceManager<OpenSearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    @Override
    public Closeable acquireHistoryRetentionLock() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNumber) throws IOException {
        return 0;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return false;
    }

    @Override
    public long getMinRetainedSeqNo() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.localCheckpointTracker.getPersistedCheckpoint();
    }

    @Override
    public long getProcessedLocalCheckpoint() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return this.localCheckpointTracker.getStats(globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.translogManager.getLastSyncedGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.getLatestSegmentInfos(), verbose));
    }

    @Override
    public void refresh(String source) throws EngineException {
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        return false;
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
        this.ensureOpen();
        if (this.engineConfig.getIndexSettings().isWarmIndex()) {
            return;
        }
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) {
                    return;
                }
                this.flushLock.lock();
            }
            try {
                this.commitSegmentInfos();
            }
            catch (IOException e) {
                this.maybeFailEngine("flush", e);
                throw new FlushFailedEngineException(this.shardId, e);
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) throws EngineException, IOException {
    }

    @Override
    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.flush(false, true);
        }
        try {
            IndexCommit indexCommit = Lucene.getIndexCommit(this.lastCommittedSegmentInfos, this.store.directory());
            return new GatedCloseable<IndexCommit>(indexCommit, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {}));
        }
        catch (IOException e) {
            throw new EngineException(this.shardId, "Unable to build latest IndexCommit", e, new Object[0]);
        }
    }

    @Override
    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return new SafeCommitInfo(this.localCheckpointTracker.getProcessedCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                block20: {
                    SegmentInfos latestSegmentInfos = this.getLatestSegmentInfos();
                    if (!this.engineConfig.getIndexSettings().isRemoteStoreEnabled() && !this.engineConfig.getIndexSettings().isAssignedOnRemoteNode()) {
                        latestSegmentInfos.counter += 100000L;
                        latestSegmentInfos.changed();
                    }
                    try {
                        if (!this.engineConfig.getIndexSettings().isWarmIndex()) {
                            this.commitSegmentInfos(latestSegmentInfos);
                        }
                    }
                    catch (IOException e) {
                        if (this.failEngineLock.isHeldByCurrentThread() || this.store.isMarkedCorrupted()) break block20;
                        try {
                            this.store.markStoreCorrupted(e);
                        }
                        catch (IOException ex) {
                            this.logger.warn("Unable to mark store corrupted", (Throwable)ex);
                        }
                    }
                }
                IOUtils.close((Closeable[])new Closeable[]{this.readerManager, this.translogManager});
            }
            catch (Exception e) {
                this.logger.error("failed to close engine", (Throwable)e);
            }
            finally {
                try {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", (Object)reason);
                }
                finally {
                    closedLatch.countDown();
                }
            }
        }
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        return 0;
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.localCheckpointTracker.getMaxSeqNo();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
    }

    @Override
    public void onSettingsChanged(TimeValue translogRetentionAge, ByteSizeValue translogRetentionSize, long softDeletesRetentionOps) {
        TranslogDeletionPolicy translogDeletionPolicy = this.translogManager.getDeletionPolicy();
        translogDeletionPolicy.setRetentionAgeInMillis(translogRetentionAge.millis());
        translogDeletionPolicy.setRetentionSizeInBytes(translogRetentionSize.getBytes());
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected SegmentInfos getLatestSegmentInfos() {
        return this.readerManager.getSegmentInfos();
    }

    @Override
    public synchronized GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
        SegmentInfos latestSegmentInfos = this.getLatestSegmentInfos();
        try {
            Collection files = latestSegmentInfos.files(false);
            this.replicaFileTracker.incRef(files);
            return new GatedCloseable<SegmentInfos>(latestSegmentInfos, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.replicaFileTracker.decRef(files)));
        }
        catch (IOException e) {
            throw new EngineException(this.shardId, e.getMessage(), e, new Object[0]);
        }
    }

    protected LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    private DirectoryReader getDirectoryReader() throws IOException {
        return new SoftDeletesDirectoryReaderWrapper(DirectoryReader.open((Directory)this.store.directory()), "__soft_deletes");
    }
}

