/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.ToLongBiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.OpenSearchParseException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.ICache;
import org.opensearch.common.cache.ICacheKey;
import org.opensearch.common.cache.LoadAwareCacheLoader;
import org.opensearch.common.cache.RemovalListener;
import org.opensearch.common.cache.RemovalNotification;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.common.cache.policy.CachedQueryResult;
import org.opensearch.common.cache.serializer.BytesReferenceSerializer;
import org.opensearch.common.cache.service.CacheService;
import org.opensearch.common.cache.stats.ImmutableCacheStatsHolder;
import org.opensearch.common.cache.store.config.CacheConfig;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.RatioValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IRCKeyWriteableSerializer;
import org.opensearch.indices.IndicesService;
import org.opensearch.threadpool.ThreadPool;

public final class IndicesRequestCache
implements RemovalListener<ICacheKey<Key>, BytesReference>,
Closeable {
    private static final Logger logger = LogManager.getLogger(IndicesRequestCache.class);
    public static final String INDICES_REQUEST_CACHE_CLEANUP_STALENESS_THRESHOLD_SETTING_KEY = "indices.requests.cache.cleanup.staleness_threshold";
    public static final String INDICES_REQUEST_CACHE_CLEANUP_INTERVAL_SETTING_KEY = "indices.requests.cache.cleanup.interval";
    public static final Setting<Boolean> INDEX_CACHE_REQUEST_ENABLED_SETTING = Setting.boolSetting("index.requests.cache.enable", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE = Setting.memorySizeSetting("indices.requests.cache.size", "1%", Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<TimeValue> INDICES_CACHE_QUERY_EXPIRE = Setting.positiveTimeSetting("indices.requests.cache.expire", new TimeValue(0L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_REQUEST_CACHE_CLEANUP_INTERVAL_SETTING = Setting.positiveTimeSetting("indices.requests.cache.cleanup.interval", IndicesService.INDICES_CACHE_CLEAN_INTERVAL_SETTING, Setting.Property.NodeScope);
    public static final Setting<String> INDICES_REQUEST_CACHE_STALENESS_THRESHOLD_SETTING = new Setting<String>("indices.requests.cache.cleanup.staleness_threshold", "0%", IndicesRequestCache::validateStalenessSetting, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_REQUEST_CACHE_MAX_SIZE_ALLOWED_IN_CACHE_SETTING = Setting.intSetting("indices.requests.cache.maximum_cacheable_size", 0, 0, 10000, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Key.class);
    private final ConcurrentMap<CleanupKey, Boolean> registeredClosedListeners = ConcurrentCollections.newConcurrentMap();
    private final TimeValue expire;
    private final ICache<Key, BytesReference> cache;
    private final ClusterService clusterService;
    final Function<ShardId, Optional<CacheEntity>> cacheEntityLookup;
    final IndicesRequestCacheCleanupManager cacheCleanupManager;
    public static final String SHARD_ID_DIMENSION_NAME = "shards";
    public static final String INDEX_DIMENSION_NAME = "indices";

    IndicesRequestCache(Settings settings, Function<ShardId, Optional<CacheEntity>> cacheEntityFunction, CacheService cacheService, ThreadPool threadPool, ClusterService clusterService, NodeEnvironment nodeEnvironment) {
        this.expire = INDICES_CACHE_QUERY_EXPIRE.exists(settings) ? INDICES_CACHE_QUERY_EXPIRE.get(settings) : null;
        this.cacheCleanupManager = new IndicesRequestCacheCleanupManager(threadPool, INDICES_REQUEST_CACHE_CLEANUP_INTERVAL_SETTING.get(settings), this.getStalenessThreshold(settings));
        this.cacheEntityLookup = cacheEntityFunction;
        this.clusterService = clusterService;
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(INDICES_REQUEST_CACHE_STALENESS_THRESHOLD_SETTING, this::setStalenessThreshold);
        CacheConfig<Key, BytesReference> config = this.getCacheConfig(settings, nodeEnvironment);
        this.cache = cacheService.createCache(config, CacheType.INDICES_REQUEST_CACHE);
    }

    CacheConfig<Key, BytesReference> getCacheConfig(Settings settings, NodeEnvironment nodeEnvironment) {
        long sizeInBytes = INDICES_CACHE_QUERY_SIZE.get(settings).getBytes();
        ToLongBiFunction<ICacheKey, BytesReference> weigher = (k, v) -> k.ramBytesUsed(((Key)k.key).ramBytesUsed()) + v.ramBytesUsed();
        CacheConfig.Builder<Key, BytesReference> configBuilder = new CacheConfig.Builder().setSettings(settings).setWeigher(weigher).setValueType(BytesReference.class).setKeyType(Key.class).setRemovalListener(this).setExpireAfterAccess(this.expire).setDimensionNames(List.of(INDEX_DIMENSION_NAME, SHARD_ID_DIMENSION_NAME)).setCachedResultParser(bytesReference -> {
            try {
                return CachedQueryResult.getPolicyValues(bytesReference);
            }
            catch (IOException e) {
                return new CachedQueryResult.PolicyValues(-1L);
            }
        }).setKeySerializer(new IRCKeyWriteableSerializer()).setValueSerializer(new BytesReferenceSerializer()).setClusterSettings(this.clusterService.getClusterSettings()).setStoragePath(nodeEnvironment.nodePaths()[0].path.toString() + "/request_cache");
        if (!CacheService.storeNamePresent(CacheType.INDICES_REQUEST_CACHE, settings)) {
            configBuilder.setMaxSizeInBytes(sizeInBytes);
        }
        return configBuilder.build();
    }

    void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        this.cache.invalidateAll();
        this.cache.close();
        this.cacheCleanupManager.close();
    }

    private double getStalenessThreshold(Settings settings) {
        String threshold = INDICES_REQUEST_CACHE_STALENESS_THRESHOLD_SETTING.get(settings);
        return RatioValue.parseRatioValue(threshold).getAsRatio();
    }

    void setStalenessThreshold(String threshold) {
        this.cacheCleanupManager.updateStalenessThreshold(RatioValue.parseRatioValue(threshold).getAsRatio());
    }

    void clear(CacheEntity entity) {
        this.cacheCleanupManager.enqueueCleanupKey(new CleanupKey(entity, null));
        this.cacheCleanupManager.forceCleanCache();
    }

    @Override
    public void onRemoval(RemovalNotification<ICacheKey<Key>, BytesReference> notification) {
        Key key = (Key)notification.getKey().key;
        IndicesService.IndexShardCacheEntity indexShardCacheEntity = this.cacheEntityLookup.apply(key.shardId).orElse(null);
        if (indexShardCacheEntity != null && key.indexShardHashCode == System.identityHashCode(indexShardCacheEntity.getCacheIdentity())) {
            indexShardCacheEntity.onRemoval(notification);
        }
        CleanupKey cleanupKey = new CleanupKey(indexShardCacheEntity, key.readerCacheKeyId);
        this.cacheCleanupManager.updateStaleCountOnEntryRemoval(cleanupKey, notification);
    }

    private ICacheKey<Key> getICacheKey(Key key) {
        String indexDimensionValue = this.getIndexDimensionName(key);
        String shardIdDimensionValue = this.getShardIdDimensionName(key);
        List<String> dimensions = List.of(indexDimensionValue, shardIdDimensionValue);
        return new ICacheKey<Key>(key, dimensions);
    }

    private String getShardIdDimensionName(Key key) {
        return key.shardId.toString();
    }

    private String getIndexDimensionName(Key key) {
        return key.shardId.getIndexName();
    }

    BytesReference getOrCompute(IndicesService.IndexShardCacheEntity cacheEntity, CheckedSupplier<BytesReference, IOException> loader, DirectoryReader reader, BytesReference cacheKey) throws Exception {
        assert (reader.getReaderCacheHelper() != null);
        assert (reader.getReaderCacheHelper() instanceof OpenSearchDirectoryReader.DelegatingCacheHelper);
        OpenSearchDirectoryReader.DelegatingCacheHelper delegatingCacheHelper = (OpenSearchDirectoryReader.DelegatingCacheHelper)reader.getReaderCacheHelper();
        String readerCacheKeyId = delegatingCacheHelper.getDelegatingCacheKey().getId();
        assert (readerCacheKeyId != null);
        IndexShard indexShard = (IndexShard)cacheEntity.getCacheIdentity();
        Key key = new Key(indexShard.shardId(), cacheKey, readerCacheKeyId, System.identityHashCode(indexShard));
        Loader cacheLoader = new Loader(cacheEntity, loader);
        BytesReference value = this.cache.computeIfAbsent(this.getICacheKey(key), cacheLoader);
        if (cacheLoader.isLoaded()) {
            Boolean previous;
            cacheEntity.onMiss();
            CleanupKey cleanupKey = new CleanupKey(cacheEntity, readerCacheKeyId);
            if (!this.registeredClosedListeners.containsKey(cleanupKey) && (previous = this.registeredClosedListeners.putIfAbsent(cleanupKey, Boolean.TRUE)) == null) {
                OpenSearchDirectoryReader.addReaderCloseListener(reader, cleanupKey);
            }
            this.cacheCleanupManager.updateStaleCountOnCacheInsert(cleanupKey);
        } else {
            cacheEntity.onHit();
        }
        return value;
    }

    void invalidate(IndicesService.IndexShardCacheEntity cacheEntity, DirectoryReader reader, BytesReference cacheKey) {
        assert (reader.getReaderCacheHelper() instanceof OpenSearchDirectoryReader.DelegatingCacheHelper);
        OpenSearchDirectoryReader.DelegatingCacheHelper delegatingCacheHelper = (OpenSearchDirectoryReader.DelegatingCacheHelper)reader.getReaderCacheHelper();
        String readerCacheKeyId = delegatingCacheHelper.getDelegatingCacheKey().getId();
        IndexShard indexShard = (IndexShard)cacheEntity.getCacheIdentity();
        this.cache.invalidate(this.getICacheKey(new Key(indexShard.shardId(), cacheKey, readerCacheKeyId, System.identityHashCode(indexShard))));
    }

    long count() {
        return this.cache.count();
    }

    ImmutableCacheStatsHolder stats(String[] levels) {
        return this.cache.stats(levels);
    }

    int numRegisteredCloseListeners() {
        return this.registeredClosedListeners.size();
    }

    static String validateStalenessSetting(String staleThreshold) {
        try {
            RatioValue.parseRatioValue(staleThreshold);
        }
        catch (OpenSearchParseException e) {
            e.addSuppressed((Throwable)e);
            throw e;
        }
        return staleThreshold;
    }

    class IndicesRequestCacheCleanupManager
    implements Closeable {
        private final Set<CleanupKey> keysToClean;
        private final ConcurrentHashMap<ShardId, ConcurrentHashMap<String, Integer>> cleanupKeyToCountMap;
        private final AtomicInteger staleKeysCount;
        private volatile double stalenessThreshold;
        private final IndicesRequestCacheCleaner cacheCleaner;

        IndicesRequestCacheCleanupManager(ThreadPool threadpool, TimeValue cleanInterval, double stalenessThreshold) {
            this.stalenessThreshold = stalenessThreshold;
            this.keysToClean = ConcurrentCollections.newConcurrentSet();
            this.cleanupKeyToCountMap = new ConcurrentHashMap();
            this.staleKeysCount = new AtomicInteger(0);
            this.cacheCleaner = new IndicesRequestCacheCleaner(this, this, threadpool, cleanInterval);
            threadpool.schedule(this.cacheCleaner, cleanInterval, "same");
        }

        void updateStalenessThreshold(double stalenessThreshold) {
            double oldStalenessThreshold = this.stalenessThreshold;
            this.stalenessThreshold = stalenessThreshold;
            if (logger.isDebugEnabled()) {
                logger.debug("Staleness threshold for indices request cache changed to {} from {}", (Object)this.stalenessThreshold, (Object)oldStalenessThreshold);
            }
        }

        void enqueueCleanupKey(CleanupKey cleanupKey) {
            this.keysToClean.add(cleanupKey);
            this.incrementStaleKeysCount(cleanupKey);
        }

        private void updateStaleCountOnCacheInsert(CleanupKey cleanupKey) {
            if (cleanupKey.entity == null) {
                return;
            }
            IndexShard indexShard = (IndexShard)cleanupKey.entity.getCacheIdentity();
            if (indexShard == null) {
                logger.warn("IndexShard is null for CleanupKey: {} while cleaning Indices Request Cache", (Object)cleanupKey.readerCacheKeyId);
                return;
            }
            ShardId shardId = indexShard.shardId();
            this.addToCleanupKeyToCountMap(shardId, cleanupKey.readerCacheKeyId);
        }

        void addToCleanupKeyToCountMap(ShardId shardId, String readerCacheKeyId) {
            this.cleanupKeyToCountMap.computeIfAbsent(shardId, k -> new ConcurrentHashMap()).merge(readerCacheKeyId, 1, Integer::sum);
        }

        private void updateStaleCountOnEntryRemoval(CleanupKey cleanupKey, RemovalNotification<ICacheKey<Key>, BytesReference> notification) {
            if (notification.getRemovalReason() == RemovalReason.REPLACED) {
                return;
            }
            if (cleanupKey.entity == null) {
                this.staleKeysCount.decrementAndGet();
                return;
            }
            IndexShard indexShard = (IndexShard)cleanupKey.entity.getCacheIdentity();
            if (indexShard == null) {
                logger.warn("IndexShard is null for CleanupKey: {} while cleaning Indices Request Cache", (Object)cleanupKey.readerCacheKeyId);
                return;
            }
            ShardId shardId = indexShard.shardId();
            this.cleanupKeyToCountMap.compute(shardId, (key, readerCacheKeyMap) -> {
                if (readerCacheKeyMap == null || !readerCacheKeyMap.containsKey(cleanupKey.readerCacheKeyId)) {
                    this.staleKeysCount.decrementAndGet();
                    return readerCacheKeyMap;
                }
                Integer count = (Integer)readerCacheKeyMap.get(cleanupKey.readerCacheKeyId);
                assert (count != null && count >= 0);
                int newCount = count - 1;
                if (newCount > 0) {
                    readerCacheKeyMap.put(cleanupKey.readerCacheKeyId, newCount);
                } else {
                    readerCacheKeyMap.remove(cleanupKey.readerCacheKeyId);
                }
                return readerCacheKeyMap.isEmpty() ? null : readerCacheKeyMap;
            });
        }

        private void incrementStaleKeysCount(CleanupKey cleanupKey) {
            if (cleanupKey.entity == null) {
                return;
            }
            IndexShard indexShard = (IndexShard)cleanupKey.entity.getCacheIdentity();
            if (indexShard == null) {
                logger.warn("IndexShard is null for CleanupKey: {}", (Object)cleanupKey.readerCacheKeyId);
                return;
            }
            ShardId shardId = indexShard.shardId();
            this.cleanupKeyToCountMap.computeIfPresent(shardId, (currentShardId, countMap) -> {
                if (cleanupKey.readerCacheKeyId == null) {
                    int totalSum = countMap.values().stream().mapToInt(Integer::intValue).sum();
                    this.staleKeysCount.addAndGet(totalSum);
                    return null;
                }
                countMap.computeIfPresent(cleanupKey.readerCacheKeyId, (readerCacheKey, count) -> {
                    this.staleKeysCount.addAndGet((int)count);
                    return null;
                });
                if (countMap.isEmpty()) {
                    return null;
                }
                return countMap;
            });
        }

        AtomicInteger getStaleKeysCount() {
            return this.staleKeysCount;
        }

        void cleanCache() {
            this.cleanCache(this.stalenessThreshold);
        }

        private void forceCleanCache() {
            this.cleanCache(0.0);
        }

        private synchronized void cleanCache(double stalenessThreshold) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaning Indices Request Cache with threshold : " + stalenessThreshold);
            }
            if (this.canSkipCacheCleanup(stalenessThreshold)) {
                return;
            }
            HashSet<CleanupKey> cleanupKeysFromOutdatedReaders = new HashSet<CleanupKey>();
            HashSet<Tuple> cleanupKeysFromFullClean = new HashSet<Tuple>();
            HashSet<Tuple> cleanupKeysFromClosedShards = new HashSet<Tuple>();
            Iterator<CleanupKey> iterator = this.keysToClean.iterator();
            while (iterator.hasNext()) {
                CleanupKey cleanupKey = iterator.next();
                iterator.remove();
                IndexShard indexShard = (IndexShard)cleanupKey.entity.getCacheIdentity();
                if (cleanupKey.readerCacheKeyId == null) {
                    cleanupKeysFromFullClean.add(new Tuple((Object)indexShard.shardId(), (Object)indexShard.hashCode()));
                    continue;
                }
                if (!cleanupKey.entity.isOpen()) {
                    cleanupKeysFromClosedShards.add(new Tuple((Object)indexShard.shardId(), (Object)indexShard.hashCode()));
                    continue;
                }
                cleanupKeysFromOutdatedReaders.add(cleanupKey);
            }
            if (cleanupKeysFromOutdatedReaders.isEmpty() && cleanupKeysFromFullClean.isEmpty() && cleanupKeysFromClosedShards.isEmpty()) {
                return;
            }
            HashSet<List<String>> dimensionListsToDrop = new HashSet<List<String>>();
            Iterator<ICacheKey<Key>> iterator2 = IndicesRequestCache.this.cache.keys().iterator();
            while (iterator2.hasNext()) {
                ICacheKey<Key> iCacheKey = iterator2.next();
                Key delegatingKey = (Key)iCacheKey.key;
                Tuple shardIdInfo = new Tuple((Object)delegatingKey.shardId, (Object)delegatingKey.indexShardHashCode);
                if (cleanupKeysFromFullClean.contains(shardIdInfo) || cleanupKeysFromClosedShards.contains(shardIdInfo)) {
                    iterator2.remove();
                } else {
                    CacheEntity cacheEntity = IndicesRequestCache.this.cacheEntityLookup.apply(delegatingKey.shardId).orElse(null);
                    if (cacheEntity == null) {
                        dimensionListsToDrop.add(iCacheKey.dimensions);
                        iterator2.remove();
                    } else {
                        CleanupKey cleanupKey = new CleanupKey(cacheEntity, delegatingKey.readerCacheKeyId);
                        if (cleanupKeysFromOutdatedReaders.contains(cleanupKey)) {
                            iterator2.remove();
                        }
                    }
                }
                if (!cleanupKeysFromClosedShards.contains(shardIdInfo)) continue;
                dimensionListsToDrop.add(iCacheKey.dimensions);
            }
            for (List list : dimensionListsToDrop) {
                ICacheKey<Object> dummyKey = new ICacheKey<Object>(null, list);
                dummyKey.setDropStatsForDimensions(true);
                IndicesRequestCache.this.cache.invalidate(dummyKey);
            }
            IndicesRequestCache.this.cache.refresh();
        }

        private synchronized boolean canSkipCacheCleanup(double cleanThresholdPercent) {
            if (cleanThresholdPercent == 0.0) {
                return false;
            }
            double staleKeysInCachePercentage = this.staleKeysInCachePercentage();
            if (staleKeysInCachePercentage < cleanThresholdPercent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Skipping Indices Request cache cleanup since the percentage of stale keys : " + staleKeysInCachePercentage + " is less than the threshold : " + this.stalenessThreshold);
                }
                return true;
            }
            return false;
        }

        private synchronized double staleKeysInCachePercentage() {
            long totalKeysInCache = IndicesRequestCache.this.count();
            if (totalKeysInCache == 0L || this.staleKeysCount.get() == 0) {
                return 0.0;
            }
            return (double)this.staleKeysCount.get() / (double)totalKeysInCache;
        }

        @Override
        public void close() {
            this.cacheCleaner.close();
        }

        ConcurrentHashMap<ShardId, ConcurrentHashMap<String, Integer>> getCleanupKeyToCountMap() {
            return this.cleanupKeyToCountMap;
        }

        private final class IndicesRequestCacheCleaner
        implements Runnable,
        Releasable {
            private final IndicesRequestCacheCleanupManager cacheCleanupManager;
            private final ThreadPool threadPool;
            private final TimeValue interval;
            private final AtomicBoolean closed = new AtomicBoolean(false);

            IndicesRequestCacheCleaner(IndicesRequestCacheCleanupManager indicesRequestCacheCleanupManager, IndicesRequestCacheCleanupManager cacheCleanupManager, ThreadPool threadPool, TimeValue interval) {
                this.cacheCleanupManager = cacheCleanupManager;
                this.threadPool = threadPool;
                this.interval = interval;
            }

            @Override
            public void run() {
                try {
                    this.cacheCleanupManager.cleanCache();
                }
                catch (Exception e) {
                    logger.warn("Exception during periodic indices request cache cleanup:", (Throwable)e);
                }
                if (!this.closed.get()) {
                    this.threadPool.scheduleUnlessShuttingDown(this.interval, "same", this);
                }
            }

            public void close() {
                this.closed.compareAndSet(false, true);
            }
        }
    }

    static class Key
    implements Accountable,
    Writeable {
        public final ShardId shardId;
        public final int indexShardHashCode;
        public final String readerCacheKeyId;
        public final BytesReference value;

        Key(ShardId shardId, BytesReference value, String readerCacheKeyId, int indexShardHashCode) {
            this.shardId = shardId;
            this.value = value;
            this.readerCacheKeyId = Objects.requireNonNull(readerCacheKeyId);
            this.indexShardHashCode = indexShardHashCode;
        }

        Key(StreamInput in) throws IOException {
            this.shardId = (ShardId)in.readOptionalWriteable(ShardId::new);
            this.readerCacheKeyId = in.readOptionalString();
            this.value = in.readBytesReference();
            this.indexShardHashCode = in.readInt();
        }

        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.shardId.getBaseRamBytesUsed() + (long)this.value.length();
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!Objects.equals(this.readerCacheKeyId, key.readerCacheKeyId)) {
                return false;
            }
            if (!this.shardId.equals((Object)key.shardId)) {
                return false;
            }
            if (!this.value.equals((Object)key.value)) {
                return false;
            }
            return this.indexShardHashCode == key.indexShardHashCode;
        }

        public int hashCode() {
            int result = this.shardId.hashCode();
            result = 31 * result + this.readerCacheKeyId.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + this.indexShardHashCode;
            return result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.shardId);
            out.writeOptionalString(this.readerCacheKeyId);
            out.writeBytesReference(this.value);
            out.writeInt(this.indexShardHashCode);
        }
    }

    private class CleanupKey
    implements IndexReader.ClosedListener {
        final CacheEntity entity;
        final String readerCacheKeyId;

        private CleanupKey(CacheEntity entity, String readerCacheKeyId) {
            this.entity = entity;
            this.readerCacheKeyId = readerCacheKeyId;
        }

        public void onClose(IndexReader.CacheKey cacheKey) {
            Boolean wasRegistered = (Boolean)IndicesRequestCache.this.registeredClosedListeners.remove(this);
            if (wasRegistered != null) {
                IndicesRequestCache.this.cacheCleanupManager.enqueueCleanupKey(this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CleanupKey that = (CleanupKey)o;
            if (!Objects.equals(this.readerCacheKeyId, that.readerCacheKeyId)) {
                return false;
            }
            return this.entity.getCacheIdentity().equals(that.entity.getCacheIdentity());
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + Objects.hashCode(this.readerCacheKeyId);
            return result;
        }
    }

    static interface CacheEntity
    extends Accountable {
        public void onCached(ICacheKey<Key> var1, BytesReference var2);

        public boolean isOpen();

        public Object getCacheIdentity();

        public void onHit();

        public void onMiss();

        public void onRemoval(RemovalNotification<ICacheKey<Key>, BytesReference> var1);
    }

    private static class Loader
    implements LoadAwareCacheLoader<ICacheKey<Key>, BytesReference> {
        private final CacheEntity entity;
        private final CheckedSupplier<BytesReference, IOException> loader;
        private boolean loaded;

        Loader(CacheEntity entity, CheckedSupplier<BytesReference, IOException> loader) {
            this.entity = entity;
            this.loader = loader;
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public BytesReference load(ICacheKey<Key> key) throws Exception {
            BytesReference value = (BytesReference)this.loader.get();
            this.entity.onCached(key, value);
            this.loaded = true;
            return value;
        }
    }
}

