/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.DeleteForecasterAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.transport.DeleteConfigRequest;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public class RestDeleteForecasterAction
extends BaseRestHandler {
    public static final String DELETE_FORECASTER_ACTION = "delete_forecaster";

    public String getName() {
        return DELETE_FORECASTER_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            String forecasterId = request.param("forecasterID");
            DeleteConfigRequest deleteForecasterRequest = new DeleteConfigRequest(forecasterId);
            return channel -> client.execute((ActionType)DeleteForecasterAction.INSTANCE, (ActionRequest)deleteForecasterRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_forecast/forecasters", "forecasterID")));
    }
}

