/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.changes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/replication/action/changes/GetChangesRequest;", "Lorg/opensearch/action/support/single/shard/SingleShardRequest;", "shardId", "Lorg/opensearch/core/index/shard/ShardId;", "fromSeqNo", "", "toSeqNo", "(Lorg/opensearch/core/index/shard/ShardId;JJ)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getFromSeqNo", "()J", "getShardId", "()Lorg/opensearch/core/index/shard/ShardId;", "getToSeqNo", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-cross-cluster-replication"})
public final class GetChangesRequest
extends SingleShardRequest<GetChangesRequest> {
    @NotNull
    private final ShardId shardId;
    private final long fromSeqNo;
    private final long toSeqNo;

    @NotNull
    public final ShardId getShardId() {
        return this.shardId;
    }

    public final long getFromSeqNo() {
        return this.fromSeqNo;
    }

    public final long getToSeqNo() {
        return this.toSeqNo;
    }

    public GetChangesRequest(@NotNull ShardId shardId, long fromSeqNo, long toSeqNo) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        super(shardId.getIndexName());
        this.shardId = shardId;
        this.fromSeqNo = fromSeqNo;
        this.toSeqNo = toSeqNo;
    }

    public GetChangesRequest(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
        this.shardId = new ShardId(input);
        this.fromSeqNo = input.readLong();
        this.toSeqNo = input.readVLong();
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return super.validateNonNullIndex();
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeLong(this.fromSeqNo);
        out.writeVLong(this.toSeqNo);
    }
}

