"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSplitButton", {
  enumerable: true,
  get: function get() {
    return _split_button.EuiSplitButton;
  }
});
exports.OuiSplitButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _accessibility = require("../accessibility");

var _split_button_control = require("./split_button_control");

var _popover = require("../popover");

var _context_menu = require("../context_menu");

var _services = require("../../services");

var _i18n = require("../i18n");

var _text = require("../text");

var _focus_trap = require("../focus_trap");

var _tabbable = require("tabbable");

var _split_button = require("../../eui_components/split_button/split_button");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
var ShiftDirection;

(function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
})(ShiftDirection || (ShiftDirection = {}));

var OuiSplitButton = function OuiSplitButton(_ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'primary' : _ref$color,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      disabled = _ref.disabled,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? [] : _ref$options,
      selectedIndex = _ref.selectedIndex,
      _ref$initiallyOpen = _ref.initiallyOpen,
      initiallyOpen = _ref$initiallyOpen === void 0 ? false : _ref$initiallyOpen,
      hasDividers = _ref.hasDividers,
      itemClassName = _ref.itemClassName,
      onClick = _ref.onClick,
      className = _ref.className,
      popoverClassName = _ref.popoverClassName,
      children = _ref.children,
      dropdownProps = _ref.dropdownProps,
      optionProps = _ref.optionProps,
      buttonProps = _ref.buttonProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["color", "fullWidth", "disabled", "options", "selectedIndex", "initiallyOpen", "hasDividers", "itemClassName", "onClick", "className", "popoverClassName", "children", "dropdownProps", "optionProps", "buttonProps"]);
  var itemNodes = (0, _react.useMemo)(function () {
    return [];
  }, []);

  var _useState = (0, _react.useState)(!!initiallyOpen),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(null),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      panelEl = _useState4[0],
      setPanelEl = _useState4[1];

  var panelRef = function panelRef(node) {
    return setPanelEl(node);
  };

  var onKeyDown = function onKeyDown(event) {
    if (panelEl && event.key === _services.cascadingMenuKeys.TAB) {
      var tabbableItems = (0, _tabbable.tabbable)(panelEl).filter(function (el) {
        return Array.from(el.attributes).map(function (el) {
          return el.name;
        }).indexOf('data-focus-guard') < 0;
      });

      if (tabbableItems.length && tabbableItems[tabbableItems.length - 1] === document.activeElement) {
        setIsOpen(false);
      }
    }
  };

  var focusItemAt = (0, _react.useCallback)(function (index) {
    var targetElement = itemNodes[index];

    if (targetElement != null) {
      targetElement.focus();
      return targetElement.matches(':focus');
    }
  }, [itemNodes]);
  var focusSelected = (0, _react.useCallback)(function () {
    requestAnimationFrame(function () {
      var hasFocus = focusItemAt(selectedIndex || 0);

      if (!hasFocus) {
        focusSelected();
      }
    });
  }, [selectedIndex, focusItemAt]);
  (0, _react.useEffect)(function () {
    isOpen && requestAnimationFrame(focusSelected);
  }, [isOpen, focusSelected]);

  var onSelectKeyDown = function onSelectKeyDown(event) {
    if (event.key === _services.keys.ARROW_UP || event.key === _services.keys.ARROW_DOWN) {
      event.preventDefault();
      event.stopPropagation();
      setIsOpen(true);
    }
  };

  var shiftFocus = function shiftFocus(direction) {
    var currentIndex = itemNodes.indexOf(document.activeElement);
    setIsOpen(true);

    if (currentIndex === -1) {
      // somehow the select options has lost focus
      focusItemAt(0);
    } else {
      if (direction === ShiftDirection.BACK) {
        focusItemAt(currentIndex === 0 ? itemNodes.length - 1 : currentIndex - 1);
      } else {
        focusItemAt(currentIndex === itemNodes.length - 1 ? 0 : currentIndex + 1);
      }
    }
  };

  var onItemKeyDown = function onItemKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      // close the popover and prevent ancestors from handling
      event.preventDefault();
      event.stopPropagation();
      setIsOpen(false);
    } else if (event.key === _services.keys.TAB) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.FORWARD);
    } else if (event.key === _services.keys.TAB && event.shiftKey) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.BACK);
    } else if (event.key === _services.keys.ARROW_UP) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.BACK);
    } else if (event.key === _services.keys.ARROW_DOWN) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.FORWARD);
    }
  };

  var popoverClasses = (0, _classnames.default)('ouiSplitButton', popoverClassName);
  var buttonClasses = (0, _classnames.default)({
    'ouiSplitButton--isOpen__button': isOpen
  }, className);
  var itemClasses = (0, _classnames.default)('ouiSplitButton__item', {
    'ouiSplitButton__item--hasDividers': hasDividers
  }, itemClassName);

  var onPrimaryClick = function onPrimaryClick() {
    onClick === null || onClick === void 0 ? void 0 : onClick();
    setIsOpen(false);
  };

  var button = /*#__PURE__*/_react.default.createElement(_split_button_control.OuiSplitButtonControl, (0, _extends2.default)({
    color: color,
    onDropdownClick: function onDropdownClick() {
      return setIsOpen(!isOpen);
    },
    onClick: onPrimaryClick,
    onKeyDown: onSelectKeyDown,
    className: buttonClasses,
    fullWidth: fullWidth,
    dropdownProps: dropdownProps,
    buttonProps: buttonProps,
    disabled: disabled
  }, rest), children);

  var itemIcon = function itemIcon(index) {
    if (selectedIndex === undefined) return;
    if (selectedIndex === index) return 'check';
    return 'empty';
  };

  var items = options.map(function (option, index) {
    var isSelected = selectedIndex === index;
    var content = typeof option.display === 'string' ? /*#__PURE__*/_react.default.createElement(_text.OuiText, (0, _extends2.default)({
      textAlign: "center"
    }, optionProps), option.display) : option.display;

    var itemOnClick = function itemOnClick() {
      var _option$onClick;

      setIsOpen(false);
      (_option$onClick = option.onClick) === null || _option$onClick === void 0 ? void 0 : _option$onClick.call(option);
    };

    return /*#__PURE__*/_react.default.createElement(_context_menu.OuiContextMenuItem, {
      key: "optionItem_".concat(index),
      className: itemClasses,
      color: color,
      icon: itemIcon(index),
      href: option.href,
      target: option.target,
      onClick: itemOnClick,
      onKeyDown: onItemKeyDown,
      layoutAlign: "center",
      buttonRef: function buttonRef(node) {
        return itemNodes[index] = node;
      },
      role: "option",
      id: "splitButtonItem_".concat(index),
      "aria-selected": isSelected ? 'true' : 'false'
    }, content);
  }); // return <div>SplitButton</div>;

  return /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, {
    ownFocus: false,
    hasArrow: false,
    anchorPosition: "downRight",
    button: button,
    panelRef: panelRef,
    className: popoverClasses,
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
    role: "alert"
  }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiSplitButton.screenReaderAnnouncement",
    default: "You are in a selector of {optionsCount} items and must select a single option. Use the up and down keys to navigate or escape to close.",
    values: {
      optionsCount: options === null || options === void 0 ? void 0 : options.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_focus_trap.OuiFocusTrap, {
    clickOutsideDisables: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    onKeyDown: onKeyDown
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "ouiSplitButton__listbox",
    role: "listbox",
    "aria-activedescendant": "".concat(selectedIndex),
    tabIndex: 0
  }, items))));
};
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */


exports.OuiSplitButton = OuiSplitButton;