"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityUISettings = void 0;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
var _trace_analytics = require("../../common/constants/trace_analytics");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerObservabilityUISettings = uiSettings => {
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SPAN_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.name', {
        defaultMessage: 'Trace analytics span indices'
      }),
      value: _trace_analytics.DATA_PREPPER_INDEX_NAME,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.description', {
        defaultMessage: 'Configure span indices that adhere to Data Prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SERVICE_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.name', {
        defaultMessage: 'Trace analytics service indices'
      }),
      value: _trace_analytics.DATA_PREPPER_SERVICE_INDEX_NAME,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.description', {
        defaultMessage: 'Configure service indices that adhere to Data Prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_MODE_DEFAULT_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.name', {
        defaultMessage: 'Trace analytics default mode'
      }),
      value: false,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.description', {
        defaultMessage: 'Enable this to default to Data Prepper mode in the trace analytics plugin'
      }),
      schema: _configSchema.schema.boolean()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CORRELATED_LOGS_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsIndices.name', {
        defaultMessage: 'Trace analytics correlated logs indices'
      }),
      value: _trace_analytics.DEFAULT_SS4O_LOGS_INDEX,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsIndices.description', {
        defaultMessage: 'Configure correlated logs indices, to be used by the trace analytics plugin to correlate spans and services to logs'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_LOGS_FIELD_MAPPNIGS_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsFieldMappings.name', {
        defaultMessage: 'Trace analytics correlated logs fields'
      }),
      value: _trace_analytics.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsFieldMappings.description', {
        defaultMessage: 'Configure correlated logs fields, to be used by the trace analytics plugin for correlate spans and services to logs'
      }),
      schema: _configSchema.schema.object({
        serviceName: _configSchema.schema.string(),
        spanId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.string(),
        traceId: _configSchema.schema.string()
      })
    }
  });
};
exports.registerObservabilityUISettings = registerObservabilityUISettings;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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