/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.requests.message.MLMcpMessageRequest;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportMcpMessageAction
extends HandledTransportAction<ActionRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpMessageAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportMcpMessageAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/mcp/message", transportService, actionFilters, MLMcpMessageRequest::new);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            listener.onFailure((Exception)new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        final MLMcpMessageRequest mlMcpMessageRequest = MLMcpMessageRequest.fromActionRequest((TransportRequest)request);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            final ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.transportService.sendRequest((DiscoveryNode)this.clusterService.state().nodes().getNodes().get(mlMcpMessageRequest.getNodeId()), "cluster:admin/opensearch/ml/mcp/message/dispatch", (TransportRequest)mlMcpMessageRequest, (TransportResponseHandler)new TransportResponseHandler<AcknowledgedResponse>(){

                public AcknowledgedResponse read(StreamInput streamInput) throws IOException {
                    return new AcknowledgedResponse(streamInput);
                }

                public void handleResponse(AcknowledgedResponse acknowledgedResponse) {
                    restoreListener.onResponse((Object)acknowledgedResponse);
                }

                public void handleException(TransportException e) {
                    log.error("Failed to process the MCP message request during sending it to corresponding node, sessionId is: {}, request is: {}", (Object)mlMcpMessageRequest.getSessionId(), (Object)mlMcpMessageRequest.getRequestBody(), (Object)e);
                    restoreListener.onFailure((Exception)e);
                }

                public String executor() {
                    return "same";
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to send the MCP message request to corresponding node, sessionId is: {}, request is: {}", (Object)mlMcpMessageRequest.getSessionId(), (Object)mlMcpMessageRequest.getRequestBody(), (Object)e);
            listener.onFailure(e);
        }
    }
}

