/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.evaluation;

import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleBiFunction;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.classification.evaluation.ConfusionMatrix;
import org.tribuo.classification.evaluation.LabelConfusionMatrix;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricContext;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.sequence.SequenceModel;

public class LabelMetric
implements EvaluationMetric<Label, Context> {
    private final MetricTarget<Label> tgt;
    private final String name;
    private final ToDoubleBiFunction<MetricTarget<Label>, Context> impl;

    public LabelMetric(MetricTarget<Label> tgt, String name, ToDoubleBiFunction<MetricTarget<Label>, Context> impl) {
        this.tgt = tgt;
        this.name = name;
        this.impl = impl;
    }

    public double compute(Context context) {
        return this.impl.applyAsDouble(this.tgt, context);
    }

    public MetricTarget<Label> getTarget() {
        return this.tgt;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelMetric that = (LabelMetric)o;
        return Objects.equals(this.tgt, that.tgt) && Objects.equals(this.name, that.name) && Objects.equals(this.impl, that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.tgt, this.name, this.impl);
    }

    public String toString() {
        return "LabelMetric{target=" + this.tgt + ", name='" + this.name + '}';
    }

    public Context createContext(Model<Label> model, List<Prediction<Label>> predictions) {
        return new Context(model, predictions);
    }

    public static final class Context
    extends MetricContext<Label> {
        private final ConfusionMatrix<Label> cm;

        public Context(Model<Label> model, List<Prediction<Label>> predictions) {
            super(model, predictions);
            this.cm = new LabelConfusionMatrix((ImmutableOutputInfo<Label>)model.getOutputIDInfo(), predictions);
        }

        public Context(SequenceModel<Label> model, List<Prediction<Label>> predictions) {
            super(model, predictions);
            this.cm = new LabelConfusionMatrix((ImmutableOutputInfo<Label>)model.getOutputIDInfo(), predictions);
        }

        public ConfusionMatrix<Label> getCM() {
            return this.cm;
        }
    }
}

