/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-BM\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011Bg\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010#0\"J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lorg/opensearch/commons/alerting/model/Finding;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "id", "", "relatedDocIds", "", "monitorId", "monitorName", "index", "docLevelQueries", "Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "timestamp", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/time/Instant;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "correlatedDocIds", "executionId", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/time/Instant;Ljava/lang/String;)V", "getCorrelatedDocIds", "()Ljava/util/List;", "getDocLevelQueries", "getExecutionId", "()Ljava/lang/String;", "getId", "getIndex", "getMonitorId", "getMonitorName", "getRelatedDocIds", "getTimestamp", "()Ljava/time/Instant;", "asTemplateArg", "", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nFinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Finding.kt\norg/opensearch/commons/alerting/model/Finding\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,188:1\n37#2,2:189\n*S KotlinDebug\n*F\n+ 1 Finding.kt\norg/opensearch/commons/alerting/model/Finding\n*L\n87#1:189,2\n*E\n"})
public final class Finding
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final List<String> relatedDocIds;
    @NotNull
    private final List<String> correlatedDocIds;
    @NotNull
    private final String monitorId;
    @NotNull
    private final String monitorName;
    @NotNull
    private final String index;
    @NotNull
    private final List<DocLevelQuery> docLevelQueries;
    @NotNull
    private final Instant timestamp;
    @Nullable
    private final String executionId;
    @NotNull
    public static final String FINDING_ID_FIELD = "id";
    @NotNull
    public static final String RELATED_DOC_IDS_FIELD = "related_doc_ids";
    @NotNull
    public static final String CORRELATED_DOC_IDS_FIELD = "correlated_doc_ids";
    @NotNull
    public static final String MONITOR_ID_FIELD = "monitor_id";
    @NotNull
    public static final String MONITOR_NAME_FIELD = "monitor_name";
    @NotNull
    public static final String INDEX_FIELD = "index";
    @NotNull
    public static final String QUERIES_FIELD = "queries";
    @NotNull
    public static final String TIMESTAMP_FIELD = "timestamp";
    @NotNull
    public static final String EXECUTION_ID_FIELD = "execution_id";
    @NotNull
    public static final String NO_ID = "";

    public Finding(@NotNull String id, @NotNull List<String> relatedDocIds, @NotNull List<String> correlatedDocIds, @NotNull String monitorId, @NotNull String monitorName, @NotNull String index, @NotNull List<DocLevelQuery> docLevelQueries, @NotNull Instant timestamp, @Nullable String executionId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)FINDING_ID_FIELD);
        Intrinsics.checkNotNullParameter(relatedDocIds, (String)"relatedDocIds");
        Intrinsics.checkNotNullParameter(correlatedDocIds, (String)"correlatedDocIds");
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)index, (String)INDEX_FIELD);
        Intrinsics.checkNotNullParameter(docLevelQueries, (String)"docLevelQueries");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)TIMESTAMP_FIELD);
        this.id = id;
        this.relatedDocIds = relatedDocIds;
        this.correlatedDocIds = correlatedDocIds;
        this.monitorId = monitorId;
        this.monitorName = monitorName;
        this.index = index;
        this.docLevelQueries = docLevelQueries;
        this.timestamp = timestamp;
        this.executionId = executionId;
    }

    public /* synthetic */ Finding(String string, List list, List list2, String string2, String string3, String string4, List list3, Instant instant, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = NO_ID;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            string5 = null;
        }
        this(string, (List<String>)list, list2, string2, string3, string4, list3, instant, string5);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<String> getRelatedDocIds() {
        return this.relatedDocIds;
    }

    @NotNull
    public final List<String> getCorrelatedDocIds() {
        return this.correlatedDocIds;
    }

    @NotNull
    public final String getMonitorId() {
        return this.monitorId;
    }

    @NotNull
    public final String getMonitorName() {
        return this.monitorName;
    }

    @NotNull
    public final String getIndex() {
        return this.index;
    }

    @NotNull
    public final List<DocLevelQuery> getDocLevelQueries() {
        return this.docLevelQueries;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String getExecutionId() {
        return this.executionId;
    }

    public Finding(@NotNull String id, @NotNull List<String> relatedDocIds, @NotNull String monitorId, @NotNull String monitorName, @NotNull String index, @NotNull List<DocLevelQuery> docLevelQueries, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)id, (String)FINDING_ID_FIELD);
        Intrinsics.checkNotNullParameter(relatedDocIds, (String)"relatedDocIds");
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)index, (String)INDEX_FIELD);
        Intrinsics.checkNotNullParameter(docLevelQueries, (String)"docLevelQueries");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)TIMESTAMP_FIELD);
        this(id, relatedDocIds, null, monitorId, monitorName, index, docLevelQueries, timestamp, null, 4, null);
    }

    public /* synthetic */ Finding(String string, List list, String string2, String string3, String string4, List list2, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = NO_ID;
        }
        this(string, list, string2, string3, string4, list2, instant);
    }

    public Finding(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        List list = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sin.readStringList()");
        List list2 = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sin.readStringList()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sin.readString()");
        String string4 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sin.readString()");
        List list3 = sin.readList(DocLevelQuery.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"sin.readList((DocLevelQuery)::readFrom)");
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
        this(string, (List<String>)list, list2, string2, string3, string4, list3, instant, sin.readOptionalString());
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FINDING_ID_FIELD, (Object)this.id), TuplesKt.to((Object)RELATED_DOC_IDS_FIELD, this.relatedDocIds), TuplesKt.to((Object)CORRELATED_DOC_IDS_FIELD, this.correlatedDocIds), TuplesKt.to((Object)MONITOR_ID_FIELD, (Object)this.monitorId), TuplesKt.to((Object)MONITOR_NAME_FIELD, (Object)this.monitorName), TuplesKt.to((Object)INDEX_FIELD, (Object)this.index), TuplesKt.to((Object)QUERIES_FIELD, this.docLevelQueries), TuplesKt.to((Object)TIMESTAMP_FIELD, (Object)this.timestamp.toEpochMilli()), TuplesKt.to((Object)EXECUTION_ID_FIELD, (Object)this.executionId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Collection $this$toTypedArray$iv = this.docLevelQueries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        builder.startObject().field(FINDING_ID_FIELD, this.id).field(RELATED_DOC_IDS_FIELD, (Iterable)this.relatedDocIds).field(CORRELATED_DOC_IDS_FIELD, (Iterable)this.correlatedDocIds).field(MONITOR_ID_FIELD, this.monitorId).field(MONITOR_NAME_FIELD, this.monitorName).field(INDEX_FIELD, this.index).field(QUERIES_FIELD, (Object)thisCollection$iv.toArray(new DocLevelQuery[0])).field(TIMESTAMP_FIELD, this.timestamp.toEpochMilli()).field(EXECUTION_ID_FIELD, this.executionId);
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeStringCollection((Collection)this.relatedDocIds);
        out.writeStringCollection((Collection)this.correlatedDocIds);
        out.writeString(this.monitorId);
        out.writeString(this.monitorName);
        out.writeString(this.index);
        out.writeCollection((Collection)this.docLevelQueries);
        out.writeInstant(this.timestamp);
        out.writeOptionalString(this.executionId);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Finding parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final Finding readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/commons/alerting/model/Finding$Companion;", "", "()V", "CORRELATED_DOC_IDS_FIELD", "", "EXECUTION_ID_FIELD", "FINDING_ID_FIELD", "INDEX_FIELD", "MONITOR_ID_FIELD", "MONITOR_NAME_FIELD", "NO_ID", "QUERIES_FIELD", "RELATED_DOC_IDS_FIELD", "TIMESTAMP_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/Finding;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Finding parse(@NotNull XContentParser xcp) throws IOException {
            Instant instant;
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String id = Finding.NO_ID;
            List relatedDocIds = new ArrayList();
            List correlatedDocIds = new ArrayList();
            String monitorId = null;
            String monitorName = null;
            String index = null;
            List queries = new ArrayList();
            Instant timestamp = null;
            String executionId = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string3 = fieldName;
                if (string3 == null) continue;
                int n = -1;
                switch (string3.hashCode()) {
                    case -1217171550: {
                        if (string3.equals(Finding.EXECUTION_ID_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 1852079648: {
                        if (string3.equals(Finding.MONITOR_ID_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case -676243241: {
                        if (string3.equals(Finding.CORRELATED_DOC_IDS_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1722472221: {
                        if (string3.equals(Finding.RELATED_DOC_IDS_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 100346066: {
                        if (string3.equals(Finding.INDEX_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 3355: {
                        if (string3.equals(Finding.FINDING_ID_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case 655087462: {
                        if (string3.equals(Finding.QUERIES_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case 1732230736: {
                        if (string3.equals(Finding.MONITOR_NAME_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                    case 55126294: {
                        if (string3.equals(Finding.TIMESTAMP_FIELD)) {
                            n = 9;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        break;
                    }
                    case 4: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            String string4 = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"xcp.text()");
                            relatedDocIds.add(string4);
                        }
                        break;
                    }
                    case 3: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            String string5 = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"xcp.text()");
                            correlatedDocIds.add(string5);
                        }
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        break;
                    }
                    case 8: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        break;
                    }
                    case 5: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        break;
                    }
                    case 7: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            queries.add(DocLevelQuery.Companion.parse(xcp));
                        }
                        break;
                    }
                    case 9: {
                        if (IndexUtilsKt.instant(xcp) == null) {
                            String string6 = "Required value was null.";
                            throw new IllegalArgumentException(string6.toString());
                        }
                        break;
                    }
                    case 1: {
                        executionId = xcp.textOrNull();
                    }
                }
            }
            String string7 = monitorId;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"monitorId");
                string7 = null;
            }
            if ((string2 = monitorName) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"monitorName");
                string2 = null;
            }
            if ((string = index) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)Finding.INDEX_FIELD);
                string = null;
            }
            if ((instant = timestamp) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)Finding.TIMESTAMP_FIELD);
                instant = null;
            }
            return new Finding(id, (List<String>)relatedDocIds, correlatedDocIds, string7, string2, string, queries, instant, executionId);
        }

        @JvmStatic
        @NotNull
        public final Finding readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Finding(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

