/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.fasterxml.jackson.databind.JavaType;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.common.Strings;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.MigrationException;
import org.opensearch.security.securityconf.impl.AllowlistingSettings;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.Meta;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.WhitelistingSettings;
import org.opensearch.security.securityconf.impl.v6.ActionGroupsV6;
import org.opensearch.security.securityconf.impl.v6.ConfigV6;
import org.opensearch.security.securityconf.impl.v6.InternalUserV6;
import org.opensearch.security.securityconf.impl.v6.RoleMappingsV6;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;

public class Migration {
    public static Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> migrateRoles(SecurityDynamicConfiguration<RoleV6> r6cs, SecurityDynamicConfiguration<RoleMappingsV6> rms6) throws MigrationException {
        String roleName;
        SecurityDynamicConfiguration<RoleV7> r7 = SecurityDynamicConfiguration.empty(CType.ROLES);
        r7.set_meta(new Meta());
        r7.get_meta().setConfig_version(2);
        r7.get_meta().setType("roles");
        for (Map.Entry<String, RoleV6> entry : r6cs.getCEntries().entrySet()) {
            roleName = entry.getKey();
            RoleV6 r6 = entry.getValue();
            if (r6 == null) {
                RoleV7 noPermRole = new RoleV7();
                noPermRole.setDescription("Migrated from v6, was empty");
                r7.putCEntry(roleName, noPermRole);
                continue;
            }
            r7.putCEntry(roleName, new RoleV7(r6));
        }
        if (rms6 != null) {
            for (Map.Entry<String, Hideable> entry : rms6.getCEntries().entrySet()) {
                roleName = entry.getKey();
                if (r7.exists(roleName)) continue;
                RoleV7 noPermRole = new RoleV7();
                noPermRole.setDescription("Migrated from v6, was in rolemappings but no role existed");
                r7.putCEntry(roleName, noPermRole);
            }
        }
        return new Tuple(r7, Migration.createTenants(r6cs));
    }

    public static SecurityDynamicConfiguration<TenantV7> createTenants(SecurityDynamicConfiguration<RoleV6> r6cs) {
        HashSet<String> dedupTenants = new HashSet<String>();
        for (Map.Entry<String, RoleV6> entry : r6cs.getCEntries().entrySet()) {
            for (Map.Entry<String, String> tenant : entry.getValue().getTenants().entrySet()) {
                dedupTenants.add(tenant.getKey());
            }
        }
        SecurityDynamicConfiguration<TenantV7> tenantConfig = SecurityDynamicConfiguration.empty(CType.TENANTS, 2);
        tenantConfig.set_meta(new Meta());
        tenantConfig.get_meta().setConfig_version(2);
        tenantConfig.get_meta().setType("tenants");
        for (String tenantName : dedupTenants) {
            TenantV7 entry = new TenantV7();
            entry.setDescription("Migrated from v6");
            tenantConfig.putCEntry(tenantName, entry);
        }
        return tenantConfig;
    }

    public static SecurityDynamicConfiguration<ConfigV7> migrateConfig(SecurityDynamicConfiguration<ConfigV6> r6cs) throws MigrationException {
        SecurityDynamicConfiguration<ConfigV7> c7 = SecurityDynamicConfiguration.empty(CType.CONFIG);
        c7.set_meta(new Meta());
        c7.get_meta().setConfig_version(2);
        c7.get_meta().setType("config");
        if (r6cs.getCEntries().size() != 1) {
            throw new MigrationException("Unable to migrate config because expected size was 1 but actual size is " + r6cs.getCEntries().size());
        }
        if (r6cs.getCEntries().get("opendistro_security") == null) {
            throw new MigrationException("Unable to migrate config because 'opendistro_security' key not found");
        }
        for (Map.Entry<String, ConfigV6> r6c : r6cs.getCEntries().entrySet()) {
            c7.putCEntry("config", new ConfigV7(r6c.getValue()));
        }
        return c7;
    }

    public static SecurityDynamicConfiguration<NodesDn> migrateNodesDn(SecurityDynamicConfiguration<NodesDn> nodesDn) {
        SecurityDynamicConfiguration<NodesDn> migrated = SecurityDynamicConfiguration.empty(CType.NODESDN);
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("nodesdn");
        for (Map.Entry<String, NodesDn> entry : nodesDn.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), new NodesDn(entry.getValue()));
        }
        return migrated;
    }

    public static SecurityDynamicConfiguration<WhitelistingSettings> migrateWhitelistingSetting(SecurityDynamicConfiguration<WhitelistingSettings> whitelistingSetting) {
        SecurityDynamicConfiguration<WhitelistingSettings> migrated = SecurityDynamicConfiguration.empty(CType.WHITELIST);
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("whitelist");
        for (Map.Entry<String, WhitelistingSettings> entry : whitelistingSetting.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), new WhitelistingSettings(entry.getValue()));
        }
        return migrated;
    }

    public static SecurityDynamicConfiguration<AllowlistingSettings> migrateAllowlistingSetting(SecurityDynamicConfiguration<AllowlistingSettings> allowlistingSetting) {
        SecurityDynamicConfiguration<AllowlistingSettings> migrated = SecurityDynamicConfiguration.empty(CType.ALLOWLIST);
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("whitelist");
        for (Map.Entry<String, AllowlistingSettings> entry : allowlistingSetting.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), new AllowlistingSettings(entry.getValue()));
        }
        return migrated;
    }

    public static SecurityDynamicConfiguration<InternalUserV7> migrateInternalUsers(SecurityDynamicConfiguration<InternalUserV6> r6is) throws MigrationException {
        SecurityDynamicConfiguration<InternalUserV7> i7 = SecurityDynamicConfiguration.empty(CType.INTERNALUSERS);
        i7.set_meta(new Meta());
        i7.get_meta().setConfig_version(2);
        i7.get_meta().setType("internalusers");
        for (Map.Entry<String, InternalUserV6> r6i : r6is.getCEntries().entrySet()) {
            String username = !Strings.isNullOrEmpty((String)r6i.getValue().getUsername()) ? r6i.getValue().getUsername() : r6i.getKey();
            i7.putCEntry(username, new InternalUserV7(r6i.getValue()));
        }
        return i7;
    }

    public static SecurityDynamicConfiguration<ActionGroupsV7> migrateActionGroups(SecurityDynamicConfiguration<?> r6as) throws MigrationException {
        SecurityDynamicConfiguration<ActionGroupsV7> a7 = SecurityDynamicConfiguration.empty(CType.ACTIONGROUPS);
        a7.set_meta(new Meta());
        a7.get_meta().setConfig_version(2);
        a7.get_meta().setType("actiongroups");
        for (Map.Entry<String, ?> r6a : r6as.getCEntries().entrySet()) {
            if (r6a.getValue() instanceof List) {
                a7.putCEntry(r6a.getKey(), new ActionGroupsV7(r6a.getKey(), (List)r6a.getValue()));
                continue;
            }
            a7.putCEntry(r6a.getKey(), new ActionGroupsV7(r6a.getKey(), (ActionGroupsV6)r6a.getValue()));
        }
        return a7;
    }

    public static SecurityDynamicConfiguration<RoleMappingsV7> migrateRoleMappings(SecurityDynamicConfiguration<RoleMappingsV6> r6rms) throws MigrationException {
        SecurityDynamicConfiguration<RoleMappingsV7> rms7 = SecurityDynamicConfiguration.empty(CType.ROLESMAPPING);
        rms7.set_meta(new Meta());
        rms7.get_meta().setConfig_version(2);
        rms7.get_meta().setType("rolesmapping");
        for (Map.Entry<String, RoleMappingsV6> r6m : r6rms.getCEntries().entrySet()) {
            rms7.putCEntry(r6m.getKey(), new RoleMappingsV7(r6m.getValue()));
        }
        return rms7;
    }

    public static SecurityDynamicConfiguration<AuditConfig> migrateAudit(SecurityDynamicConfiguration<AuditConfig> audit) {
        SecurityDynamicConfiguration<AuditConfig> migrated = SecurityDynamicConfiguration.empty(CType.AUDIT);
        migrated.set_meta(new Meta());
        migrated.get_meta().setConfig_version(2);
        migrated.get_meta().setType("audit");
        for (Map.Entry<String, AuditConfig> entry : audit.getCEntries().entrySet()) {
            migrated.putCEntry(entry.getKey(), entry.getValue());
        }
        return migrated;
    }

    public static <T> SecurityDynamicConfiguration<T> readYaml(File file, Class<T> type) throws IOException {
        if (!file.exists()) {
            return SecurityDynamicConfiguration.empty(null);
        }
        JavaType javaType = DefaultObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{type});
        return (SecurityDynamicConfiguration)DefaultObjectMapper.YAML_MAPPER.readValue(file, javaType);
    }
}

