/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import com.plantuml.api.cheerpj.WasmLog;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.file.AParentFolderRegular;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.Preprocessor;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.CharsetUtils;
import net.sourceforge.plantuml.utils.StartUtils;

public final class BlockUmlBuilder
implements DefinitionsContainer {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<FileWithSuffix> usedFiles = new HashSet<FileWithSuffix>();
    private final ImportedFiles importedFiles;
    private final Charset charset;

    @Deprecated
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader readerInit, SFile newCurrentDir, String desc) throws IOException {
        this(config, CharsetUtils.charsetOrDefault(charset), defines, readerInit, newCurrentDir, desc);
    }

    @Deprecated
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader) throws IOException {
        this(config, charset, defines, reader, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> config, Charset charset, Defines defines, Reader readerInit, SFile newCurrentDir, String desc) throws IOException {
        this.charset = Objects.requireNonNull(charset);
        UncommentReadLine reader = new UncommentReadLine(ReadLineReader.create(readerInit, desc));
        this.importedFiles = ImportedFiles.createImportedFiles(new AParentFolderRegular(newCurrentDir));
        try (Preprocessor includer = new Preprocessor(config, reader);){
            StringLocated s2 = null;
            ArrayList<StringLocated> current = null;
            boolean paused = false;
            while ((s2 = includer.readLine()) != null) {
                StringLocated append;
                if (StartUtils.isArobaseStartDiagram(s2.getString())) {
                    current = new ArrayList<StringLocated>();
                    paused = false;
                }
                if (StartUtils.isArobasePauseDiagram(s2.getString())) {
                    paused = true;
                    reader.setPaused(true);
                }
                if (StartUtils.isExit(s2.getString())) {
                    paused = true;
                    reader.setPaused(true);
                }
                if (current != null && !paused) {
                    current.add(s2);
                } else if (paused && (append = StartUtils.getPossibleAppend(s2)) != null) {
                    current.add(append);
                }
                if (StartUtils.isArobaseUnpauseDiagram(s2.getString())) {
                    paused = false;
                    reader.setPaused(false);
                }
                if (!StartUtils.isArobaseEndDiagram(s2.getString()) || current == null) continue;
                if (paused) {
                    current.add(s2);
                }
                WasmLog.log("...text loaded...");
                BlockUml uml = new BlockUml(current, defines.cloneMe(), null, this, charset);
                this.usedFiles.addAll(uml.getIncluded());
                this.blocks.add(uml);
                current = null;
                reader.setPaused(false);
            }
        }
        finally {
            readerInit.close();
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }

    @Override
    public List<String> getDefinition(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            return block.getDefinition(false);
        }
        return Collections.emptyList();
    }

    @Override
    public final ImportedFiles getImportedFiles() {
        return this.importedFiles;
    }

    @Override
    @Deprecated
    public final String getCharset() {
        return this.charset.name();
    }
}

