/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.atmp.InnerStrategy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.cucadiagram.BodyEnhancedAbstract;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.legacy.CreoleParser;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.TextBlockVertical2;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.url.Url;

public class BodyEnhanced1
extends BodyEnhancedAbstract
implements TextBlock,
WithPorts {
    private final Display rawBody2;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final List<Url> urls = new ArrayList<Url>();
    private final Entity entity;
    private final boolean inEllipse;
    private final Style style;

    BodyEnhanced1(HorizontalAlignment align, List<CharSequence> rawBody, ISkinParam skinParam, Entity entity, Style style) {
        super(align, style.getFontConfiguration(skinParam.getIHtmlColorSet(), entity.getColors()), style);
        this.style = style;
        this.rawBody2 = Display.create(rawBody);
        this.skinParam = skinParam;
        this.lineFirst = true;
        this.entity = entity;
        this.inEllipse = false;
    }

    BodyEnhanced1(HorizontalAlignment align, Display display, ISkinParam skinParam, Entity entity, Style style) {
        super(align, style.getFontConfiguration(skinParam.getIHtmlColorSet(), entity.getColors()), style);
        this.style = style;
        this.entity = entity;
        this.skinParam = skinParam;
        this.lineFirst = false;
        LeafType leafType = entity.getLeafType();
        boolean bl = this.inEllipse = leafType == LeafType.USECASE || leafType == LeafType.USECASE_BUSINESS;
        if (this.inEllipse && display.size() > 0 && BodyEnhanced1.isBlockSeparator(display.get(0).toString())) {
            display = display.add("");
        }
        this.rawBody2 = display;
    }

    @Override
    protected double getMarginX() {
        return 6.0;
    }

    private static boolean isTreeOrTable(String s2) {
        return Parser.isTreeStart(s2 = StringUtils.trinNoTrace(s2)) || CreoleParser.isTableLine(s2);
    }

    @Override
    protected final TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        this.urls.clear();
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock title = null;
        Display display = null;
        Iterator it = this.rawBody2.iterator();
        while (it.hasNext()) {
            CharSequence cs = (CharSequence)it.next();
            String s2 = cs.toString();
            if (BodyEnhanced1.isBlockSeparator(s2)) {
                if (display == null) {
                    display = Display.empty();
                }
                blocks.add(this.buildTextBlock(display, separator, title, stringBounder));
                separator = s2.charAt(0);
                title = this.getTitle(s2, this.skinParam);
                display = null;
                continue;
            }
            if (BodyEnhanced1.isTreeOrTable(s2)) {
                boolean isTable = CreoleParser.isTableLine(s2);
                if (display == null) {
                    display = Display.empty();
                }
                blocks.add(this.buildTextBlock(display, separator, title, stringBounder));
                separator = '\u0000';
                title = null;
                display = null;
                List<CharSequence> allTree = BodyEnhanced1.buildTreeOrTable(s2, (ListIterator<CharSequence>)it);
                FontConfiguration fontConfiguration = this.style.getFontConfiguration(this.skinParam.getIHtmlColorSet());
                TextBlock bloc = Display.create(allTree).create7(fontConfiguration, this.align, this.skinParam, CreoleMode.FULL);
                if (isTable) {
                    bloc = TextBlockUtils.withMargin(bloc, 10.0, 10.0, 0.0, 5.0);
                }
                blocks.add(bloc);
                continue;
            }
            if (display == null) {
                display = Display.empty();
            }
            display = display.add(cs);
            if (!(cs instanceof Member) || ((Member)cs).getUrl() == null) continue;
            this.urls.add(((Member)cs).getUrl());
        }
        if (display == null) {
            display = Display.empty();
        }
        if (this.inEllipse && display.size() == 0) {
            display = display.add("");
        }
        blocks.add(this.buildTextBlock(display, separator, title, stringBounder));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        double minClassWidth = this.style.value(PName.MinimumWidth).asDouble();
        if (minClassWidth > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, minClassWidth, this.align);
        }
        return this.area;
    }

    private TextBlock buildTextBlock(Display display, char separator, TextBlock title, StringBounder stringBounder) {
        TextBlock result = new MethodsOrFieldsArea(display, this.skinParam, this.align, this.entity, this.style);
        result = this.decorate(result, separator, title, stringBounder);
        return result;
    }

    private static List<CharSequence> buildTreeOrTable(String init, ListIterator<CharSequence> it) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Pattern p = Pattern.compile("^(\\s+)");
        Matcher m4 = p.matcher(init);
        String start = "";
        if (m4.find()) {
            start = m4.group(1);
        }
        result.add(BodyEnhanced1.purge(init, start));
        while (it.hasNext()) {
            String s2 = it.next().toString();
            if (BodyEnhanced1.isTreeOrTable(s2)) {
                result.add(BodyEnhanced1.purge(s2, start));
                continue;
            }
            it.previous();
            return result;
        }
        return result;
    }

    private static String purge(String s2, String start) {
        if (s2.startsWith(start)) {
            return s2.substring(start.length());
        }
        return s2;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        TextBlock area = this.getArea(stringBounder);
        if (area instanceof WithPorts) {
            return ((WithPorts)((Object)area)).getPorts(stringBounder);
        }
        return new Ports();
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.getArea(stringBounder).getInnerPosition(member, stringBounder, strategy);
    }
}

