/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.style.SName;

class USymbolNode
extends USymbol {
    USymbolNode() {
    }

    @Override
    public SName getSName() {
        return SName.node;
    }

    private void drawNode(UGraphic ug, double width, double height, double shadowing) {
        UPolygon shape = new UPolygon();
        shape.addPoint(0.0, 10.0);
        shape.addPoint(10.0, 0.0);
        shape.addPoint(width, 0.0);
        shape.addPoint(width, height - 10.0);
        shape.addPoint(width - 10.0, height);
        shape.addPoint(0.0, height);
        shape.addPoint(0.0, 10.0);
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
        ug.apply(new UTranslate(width - 10.0, 10.0)).draw(new ULine(10.0, -10.0));
        ug.apply(UTranslate.dy(10.0)).draw(ULine.hline(width - 10.0));
        ug.apply(new UTranslate(width - 10.0, 10.0)).draw(ULine.vline(height - 10.0));
        ug.apply(new UTranslate(0.0, height)).draw(new UEmpty(10.0, 10.0));
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                this.this$0.drawNode(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                USymbol.Margin margin = this.this$0.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                MyUGraphicNode ug2 = this.this$0.new MyUGraphicNode(ug, dim.getWidth());
                tb.drawU(ug2.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return this.this$0.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                this.this$0.drawNode(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                ug = ug.apply(new UTranslate(-4.0, 11.0));
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereoY = 2.0;
                double posStereoX = stereoAlignment == HorizontalAlignment.RIGHT ? width - dimStereo.getWidth() - this.this$0.getMargin().getX1() : (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, 2.0)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }

    @Override
    public int suppHeightBecauseOfShape() {
        return 5;
    }

    @Override
    public int suppWidthBecauseOfShape() {
        return 60;
    }

    class MyUGraphicNode
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicNode(ug, this.endingX);
        }

        public MyUGraphicNode(UGraphic ug, double endingX) {
            super(ug);
            this.endingX = endingX;
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            ug = ug.apply(translate);
            this.drawHlineInternal(ug, line);
            if (line.isDouble()) {
                this.drawHlineInternal(ug.apply(UTranslate.dy(2.0)), line);
            }
            line.drawTitleInternal(ug, 0.0, this.endingX - 10.0, 0.0, true);
        }

        private void drawHlineInternal(UGraphic ug, UHorizontalLine line) {
            ug = ug.apply(line.getStroke()).apply(HColors.none().bg());
            ug.draw(ULine.hline(this.endingX - 10.0));
            ug.apply(UTranslate.dx(this.endingX - 10.0)).draw(new ULine(10.0, -10.0));
        }
    }
}

