/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.version.VersionMatcher;

class CollectionOfModulesToSort {
    private final List moduleDescriptors;
    private final VersionMatcher versionMatcher;
    private final Map modulesByModuleId;
    private final NonMatchingVersionReporter nonMatchingVersionReporter;

    public CollectionOfModulesToSort(Collection object, VersionMatcher object2, NonMatchingVersionReporter object3) {
        this.versionMatcher = object2;
        this.nonMatchingVersionReporter = object3;
        this.modulesByModuleId = new HashMap();
        this.moduleDescriptors = new ArrayList(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (ModuleDescriptor)object.next();
            object3 = new ModuleInSort((ModuleDescriptor)object2);
            this.moduleDescriptors.add(object3);
            this.addToModulesByModuleId((ModuleDescriptor)object2, (ModuleInSort)object3);
        }
    }

    private void addToModulesByModuleId(ModuleDescriptor object, ModuleInSort moduleInSort) {
        object = object.getModuleRevisionId().getModuleId();
        LinkedList<ModuleInSort> linkedList = new LinkedList<ModuleInSort>();
        linkedList.add(moduleInSort);
        object = this.modulesByModuleId.put(object, linkedList);
        if (object != null) {
            linkedList.addAll((Collection<ModuleInSort>)object);
        }
    }

    public Iterator iterator() {
        return this.moduleDescriptors.iterator();
    }

    public int size() {
        return this.moduleDescriptors.size();
    }

    public ModuleInSort getModuleDescriptorDependency(DependencyDescriptor dependencyDescriptor) {
        Object object = (Collection)this.modulesByModuleId.get(dependencyDescriptor.getDependencyId());
        if (object == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ModuleInSort moduleInSort = (ModuleInSort)object.next();
            if (moduleInSort.match(dependencyDescriptor, this.versionMatcher)) {
                return moduleInSort;
            }
            this.nonMatchingVersionReporter.reportNonMatchingVersion(dependencyDescriptor, moduleInSort.getSortedModuleDescriptor());
        }
        return null;
    }
}

