/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.FontPanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.PageLayoutPanel;
import org.freehep.graphicsio.exportchooser.PageMarginPanel;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PDFExportFileType
extends AbstractExportFileType {
    private static final String[] versionList = new String[]{"Acrobat Reader 4.x", "Acrobat Reader 5.x"};

    @Override
    public String getDescription() {
        return "Portable Document Format";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"pdf"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[]{"application/pdf"};
    }

    @Override
    public boolean isMultipageCapable() {
        return true;
    }

    @Override
    public boolean hasOptionPanel() {
        return true;
    }

    @Override
    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, PDFGraphics2D.getDefaultProperties());
        OptionPanel format = new OptionPanel("Format");
        OptionComboBox version = new OptionComboBox(options, PDFGraphics2D.VERSION, versionList);
        format.add("0 * [5 15 5 15] r", new JLabel("PDF Version"));
        format.add("1 * [5 15 5 15] lw", version);
        format.add("0 * * 1 [5 15 5 15] w", new OptionCheckBox(options, PDFGraphics2D.COMPRESS, "Compress"));
        OptionPanel preview = new OptionPanel("Preview");
        OptionCheckBox thumbnails = new OptionCheckBox(options, PDFGraphics2D.THUMBNAILS, "Include Thumbnail");
        thumbnails.setToolTipText("Thumbnails are automatically generated by Acrobat Reader 5");
        preview.add("0 * * 1 [5 15 5 15] w", thumbnails);
        version.selects("Acrobat Reader 4.x", thumbnails);
        String rootKey = PDFGraphics2D.class.getName();
        String abstractRootKey = AbstractVectorGraphicsIO.class.getName();
        InfoPanel infoPanel = new InfoPanel(options, rootKey, new String[]{"Author", "Title", "Subject", "Keywords"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", new PageLayoutPanel(options, rootKey));
        leftPanel.add("0 * wt", new PageMarginPanel(options, rootKey));
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", format);
        rightPanel.add("0 * wt", preview);
        rightPanel.add("0 * wt", new BackgroundPanel(options, rootKey, true));
        rightPanel.add("0 * wt", new ImageTypePanel(options, rootKey, new String[]{"Smallest Size", "ZLIB", "JPG"}));
        rightPanel.add("0 * wt", new FontPanel(options, rootKey, abstractRootKey));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", leftPanel);
        optionsPanel.add("1 0 [5 5 5 5] wt", rightPanel);
        optionsPanel.add("0 1 2 1 [5 5 5 5] wt", infoPanel);
        optionsPanel.add("0 * wh", new JLabel());
        return optionsPanel;
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new PDFGraphics2D(os, target);
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new PDFGraphics2D(os, dimension);
    }
}

